CATEGORIES = [
    ('Arts & Entertainment', [
        'Books & Literature',
        'Celebrity Fan/Gossip',
        'Fine Art',
        'Humor',
        'Movies',
        'Music',
        'Television'
    ]),
    ('Automotive', [
        'Auto Parts',
        'Auto Repair',
        'Buying/Selling Cars',
        'Car Culture',
        'Certified Pre-Owned',
        'Convertible',
        'Coupe',
        'Crossover',
        'Diesel',
        'Electric Vehicle',
        'Hatchback',
        'Hybrid',
        'Luxury',
        'MiniVan',
        'Mororcycles',
        'Off-Road Vehicles',
        'Performance Vehicles',
        'Pickup',
        'Road-Side Assistance',
        'Sedan',
        'Trucks & Accessories',
        'Vintage Cars',
        'Wagon',
    ]),
    ('Business', [
        'Advertising',
        'Agriculture',
        'Biotech/Biomedical',
        'Business Software',
        'Construction',
        'Forestry',
        'Government',
        'Green Solutions',
        'Human Resources',
        'Logistics',
        'Marketing',
        'Metals',
    ]
    ),
    ('Careers', [
        'Career Planning',
        'College',
        'Financial Aid',
        'Job Fairs',
        'Job Search',
        'Resume Writing/Advice',
        'Nursing',
        'Scholarships',
        'Telecommuting',
        'U.S. Military',
        'Career Advice',
    ]),
    ('Education', [
        '7-12 Education',
        'Adult Education',
        'Art History',
        'Colledge Administration',
        'College Life',
        'Distance Learning',
        'English as a 2nd Language',
        'Language Learning',
        'Graduate School',
        'Homeschooling',
        'Homework/Study Tips',
        'K-6 Educators',
        'Private School',
        'Special Education',
        'Studying Business',
    ]),
    ('Family & Parenting', [
        'Adoption',
        'Babies & Toddlers',
        'Daycare/Pre School',
        'Family Internet',
        'Parenting - K-6 Kids',
        'Parenting teens',
        'Pregnancy',
        'Special Needs Kids',
        'Eldercare',
    ]),
    ('Health & Fitness', [
        'Exercise',
        'A.D.D.',
        'AIDS/HIV',
        'Allergies',
        'Alternative Medicine',
        'Arthritis',
        'Asthma',
        'Autism/PDD',
        'Bipolar Disorder',
        'Brain Tumor',
        'Cancer',
        'Cholesterol',
        'Chronic Fatigue Syndrome',
        'Chronic Pain',
        'Cold & Flu',
        'Deafness',
        'Dental Care',
        'Depression',
        'Dermatology',
        'Diabetes',
        'Epilepsy',
        'GERD/Acid Reflux',
        'Headaches/Migraines',
        'Heart Disease',
        'Herbs for Health',
        'Holistic Healing',
        'IBS/Crohn\'s Disease',
        'Incest/Abuse Support',
        'Incontinence',
        'Infertility',
        'Men\'s Health',
        'Nutrition',
        'Orthopedics',
        'Panic/Anxiety Disorders',
        'Pediatrics',
        'Physical Therapy',
        'Psychology/Psychiatry',
        'Senor Health',
        'Sexuality',
        'Sleep Disorders',
        'Smoking Cessation',
        'Substance Abuse',
        'Thyroid Disease',
        'Weight Loss',
        'Women\'s Health',
    ]),
    ('Food & Drink', [
        'American Cuisine',
        'Barbecues & Grilling',
        'Cajun/Creole',
        'Chinese Cuisine',
        'Cocktails/Beer',
        'Coffee/Tea',
        'Cuisine-Specific',
        'Desserts & Baking',
        'Dining Out',
        'Food Allergies',
        'French Cuisine',
        'Health/Lowfat Cooking',
        'Italian Cuisine',
        'Japanese Cuisine',
        'Mexican Cuisine',
        'Vegan',
        'Vegetarian',
        'Wine',
    ]),
    ('Hobbies & Interests', [
        'Art/Technology',
        'Arts & Crafts',
        'Beadwork',
        'Birdwatching',
        'Board Games/Puzzles',
        'Candle & Soap Making',
        'Card Games',
        'Chess',
        'Cigars',
        'Collecting',
        'Comic Books',
        'Drawing/Sketching',
        'Freelance Writing',
        'Genealogy',
        'Getting Published',
        'Guitar',
        'Home Recording',
        'Investors & Patents',
        'Jewelry Making',
        'Magic & Illusion',
        'Needlework',
        'Painting',
        'Photography',
        'Radio',
        'Roleplaying Games',
        'Sci-Fi & Fantasy',
        'Scrapbooking',
        'Screenwriting',
        'Stamps & Coins',
        'Video & Computer Games',
        'Woodworking',
    ]),
    ('Home & Garden', [
        'Appliances',
        'Entertaining',
        'Environmental Safety',
        'Gardening',
        'Home Repair',
        'Home Theater',
        'Interior Decorating',
        'Landscaping',
        'Remodeling & Construction',
    ]),
    ('Law, Gov\'t & Politics', [
        'Immigration',
        'Legal Issues',
        'U.S. Government Resources',
        'Politics',
        'Commentary',
    ]),
    ('News', [
        'International News',
        'National News',
        'Local News',
    ]),
    ('Personal Finance', [
        'Beginning Investing',
        'Credit/Debt & Loans',
        'Financial News',
        'Financial Planning',
        'Hedge Fund',
        'Insurance',
        'Investing',
        'Mutual Funds',
        'Options',
        'Retirement Planning',
        'Stocks',
        'Tax Planning',
    ]),
    ('Society', [
        'Dating',
        'Divorce Support',
        'Gay Life',
        'Marriage',
        'Senior Living',
        'Teens',
        'Weddings',
        'Ethnic Specific',
    ]),
    ('Science', [
        'Astrology',
        'Biology',
        'Chemistry',
        'Geology',
        'Paranormal Phenomena',
        'Physics',
        'Space/Astronomy',
        'Geography',
        'Botany',
        'Weather',
    ]),
    ('Pets', [
        'Aquariums',
        'Birds',
        'Cats',
        'Dogs',
        'Large Animals',
        'Reptiles',
        'Veterinary Medicine',
    ]),
    ('Sports', [
        'Auto Racing',
        'Baseball',
        'Bicycling',
        'Bodybuilding',
        'Boxing',
        'Canoeing/Kayaking',
        'Cheerleading',
        'Climbing',
        'Cricket',
        'Figure Skating',
        'Fly Fishing',
        'Football',
        'Freshwater Fishing',
        'Game & Fish',
        'Golf',
        'Horse Racing',
        'Horses',
        'Hunting/Shooting',
        'Inline Skating',
        'Martial Arts',
        'Mountain Biking',
        'NASCAR Racing',
        'Olympics',
        'Paintball',
        'Power & Motorcycles',
        'Pro Basketball',
        'Pro Ice Hockey',
        'Rodeo',
        'Rugby',
        'Running/Jogging',
        'Sailing',
        'Saltwater Fishing',
        'Scuba Diving',
        'Skateboarding',
        'Skiing',
        'Snowboarding',
        'Surfing/Bodyboarding',
        'Swimming',
        'Table Tennis/Ping-Pong',
        'Tennis',
        'Volleyball',
        'Walking',
        'Waterski/Wakeboard',
        'World Soccer',
    ]),
    ('Style & Fashion', [
        'Beauty',
        'Body Art',
        'Fashion',
        'Jewelry',
        'Clothing',
        'Accessories',
    ]),
    ('Technology & Computing', [
        '3-D Graphics',
        'Animation',
        'Antivirus Software',
        'C/C++',
        'Cameras & Camcorders',
        'Cell Phones',
        'Computer Certification',
        'Computer Networking',
        'Computer Peripherals',
        'Computer Reviews',
        'Data Centers',
        'Databases',
        'Desktop Publishing',
        'Desktop Video',
        'Email',
        'Graphics Software',
        'Home Video/DVD',
        'Internet Technology',
        'Java',
        'JavaScript',
        'Mac Support',
        'MP3/MIDI',
        'Net Conferencing',
        'Net for Beginners',
        'Network Security',
        'Palmtops/PDAs',
        'PC Support',
        'Portable',
        'Entertainment',
        'Shareware/Freeware',
        'Unix',
        'Visual Basic',
        'Web Clip Art',
        'Web Design/HTML',
        'Web Search',
        'Windows',
    ]),
    ('Travel', [
        'Adventure Travel',
        'Africa',
        'Air Travel',
        'Australia & New Zealand',
        'Bed & Breakfasts',
        'Budget Travel',
        'Business Travel',
        'By US Locale',
        'Camping',
        'Canada',
        'Caribbean',
        'Cruises',
        'Eastern Europe',
        'Europe',
        'France',
        'Greece',
        'Honeymoons/Getaways',
        'Hotels',
        'Italy',
        'Japan',
        'Mexico & Central America',
        'National Parks',
        'South America',
        'Spas',
        'Theme Parks',
        'Traveling with Kids',
        'United Kingdom',
    ]),
    ('Real Estate', [
        'Apartments',
        'Architects',
        'Buying/Selling Homes',
    ]),
    ('Shopping', [
        'Contests & Freebies',
        'Couponing',
        'Comparison',
        'Engines',
    ]),
    ('Religion & Spirituality', [
        'Alternative Religions',
        'Atheism/Agnosticism',
        'Buddhism',
        'Catholicism',
        'Christianity',
        'Hinduism',
        'Islam',
        'Judaism',
        'Latter-Day Saints',
        'Pagan/Wiccan',
    ]),
    ('Uncategorized', []),
    ('Non-Standard Content', [
        'Unmoderated UGC',
        'Extreme Graphic/Explicit Violence',
        'Pornography',
        'Profane Content',
        'Hate Content',
        'Under Construction',
        'Incentivized',
    ]),
    ('Illegal Content', [
        'Illegal Content',
        'Warez',
        'Spyware/Malware',
        'Copyright Infringement',
    ])
]


def from_string(s):
    try:
        if s.startswith('IAB'):
            s = s[3:]

        if '-' in s:
            tier1, tier2 = map(int, s.split('-'))
            t1c = CATEGORIES[tier1 - 1][0]
            t2c = CATEGORIES[tier1 - 1][1][tier2 - 1]
            return '{}: {}'.format(t1c, t2c)
        else:
            return CATEGORIES[int(s) - 1][0]
    except ValueError:
        return s