import sys
import time
from datetime import datetime, timedelta
import logging
from opsaws.awsargparse import AwsArgParser
from opsaws.rds.snapshot import RDSSnapshot

logger = logging.getLogger(__name__)


def add_backup_argument_group(parser):
    group = parser.add_argument_group('backup options')
    group.add_argument('--retention', default='7:4:1',
                       help="days:weeks:months worth of backups to keep")
    group.add_argument('--time-limit', type=int, default=3600)
    group.add_argument('--manually', action='store_true', help='backup manually', default=False)
    group.add_argument('--check-date', default=datetime.utcnow()-timedelta(days=1))


def parse_options():
    parser = AwsArgParser()
    add_backup_argument_group(parser)
    parser.add_argument('-d', '--debug', action='store_true', help='Turn on debug info',
                        default=False)

    options = parser.parse_args()

    if options.debug:
        logging.basicConfig(level=logging.DEBUG, format='%(asctime)s %(levelname)s %(message)s')
    else:
        logging.basicConfig(level=logging.INFO, format='%(asctime)s %(levelname)s %(message)s')

    logging.debug(options)

    return options


def validate_snapshots(snapshots, state='available'):
    for snapshot in snapshots:
        if snapshot['State'] != state:
            return False
    return True


def main():
    options = parse_options()

    # setup ebs_backup AWS connection information
    rds_backup = RDSSnapshot(options.conf_file, options.profile, options.region)

    # create all snapshot
    if options.manually:
        # TODO
        pass

    # delete old retention
    if options.retention:
        rds_backup.rotate_snapshot(options.retention)

    # check if all snapshot ready
    if options.manually:
        # TODO
        pass
    else:
        dbs = rds_backup.describe_db_instance()
        not_ready_msg = ''
        for db in dbs:
            if not len(rds_backup.describe_db_snapshots_by_date(
                    db_instance_identifier=db['DBInstanceIdentifier'], date=options.check_date)):
                not_ready_msg += ' {0} '.format(db['DBInstanceIdentifier'])
        if not not_ready_msg:
            msg = 'OK: All snapshot created'
            logger.info(msg)
            print msg
            return 0
        else:
            msg = 'WARNING: Some snapshot is not ready. ' + not_ready_msg
            logger.info(msg)
            print >> sys.stderr, msg
            return 1


if __name__ == "__main__":
    sys.exit(main())