import json
import logging

from grandfatherson import to_delete, MONDAY
from dateutil.parser import parse
from datetime import date, datetime

from opsaws.rds import RDSCli
from opsaws.awscli import AwsCli

logger = logging.getLogger(__name__)


class RDSSnapshot(RDSCli):

    def rotate_snapshot(self, retention):

        # parse the retention rule
        days, weeks, months = map(int, retention.split(':'))

        # get all snapshot and delete old backup
        snapshots = self.describe_db_snapshots()
        for snapshot in snapshots:
            if snapshot['Status'] != 'available':
                continue
            t1 = parse(snapshot['SnapshotCreateTime'])
            backups = [datetime(t1.year, t1.month, t1.day)]
            if to_delete(backups, days=days, weeks=weeks, months=months, firstweekday=MONDAY):
                self.delete_db_snapshot(snapshot['DBSnapshotIdentifier'])

    def describe_db_snapshots_by_date(self, db_instance_identifier=None, date=datetime.utcnow()):
        snapshots = self.describe_db_snapshots(db_instance_identifier=db_instance_identifier)
        result = list()
        for snapshot in snapshots:
            t1 = parse(snapshot['SnapshotCreateTime'])
            if [t1.year, t1.month, t1.day] == [date.year, date.month, date.day]:
                result.append(snapshot)
        return result


