import json
import logging
from opsaws.awscli import AwsCli

logger = logging.getLogger(__name__)


class R53Cli(AwsCli):

    def list_hosted_zones(self):
        logger.info('list hosted zones')
        command = 'aws route53 list-hosted-zones'
        return self.run(command)['HostedZones']

    def list_resource_record_sets(self, hosted_zone_id):
        logger.info('list record sets in zones {0}'.format(hosted_zone_id))
        command = 'aws route53 list-resource-record-sets'
        command += ' --hosted-zone-id '+hosted_zone_id
        return self.run(command)['ResourceRecordSets']

    def get_hosted_zone(self, hosted_zone_id):
        logger.info('get zones {0} detail'.format(hosted_zone_id))
        command = 'aws route53 get-hosted-zone'
        command += ' --id '+hosted_zone_id
        return self.run(command)

    def dump(self, fp):
        zones = self.list_hosted_zones()
        print >> fp, "*" * 60
        json.dump(zones, fp=fp, indent=4, sort_keys=True)
        print >> fp, '\n'

        for zone in zones:
            detail = self.get_hosted_zone(zone['Id'])
            print >> fp, "*" * 60
            json.dump(detail, fp=fp, indent=4, sort_keys=True)
            print >> fp, '\n'

            records = self.list_resource_record_sets(zone['Id'])
            print >> fp, "*" * 60
            json.dump(records, fp=fp, indent=4, sort_keys=True)
            print >> fp, '\n'

