import json
import logging

from grandfatherson import dates_to_delete, MONDAY
from dateutil.parser import parse
from datetime import date, datetime

from opsaws.rds import RDSCli
from opsaws.awscli import AwsCli

logger = logging.getLogger(__name__)


class RDSSnapshot(RDSCli):

    def rotate_snapshot(self, retention):

        # parse the retention rule
        days, weeks, months = map(int, retention.split(':'))

        # get all snapshot and delete old backup
        snapshots = self.describe_db_snapshots()

        # get all snapshot date and calculate the delete set
        all_dt = [parse(snapshot['SnapshotCreateTime']).date() for snapshot in snapshots]
        delete_set = dates_to_delete(all_dt, days=days, weeks=weeks, months=months, firstweekday=MONDAY)

        # delete the snapshot if it is in the delete set
        for snapshot in snapshots:
            if snapshot['Status'] != 'available':
                continue
            if parse(snapshot['SnapshotCreateTime']).date() in delete_set:
                self.delete_db_snapshot(snapshot['DBSnapshotIdentifier'])

    def describe_db_snapshots_by_date(self, db_instance_identifier=None, dt=date.today()):
        snapshots = self.describe_db_snapshots(db_instance_identifier=db_instance_identifier)
        result = list()
        for snapshot in snapshots:
            if parse(snapshot['SnapshotCreateTime']).date() == dt:
                result.append(snapshot)
        return result


