import sys
import time
import logging
from opsaws.awsargparse import AwsArgParser
from opsaws.ec2.snapshot import EBSSnapshot
from opsaws.route53 import R53Cli

logger = logging.getLogger(__name__)


def add_dump_argument_group(parser):
    group = parser.add_argument_group('dump options')
    group.add_argument('-f', '--file', required=True)


def parse_options():
    parser = AwsArgParser()
    add_dump_argument_group(parser)
    parser.add_argument('-d', '--debug', action='store_true', help='Turn on debug info',
                        default=False)

    options = parser.parse_args()

    if options.debug:
        logging.basicConfig(level=logging.DEBUG, format='%(asctime)s %(levelname)s %(message)s')
    else:
        logging.basicConfig(level=logging.INFO, format='%(asctime)s %(levelname)s %(message)s')

    logging.debug(options)

    return options


def main():
    options = parse_options()

    r53backup = R53Cli(options.conf_file, options.profile, options.region)

    with open(options.file, 'w') as fp:
        r53backup.dump(fp)

    print 'Backup r53 to file: {0} done!'.format(options.file)


if __name__ == "__main__":
    main()