import subprocess
import json
import logging

logger = logging.getLogger(__name__)


class AwsCli():
    def __init__(self, conf_file, profile=None, region=None):
        self.conf_file = conf_file
        self.profile = profile
        self.region = region

    def run(self, command):
        command = self._awscli_wrapper(command)
        result = json.loads(subprocess.check_output(command, shell=True))
        logger.debug('result: ' + str(result))
        return result

    def _awscli_wrapper(self, command):
        # add config file
        if self.conf_file:
            command = 'AWS_CONFIG_FILE=' + self.conf_file + ' ' + command

        # add region
        if self.region:
            command += ' --region ' + self.region

        # add profile
        if self.profile:
            command += ' --profile ' + self.profile

        return command