import subprocess
import logging
from opsaws.awsargparse import AwsArgParser
from opsaws.awscli import AwsCli

logger = logging.getLogger(__name__)


def add_backup_argument_group(parser):
    group = parser.add_argument_group('backup options')
    group.add_argument('--tenant', default=None, action="append", dest="AWS_TENANT")
    group.add_argument('--retention', default='7:4:1', dest="retention",
                       help="days:weeks:months worth of backups to keep")
    group.add_argument('--trapdest', default='localhost', dest="trapdest",
                       help="Hostname of monitoring server to send status traps to")
    group.add_argument('--dry_run', dest="dry_run", action="store_true",
                       help="Don't execute snapshot run or delete run")


def parse_options():
    parser = AwsArgParser()
    add_backup_argument_group(parser)
    parser.add_argument('-d', '--debug', action='store_true', help='Turn on debug info',
                        default=False)

    options = parser.parse_args()

    if options.debug:
        logging.basicConfig(level=logging.DEBUG, format='%(asctime)s %(levelname)s %(message)s')
    else:
        logging.basicConfig(level=logging.INFO, format='%(asctime)s %(levelname)s %(message)s')

    logging.debug(options)

    return options


def main():

    options = parse_options()

    awscli = AwsCli(options.conf_file, options.profile, options.region)

    volumes = awscli.run('aws ec2 describe-volumes')['Volumes']

    for volume in volumes:
        print volume['VolumeId']


if __name__ == "__main__":
    main()