#!/usr/bin/python -B

import boto
from boto.ec2.connection import EC2Connection 
from boto import rds
from pprint import pprint
import os, sys, getopt, socket, time
from datetime import date, datetime
from dateutil import parser
from time import mktime

# Debug
#boto.set_stream_logger('paws')

# Set date, convert to string
today = date.today()
date_today = today.isoformat()

# Required options to pass 
opts, args = getopt.getopt(sys.argv[1:], 'a:s:r:t:')
 
# Set empty default values for options.
AWS_ACCESS_KEY = ''
AWS_SECRET_KEY = ''
AWS_REGION =  ''
AWS_TENANT = ''
 
# Options to vars 
for opt, arg in opts:
  if opt == '-a':
    AWS_ACCESS_KEY = arg
  elif opt == '-s':
    AWS_SECRET_KEY = arg
  elif opt == '-r':
    AWS_REGION = arg
  elif opt == '-t':
    AWS_TENANT = arg

def iso8601_epoch(iso8601_time):

  iso8601 = str(parser.parse(iso8601_time))[:19]
  utc = datetime.strptime(iso8601, "%Y-%m-%d %H:%M:%S" )
  epoch = mktime(utc.timetuple())

  return epoch

# Establish our RDS connection
conn_rds = rds.connect_to_region(AWS_REGION, aws_access_key_id=AWS_ACCESS_KEY, aws_secret_access_key=AWS_SECRET_KEY)

# Handy function to time a loop
def avail_loop(status, wait, time_limit, host):

  get_status = eval(status)
  start_time = time.time()
  pprint(status)

  while not get_status[0].status == 'available':
    get_status = eval(status)
    run_time = time.time() - start_time
    print 'Status: {0}, Run Time: {1}'.format(get_status[0].status,run_time)
    time.sleep(wait)
   
    # If loop time limit is exceeded then exit 2 (Critical) and fire snmp trap
    if run_time > time_limit:
      print 'Waited too long, time limit: {0}s exceeded'.format(time_limit)
      os.system('/usr/bin/snmptrap -v 2c -c public localhost "" NAGIOS-NOTIFY-MIB::nSvcEvent nSvcHostname s {0} nSvcDesc s RDSBACKUP nSvcStateID i 2 nSvcOutput s "\'RDS Backup Failed.\'"'.format(host))
      sys.exit(2)
      break

  end_time = time.time()
  time_taken = end_time - start_time
  print 'Event took: {0}'.format(time_taken)

  return get_status[0].status

# Backup function
def rds_backup():

  # Fetch list of deployed RDS instances
  rds_dbs = conn_rds.get_all_dbinstances()

  # Iterate throught the list of RDS instances in our region to see what we need to snapshot
  for db in rds_dbs:

    if AWS_TENANT in db.id:

      print 'Found: {0}, checking status for snapshot'.format(db.id)

      # Use the avail_loop function to ensure our RDS instance is available before we start to take snapshots
      get_dbs = 'conn_rds.get_all_dbinstances("'+db.id+'")'
      rds_status = avail_loop(get_dbs, 3, 60, db.id)

      print 'Creating snapshot from {0}'.format(db.id)

      # Snapshot our RDS and time
      snap = conn_rds.create_dbsnapshot(db.id+'-'+date_today, db.id)

  # Fetch snapshot list
  rds_snapshots = conn_rds.get_all_dbsnapshots()

  # Iterate throught the list of snapshots
  for snapshot in rds_snapshots:

    if AWS_TENANT in snapshot.id:

      print 'Found: {0}, checking status for snapshot'.format(snapshot.id)

      # Although the RDS instance we took a snapshot of is in an available status, the snapshot may not be.
      # Check all snapshots for an available status and report any failures to monitoring
      get_snapshot = 'conn_rds.get_all_dbsnapshots("'+snapshot.id+'")'
      snapshot_status = avail_loop(get_snapshot, 3, 3600, snapshot.instance_id)

      print 'Snapshot: {0} Host: {1} Status: {2}'.format(snapshot.id, snapshot.instance_id, snapshot_status)
      os.system('/usr/bin/snmptrap -v 2c -c public localhost "" NAGIOS-NOTIFY-MIB::nSvcEvent nSvcHostname s {0} nSvcDesc s RDSBACKUP nSvcStateID i 0 nSvcOutput s "\'RDS Backup Success ({1}).\'"'.format(snapshot.instance_id, snapshot.id))

      # Clean up old snapshots, 259200 will keep the past 3 days
      # Dry running this for now, will write to rdsbackup log
      print "DEBUG - Now: {0} SS_Create: {1}".format(time.time(), iso8601_epoch(snapshot.snapshot_create_time))
      if (time.time() -  iso8601_epoch(snapshot.snapshot_create_time)) > 259200:
        print 'Deleting snapshot: {0} Created: {1}'.format(snapshot.id, snapshot.snapshot_create_time)
        conn_rds.delete_dbsnapshot(snapshot.id)

  sys.exit(0)
  
rds_backup();
