#!/usr/bin/python -B

import os
import sys
import time
import getopt
import re
import boto
import socket
import optparse
import dateutil.parser as dp

from grandfatherson import to_delete, MONDAY

from boto import ec2
from boto.utils import get_instance_metadata
from boto.ec2.connection import EC2Connection 

from time import mktime
from dateutil import parser
from datetime import date, datetime, timedelta

from pprint import pprint

# Debug
#boto.set_stream_logger('paws')

# Set host for snmptraps
myhost = socket.gethostname()

# Set date, convert to string
today = date.today()
date_today = today.isoformat()

# new time/date
d = datetime.now()
now = d.strftime("%Y%m%d%H%M")

# Required options      
p = optparse.OptionParser()

p.add_option('--access_key', default=None, dest="AWS_ACCESS_KEY")
p.add_option('--secret_key', default=None, dest="AWS_SECRET_KEY")
p.add_option('--region', default=None, dest="AWS_REGION")
p.add_option('--tenant', default=None, action="append", dest="AWS_TENANT")
p.add_option('--retention', default='7:4:1', dest="retention", help="days:weeks:months worth of backups to keep")
p.add_option('--trapdest', default='localhost', dest="trapdest", help="Hostname of monitoring server to send status traps to")
p.add_option('--dry_run', dest="dry_run", action="store_true", help="Don't execute snapshot run or delete run")

options, arguments = p.parse_args()

if (options.AWS_ACCESS_KEY == None):
       p.error("--access_key is required")
if (options.AWS_SECRET_KEY == None):
       p.error("--secret_key is required")
if (options.AWS_REGION == None):
       p.error("--region is required")
if (options.AWS_TENANT == None):
       p.error("--tenant is required - consumerops,midvale")

def iso8601_epoch(iso8601_time):

  iso8601 = str(parser.parse(iso8601_time))[:19]
  utc = datetime.strptime(iso8601, "%Y-%m-%d %H:%M:%S" )
  epoch = mktime(utc.timetuple())

  return epoch

# Establish our EC2 connection
conn_ec2 = ec2.connect_to_region(options.AWS_REGION, aws_access_key_id=options.AWS_ACCESS_KEY, aws_secret_access_key=options.AWS_SECRET_KEY)

# Handy function to time a loop
def avail_loop(status, wait, time_limit, host):

  get_status = eval(status)
  start_time = time.time()
  pprint(status)

  while not get_status[0].status == 'completed':
    get_status = eval(status)
    run_time = time.time() - start_time
    print 'Status: {0}, Run Time: {1}'.format(get_status[0].status,run_time)
    time.sleep(wait)
   
    # If loop time limit is exceeded then exit 2 (Critical) and fire snmp trap
    if run_time > time_limit:
      print 'Waited too long, time limit: {0}s exceeded'.format(time_limit)
      os.system('/usr/bin/snmptrap -v 2c -c public {0} "" NAGIOS-NOTIFY-MIB::nSvcEvent nSvcHostname s {1} nSvcDesc s EBSBACKUP nSvcStateID i 2 nSvcOutput s "\'EBS Backup Failed.\'"'.format(options.trapdest,host))
      sys.exit(2)
      break

  end_time = time.time()
  time_taken = end_time - start_time
  print 'Event took: {0}'.format(time_taken)

  return get_status[0].status

# Backup function
def ebs_backup( options, myhost ):

  # retention
  retention_days = int(options.retention.split(':')[0])
  retention_weeks  = int(options.retention.split(':')[1])
  retention_months = int(options.retention.split(':')[2])

  # Fetch list EBS volumes
  ec2_ebs = conn_ec2.get_all_volumes()

  # Iterate throught the list of EBS volumes in our region to see what we need to snapshot 
  for volume in ec2_ebs:

    tags = volume.tags
    volstatus = volume.status

    # Skip volumes which are not in-use
    if volstatus != 'in-use':
        continue

    # Do we have a tag to store Tenant
    if 'Tenant' in tags:

      # is it the tenant we're looking for
      if tags['Tenant'] not in options.AWS_TENANT:
         # no , onto the next volume
         continue

      # Connect to volume
      conn_vol = conn_ec2.get_all_volumes([volume.id])
      vol = conn_vol[0]

      print 'Creating snapshot from {0}'.format(volume.id)

      # Snapshot our EBS and time
      if not options.dry_run:
         snap = vol.create_snapshot(volume.id+'-'+volume.tags['Name']+'-'+date_today)

         # From the volume were about to snapshot, find the host which it's attached to
         reservations = conn_ec2.get_all_instances([volume.attach_data.instance_id])
         instances = [i for r in reservations for i in r.instances]

         # Tag our snapshot with parent vol_id and name
         snap.add_tag("Tenant", instances[0].tags['Tenant']) 
         snap.add_tag("TakenWhileAttachedToID", volume.attach_data.instance_id)
         snap.add_tag("TakenWhileAttachedToName", instances[0].tags['Name'])
         snap.add_tag("TakenFromVolumeID", volume.attach_data.id)
         snap.add_tag("TakenAtUnixTime", time.time())
         snap.add_tag("TakenDate", date_today)

  # Fetch snapshot list
  ebs_snapshots = conn_ec2.get_all_snapshots(owner="self")

  # Iterate throught the list of snapshots
  for snapshot in ebs_snapshots:

    tags = snapshot.tags

    # Do we have a tag to store Tenant
    if 'Tenant' in tags:

      # is it the tenant we're looking for
      if tags['Tenant'] not in options.AWS_TENANT:
          # no , onto the next volume
          continue

      print 'Found: {0} ({1}), checking status for snapshot'.format(snapshot.description, snapshot.id)

      # Check all snapshots for a completed status and report any failures to monitoring
      get_snapshot = 'conn_ec2.get_all_snapshots("'+snapshot.id+'")'
      snapshot_status = avail_loop(get_snapshot, 3, 3600, snapshot.tags['Name'])

      #debug
      #pprint(snapshot.__dict__)

      print 'Snapshot: {0} Host: {1} Status: {2}'.format(snapshot.id, snapshot.tags['Name'], snapshot_status)
      if snapshot_status != 'completed':
        if options.dry_run: 
          print 'Sending trap Fail to: {0} from: {1}'.format(options.trapdest, myhost)
        os.system('/usr/bin/snmptrap -v 2c -c public {0} "" NAGIOS-NOTIFY-MIB::nSvcEvent nSvcHostname s {1} nSvcDesc s EBSBACKUP nSvcStateID i 2 nSvcOutput s "\'EBS Backup Failed ({2}).\'"'.format(options.trapdest, myhost, snapshot.volume_id))
        sys.exit(2)
        break
      else: 
        if options.dry_run: 
          print 'Sending trap Success to: {0} from: {1}'.format(options.trapdest, myhost)
        os.system('/usr/bin/snmptrap -v 2c -c public {0} "" NAGIOS-NOTIFY-MIB::nSvcEvent nSvcHostname s {1} nSvcDesc s EBSBACKUP nSvcStateID i 0 nSvcOutput s "\'EBS Backup Success.\'"'.format(options.trapdest, myhost))

      # vol-af33658f-ops-monitor-volume-2014-02-06
      backup_regex = re.compile('.*-((\d+)-(\d+)-(\d+))$')

      backup_files = dict()
      filename = snapshot.description

      match = backup_regex.match(filename) 

      if match:

        backup_files[ match.group(1) ] = filename
          
      backups = map ( dp.parse,  backup_files.keys() ) 
   
      delete_dates = to_delete( backups,  
                                days=retention_days,
                                weeks=retention_weeks,
                                months=retention_months, 
                                firstweekday=MONDAY, 
                                now=datetime.now()
                              )

      for deletestamp in delete_dates:

        stamp = deletestamp.strftime("%Y-%m-%d")
        if stamp in backup_files:
   
          filename = backup_files[ stamp ]
          
          if not options.dry_run:
            print 'Deleting snapshot: {0} Created: {1}'.format(snapshot.id, snapshot.start_time)
            conn_ec2.delete_snapshot(snapshot.id)

  sys.exit(0)
  
ebs_backup( options, myhost );
