import subprocess
import json
import logging

logger = logging.getLogger(__name__)


class AwsCli(object):
    def __init__(self, conf_file, profile=None, region=None):
        self.conf_file = conf_file
        self.profile = profile
        self.region = region

    def run(self, command):
        command = self._awscli_wrapper(command)
        logger.debug('Execute Command: {0}'.format(command))
        p = subprocess.Popen(command, stdout=subprocess.PIPE, stderr=subprocess.PIPE, shell=True)
        out, err = p.communicate()

        if '--dry-run' not in command:
            if p.returncode:
                logger.debug('output: ' + str(err))
                raise subprocess.CalledProcessError(p.returncode, command)
            else:
                logger.debug('output: ' + str(out))
                return json.loads(out)
        else:
            if 'DryRunOperation' not in str(err):
                logger.debug('output: ' + str(err))
                raise subprocess.CalledProcessError(p.returncode, command)
            else:
                logger.debug('output: ' + str(err))
                return err

    def _awscli_wrapper(self, command):

        command = 'PATH=$PATH:/usr/local/bin '+command

        # add config file
        if self.conf_file:
            command = 'AWS_CONFIG_FILE=' + self.conf_file + ' ' + command

        # add region
        if self.region:
            command += ' --region ' + self.region

        # add profile
        if self.profile:
            command += ' --profile ' + self.profile

        return command