import json
import logging
from opsaws.awscli import AwsCli

logger = logging.getLogger(__name__)


class RDSCli(AwsCli):

    def describe_db_instance(self):
        logger.info('describe-db-instances')
        command = 'aws rds describe-db-instances'
        return self.run(command)['DBInstances']

    def describe_db_snapshots(self, db_instance_identifier=None, db_snapshot_identifier=None, snapshot_type=None):
        logger.info('describe-db-snapshots db_id:{0} snapshot_id:{1} snapshot_type:{2}'.format(db_instance_identifier, db_snapshot_identifier, snapshot_type))
        command = 'aws rds describe-db-snapshots'

        if db_instance_identifier:
            command += ' --db-instance-identifier '+db_instance_identifier
        if db_snapshot_identifier:
            command += ' --db-snapshot-identifier '+db_snapshot_identifier
        if snapshot_type:
            command += ' --snapshot-type '+snapshot_type
        return self.run(command)['DBSnapshots']

    def create_db_snapshot(self, db_instance_identifier, db_snapshot_identifier):
        logger.info('create-db-snapshot db_identifier:{0} snapshot_identifier:{1}'.format(db_snapshot_identifier, db_snapshot_identifier))
        command = 'aws rds create-db-snapshot'
        command += ' --db-instance-identifier ' + db_instance_identifier
        command += ' --db-snapshot-identifier ' + db_snapshot_identifier

        return self.run(command)['DBSnapshot']

    def delete_db_snapshot(self, db_snapshot_identifier):
        logger.info('delete-db-snapshot identifier:{0}'.format(db_snapshot_identifier))
        command = 'aws rds delete-db-snapshot --db-snapshot-identifier ' + db_snapshot_identifier

        return self.run(command)['DBSnapshot']
