# Copyright 2013 Novo Nordisk Foundation Center for Biosustainability,
# Technical University of Denmark.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


__version__ = '0.0.2'

import logging

log = logging.getLogger(__name__)

from .util import list_available_solvers

available_solvers = list_available_solvers()

if available_solvers['GLPK']:
    from .glpk_interface import Model, Variable, Constraint, Objective
elif available_solvers['CPLEX']:
    from .cplex_interface import Model, Variable, Constraint, Objective
else:
    log.error('No solvers available.')

if available_solvers['GLPK']:
    import glpk_interface
if available_solvers['CPLEX']:
    import cplex_interface
