#!/usr/bin/env python
#coding: utf-8

__author__ = "alice <http://twitter.com/Alice_Himmel>"
__version__ = "1.0(beta)"
__license__ = "NYSL"


import sys
import os
import types

class BaseError(Exception):      pass
class OptionError(BaseError):    pass
class ArgumentsError(BaseError): pass

class OptionParse:
	def __init__(self, usage, version, helpfile=None):
		self.status = Status()
		self.status.usage = usage
		self.status.version = version
		if helpfile:
			if isinstance(helpfile, types.FileType) == False:
				raise TypeError("%s is not file type." % helpfile)
			self.status.helpfile = helpfile
		else: self.status.helpfile = ""
		
	
	def add_option(self, *opts, **args):
		self.sup = SupClass()
		self.opts = self.sup.check_opts(opts)
		self.number_of_key, self.desc, self.action = self.sup.check_args(args)
		self.action = self.sup.check_act(self.action)
		self.regps = self.status.registoption(self.opts, self.number_of_key, self.desc, self.action)
		
	def runparser(self):
		if self.status.helpfile == "":
			self.launch = RunParser(self.status.get_registory(), self.status.usage, self.status.version)
		else:
			self.launch = RunParser(self.status.get_registory(), self.status.usage, self.status.version, self.status.helpfile)
		
class Status:
	def __init__(self):
		self.usage   = ""
		self.version = ""
		self.helpfile = ""
	def registoption(self, opts, number_of_key, desc, action):
		try:
			self.OptionRegistrar[ opts ] = {
				"number_of_key" : number_of_key,
				"desc"          : desc,
				"action"        : action
			}
		except:
			self.OptionRegistrar = {}
			self.OptionRegistrar[ opts ] = {
				"number_of_key" : number_of_key,
				"desc"          : desc,
				"action"        : action
			}
		return True
	def get_registory(self):
		return self.OptionRegistrar
	def get_regist_arg(self, opts):
		if isinstance(opts, types.TupleType) == False:
			raise TypeError("'%s' is not tuple type." % opts)
		self.reg = self.OptionRegistrar
		item = [self.reg[i] for i in self.reg.keys() if i == opts]
		return item
				
class SupClass:
	def check_opts(self, opts):
		options = []
		for opt in opts:
			if "-" not in opt:
				raise OptionError("%s option is not contian '-'" % opt)
			elif isinstance(opt, types.StringType) == False:
				raise TypeError("option is String type only.")			
			else: 
				options.append(opt)
		return tuple(options)
		
	def check_args(self, args):
		allow_keys = ["number_of_key", "desc", "action"]
		number_of_key = ""
		desc = ""
		action = ""
		for key, value in args.iteritems():
			if key == allow_keys[0]:
				number_of_key = int(value)
			elif key == allow_keys[1]:
				desc = value
			elif key == allow_keys[2]:
				action = value
			else:
				raise ArgumentsError("too many args")
		if number_of_key == "" or desc == "" or action == "":
			raise ArgumentsError("Arguments have not been met.")
		return (number_of_key, desc, action)
	
	def check_act(self, action):
		if isinstance(action, types.FunctionType) == False:
			raise TypeError("'%s' action is not function type." % action)
		else: return action
		
class RunParser:
	def __init__(self, optionregistory, usage, version, helpfile=None):
		self.registory = optionregistory
		self.usage = self.check_usage(usage)
		self.version = version
		if len(sys.argv[1:]) == 0:
			if helpfile != None:
				self.call_help2(helpfile)
			else:
				self.call_help()
		else:
			ArgParser(self.registory)
		
	def check_usage(self, usage):
		if usage[0:6] != "usage:":
			before = usage
			usage = "usage:"+before
		if "%prog" in usage:
			usage = usage.replace("%prog", os.path.basename(sys.argv[0]))
		return usage
	
	def format_textwidth(self):
		length = []
		for opts in self.registory.keys():
			for opt in opts:
				length.append(len(opt))
		sorts = sorted(length, reverse=True)
		return int(sorts[0])
		
	def call_help(self):
		content = " "
		width = self.format_textwidth()
		print self.usage+"\n"
		for opts in self.registory.keys():
			for opt in opts:
				if opt == opts[-1]:
					content += opt
				else:
					content += opt+" "
			content += " "*10+self.registory[opts]["desc"]+"\n "
		print content
		sys.exit(0)
	
	def call_help2(fp):
		print self.usage+"\n"
		for t in fp.read().split("\n"):
			print t
		sys.exit(0)
			
class ArgParser:
	def __init__(self, registory):
		self.registory = registory
		self.mainopt, self.args = self.get_sys_args(sys.argv[1:])
		
		for opts in self.registory.keys():
			for opt in opts:
				if opt == self.mainopt:
					nok = self.registory[opts]["number_of_key"]
					if len(self.args) > nok:
						raise ArgumentsError("too many arguments.")
					elif len(self.args) < nok:
						raise ArgumentsError("too little arguments.")
					else:
						self.registory[opts]["action"](self.args)
						result = True
						break
				else: result = False
		if result == False:
			raise ArgumentsError("argument is not appropriate.")
					
	def get_sys_args(self,args):
		opt = args[0]
		other = args[1:]
		return  opt, other
		