#!/usr/bin/env python
#coding: utf-8

__author__ = "alice"
__version__ = "2.0"
__license__ = "NYSL"

import sys
import os
import types


# Setting Error
class BaseError(Exception):      pass
class OptionError(BaseError):    pass
class ArgumentsError(BaseError): pass
class ElementsError(BaseError):  pass


# Main classes

class OptionParser:
	def __init__(self, usage, version, helpfile=None):
		self.sup = Support()
		self.usage = self.sup.format_usage(usage)
		self.version = version
		
		if helpfile != None:
			if self.sup.check_type(helpfile, "file") == False:
				raise TypeError("%s is not FILE type." % helpfile)
			else: self.helpfile = helpfile
		else: self.helpfile = helpfile
				
	def add_option(self, *option_names, **status_elements):
		self.option_names = option_names
		self.noa, self.desc, self.func = self.sup.get_elements(status_elements)
		
		# Set option
		self.status = Status()
		self.status.SetStatus(self.option_names, self.noa, self.desc, self.func)
		
	def runparser(self):
		ArgumentsParser(self.usage, self.version, self.helpfile)
		
# Arguments Parser class
class ArgumentsParser:
	def __init__(self, usage, ver, helpfile):
		self.helpfile = helpfile
		self.usage = usage
		self.version = ver
		
		# Call Help (argument)
		if len(sys.argv[1:]) == 0 or sys.argv[1] == "-h" or sys.argv[1] == "--help":
			if self.helpfile != None:
				self.call_help_file(self.helpfile)
			else:
				self.call_help()
		else:
			ClassifyArg(sys.argv[1:])
	
	def call_help(self):
		self.status = Status()
		self.registory = self.status.getregistory()
		content = []
		content.append(self.usage)
		
		print self.usage
		print "-h --help".ljust(self.get_width()) + "show help text."
		ids = [elements["sortid"] for elements in self.registory.values()]
		for id in sorted(ids):
			for options, elements in self.registory.iteritems():
				if elements["sortid"] == id:
					opts = ""
					for opt in options:
						if opt == options[-1]:
							opts += opt
						else: opts += opt + " "
					print "%s%s" % ( opts.ljust(self.get_width()), self.registory[options]["desc"] )
		sys.exit(1)
			
	def call_help_file(self, helpfile):
		print self.usage
		for line in self.helpfile.read().split("\n"):
			print line
		sys.exit(1)
		
	def get_width(self):
		text = ""
		optwidths = []
		optwidth = 0
		for options in self.registory.keys():
			for opt in options:
				optwidth += len(opt)
			optwidths.append(optwidth)
			width = sorted([i for i in optwidths], reverse=True)[0]
			smallwidth = sorted([i for i in optwidths], reverse=True)[-1]
		return width-smallwidth

class ClassifyArg:
	def __init__(self, argv):
		mainarg = argv[0]
		arglist = argv[1:]
		
		self.status = Status()
		self.registory = self.status.getregistory()
		for options in self.registory.keys():
			for opt in options:
				if opt == mainarg:
					self.registory[options]["func"](arglist)
			
# Setting Status class
class Status:
	OptionRegistory = {}
	i = 1
	def SetStatus(self, option_names, number_of_arg, description, function):
		Status.OptionRegistory[ option_names ] = {
			"number_of_arg": number_of_arg,
			"desc"         : description,
			"func"         : function,
			"sortid"       : Status.i
		}
		Status.i += 1
	
	def getregistory(self):
		return Status.OptionRegistory

# Support Class
class Support:
	def format_usage(self, usage):
		if usage.startswith("usage:") == False:
			usage = "usage: "+usage
		if "%prog" in usage:
			usage = usage.replace("%prog", os.path.basename(sys.argv[0]))
		return usage
	
	def get_elements(self, status_elements):
		elements = status_elements
		allow_keys = ["number_of_arg", "desc", "func"]
		noa = ""
		desc = ""
		func = ""
		
		for key, value in elements.iteritems():
			if key == allow_keys[0]:
				noa = int(value)-1
			elif key == allow_keys[1]:
				desc = value
			elif key == allow_keys[2]:
				if self.check_type(value, "func") == False:
					raise TypeError("The 'func' element is only function type.")
				else: func = value
		
		if noa == "" or desc == "" or func == "":
			raise ElementsError("Add_option method needs 'number_of_arg', 'desc' and 'func' elements.")
		
		return (noa, desc, func)
		
	def check_type(self, var, type):
		localtypes = {
			"None"  : types.NoneType,
			"bool"  : types.BooleanType,
			"int"   : types.IntType,
			"str"   : types.StringType,
			"tuple" : types.TupleType,
			"list"  : types.ListType,
			"dict"  : types.DictType,
			"func"  : types.FunctionType,
			"file"  : types.FileType,
		}
		for localtype in localtypes.keys():
			if localtype == type:
				TOF = isinstance(var,localtypes[localtype])
				return TOF
