import log
import event
def create(conn):
    if '|' in conn.request.headers['url']:
        return IFrameTransport()
    else:
        return XHRTransport()

def extract_user(req):
    if '|' in req.headers['url']:
        return req.headers['url'].split('|')        
    elif '!' in req.headers['url']:
        return req.headers['url'].split('!')
        

class Transport(object):
    def respond(self, request):
        pass
    def accept_http_connection(self, conn):        
        pass
    def response_success(self, request, conn):
        pass
        

class IFrameTransport(Transport):
    initial_data =  "HTTP/1.1 200 OK\r\n"
    initial_data += "Content-Type: text/html\r\n"
    initial_data += "Content-Length: 100000\r\n\r\n"
    initial_data += "<script>document.domain=\"%s\";</script>"

    def __init__(self):
        self.http_conn = None

    def accept_http_connection(self, conn):
        if self.http_conn is not None:
            self.http_conn.close()
        self.http_conn = conn
        document_domain = '.'.join(conn.request.headers['host'].split(':')[0].split('.')[-2:])
        self.http_conn.respond(ResponseBuffer(self.initial_data % document_domain, self))

    def respond(self, request):
        self.http_conn.respond(ResponseBuffer(request.body, self, request))
        
    def response_success(self, request, conn):
        log_recipient = "%s [ %s ]" % (str(conn.key())[1:-1], conn.addr[0])
        log.log("EVENT", "%s/%s -> %s" % (conn.addr[0], request.id, log_recipient))
        request.success(conn.key())
        
    def response_failure(self, request, conn):
        log_recipient = "%s [ %s ]" % (str(conn.key())[1:-1], conn.addr[0])
        request.error(conn.key())

    
class XHRTransport(Transport):
    timeout_delay = 30
            
    def __init__(self):
        self.connections = []
        
    def accept_http_connection(self, conn):
       
        timer = event.timeout(self.timeout_delay, self.timed_out, conn)
        conn.timer = timer
        self.connections.append(conn)
        
    def timed_out(self, conn):
        print "TIME OUT: %s" % conn
        self.connections.remove(conn)
        conn.respond(ResponseBuffer("", self, XHRTimeoutRequest()))
            
    def respond(self, request):
        conn = self.connections.pop(0)
        conn.respond(ResponseBuffer(request.body, self, request))
        conn.timer.delete()

    def timeout_response_complete(self, conn):
        conn.close()
        
    def response_success(self, request, conn):
        if isinstance(request, XHRTimeoutRequest):
            return self.timeout_response_complete(conn)
        log_recipient = "%s [ %s ]" % (str(conn.key())[1:-1], conn.addr[0])
        log.log("EVENT", "%s/%s -> %s" % (conn.addr[0], request.id, log_recipient))
        request.success(conn.key())
        conn.close()
        
    def response_failure(self, request, conn):
        if isinstance(request, XHRTimeoutRequest):
            return self.timeout_response_complete(conn)
        log_recipient = "%s [ %s ]" % (str(conn.key())[1:-1], conn.addr[0])
        request.error(conn.key())
        conn.close()
        
        
        
class XHRTimeoutRequest(object):
    pass


    
class ResponseBuffer(object):

    def __init__(self, data, transport, request=None):
        self.request = request
        self.data = data
        self.transport = transport
        
    def success(self, conn):
        if self.request:
            self.transport.response_success(self.request, conn)
        
    def failure(self, conn):
        if self.request:
            self.transport.response_failure(self.request, conn)