
from gi.repository import Gtk

import org.wayround.pyabber.ccc
import org.wayround.pyabber.chat_pager
import org.wayround.utils.gtk


class ChatWindow:

    def __init__(self, controller):

        if not isinstance(
                controller,
                org.wayround.pyabber.ccc.ClientConnectionController
                ):
            raise ValueError(
                "`controller' must be org.wayround.xmpp.client.XMPPC2SClient"
                )

        self._controller = controller
        # self._title = ''

        window = Gtk.Window()

        b = Gtk.Box()
        b.set_orientation(Gtk.Orientation.VERTICAL)
        b.set_margin_left(5)
        b.set_margin_top(5)
        b.set_margin_right(5)
        b.set_margin_bottom(5)
        b.set_spacing(5)

        window.add(b)
        window.connect('destroy', self._on_destroy)
        window.connect(
            'delete-event', org.wayround.utils.gtk.hide_on_delete
            )

        self.chat_pager = org.wayround.pyabber.chat_pager.ChatPager(controller)

        b.pack_start(self.chat_pager.get_widget(), True, True, 0)

        self._window = window

        self.refresh_title()

        return

    def run(self):
        self.show()
        return

    def show(self):
        self._window.show_all()
        return

    def destroy(self):
        self.chat_pager.destroy()
        self._window.hide()
        self._window.destroy()
        return

    def _on_destroy(self, window):
        self.destroy()
        return

    def get_window_widget(self):
        return self._window

    def refresh_title(self):
        j = self._controller.jid.full()
        self._window.set_title("Chatting as `{}'".format(j))
        return
