// Generated by CoffeeScript 1.3.3
(function() {
  var changeFavicon, getCalScrollUpDown, getCheckAutoReload, getCheckedToggleFunc, getChoosePerspective, getChoosePerspectiveByKey, getEventclassToggleFunc, getEventfilterToggleFunc, getPageSwitcher, getReloadImages, getResizeCalendar, root, setCalendar, setCalendarKeyBind, setCalendarKeyBindAndAutoResizeAndAutoReloadAndHelp, setFullCalendarUI, setPageViewKeyBind, setUpMain,
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  getCalScrollUpDown = function(cal, inc) {
    return function() {
      var scrollBar, view;
      view = cal.fullCalendar("getView");
      if (view.name === "agendaWeek" || view.name === "agendaDay") {
        scrollBar = view.element.children("div").children("div:eq(2)");
        return scrollBar.scrollTop(scrollBar.scrollTop() + inc);
      } else {
        return window.scrollBy(0, inc);
      }
    };
  };

  getEventclassToggleFunc = function(cal, eventclass) {
    var checkbox, refetchEvents;
    refetchEvents = function() {
      return cal.fullCalendar("refetchEvents");
    };
    checkbox = $("#eventclass-" + eventclass);
    checkbox.change(refetchEvents);
    return getCheckedToggleFunc(checkbox, refetchEvents);
  };

  getEventfilterToggleFunc = function(cal, i) {
    var checkbox, refetchEvents;
    refetchEvents = function() {
      return cal.fullCalendar("refetchEvents");
    };
    checkbox = $("#eventfilter-" + i);
    checkbox.change(refetchEvents);
    return getCheckedToggleFunc(checkbox, refetchEvents);
  };

  getCheckedToggleFunc = function(checkbox, callback) {
    return function() {
      if (checkbox.is(":checked")) {
        checkbox.removeAttr("checked");
      } else {
        checkbox.attr("checked", "checked");
      }
      if (callback !== void 0) {
        return callback();
      }
    };
  };

  getChoosePerspective = function(calendar, perspectives, eventclasses, eventfilters) {
    return function(cpid) {
      var checkbox, defper, ec, ef, event, filter, per, view;
      defper = perspectives[0];
      per = perspectives[cpid];
      event = "event" in per ? per["event"] : defper["event"];
      view = "view" in per ? per["view"] : defper["view"];
      filter = "filter" in per ? per["filter"] : defper["filter"];
      for (ec in eventclasses) {
        checkbox = eventclasses[ec];
        if (__indexOf.call(event, ec) >= 0) {
          checkbox.attr("checked", "checked");
        } else {
          checkbox.removeAttr("checked");
        }
      }
      for (ef in eventfilters) {
        checkbox = eventfilters[ef];
        if (ef in filter) {
          checkbox.attr("checked", "checked");
        } else {
          checkbox.removeAttr("checked");
        }
      }
      return calendar.fullCalendar("changeView", view).fullCalendar("refetchEvents");
    };
  };

  getChoosePerspectiveByKey = function(cpid, checkbox, choosePerspective) {
    return function() {
      checkbox.attr("checked", "checked");
      return choosePerspective(cpid);
    };
  };

  setFullCalendarUI = function(events_data, perspectives, config) {
    var calendar, choosePerspective, ec, eventclasses, eventfilters, getEventclasses, getEventfilters, perspectiveCheckboxes, _i, _len, _ref;
    calendar = $("#calendar");
    getEventclasses = function() {
      var k, v, _results;
      _results = [];
      for (k in eventclasses) {
        v = eventclasses[k];
        if (v.attr("checked")) {
          _results.push(k);
        }
      }
      return _results;
    };
    getEventfilters = function() {
      var k, v, _results;
      _results = [];
      for (k in eventfilters) {
        v = eventfilters[k];
        if (v.attr("checked")) {
          _results.push(k);
        }
      }
      return _results;
    };
    eventclasses = {};
    _ref = $('input.eventclass-checkbox');
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      ec = _ref[_i];
      ec = $(ec);
      eventclasses[ec.data('name')] = ec;
    }
    eventfilters = {};
    $(".eventfilter").each(function(idx, elem) {
      var checkbox, fid;
      checkbox = $(elem);
      fid = checkbox.attr("id").split("eventfilter-")[1];
      eventfilters[fid] = checkbox;
      return checkbox.change(function() {
        return calendar.fullCalendar("refetchEvents");
      });
    });
    calendar.fullCalendar({
      header: {
        left: "prev,next,today",
        center: "title",
        right: "month,basicWeek,basicDay,agendaWeek,agendaDay"
      },
      buttonText: {
        month: "Month (q)",
        basicWeek: "Week (w)",
        basicDay: "Day (e)",
        agendaWeek: "A/W (r)",
        agendaDay: "A/D (t)",
        today: "Today (T)"
      },
      firstDay: 1,
      eventSources: [
        {
          url: events_data,
          data: {
            eventclass: getEventclasses,
            eventfilter: getEventfilters
          }
        }
      ].concat(config.eventSources),
      eventClick: function(event) {
        if (event.url) {
          window.open(event.url);
          return false;
        }
      }
    });
    choosePerspective = getChoosePerspective(calendar, perspectives, eventclasses, eventfilters);
    perspectiveCheckboxes = $(".cal-perspective");
    perspectiveCheckboxes.change(function() {
      return choosePerspective($(this).attr("id").split("cal-perspective-")[1]);
    });
    perspectiveCheckboxes.each(function(idx, elem) {
      return $(document).bind("keydown", "" + (idx + 1), getChoosePerspectiveByKey(idx, $(elem), choosePerspective));
    });
    $(".eventfilter").each(function(idx) {
      return $(document).bind("keydown", "shift+" + (idx + 1), getEventfilterToggleFunc(calendar, idx));
    });
    return $(document).ready(function() {
      return choosePerspective(0);
    });
  };

  setCalendarKeyBind = function(doc, cal, cbConf, resizeCalendar, checkAutoReload) {
    var ec, fun, key, _i, _len, _ref, _results;
    doc.bind("keydown", "shift+h", function() {
      return $.colorbox($.extend({
        href: "#help"
      }, cbConf));
    }).bind("keydown", "shift+/", function() {
      return $.colorbox($.extend({
        href: "#help"
      }, cbConf));
    }).bind("keydown", "shift+p", function() {
      $("#calendar-control-advanced").toggle();
      return resizeCalendar();
    }).bind("keydown", "left", function() {
      return cal.fullCalendar("prev");
    }).bind("keydown", "right", function() {
      return cal.fullCalendar("next");
    }).bind("keydown", "h", function() {
      return cal.fullCalendar("prev");
    }).bind("keydown", "l", function() {
      return cal.fullCalendar("next");
    }).bind("keydown", "j", getCalScrollUpDown(cal, 100)).bind("keydown", "k", getCalScrollUpDown(cal, -100)).bind("keydown", "u", getCalScrollUpDown(cal, -1 * window.innerHeight / 2)).bind("keydown", "d", getCalScrollUpDown(cal, window.innerHeight / 2)).bind("keydown", "q", function() {
      return cal.fullCalendar("changeView", "month");
    }).bind("keydown", "w", function() {
      return cal.fullCalendar("changeView", "basicWeek");
    }).bind("keydown", "e", function() {
      return cal.fullCalendar("changeView", "basicDay");
    }).bind("keydown", "r", function() {
      return cal.fullCalendar("changeView", "agendaWeek");
    }).bind("keydown", "t", function() {
      return cal.fullCalendar("changeView", "agendaDay");
    }).bind("keydown", "shift+a", getCheckedToggleFunc($("#auto-reload"), checkAutoReload)).bind("keydown", "shift+t", function() {
      return cal.fullCalendar("today");
    }).bind("keydown", "shift+r", function() {
      return cal.fullCalendar("refetchEvents");
    }).bind("keydown", "shift+l", function() {
      return window.open($("#timeline_link").attr("href"));
    });
    _ref = $('input.eventclass-checkbox');
    _results = [];
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      ec = _ref[_i];
      ec = $(ec);
      key = ec.data("key");
      if (key) {
        fun = getEventclassToggleFunc(cal, ec.data("name"));
        _results.push(doc.bind("keydown", key, fun));
      } else {
        _results.push(void 0);
      }
    }
    return _results;
  };

  getCheckAutoReload = function(cal) {
    var autoReload, autoReloadId;
    autoReloadId = false;
    autoReload = function() {
      return autoReloadId = window.setTimeout(function() {
        cal.fullCalendar("refetchEvents");
        return autoReload();
      }, 1000);
    };
    return function() {
      if ($("#auto-reload").is(":checked")) {
        return autoReload();
      } else {
        return clearTimeout(autoReloadId);
      }
    };
  };

  getResizeCalendar = function(cal) {
    return function() {
      return cal.fullCalendar("option", "height", $(window).height() - cal.position().top);
    };
  };

  setCalendarKeyBindAndAutoResizeAndAutoReloadAndHelp = function() {
    var cal, cbConf, checkAutoReload, resizeCalendar;
    $("#calendar-control-advanced").hide();
    cbConf = {
      transition: "none",
      speed: 0,
      inline: true
    };
    cal = $("#calendar");
    resizeCalendar = getResizeCalendar(cal);
    checkAutoReload = getCheckAutoReload(cal);
    setCalendarKeyBind($(document), cal, cbConf, resizeCalendar, checkAutoReload);
    $(window).bind("resize", resizeCalendar);
    resizeCalendar();
    $("#auto-reload").change(checkAutoReload);
    checkAutoReload();
    return $(".inline").colorbox(cbConf);
  };

  setCalendar = function(events_data, perspectives) {
    return $.getJSON("/cal_config", function(config) {
      setFullCalendarUI(events_data, perspectives, config);
      return setCalendarKeyBindAndAutoResizeAndAutoReloadAndHelp();
    });
  };

  getPageSwitcher = function(page, faviconpath, callback) {
    var otherpages, p, pagelist, title;
    pagelist = ["calendar", "graphs", "dones"];
    otherpages = (function() {
      var _i, _len, _results;
      _results = [];
      for (_i = 0, _len = pagelist.length; _i < _len; _i++) {
        p = pagelist[_i];
        if (p !== page) {
          _results.push(p);
        }
      }
      return _results;
    })();
    title = $("title");
    return function() {
      var other, _i, _len;
      $("#container-" + page).show();
      for (_i = 0, _len = otherpages.length; _i < _len; _i++) {
        other = otherpages[_i];
        $("#container-" + other).hide();
      }
      changeFavicon(faviconpath);
      title.text("" + page + " | orgviz");
      if (callback != null) {
        return callback();
      }
    };
  };

  changeFavicon = function(href) {
    var link;
    link = document.createElement("link");
    link.id = "favicon";
    link.type = "image/x-icon";
    link.rel = "shortcut icon";
    link.href = href;
    $("#favicon").remove();
    return document.getElementsByTagName("head")[0].appendChild(link);
  };

  setPageViewKeyBind = function(favicon) {
    var reloadImages, viewPageCalendar, viewPageDones, viewPageGraphs;
    reloadImages = getReloadImages($(".graph"));
    viewPageCalendar = getPageSwitcher("calendar", favicon.calendar);
    viewPageGraphs = getPageSwitcher("graphs", favicon.graphs, reloadImages);
    viewPageDones = getPageSwitcher("dones", favicon.dones, function() {
      return $.ajax({
        url: "/dones_data",
        success: function(data) {
          return $("#container-dones").html(data);
        }
      });
    });
    viewPageCalendar();
    return $(document).bind("keydown", "g", reloadImages).bind("keydown", "shift+c", viewPageCalendar).bind("keydown", "shift+g", viewPageGraphs).bind("keydown", "shift+d", viewPageDones);
  };

  getReloadImages = function(images) {
    var imgSrcMap, imgsGraph;
    imgSrcMap = {};
    imgsGraph = images;
    imgsGraph.each(function(index, elem) {
      var id;
      id = $(elem).attr("id");
      if (id) {
        return imgSrcMap[id] = $(elem).attr("src");
      } else {
        id = "graph-" + index;
        $(elem).attr("id", id);
        return imgSrcMap[id] = $(elem).attr("src");
      }
    });
    return function() {
      return imgsGraph.attr("src", function() {
        var id, newSrc;
        id = $(this).attr("id");
        newSrc = imgSrcMap[id] + "?_=" + new Date().getTime();
        return newSrc;
      });
    };
  };

  setUpMain = function(events_data, perspectives, favicon) {
    setCalendar(events_data, perspectives);
    return setPageViewKeyBind(favicon);
  };

  root = typeof exports !== "undefined" && exports !== null ? exports : this;

  root.setUpMain = setUpMain;

  root.setCalendar = setCalendar;

  root.getReloadImages = getReloadImages;

}).call(this);
