// Generated by CoffeeScript 1.3.3
(function() {
  var fitTo, getCheckAutoReload, getCheckedToggleFunc, getPushPan, getResizeTimeGlider, root, setupTimeline;

  fitTo = function(fit, to, bottom, right) {
    var pos;
    if (bottom == null) {
      bottom = 0;
    }
    if (right == null) {
      right = 0;
    }
    pos = fit.position();
    fit.height(to.height() - pos.top - bottom);
    return fit.width(to.width() - pos.left - right);
  };

  getResizeTimeGlider = function(tg) {
    var tgcont, win;
    tgcont = tg.children(".timeglider-container");
    win = $(window);
    return function() {
      fitTo(tg, win);
      return fitTo(tgcont, win);
    };
  };

  getCheckAutoReload = function(reload) {
    var autoReload, autoReloadId;
    autoReloadId = false;
    autoReload = function() {
      return autoReloadId = window.setTimeout(function() {
        reload();
        return autoReload();
      }, 1000);
    };
    return function() {
      if ($("#auto-reload").is(":checked")) {
        return autoReload();
      } else {
        return clearTimeout(autoReloadId);
      }
    };
  };

  getCheckedToggleFunc = function(checkbox, callback) {
    return function() {
      if (checkbox.is(":checked")) {
        checkbox.removeAttr("checked");
      } else {
        checkbox.attr("checked", "checked");
      }
      if (callback != null) {
        return callback();
      }
    };
  };

  getPushPan = function(left, right, delay) {
    var push, pushed, tid;
    tid = false;
    pushed = false;
    push = function(button) {
      if (!pushed) {
        pushed = true;
        button.mousedown();
        return tid = window.setTimeout(function() {
          pushed = false;
          return button.mouseup();
        }, delay);
      }
    };
    return [
      (function() {
        return push(left);
      }), (function() {
        return push(right);
      })
    ];
  };

  setupTimeline = function(tg, data_source) {
    var autoReloadCheckbox, checkAutoReload, panButtonLeft, panButtonRight, pushLeft, pushRight, tg_actor, _ref;
    fitTo(tg, $(window), 10);
    tg.timeline({
      min_zoom: 1,
      max_zoom: 40,
      data_source: data_source
    });
    tg_actor = tg.data("timeline");
    autoReloadCheckbox = $("#auto-reload");
    checkAutoReload = getCheckAutoReload(function() {
      return tg_actor.load(data_source);
    });
    autoReloadCheckbox.change(checkAutoReload);
    checkAutoReload();
    panButtonLeft = $(".timeglider-pan-left");
    panButtonRight = $(".timeglider-pan-right");
    _ref = getPushPan(panButtonLeft, panButtonRight, 100), pushLeft = _ref[0], pushRight = _ref[1];
    $(document).bind("keydown", "r", function() {
      return tg_actor.load(data_source);
    }).bind("keydown", "a", getCheckedToggleFunc(autoReloadCheckbox, checkAutoReload)).bind("keydown", "i", function() {
      return tg_actor.zoom(-1);
    }).bind("keydown", "o", function() {
      return tg_actor.zoom(+1);
    }).bind("keydown", "h", pushLeft).bind("keydown", "l", pushRight).bind("keydown", "g", function() {
      panButtonLeft.mouseup();
      panButtonRight.mouseup();
      return console.log("G!");
    });
    return {
      tg: tg,
      tg_actor: tg_actor
    };
  };

  root = typeof exports !== "undefined" && exports !== null ? exports : this;

  root.setupTimeline = setupTimeline;

}).call(this);
