# Sources :
#    1) http://wiki.python.org/moin/Distutils/Tutorial
#    2) http://www.developpez.net/forums/d1195941/autres-langages/python-zope/general-python/ajout-module-distribution-python/#post6555422
#    3) http://docs.python.org/distutils/sourcedist.html
#    4) http://www.developpez.net/forums/d1208929/autres-langages/python-zope/general-python/distutils-exclure-inclure-dossier-fichier-lors-setup/#post6619447

# Meta-datas
#     1) http://docs.python.org/3.0/distutils/setupscript.html#additional-meta-data
#     2) https://pypi.python.org/pypi?%3Aaction=list_classifiers


# Line commands
#
#    1) Local installation :
#        python3.2 setup.py install
#
#    2) To register :
#         python3.2 setup.py register
#
#    3) To put the code on Pypi :
#         python3.2 setup.py sdist upload

from distutils.core import setup

with open(
    file     = 'orpyste/description.rst',
    encoding = "utf-8"
) as f:
    long_description = f.read()

setup(
    name         = "orpyste",
    version      = "2013.04.01",
    author       = "Christophe BAL",
    author_email = "projetmbc@gmail.com",
    url          = "https://pypi.python.org/pypi/orpyste",
    download_url = "https://pypi.python.org/pypi/orpyste",
    packages     = ['orpyste'],
    package_dir  = {'orpyste': "orpyste"},
    package_data = {'orpyste': ["change_log/*/*.txt"]},
    classifiers  = [
        'Development Status :: 5 - Production/Stable',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: GNU General Public License (GPL)',
        'Programming Language :: Python :: 3',
        'Operating System :: MacOS',
        'Operating System :: Microsoft :: Windows',
        'Operating System :: POSIX :: Linux',
        'Topic :: Utilities',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Topic :: Desktop Environment :: File Managers',
    ],
    description = \
        "A tool for reading yet another simple structured textual data files.",
    long_description = long_description,
)
