#! /usr/bin/env python3

"""
Directory : orpyste/model
Name      : parser
Version   : 2013.04
Author    : Christophe BAL
Mail      : projetmbc@gmail.com

This file defines all of things needed for the skeleton abstract class that will
be used by the reading class.
"""


class Skeleton():

# ---------------------- #
# -- KIND OF ONE LINE -- #
# ---------------------- #

    def isOneLineComment(self, oneLine):
        """
This method returns a boolean to know if the line is a single line comment.
        """
        return oneLine.startswith('//')

    def isMultiLineCommentStart(self, oneLine):
        """
This method returns a boolean to know if the line is the beginning of a
multiline comment.
        """
        return oneLine.startswith('/*')

    def isMultiLineCommentEnd(self, oneLine):
        """
This method returns a boolean to know if the line is the end of a multiline
comment.
        """
        return oneLine.strip()[-2:] == '*/'

    def isNewBlock(self, oneLine):
        """
This method returns a boolean to know if the line is the beginning of a block.
        """
        oneLine = oneLine.strip()

        if oneLine[-2:] != '::':
            return False

        oneLine = oneLine[:-2]

        if oneLine[-1:] == ':':
            return False

        return True

# --------------------- #
# -- EQUAL PLUS MODE -- #
# --------------------- #

    def findEqualPlus(self, oneLine):
        """
This method returns the possible position of a sign ``=`` in a line.
        """
        i = oneLine.find('=')
        j = oneLine.find('"="')

        if i == j + 1:
            i = -1

        return i

# ----------------- #
# -- INDENTATION -- #
# ----------------- #

    def indentLevel(self, oneLine):
        """
This method simply returns the level of indention of a line.
        """
        level = 0

        for oneChar in oneLine:
            if oneChar == ' ':
                level += 1

            elif oneChar == '\t':
                level += 4

            else:
                break

        return level

# -------------- #
# -- CLEANING -- #
# -------------- #

    def stripIt(self, oneLine):
        """
This method cleans a line or block content regarding to the value of the
attribut ``strip``.
        """
        if self.strip:
            return oneLine.strip()

        else:
            return oneLine.rstrip()

    def cleanIndent(
        self,
        oneLine,
        level
    ):
        """
This methods removes spaces coming from indentation.
        """
        if level == 0:
            return oneLine

        else:
            currentLevel   = 0
            spacesToRemove = ""

            while oneLine:
                firstChar = oneLine[0]

                if firstChar == ' ':
                    currentLevel += 1
                    oneLine      = oneLine[1:]

                elif firstChar == '\t':
                    currentLevel += 4
                    oneLine      = oneLine[1:]

                else:
                    break

                if currentLevel >= level:
                    break

            return oneLine
