# =======
# Sources
# =======
#
#    1) http://wiki.python.org/moin/Distutils/Tutorial
#    2) http://www.developpez.net/forums/d1195941/autres-langages/python-zope/general-python/ajout-module-distribution-python/#post6555422
#    3) http://docs.python.org/distutils/sourcedist.html
#    4) http://www.developpez.net/forums/d1208929/autres-langages/python-zope/general-python/distutils-exclure-inclure-dossier-fichier-lors-setup/#post6619447


# ==========
# Meta-datas
# ==========
#
#     1) http://docs.python.org/3.0/distutils/setupscript.html#additional-meta-data
#     2) https://pypi.python.org/pypi?%3Aaction=list_classifiers


# =============
# Line commands
# =============
#
#    1) Local installation :
#        python3 setup.py install
#
#    2) Registering :
#         python3 setup.py register
#
#    3) Uploading the code on Pypi :
#         python3 setup.py sdist upload

from distutils.core import setup

PROJECT_DATE = "2013.10.05"

LONG_DESCRIPTION = """
**orPyste**, which is an anagram of **pyStore**, has been built so as to work with textual datas with the possibility to write easily this datas in text files.

If you want more informations and examples than thereafter, just take a look at the docstrings.

.. contents:: Table of Contents


========================
One important dependency
========================

This package uses `misTool <https://pypi.python.org/pypi/mistool>`_. **Don't forget to install it !**


===============================
Which OS can use this package ?
===============================

All the modules have been tested under Mac OS, Windows 7 and Linux Ubuntu 12.10 Quantal.


=====================
`Peuf` specifications
=====================

The datas are strings storing in blocks using indentation. Each block must have a name looking like **nameOfABlock::** and its content must have a higher level of indentation. Each block can contain other blocks or meaningful contents which can be of the following kinds.

1) You can use **key = value** like datas on each lines of the content.

2) You can also use similar **key = value** like datas but with the possibility to write the value on several lines.

3) More generally, you can use **key [SEP] value** like datas on each lines of the content where **[SEP]** can be a separator belonging to a list of personal separators. Like with **key = value**, it is also possible to put each value on several lines.

4) There is also **lines** like datas for texts stored line by line.

5) Finally, you can use **block** like datas for texts on several lines.


======================
How to use `orPyste` ?
======================

The module contains the class **orpyste.reader.Build** which produces an ordered dictionary whose keys are names of the blocks and values are either dictionaries for blocks containing blocks, or one of the following kinds of block values for blocks containing directly datas.

1) For **key = value** like datas, the block value is a dictionary defined naturally with the keys of the datas and their corresponding values.

2) For **key [SEP] value** like datas with personal separators, the block value is a dictionary with keys corresponding to the separators used, and values equal to one dictionary of key value kind.

3) For **lines** like datas, the block value is the list of the lines.

4) Finally, for **block** like datas, the block value is simply a string corresponding to the whole content of the block.


============================
Log of the last main changes
============================

Only the major changes are in english. You can find all of them in the directory ``change_log/en``.

If you want to know every changes, even the minor ones, there are in the directory ``change_log/fr`` but all of this is only in french.


:2013-10-05: One big bug has been fixed : sometimes, empty contents caused an error.


:2013-09-15: Block like contents starting with empty lines caused the crash of the program.


:2013-05-22: Two new modes allow to work with **key [SEP] value** like datas using different separators **[SEP]** and not only the equal sign.


:2013-04-13: One big bug has been fixed : the second level of indentation was ignored in block and line modes.


:2013-04-01: First downloadable version of the package.
""".strip()

setup(
    name         = "orpyste",
    version      = PROJECT_DATE,
    author       = "Christophe BAL",
    author_email = "projetmbc@gmail.com",
    url          = "https://pypi.python.org/pypi/orpyste",
    download_url = "https://pypi.python.org/pypi/orpyste",
    requires     = ['mistool'],
    packages     = [
#    + Main
        'orpyste',
#    + Models
        'orpyste.model',
    ],
    package_dir  = {'orpyste': "orpyste"},
    package_data = {'orpyste': ["change_log/*/*/*.txt"]},
    classifiers  = [
        'Development Status :: 5 - Production/Stable',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: GNU General Public License (GPL)',
        'Programming Language :: Python :: 3',
        'Operating System :: MacOS',
        'Operating System :: Microsoft :: Windows',
        'Operating System :: POSIX :: Linux',
        'Topic :: Utilities',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Topic :: Desktop Environment :: File Managers',
    ],
    description = \
        "A tool for reading yet another simple structured textual data files.",
    long_description = LONG_DESCRIPTION,
)
