#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <pthread.h>

#include <Python.h>

#include <ortp/ortp.h>
#include <ortp/telephonyevents.h>

#include "pyortp.h"

static PyMethodDef ortp_methods[] = {
    {NULL}  /* Sentinel */
};

static PyMethodDef ortp_SessionObject_methods[] = {
    // Configuring
    {"set_local_addr", (PyCFunction)ortp_SessionObject_set_local_addr, METH_VARARGS, "Return the name, combining the first and last name"},
    {"set_remote_addr", (PyCFunction)ortp_SessionObject_set_remote_addr, METH_VARARGS, "Return the name, combining the first and last name"},
    {"enable_rtcp", (PyCFunction)ortp_SessionObject_enable_rtcp, METH_VARARGS, "Return the name, combining the first and last name"},
    {"reset", (PyCFunction)ortp_SessionObject_reset, METH_VARARGS, "Return the name, combining the first and last name"},

    // Sending payload
    {"send_with_ts", (PyCFunction)ortp_SessionObject_send_with_ts, METH_VARARGS, "Return the name, combining the first and last name"},

    // Telephony Events
    {"send_dtmf", (PyCFunction)ortp_SessionObject_send_dtmf, METH_VARARGS, "Return the name, combining the first and last name"},


    {NULL, NULL, 0, NULL}        /* Sentinel */
};

static PyTypeObject ortp_SessionType = {
    PyObject_HEAD_INIT(NULL)
    0,                                                /* ob_size */
    "ortp.Session",                                   /* tp_name */
    sizeof(ortp_SessionObject),                       /* tp_basicsize */
    0,                                                /* tp_itemsize */
    (destructor)ortp_SessionObject_dealloc,           /* tp_dealloc */
    0,                                                /* tp_print */
    0,                                                /* tp_getattr */
    0,                                                /* tp_setattr */
    0,                                                /* tp_compare */
    0,                                                /* tp_repr */
    0,                                                /* tp_as_number */
    0,                                                /* tp_as_sequence */
    0,                                                /* tp_as_mapping */
    0,                                                /* tp_hash */
    0,                                                /* tp_call */
    0,                                                /* tp_str */
    0,                                                /* tp_getattro */
    0,                                                /* tp_setattro */
    0,                                                /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,         /* tp_flags */
    "Session objects",                                /* tp_doc */
    0,                                                /* tp_traverse */
    0,                                                /* tp_clear */
    0,                                                /* tp_richcompare */
    0,                                                /* tp_weaklistoffset */
    0,                                                /* tp_iter */
    0,                                                /* tp_iternext */
    ortp_SessionObject_methods,                       /* tp_methods */
    0, /*Noddy_members, */                            /* tp_members */
    0,                                                /* tp_getset */
    0,                                                /* tp_base */
    0,                                                /* tp_dict */
    0,                                                /* tp_descr_get */
    0,                                                /* tp_descr_set */
    0,                                                /* tp_dictoffset */
    (initproc)ortp_SessionObject_init,                /* tp_init */
    0,                                                /* tp_alloc */
    ortp_SessionObject_new,                           /* tp_new */
};


#ifndef PyMODINIT_FUNC	/* declarations for DLL import/export */
#define PyMODINIT_FUNC void
#endif

PyMODINIT_FUNC initortp(void)
{
    PyObject* m;

    m = Py_InitModule("ortp", ortp_methods);
    if (m == NULL)
        return;


    // Initialize oRTP
    ortp_init();
    ortp_scheduler_init();

    ortp_set_log_level_mask(ORTP_MESSAGE|ORTP_WARNING|ORTP_ERROR);

    /* set the telephony event payload type to 96 in the av profile.*/
    //rtp_profile_set_payload(&av_profile, 96, &payload_type_telephone_event);
    rtp_profile_set_payload(&av_profile, 101, &payload_type_telephone_event);


    // Initialize Python object

    ortp_SessionType.tp_new = PyType_GenericNew;
    if (PyType_Ready(&ortp_SessionType) < 0) {
        return;
    }



    Py_INCREF(&ortp_SessionType);
    PyModule_AddObject(m, "Session", (PyObject *)&ortp_SessionType);

}

static PyObject *
ortp_SessionObject_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
    ortp_SessionObject *self;

    self = (ortp_SessionObject *)type->tp_alloc(type, 0);
    if (self != NULL) {
        self->session = NULL;
    }

    return (PyObject *)self;
}

static void
ortp_SessionObject_dealloc(ortp_SessionObject* self)
{
    //Py_XDECREF(self->first);
    //Py_XDECREF(self->last);
    self->ob_type->tp_free((PyObject*)self);
}

static int
ortp_SessionObject_init(ortp_SessionObject *self, PyObject *args, PyObject *kwds)
{
    //return -1; 
    int ssrc = 1024;

    self->session = rtp_session_new(RTP_SESSION_SENDONLY);

    rtp_session_set_scheduling_mode(self->session, 1);
    rtp_session_set_blocking_mode(self->session, 1);
    rtp_session_set_connected_mode(self->session, TRUE);
    rtp_session_set_payload_type(self->session, 0);
    rtp_session_set_ssrc(self->session, ssrc);

    return 0;
}

static PyObject *
ortp_SessionObject_set_local_addr(ortp_SessionObject* self, PyObject* args)
{
    const char *src_address;
    int rtp_port;
    int rtcp_port = 0;

    if (!PyArg_ParseTuple(args, "si|i", &src_address, &rtp_port, &rtcp_port)) {
        return NULL;
    }

    if (rtcp_port == 0) {
        rtcp_port = rtp_port+1;
    }

    printf("debug: set_local_addr: rtcp_port: %s %d\n", src_address, rtcp_port);

    rtp_session_set_local_addr(self->session, src_address, rtp_port, rtcp_port);

    return Py_BuildValue("");
}

static PyObject *
ortp_SessionObject_set_remote_addr(ortp_SessionObject* self, PyObject* args)
{
    const char *dst_address;
    int dst_port;

    if (!PyArg_ParseTuple(args, "si", &dst_address, &dst_port)) {
        return NULL;
    }

    printf("debug: set_remote_addr: %s:%d\n", dst_address, dst_port);

    rtp_session_set_remote_addr(self->session, dst_address, dst_port);

    return Py_BuildValue("");
}

static PyObject *
ortp_SessionObject_enable_rtcp(ortp_SessionObject* self, PyObject* args)
{
    int enable_rtcp;

    if (!PyArg_ParseTuple(args, "p", &enable_rtcp)) {
        return NULL;
    }

    rtp_session_enable_rtcp(self->session, (bool_t)enable_rtcp);

    return Py_BuildValue("");
}

static PyObject *
ortp_SessionObject_reset(ortp_SessionObject* self, PyObject* args)
{
    if (!PyArg_ParseTuple(args, "")) {
        return NULL;
    }

    rtp_session_reset(self->session);

    return Py_BuildValue("");
}

static PyObject *
ortp_SessionObject_send_with_ts(ortp_SessionObject* self, PyObject* args)
{
    char *buffer;
    int len = 0;
    int user_ts = 0;

    if (!PyArg_ParseTuple(args, "s#|i", &buffer, &len, &user_ts)) {
        return NULL;
    }

    if (len == 0) {
        return NULL;
    }

    // (const uint8_t *)
    rtp_session_send_with_ts(self->session, buffer, len, (uint32_t)user_ts);

    return Py_BuildValue("");
}

static PyObject *
ortp_SessionObject_send_dtmf(ortp_SessionObject* self, PyObject* args)
{
    int user_ts;
    int duration = 3*160;

    if (!PyArg_ParseTuple(args, "i|i", &user_ts, &duration)) {
        return NULL;
    }

    printf("debug: send_dtmf: %d\n", user_ts);

    int rc = rtp_session_send_dtmf2(self->session, '*', (uint32_t)user_ts, duration);

    printf("debug: send_dtmf: rc = %d\n", rc);

    return Py_BuildValue("");
}
