# -*- coding: utf-8 -*-
from os.path import exists
from envoy import run

def osascript(applescript_or_file):
    """osascript applescript code or file
    https://developer.apple.com/library/mac/#documentation/Darwin/Reference/ManPages/man1/osascript.1.html
    """
    if exists(applescript_or_file):
        return run("osascript %s" % applescript_or_file).std_out
    else:
        return run("osascript",applescript_or_file).std_out

def sudo(command):
    """do shell with administrator privileges
    http://developer.apple.com/library/mac/#technotes/tn2065/_index.html"""
    escaped=command.replace('"','\\"')
    cmd='do shell script "%s" with administrator privileges' % escaped
    r=run("osascript",cmd)
    if r.status_code==0:
        return r.std_out
    else:
        raise Exception(r.std_err)