#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Wed Oct 30 11:21:25 2013 by generateDS.py version 2.9a.
#

import sys
import getopt
import re as re_

# Begin NOT_GENERATED
from ovirtsdk.utils.reflectionhelper import ReflectionHelper
from ovirtsdk.utils.comperator import Comparator
# End NOT_GENERATED
import base64
from datetime import datetime, tzinfo, timedelta

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(tzinfo):
            def __init__(self, offset, name):
                self.__offset = timedelta(minutes = offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S')
            else:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S.%f')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_datetime(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S')
            return dt.replace(tzinfo = tz)

        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = input_data.strftime('%Y-%m-%d')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_date(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            return datetime.strptime(input_data,
                '%Y-%m-%d').replace(tzinfo = tz)
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        # Begin NOT_GENERATED
        def __setattr__(self, item, value):
            if (value is not None and
                not isinstance(value, list) and
                ReflectionHelper.isModuleMember(
                    sys.modules['ovirtsdk.infrastructure.brokers'],
                    type(value)) and
                not ReflectionHelper.isModuleMember(sys.modules[__name__],
                    type(value)) and
                value.__dict__.has_key('superclass') and
                value.superclass is not None and
                value.superclass != BaseResource):
                if (ReflectionHelper.isModuleMember(
                        sys.modules['ovirtsdk.infrastructure.brokers'],
                        type(self)) and
                   self.__dict__.has_key('superclass') and
                   self.superclass is not None):
                    object.__setattr__(self.superclass, item, value.superclass)
                else:
                    object.__setattr__(self, item, value.superclass)
            elif (not isinstance(value, list) and
                 ReflectionHelper.isModuleMember(
                         sys.modules['ovirtsdk.infrastructure.brokers'],
                         type(self)) and
                 self.__dict__.has_key('superclass') and
                 self.superclass is not None and
                 not ReflectionHelper.isModuleMember(
                         sys.modules['ovirtsdk.infrastructure.brokers'],
                         type(value)) and
                 item is not 'superclass' and
                 item is not 'parentclass'):
                object.__setattr__(self.superclass, item, value)
            elif isinstance(value, list):
                parsed_list = []
                for obj in value:
                    if (ReflectionHelper.isModuleMember(
                            sys.modules['ovirtsdk.infrastructure.brokers'],
                            type(obj)) and
                       obj.__dict__.has_key('superclass') and
                       obj.superclass is not None and
                       item is not 'superclass' and
                       item is not 'parentclass'):
                        parsed_list.append(obj.superclass)
                    else:
                        parsed_list.append(obj)
                object.__setattr__(self, item, parsed_list)
            else:
                object.__setattr__(self, item, value)

        def __eq__(self, other):
            return Comparator.compare(self, other)

        def __ne__(self, other):
            return not self.__eq__(other)
        # End NOT_GENERATED


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'UTF-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' %
                (self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class KeyValuePair(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value
    def factory(*args_, **kwargs_):
        if KeyValuePair.subclass:
            return KeyValuePair.subclass(*args_, **kwargs_)
        else:
            return KeyValuePair(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_key(self): return self.key
    def set_key(self, key): self.key = key
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def hasContent_(self):
        if (
            self.key is not None or
            self.value is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='KeyValuePair', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='KeyValuePair')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='KeyValuePair'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='KeyValuePair', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.key is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skey>%s</%skey>%s' % (namespace_, self.gds_format_string(quote_xml(self.key).encode(ExternalEncoding), input_name='key'), namespace_, eol_))
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(self.value).encode(ExternalEncoding), input_name='value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='KeyValuePair'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.key is not None:
            showIndent(outfile, level)
            outfile.write('key=%s,\n' % quote_python(self.key).encode(ExternalEncoding))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'key':
            key_ = child_.text
            key_ = self.gds_validate_string(key_, node, 'key')
            self.key = key_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
# end class KeyValuePair


class LinkCapabilities(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, searchable=None):
        self.searchable = searchable
    def factory(*args_, **kwargs_):
        if LinkCapabilities.subclass:
            return LinkCapabilities.subclass(*args_, **kwargs_)
        else:
            return LinkCapabilities(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_searchable(self): return self.searchable
    def set_searchable(self, searchable): self.searchable = searchable
    def hasContent_(self):
        if (
            self.searchable is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LinkCapabilities', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LinkCapabilities')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LinkCapabilities'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='LinkCapabilities', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.searchable is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssearchable>%s</%ssearchable>%s' % (namespace_, self.gds_format_boolean(self.searchable, input_name='searchable'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='LinkCapabilities'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.searchable is not None:
            showIndent(outfile, level)
            outfile.write('searchable=%s,\n' % self.searchable)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'searchable':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'searchable')
            self.searchable = ival_
# end class LinkCapabilities


class DetailedLinks(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, link=None):
        if link is None:
            self.link = []
        else:
            self.link = link
    def factory(*args_, **kwargs_):
        if DetailedLinks.subclass:
            return DetailedLinks.subclass(*args_, **kwargs_)
        else:
            return DetailedLinks(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_link(self): return self.link
    def set_link(self, link): self.link = link
    def add_link(self, value): self.link.append(value)
    def insert_link(self, index, value): self.link[index] = value
    def hasContent_(self):
        if (
            self.link
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DetailedLinks', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DetailedLinks')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DetailedLinks'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='DetailedLinks', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for link_ in self.link:
            link_.export(outfile, level, namespace_, name_='link', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='DetailedLinks'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('link=[\n')
        level += 1
        for link_ in self.link:
            showIndent(outfile, level)
            outfile.write('model_.DetailedLink(\n')
            link_.exportLiteral(outfile, level, name_='DetailedLink')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'link':
            class_obj_ = self.get_class_obj_(child_, DetailedLink)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.link.append(obj_)
# end class DetailedLinks


class Link(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, href=None, rel=None, extensiontype_=None):
        self.href = _cast(None, href)
        self.rel = _cast(None, rel)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if Link.subclass:
            return Link.subclass(*args_, **kwargs_)
        else:
            return Link(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_rel(self): return self.rel
    def set_rel(self, rel): self.rel = rel
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Link', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Link')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Link'):
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (self.gds_format_string(quote_attrib(self.href).encode(ExternalEncoding), input_name='href'), ))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            outfile.write(' rel=%s' % (self.gds_format_string(quote_attrib(self.rel).encode(ExternalEncoding), input_name='rel'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='Link', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='Link'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            showIndent(outfile, level)
            outfile.write('href = "%s",\n' % (self.href,))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            showIndent(outfile, level)
            outfile.write('rel = "%s",\n' % (self.rel,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('rel', node)
        if value is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            self.rel = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Link


class ApiSummary(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vms=None, hosts=None, users=None, storage_domains=None):
        self.vms = vms
        self.hosts = hosts
        self.users = users
        self.storage_domains = storage_domains
    def factory(*args_, **kwargs_):
        if ApiSummary.subclass:
            return ApiSummary.subclass(*args_, **kwargs_)
        else:
            return ApiSummary(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vms(self): return self.vms
    def set_vms(self, vms): self.vms = vms
    def get_hosts(self): return self.hosts
    def set_hosts(self, hosts): self.hosts = hosts
    def get_users(self): return self.users
    def set_users(self, users): self.users = users
    def get_storage_domains(self): return self.storage_domains
    def set_storage_domains(self, storage_domains): self.storage_domains = storage_domains
    def hasContent_(self):
        if (
            self.vms is not None or
            self.hosts is not None or
            self.users is not None or
            self.storage_domains is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ApiSummary', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ApiSummary')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ApiSummary'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ApiSummary', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.vms is not None:
            self.vms.export(outfile, level, namespace_, name_='vms', pretty_print=pretty_print)
        if self.hosts is not None:
            self.hosts.export(outfile, level, namespace_, name_='hosts', pretty_print=pretty_print)
        if self.users is not None:
            self.users.export(outfile, level, namespace_, name_='users', pretty_print=pretty_print)
        if self.storage_domains is not None:
            self.storage_domains.export(outfile, level, namespace_, name_='storage_domains', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ApiSummary'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.vms is not None:
            showIndent(outfile, level)
            outfile.write('vms=model_.vms(\n')
            self.vms.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.hosts is not None:
            showIndent(outfile, level)
            outfile.write('hosts=model_.hosts(\n')
            self.hosts.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.users is not None:
            showIndent(outfile, level)
            outfile.write('users=model_.users(\n')
            self.users.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.storage_domains is not None:
            showIndent(outfile, level)
            outfile.write('storage_domains=model_.storage_domains(\n')
            self.storage_domains.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vms':
            obj_ = VMs.factory()
            obj_.build(child_)
            self.set_vms(obj_)
        elif nodeName_ == 'hosts':
            obj_ = Hosts.factory()
            obj_.build(child_)
            self.set_hosts(obj_)
        elif nodeName_ == 'users':
            obj_ = Users.factory()
            obj_.build(child_)
            self.set_users(obj_)
        elif nodeName_ == 'storage_domains':
            obj_ = StorageDomains.factory()
            obj_.build(child_)
            self.set_storage_domains(obj_)
# end class ApiSummary


class Fault(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, reason=None, detail=None):
        self.reason = reason
        self.detail = detail
    def factory(*args_, **kwargs_):
        if Fault.subclass:
            return Fault.subclass(*args_, **kwargs_)
        else:
            return Fault(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_reason(self): return self.reason
    def set_reason(self, reason): self.reason = reason
    def get_detail(self): return self.detail
    def set_detail(self, detail): self.detail = detail
    def hasContent_(self):
        if (
            self.reason is not None or
            self.detail is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Fault', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Fault')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Fault'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Fault', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.reason is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreason>%s</%sreason>%s' % (namespace_, self.gds_format_string(quote_xml(self.reason).encode(ExternalEncoding), input_name='reason'), namespace_, eol_))
        if self.detail is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetail>%s</%sdetail>%s' % (namespace_, self.gds_format_string(quote_xml(self.detail).encode(ExternalEncoding), input_name='detail'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Fault'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.reason is not None:
            showIndent(outfile, level)
            outfile.write('reason=%s,\n' % quote_python(self.reason).encode(ExternalEncoding))
        if self.detail is not None:
            showIndent(outfile, level)
            outfile.write('detail=%s,\n' % quote_python(self.detail).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'reason':
            reason_ = child_.text
            reason_ = self.gds_validate_string(reason_, node, 'reason')
            self.reason = reason_
        elif nodeName_ == 'detail':
            detail_ = child_.text
            detail_ = self.gds_validate_string(detail_, node, 'detail')
            self.detail = detail_
# end class Fault


class GracePeriod(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, expiry=None):
        self.expiry = expiry
    def factory(*args_, **kwargs_):
        if GracePeriod.subclass:
            return GracePeriod.subclass(*args_, **kwargs_)
        else:
            return GracePeriod(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_expiry(self): return self.expiry
    def set_expiry(self, expiry): self.expiry = expiry
    def hasContent_(self):
        if (
            self.expiry is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GracePeriod', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GracePeriod')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GracePeriod'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='GracePeriod', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.expiry is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sexpiry>%s</%sexpiry>%s' % (namespace_, self.gds_format_integer(self.expiry, input_name='expiry'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='GracePeriod'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.expiry is not None:
            showIndent(outfile, level)
            outfile.write('expiry=%d,\n' % self.expiry)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'expiry':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'expiry')
            self.expiry = ival_
# end class GracePeriod


class IscsiDetails(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, initiator=None, port=None, target=None, username=None, password=None, portal=None, address=None, serial=None, vendor_id=None, product_id=None, lun_mapping=None, size=None, paths=None, status=None, volume_group_id=None, storage_domain_id=None, disk_id=None):
        self.initiator = initiator
        self.port = port
        self.target = target
        self.username = username
        self.password = password
        self.portal = portal
        self.address = address
        self.serial = serial
        self.vendor_id = vendor_id
        self.product_id = product_id
        self.lun_mapping = lun_mapping
        self.size = size
        self.paths = paths
        self.status = status
        self.volume_group_id = volume_group_id
        self.storage_domain_id = storage_domain_id
        self.disk_id = disk_id
    def factory(*args_, **kwargs_):
        if IscsiDetails.subclass:
            return IscsiDetails.subclass(*args_, **kwargs_)
        else:
            return IscsiDetails(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_initiator(self): return self.initiator
    def set_initiator(self, initiator): self.initiator = initiator
    def get_port(self): return self.port
    def set_port(self, port): self.port = port
    def get_target(self): return self.target
    def set_target(self, target): self.target = target
    def get_username(self): return self.username
    def set_username(self, username): self.username = username
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_portal(self): return self.portal
    def set_portal(self, portal): self.portal = portal
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_serial(self): return self.serial
    def set_serial(self, serial): self.serial = serial
    def get_vendor_id(self): return self.vendor_id
    def set_vendor_id(self, vendor_id): self.vendor_id = vendor_id
    def get_product_id(self): return self.product_id
    def set_product_id(self, product_id): self.product_id = product_id
    def get_lun_mapping(self): return self.lun_mapping
    def set_lun_mapping(self, lun_mapping): self.lun_mapping = lun_mapping
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def get_paths(self): return self.paths
    def set_paths(self, paths): self.paths = paths
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_volume_group_id(self): return self.volume_group_id
    def set_volume_group_id(self, volume_group_id): self.volume_group_id = volume_group_id
    def get_storage_domain_id(self): return self.storage_domain_id
    def set_storage_domain_id(self, storage_domain_id): self.storage_domain_id = storage_domain_id
    def get_disk_id(self): return self.disk_id
    def set_disk_id(self, disk_id): self.disk_id = disk_id
    def hasContent_(self):
        if (
            self.initiator is not None or
            self.port is not None or
            self.target is not None or
            self.username is not None or
            self.password is not None or
            self.portal is not None or
            self.address is not None or
            self.serial is not None or
            self.vendor_id is not None or
            self.product_id is not None or
            self.lun_mapping is not None or
            self.size is not None or
            self.paths is not None or
            self.status is not None or
            self.volume_group_id is not None or
            self.storage_domain_id is not None or
            self.disk_id is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IscsiDetails', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IscsiDetails')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IscsiDetails'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='IscsiDetails', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.initiator is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinitiator>%s</%sinitiator>%s' % (namespace_, self.gds_format_string(quote_xml(self.initiator).encode(ExternalEncoding), input_name='initiator'), namespace_, eol_))
        if self.port is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sport>%s</%sport>%s' % (namespace_, self.gds_format_integer(self.port, input_name='port'), namespace_, eol_))
        if self.target is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%starget>%s</%starget>%s' % (namespace_, self.gds_format_string(quote_xml(self.target).encode(ExternalEncoding), input_name='target'), namespace_, eol_))
        if self.username is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%susername>%s</%susername>%s' % (namespace_, self.gds_format_string(quote_xml(self.username).encode(ExternalEncoding), input_name='username'), namespace_, eol_))
        if self.password is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespace_, self.gds_format_string(quote_xml(self.password).encode(ExternalEncoding), input_name='password'), namespace_, eol_))
        if self.portal is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sportal>%s</%sportal>%s' % (namespace_, self.gds_format_string(quote_xml(self.portal).encode(ExternalEncoding), input_name='portal'), namespace_, eol_))
        if self.address is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress>%s</%saddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_, eol_))
        if self.serial is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sserial>%s</%sserial>%s' % (namespace_, self.gds_format_string(quote_xml(self.serial).encode(ExternalEncoding), input_name='serial'), namespace_, eol_))
        if self.vendor_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svendor_id>%s</%svendor_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.vendor_id).encode(ExternalEncoding), input_name='vendor_id'), namespace_, eol_))
        if self.product_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sproduct_id>%s</%sproduct_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.product_id).encode(ExternalEncoding), input_name='product_id'), namespace_, eol_))
        if self.lun_mapping is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slun_mapping>%s</%slun_mapping>%s' % (namespace_, self.gds_format_integer(self.lun_mapping, input_name='lun_mapping'), namespace_, eol_))
        if self.size is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssize>%s</%ssize>%s' % (namespace_, self.gds_format_integer(self.size, input_name='size'), namespace_, eol_))
        if self.paths is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spaths>%s</%spaths>%s' % (namespace_, self.gds_format_integer(self.paths, input_name='paths'), namespace_, eol_))
        if self.status is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstatus>%s</%sstatus>%s' % (namespace_, self.gds_format_string(quote_xml(self.status).encode(ExternalEncoding), input_name='status'), namespace_, eol_))
        if self.volume_group_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svolume_group_id>%s</%svolume_group_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.volume_group_id).encode(ExternalEncoding), input_name='volume_group_id'), namespace_, eol_))
        if self.storage_domain_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstorage_domain_id>%s</%sstorage_domain_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.storage_domain_id).encode(ExternalEncoding), input_name='storage_domain_id'), namespace_, eol_))
        if self.disk_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisk_id>%s</%sdisk_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.disk_id).encode(ExternalEncoding), input_name='disk_id'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='IscsiDetails'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.initiator is not None:
            showIndent(outfile, level)
            outfile.write('initiator=%s,\n' % quote_python(self.initiator).encode(ExternalEncoding))
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('port=%d,\n' % self.port)
        if self.target is not None:
            showIndent(outfile, level)
            outfile.write('target=%s,\n' % quote_python(self.target).encode(ExternalEncoding))
        if self.username is not None:
            showIndent(outfile, level)
            outfile.write('username=%s,\n' % quote_python(self.username).encode(ExternalEncoding))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % quote_python(self.password).encode(ExternalEncoding))
        if self.portal is not None:
            showIndent(outfile, level)
            outfile.write('portal=%s,\n' % quote_python(self.portal).encode(ExternalEncoding))
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.serial is not None:
            showIndent(outfile, level)
            outfile.write('serial=%s,\n' % quote_python(self.serial).encode(ExternalEncoding))
        if self.vendor_id is not None:
            showIndent(outfile, level)
            outfile.write('vendor_id=%s,\n' % quote_python(self.vendor_id).encode(ExternalEncoding))
        if self.product_id is not None:
            showIndent(outfile, level)
            outfile.write('product_id=%s,\n' % quote_python(self.product_id).encode(ExternalEncoding))
        if self.lun_mapping is not None:
            showIndent(outfile, level)
            outfile.write('lun_mapping=%d,\n' % self.lun_mapping)
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % self.size)
        if self.paths is not None:
            showIndent(outfile, level)
            outfile.write('paths=%d,\n' % self.paths)
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=%s,\n' % quote_python(self.status).encode(ExternalEncoding))
        if self.volume_group_id is not None:
            showIndent(outfile, level)
            outfile.write('volume_group_id=%s,\n' % quote_python(self.volume_group_id).encode(ExternalEncoding))
        if self.storage_domain_id is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain_id=%s,\n' % quote_python(self.storage_domain_id).encode(ExternalEncoding))
        if self.disk_id is not None:
            showIndent(outfile, level)
            outfile.write('disk_id=%s,\n' % quote_python(self.disk_id).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'initiator':
            initiator_ = child_.text
            initiator_ = self.gds_validate_string(initiator_, node, 'initiator')
            self.initiator = initiator_
        elif nodeName_ == 'port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'port')
            self.port = ival_
        elif nodeName_ == 'target':
            target_ = child_.text
            target_ = self.gds_validate_string(target_, node, 'target')
            self.target = target_
        elif nodeName_ == 'username':
            username_ = child_.text
            username_ = self.gds_validate_string(username_, node, 'username')
            self.username = username_
        elif nodeName_ == 'password':
            password_ = child_.text
            password_ = self.gds_validate_string(password_, node, 'password')
            self.password = password_
        elif nodeName_ == 'portal':
            portal_ = child_.text
            portal_ = self.gds_validate_string(portal_, node, 'portal')
            self.portal = portal_
        elif nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'serial':
            serial_ = child_.text
            serial_ = self.gds_validate_string(serial_, node, 'serial')
            self.serial = serial_
        elif nodeName_ == 'vendor_id':
            vendor_id_ = child_.text
            vendor_id_ = self.gds_validate_string(vendor_id_, node, 'vendor_id')
            self.vendor_id = vendor_id_
        elif nodeName_ == 'product_id':
            product_id_ = child_.text
            product_id_ = self.gds_validate_string(product_id_, node, 'product_id')
            self.product_id = product_id_
        elif nodeName_ == 'lun_mapping':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'lun_mapping')
            self.lun_mapping = ival_
        elif nodeName_ == 'size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'size')
            self.size = ival_
        elif nodeName_ == 'paths':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'paths')
            self.paths = ival_
        elif nodeName_ == 'status':
            status_ = child_.text
            status_ = self.gds_validate_string(status_, node, 'status')
            self.status = status_
        elif nodeName_ == 'volume_group_id':
            volume_group_id_ = child_.text
            volume_group_id_ = self.gds_validate_string(volume_group_id_, node, 'volume_group_id')
            self.volume_group_id = volume_group_id_
        elif nodeName_ == 'storage_domain_id':
            storage_domain_id_ = child_.text
            storage_domain_id_ = self.gds_validate_string(storage_domain_id_, node, 'storage_domain_id')
            self.storage_domain_id = storage_domain_id_
        elif nodeName_ == 'disk_id':
            disk_id_ = child_.text
            disk_id_ = self.gds_validate_string(disk_id_, node, 'disk_id')
            self.disk_id = disk_id_
# end class IscsiDetails


class Actions(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, link=None):
        if link is None:
            self.link = []
        else:
            self.link = link
    def factory(*args_, **kwargs_):
        if Actions.subclass:
            return Actions.subclass(*args_, **kwargs_)
        else:
            return Actions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_link(self): return self.link
    def set_link(self, link): self.link = link
    def add_link(self, value): self.link.append(value)
    def insert_link(self, index, value): self.link[index] = value
    def hasContent_(self):
        if (
            self.link
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Actions', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Actions')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Actions'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Actions', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for link_ in self.link:
            link_.export(outfile, level, namespace_, name_='link', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Actions'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('link=[\n')
        level += 1
        for link_ in self.link:
            showIndent(outfile, level)
            outfile.write('model_.link(\n')
            link_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'link':
            class_obj_ = self.get_class_obj_(child_, Link)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.link.append(obj_)
# end class Actions


class Status(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, state=None, detail=None):
        self.state = state
        self.detail = detail
    def factory(*args_, **kwargs_):
        if Status.subclass:
            return Status.subclass(*args_, **kwargs_)
        else:
            return Status(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def get_detail(self): return self.detail
    def set_detail(self, detail): self.detail = detail
    def hasContent_(self):
        if (
            self.state is not None or
            self.detail is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Status', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Status')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Status'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Status', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.state is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstate>%s</%sstate>%s' % (namespace_, self.gds_format_string(quote_xml(self.state).encode(ExternalEncoding), input_name='state'), namespace_, eol_))
        if self.detail is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetail>%s</%sdetail>%s' % (namespace_, self.gds_format_string(quote_xml(self.detail).encode(ExternalEncoding), input_name='detail'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Status'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.state is not None:
            showIndent(outfile, level)
            outfile.write('state=%s,\n' % quote_python(self.state).encode(ExternalEncoding))
        if self.detail is not None:
            showIndent(outfile, level)
            outfile.write('detail=%s,\n' % quote_python(self.detail).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'state':
            state_ = child_.text
            state_ = self.gds_validate_string(state_, node, 'state')
            self.state = state_
        elif nodeName_ == 'detail':
            detail_ = child_.text
            detail_ = self.gds_validate_string(detail_, node, 'detail')
            self.detail = detail_
# end class Status


class Usages(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, usage=None):
        if usage is None:
            self.usage = []
        else:
            self.usage = usage
    def factory(*args_, **kwargs_):
        if Usages.subclass:
            return Usages.subclass(*args_, **kwargs_)
        else:
            return Usages(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_usage(self): return self.usage
    def set_usage(self, usage): self.usage = usage
    def add_usage(self, value): self.usage.append(value)
    def insert_usage(self, index, value): self.usage[index] = value
    def hasContent_(self):
        if (
            self.usage
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Usages', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Usages')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Usages'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Usages', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for usage_ in self.usage:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%susage>%s</%susage>%s' % (namespace_, self.gds_format_string(quote_xml(usage_).encode(ExternalEncoding), input_name='usage'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Usages'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('usage=[\n')
        level += 1
        for usage_ in self.usage:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(usage_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'usage':
            usage_ = child_.text
            usage_ = self.gds_validate_string(usage_, node, 'usage')
            self.usage.append(usage_)
# end class Usages


class CreationStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, creation_state=None):
        if creation_state is None:
            self.creation_state = []
        else:
            self.creation_state = creation_state
    def factory(*args_, **kwargs_):
        if CreationStates.subclass:
            return CreationStates.subclass(*args_, **kwargs_)
        else:
            return CreationStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_creation_state(self): return self.creation_state
    def set_creation_state(self, creation_state): self.creation_state = creation_state
    def add_creation_state(self, value): self.creation_state.append(value)
    def insert_creation_state(self, index, value): self.creation_state[index] = value
    def hasContent_(self):
        if (
            self.creation_state
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CreationStates', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CreationStates')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CreationStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='CreationStates', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for creation_state_ in self.creation_state:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%screation_state>%s</%screation_state>%s' % (namespace_, self.gds_format_string(quote_xml(creation_state_).encode(ExternalEncoding), input_name='creation_state'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='CreationStates'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('creation_state=[\n')
        level += 1
        for creation_state_ in self.creation_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(creation_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'creation_state':
            creation_state_ = child_.text
            creation_state_ = self.gds_validate_string(creation_state_, node, 'creation_state')
            self.creation_state.append(creation_state_)
# end class CreationStates


class Value(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, datum=None):
        self.datum = datum
    def factory(*args_, **kwargs_):
        if Value.subclass:
            return Value.subclass(*args_, **kwargs_)
        else:
            return Value(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datum(self): return self.datum
    def set_datum(self, datum): self.datum = datum
    def hasContent_(self):
        if (
            self.datum is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Value', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Value')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Value'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Value', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.datum is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdatum>%s</%sdatum>%s' % (namespace_, self.gds_format_float(self.datum, input_name='datum'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Value'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.datum is not None:
            showIndent(outfile, level)
            outfile.write('datum=%f,\n' % self.datum)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'datum':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'datum')
            self.datum = fval_
# end class Value


class Values(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, value=None):
        self.type_ = _cast(None, type_)
        if value is None:
            self.value = []
        else:
            self.value = value
    def factory(*args_, **kwargs_):
        if Values.subclass:
            return Values.subclass(*args_, **kwargs_)
        else:
            return Values(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def add_value(self, value): self.value.append(value)
    def insert_value(self, index, value): self.value[index] = value
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def validate_ValueType(self, value):
        # Validate type ValueType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.value
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Values', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Values')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Values'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Values', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for value_ in self.value:
            value_.export(outfile, level, namespace_, name_='value', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Values'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('value=[\n')
        level += 1
        for value_ in self.value:
            showIndent(outfile, level)
            outfile.write('model_.value(\n')
            value_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
            self.validate_ValueType(self.type_)    # validate type ValueType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'value':
            obj_ = Value.factory()
            obj_.build(child_)
            self.value.append(obj_)
# end class Values


class CpuTopology(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, cores=None, threads=None, sockets=None):
        self.cores = _cast(int, cores)
        self.threads = _cast(int, threads)
        self.sockets = _cast(int, sockets)
        pass
    def factory(*args_, **kwargs_):
        if CpuTopology.subclass:
            return CpuTopology.subclass(*args_, **kwargs_)
        else:
            return CpuTopology(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cores(self): return self.cores
    def set_cores(self, cores): self.cores = cores
    def get_threads(self): return self.threads
    def set_threads(self, threads): self.threads = threads
    def get_sockets(self): return self.sockets
    def set_sockets(self, sockets): self.sockets = sockets
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CpuTopology', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CpuTopology')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CpuTopology'):
        if self.cores is not None and 'cores' not in already_processed:
            already_processed.add('cores')
            outfile.write(' cores="%s"' % self.gds_format_integer(self.cores, input_name='cores'))
        if self.threads is not None and 'threads' not in already_processed:
            already_processed.add('threads')
            outfile.write(' threads="%s"' % self.gds_format_integer(self.threads, input_name='threads'))
        if self.sockets is not None and 'sockets' not in already_processed:
            already_processed.add('sockets')
            outfile.write(' sockets="%s"' % self.gds_format_integer(self.sockets, input_name='sockets'))
    def exportChildren(self, outfile, level, namespace_='', name_='CpuTopology', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='CpuTopology'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.cores is not None and 'cores' not in already_processed:
            already_processed.add('cores')
            showIndent(outfile, level)
            outfile.write('cores = %d,\n' % (self.cores,))
        if self.threads is not None and 'threads' not in already_processed:
            already_processed.add('threads')
            showIndent(outfile, level)
            outfile.write('threads = %d,\n' % (self.threads,))
        if self.sockets is not None and 'sockets' not in already_processed:
            already_processed.add('sockets')
            showIndent(outfile, level)
            outfile.write('sockets = %d,\n' % (self.sockets,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('cores', node)
        if value is not None and 'cores' not in already_processed:
            already_processed.add('cores')
            try:
                self.cores = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('threads', node)
        if value is not None and 'threads' not in already_processed:
            already_processed.add('threads')
            try:
                self.threads = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('sockets', node)
        if value is not None and 'sockets' not in already_processed:
            already_processed.add('sockets')
            try:
                self.sockets = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class CpuTopology


class VCpuPin(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vcpu=None, cpu_set=None):
        self.vcpu = _cast(int, vcpu)
        self.cpu_set = _cast(None, cpu_set)
        pass
    def factory(*args_, **kwargs_):
        if VCpuPin.subclass:
            return VCpuPin.subclass(*args_, **kwargs_)
        else:
            return VCpuPin(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vcpu(self): return self.vcpu
    def set_vcpu(self, vcpu): self.vcpu = vcpu
    def get_cpu_set(self): return self.cpu_set
    def set_cpu_set(self, cpu_set): self.cpu_set = cpu_set
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VCpuPin', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VCpuPin')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VCpuPin'):
        if self.vcpu is not None and 'vcpu' not in already_processed:
            already_processed.add('vcpu')
            outfile.write(' vcpu="%s"' % self.gds_format_integer(self.vcpu, input_name='vcpu'))
        if self.cpu_set is not None and 'cpu_set' not in already_processed:
            already_processed.add('cpu_set')
            outfile.write(' cpu_set=%s' % (self.gds_format_string(quote_attrib(self.cpu_set).encode(ExternalEncoding), input_name='cpu_set'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='VCpuPin', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='VCpuPin'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.vcpu is not None and 'vcpu' not in already_processed:
            already_processed.add('vcpu')
            showIndent(outfile, level)
            outfile.write('vcpu = %d,\n' % (self.vcpu,))
        if self.cpu_set is not None and 'cpu_set' not in already_processed:
            already_processed.add('cpu_set')
            showIndent(outfile, level)
            outfile.write('cpu_set = "%s",\n' % (self.cpu_set,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('vcpu', node)
        if value is not None and 'vcpu' not in already_processed:
            already_processed.add('vcpu')
            try:
                self.vcpu = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('cpu_set', node)
        if value is not None and 'cpu_set' not in already_processed:
            already_processed.add('cpu_set')
            self.cpu_set = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class VCpuPin


class CpuTune(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vcpu_pin=None):
        if vcpu_pin is None:
            self.vcpu_pin = []
        else:
            self.vcpu_pin = vcpu_pin
    def factory(*args_, **kwargs_):
        if CpuTune.subclass:
            return CpuTune.subclass(*args_, **kwargs_)
        else:
            return CpuTune(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vcpu_pin(self): return self.vcpu_pin
    def set_vcpu_pin(self, vcpu_pin): self.vcpu_pin = vcpu_pin
    def add_vcpu_pin(self, value): self.vcpu_pin.append(value)
    def insert_vcpu_pin(self, index, value): self.vcpu_pin[index] = value
    def hasContent_(self):
        if (
            self.vcpu_pin
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CpuTune', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CpuTune')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CpuTune'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='CpuTune', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for vcpu_pin_ in self.vcpu_pin:
            vcpu_pin_.export(outfile, level, namespace_, name_='vcpu_pin', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='CpuTune'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('vcpu_pin=[\n')
        level += 1
        for vcpu_pin_ in self.vcpu_pin:
            showIndent(outfile, level)
            outfile.write('model_.vcpu_pin(\n')
            vcpu_pin_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vcpu_pin':
            obj_ = VCpuPin.factory()
            obj_.build(child_)
            self.vcpu_pin.append(obj_)
# end class CpuTune


class CPU(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, topology=None, level=None, name=None, speed=None, cpu_tune=None, mode=None):
        self.id = _cast(None, id)
        self.topology = topology
        self.level = level
        self.name = name
        self.speed = speed
        self.cpu_tune = cpu_tune
        self.mode = mode
    def factory(*args_, **kwargs_):
        if CPU.subclass:
            return CPU.subclass(*args_, **kwargs_)
        else:
            return CPU(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_topology(self): return self.topology
    def set_topology(self, topology): self.topology = topology
    def get_level(self): return self.level
    def set_level(self, level): self.level = level
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_speed(self): return self.speed
    def set_speed(self, speed): self.speed = speed
    def get_cpu_tune(self): return self.cpu_tune
    def set_cpu_tune(self, cpu_tune): self.cpu_tune = cpu_tune
    def get_mode(self): return self.mode
    def set_mode(self, mode): self.mode = mode
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def hasContent_(self):
        if (
            self.topology is not None or
            self.level is not None or
            self.name is not None or
            self.speed is not None or
            self.cpu_tune is not None or
            self.mode is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CPU', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CPU')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CPU'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='CPU', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.topology is not None:
            self.topology.export(outfile, level, namespace_, name_='topology', pretty_print=pretty_print)
        if self.level is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slevel>%s</%slevel>%s' % (namespace_, self.gds_format_integer(self.level, input_name='level'), namespace_, eol_))
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_, eol_))
        if self.speed is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sspeed>%s</%sspeed>%s' % (namespace_, self.gds_format_float(self.speed, input_name='speed'), namespace_, eol_))
        if self.cpu_tune is not None:
            self.cpu_tune.export(outfile, level, namespace_, name_='cpu_tune', pretty_print=pretty_print)
        if self.mode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smode>%s</%smode>%s' % (namespace_, self.gds_format_string(quote_xml(self.mode).encode(ExternalEncoding), input_name='mode'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='CPU'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.topology is not None:
            showIndent(outfile, level)
            outfile.write('topology=model_.CpuTopology(\n')
            self.topology.exportLiteral(outfile, level, name_='topology')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.level is not None:
            showIndent(outfile, level)
            outfile.write('level=%d,\n' % self.level)
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        if self.speed is not None:
            showIndent(outfile, level)
            outfile.write('speed=%f,\n' % self.speed)
        if self.cpu_tune is not None:
            showIndent(outfile, level)
            outfile.write('cpu_tune=model_.CpuTune(\n')
            self.cpu_tune.exportLiteral(outfile, level, name_='cpu_tune')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.mode is not None:
            showIndent(outfile, level)
            outfile.write('mode=%s,\n' % quote_python(self.mode).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'topology':
            obj_ = CpuTopology.factory()
            obj_.build(child_)
            self.set_topology(obj_)
        elif nodeName_ == 'level':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'level')
            self.level = ival_
        elif nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'speed':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'speed')
            self.speed = fval_
        elif nodeName_ == 'cpu_tune':
            obj_ = CpuTune.factory()
            obj_.build(child_)
            self.set_cpu_tune(obj_)
        elif nodeName_ == 'mode':
            mode_ = child_.text
            mode_ = self.gds_validate_string(mode_, node, 'mode')
            self.mode = mode_
# end class CPU


class CPUs(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, cpu=None):
        if cpu is None:
            self.cpu = []
        else:
            self.cpu = cpu
    def factory(*args_, **kwargs_):
        if CPUs.subclass:
            return CPUs.subclass(*args_, **kwargs_)
        else:
            return CPUs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cpu(self): return self.cpu
    def set_cpu(self, cpu): self.cpu = cpu
    def add_cpu(self, value): self.cpu.append(value)
    def insert_cpu(self, index, value): self.cpu[index] = value
    def hasContent_(self):
        if (
            self.cpu
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CPUs', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CPUs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CPUs'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='CPUs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for cpu_ in self.cpu:
            cpu_.export(outfile, level, namespace_, name_='cpu', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='CPUs'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('cpu=[\n')
        level += 1
        for cpu_ in self.cpu:
            showIndent(outfile, level)
            outfile.write('model_.cpu(\n')
            cpu_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'cpu':
            obj_ = CPU.factory()
            obj_.build(child_)
            self.cpu.append(obj_)
# end class CPUs


class SupportedVersions(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, version=None):
        if version is None:
            self.version = []
        else:
            self.version = version
    def factory(*args_, **kwargs_):
        if SupportedVersions.subclass:
            return SupportedVersions.subclass(*args_, **kwargs_)
        else:
            return SupportedVersions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def add_version(self, value): self.version.append(value)
    def insert_version(self, index, value): self.version[index] = value
    def hasContent_(self):
        if (
            self.version
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SupportedVersions', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SupportedVersions')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SupportedVersions'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='SupportedVersions', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for version_ in self.version:
            version_.export(outfile, level, namespace_, name_='version', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SupportedVersions'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('version=[\n')
        level += 1
        for version_ in self.version:
            showIndent(outfile, level)
            outfile.write('model_.Version(\n')
            version_.exportLiteral(outfile, level, name_='Version')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'version':
            class_obj_ = self.get_class_obj_(child_, Version)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.version.append(obj_)
# end class SupportedVersions


class ErrorHandling(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, on_error=None):
        self.on_error = on_error
    def factory(*args_, **kwargs_):
        if ErrorHandling.subclass:
            return ErrorHandling.subclass(*args_, **kwargs_)
        else:
            return ErrorHandling(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_on_error(self): return self.on_error
    def set_on_error(self, on_error): self.on_error = on_error
    def hasContent_(self):
        if (
            self.on_error is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ErrorHandling', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ErrorHandling')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ErrorHandling'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ErrorHandling', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.on_error is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%son_error>%s</%son_error>%s' % (namespace_, self.gds_format_string(quote_xml(self.on_error).encode(ExternalEncoding), input_name='on_error'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='ErrorHandling'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.on_error is not None:
            showIndent(outfile, level)
            outfile.write('on_error=%s,\n' % quote_python(self.on_error).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'on_error':
            on_error_ = child_.text
            on_error_ = self.gds_validate_string(on_error_, node, 'on_error')
            self.on_error = on_error_
# end class ErrorHandling


class SchedulingPolicies(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, policy=None):
        if policy is None:
            self.policy = []
        else:
            self.policy = policy
    def factory(*args_, **kwargs_):
        if SchedulingPolicies.subclass:
            return SchedulingPolicies.subclass(*args_, **kwargs_)
        else:
            return SchedulingPolicies(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_policy(self): return self.policy
    def set_policy(self, policy): self.policy = policy
    def add_policy(self, value): self.policy.append(value)
    def insert_policy(self, index, value): self.policy[index] = value
    def hasContent_(self):
        if (
            self.policy
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SchedulingPolicies', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SchedulingPolicies')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SchedulingPolicies'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='SchedulingPolicies', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for policy_ in self.policy:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spolicy>%s</%spolicy>%s' % (namespace_, self.gds_format_string(quote_xml(policy_).encode(ExternalEncoding), input_name='policy'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='SchedulingPolicies'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('policy=[\n')
        level += 1
        for policy_ in self.policy:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(policy_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'policy':
            policy_ = child_.text
            policy_ = self.gds_validate_string(policy_, node, 'policy')
            self.policy.append(policy_)
# end class SchedulingPolicies


class Features(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, feature=None):
        if feature is None:
            self.feature = []
        else:
            self.feature = feature
    def factory(*args_, **kwargs_):
        if Features.subclass:
            return Features.subclass(*args_, **kwargs_)
        else:
            return Features(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_feature(self): return self.feature
    def set_feature(self, feature): self.feature = feature
    def add_feature(self, value): self.feature.append(value)
    def insert_feature(self, index, value): self.feature[index] = value
    def hasContent_(self):
        if (
            self.feature
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Features', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Features')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Features'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Features', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for feature_ in self.feature:
            feature_.export(outfile, level, namespace_, name_='feature', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Features'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('feature=[\n')
        level += 1
        for feature_ in self.feature:
            showIndent(outfile, level)
            outfile.write('model_.feature(\n')
            feature_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'feature':
            obj_ = Feature.factory()
            obj_.build(child_)
            self.feature.append(obj_)
# end class Features


class FenceTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, fence_type=None):
        if fence_type is None:
            self.fence_type = []
        else:
            self.fence_type = fence_type
    def factory(*args_, **kwargs_):
        if FenceTypes.subclass:
            return FenceTypes.subclass(*args_, **kwargs_)
        else:
            return FenceTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_fence_type(self): return self.fence_type
    def set_fence_type(self, fence_type): self.fence_type = fence_type
    def add_fence_type(self, value): self.fence_type.append(value)
    def insert_fence_type(self, index, value): self.fence_type[index] = value
    def hasContent_(self):
        if (
            self.fence_type
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='FenceTypes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FenceTypes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FenceTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='FenceTypes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for fence_type_ in self.fence_type:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfence_type>%s</%sfence_type>%s' % (namespace_, self.gds_format_string(quote_xml(fence_type_).encode(ExternalEncoding), input_name='fence_type'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='FenceTypes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('fence_type=[\n')
        level += 1
        for fence_type_ in self.fence_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(fence_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'fence_type':
            fence_type_ = child_.text
            fence_type_ = self.gds_validate_string(fence_type_, node, 'fence_type')
            self.fence_type.append(fence_type_)
# end class FenceTypes


class StorageTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, storage_type=None):
        if storage_type is None:
            self.storage_type = []
        else:
            self.storage_type = storage_type
    def factory(*args_, **kwargs_):
        if StorageTypes.subclass:
            return StorageTypes.subclass(*args_, **kwargs_)
        else:
            return StorageTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_storage_type(self): return self.storage_type
    def set_storage_type(self, storage_type): self.storage_type = storage_type
    def add_storage_type(self, value): self.storage_type.append(value)
    def insert_storage_type(self, index, value): self.storage_type[index] = value
    def hasContent_(self):
        if (
            self.storage_type
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StorageTypes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageTypes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='StorageTypes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for storage_type_ in self.storage_type:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstorage_type>%s</%sstorage_type>%s' % (namespace_, self.gds_format_string(quote_xml(storage_type_).encode(ExternalEncoding), input_name='storage_type'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='StorageTypes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('storage_type=[\n')
        level += 1
        for storage_type_ in self.storage_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(storage_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'storage_type':
            storage_type_ = child_.text
            storage_type_ = self.gds_validate_string(storage_type_, node, 'storage_type')
            self.storage_type.append(storage_type_)
# end class StorageTypes


class ConfigurationTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, configuration_type=None):
        if configuration_type is None:
            self.configuration_type = []
        else:
            self.configuration_type = configuration_type
    def factory(*args_, **kwargs_):
        if ConfigurationTypes.subclass:
            return ConfigurationTypes.subclass(*args_, **kwargs_)
        else:
            return ConfigurationTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_configuration_type(self): return self.configuration_type
    def set_configuration_type(self, configuration_type): self.configuration_type = configuration_type
    def add_configuration_type(self, value): self.configuration_type.append(value)
    def insert_configuration_type(self, index, value): self.configuration_type[index] = value
    def hasContent_(self):
        if (
            self.configuration_type
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ConfigurationTypes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ConfigurationTypes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ConfigurationTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ConfigurationTypes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for configuration_type_ in self.configuration_type:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sconfiguration_type>%s</%sconfiguration_type>%s' % (namespace_, self.gds_format_string(quote_xml(configuration_type_).encode(ExternalEncoding), input_name='configuration_type'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='ConfigurationTypes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('configuration_type=[\n')
        level += 1
        for configuration_type_ in self.configuration_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(configuration_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'configuration_type':
            configuration_type_ = child_.text
            configuration_type_ = self.gds_validate_string(configuration_type_, node, 'configuration_type')
            self.configuration_type.append(configuration_type_)
# end class ConfigurationTypes


class StorageDomainTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, storage_domain_type=None):
        if storage_domain_type is None:
            self.storage_domain_type = []
        else:
            self.storage_domain_type = storage_domain_type
    def factory(*args_, **kwargs_):
        if StorageDomainTypes.subclass:
            return StorageDomainTypes.subclass(*args_, **kwargs_)
        else:
            return StorageDomainTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_storage_domain_type(self): return self.storage_domain_type
    def set_storage_domain_type(self, storage_domain_type): self.storage_domain_type = storage_domain_type
    def add_storage_domain_type(self, value): self.storage_domain_type.append(value)
    def insert_storage_domain_type(self, index, value): self.storage_domain_type[index] = value
    def hasContent_(self):
        if (
            self.storage_domain_type
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StorageDomainTypes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageDomainTypes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageDomainTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='StorageDomainTypes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for storage_domain_type_ in self.storage_domain_type:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstorage_domain_type>%s</%sstorage_domain_type>%s' % (namespace_, self.gds_format_string(quote_xml(storage_domain_type_).encode(ExternalEncoding), input_name='storage_domain_type'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='StorageDomainTypes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('storage_domain_type=[\n')
        level += 1
        for storage_domain_type_ in self.storage_domain_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(storage_domain_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'storage_domain_type':
            storage_domain_type_ = child_.text
            storage_domain_type_ = self.gds_validate_string(storage_domain_type_, node, 'storage_domain_type')
            self.storage_domain_type.append(storage_domain_type_)
# end class StorageDomainTypes


class VmTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vm_type=None):
        if vm_type is None:
            self.vm_type = []
        else:
            self.vm_type = vm_type
    def factory(*args_, **kwargs_):
        if VmTypes.subclass:
            return VmTypes.subclass(*args_, **kwargs_)
        else:
            return VmTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vm_type(self): return self.vm_type
    def set_vm_type(self, vm_type): self.vm_type = vm_type
    def add_vm_type(self, value): self.vm_type.append(value)
    def insert_vm_type(self, index, value): self.vm_type[index] = value
    def hasContent_(self):
        if (
            self.vm_type
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VmTypes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmTypes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VmTypes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for vm_type_ in self.vm_type:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svm_type>%s</%svm_type>%s' % (namespace_, self.gds_format_string(quote_xml(vm_type_).encode(ExternalEncoding), input_name='vm_type'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='VmTypes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('vm_type=[\n')
        level += 1
        for vm_type_ in self.vm_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(vm_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vm_type':
            vm_type_ = child_.text
            vm_type_ = self.gds_validate_string(vm_type_, node, 'vm_type')
            self.vm_type.append(vm_type_)
# end class VmTypes


class BootDevices(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, boot_device=None):
        if boot_device is None:
            self.boot_device = []
        else:
            self.boot_device = boot_device
    def factory(*args_, **kwargs_):
        if BootDevices.subclass:
            return BootDevices.subclass(*args_, **kwargs_)
        else:
            return BootDevices(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_boot_device(self): return self.boot_device
    def set_boot_device(self, boot_device): self.boot_device = boot_device
    def add_boot_device(self, value): self.boot_device.append(value)
    def insert_boot_device(self, index, value): self.boot_device[index] = value
    def hasContent_(self):
        if (
            self.boot_device
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BootDevices', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BootDevices')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BootDevices'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='BootDevices', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for boot_device_ in self.boot_device:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sboot_device>%s</%sboot_device>%s' % (namespace_, self.gds_format_string(quote_xml(boot_device_).encode(ExternalEncoding), input_name='boot_device'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='BootDevices'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('boot_device=[\n')
        level += 1
        for boot_device_ in self.boot_device:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(boot_device_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'boot_device':
            boot_device_ = child_.text
            boot_device_ = self.gds_validate_string(boot_device_, node, 'boot_device')
            self.boot_device.append(boot_device_)
# end class BootDevices


class DisplayTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, display_type=None):
        if display_type is None:
            self.display_type = []
        else:
            self.display_type = display_type
    def factory(*args_, **kwargs_):
        if DisplayTypes.subclass:
            return DisplayTypes.subclass(*args_, **kwargs_)
        else:
            return DisplayTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_display_type(self): return self.display_type
    def set_display_type(self, display_type): self.display_type = display_type
    def add_display_type(self, value): self.display_type.append(value)
    def insert_display_type(self, index, value): self.display_type[index] = value
    def hasContent_(self):
        if (
            self.display_type
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DisplayTypes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DisplayTypes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DisplayTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='DisplayTypes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for display_type_ in self.display_type:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplay_type>%s</%sdisplay_type>%s' % (namespace_, self.gds_format_string(quote_xml(display_type_).encode(ExternalEncoding), input_name='display_type'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='DisplayTypes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('display_type=[\n')
        level += 1
        for display_type_ in self.display_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(display_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'display_type':
            display_type_ = child_.text
            display_type_ = self.gds_validate_string(display_type_, node, 'display_type')
            self.display_type.append(display_type_)
# end class DisplayTypes


class NicInterfaces(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nic_interface=None):
        if nic_interface is None:
            self.nic_interface = []
        else:
            self.nic_interface = nic_interface
    def factory(*args_, **kwargs_):
        if NicInterfaces.subclass:
            return NicInterfaces.subclass(*args_, **kwargs_)
        else:
            return NicInterfaces(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_nic_interface(self): return self.nic_interface
    def set_nic_interface(self, nic_interface): self.nic_interface = nic_interface
    def add_nic_interface(self, value): self.nic_interface.append(value)
    def insert_nic_interface(self, index, value): self.nic_interface[index] = value
    def hasContent_(self):
        if (
            self.nic_interface
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NicInterfaces', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NicInterfaces')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NicInterfaces'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='NicInterfaces', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for nic_interface_ in self.nic_interface:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snic_interface>%s</%snic_interface>%s' % (namespace_, self.gds_format_string(quote_xml(nic_interface_).encode(ExternalEncoding), input_name='nic_interface'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='NicInterfaces'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('nic_interface=[\n')
        level += 1
        for nic_interface_ in self.nic_interface:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(nic_interface_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'nic_interface':
            nic_interface_ = child_.text
            nic_interface_ = self.gds_validate_string(nic_interface_, node, 'nic_interface')
            self.nic_interface.append(nic_interface_)
# end class NicInterfaces


class OsTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, os_type=None):
        if os_type is None:
            self.os_type = []
        else:
            self.os_type = os_type
    def factory(*args_, **kwargs_):
        if OsTypes.subclass:
            return OsTypes.subclass(*args_, **kwargs_)
        else:
            return OsTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_os_type(self): return self.os_type
    def set_os_type(self, os_type): self.os_type = os_type
    def add_os_type(self, value): self.os_type.append(value)
    def insert_os_type(self, index, value): self.os_type[index] = value
    def hasContent_(self):
        if (
            self.os_type
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='OsTypes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OsTypes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OsTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='OsTypes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for os_type_ in self.os_type:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sos_type>%s</%sos_type>%s' % (namespace_, self.gds_format_string(quote_xml(os_type_).encode(ExternalEncoding), input_name='os_type'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='OsTypes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('os_type=[\n')
        level += 1
        for os_type_ in self.os_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(os_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'os_type':
            os_type_ = child_.text
            os_type_ = self.gds_validate_string(os_type_, node, 'os_type')
            self.os_type.append(os_type_)
# end class OsTypes


class DiskFormats(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, disk_format=None):
        if disk_format is None:
            self.disk_format = []
        else:
            self.disk_format = disk_format
    def factory(*args_, **kwargs_):
        if DiskFormats.subclass:
            return DiskFormats.subclass(*args_, **kwargs_)
        else:
            return DiskFormats(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_disk_format(self): return self.disk_format
    def set_disk_format(self, disk_format): self.disk_format = disk_format
    def add_disk_format(self, value): self.disk_format.append(value)
    def insert_disk_format(self, index, value): self.disk_format[index] = value
    def hasContent_(self):
        if (
            self.disk_format
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DiskFormats', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DiskFormats')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DiskFormats'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='DiskFormats', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for disk_format_ in self.disk_format:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisk_format>%s</%sdisk_format>%s' % (namespace_, self.gds_format_string(quote_xml(disk_format_).encode(ExternalEncoding), input_name='disk_format'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='DiskFormats'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('disk_format=[\n')
        level += 1
        for disk_format_ in self.disk_format:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(disk_format_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'disk_format':
            disk_format_ = child_.text
            disk_format_ = self.gds_validate_string(disk_format_, node, 'disk_format')
            self.disk_format.append(disk_format_)
# end class DiskFormats


class DiskInterfaces(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, disk_interface=None):
        if disk_interface is None:
            self.disk_interface = []
        else:
            self.disk_interface = disk_interface
    def factory(*args_, **kwargs_):
        if DiskInterfaces.subclass:
            return DiskInterfaces.subclass(*args_, **kwargs_)
        else:
            return DiskInterfaces(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_disk_interface(self): return self.disk_interface
    def set_disk_interface(self, disk_interface): self.disk_interface = disk_interface
    def add_disk_interface(self, value): self.disk_interface.append(value)
    def insert_disk_interface(self, index, value): self.disk_interface[index] = value
    def hasContent_(self):
        if (
            self.disk_interface
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DiskInterfaces', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DiskInterfaces')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DiskInterfaces'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='DiskInterfaces', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for disk_interface_ in self.disk_interface:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisk_interface>%s</%sdisk_interface>%s' % (namespace_, self.gds_format_string(quote_xml(disk_interface_).encode(ExternalEncoding), input_name='disk_interface'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='DiskInterfaces'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('disk_interface=[\n')
        level += 1
        for disk_interface_ in self.disk_interface:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(disk_interface_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'disk_interface':
            disk_interface_ = child_.text
            disk_interface_ = self.gds_validate_string(disk_interface_, node, 'disk_interface')
            self.disk_interface.append(disk_interface_)
# end class DiskInterfaces


class VmAffinities(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, affinity=None):
        if affinity is None:
            self.affinity = []
        else:
            self.affinity = affinity
    def factory(*args_, **kwargs_):
        if VmAffinities.subclass:
            return VmAffinities.subclass(*args_, **kwargs_)
        else:
            return VmAffinities(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_affinity(self): return self.affinity
    def set_affinity(self, affinity): self.affinity = affinity
    def add_affinity(self, value): self.affinity.append(value)
    def insert_affinity(self, index, value): self.affinity[index] = value
    def hasContent_(self):
        if (
            self.affinity
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VmAffinities', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmAffinities')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmAffinities'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VmAffinities', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for affinity_ in self.affinity:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saffinity>%s</%saffinity>%s' % (namespace_, self.gds_format_string(quote_xml(affinity_).encode(ExternalEncoding), input_name='affinity'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='VmAffinities'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('affinity=[\n')
        level += 1
        for affinity_ in self.affinity:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(affinity_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'affinity':
            affinity_ = child_.text
            affinity_ = self.gds_validate_string(affinity_, node, 'affinity')
            self.affinity.append(affinity_)
# end class VmAffinities


class BootProtocols(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, boot_protocol=None):
        if boot_protocol is None:
            self.boot_protocol = []
        else:
            self.boot_protocol = boot_protocol
    def factory(*args_, **kwargs_):
        if BootProtocols.subclass:
            return BootProtocols.subclass(*args_, **kwargs_)
        else:
            return BootProtocols(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_boot_protocol(self): return self.boot_protocol
    def set_boot_protocol(self, boot_protocol): self.boot_protocol = boot_protocol
    def add_boot_protocol(self, value): self.boot_protocol.append(value)
    def insert_boot_protocol(self, index, value): self.boot_protocol[index] = value
    def hasContent_(self):
        if (
            self.boot_protocol
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BootProtocols', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BootProtocols')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BootProtocols'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='BootProtocols', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for boot_protocol_ in self.boot_protocol:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sboot_protocol>%s</%sboot_protocol>%s' % (namespace_, self.gds_format_string(quote_xml(boot_protocol_).encode(ExternalEncoding), input_name='boot_protocol'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='BootProtocols'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('boot_protocol=[\n')
        level += 1
        for boot_protocol_ in self.boot_protocol:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(boot_protocol_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'boot_protocol':
            boot_protocol_ = child_.text
            boot_protocol_ = self.gds_validate_string(boot_protocol_, node, 'boot_protocol')
            self.boot_protocol.append(boot_protocol_)
# end class BootProtocols


class ErrorHandlingOptions(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, on_error=None):
        if on_error is None:
            self.on_error = []
        else:
            self.on_error = on_error
    def factory(*args_, **kwargs_):
        if ErrorHandlingOptions.subclass:
            return ErrorHandlingOptions.subclass(*args_, **kwargs_)
        else:
            return ErrorHandlingOptions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_on_error(self): return self.on_error
    def set_on_error(self, on_error): self.on_error = on_error
    def add_on_error(self, value): self.on_error.append(value)
    def insert_on_error(self, index, value): self.on_error[index] = value
    def hasContent_(self):
        if (
            self.on_error
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ErrorHandlingOptions', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ErrorHandlingOptions')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ErrorHandlingOptions'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ErrorHandlingOptions', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for on_error_ in self.on_error:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%son_error>%s</%son_error>%s' % (namespace_, self.gds_format_string(quote_xml(on_error_).encode(ExternalEncoding), input_name='on_error'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='ErrorHandlingOptions'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('on_error=[\n')
        level += 1
        for on_error_ in self.on_error:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(on_error_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'on_error':
            on_error_ = child_.text
            on_error_ = self.gds_validate_string(on_error_, node, 'on_error')
            self.on_error.append(on_error_)
# end class ErrorHandlingOptions


class StorageFormats(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, format=None):
        if format is None:
            self.format = []
        else:
            self.format = format
    def factory(*args_, **kwargs_):
        if StorageFormats.subclass:
            return StorageFormats.subclass(*args_, **kwargs_)
        else:
            return StorageFormats(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def add_format(self, value): self.format.append(value)
    def insert_format(self, index, value): self.format[index] = value
    def hasContent_(self):
        if (
            self.format
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StorageFormats', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageFormats')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageFormats'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='StorageFormats', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for format_ in self.format:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sformat>%s</%sformat>%s' % (namespace_, self.gds_format_string(quote_xml(format_).encode(ExternalEncoding), input_name='format'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='StorageFormats'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('format=[\n')
        level += 1
        for format_ in self.format:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(format_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'format':
            format_ = child_.text
            format_ = self.gds_validate_string(format_, node, 'format')
            self.format.append(format_)
# end class StorageFormats


class NfsVersions(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nfs_version=None):
        if nfs_version is None:
            self.nfs_version = []
        else:
            self.nfs_version = nfs_version
    def factory(*args_, **kwargs_):
        if NfsVersions.subclass:
            return NfsVersions.subclass(*args_, **kwargs_)
        else:
            return NfsVersions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_nfs_version(self): return self.nfs_version
    def set_nfs_version(self, nfs_version): self.nfs_version = nfs_version
    def add_nfs_version(self, value): self.nfs_version.append(value)
    def insert_nfs_version(self, index, value): self.nfs_version[index] = value
    def hasContent_(self):
        if (
            self.nfs_version
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NfsVersions', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NfsVersions')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NfsVersions'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='NfsVersions', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for nfs_version_ in self.nfs_version:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snfs_version>%s</%snfs_version>%s' % (namespace_, self.gds_format_string(quote_xml(nfs_version_).encode(ExternalEncoding), input_name='nfs_version'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='NfsVersions'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('nfs_version=[\n')
        level += 1
        for nfs_version_ in self.nfs_version:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(nfs_version_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'nfs_version':
            nfs_version_ = child_.text
            nfs_version_ = self.gds_validate_string(nfs_version_, node, 'nfs_version')
            self.nfs_version.append(nfs_version_)
# end class NfsVersions


class ReportedDeviceTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, reported_device_type=None):
        if reported_device_type is None:
            self.reported_device_type = []
        else:
            self.reported_device_type = reported_device_type
    def factory(*args_, **kwargs_):
        if ReportedDeviceTypes.subclass:
            return ReportedDeviceTypes.subclass(*args_, **kwargs_)
        else:
            return ReportedDeviceTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_reported_device_type(self): return self.reported_device_type
    def set_reported_device_type(self, reported_device_type): self.reported_device_type = reported_device_type
    def add_reported_device_type(self, value): self.reported_device_type.append(value)
    def insert_reported_device_type(self, index, value): self.reported_device_type[index] = value
    def hasContent_(self):
        if (
            self.reported_device_type
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ReportedDeviceTypes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ReportedDeviceTypes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ReportedDeviceTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ReportedDeviceTypes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for reported_device_type_ in self.reported_device_type:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreported_device_type>%s</%sreported_device_type>%s' % (namespace_, self.gds_format_string(quote_xml(reported_device_type_).encode(ExternalEncoding), input_name='reported_device_type'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='ReportedDeviceTypes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('reported_device_type=[\n')
        level += 1
        for reported_device_type_ in self.reported_device_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(reported_device_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'reported_device_type':
            reported_device_type_ = child_.text
            reported_device_type_ = self.gds_validate_string(reported_device_type_, node, 'reported_device_type')
            self.reported_device_type.append(reported_device_type_)
# end class ReportedDeviceTypes


class IpVersions(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ip_version=None):
        if ip_version is None:
            self.ip_version = []
        else:
            self.ip_version = ip_version
    def factory(*args_, **kwargs_):
        if IpVersions.subclass:
            return IpVersions.subclass(*args_, **kwargs_)
        else:
            return IpVersions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ip_version(self): return self.ip_version
    def set_ip_version(self, ip_version): self.ip_version = ip_version
    def add_ip_version(self, value): self.ip_version.append(value)
    def insert_ip_version(self, index, value): self.ip_version[index] = value
    def hasContent_(self):
        if (
            self.ip_version
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IpVersions', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IpVersions')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IpVersions'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='IpVersions', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ip_version_ in self.ip_version:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sip_version>%s</%sip_version>%s' % (namespace_, self.gds_format_string(quote_xml(ip_version_).encode(ExternalEncoding), input_name='ip_version'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='IpVersions'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('ip_version=[\n')
        level += 1
        for ip_version_ in self.ip_version:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(ip_version_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ip_version':
            ip_version_ = child_.text
            ip_version_ = self.gds_validate_string(ip_version_, node, 'ip_version')
            self.ip_version.append(ip_version_)
# end class IpVersions


class CpuModes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, cpu_mode=None):
        if cpu_mode is None:
            self.cpu_mode = []
        else:
            self.cpu_mode = cpu_mode
    def factory(*args_, **kwargs_):
        if CpuModes.subclass:
            return CpuModes.subclass(*args_, **kwargs_)
        else:
            return CpuModes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cpu_mode(self): return self.cpu_mode
    def set_cpu_mode(self, cpu_mode): self.cpu_mode = cpu_mode
    def add_cpu_mode(self, value): self.cpu_mode.append(value)
    def insert_cpu_mode(self, index, value): self.cpu_mode[index] = value
    def hasContent_(self):
        if (
            self.cpu_mode
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CpuModes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CpuModes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CpuModes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='CpuModes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for cpu_mode_ in self.cpu_mode:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scpu_mode>%s</%scpu_mode>%s' % (namespace_, self.gds_format_string(quote_xml(cpu_mode_).encode(ExternalEncoding), input_name='cpu_mode'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='CpuModes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('cpu_mode=[\n')
        level += 1
        for cpu_mode_ in self.cpu_mode:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(cpu_mode_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'cpu_mode':
            cpu_mode_ = child_.text
            cpu_mode_ = self.gds_validate_string(cpu_mode_, node, 'cpu_mode')
            self.cpu_mode.append(cpu_mode_)
# end class CpuModes


class ScsiGenericIoOptions(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, sgio_options=None):
        if sgio_options is None:
            self.sgio_options = []
        else:
            self.sgio_options = sgio_options
    def factory(*args_, **kwargs_):
        if ScsiGenericIoOptions.subclass:
            return ScsiGenericIoOptions.subclass(*args_, **kwargs_)
        else:
            return ScsiGenericIoOptions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_sgio_options(self): return self.sgio_options
    def set_sgio_options(self, sgio_options): self.sgio_options = sgio_options
    def add_sgio_options(self, value): self.sgio_options.append(value)
    def insert_sgio_options(self, index, value): self.sgio_options[index] = value
    def hasContent_(self):
        if (
            self.sgio_options
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ScsiGenericIoOptions', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ScsiGenericIoOptions')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ScsiGenericIoOptions'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ScsiGenericIoOptions', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for sgio_options_ in self.sgio_options:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssgio_options>%s</%ssgio_options>%s' % (namespace_, self.gds_format_string(quote_xml(sgio_options_).encode(ExternalEncoding), input_name='sgio_options'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='ScsiGenericIoOptions'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('sgio_options=[\n')
        level += 1
        for sgio_options_ in self.sgio_options:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(sgio_options_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'sgio_options':
            sgio_options_ = child_.text
            sgio_options_ = self.gds_validate_string(sgio_options_, node, 'sgio_options')
            self.sgio_options.append(sgio_options_)
# end class ScsiGenericIoOptions


class WatchdogActions(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, action=None):
        if action is None:
            self.action = []
        else:
            self.action = action
    def factory(*args_, **kwargs_):
        if WatchdogActions.subclass:
            return WatchdogActions.subclass(*args_, **kwargs_)
        else:
            return WatchdogActions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_action(self): return self.action
    def set_action(self, action): self.action = action
    def add_action(self, value): self.action.append(value)
    def insert_action(self, index, value): self.action[index] = value
    def hasContent_(self):
        if (
            self.action
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='WatchdogActions', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='WatchdogActions')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='WatchdogActions'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='WatchdogActions', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for action_ in self.action:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saction>%s</%saction>%s' % (namespace_, self.gds_format_string(quote_xml(action_).encode(ExternalEncoding), input_name='action'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='WatchdogActions'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('action=[\n')
        level += 1
        for action_ in self.action:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(action_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'action':
            action_ = child_.text
            action_ = self.gds_validate_string(action_, node, 'action')
            self.action.append(action_)
# end class WatchdogActions


class WatchdogModels(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, model=None):
        if model is None:
            self.model = []
        else:
            self.model = model
    def factory(*args_, **kwargs_):
        if WatchdogModels.subclass:
            return WatchdogModels.subclass(*args_, **kwargs_)
        else:
            return WatchdogModels(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_model(self): return self.model
    def set_model(self, model): self.model = model
    def add_model(self, value): self.model.append(value)
    def insert_model(self, index, value): self.model[index] = value
    def hasContent_(self):
        if (
            self.model
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='WatchdogModels', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='WatchdogModels')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='WatchdogModels'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='WatchdogModels', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for model_ in self.model:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodel>%s</%smodel>%s' % (namespace_, self.gds_format_string(quote_xml(model_).encode(ExternalEncoding), input_name='model'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='WatchdogModels'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('model=[\n')
        level += 1
        for model_ in self.model:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(model_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'model':
            model_ = child_.text
            model_ = self.gds_validate_string(model_, node, 'model')
            self.model.append(model_)
# end class WatchdogModels


class SnapshotStatuses(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, snapshot_status=None):
        if snapshot_status is None:
            self.snapshot_status = []
        else:
            self.snapshot_status = snapshot_status
    def factory(*args_, **kwargs_):
        if SnapshotStatuses.subclass:
            return SnapshotStatuses.subclass(*args_, **kwargs_)
        else:
            return SnapshotStatuses(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_snapshot_status(self): return self.snapshot_status
    def set_snapshot_status(self, snapshot_status): self.snapshot_status = snapshot_status
    def add_snapshot_status(self, value): self.snapshot_status.append(value)
    def insert_snapshot_status(self, index, value): self.snapshot_status[index] = value
    def hasContent_(self):
        if (
            self.snapshot_status
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SnapshotStatuses', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SnapshotStatuses')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SnapshotStatuses'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='SnapshotStatuses', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for snapshot_status_ in self.snapshot_status:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssnapshot_status>%s</%ssnapshot_status>%s' % (namespace_, self.gds_format_string(quote_xml(snapshot_status_).encode(ExternalEncoding), input_name='snapshot_status'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='SnapshotStatuses'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('snapshot_status=[\n')
        level += 1
        for snapshot_status_ in self.snapshot_status:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(snapshot_status_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'snapshot_status':
            snapshot_status_ = child_.text
            snapshot_status_ = self.gds_validate_string(snapshot_status_, node, 'snapshot_status')
            self.snapshot_status.append(snapshot_status_)
# end class SnapshotStatuses


class ActionableResource(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, actions=None, extensiontype_=None):
        self.actions = actions
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if ActionableResource.subclass:
            return ActionableResource.subclass(*args_, **kwargs_)
        else:
            return ActionableResource(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_actions(self): return self.actions
    def set_actions(self, actions): self.actions = actions
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.actions is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ActionableResource', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ActionableResource')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ActionableResource'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ActionableResource', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.actions is not None:
            self.actions.export(outfile, level, namespace_, name_='actions', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ActionableResource'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.actions is not None:
            showIndent(outfile, level)
            outfile.write('actions=model_.Actions(\n')
            self.actions.exportLiteral(outfile, level, name_='actions')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'actions':
            obj_ = Actions.factory()
            obj_.build(child_)
            self.set_actions(obj_)
# end class ActionableResource


class BaseResource(ActionableResource):
    subclass = None
    superclass = ActionableResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, extensiontype_=None):
        super(BaseResource, self).__init__(actions, extensiontype_, )
        self.href = _cast(None, href)
        self.id = _cast(None, id)
        self.name = name
        self.description = description
        self.comment = comment
        self.creation_status = creation_status
        if link is None:
            self.link = []
        else:
            self.link = link
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if BaseResource.subclass:
            return BaseResource.subclass(*args_, **kwargs_)
        else:
            return BaseResource(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_comment(self): return self.comment
    def set_comment(self, comment): self.comment = comment
    def get_creation_status(self): return self.creation_status
    def set_creation_status(self, creation_status): self.creation_status = creation_status
    def get_link(self): return self.link
    def set_link(self, link): self.link = link
    def add_link(self, value): self.link.append(value)
    def insert_link(self, index, value): self.link[index] = value
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.name is not None or
            self.description is not None or
            self.comment is not None or
            self.creation_status is not None or
            self.link or
            super(BaseResource, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BaseResource', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseResource')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseResource'):
        super(BaseResource, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseResource')
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (self.gds_format_string(quote_attrib(self.href).encode(ExternalEncoding), input_name='href'), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseResource', fromsubclass_=False, pretty_print=True):
        super(BaseResource, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_, eol_))
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_, eol_))
        if self.comment is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scomment>%s</%scomment>%s' % (namespace_, self.gds_format_string(quote_xml(self.comment).encode(ExternalEncoding), input_name='comment'), namespace_, eol_))
        if self.creation_status is not None:
            self.creation_status.export(outfile, level, namespace_, name_='creation_status', pretty_print=pretty_print)
        for link_ in self.link:
            link_.export(outfile, level, namespace_, name_='link', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BaseResource'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            showIndent(outfile, level)
            outfile.write('href = "%s",\n' % (self.href,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
        super(BaseResource, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(BaseResource, self).exportLiteralChildren(outfile, level, name_)
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.comment is not None:
            showIndent(outfile, level)
            outfile.write('comment=%s,\n' % quote_python(self.comment).encode(ExternalEncoding))
        if self.creation_status is not None:
            showIndent(outfile, level)
            outfile.write('creation_status=model_.Status(\n')
            self.creation_status.exportLiteral(outfile, level, name_='creation_status')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('link=[\n')
        level += 1
        for link_ in self.link:
            showIndent(outfile, level)
            outfile.write('model_.link(\n')
            link_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(BaseResource, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'comment':
            comment_ = child_.text
            comment_ = self.gds_validate_string(comment_, node, 'comment')
            self.comment = comment_
        elif nodeName_ == 'creation_status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.set_creation_status(obj_)
        elif nodeName_ == 'link':
            class_obj_ = self.get_class_obj_(child_, Link)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.link.append(obj_)
        super(BaseResource, self).buildChildren(child_, node, nodeName_, True)
# end class BaseResource


class BaseResources(ActionableResource):
    subclass = None
    superclass = ActionableResource
    def __init__(self, actions=None, total=None, active=None, extensiontype_=None):
        super(BaseResources, self).__init__(actions, extensiontype_, )
        self.total = total
        self.active = active
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if BaseResources.subclass:
            return BaseResources.subclass(*args_, **kwargs_)
        else:
            return BaseResources(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_total(self): return self.total
    def set_total(self, total): self.total = total
    def get_active(self): return self.active
    def set_active(self, active): self.active = active
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.total is not None or
            self.active is not None or
            super(BaseResources, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BaseResources', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseResources')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseResources'):
        super(BaseResources, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseResources')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseResources', fromsubclass_=False, pretty_print=True):
        super(BaseResources, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.total is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotal>%s</%stotal>%s' % (namespace_, self.gds_format_integer(self.total, input_name='total'), namespace_, eol_))
        if self.active is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sactive>%s</%sactive>%s' % (namespace_, self.gds_format_integer(self.active, input_name='active'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='BaseResources'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(BaseResources, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(BaseResources, self).exportLiteralChildren(outfile, level, name_)
        if self.total is not None:
            showIndent(outfile, level)
            outfile.write('total=%d,\n' % self.total)
        if self.active is not None:
            showIndent(outfile, level)
            outfile.write('active=%d,\n' % self.active)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(BaseResources, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'total':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'total')
            self.total = ival_
        elif nodeName_ == 'active':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'active')
            self.active = ival_
        super(BaseResources, self).buildChildren(child_, node, nodeName_, True)
# end class BaseResources


class Option(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, name=None, value=None):
        self.type_ = _cast(None, type_)
        self.name = _cast(None, name)
        self.value = _cast(None, value)
        pass
    def factory(*args_, **kwargs_):
        if Option.subclass:
            return Option.subclass(*args_, **kwargs_)
        else:
            return Option(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Option', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Option')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Option'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (self.gds_format_string(quote_attrib(self.value).encode(ExternalEncoding), input_name='value'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Option', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='Option'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            showIndent(outfile, level)
            outfile.write('value = "%s",\n' % (self.value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Option


class Options(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, option=None):
        if option is None:
            self.option = []
        else:
            self.option = option
    def factory(*args_, **kwargs_):
        if Options.subclass:
            return Options.subclass(*args_, **kwargs_)
        else:
            return Options(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_option(self): return self.option
    def set_option(self, option): self.option = option
    def add_option(self, value): self.option.append(value)
    def insert_option(self, index, value): self.option[index] = value
    def hasContent_(self):
        if (
            self.option
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Options', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Options')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Options'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Options', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for option_ in self.option:
            option_.export(outfile, level, namespace_, name_='option', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Options'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('option=[\n')
        level += 1
        for option_ in self.option:
            showIndent(outfile, level)
            outfile.write('model_.Option(\n')
            option_.exportLiteral(outfile, level, name_='Option')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'option':
            obj_ = Option.factory()
            obj_.build(child_)
            self.option.append(obj_)
# end class Options


class DataCenter(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, storage_type=None, storage_format=None, version=None, supported_versions=None, status=None):
        super(DataCenter, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.storage_type = storage_type
        self.storage_format = storage_format
        self.version = version
        self.supported_versions = supported_versions
        self.status = status
    def factory(*args_, **kwargs_):
        if DataCenter.subclass:
            return DataCenter.subclass(*args_, **kwargs_)
        else:
            return DataCenter(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_storage_type(self): return self.storage_type
    def set_storage_type(self, storage_type): self.storage_type = storage_type
    def get_storage_format(self): return self.storage_format
    def set_storage_format(self, storage_format): self.storage_format = storage_format
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_supported_versions(self): return self.supported_versions
    def set_supported_versions(self, supported_versions): self.supported_versions = supported_versions
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def hasContent_(self):
        if (
            self.storage_type is not None or
            self.storage_format is not None or
            self.version is not None or
            self.supported_versions is not None or
            self.status is not None or
            super(DataCenter, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DataCenter', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DataCenter')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DataCenter'):
        super(DataCenter, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DataCenter')
    def exportChildren(self, outfile, level, namespace_='', name_='DataCenter', fromsubclass_=False, pretty_print=True):
        super(DataCenter, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.storage_type is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstorage_type>%s</%sstorage_type>%s' % (namespace_, self.gds_format_string(quote_xml(self.storage_type).encode(ExternalEncoding), input_name='storage_type'), namespace_, eol_))
        if self.storage_format is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstorage_format>%s</%sstorage_format>%s' % (namespace_, self.gds_format_string(quote_xml(self.storage_format).encode(ExternalEncoding), input_name='storage_format'), namespace_, eol_))
        if self.version is not None:
            self.version.export(outfile, level, namespace_, name_='version', pretty_print=pretty_print)
        if self.supported_versions is not None:
            self.supported_versions.export(outfile, level, namespace_, name_='supported_versions', pretty_print=pretty_print)
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='DataCenter'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(DataCenter, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DataCenter, self).exportLiteralChildren(outfile, level, name_)
        if self.storage_type is not None:
            showIndent(outfile, level)
            outfile.write('storage_type=%s,\n' % quote_python(self.storage_type).encode(ExternalEncoding))
        if self.storage_format is not None:
            showIndent(outfile, level)
            outfile.write('storage_format=%s,\n' % quote_python(self.storage_format).encode(ExternalEncoding))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=model_.Version(\n')
            self.version.exportLiteral(outfile, level, name_='version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.supported_versions is not None:
            showIndent(outfile, level)
            outfile.write('supported_versions=model_.SupportedVersions(\n')
            self.supported_versions.exportLiteral(outfile, level, name_='supported_versions')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(DataCenter, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'storage_type':
            storage_type_ = child_.text
            storage_type_ = self.gds_validate_string(storage_type_, node, 'storage_type')
            self.storage_type = storage_type_
        elif nodeName_ == 'storage_format':
            storage_format_ = child_.text
            storage_format_ = self.gds_validate_string(storage_format_, node, 'storage_format')
            self.storage_format = storage_format_
        elif nodeName_ == 'version':
            class_obj_ = self.get_class_obj_(child_, Version)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_version(obj_)
        elif nodeName_ == 'supported_versions':
            obj_ = SupportedVersions.factory()
            obj_.build(child_)
            self.set_supported_versions(obj_)
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.set_status(obj_)
        super(DataCenter, self).buildChildren(child_, node, nodeName_, True)
# end class DataCenter


class DataCenters(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, data_center=None):
        super(DataCenters, self).__init__(actions, total, active, )
        if data_center is None:
            self.data_center = []
        else:
            self.data_center = data_center
    def factory(*args_, **kwargs_):
        if DataCenters.subclass:
            return DataCenters.subclass(*args_, **kwargs_)
        else:
            return DataCenters(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_data_center(self): return self.data_center
    def set_data_center(self, data_center): self.data_center = data_center
    def add_data_center(self, value): self.data_center.append(value)
    def insert_data_center(self, index, value): self.data_center[index] = value
    def hasContent_(self):
        if (
            self.data_center or
            super(DataCenters, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DataCenters', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DataCenters')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DataCenters'):
        super(DataCenters, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DataCenters')
    def exportChildren(self, outfile, level, namespace_='', name_='DataCenters', fromsubclass_=False, pretty_print=True):
        super(DataCenters, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for data_center_ in self.data_center:
            data_center_.export(outfile, level, namespace_, name_='data_center', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='DataCenters'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(DataCenters, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DataCenters, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('data_center=[\n')
        level += 1
        for data_center_ in self.data_center:
            showIndent(outfile, level)
            outfile.write('model_.data_center(\n')
            data_center_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(DataCenters, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'data_center':
            obj_ = DataCenter.factory()
            obj_.build(child_)
            self.data_center.append(obj_)
        super(DataCenters, self).buildChildren(child_, node, nodeName_, True)
# end class DataCenters


class DataCenterStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, data_center_state=None):
        if data_center_state is None:
            self.data_center_state = []
        else:
            self.data_center_state = data_center_state
    def factory(*args_, **kwargs_):
        if DataCenterStates.subclass:
            return DataCenterStates.subclass(*args_, **kwargs_)
        else:
            return DataCenterStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_data_center_state(self): return self.data_center_state
    def set_data_center_state(self, data_center_state): self.data_center_state = data_center_state
    def add_data_center_state(self, value): self.data_center_state.append(value)
    def insert_data_center_state(self, index, value): self.data_center_state[index] = value
    def hasContent_(self):
        if (
            self.data_center_state
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DataCenterStates', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DataCenterStates')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DataCenterStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='DataCenterStates', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for data_center_state_ in self.data_center_state:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdata_center_state>%s</%sdata_center_state>%s' % (namespace_, self.gds_format_string(quote_xml(data_center_state_).encode(ExternalEncoding), input_name='data_center_state'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='DataCenterStates'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('data_center_state=[\n')
        level += 1
        for data_center_state_ in self.data_center_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(data_center_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'data_center_state':
            data_center_state_ = child_.text
            data_center_state_ = self.gds_validate_string(data_center_state_, node, 'data_center_state')
            self.data_center_state.append(data_center_state_)
# end class DataCenterStates


class MemoryOverCommit(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, percent=None):
        self.percent = _cast(int, percent)
        pass
    def factory(*args_, **kwargs_):
        if MemoryOverCommit.subclass:
            return MemoryOverCommit.subclass(*args_, **kwargs_)
        else:
            return MemoryOverCommit(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_percent(self): return self.percent
    def set_percent(self, percent): self.percent = percent
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MemoryOverCommit', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MemoryOverCommit')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MemoryOverCommit'):
        if self.percent is not None and 'percent' not in already_processed:
            already_processed.add('percent')
            outfile.write(' percent="%s"' % self.gds_format_integer(self.percent, input_name='percent'))
    def exportChildren(self, outfile, level, namespace_='', name_='MemoryOverCommit', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='MemoryOverCommit'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.percent is not None and 'percent' not in already_processed:
            already_processed.add('percent')
            showIndent(outfile, level)
            outfile.write('percent = %d,\n' % (self.percent,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('percent', node)
        if value is not None and 'percent' not in already_processed:
            already_processed.add('percent')
            try:
                self.percent = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class MemoryOverCommit


class MemoryPolicy(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, guaranteed=None, ballooning=None, overcommit=None, transparent_hugepages=None):
        self.guaranteed = guaranteed
        self.ballooning = ballooning
        self.overcommit = overcommit
        self.transparent_hugepages = transparent_hugepages
    def factory(*args_, **kwargs_):
        if MemoryPolicy.subclass:
            return MemoryPolicy.subclass(*args_, **kwargs_)
        else:
            return MemoryPolicy(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_guaranteed(self): return self.guaranteed
    def set_guaranteed(self, guaranteed): self.guaranteed = guaranteed
    def get_ballooning(self): return self.ballooning
    def set_ballooning(self, ballooning): self.ballooning = ballooning
    def get_overcommit(self): return self.overcommit
    def set_overcommit(self, overcommit): self.overcommit = overcommit
    def get_transparent_hugepages(self): return self.transparent_hugepages
    def set_transparent_hugepages(self, transparent_hugepages): self.transparent_hugepages = transparent_hugepages
    def hasContent_(self):
        if (
            self.guaranteed is not None or
            self.ballooning is not None or
            self.overcommit is not None or
            self.transparent_hugepages is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MemoryPolicy', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MemoryPolicy')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MemoryPolicy'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='MemoryPolicy', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.guaranteed is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sguaranteed>%s</%sguaranteed>%s' % (namespace_, self.gds_format_integer(self.guaranteed, input_name='guaranteed'), namespace_, eol_))
        if self.ballooning is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sballooning>%s</%sballooning>%s' % (namespace_, self.gds_format_boolean(self.ballooning, input_name='ballooning'), namespace_, eol_))
        if self.overcommit is not None:
            self.overcommit.export(outfile, level, namespace_, name_='overcommit', pretty_print=pretty_print)
        if self.transparent_hugepages is not None:
            self.transparent_hugepages.export(outfile, level, namespace_, name_='transparent_hugepages', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='MemoryPolicy'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.guaranteed is not None:
            showIndent(outfile, level)
            outfile.write('guaranteed=%d,\n' % self.guaranteed)
        if self.ballooning is not None:
            showIndent(outfile, level)
            outfile.write('ballooning=%s,\n' % self.ballooning)
        if self.overcommit is not None:
            showIndent(outfile, level)
            outfile.write('overcommit=model_.MemoryOverCommit(\n')
            self.overcommit.exportLiteral(outfile, level, name_='overcommit')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.transparent_hugepages is not None:
            showIndent(outfile, level)
            outfile.write('transparent_hugepages=model_.transparent_hugepages(\n')
            self.transparent_hugepages.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'guaranteed':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'guaranteed')
            self.guaranteed = ival_
        elif nodeName_ == 'ballooning':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ballooning')
            self.ballooning = ival_
        elif nodeName_ == 'overcommit':
            obj_ = MemoryOverCommit.factory()
            obj_.build(child_)
            self.set_overcommit(obj_)
        elif nodeName_ == 'transparent_hugepages':
            obj_ = TransparentHugePages.factory()
            obj_.build(child_)
            self.set_transparent_hugepages(obj_)
# end class MemoryPolicy


class Console(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, enabled=None):
        self.enabled = _cast(bool, enabled)
        pass
    def factory(*args_, **kwargs_):
        if Console.subclass:
            return Console.subclass(*args_, **kwargs_)
        else:
            return Console(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_enabled(self): return self.enabled
    def set_enabled(self, enabled): self.enabled = enabled
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Console', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Console')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Console'):
        if self.enabled is not None and 'enabled' not in already_processed:
            already_processed.add('enabled')
            outfile.write(' enabled="%s"' % self.gds_format_boolean(self.enabled, input_name='enabled'))
    def exportChildren(self, outfile, level, namespace_='', name_='Console', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='Console'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.enabled is not None and 'enabled' not in already_processed:
            already_processed.add('enabled')
            showIndent(outfile, level)
            outfile.write('enabled = %s,\n' % (self.enabled,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('enabled', node)
        if value is not None and 'enabled' not in already_processed:
            already_processed.add('enabled')
            if value in ('true', '1'):
                self.enabled = True
            elif value in ('false', '0'):
                self.enabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Console


class VirtIO_SCSI(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, enabled=None):
        self.enabled = _cast(bool, enabled)
        pass
    def factory(*args_, **kwargs_):
        if VirtIO_SCSI.subclass:
            return VirtIO_SCSI.subclass(*args_, **kwargs_)
        else:
            return VirtIO_SCSI(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_enabled(self): return self.enabled
    def set_enabled(self, enabled): self.enabled = enabled
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VirtIO_SCSI', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VirtIO_SCSI')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VirtIO_SCSI'):
        if self.enabled is not None and 'enabled' not in already_processed:
            already_processed.add('enabled')
            outfile.write(' enabled="%s"' % self.gds_format_boolean(self.enabled, input_name='enabled'))
    def exportChildren(self, outfile, level, namespace_='', name_='VirtIO_SCSI', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='VirtIO_SCSI'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.enabled is not None and 'enabled' not in already_processed:
            already_processed.add('enabled')
            showIndent(outfile, level)
            outfile.write('enabled = %s,\n' % (self.enabled,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('enabled', node)
        if value is not None and 'enabled' not in already_processed:
            already_processed.add('enabled')
            if value in ('true', '1'):
                self.enabled = True
            elif value in ('false', '0'):
                self.enabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class VirtIO_SCSI


class SchedulingPolicyThresholds(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, high=None, duration=None, low=None):
        self.high = _cast(int, high)
        self.duration = _cast(int, duration)
        self.low = _cast(int, low)
        pass
    def factory(*args_, **kwargs_):
        if SchedulingPolicyThresholds.subclass:
            return SchedulingPolicyThresholds.subclass(*args_, **kwargs_)
        else:
            return SchedulingPolicyThresholds(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_high(self): return self.high
    def set_high(self, high): self.high = high
    def get_duration(self): return self.duration
    def set_duration(self, duration): self.duration = duration
    def get_low(self): return self.low
    def set_low(self, low): self.low = low
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SchedulingPolicyThresholds', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SchedulingPolicyThresholds')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SchedulingPolicyThresholds'):
        if self.high is not None and 'high' not in already_processed:
            already_processed.add('high')
            outfile.write(' high="%s"' % self.gds_format_integer(self.high, input_name='high'))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            outfile.write(' duration="%s"' % self.gds_format_integer(self.duration, input_name='duration'))
        if self.low is not None and 'low' not in already_processed:
            already_processed.add('low')
            outfile.write(' low="%s"' % self.gds_format_integer(self.low, input_name='low'))
    def exportChildren(self, outfile, level, namespace_='', name_='SchedulingPolicyThresholds', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='SchedulingPolicyThresholds'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.high is not None and 'high' not in already_processed:
            already_processed.add('high')
            showIndent(outfile, level)
            outfile.write('high = %d,\n' % (self.high,))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            showIndent(outfile, level)
            outfile.write('duration = %d,\n' % (self.duration,))
        if self.low is not None and 'low' not in already_processed:
            already_processed.add('low')
            showIndent(outfile, level)
            outfile.write('low = %d,\n' % (self.low,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('high', node)
        if value is not None and 'high' not in already_processed:
            already_processed.add('high')
            try:
                self.high = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('duration', node)
        if value is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            try:
                self.duration = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('low', node)
        if value is not None and 'low' not in already_processed:
            already_processed.add('low')
            try:
                self.low = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class SchedulingPolicyThresholds


class SchedulingPolicy(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, policy=None, thresholds=None):
        self.policy = policy
        self.thresholds = thresholds
    def factory(*args_, **kwargs_):
        if SchedulingPolicy.subclass:
            return SchedulingPolicy.subclass(*args_, **kwargs_)
        else:
            return SchedulingPolicy(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_policy(self): return self.policy
    def set_policy(self, policy): self.policy = policy
    def get_thresholds(self): return self.thresholds
    def set_thresholds(self, thresholds): self.thresholds = thresholds
    def hasContent_(self):
        if (
            self.policy is not None or
            self.thresholds is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SchedulingPolicy', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SchedulingPolicy')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SchedulingPolicy'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='SchedulingPolicy', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.policy is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spolicy>%s</%spolicy>%s' % (namespace_, self.gds_format_string(quote_xml(self.policy).encode(ExternalEncoding), input_name='policy'), namespace_, eol_))
        if self.thresholds is not None:
            self.thresholds.export(outfile, level, namespace_, name_='thresholds', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SchedulingPolicy'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.policy is not None:
            showIndent(outfile, level)
            outfile.write('policy=%s,\n' % quote_python(self.policy).encode(ExternalEncoding))
        if self.thresholds is not None:
            showIndent(outfile, level)
            outfile.write('thresholds=model_.SchedulingPolicyThresholds(\n')
            self.thresholds.exportLiteral(outfile, level, name_='thresholds')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'policy':
            policy_ = child_.text
            policy_ = self.gds_validate_string(policy_, node, 'policy')
            self.policy = policy_
        elif nodeName_ == 'thresholds':
            obj_ = SchedulingPolicyThresholds.factory()
            obj_.build(child_)
            self.set_thresholds(obj_)
# end class SchedulingPolicy


class Cluster(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, cpu=None, data_center=None, memory_policy=None, scheduling_policy=None, version=None, supported_versions=None, error_handling=None, virt_service=None, gluster_service=None, threads_as_cores=None, tunnel_migration=None, trusted_service=None, ballooning_enabled=None):
        super(Cluster, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.cpu = cpu
        self.data_center = data_center
        self.memory_policy = memory_policy
        self.scheduling_policy = scheduling_policy
        self.version = version
        self.supported_versions = supported_versions
        self.error_handling = error_handling
        self.virt_service = virt_service
        self.gluster_service = gluster_service
        self.threads_as_cores = threads_as_cores
        self.tunnel_migration = tunnel_migration
        self.trusted_service = trusted_service
        self.ballooning_enabled = ballooning_enabled
    def factory(*args_, **kwargs_):
        if Cluster.subclass:
            return Cluster.subclass(*args_, **kwargs_)
        else:
            return Cluster(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cpu(self): return self.cpu
    def set_cpu(self, cpu): self.cpu = cpu
    def get_data_center(self): return self.data_center
    def set_data_center(self, data_center): self.data_center = data_center
    def get_memory_policy(self): return self.memory_policy
    def set_memory_policy(self, memory_policy): self.memory_policy = memory_policy
    def get_scheduling_policy(self): return self.scheduling_policy
    def set_scheduling_policy(self, scheduling_policy): self.scheduling_policy = scheduling_policy
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_supported_versions(self): return self.supported_versions
    def set_supported_versions(self, supported_versions): self.supported_versions = supported_versions
    def get_error_handling(self): return self.error_handling
    def set_error_handling(self, error_handling): self.error_handling = error_handling
    def get_virt_service(self): return self.virt_service
    def set_virt_service(self, virt_service): self.virt_service = virt_service
    def get_gluster_service(self): return self.gluster_service
    def set_gluster_service(self, gluster_service): self.gluster_service = gluster_service
    def get_threads_as_cores(self): return self.threads_as_cores
    def set_threads_as_cores(self, threads_as_cores): self.threads_as_cores = threads_as_cores
    def get_tunnel_migration(self): return self.tunnel_migration
    def set_tunnel_migration(self, tunnel_migration): self.tunnel_migration = tunnel_migration
    def get_trusted_service(self): return self.trusted_service
    def set_trusted_service(self, trusted_service): self.trusted_service = trusted_service
    def get_ballooning_enabled(self): return self.ballooning_enabled
    def set_ballooning_enabled(self, ballooning_enabled): self.ballooning_enabled = ballooning_enabled
    def hasContent_(self):
        if (
            self.cpu is not None or
            self.data_center is not None or
            self.memory_policy is not None or
            self.scheduling_policy is not None or
            self.version is not None or
            self.supported_versions is not None or
            self.error_handling is not None or
            self.virt_service is not None or
            self.gluster_service is not None or
            self.threads_as_cores is not None or
            self.tunnel_migration is not None or
            self.trusted_service is not None or
            self.ballooning_enabled is not None or
            super(Cluster, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Cluster', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Cluster')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Cluster'):
        super(Cluster, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Cluster')
    def exportChildren(self, outfile, level, namespace_='', name_='Cluster', fromsubclass_=False, pretty_print=True):
        super(Cluster, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cpu is not None:
            self.cpu.export(outfile, level, namespace_, name_='cpu', pretty_print=pretty_print)
        if self.data_center is not None:
            self.data_center.export(outfile, level, namespace_, name_='data_center', pretty_print=pretty_print)
        if self.memory_policy is not None:
            self.memory_policy.export(outfile, level, namespace_, name_='memory_policy', pretty_print=pretty_print)
        if self.scheduling_policy is not None:
            self.scheduling_policy.export(outfile, level, namespace_, name_='scheduling_policy', pretty_print=pretty_print)
        if self.version is not None:
            self.version.export(outfile, level, namespace_, name_='version', pretty_print=pretty_print)
        if self.supported_versions is not None:
            self.supported_versions.export(outfile, level, namespace_, name_='supported_versions', pretty_print=pretty_print)
        if self.error_handling is not None:
            self.error_handling.export(outfile, level, namespace_, name_='error_handling', pretty_print=pretty_print)
        if self.virt_service is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svirt_service>%s</%svirt_service>%s' % (namespace_, self.gds_format_boolean(self.virt_service, input_name='virt_service'), namespace_, eol_))
        if self.gluster_service is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgluster_service>%s</%sgluster_service>%s' % (namespace_, self.gds_format_boolean(self.gluster_service, input_name='gluster_service'), namespace_, eol_))
        if self.threads_as_cores is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sthreads_as_cores>%s</%sthreads_as_cores>%s' % (namespace_, self.gds_format_boolean(self.threads_as_cores, input_name='threads_as_cores'), namespace_, eol_))
        if self.tunnel_migration is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stunnel_migration>%s</%stunnel_migration>%s' % (namespace_, self.gds_format_boolean(self.tunnel_migration, input_name='tunnel_migration'), namespace_, eol_))
        if self.trusted_service is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%strusted_service>%s</%strusted_service>%s' % (namespace_, self.gds_format_boolean(self.trusted_service, input_name='trusted_service'), namespace_, eol_))
        if self.ballooning_enabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sballooning_enabled>%s</%sballooning_enabled>%s' % (namespace_, self.gds_format_boolean(self.ballooning_enabled, input_name='ballooning_enabled'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Cluster'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Cluster, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Cluster, self).exportLiteralChildren(outfile, level, name_)
        if self.cpu is not None:
            showIndent(outfile, level)
            outfile.write('cpu=model_.cpu(\n')
            self.cpu.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.data_center is not None:
            showIndent(outfile, level)
            outfile.write('data_center=model_.data_center(\n')
            self.data_center.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.memory_policy is not None:
            showIndent(outfile, level)
            outfile.write('memory_policy=model_.MemoryPolicy(\n')
            self.memory_policy.exportLiteral(outfile, level, name_='memory_policy')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.scheduling_policy is not None:
            showIndent(outfile, level)
            outfile.write('scheduling_policy=model_.SchedulingPolicy(\n')
            self.scheduling_policy.exportLiteral(outfile, level, name_='scheduling_policy')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=model_.Version(\n')
            self.version.exportLiteral(outfile, level, name_='version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.supported_versions is not None:
            showIndent(outfile, level)
            outfile.write('supported_versions=model_.SupportedVersions(\n')
            self.supported_versions.exportLiteral(outfile, level, name_='supported_versions')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.error_handling is not None:
            showIndent(outfile, level)
            outfile.write('error_handling=model_.ErrorHandling(\n')
            self.error_handling.exportLiteral(outfile, level, name_='error_handling')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.virt_service is not None:
            showIndent(outfile, level)
            outfile.write('virt_service=%s,\n' % self.virt_service)
        if self.gluster_service is not None:
            showIndent(outfile, level)
            outfile.write('gluster_service=%s,\n' % self.gluster_service)
        if self.threads_as_cores is not None:
            showIndent(outfile, level)
            outfile.write('threads_as_cores=%s,\n' % self.threads_as_cores)
        if self.tunnel_migration is not None:
            showIndent(outfile, level)
            outfile.write('tunnel_migration=%s,\n' % self.tunnel_migration)
        if self.trusted_service is not None:
            showIndent(outfile, level)
            outfile.write('trusted_service=%s,\n' % self.trusted_service)
        if self.ballooning_enabled is not None:
            showIndent(outfile, level)
            outfile.write('ballooning_enabled=%s,\n' % self.ballooning_enabled)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Cluster, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'cpu':
            obj_ = CPU.factory()
            obj_.build(child_)
            self.set_cpu(obj_)
        elif nodeName_ == 'data_center':
            obj_ = DataCenter.factory()
            obj_.build(child_)
            self.set_data_center(obj_)
        elif nodeName_ == 'memory_policy':
            obj_ = MemoryPolicy.factory()
            obj_.build(child_)
            self.set_memory_policy(obj_)
        elif nodeName_ == 'scheduling_policy':
            obj_ = SchedulingPolicy.factory()
            obj_.build(child_)
            self.set_scheduling_policy(obj_)
        elif nodeName_ == 'version':
            class_obj_ = self.get_class_obj_(child_, Version)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_version(obj_)
        elif nodeName_ == 'supported_versions':
            obj_ = SupportedVersions.factory()
            obj_.build(child_)
            self.set_supported_versions(obj_)
        elif nodeName_ == 'error_handling':
            obj_ = ErrorHandling.factory()
            obj_.build(child_)
            self.set_error_handling(obj_)
        elif nodeName_ == 'virt_service':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'virt_service')
            self.virt_service = ival_
        elif nodeName_ == 'gluster_service':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'gluster_service')
            self.gluster_service = ival_
        elif nodeName_ == 'threads_as_cores':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'threads_as_cores')
            self.threads_as_cores = ival_
        elif nodeName_ == 'tunnel_migration':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'tunnel_migration')
            self.tunnel_migration = ival_
        elif nodeName_ == 'trusted_service':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'trusted_service')
            self.trusted_service = ival_
        elif nodeName_ == 'ballooning_enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ballooning_enabled')
            self.ballooning_enabled = ival_
        super(Cluster, self).buildChildren(child_, node, nodeName_, True)
# end class Cluster


class Clusters(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, cluster=None):
        super(Clusters, self).__init__(actions, total, active, )
        if cluster is None:
            self.cluster = []
        else:
            self.cluster = cluster
    def factory(*args_, **kwargs_):
        if Clusters.subclass:
            return Clusters.subclass(*args_, **kwargs_)
        else:
            return Clusters(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def add_cluster(self, value): self.cluster.append(value)
    def insert_cluster(self, index, value): self.cluster[index] = value
    def hasContent_(self):
        if (
            self.cluster or
            super(Clusters, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Clusters', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Clusters')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Clusters'):
        super(Clusters, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Clusters')
    def exportChildren(self, outfile, level, namespace_='', name_='Clusters', fromsubclass_=False, pretty_print=True):
        super(Clusters, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for cluster_ in self.cluster:
            cluster_.export(outfile, level, namespace_, name_='cluster', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Clusters'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Clusters, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Clusters, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('cluster=[\n')
        level += 1
        for cluster_ in self.cluster:
            showIndent(outfile, level)
            outfile.write('model_.cluster(\n')
            cluster_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Clusters, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.cluster.append(obj_)
        super(Clusters, self).buildChildren(child_, node, nodeName_, True)
# end class Clusters


class Agent(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, address=None, username=None, password=None, options=None, concurrent=None, order=None):
        self.type_ = _cast(None, type_)
        self.address = address
        self.username = username
        self.password = password
        self.options = options
        self.concurrent = concurrent
        self.order = order
    def factory(*args_, **kwargs_):
        if Agent.subclass:
            return Agent.subclass(*args_, **kwargs_)
        else:
            return Agent(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_username(self): return self.username
    def set_username(self, username): self.username = username
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_options(self): return self.options
    def set_options(self, options): self.options = options
    def get_concurrent(self): return self.concurrent
    def set_concurrent(self, concurrent): self.concurrent = concurrent
    def get_order(self): return self.order
    def set_order(self, order): self.order = order
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def hasContent_(self):
        if (
            self.address is not None or
            self.username is not None or
            self.password is not None or
            self.options is not None or
            self.concurrent is not None or
            self.order is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Agent', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Agent')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Agent'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Agent', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.address is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress>%s</%saddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_, eol_))
        if self.username is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%susername>%s</%susername>%s' % (namespace_, self.gds_format_string(quote_xml(self.username).encode(ExternalEncoding), input_name='username'), namespace_, eol_))
        if self.password is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespace_, self.gds_format_string(quote_xml(self.password).encode(ExternalEncoding), input_name='password'), namespace_, eol_))
        if self.options is not None:
            self.options.export(outfile, level, namespace_, name_='options', pretty_print=pretty_print)
        if self.concurrent is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sconcurrent>%s</%sconcurrent>%s' % (namespace_, self.gds_format_boolean(self.concurrent, input_name='concurrent'), namespace_, eol_))
        if self.order is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorder>%s</%sorder>%s' % (namespace_, self.gds_format_integer(self.order, input_name='order'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Agent'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.username is not None:
            showIndent(outfile, level)
            outfile.write('username=%s,\n' % quote_python(self.username).encode(ExternalEncoding))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % quote_python(self.password).encode(ExternalEncoding))
        if self.options is not None:
            showIndent(outfile, level)
            outfile.write('options=model_.options(\n')
            self.options.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.concurrent is not None:
            showIndent(outfile, level)
            outfile.write('concurrent=%s,\n' % self.concurrent)
        if self.order is not None:
            showIndent(outfile, level)
            outfile.write('order=%d,\n' % self.order)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'username':
            username_ = child_.text
            username_ = self.gds_validate_string(username_, node, 'username')
            self.username = username_
        elif nodeName_ == 'password':
            password_ = child_.text
            password_ = self.gds_validate_string(password_, node, 'password')
            self.password = password_
        elif nodeName_ == 'options':
            obj_ = Options.factory()
            obj_.build(child_)
            self.set_options(obj_)
        elif nodeName_ == 'concurrent':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'concurrent')
            self.concurrent = ival_
        elif nodeName_ == 'order':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'order')
            self.order = ival_
# end class Agent


class Agents(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, agent=None):
        if agent is None:
            self.agent = []
        else:
            self.agent = agent
    def factory(*args_, **kwargs_):
        if Agents.subclass:
            return Agents.subclass(*args_, **kwargs_)
        else:
            return Agents(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_agent(self): return self.agent
    def set_agent(self, agent): self.agent = agent
    def add_agent(self, value): self.agent.append(value)
    def insert_agent(self, index, value): self.agent[index] = value
    def hasContent_(self):
        if (
            self.agent
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Agents', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Agents')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Agents'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Agents', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for agent_ in self.agent:
            agent_.export(outfile, level, namespace_, name_='agent', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Agents'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('agent=[\n')
        level += 1
        for agent_ in self.agent:
            showIndent(outfile, level)
            outfile.write('model_.Agent(\n')
            agent_.exportLiteral(outfile, level, name_='Agent')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'agent':
            obj_ = Agent.factory()
            obj_.build(child_)
            self.agent.append(obj_)
# end class Agents


class PowerManagement(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, enabled=None, address=None, username=None, password=None, options=None, status=None, pm_proxies=None, agents=None):
        self.type_ = _cast(None, type_)
        self.enabled = enabled
        self.address = address
        self.username = username
        self.password = password
        self.options = options
        self.status = status
        self.pm_proxies = pm_proxies
        self.agents = agents
    def factory(*args_, **kwargs_):
        if PowerManagement.subclass:
            return PowerManagement.subclass(*args_, **kwargs_)
        else:
            return PowerManagement(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_enabled(self): return self.enabled
    def set_enabled(self, enabled): self.enabled = enabled
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_username(self): return self.username
    def set_username(self, username): self.username = username
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_options(self): return self.options
    def set_options(self, options): self.options = options
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_pm_proxies(self): return self.pm_proxies
    def set_pm_proxies(self, pm_proxies): self.pm_proxies = pm_proxies
    def get_agents(self): return self.agents
    def set_agents(self, agents): self.agents = agents
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def hasContent_(self):
        if (
            self.enabled is not None or
            self.address is not None or
            self.username is not None or
            self.password is not None or
            self.options is not None or
            self.status is not None or
            self.pm_proxies is not None or
            self.agents is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PowerManagement', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PowerManagement')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PowerManagement'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PowerManagement', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.enabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%senabled>%s</%senabled>%s' % (namespace_, self.gds_format_boolean(self.enabled, input_name='enabled'), namespace_, eol_))
        if self.address is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress>%s</%saddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_, eol_))
        if self.username is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%susername>%s</%susername>%s' % (namespace_, self.gds_format_string(quote_xml(self.username).encode(ExternalEncoding), input_name='username'), namespace_, eol_))
        if self.password is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespace_, self.gds_format_string(quote_xml(self.password).encode(ExternalEncoding), input_name='password'), namespace_, eol_))
        if self.options is not None:
            self.options.export(outfile, level, namespace_, name_='options', pretty_print=pretty_print)
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status', pretty_print=pretty_print)
        if self.pm_proxies is not None:
            self.pm_proxies.export(outfile, level, namespace_, name_='pm_proxies', pretty_print=pretty_print)
        if self.agents is not None:
            self.agents.export(outfile, level, namespace_, name_='agents', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='PowerManagement'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.enabled is not None:
            showIndent(outfile, level)
            outfile.write('enabled=%s,\n' % self.enabled)
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.username is not None:
            showIndent(outfile, level)
            outfile.write('username=%s,\n' % quote_python(self.username).encode(ExternalEncoding))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % quote_python(self.password).encode(ExternalEncoding))
        if self.options is not None:
            showIndent(outfile, level)
            outfile.write('options=model_.Options(\n')
            self.options.exportLiteral(outfile, level, name_='options')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.pm_proxies is not None:
            showIndent(outfile, level)
            outfile.write('pm_proxies=model_.pm_proxies(\n')
            self.pm_proxies.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.agents is not None:
            showIndent(outfile, level)
            outfile.write('agents=model_.agents(\n')
            self.agents.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'enabled')
            self.enabled = ival_
        elif nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'username':
            username_ = child_.text
            username_ = self.gds_validate_string(username_, node, 'username')
            self.username = username_
        elif nodeName_ == 'password':
            password_ = child_.text
            password_ = self.gds_validate_string(password_, node, 'password')
            self.password = password_
        elif nodeName_ == 'options':
            obj_ = Options.factory()
            obj_.build(child_)
            self.set_options(obj_)
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.set_status(obj_)
        elif nodeName_ == 'pm_proxies':
            obj_ = PmProxies.factory()
            obj_.build(child_)
            self.set_pm_proxies(obj_)
        elif nodeName_ == 'agents':
            obj_ = Agents.factory()
            obj_.build(child_)
            self.set_agents(obj_)
# end class PowerManagement


class PowerManagementStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, power_management_state=None):
        if power_management_state is None:
            self.power_management_state = []
        else:
            self.power_management_state = power_management_state
    def factory(*args_, **kwargs_):
        if PowerManagementStates.subclass:
            return PowerManagementStates.subclass(*args_, **kwargs_)
        else:
            return PowerManagementStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_power_management_state(self): return self.power_management_state
    def set_power_management_state(self, power_management_state): self.power_management_state = power_management_state
    def add_power_management_state(self, value): self.power_management_state.append(value)
    def insert_power_management_state(self, index, value): self.power_management_state[index] = value
    def hasContent_(self):
        if (
            self.power_management_state
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PowerManagementStates', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PowerManagementStates')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PowerManagementStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='PowerManagementStates', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for power_management_state_ in self.power_management_state:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spower_management_state>%s</%spower_management_state>%s' % (namespace_, self.gds_format_string(quote_xml(power_management_state_).encode(ExternalEncoding), input_name='power_management_state'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='PowerManagementStates'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('power_management_state=[\n')
        level += 1
        for power_management_state_ in self.power_management_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(power_management_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'power_management_state':
            power_management_state_ = child_.text
            power_management_state_ = self.gds_validate_string(power_management_state_, node, 'power_management_state')
            self.power_management_state.append(power_management_state_)
# end class PowerManagementStates


class HardwareInformation(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, manufacturer=None, version=None, serial_number=None, product_name=None, uuid=None, family=None):
        self.manufacturer = manufacturer
        self.version = version
        self.serial_number = serial_number
        self.product_name = product_name
        self.uuid = uuid
        self.family = family
    def factory(*args_, **kwargs_):
        if HardwareInformation.subclass:
            return HardwareInformation.subclass(*args_, **kwargs_)
        else:
            return HardwareInformation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_manufacturer(self): return self.manufacturer
    def set_manufacturer(self, manufacturer): self.manufacturer = manufacturer
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_serial_number(self): return self.serial_number
    def set_serial_number(self, serial_number): self.serial_number = serial_number
    def get_product_name(self): return self.product_name
    def set_product_name(self, product_name): self.product_name = product_name
    def get_uuid(self): return self.uuid
    def set_uuid(self, uuid): self.uuid = uuid
    def get_family(self): return self.family
    def set_family(self, family): self.family = family
    def hasContent_(self):
        if (
            self.manufacturer is not None or
            self.version is not None or
            self.serial_number is not None or
            self.product_name is not None or
            self.uuid is not None or
            self.family is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='HardwareInformation', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HardwareInformation')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HardwareInformation'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='HardwareInformation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.manufacturer is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smanufacturer>%s</%smanufacturer>%s' % (namespace_, self.gds_format_string(quote_xml(self.manufacturer).encode(ExternalEncoding), input_name='manufacturer'), namespace_, eol_))
        if self.version is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion>%s</%sversion>%s' % (namespace_, self.gds_format_string(quote_xml(self.version).encode(ExternalEncoding), input_name='version'), namespace_, eol_))
        if self.serial_number is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sserial_number>%s</%sserial_number>%s' % (namespace_, self.gds_format_string(quote_xml(self.serial_number).encode(ExternalEncoding), input_name='serial_number'), namespace_, eol_))
        if self.product_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sproduct_name>%s</%sproduct_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.product_name).encode(ExternalEncoding), input_name='product_name'), namespace_, eol_))
        if self.uuid is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suuid>%s</%suuid>%s' % (namespace_, self.gds_format_string(quote_xml(self.uuid).encode(ExternalEncoding), input_name='uuid'), namespace_, eol_))
        if self.family is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfamily>%s</%sfamily>%s' % (namespace_, self.gds_format_string(quote_xml(self.family).encode(ExternalEncoding), input_name='family'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='HardwareInformation'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.manufacturer is not None:
            showIndent(outfile, level)
            outfile.write('manufacturer=%s,\n' % quote_python(self.manufacturer).encode(ExternalEncoding))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=%s,\n' % quote_python(self.version).encode(ExternalEncoding))
        if self.serial_number is not None:
            showIndent(outfile, level)
            outfile.write('serial_number=%s,\n' % quote_python(self.serial_number).encode(ExternalEncoding))
        if self.product_name is not None:
            showIndent(outfile, level)
            outfile.write('product_name=%s,\n' % quote_python(self.product_name).encode(ExternalEncoding))
        if self.uuid is not None:
            showIndent(outfile, level)
            outfile.write('uuid=%s,\n' % quote_python(self.uuid).encode(ExternalEncoding))
        if self.family is not None:
            showIndent(outfile, level)
            outfile.write('family=%s,\n' % quote_python(self.family).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'manufacturer':
            manufacturer_ = child_.text
            manufacturer_ = self.gds_validate_string(manufacturer_, node, 'manufacturer')
            self.manufacturer = manufacturer_
        elif nodeName_ == 'version':
            version_ = child_.text
            version_ = self.gds_validate_string(version_, node, 'version')
            self.version = version_
        elif nodeName_ == 'serial_number':
            serial_number_ = child_.text
            serial_number_ = self.gds_validate_string(serial_number_, node, 'serial_number')
            self.serial_number = serial_number_
        elif nodeName_ == 'product_name':
            product_name_ = child_.text
            product_name_ = self.gds_validate_string(product_name_, node, 'product_name')
            self.product_name = product_name_
        elif nodeName_ == 'uuid':
            uuid_ = child_.text
            uuid_ = self.gds_validate_string(uuid_, node, 'uuid')
            self.uuid = uuid_
        elif nodeName_ == 'family':
            family_ = child_.text
            family_ = self.gds_validate_string(family_, node, 'family')
            self.family = family_
# end class HardwareInformation


class PowerManagers(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, power_management=None):
        if power_management is None:
            self.power_management = []
        else:
            self.power_management = power_management
    def factory(*args_, **kwargs_):
        if PowerManagers.subclass:
            return PowerManagers.subclass(*args_, **kwargs_)
        else:
            return PowerManagers(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_power_management(self): return self.power_management
    def set_power_management(self, power_management): self.power_management = power_management
    def add_power_management(self, value): self.power_management.append(value)
    def insert_power_management(self, index, value): self.power_management[index] = value
    def hasContent_(self):
        if (
            self.power_management
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PowerManagers', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PowerManagers')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PowerManagers'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='PowerManagers', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for power_management_ in self.power_management:
            power_management_.export(outfile, level, namespace_, name_='power_management', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='PowerManagers'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('power_management=[\n')
        level += 1
        for power_management_ in self.power_management:
            showIndent(outfile, level)
            outfile.write('model_.power_management(\n')
            power_management_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'power_management':
            obj_ = PowerManagement.factory()
            obj_.build(child_)
            self.power_management.append(obj_)
# end class PowerManagers


class KSM(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, enabled=None):
        self.enabled = enabled
    def factory(*args_, **kwargs_):
        if KSM.subclass:
            return KSM.subclass(*args_, **kwargs_)
        else:
            return KSM(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_enabled(self): return self.enabled
    def set_enabled(self, enabled): self.enabled = enabled
    def hasContent_(self):
        if (
            self.enabled is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='KSM', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='KSM')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='KSM'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='KSM', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.enabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%senabled>%s</%senabled>%s' % (namespace_, self.gds_format_boolean(self.enabled, input_name='enabled'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='KSM'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.enabled is not None:
            showIndent(outfile, level)
            outfile.write('enabled=%s,\n' % self.enabled)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'enabled')
            self.enabled = ival_
# end class KSM


class TransparentHugePages(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, enabled=None):
        self.enabled = enabled
    def factory(*args_, **kwargs_):
        if TransparentHugePages.subclass:
            return TransparentHugePages.subclass(*args_, **kwargs_)
        else:
            return TransparentHugePages(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_enabled(self): return self.enabled
    def set_enabled(self, enabled): self.enabled = enabled
    def hasContent_(self):
        if (
            self.enabled is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TransparentHugePages', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TransparentHugePages')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TransparentHugePages'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='TransparentHugePages', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.enabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%senabled>%s</%senabled>%s' % (namespace_, self.gds_format_boolean(self.enabled, input_name='enabled'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='TransparentHugePages'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.enabled is not None:
            showIndent(outfile, level)
            outfile.write('enabled=%s,\n' % self.enabled)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'enabled')
            self.enabled = ival_
# end class TransparentHugePages


class Certificate(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, organization=None, subject=None):
        self.organization = organization
        self.subject = subject
    def factory(*args_, **kwargs_):
        if Certificate.subclass:
            return Certificate.subclass(*args_, **kwargs_)
        else:
            return Certificate(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_organization(self): return self.organization
    def set_organization(self, organization): self.organization = organization
    def get_subject(self): return self.subject
    def set_subject(self, subject): self.subject = subject
    def hasContent_(self):
        if (
            self.organization is not None or
            self.subject is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Certificate', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Certificate')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Certificate'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Certificate', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.organization is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorganization>%s</%sorganization>%s' % (namespace_, self.gds_format_string(quote_xml(self.organization).encode(ExternalEncoding), input_name='organization'), namespace_, eol_))
        if self.subject is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssubject>%s</%ssubject>%s' % (namespace_, self.gds_format_string(quote_xml(self.subject).encode(ExternalEncoding), input_name='subject'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Certificate'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.organization is not None:
            showIndent(outfile, level)
            outfile.write('organization=%s,\n' % quote_python(self.organization).encode(ExternalEncoding))
        if self.subject is not None:
            showIndent(outfile, level)
            outfile.write('subject=%s,\n' % quote_python(self.subject).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'organization':
            organization_ = child_.text
            organization_ = self.gds_validate_string(organization_, node, 'organization')
            self.organization = organization_
        elif nodeName_ == 'subject':
            subject_ = child_.text
            subject_ = self.gds_validate_string(subject_, node, 'subject')
            self.subject = subject_
# end class Certificate


class Host(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, address=None, certificate=None, status=None, cluster=None, port=None, type_=None, storage_manager=None, version=None, hardware_information=None, power_management=None, ksm=None, transparent_hugepages=None, iscsi=None, root_password=None, ssh=None, statistics=None, cpu=None, memory=None, max_scheduling_memory=None, summary=None, override_iptables=None, reboot_after_installation=None, os=None, hooks=None, libvirt_version=None, display=None):
        super(Host, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.address = address
        self.certificate = certificate
        self.status = status
        self.cluster = cluster
        self.port = port
        self.type_ = type_
        self.storage_manager = storage_manager
        self.version = version
        self.hardware_information = hardware_information
        self.power_management = power_management
        self.ksm = ksm
        self.transparent_hugepages = transparent_hugepages
        self.iscsi = iscsi
        self.root_password = root_password
        self.ssh = ssh
        self.statistics = statistics
        self.cpu = cpu
        self.memory = memory
        self.max_scheduling_memory = max_scheduling_memory
        self.summary = summary
        self.override_iptables = override_iptables
        self.reboot_after_installation = reboot_after_installation
        self.os = os
        self.hooks = hooks
        self.libvirt_version = libvirt_version
        self.display = display
    def factory(*args_, **kwargs_):
        if Host.subclass:
            return Host.subclass(*args_, **kwargs_)
        else:
            return Host(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_certificate(self): return self.certificate
    def set_certificate(self, certificate): self.certificate = certificate
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def get_port(self): return self.port
    def set_port(self, port): self.port = port
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_storage_manager(self): return self.storage_manager
    def set_storage_manager(self, storage_manager): self.storage_manager = storage_manager
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_hardware_information(self): return self.hardware_information
    def set_hardware_information(self, hardware_information): self.hardware_information = hardware_information
    def get_power_management(self): return self.power_management
    def set_power_management(self, power_management): self.power_management = power_management
    def get_ksm(self): return self.ksm
    def set_ksm(self, ksm): self.ksm = ksm
    def get_transparent_hugepages(self): return self.transparent_hugepages
    def set_transparent_hugepages(self, transparent_hugepages): self.transparent_hugepages = transparent_hugepages
    def get_iscsi(self): return self.iscsi
    def set_iscsi(self, iscsi): self.iscsi = iscsi
    def get_root_password(self): return self.root_password
    def set_root_password(self, root_password): self.root_password = root_password
    def get_ssh(self): return self.ssh
    def set_ssh(self, ssh): self.ssh = ssh
    def get_statistics(self): return self.statistics
    def set_statistics(self, statistics): self.statistics = statistics
    def get_cpu(self): return self.cpu
    def set_cpu(self, cpu): self.cpu = cpu
    def get_memory(self): return self.memory
    def set_memory(self, memory): self.memory = memory
    def get_max_scheduling_memory(self): return self.max_scheduling_memory
    def set_max_scheduling_memory(self, max_scheduling_memory): self.max_scheduling_memory = max_scheduling_memory
    def get_summary(self): return self.summary
    def set_summary(self, summary): self.summary = summary
    def get_override_iptables(self): return self.override_iptables
    def set_override_iptables(self, override_iptables): self.override_iptables = override_iptables
    def get_reboot_after_installation(self): return self.reboot_after_installation
    def set_reboot_after_installation(self, reboot_after_installation): self.reboot_after_installation = reboot_after_installation
    def get_os(self): return self.os
    def set_os(self, os): self.os = os
    def get_hooks(self): return self.hooks
    def set_hooks(self, hooks): self.hooks = hooks
    def get_libvirt_version(self): return self.libvirt_version
    def set_libvirt_version(self, libvirt_version): self.libvirt_version = libvirt_version
    def get_display(self): return self.display
    def set_display(self, display): self.display = display
    def hasContent_(self):
        if (
            self.address is not None or
            self.certificate is not None or
            self.status is not None or
            self.cluster is not None or
            self.port is not None or
            self.type_ is not None or
            self.storage_manager is not None or
            self.version is not None or
            self.hardware_information is not None or
            self.power_management is not None or
            self.ksm is not None or
            self.transparent_hugepages is not None or
            self.iscsi is not None or
            self.root_password is not None or
            self.ssh is not None or
            self.statistics is not None or
            self.cpu is not None or
            self.memory is not None or
            self.max_scheduling_memory is not None or
            self.summary is not None or
            self.override_iptables is not None or
            self.reboot_after_installation is not None or
            self.os is not None or
            self.hooks is not None or
            self.libvirt_version is not None or
            self.display is not None or
            super(Host, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Host', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Host')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Host'):
        super(Host, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Host')
    def exportChildren(self, outfile, level, namespace_='', name_='Host', fromsubclass_=False, pretty_print=True):
        super(Host, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.address is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress>%s</%saddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_, eol_))
        if self.certificate is not None:
            self.certificate.export(outfile, level, namespace_, name_='certificate', pretty_print=pretty_print)
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status', pretty_print=pretty_print)
        if self.cluster is not None:
            self.cluster.export(outfile, level, namespace_, name_='cluster', pretty_print=pretty_print)
        if self.port is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sport>%s</%sport>%s' % (namespace_, self.gds_format_integer(self.port, input_name='port'), namespace_, eol_))
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.storage_manager is not None:
            self.storage_manager.export(outfile, level, namespace_, name_='storage_manager', pretty_print=pretty_print)
        if self.version is not None:
            self.version.export(outfile, level, namespace_, name_='version', pretty_print=pretty_print)
        if self.hardware_information is not None:
            self.hardware_information.export(outfile, level, namespace_, name_='hardware_information', pretty_print=pretty_print)
        if self.power_management is not None:
            self.power_management.export(outfile, level, namespace_, name_='power_management', pretty_print=pretty_print)
        if self.ksm is not None:
            self.ksm.export(outfile, level, namespace_, name_='ksm', pretty_print=pretty_print)
        if self.transparent_hugepages is not None:
            self.transparent_hugepages.export(outfile, level, namespace_, name_='transparent_hugepages', pretty_print=pretty_print)
        if self.iscsi is not None:
            self.iscsi.export(outfile, level, namespace_, name_='iscsi', pretty_print=pretty_print)
        if self.root_password is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sroot_password>%s</%sroot_password>%s' % (namespace_, self.gds_format_string(quote_xml(self.root_password).encode(ExternalEncoding), input_name='root_password'), namespace_, eol_))
        if self.ssh is not None:
            self.ssh.export(outfile, level, namespace_, name_='ssh', pretty_print=pretty_print)
        if self.statistics is not None:
            self.statistics.export(outfile, level, namespace_, name_='statistics', pretty_print=pretty_print)
        if self.cpu is not None:
            self.cpu.export(outfile, level, namespace_, name_='cpu', pretty_print=pretty_print)
        if self.memory is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smemory>%s</%smemory>%s' % (namespace_, self.gds_format_integer(self.memory, input_name='memory'), namespace_, eol_))
        if self.max_scheduling_memory is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smax_scheduling_memory>%s</%smax_scheduling_memory>%s' % (namespace_, self.gds_format_integer(self.max_scheduling_memory, input_name='max_scheduling_memory'), namespace_, eol_))
        if self.summary is not None:
            self.summary.export(outfile, level, namespace_, name_='summary', pretty_print=pretty_print)
        if self.override_iptables is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soverride_iptables>%s</%soverride_iptables>%s' % (namespace_, self.gds_format_boolean(self.override_iptables, input_name='override_iptables'), namespace_, eol_))
        if self.reboot_after_installation is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreboot_after_installation>%s</%sreboot_after_installation>%s' % (namespace_, self.gds_format_boolean(self.reboot_after_installation, input_name='reboot_after_installation'), namespace_, eol_))
        if self.os is not None:
            self.os.export(outfile, level, namespace_, name_='os', pretty_print=pretty_print)
        if self.hooks is not None:
            self.hooks.export(outfile, level, namespace_, name_='hooks', pretty_print=pretty_print)
        if self.libvirt_version is not None:
            self.libvirt_version.export(outfile, level, namespace_, name_='libvirt_version', pretty_print=pretty_print)
        if self.display is not None:
            self.display.export(outfile, level, namespace_, name_='display', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Host'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Host, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Host, self).exportLiteralChildren(outfile, level, name_)
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.certificate is not None:
            showIndent(outfile, level)
            outfile.write('certificate=model_.certificate(\n')
            self.certificate.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cluster is not None:
            showIndent(outfile, level)
            outfile.write('cluster=model_.Cluster(\n')
            self.cluster.exportLiteral(outfile, level, name_='cluster')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('port=%d,\n' % self.port)
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.storage_manager is not None:
            showIndent(outfile, level)
            outfile.write('storage_manager=model_.StorageManager(\n')
            self.storage_manager.exportLiteral(outfile, level, name_='storage_manager')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=model_.Version(\n')
            self.version.exportLiteral(outfile, level, name_='version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.hardware_information is not None:
            showIndent(outfile, level)
            outfile.write('hardware_information=model_.hardware_information(\n')
            self.hardware_information.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.power_management is not None:
            showIndent(outfile, level)
            outfile.write('power_management=model_.power_management(\n')
            self.power_management.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ksm is not None:
            showIndent(outfile, level)
            outfile.write('ksm=model_.ksm(\n')
            self.ksm.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.transparent_hugepages is not None:
            showIndent(outfile, level)
            outfile.write('transparent_hugepages=model_.transparent_hugepages(\n')
            self.transparent_hugepages.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.iscsi is not None:
            showIndent(outfile, level)
            outfile.write('iscsi=model_.IscsiDetails(\n')
            self.iscsi.exportLiteral(outfile, level, name_='iscsi')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.root_password is not None:
            showIndent(outfile, level)
            outfile.write('root_password=%s,\n' % quote_python(self.root_password).encode(ExternalEncoding))
        if self.ssh is not None:
            showIndent(outfile, level)
            outfile.write('ssh=model_.ssh(\n')
            self.ssh.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.statistics is not None:
            showIndent(outfile, level)
            outfile.write('statistics=model_.Statistics(\n')
            self.statistics.exportLiteral(outfile, level, name_='statistics')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cpu is not None:
            showIndent(outfile, level)
            outfile.write('cpu=model_.cpu(\n')
            self.cpu.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.memory is not None:
            showIndent(outfile, level)
            outfile.write('memory=%d,\n' % self.memory)
        if self.max_scheduling_memory is not None:
            showIndent(outfile, level)
            outfile.write('max_scheduling_memory=%d,\n' % self.max_scheduling_memory)
        if self.summary is not None:
            showIndent(outfile, level)
            outfile.write('summary=model_.VmSummary(\n')
            self.summary.exportLiteral(outfile, level, name_='summary')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.override_iptables is not None:
            showIndent(outfile, level)
            outfile.write('override_iptables=%s,\n' % self.override_iptables)
        if self.reboot_after_installation is not None:
            showIndent(outfile, level)
            outfile.write('reboot_after_installation=%s,\n' % self.reboot_after_installation)
        if self.os is not None:
            showIndent(outfile, level)
            outfile.write('os=model_.OperatingSystem(\n')
            self.os.exportLiteral(outfile, level, name_='os')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.hooks is not None:
            showIndent(outfile, level)
            outfile.write('hooks=model_.hooks(\n')
            self.hooks.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.libvirt_version is not None:
            showIndent(outfile, level)
            outfile.write('libvirt_version=model_.Version(\n')
            self.libvirt_version.exportLiteral(outfile, level, name_='libvirt_version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.display is not None:
            showIndent(outfile, level)
            outfile.write('display=model_.display(\n')
            self.display.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Host, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'certificate':
            obj_ = Certificate.factory()
            obj_.build(child_)
            self.set_certificate(obj_)
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.set_status(obj_)
        elif nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.set_cluster(obj_)
        elif nodeName_ == 'port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'port')
            self.port = ival_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'storage_manager':
            obj_ = StorageManager.factory()
            obj_.build(child_)
            self.set_storage_manager(obj_)
        elif nodeName_ == 'version':
            class_obj_ = self.get_class_obj_(child_, Version)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_version(obj_)
        elif nodeName_ == 'hardware_information':
            obj_ = HardwareInformation.factory()
            obj_.build(child_)
            self.set_hardware_information(obj_)
        elif nodeName_ == 'power_management':
            obj_ = PowerManagement.factory()
            obj_.build(child_)
            self.set_power_management(obj_)
        elif nodeName_ == 'ksm':
            obj_ = KSM.factory()
            obj_.build(child_)
            self.set_ksm(obj_)
        elif nodeName_ == 'transparent_hugepages':
            obj_ = TransparentHugePages.factory()
            obj_.build(child_)
            self.set_transparent_hugepages(obj_)
        elif nodeName_ == 'iscsi':
            obj_ = IscsiDetails.factory()
            obj_.build(child_)
            self.set_iscsi(obj_)
        elif nodeName_ == 'root_password':
            root_password_ = child_.text
            root_password_ = self.gds_validate_string(root_password_, node, 'root_password')
            self.root_password = root_password_
        elif nodeName_ == 'ssh':
            obj_ = SSH.factory()
            obj_.build(child_)
            self.set_ssh(obj_)
        elif nodeName_ == 'statistics':
            obj_ = Statistics.factory()
            obj_.build(child_)
            self.set_statistics(obj_)
        elif nodeName_ == 'cpu':
            obj_ = CPU.factory()
            obj_.build(child_)
            self.set_cpu(obj_)
        elif nodeName_ == 'memory':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'memory')
            self.memory = ival_
        elif nodeName_ == 'max_scheduling_memory':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'max_scheduling_memory')
            self.max_scheduling_memory = ival_
        elif nodeName_ == 'summary':
            obj_ = VmSummary.factory()
            obj_.build(child_)
            self.set_summary(obj_)
        elif nodeName_ == 'override_iptables':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'override_iptables')
            self.override_iptables = ival_
        elif nodeName_ == 'reboot_after_installation':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'reboot_after_installation')
            self.reboot_after_installation = ival_
        elif nodeName_ == 'os':
            obj_ = OperatingSystem.factory()
            obj_.build(child_)
            self.set_os(obj_)
        elif nodeName_ == 'hooks':
            obj_ = Hooks.factory()
            obj_.build(child_)
            self.set_hooks(obj_)
        elif nodeName_ == 'libvirt_version':
            class_obj_ = self.get_class_obj_(child_, Version)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_libvirt_version(obj_)
        elif nodeName_ == 'display':
            obj_ = Display.factory()
            obj_.build(child_)
            self.set_display(obj_)
        super(Host, self).buildChildren(child_, node, nodeName_, True)
# end class Host


class StorageManager(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, priority=None, valueOf_=None):
        self.priority = _cast(int, priority)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if StorageManager.subclass:
            return StorageManager.subclass(*args_, **kwargs_)
        else:
            return StorageManager(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_priority(self): return self.priority
    def set_priority(self, priority): self.priority = priority
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StorageManager', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageManager')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageManager'):
        if self.priority is not None and 'priority' not in already_processed:
            already_processed.add('priority')
            outfile.write(' priority="%s"' % self.gds_format_integer(self.priority, input_name='priority'))
    def exportChildren(self, outfile, level, namespace_='', name_='StorageManager', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='StorageManager'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.priority is not None and 'priority' not in already_processed:
            already_processed.add('priority')
            showIndent(outfile, level)
            outfile.write('priority = %d,\n' % (self.priority,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('priority', node)
        if value is not None and 'priority' not in already_processed:
            already_processed.add('priority')
            try:
                self.priority = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class StorageManager


class HostStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, host_state=None):
        if host_state is None:
            self.host_state = []
        else:
            self.host_state = host_state
    def factory(*args_, **kwargs_):
        if HostStates.subclass:
            return HostStates.subclass(*args_, **kwargs_)
        else:
            return HostStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_host_state(self): return self.host_state
    def set_host_state(self, host_state): self.host_state = host_state
    def add_host_state(self, value): self.host_state.append(value)
    def insert_host_state(self, index, value): self.host_state[index] = value
    def hasContent_(self):
        if (
            self.host_state
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='HostStates', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HostStates')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HostStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='HostStates', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for host_state_ in self.host_state:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shost_state>%s</%shost_state>%s' % (namespace_, self.gds_format_string(quote_xml(host_state_).encode(ExternalEncoding), input_name='host_state'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='HostStates'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('host_state=[\n')
        level += 1
        for host_state_ in self.host_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(host_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'host_state':
            host_state_ = child_.text
            host_state_ = self.gds_validate_string(host_state_, node, 'host_state')
            self.host_state.append(host_state_)
# end class HostStates


class HostNonOperationalDetails(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, host_non_operational_detail=None):
        if host_non_operational_detail is None:
            self.host_non_operational_detail = []
        else:
            self.host_non_operational_detail = host_non_operational_detail
    def factory(*args_, **kwargs_):
        if HostNonOperationalDetails.subclass:
            return HostNonOperationalDetails.subclass(*args_, **kwargs_)
        else:
            return HostNonOperationalDetails(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_host_non_operational_detail(self): return self.host_non_operational_detail
    def set_host_non_operational_detail(self, host_non_operational_detail): self.host_non_operational_detail = host_non_operational_detail
    def add_host_non_operational_detail(self, value): self.host_non_operational_detail.append(value)
    def insert_host_non_operational_detail(self, index, value): self.host_non_operational_detail[index] = value
    def hasContent_(self):
        if (
            self.host_non_operational_detail
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='HostNonOperationalDetails', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HostNonOperationalDetails')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HostNonOperationalDetails'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='HostNonOperationalDetails', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for host_non_operational_detail_ in self.host_non_operational_detail:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shost_non_operational_detail>%s</%shost_non_operational_detail>%s' % (namespace_, self.gds_format_string(quote_xml(host_non_operational_detail_).encode(ExternalEncoding), input_name='host_non_operational_detail'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='HostNonOperationalDetails'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('host_non_operational_detail=[\n')
        level += 1
        for host_non_operational_detail_ in self.host_non_operational_detail:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(host_non_operational_detail_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'host_non_operational_detail':
            host_non_operational_detail_ = child_.text
            host_non_operational_detail_ = self.gds_validate_string(host_non_operational_detail_, node, 'host_non_operational_detail')
            self.host_non_operational_detail.append(host_non_operational_detail_)
# end class HostNonOperationalDetails


class VmSummary(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, active=None, migrating=None, total=None):
        self.active = active
        self.migrating = migrating
        self.total = total
    def factory(*args_, **kwargs_):
        if VmSummary.subclass:
            return VmSummary.subclass(*args_, **kwargs_)
        else:
            return VmSummary(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_active(self): return self.active
    def set_active(self, active): self.active = active
    def get_migrating(self): return self.migrating
    def set_migrating(self, migrating): self.migrating = migrating
    def get_total(self): return self.total
    def set_total(self, total): self.total = total
    def hasContent_(self):
        if (
            self.active is not None or
            self.migrating is not None or
            self.total is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VmSummary', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmSummary')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmSummary'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VmSummary', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.active is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sactive>%s</%sactive>%s' % (namespace_, self.gds_format_integer(self.active, input_name='active'), namespace_, eol_))
        if self.migrating is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smigrating>%s</%smigrating>%s' % (namespace_, self.gds_format_integer(self.migrating, input_name='migrating'), namespace_, eol_))
        if self.total is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotal>%s</%stotal>%s' % (namespace_, self.gds_format_integer(self.total, input_name='total'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='VmSummary'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.active is not None:
            showIndent(outfile, level)
            outfile.write('active=%d,\n' % self.active)
        if self.migrating is not None:
            showIndent(outfile, level)
            outfile.write('migrating=%d,\n' % self.migrating)
        if self.total is not None:
            showIndent(outfile, level)
            outfile.write('total=%d,\n' % self.total)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'active':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'active')
            self.active = ival_
        elif nodeName_ == 'migrating':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'migrating')
            self.migrating = ival_
        elif nodeName_ == 'total':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'total')
            self.total = ival_
# end class VmSummary


class Hosts(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, host=None):
        super(Hosts, self).__init__(actions, total, active, )
        if host is None:
            self.host = []
        else:
            self.host = host
    def factory(*args_, **kwargs_):
        if Hosts.subclass:
            return Hosts.subclass(*args_, **kwargs_)
        else:
            return Hosts(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def add_host(self, value): self.host.append(value)
    def insert_host(self, index, value): self.host[index] = value
    def hasContent_(self):
        if (
            self.host or
            super(Hosts, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Hosts', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Hosts')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Hosts'):
        super(Hosts, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Hosts')
    def exportChildren(self, outfile, level, namespace_='', name_='Hosts', fromsubclass_=False, pretty_print=True):
        super(Hosts, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for host_ in self.host:
            host_.export(outfile, level, namespace_, name_='host', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Hosts'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Hosts, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Hosts, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('host=[\n')
        level += 1
        for host_ in self.host:
            showIndent(outfile, level)
            outfile.write('model_.host(\n')
            host_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Hosts, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.host.append(obj_)
        super(Hosts, self).buildChildren(child_, node, nodeName_, True)
# end class Hosts


class Permit(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, administrative=None, role=None):
        super(Permit, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.administrative = administrative
        self.role = role
    def factory(*args_, **kwargs_):
        if Permit.subclass:
            return Permit.subclass(*args_, **kwargs_)
        else:
            return Permit(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_administrative(self): return self.administrative
    def set_administrative(self, administrative): self.administrative = administrative
    def get_role(self): return self.role
    def set_role(self, role): self.role = role
    def hasContent_(self):
        if (
            self.administrative is not None or
            self.role is not None or
            super(Permit, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Permit', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Permit')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Permit'):
        super(Permit, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Permit')
    def exportChildren(self, outfile, level, namespace_='', name_='Permit', fromsubclass_=False, pretty_print=True):
        super(Permit, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.administrative is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sadministrative>%s</%sadministrative>%s' % (namespace_, self.gds_format_boolean(self.administrative, input_name='administrative'), namespace_, eol_))
        if self.role is not None:
            self.role.export(outfile, level, namespace_, name_='role', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Permit'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Permit, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Permit, self).exportLiteralChildren(outfile, level, name_)
        if self.administrative is not None:
            showIndent(outfile, level)
            outfile.write('administrative=%s,\n' % self.administrative)
        if self.role is not None:
            showIndent(outfile, level)
            outfile.write('role=model_.Role(\n')
            self.role.exportLiteral(outfile, level, name_='role')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Permit, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'administrative':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'administrative')
            self.administrative = ival_
        elif nodeName_ == 'role':
            obj_ = Role.factory()
            obj_.build(child_)
            self.set_role(obj_)
        super(Permit, self).buildChildren(child_, node, nodeName_, True)
# end class Permit


class Permits(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, permit=None):
        super(Permits, self).__init__(actions, total, active, )
        if permit is None:
            self.permit = []
        else:
            self.permit = permit
    def factory(*args_, **kwargs_):
        if Permits.subclass:
            return Permits.subclass(*args_, **kwargs_)
        else:
            return Permits(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_permit(self): return self.permit
    def set_permit(self, permit): self.permit = permit
    def add_permit(self, value): self.permit.append(value)
    def insert_permit(self, index, value): self.permit[index] = value
    def hasContent_(self):
        if (
            self.permit or
            super(Permits, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Permits', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Permits')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Permits'):
        super(Permits, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Permits')
    def exportChildren(self, outfile, level, namespace_='', name_='Permits', fromsubclass_=False, pretty_print=True):
        super(Permits, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for permit_ in self.permit:
            permit_.export(outfile, level, namespace_, name_='permit', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Permits'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Permits, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Permits, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('permit=[\n')
        level += 1
        for permit_ in self.permit:
            showIndent(outfile, level)
            outfile.write('model_.Permit(\n')
            permit_.exportLiteral(outfile, level, name_='Permit')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Permits, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'permit':
            obj_ = Permit.factory()
            obj_.build(child_)
            self.permit.append(obj_)
        super(Permits, self).buildChildren(child_, node, nodeName_, True)
# end class Permits


class Role(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, mutable=None, administrative=None, user=None, permits=None):
        super(Role, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.mutable = mutable
        self.administrative = administrative
        self.user = user
        self.permits = permits
    def factory(*args_, **kwargs_):
        if Role.subclass:
            return Role.subclass(*args_, **kwargs_)
        else:
            return Role(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_mutable(self): return self.mutable
    def set_mutable(self, mutable): self.mutable = mutable
    def get_administrative(self): return self.administrative
    def set_administrative(self, administrative): self.administrative = administrative
    def get_user(self): return self.user
    def set_user(self, user): self.user = user
    def get_permits(self): return self.permits
    def set_permits(self, permits): self.permits = permits
    def hasContent_(self):
        if (
            self.mutable is not None or
            self.administrative is not None or
            self.user is not None or
            self.permits is not None or
            super(Role, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Role', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Role')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Role'):
        super(Role, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Role')
    def exportChildren(self, outfile, level, namespace_='', name_='Role', fromsubclass_=False, pretty_print=True):
        super(Role, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.mutable is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smutable>%s</%smutable>%s' % (namespace_, self.gds_format_boolean(self.mutable, input_name='mutable'), namespace_, eol_))
        if self.administrative is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sadministrative>%s</%sadministrative>%s' % (namespace_, self.gds_format_boolean(self.administrative, input_name='administrative'), namespace_, eol_))
        if self.user is not None:
            self.user.export(outfile, level, namespace_, name_='user', pretty_print=pretty_print)
        if self.permits is not None:
            self.permits.export(outfile, level, namespace_, name_='permits', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Role'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Role, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Role, self).exportLiteralChildren(outfile, level, name_)
        if self.mutable is not None:
            showIndent(outfile, level)
            outfile.write('mutable=%s,\n' % self.mutable)
        if self.administrative is not None:
            showIndent(outfile, level)
            outfile.write('administrative=%s,\n' % self.administrative)
        if self.user is not None:
            showIndent(outfile, level)
            outfile.write('user=model_.User(\n')
            self.user.exportLiteral(outfile, level, name_='user')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.permits is not None:
            showIndent(outfile, level)
            outfile.write('permits=model_.Permits(\n')
            self.permits.exportLiteral(outfile, level, name_='permits')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Role, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'mutable':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'mutable')
            self.mutable = ival_
        elif nodeName_ == 'administrative':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'administrative')
            self.administrative = ival_
        elif nodeName_ == 'user':
            obj_ = User.factory()
            obj_.build(child_)
            self.set_user(obj_)
        elif nodeName_ == 'permits':
            obj_ = Permits.factory()
            obj_.build(child_)
            self.set_permits(obj_)
        super(Role, self).buildChildren(child_, node, nodeName_, True)
# end class Role


class Roles(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, role=None):
        super(Roles, self).__init__(actions, total, active, )
        if role is None:
            self.role = []
        else:
            self.role = role
    def factory(*args_, **kwargs_):
        if Roles.subclass:
            return Roles.subclass(*args_, **kwargs_)
        else:
            return Roles(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_role(self): return self.role
    def set_role(self, role): self.role = role
    def add_role(self, value): self.role.append(value)
    def insert_role(self, index, value): self.role[index] = value
    def hasContent_(self):
        if (
            self.role or
            super(Roles, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Roles', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Roles')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Roles'):
        super(Roles, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Roles')
    def exportChildren(self, outfile, level, namespace_='', name_='Roles', fromsubclass_=False, pretty_print=True):
        super(Roles, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for role_ in self.role:
            role_.export(outfile, level, namespace_, name_='role', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Roles'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Roles, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Roles, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('role=[\n')
        level += 1
        for role_ in self.role:
            showIndent(outfile, level)
            outfile.write('model_.role(\n')
            role_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Roles, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'role':
            obj_ = Role.factory()
            obj_.build(child_)
            self.role.append(obj_)
        super(Roles, self).buildChildren(child_, node, nodeName_, True)
# end class Roles


class User(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, domain=None, department=None, logged_in=None, last_name=None, user_name=None, password=None, email=None, roles=None, groups=None):
        super(User, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.domain = domain
        self.department = department
        self.logged_in = logged_in
        self.last_name = last_name
        self.user_name = user_name
        self.password = password
        self.email = email
        self.roles = roles
        self.groups = groups
    def factory(*args_, **kwargs_):
        if User.subclass:
            return User.subclass(*args_, **kwargs_)
        else:
            return User(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_domain(self): return self.domain
    def set_domain(self, domain): self.domain = domain
    def get_department(self): return self.department
    def set_department(self, department): self.department = department
    def get_logged_in(self): return self.logged_in
    def set_logged_in(self, logged_in): self.logged_in = logged_in
    def get_last_name(self): return self.last_name
    def set_last_name(self, last_name): self.last_name = last_name
    def get_user_name(self): return self.user_name
    def set_user_name(self, user_name): self.user_name = user_name
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_email(self): return self.email
    def set_email(self, email): self.email = email
    def get_roles(self): return self.roles
    def set_roles(self, roles): self.roles = roles
    def get_groups(self): return self.groups
    def set_groups(self, groups): self.groups = groups
    def hasContent_(self):
        if (
            self.domain is not None or
            self.department is not None or
            self.logged_in is not None or
            self.last_name is not None or
            self.user_name is not None or
            self.password is not None or
            self.email is not None or
            self.roles is not None or
            self.groups is not None or
            super(User, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='User', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='User')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='User'):
        super(User, self).exportAttributes(outfile, level, already_processed, namespace_, name_='User')
    def exportChildren(self, outfile, level, namespace_='', name_='User', fromsubclass_=False, pretty_print=True):
        super(User, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.domain is not None:
            self.domain.export(outfile, level, namespace_, name_='domain', pretty_print=pretty_print)
        if self.department is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdepartment>%s</%sdepartment>%s' % (namespace_, self.gds_format_string(quote_xml(self.department).encode(ExternalEncoding), input_name='department'), namespace_, eol_))
        if self.logged_in is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slogged_in>%s</%slogged_in>%s' % (namespace_, self.gds_format_boolean(self.logged_in, input_name='logged_in'), namespace_, eol_))
        if self.last_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slast_name>%s</%slast_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.last_name).encode(ExternalEncoding), input_name='last_name'), namespace_, eol_))
        if self.user_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_name>%s</%suser_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.user_name).encode(ExternalEncoding), input_name='user_name'), namespace_, eol_))
        if self.password is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespace_, self.gds_format_string(quote_xml(self.password).encode(ExternalEncoding), input_name='password'), namespace_, eol_))
        if self.email is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%semail>%s</%semail>%s' % (namespace_, self.gds_format_string(quote_xml(self.email).encode(ExternalEncoding), input_name='email'), namespace_, eol_))
        if self.roles is not None:
            self.roles.export(outfile, level, namespace_, name_='roles', pretty_print=pretty_print)
        if self.groups is not None:
            self.groups.export(outfile, level, namespace_, name_='groups', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='User'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(User, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(User, self).exportLiteralChildren(outfile, level, name_)
        if self.domain is not None:
            showIndent(outfile, level)
            outfile.write('domain=model_.domain(\n')
            self.domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.department is not None:
            showIndent(outfile, level)
            outfile.write('department=%s,\n' % quote_python(self.department).encode(ExternalEncoding))
        if self.logged_in is not None:
            showIndent(outfile, level)
            outfile.write('logged_in=%s,\n' % self.logged_in)
        if self.last_name is not None:
            showIndent(outfile, level)
            outfile.write('last_name=%s,\n' % quote_python(self.last_name).encode(ExternalEncoding))
        if self.user_name is not None:
            showIndent(outfile, level)
            outfile.write('user_name=%s,\n' % quote_python(self.user_name).encode(ExternalEncoding))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % quote_python(self.password).encode(ExternalEncoding))
        if self.email is not None:
            showIndent(outfile, level)
            outfile.write('email=%s,\n' % quote_python(self.email).encode(ExternalEncoding))
        if self.roles is not None:
            showIndent(outfile, level)
            outfile.write('roles=model_.Roles(\n')
            self.roles.exportLiteral(outfile, level, name_='roles')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.groups is not None:
            showIndent(outfile, level)
            outfile.write('groups=model_.groups(\n')
            self.groups.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(User, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'domain':
            obj_ = Domain.factory()
            obj_.build(child_)
            self.set_domain(obj_)
        elif nodeName_ == 'department':
            department_ = child_.text
            department_ = self.gds_validate_string(department_, node, 'department')
            self.department = department_
        elif nodeName_ == 'logged_in':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'logged_in')
            self.logged_in = ival_
        elif nodeName_ == 'last_name':
            last_name_ = child_.text
            last_name_ = self.gds_validate_string(last_name_, node, 'last_name')
            self.last_name = last_name_
        elif nodeName_ == 'user_name':
            user_name_ = child_.text
            user_name_ = self.gds_validate_string(user_name_, node, 'user_name')
            self.user_name = user_name_
        elif nodeName_ == 'password':
            password_ = child_.text
            password_ = self.gds_validate_string(password_, node, 'password')
            self.password = password_
        elif nodeName_ == 'email':
            email_ = child_.text
            email_ = self.gds_validate_string(email_, node, 'email')
            self.email = email_
        elif nodeName_ == 'roles':
            obj_ = Roles.factory()
            obj_.build(child_)
            self.set_roles(obj_)
        elif nodeName_ == 'groups':
            obj_ = Groups.factory()
            obj_.build(child_)
            self.set_groups(obj_)
        super(User, self).buildChildren(child_, node, nodeName_, True)
# end class User


class Users(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, user=None):
        super(Users, self).__init__(actions, total, active, )
        if user is None:
            self.user = []
        else:
            self.user = user
    def factory(*args_, **kwargs_):
        if Users.subclass:
            return Users.subclass(*args_, **kwargs_)
        else:
            return Users(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_user(self): return self.user
    def set_user(self, user): self.user = user
    def add_user(self, value): self.user.append(value)
    def insert_user(self, index, value): self.user[index] = value
    def hasContent_(self):
        if (
            self.user or
            super(Users, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Users', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Users')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Users'):
        super(Users, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Users')
    def exportChildren(self, outfile, level, namespace_='', name_='Users', fromsubclass_=False, pretty_print=True):
        super(Users, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for user_ in self.user:
            user_.export(outfile, level, namespace_, name_='user', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Users'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Users, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Users, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('user=[\n')
        level += 1
        for user_ in self.user:
            showIndent(outfile, level)
            outfile.write('model_.user(\n')
            user_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Users, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'user':
            obj_ = User.factory()
            obj_.build(child_)
            self.user.append(obj_)
        super(Users, self).buildChildren(child_, node, nodeName_, True)
# end class Users


class AuthenticationMethod(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, authentication_method=None):
        if authentication_method is None:
            self.authentication_method = []
        else:
            self.authentication_method = authentication_method
    def factory(*args_, **kwargs_):
        if AuthenticationMethod.subclass:
            return AuthenticationMethod.subclass(*args_, **kwargs_)
        else:
            return AuthenticationMethod(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_authentication_method(self): return self.authentication_method
    def set_authentication_method(self, authentication_method): self.authentication_method = authentication_method
    def add_authentication_method(self, value): self.authentication_method.append(value)
    def insert_authentication_method(self, index, value): self.authentication_method[index] = value
    def hasContent_(self):
        if (
            self.authentication_method
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AuthenticationMethod', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AuthenticationMethod')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AuthenticationMethod'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='AuthenticationMethod', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for authentication_method_ in self.authentication_method:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sauthentication_method>%s</%sauthentication_method>%s' % (namespace_, self.gds_format_string(quote_xml(authentication_method_).encode(ExternalEncoding), input_name='authentication_method'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='AuthenticationMethod'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('authentication_method=[\n')
        level += 1
        for authentication_method_ in self.authentication_method:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(authentication_method_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'authentication_method':
            authentication_method_ = child_.text
            authentication_method_ = self.gds_validate_string(authentication_method_, node, 'authentication_method')
            self.authentication_method.append(authentication_method_)
# end class AuthenticationMethod


class SSH(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, port=None, fingerprint=None, authentication_method=None, user=None):
        super(SSH, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.port = port
        self.fingerprint = fingerprint
        self.authentication_method = authentication_method
        self.user = user
    def factory(*args_, **kwargs_):
        if SSH.subclass:
            return SSH.subclass(*args_, **kwargs_)
        else:
            return SSH(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_port(self): return self.port
    def set_port(self, port): self.port = port
    def get_fingerprint(self): return self.fingerprint
    def set_fingerprint(self, fingerprint): self.fingerprint = fingerprint
    def get_authentication_method(self): return self.authentication_method
    def set_authentication_method(self, authentication_method): self.authentication_method = authentication_method
    def get_user(self): return self.user
    def set_user(self, user): self.user = user
    def hasContent_(self):
        if (
            self.port is not None or
            self.fingerprint is not None or
            self.authentication_method is not None or
            self.user is not None or
            super(SSH, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SSH', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SSH')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SSH'):
        super(SSH, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SSH')
    def exportChildren(self, outfile, level, namespace_='', name_='SSH', fromsubclass_=False, pretty_print=True):
        super(SSH, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.port is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sport>%s</%sport>%s' % (namespace_, self.gds_format_integer(self.port, input_name='port'), namespace_, eol_))
        if self.fingerprint is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfingerprint>%s</%sfingerprint>%s' % (namespace_, self.gds_format_string(quote_xml(self.fingerprint).encode(ExternalEncoding), input_name='fingerprint'), namespace_, eol_))
        if self.authentication_method is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sauthentication_method>%s</%sauthentication_method>%s' % (namespace_, self.gds_format_string(quote_xml(self.authentication_method).encode(ExternalEncoding), input_name='authentication_method'), namespace_, eol_))
        if self.user is not None:
            self.user.export(outfile, level, namespace_, name_='user', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SSH'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(SSH, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(SSH, self).exportLiteralChildren(outfile, level, name_)
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('port=%d,\n' % self.port)
        if self.fingerprint is not None:
            showIndent(outfile, level)
            outfile.write('fingerprint=%s,\n' % quote_python(self.fingerprint).encode(ExternalEncoding))
        if self.authentication_method is not None:
            showIndent(outfile, level)
            outfile.write('authentication_method=%s,\n' % quote_python(self.authentication_method).encode(ExternalEncoding))
        if self.user is not None:
            showIndent(outfile, level)
            outfile.write('user=model_.user(\n')
            self.user.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(SSH, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'port')
            self.port = ival_
        elif nodeName_ == 'fingerprint':
            fingerprint_ = child_.text
            fingerprint_ = self.gds_validate_string(fingerprint_, node, 'fingerprint')
            self.fingerprint = fingerprint_
        elif nodeName_ == 'authentication_method':
            authentication_method_ = child_.text
            authentication_method_ = self.gds_validate_string(authentication_method_, node, 'authentication_method')
            self.authentication_method = authentication_method_
        elif nodeName_ == 'user':
            obj_ = User.factory()
            obj_.build(child_)
            self.set_user(obj_)
        super(SSH, self).buildChildren(child_, node, nodeName_, True)
# end class SSH


class Group(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, domain=None, roles=None):
        super(Group, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.domain = domain
        self.roles = roles
    def factory(*args_, **kwargs_):
        if Group.subclass:
            return Group.subclass(*args_, **kwargs_)
        else:
            return Group(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_domain(self): return self.domain
    def set_domain(self, domain): self.domain = domain
    def get_roles(self): return self.roles
    def set_roles(self, roles): self.roles = roles
    def hasContent_(self):
        if (
            self.domain is not None or
            self.roles is not None or
            super(Group, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Group', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Group')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Group'):
        super(Group, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Group')
    def exportChildren(self, outfile, level, namespace_='', name_='Group', fromsubclass_=False, pretty_print=True):
        super(Group, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.domain is not None:
            self.domain.export(outfile, level, namespace_, name_='domain', pretty_print=pretty_print)
        if self.roles is not None:
            self.roles.export(outfile, level, namespace_, name_='roles', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Group'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Group, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Group, self).exportLiteralChildren(outfile, level, name_)
        if self.domain is not None:
            showIndent(outfile, level)
            outfile.write('domain=model_.domain(\n')
            self.domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.roles is not None:
            showIndent(outfile, level)
            outfile.write('roles=model_.Roles(\n')
            self.roles.exportLiteral(outfile, level, name_='roles')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Group, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'domain':
            obj_ = Domain.factory()
            obj_.build(child_)
            self.set_domain(obj_)
        elif nodeName_ == 'roles':
            obj_ = Roles.factory()
            obj_.build(child_)
            self.set_roles(obj_)
        super(Group, self).buildChildren(child_, node, nodeName_, True)
# end class Group


class Groups(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, group=None):
        super(Groups, self).__init__(actions, total, active, )
        if group is None:
            self.group = []
        else:
            self.group = group
    def factory(*args_, **kwargs_):
        if Groups.subclass:
            return Groups.subclass(*args_, **kwargs_)
        else:
            return Groups(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_group(self): return self.group
    def set_group(self, group): self.group = group
    def add_group(self, value): self.group.append(value)
    def insert_group(self, index, value): self.group[index] = value
    def hasContent_(self):
        if (
            self.group or
            super(Groups, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Groups', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Groups')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Groups'):
        super(Groups, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Groups')
    def exportChildren(self, outfile, level, namespace_='', name_='Groups', fromsubclass_=False, pretty_print=True):
        super(Groups, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for group_ in self.group:
            group_.export(outfile, level, namespace_, name_='group', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Groups'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Groups, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Groups, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('group=[\n')
        level += 1
        for group_ in self.group:
            showIndent(outfile, level)
            outfile.write('model_.group(\n')
            group_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Groups, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'group':
            obj_ = Group.factory()
            obj_.build(child_)
            self.group.append(obj_)
        super(Groups, self).buildChildren(child_, node, nodeName_, True)
# end class Groups


class Permission(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, role=None, user=None, group=None, data_center=None, cluster=None, host=None, storage_domain=None, vm=None, vmpool=None, template=None, disk=None):
        super(Permission, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.role = role
        self.user = user
        self.group = group
        self.data_center = data_center
        self.cluster = cluster
        self.host = host
        self.storage_domain = storage_domain
        self.vm = vm
        self.vmpool = vmpool
        self.template = template
        self.disk = disk
    def factory(*args_, **kwargs_):
        if Permission.subclass:
            return Permission.subclass(*args_, **kwargs_)
        else:
            return Permission(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_role(self): return self.role
    def set_role(self, role): self.role = role
    def get_user(self): return self.user
    def set_user(self, user): self.user = user
    def get_group(self): return self.group
    def set_group(self, group): self.group = group
    def get_data_center(self): return self.data_center
    def set_data_center(self, data_center): self.data_center = data_center
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def get_storage_domain(self): return self.storage_domain
    def set_storage_domain(self, storage_domain): self.storage_domain = storage_domain
    def get_vm(self): return self.vm
    def set_vm(self, vm): self.vm = vm
    def get_vmpool(self): return self.vmpool
    def set_vmpool(self, vmpool): self.vmpool = vmpool
    def get_template(self): return self.template
    def set_template(self, template): self.template = template
    def get_disk(self): return self.disk
    def set_disk(self, disk): self.disk = disk
    def hasContent_(self):
        if (
            self.role is not None or
            self.user is not None or
            self.group is not None or
            self.data_center is not None or
            self.cluster is not None or
            self.host is not None or
            self.storage_domain is not None or
            self.vm is not None or
            self.vmpool is not None or
            self.template is not None or
            self.disk is not None or
            super(Permission, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Permission', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Permission')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Permission'):
        super(Permission, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Permission')
    def exportChildren(self, outfile, level, namespace_='', name_='Permission', fromsubclass_=False, pretty_print=True):
        super(Permission, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.role is not None:
            self.role.export(outfile, level, namespace_, name_='role', pretty_print=pretty_print)
        if self.user is not None:
            self.user.export(outfile, level, namespace_, name_='user', pretty_print=pretty_print)
        if self.group is not None:
            self.group.export(outfile, level, namespace_, name_='group', pretty_print=pretty_print)
        if self.data_center is not None:
            self.data_center.export(outfile, level, namespace_, name_='data_center', pretty_print=pretty_print)
        if self.cluster is not None:
            self.cluster.export(outfile, level, namespace_, name_='cluster', pretty_print=pretty_print)
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host', pretty_print=pretty_print)
        if self.storage_domain is not None:
            self.storage_domain.export(outfile, level, namespace_, name_='storage_domain', pretty_print=pretty_print)
        if self.vm is not None:
            self.vm.export(outfile, level, namespace_, name_='vm', pretty_print=pretty_print)
        if self.vmpool is not None:
            self.vmpool.export(outfile, level, namespace_, name_='vmpool', pretty_print=pretty_print)
        if self.template is not None:
            self.template.export(outfile, level, namespace_, name_='template', pretty_print=pretty_print)
        if self.disk is not None:
            self.disk.export(outfile, level, namespace_, name_='disk', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Permission'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Permission, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Permission, self).exportLiteralChildren(outfile, level, name_)
        if self.role is not None:
            showIndent(outfile, level)
            outfile.write('role=model_.Role(\n')
            self.role.exportLiteral(outfile, level, name_='role')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.user is not None:
            showIndent(outfile, level)
            outfile.write('user=model_.User(\n')
            self.user.exportLiteral(outfile, level, name_='user')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.group is not None:
            showIndent(outfile, level)
            outfile.write('group=model_.Group(\n')
            self.group.exportLiteral(outfile, level, name_='group')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.data_center is not None:
            showIndent(outfile, level)
            outfile.write('data_center=model_.data_center(\n')
            self.data_center.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cluster is not None:
            showIndent(outfile, level)
            outfile.write('cluster=model_.cluster(\n')
            self.cluster.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.storage_domain is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain=model_.storage_domain(\n')
            self.storage_domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vm is not None:
            showIndent(outfile, level)
            outfile.write('vm=model_.vm(\n')
            self.vm.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vmpool is not None:
            showIndent(outfile, level)
            outfile.write('vmpool=model_.vmpool(\n')
            self.vmpool.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.template is not None:
            showIndent(outfile, level)
            outfile.write('template=model_.template(\n')
            self.template.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.disk is not None:
            showIndent(outfile, level)
            outfile.write('disk=model_.disk(\n')
            self.disk.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Permission, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'role':
            obj_ = Role.factory()
            obj_.build(child_)
            self.set_role(obj_)
        elif nodeName_ == 'user':
            obj_ = User.factory()
            obj_.build(child_)
            self.set_user(obj_)
        elif nodeName_ == 'group':
            obj_ = Group.factory()
            obj_.build(child_)
            self.set_group(obj_)
        elif nodeName_ == 'data_center':
            obj_ = DataCenter.factory()
            obj_.build(child_)
            self.set_data_center(obj_)
        elif nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.set_cluster(obj_)
        elif nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.set_host(obj_)
        elif nodeName_ == 'storage_domain':
            obj_ = StorageDomain.factory()
            obj_.build(child_)
            self.set_storage_domain(obj_)
        elif nodeName_ == 'vm':
            class_obj_ = self.get_class_obj_(child_, VM)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_vm(obj_)
        elif nodeName_ == 'vmpool':
            obj_ = VmPool.factory()
            obj_.build(child_)
            self.set_vmpool(obj_)
        elif nodeName_ == 'template':
            obj_ = Template.factory()
            obj_.build(child_)
            self.set_template(obj_)
        elif nodeName_ == 'disk':
            obj_ = Disk.factory()
            obj_.build(child_)
            self.set_disk(obj_)
        super(Permission, self).buildChildren(child_, node, nodeName_, True)
# end class Permission


class Permissions(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, permission=None, clone=None):
        super(Permissions, self).__init__(actions, total, active, )
        if permission is None:
            self.permission = []
        else:
            self.permission = permission
        self.clone = clone
    def factory(*args_, **kwargs_):
        if Permissions.subclass:
            return Permissions.subclass(*args_, **kwargs_)
        else:
            return Permissions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_permission(self): return self.permission
    def set_permission(self, permission): self.permission = permission
    def add_permission(self, value): self.permission.append(value)
    def insert_permission(self, index, value): self.permission[index] = value
    def get_clone(self): return self.clone
    def set_clone(self, clone): self.clone = clone
    def hasContent_(self):
        if (
            self.permission or
            self.clone is not None or
            super(Permissions, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Permissions', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Permissions')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Permissions'):
        super(Permissions, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Permissions')
    def exportChildren(self, outfile, level, namespace_='', name_='Permissions', fromsubclass_=False, pretty_print=True):
        super(Permissions, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for permission_ in self.permission:
            permission_.export(outfile, level, namespace_, name_='permission', pretty_print=pretty_print)
        if self.clone is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sclone>%s</%sclone>%s' % (namespace_, self.gds_format_boolean(self.clone, input_name='clone'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Permissions'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Permissions, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Permissions, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('permission=[\n')
        level += 1
        for permission_ in self.permission:
            showIndent(outfile, level)
            outfile.write('model_.permission(\n')
            permission_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.clone is not None:
            showIndent(outfile, level)
            outfile.write('clone=%s,\n' % self.clone)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Permissions, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'permission':
            obj_ = Permission.factory()
            obj_.build(child_)
            self.permission.append(obj_)
        elif nodeName_ == 'clone':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'clone')
            self.clone = ival_
        super(Permissions, self).buildChildren(child_, node, nodeName_, True)
# end class Permissions


class Domain(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, user=None):
        super(Domain, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.user = user
    def factory(*args_, **kwargs_):
        if Domain.subclass:
            return Domain.subclass(*args_, **kwargs_)
        else:
            return Domain(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_user(self): return self.user
    def set_user(self, user): self.user = user
    def hasContent_(self):
        if (
            self.user is not None or
            super(Domain, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Domain', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Domain')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Domain'):
        super(Domain, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Domain')
    def exportChildren(self, outfile, level, namespace_='', name_='Domain', fromsubclass_=False, pretty_print=True):
        super(Domain, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.user is not None:
            self.user.export(outfile, level, namespace_, name_='user', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Domain'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Domain, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Domain, self).exportLiteralChildren(outfile, level, name_)
        if self.user is not None:
            showIndent(outfile, level)
            outfile.write('user=model_.User(\n')
            self.user.exportLiteral(outfile, level, name_='user')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Domain, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'user':
            obj_ = User.factory()
            obj_.build(child_)
            self.set_user(obj_)
        super(Domain, self).buildChildren(child_, node, nodeName_, True)
# end class Domain


class Domains(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, domain=None):
        super(Domains, self).__init__(actions, total, active, )
        if domain is None:
            self.domain = []
        else:
            self.domain = domain
    def factory(*args_, **kwargs_):
        if Domains.subclass:
            return Domains.subclass(*args_, **kwargs_)
        else:
            return Domains(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_domain(self): return self.domain
    def set_domain(self, domain): self.domain = domain
    def add_domain(self, value): self.domain.append(value)
    def insert_domain(self, index, value): self.domain[index] = value
    def hasContent_(self):
        if (
            self.domain or
            super(Domains, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Domains', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Domains')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Domains'):
        super(Domains, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Domains')
    def exportChildren(self, outfile, level, namespace_='', name_='Domains', fromsubclass_=False, pretty_print=True):
        super(Domains, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for domain_ in self.domain:
            domain_.export(outfile, level, namespace_, name_='domain', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Domains'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Domains, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Domains, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('domain=[\n')
        level += 1
        for domain_ in self.domain:
            showIndent(outfile, level)
            outfile.write('model_.domain(\n')
            domain_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Domains, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'domain':
            obj_ = Domain.factory()
            obj_.build(child_)
            self.domain.append(obj_)
        super(Domains, self).buildChildren(child_, node, nodeName_, True)
# end class Domains


class Event(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, code=None, severity=None, time=None, correlation_id=None, user=None, vm=None, storage_domain=None, host=None, template=None, cluster=None, data_center=None, origin=None, custom_id=None, flood_rate=None, custom_data=None):
        super(Event, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.code = code
        self.severity = severity
        self.time = time
        self.correlation_id = correlation_id
        self.user = user
        self.vm = vm
        self.storage_domain = storage_domain
        self.host = host
        self.template = template
        self.cluster = cluster
        self.data_center = data_center
        self.origin = origin
        self.custom_id = custom_id
        self.flood_rate = flood_rate
        self.custom_data = custom_data
    def factory(*args_, **kwargs_):
        if Event.subclass:
            return Event.subclass(*args_, **kwargs_)
        else:
            return Event(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_severity(self): return self.severity
    def set_severity(self, severity): self.severity = severity
    def get_time(self): return self.time
    def set_time(self, time): self.time = time
    def get_correlation_id(self): return self.correlation_id
    def set_correlation_id(self, correlation_id): self.correlation_id = correlation_id
    def get_user(self): return self.user
    def set_user(self, user): self.user = user
    def get_vm(self): return self.vm
    def set_vm(self, vm): self.vm = vm
    def get_storage_domain(self): return self.storage_domain
    def set_storage_domain(self, storage_domain): self.storage_domain = storage_domain
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def get_template(self): return self.template
    def set_template(self, template): self.template = template
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def get_data_center(self): return self.data_center
    def set_data_center(self, data_center): self.data_center = data_center
    def get_origin(self): return self.origin
    def set_origin(self, origin): self.origin = origin
    def get_custom_id(self): return self.custom_id
    def set_custom_id(self, custom_id): self.custom_id = custom_id
    def get_flood_rate(self): return self.flood_rate
    def set_flood_rate(self, flood_rate): self.flood_rate = flood_rate
    def get_custom_data(self): return self.custom_data
    def set_custom_data(self, custom_data): self.custom_data = custom_data
    def hasContent_(self):
        if (
            self.code is not None or
            self.severity is not None or
            self.time is not None or
            self.correlation_id is not None or
            self.user is not None or
            self.vm is not None or
            self.storage_domain is not None or
            self.host is not None or
            self.template is not None or
            self.cluster is not None or
            self.data_center is not None or
            self.origin is not None or
            self.custom_id is not None or
            self.flood_rate is not None or
            self.custom_data is not None or
            super(Event, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Event', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Event')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Event'):
        super(Event, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Event')
    def exportChildren(self, outfile, level, namespace_='', name_='Event', fromsubclass_=False, pretty_print=True):
        super(Event, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.code is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scode>%s</%scode>%s' % (namespace_, self.gds_format_integer(self.code, input_name='code'), namespace_, eol_))
        if self.severity is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sseverity>%s</%sseverity>%s' % (namespace_, self.gds_format_string(quote_xml(self.severity).encode(ExternalEncoding), input_name='severity'), namespace_, eol_))
        if self.time is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stime>%s</%stime>%s' % (namespace_, self.gds_format_datetime(self.time, input_name='time'), namespace_, eol_))
        if self.correlation_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scorrelation_id>%s</%scorrelation_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.correlation_id).encode(ExternalEncoding), input_name='correlation_id'), namespace_, eol_))
        if self.user is not None:
            self.user.export(outfile, level, namespace_, name_='user', pretty_print=pretty_print)
        if self.vm is not None:
            self.vm.export(outfile, level, namespace_, name_='vm', pretty_print=pretty_print)
        if self.storage_domain is not None:
            self.storage_domain.export(outfile, level, namespace_, name_='storage_domain', pretty_print=pretty_print)
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host', pretty_print=pretty_print)
        if self.template is not None:
            self.template.export(outfile, level, namespace_, name_='template', pretty_print=pretty_print)
        if self.cluster is not None:
            self.cluster.export(outfile, level, namespace_, name_='cluster', pretty_print=pretty_print)
        if self.data_center is not None:
            self.data_center.export(outfile, level, namespace_, name_='data_center', pretty_print=pretty_print)
        if self.origin is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorigin>%s</%sorigin>%s' % (namespace_, self.gds_format_string(quote_xml(self.origin).encode(ExternalEncoding), input_name='origin'), namespace_, eol_))
        if self.custom_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scustom_id>%s</%scustom_id>%s' % (namespace_, self.gds_format_integer(self.custom_id, input_name='custom_id'), namespace_, eol_))
        if self.flood_rate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sflood_rate>%s</%sflood_rate>%s' % (namespace_, self.gds_format_integer(self.flood_rate, input_name='flood_rate'), namespace_, eol_))
        if self.custom_data is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scustom_data>%s</%scustom_data>%s' % (namespace_, self.gds_format_string(quote_xml(self.custom_data).encode(ExternalEncoding), input_name='custom_data'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Event'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Event, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Event, self).exportLiteralChildren(outfile, level, name_)
        if self.code is not None:
            showIndent(outfile, level)
            outfile.write('code=%d,\n' % self.code)
        if self.severity is not None:
            showIndent(outfile, level)
            outfile.write('severity=%s,\n' % quote_python(self.severity).encode(ExternalEncoding))
        if self.time is not None:
            showIndent(outfile, level)
            outfile.write('time=datetime_.strptime("%s", "%%Y-%%m-%%dT%%H:%%M:%%S"),\n' % self.gds_format_datetime(self.time, input_name='time'))
        if self.correlation_id is not None:
            showIndent(outfile, level)
            outfile.write('correlation_id=%s,\n' % quote_python(self.correlation_id).encode(ExternalEncoding))
        if self.user is not None:
            showIndent(outfile, level)
            outfile.write('user=model_.user(\n')
            self.user.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vm is not None:
            showIndent(outfile, level)
            outfile.write('vm=model_.vm(\n')
            self.vm.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.storage_domain is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain=model_.storage_domain(\n')
            self.storage_domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.template is not None:
            showIndent(outfile, level)
            outfile.write('template=model_.template(\n')
            self.template.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cluster is not None:
            showIndent(outfile, level)
            outfile.write('cluster=model_.cluster(\n')
            self.cluster.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.data_center is not None:
            showIndent(outfile, level)
            outfile.write('data_center=model_.data_center(\n')
            self.data_center.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.origin is not None:
            showIndent(outfile, level)
            outfile.write('origin=%s,\n' % quote_python(self.origin).encode(ExternalEncoding))
        if self.custom_id is not None:
            showIndent(outfile, level)
            outfile.write('custom_id=%d,\n' % self.custom_id)
        if self.flood_rate is not None:
            showIndent(outfile, level)
            outfile.write('flood_rate=%d,\n' % self.flood_rate)
        if self.custom_data is not None:
            showIndent(outfile, level)
            outfile.write('custom_data=%s,\n' % quote_python(self.custom_data).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Event, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'code':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'code')
            self.code = ival_
        elif nodeName_ == 'severity':
            severity_ = child_.text
            severity_ = self.gds_validate_string(severity_, node, 'severity')
            self.severity = severity_
        elif nodeName_ == 'time':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_, node, 'time')
            self.time = dval_
        elif nodeName_ == 'correlation_id':
            correlation_id_ = child_.text
            correlation_id_ = self.gds_validate_string(correlation_id_, node, 'correlation_id')
            self.correlation_id = correlation_id_
        elif nodeName_ == 'user':
            obj_ = User.factory()
            obj_.build(child_)
            self.set_user(obj_)
        elif nodeName_ == 'vm':
            class_obj_ = self.get_class_obj_(child_, VM)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_vm(obj_)
        elif nodeName_ == 'storage_domain':
            obj_ = StorageDomain.factory()
            obj_.build(child_)
            self.set_storage_domain(obj_)
        elif nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.set_host(obj_)
        elif nodeName_ == 'template':
            obj_ = Template.factory()
            obj_.build(child_)
            self.set_template(obj_)
        elif nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.set_cluster(obj_)
        elif nodeName_ == 'data_center':
            obj_ = DataCenter.factory()
            obj_.build(child_)
            self.set_data_center(obj_)
        elif nodeName_ == 'origin':
            origin_ = child_.text
            origin_ = self.gds_validate_string(origin_, node, 'origin')
            self.origin = origin_
        elif nodeName_ == 'custom_id':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'custom_id')
            self.custom_id = ival_
        elif nodeName_ == 'flood_rate':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'flood_rate')
            self.flood_rate = ival_
        elif nodeName_ == 'custom_data':
            custom_data_ = child_.text
            custom_data_ = self.gds_validate_string(custom_data_, node, 'custom_data')
            self.custom_data = custom_data_
        super(Event, self).buildChildren(child_, node, nodeName_, True)
# end class Event


class Events(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, event=None):
        super(Events, self).__init__(actions, total, active, )
        if event is None:
            self.event = []
        else:
            self.event = event
    def factory(*args_, **kwargs_):
        if Events.subclass:
            return Events.subclass(*args_, **kwargs_)
        else:
            return Events(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_event(self): return self.event
    def set_event(self, event): self.event = event
    def add_event(self, value): self.event.append(value)
    def insert_event(self, index, value): self.event[index] = value
    def hasContent_(self):
        if (
            self.event or
            super(Events, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Events', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Events')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Events'):
        super(Events, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Events')
    def exportChildren(self, outfile, level, namespace_='', name_='Events', fromsubclass_=False, pretty_print=True):
        super(Events, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for event_ in self.event:
            event_.export(outfile, level, namespace_, name_='event', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Events'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Events, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Events, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('event=[\n')
        level += 1
        for event_ in self.event:
            showIndent(outfile, level)
            outfile.write('model_.event(\n')
            event_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Events, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'event':
            obj_ = Event.factory()
            obj_.build(child_)
            self.event.append(obj_)
        super(Events, self).buildChildren(child_, node, nodeName_, True)
# end class Events


class File(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, content=None, type_=None, storage_domain=None):
        super(File, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.content = content
        self.type_ = type_
        self.storage_domain = storage_domain
    def factory(*args_, **kwargs_):
        if File.subclass:
            return File.subclass(*args_, **kwargs_)
        else:
            return File(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_content(self): return self.content
    def set_content(self, content): self.content = content
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_storage_domain(self): return self.storage_domain
    def set_storage_domain(self, storage_domain): self.storage_domain = storage_domain
    def hasContent_(self):
        if (
            self.content is not None or
            self.type_ is not None or
            self.storage_domain is not None or
            super(File, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='File', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='File')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='File'):
        super(File, self).exportAttributes(outfile, level, already_processed, namespace_, name_='File')
    def exportChildren(self, outfile, level, namespace_='', name_='File', fromsubclass_=False, pretty_print=True):
        super(File, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.content is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scontent>%s</%scontent>%s' % (namespace_, self.gds_format_string(quote_xml(self.content).encode(ExternalEncoding), input_name='content'), namespace_, eol_))
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.storage_domain is not None:
            self.storage_domain.export(outfile, level, namespace_, name_='storage_domain', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='File'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(File, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(File, self).exportLiteralChildren(outfile, level, name_)
        if self.content is not None:
            showIndent(outfile, level)
            outfile.write('content=%s,\n' % quote_python(self.content).encode(ExternalEncoding))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.storage_domain is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain=model_.storage_domain(\n')
            self.storage_domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(File, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'content':
            content_ = child_.text
            content_ = self.gds_validate_string(content_, node, 'content')
            self.content = content_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'storage_domain':
            obj_ = StorageDomain.factory()
            obj_.build(child_)
            self.set_storage_domain(obj_)
        super(File, self).buildChildren(child_, node, nodeName_, True)
# end class File


class Files(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, file=None):
        super(Files, self).__init__(actions, total, active, )
        if file is None:
            self.file = []
        else:
            self.file = file
    def factory(*args_, **kwargs_):
        if Files.subclass:
            return Files.subclass(*args_, **kwargs_)
        else:
            return Files(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_file(self): return self.file
    def set_file(self, file): self.file = file
    def add_file(self, value): self.file.append(value)
    def insert_file(self, index, value): self.file[index] = value
    def hasContent_(self):
        if (
            self.file or
            super(Files, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Files', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Files')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Files'):
        super(Files, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Files')
    def exportChildren(self, outfile, level, namespace_='', name_='Files', fromsubclass_=False, pretty_print=True):
        super(Files, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for file_ in self.file:
            file_.export(outfile, level, namespace_, name_='file', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Files'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Files, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Files, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('file=[\n')
        level += 1
        for file_ in self.file:
            showIndent(outfile, level)
            outfile.write('model_.file(\n')
            file_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Files, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'file':
            obj_ = File.factory()
            obj_.build(child_)
            self.file.append(obj_)
        super(Files, self).buildChildren(child_, node, nodeName_, True)
# end class Files


class Image(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None):
        super(Image, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        pass
    def factory(*args_, **kwargs_):
        if Image.subclass:
            return Image.subclass(*args_, **kwargs_)
        else:
            return Image(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(Image, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Image', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Image')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Image'):
        super(Image, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Image')
    def exportChildren(self, outfile, level, namespace_='', name_='Image', fromsubclass_=False, pretty_print=True):
        super(Image, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Image'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Image, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Image, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Image, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(Image, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class Image


class Images(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, image=None):
        super(Images, self).__init__(actions, total, active, )
        if image is None:
            self.image = []
        else:
            self.image = image
    def factory(*args_, **kwargs_):
        if Images.subclass:
            return Images.subclass(*args_, **kwargs_)
        else:
            return Images(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_image(self): return self.image
    def set_image(self, image): self.image = image
    def add_image(self, value): self.image.append(value)
    def insert_image(self, index, value): self.image[index] = value
    def hasContent_(self):
        if (
            self.image or
            super(Images, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Images', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Images')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Images'):
        super(Images, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Images')
    def exportChildren(self, outfile, level, namespace_='', name_='Images', fromsubclass_=False, pretty_print=True):
        super(Images, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for image_ in self.image:
            image_.export(outfile, level, namespace_, name_='image', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Images'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Images, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Images, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('image=[\n')
        level += 1
        for image_ in self.image:
            showIndent(outfile, level)
            outfile.write('model_.image(\n')
            image_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Images, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'image':
            obj_ = Image.factory()
            obj_.build(child_)
            self.image.append(obj_)
        super(Images, self).buildChildren(child_, node, nodeName_, True)
# end class Images


class Hook(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, event_name=None, md5=None, host=None):
        super(Hook, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.event_name = event_name
        self.md5 = md5
        self.host = host
    def factory(*args_, **kwargs_):
        if Hook.subclass:
            return Hook.subclass(*args_, **kwargs_)
        else:
            return Hook(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_event_name(self): return self.event_name
    def set_event_name(self, event_name): self.event_name = event_name
    def get_md5(self): return self.md5
    def set_md5(self, md5): self.md5 = md5
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def hasContent_(self):
        if (
            self.event_name is not None or
            self.md5 is not None or
            self.host is not None or
            super(Hook, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Hook', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Hook')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Hook'):
        super(Hook, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Hook')
    def exportChildren(self, outfile, level, namespace_='', name_='Hook', fromsubclass_=False, pretty_print=True):
        super(Hook, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.event_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sevent_name>%s</%sevent_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.event_name).encode(ExternalEncoding), input_name='event_name'), namespace_, eol_))
        if self.md5 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smd5>%s</%smd5>%s' % (namespace_, self.gds_format_string(quote_xml(self.md5).encode(ExternalEncoding), input_name='md5'), namespace_, eol_))
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Hook'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Hook, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Hook, self).exportLiteralChildren(outfile, level, name_)
        if self.event_name is not None:
            showIndent(outfile, level)
            outfile.write('event_name=%s,\n' % quote_python(self.event_name).encode(ExternalEncoding))
        if self.md5 is not None:
            showIndent(outfile, level)
            outfile.write('md5=%s,\n' % quote_python(self.md5).encode(ExternalEncoding))
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Hook, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'event_name':
            event_name_ = child_.text
            event_name_ = self.gds_validate_string(event_name_, node, 'event_name')
            self.event_name = event_name_
        elif nodeName_ == 'md5':
            md5_ = child_.text
            md5_ = self.gds_validate_string(md5_, node, 'md5')
            self.md5 = md5_
        elif nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.set_host(obj_)
        super(Hook, self).buildChildren(child_, node, nodeName_, True)
# end class Hook


class Hooks(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, hook=None):
        super(Hooks, self).__init__(actions, total, active, )
        if hook is None:
            self.hook = []
        else:
            self.hook = hook
    def factory(*args_, **kwargs_):
        if Hooks.subclass:
            return Hooks.subclass(*args_, **kwargs_)
        else:
            return Hooks(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_hook(self): return self.hook
    def set_hook(self, hook): self.hook = hook
    def add_hook(self, value): self.hook.append(value)
    def insert_hook(self, index, value): self.hook[index] = value
    def hasContent_(self):
        if (
            self.hook or
            super(Hooks, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Hooks', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Hooks')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Hooks'):
        super(Hooks, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Hooks')
    def exportChildren(self, outfile, level, namespace_='', name_='Hooks', fromsubclass_=False, pretty_print=True):
        super(Hooks, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for hook_ in self.hook:
            hook_.export(outfile, level, namespace_, name_='hook', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Hooks'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Hooks, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Hooks, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('hook=[\n')
        level += 1
        for hook_ in self.hook:
            showIndent(outfile, level)
            outfile.write('model_.hook(\n')
            hook_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Hooks, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'hook':
            obj_ = Hook.factory()
            obj_.build(child_)
            self.hook.append(obj_)
        super(Hooks, self).buildChildren(child_, node, nodeName_, True)
# end class Hooks


class IP(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, netmask=None, version=None, gateway=None, address=None):
        self.netmask = _cast(None, netmask)
        self.version = _cast(None, version)
        self.gateway = _cast(None, gateway)
        self.address = _cast(None, address)
        pass
    def factory(*args_, **kwargs_):
        if IP.subclass:
            return IP.subclass(*args_, **kwargs_)
        else:
            return IP(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_netmask(self): return self.netmask
    def set_netmask(self, netmask): self.netmask = netmask
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_gateway(self): return self.gateway
    def set_gateway(self, gateway): self.gateway = gateway
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IP', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IP')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IP'):
        if self.netmask is not None and 'netmask' not in already_processed:
            already_processed.add('netmask')
            outfile.write(' netmask=%s' % (self.gds_format_string(quote_attrib(self.netmask).encode(ExternalEncoding), input_name='netmask'), ))
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            outfile.write(' version=%s' % (self.gds_format_string(quote_attrib(self.version).encode(ExternalEncoding), input_name='version'), ))
        if self.gateway is not None and 'gateway' not in already_processed:
            already_processed.add('gateway')
            outfile.write(' gateway=%s' % (self.gds_format_string(quote_attrib(self.gateway).encode(ExternalEncoding), input_name='gateway'), ))
        if self.address is not None and 'address' not in already_processed:
            already_processed.add('address')
            outfile.write(' address=%s' % (self.gds_format_string(quote_attrib(self.address).encode(ExternalEncoding), input_name='address'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='IP', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='IP'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.netmask is not None and 'netmask' not in already_processed:
            already_processed.add('netmask')
            showIndent(outfile, level)
            outfile.write('netmask = "%s",\n' % (self.netmask,))
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            showIndent(outfile, level)
            outfile.write('version = "%s",\n' % (self.version,))
        if self.gateway is not None and 'gateway' not in already_processed:
            already_processed.add('gateway')
            showIndent(outfile, level)
            outfile.write('gateway = "%s",\n' % (self.gateway,))
        if self.address is not None and 'address' not in already_processed:
            already_processed.add('address')
            showIndent(outfile, level)
            outfile.write('address = "%s",\n' % (self.address,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('netmask', node)
        if value is not None and 'netmask' not in already_processed:
            already_processed.add('netmask')
            self.netmask = value
        value = find_attr_value_('version', node)
        if value is not None and 'version' not in already_processed:
            already_processed.add('version')
            self.version = value
        value = find_attr_value_('gateway', node)
        if value is not None and 'gateway' not in already_processed:
            already_processed.add('gateway')
            self.gateway = value
        value = find_attr_value_('address', node)
        if value is not None and 'address' not in already_processed:
            already_processed.add('address')
            self.address = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class IP


class IPs(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, ip=None):
        super(IPs, self).__init__(actions, total, active, )
        if ip is None:
            self.ip = []
        else:
            self.ip = ip
    def factory(*args_, **kwargs_):
        if IPs.subclass:
            return IPs.subclass(*args_, **kwargs_)
        else:
            return IPs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ip(self): return self.ip
    def set_ip(self, ip): self.ip = ip
    def add_ip(self, value): self.ip.append(value)
    def insert_ip(self, index, value): self.ip[index] = value
    def hasContent_(self):
        if (
            self.ip or
            super(IPs, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IPs', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IPs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IPs'):
        super(IPs, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IPs')
    def exportChildren(self, outfile, level, namespace_='', name_='IPs', fromsubclass_=False, pretty_print=True):
        super(IPs, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ip_ in self.ip:
            ip_.export(outfile, level, namespace_, name_='ip', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IPs'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(IPs, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IPs, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('ip=[\n')
        level += 1
        for ip_ in self.ip:
            showIndent(outfile, level)
            outfile.write('model_.ip(\n')
            ip_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(IPs, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ip':
            obj_ = IP.factory()
            obj_.build(child_)
            self.ip.append(obj_)
        super(IPs, self).buildChildren(child_, node, nodeName_, True)
# end class IPs


class MAC(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, address=None):
        self.address = _cast(None, address)
        pass
    def factory(*args_, **kwargs_):
        if MAC.subclass:
            return MAC.subclass(*args_, **kwargs_)
        else:
            return MAC(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MAC', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MAC')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MAC'):
        if self.address is not None and 'address' not in already_processed:
            already_processed.add('address')
            outfile.write(' address=%s' % (self.gds_format_string(quote_attrib(self.address).encode(ExternalEncoding), input_name='address'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='MAC', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='MAC'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.address is not None and 'address' not in already_processed:
            already_processed.add('address')
            showIndent(outfile, level)
            outfile.write('address = "%s",\n' % (self.address,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('address', node)
        if value is not None and 'address' not in already_processed:
            already_processed.add('address')
            self.address = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class MAC


class VLAN(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None):
        self.id = _cast(int, id)
        pass
    def factory(*args_, **kwargs_):
        if VLAN.subclass:
            return VLAN.subclass(*args_, **kwargs_)
        else:
            return VLAN(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VLAN', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VLAN')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VLAN'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespace_='', name_='VLAN', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='VLAN'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id = %d,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class VLAN


class Network(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, data_center=None, cluster=None, ip=None, vlan=None, stp=None, status=None, display=None, mtu=None, usages=None, required=None, profile_required=None):
        super(Network, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.data_center = data_center
        self.cluster = cluster
        self.ip = ip
        self.vlan = vlan
        self.stp = stp
        self.status = status
        self.display = display
        self.mtu = mtu
        self.usages = usages
        self.required = required
        self.profile_required = profile_required
    def factory(*args_, **kwargs_):
        if Network.subclass:
            return Network.subclass(*args_, **kwargs_)
        else:
            return Network(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_data_center(self): return self.data_center
    def set_data_center(self, data_center): self.data_center = data_center
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def get_ip(self): return self.ip
    def set_ip(self, ip): self.ip = ip
    def get_vlan(self): return self.vlan
    def set_vlan(self, vlan): self.vlan = vlan
    def get_stp(self): return self.stp
    def set_stp(self, stp): self.stp = stp
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_display(self): return self.display
    def set_display(self, display): self.display = display
    def get_mtu(self): return self.mtu
    def set_mtu(self, mtu): self.mtu = mtu
    def get_usages(self): return self.usages
    def set_usages(self, usages): self.usages = usages
    def get_required(self): return self.required
    def set_required(self, required): self.required = required
    def get_profile_required(self): return self.profile_required
    def set_profile_required(self, profile_required): self.profile_required = profile_required
    def hasContent_(self):
        if (
            self.data_center is not None or
            self.cluster is not None or
            self.ip is not None or
            self.vlan is not None or
            self.stp is not None or
            self.status is not None or
            self.display is not None or
            self.mtu is not None or
            self.usages is not None or
            self.required is not None or
            self.profile_required is not None or
            super(Network, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Network', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Network')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Network'):
        super(Network, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Network')
    def exportChildren(self, outfile, level, namespace_='', name_='Network', fromsubclass_=False, pretty_print=True):
        super(Network, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.data_center is not None:
            self.data_center.export(outfile, level, namespace_, name_='data_center', pretty_print=pretty_print)
        if self.cluster is not None:
            self.cluster.export(outfile, level, namespace_, name_='cluster', pretty_print=pretty_print)
        if self.ip is not None:
            self.ip.export(outfile, level, namespace_, name_='ip', pretty_print=pretty_print)
        if self.vlan is not None:
            self.vlan.export(outfile, level, namespace_, name_='vlan', pretty_print=pretty_print)
        if self.stp is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstp>%s</%sstp>%s' % (namespace_, self.gds_format_boolean(self.stp, input_name='stp'), namespace_, eol_))
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status', pretty_print=pretty_print)
        if self.display is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplay>%s</%sdisplay>%s' % (namespace_, self.gds_format_boolean(self.display, input_name='display'), namespace_, eol_))
        if self.mtu is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smtu>%s</%smtu>%s' % (namespace_, self.gds_format_integer(self.mtu, input_name='mtu'), namespace_, eol_))
        if self.usages is not None:
            self.usages.export(outfile, level, namespace_, name_='usages', pretty_print=pretty_print)
        if self.required is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srequired>%s</%srequired>%s' % (namespace_, self.gds_format_boolean(self.required, input_name='required'), namespace_, eol_))
        if self.profile_required is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprofile_required>%s</%sprofile_required>%s' % (namespace_, self.gds_format_boolean(self.profile_required, input_name='profile_required'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Network'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Network, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Network, self).exportLiteralChildren(outfile, level, name_)
        if self.data_center is not None:
            showIndent(outfile, level)
            outfile.write('data_center=model_.data_center(\n')
            self.data_center.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cluster is not None:
            showIndent(outfile, level)
            outfile.write('cluster=model_.cluster(\n')
            self.cluster.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ip is not None:
            showIndent(outfile, level)
            outfile.write('ip=model_.ip(\n')
            self.ip.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vlan is not None:
            showIndent(outfile, level)
            outfile.write('vlan=model_.vlan(\n')
            self.vlan.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.stp is not None:
            showIndent(outfile, level)
            outfile.write('stp=%s,\n' % self.stp)
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.display is not None:
            showIndent(outfile, level)
            outfile.write('display=%s,\n' % self.display)
        if self.mtu is not None:
            showIndent(outfile, level)
            outfile.write('mtu=%d,\n' % self.mtu)
        if self.usages is not None:
            showIndent(outfile, level)
            outfile.write('usages=model_.usages(\n')
            self.usages.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.required is not None:
            showIndent(outfile, level)
            outfile.write('required=%s,\n' % self.required)
        if self.profile_required is not None:
            showIndent(outfile, level)
            outfile.write('profile_required=%s,\n' % self.profile_required)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Network, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'data_center':
            obj_ = DataCenter.factory()
            obj_.build(child_)
            self.set_data_center(obj_)
        elif nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.set_cluster(obj_)
        elif nodeName_ == 'ip':
            obj_ = IP.factory()
            obj_.build(child_)
            self.set_ip(obj_)
        elif nodeName_ == 'vlan':
            obj_ = VLAN.factory()
            obj_.build(child_)
            self.set_vlan(obj_)
        elif nodeName_ == 'stp':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'stp')
            self.stp = ival_
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.set_status(obj_)
        elif nodeName_ == 'display':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'display')
            self.display = ival_
        elif nodeName_ == 'mtu':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'mtu')
            self.mtu = ival_
        elif nodeName_ == 'usages':
            obj_ = Usages.factory()
            obj_.build(child_)
            self.set_usages(obj_)
        elif nodeName_ == 'required':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'required')
            self.required = ival_
        elif nodeName_ == 'profile_required':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'profile_required')
            self.profile_required = ival_
        super(Network, self).buildChildren(child_, node, nodeName_, True)
# end class Network


class NetworkStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, network_state=None):
        if network_state is None:
            self.network_state = []
        else:
            self.network_state = network_state
    def factory(*args_, **kwargs_):
        if NetworkStates.subclass:
            return NetworkStates.subclass(*args_, **kwargs_)
        else:
            return NetworkStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_network_state(self): return self.network_state
    def set_network_state(self, network_state): self.network_state = network_state
    def add_network_state(self, value): self.network_state.append(value)
    def insert_network_state(self, index, value): self.network_state[index] = value
    def hasContent_(self):
        if (
            self.network_state
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NetworkStates', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkStates')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NetworkStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='NetworkStates', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for network_state_ in self.network_state:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snetwork_state>%s</%snetwork_state>%s' % (namespace_, self.gds_format_string(quote_xml(network_state_).encode(ExternalEncoding), input_name='network_state'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='NetworkStates'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('network_state=[\n')
        level += 1
        for network_state_ in self.network_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(network_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'network_state':
            network_state_ = child_.text
            network_state_ = self.gds_validate_string(network_state_, node, 'network_state')
            self.network_state.append(network_state_)
# end class NetworkStates


class Networks(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, network=None):
        super(Networks, self).__init__(actions, total, active, )
        if network is None:
            self.network = []
        else:
            self.network = network
    def factory(*args_, **kwargs_):
        if Networks.subclass:
            return Networks.subclass(*args_, **kwargs_)
        else:
            return Networks(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_network(self): return self.network
    def set_network(self, network): self.network = network
    def add_network(self, value): self.network.append(value)
    def insert_network(self, index, value): self.network[index] = value
    def hasContent_(self):
        if (
            self.network or
            super(Networks, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Networks', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Networks')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Networks'):
        super(Networks, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Networks')
    def exportChildren(self, outfile, level, namespace_='', name_='Networks', fromsubclass_=False, pretty_print=True):
        super(Networks, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for network_ in self.network:
            network_.export(outfile, level, namespace_, name_='network', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Networks'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Networks, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Networks, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('network=[\n')
        level += 1
        for network_ in self.network:
            showIndent(outfile, level)
            outfile.write('model_.network(\n')
            network_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Networks, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'network':
            obj_ = Network.factory()
            obj_.build(child_)
            self.network.append(obj_)
        super(Networks, self).buildChildren(child_, node, nodeName_, True)
# end class Networks


class VnicProfile(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, network=None, port_mirroring=None, custom_properties=None):
        super(VnicProfile, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.network = network
        self.port_mirroring = port_mirroring
        self.custom_properties = custom_properties
    def factory(*args_, **kwargs_):
        if VnicProfile.subclass:
            return VnicProfile.subclass(*args_, **kwargs_)
        else:
            return VnicProfile(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_network(self): return self.network
    def set_network(self, network): self.network = network
    def get_port_mirroring(self): return self.port_mirroring
    def set_port_mirroring(self, port_mirroring): self.port_mirroring = port_mirroring
    def get_custom_properties(self): return self.custom_properties
    def set_custom_properties(self, custom_properties): self.custom_properties = custom_properties
    def hasContent_(self):
        if (
            self.network is not None or
            self.port_mirroring is not None or
            self.custom_properties is not None or
            super(VnicProfile, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VnicProfile', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VnicProfile')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VnicProfile'):
        super(VnicProfile, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VnicProfile')
    def exportChildren(self, outfile, level, namespace_='', name_='VnicProfile', fromsubclass_=False, pretty_print=True):
        super(VnicProfile, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.network is not None:
            self.network.export(outfile, level, namespace_, name_='network', pretty_print=pretty_print)
        if self.port_mirroring is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sport_mirroring>%s</%sport_mirroring>%s' % (namespace_, self.gds_format_boolean(self.port_mirroring, input_name='port_mirroring'), namespace_, eol_))
        if self.custom_properties is not None:
            self.custom_properties.export(outfile, level, namespace_, name_='custom_properties', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VnicProfile'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(VnicProfile, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VnicProfile, self).exportLiteralChildren(outfile, level, name_)
        if self.network is not None:
            showIndent(outfile, level)
            outfile.write('network=model_.network(\n')
            self.network.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.port_mirroring is not None:
            showIndent(outfile, level)
            outfile.write('port_mirroring=%s,\n' % self.port_mirroring)
        if self.custom_properties is not None:
            showIndent(outfile, level)
            outfile.write('custom_properties=model_.custom_properties(\n')
            self.custom_properties.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(VnicProfile, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'network':
            obj_ = Network.factory()
            obj_.build(child_)
            self.set_network(obj_)
        elif nodeName_ == 'port_mirroring':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'port_mirroring')
            self.port_mirroring = ival_
        elif nodeName_ == 'custom_properties':
            obj_ = CustomProperties.factory()
            obj_.build(child_)
            self.set_custom_properties(obj_)
        super(VnicProfile, self).buildChildren(child_, node, nodeName_, True)
# end class VnicProfile


class VnicProfiles(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, vnic_profile=None):
        super(VnicProfiles, self).__init__(actions, total, active, )
        if vnic_profile is None:
            self.vnic_profile = []
        else:
            self.vnic_profile = vnic_profile
    def factory(*args_, **kwargs_):
        if VnicProfiles.subclass:
            return VnicProfiles.subclass(*args_, **kwargs_)
        else:
            return VnicProfiles(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vnic_profile(self): return self.vnic_profile
    def set_vnic_profile(self, vnic_profile): self.vnic_profile = vnic_profile
    def add_vnic_profile(self, value): self.vnic_profile.append(value)
    def insert_vnic_profile(self, index, value): self.vnic_profile[index] = value
    def hasContent_(self):
        if (
            self.vnic_profile or
            super(VnicProfiles, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VnicProfiles', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VnicProfiles')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VnicProfiles'):
        super(VnicProfiles, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VnicProfiles')
    def exportChildren(self, outfile, level, namespace_='', name_='VnicProfiles', fromsubclass_=False, pretty_print=True):
        super(VnicProfiles, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for vnic_profile_ in self.vnic_profile:
            vnic_profile_.export(outfile, level, namespace_, name_='vnic_profile', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VnicProfiles'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(VnicProfiles, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VnicProfiles, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('vnic_profile=[\n')
        level += 1
        for vnic_profile_ in self.vnic_profile:
            showIndent(outfile, level)
            outfile.write('model_.vnic_profile(\n')
            vnic_profile_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(VnicProfiles, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vnic_profile':
            obj_ = VnicProfile.factory()
            obj_.build(child_)
            self.vnic_profile.append(obj_)
        super(VnicProfiles, self).buildChildren(child_, node, nodeName_, True)
# end class VnicProfiles


class LogicalUnit(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, port=None, target=None, username=None, password=None, portal=None, address=None, serial=None, vendor_id=None, product_id=None, lun_mapping=None, size=None, paths=None, status=None, volume_group_id=None, storage_domain_id=None, disk_id=None):
        self.id = _cast(None, id)
        self.port = port
        self.target = target
        self.username = username
        self.password = password
        self.portal = portal
        self.address = address
        self.serial = serial
        self.vendor_id = vendor_id
        self.product_id = product_id
        self.lun_mapping = lun_mapping
        self.size = size
        self.paths = paths
        self.status = status
        self.volume_group_id = volume_group_id
        self.storage_domain_id = storage_domain_id
        self.disk_id = disk_id
    def factory(*args_, **kwargs_):
        if LogicalUnit.subclass:
            return LogicalUnit.subclass(*args_, **kwargs_)
        else:
            return LogicalUnit(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_port(self): return self.port
    def set_port(self, port): self.port = port
    def get_target(self): return self.target
    def set_target(self, target): self.target = target
    def get_username(self): return self.username
    def set_username(self, username): self.username = username
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_portal(self): return self.portal
    def set_portal(self, portal): self.portal = portal
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_serial(self): return self.serial
    def set_serial(self, serial): self.serial = serial
    def get_vendor_id(self): return self.vendor_id
    def set_vendor_id(self, vendor_id): self.vendor_id = vendor_id
    def get_product_id(self): return self.product_id
    def set_product_id(self, product_id): self.product_id = product_id
    def get_lun_mapping(self): return self.lun_mapping
    def set_lun_mapping(self, lun_mapping): self.lun_mapping = lun_mapping
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def get_paths(self): return self.paths
    def set_paths(self, paths): self.paths = paths
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_volume_group_id(self): return self.volume_group_id
    def set_volume_group_id(self, volume_group_id): self.volume_group_id = volume_group_id
    def get_storage_domain_id(self): return self.storage_domain_id
    def set_storage_domain_id(self, storage_domain_id): self.storage_domain_id = storage_domain_id
    def get_disk_id(self): return self.disk_id
    def set_disk_id(self, disk_id): self.disk_id = disk_id
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def hasContent_(self):
        if (
            self.port is not None or
            self.target is not None or
            self.username is not None or
            self.password is not None or
            self.portal is not None or
            self.address is not None or
            self.serial is not None or
            self.vendor_id is not None or
            self.product_id is not None or
            self.lun_mapping is not None or
            self.size is not None or
            self.paths is not None or
            self.status is not None or
            self.volume_group_id is not None or
            self.storage_domain_id is not None or
            self.disk_id is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LogicalUnit', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LogicalUnit')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LogicalUnit'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='LogicalUnit', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.port is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sport>%s</%sport>%s' % (namespace_, self.gds_format_integer(self.port, input_name='port'), namespace_, eol_))
        if self.target is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%starget>%s</%starget>%s' % (namespace_, self.gds_format_string(quote_xml(self.target).encode(ExternalEncoding), input_name='target'), namespace_, eol_))
        if self.username is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%susername>%s</%susername>%s' % (namespace_, self.gds_format_string(quote_xml(self.username).encode(ExternalEncoding), input_name='username'), namespace_, eol_))
        if self.password is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespace_, self.gds_format_string(quote_xml(self.password).encode(ExternalEncoding), input_name='password'), namespace_, eol_))
        if self.portal is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sportal>%s</%sportal>%s' % (namespace_, self.gds_format_string(quote_xml(self.portal).encode(ExternalEncoding), input_name='portal'), namespace_, eol_))
        if self.address is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress>%s</%saddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_, eol_))
        if self.serial is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sserial>%s</%sserial>%s' % (namespace_, self.gds_format_string(quote_xml(self.serial).encode(ExternalEncoding), input_name='serial'), namespace_, eol_))
        if self.vendor_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svendor_id>%s</%svendor_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.vendor_id).encode(ExternalEncoding), input_name='vendor_id'), namespace_, eol_))
        if self.product_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sproduct_id>%s</%sproduct_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.product_id).encode(ExternalEncoding), input_name='product_id'), namespace_, eol_))
        if self.lun_mapping is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slun_mapping>%s</%slun_mapping>%s' % (namespace_, self.gds_format_integer(self.lun_mapping, input_name='lun_mapping'), namespace_, eol_))
        if self.size is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssize>%s</%ssize>%s' % (namespace_, self.gds_format_integer(self.size, input_name='size'), namespace_, eol_))
        if self.paths is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spaths>%s</%spaths>%s' % (namespace_, self.gds_format_integer(self.paths, input_name='paths'), namespace_, eol_))
        if self.status is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstatus>%s</%sstatus>%s' % (namespace_, self.gds_format_string(quote_xml(self.status).encode(ExternalEncoding), input_name='status'), namespace_, eol_))
        if self.volume_group_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svolume_group_id>%s</%svolume_group_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.volume_group_id).encode(ExternalEncoding), input_name='volume_group_id'), namespace_, eol_))
        if self.storage_domain_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstorage_domain_id>%s</%sstorage_domain_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.storage_domain_id).encode(ExternalEncoding), input_name='storage_domain_id'), namespace_, eol_))
        if self.disk_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisk_id>%s</%sdisk_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.disk_id).encode(ExternalEncoding), input_name='disk_id'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='LogicalUnit'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('port=%d,\n' % self.port)
        if self.target is not None:
            showIndent(outfile, level)
            outfile.write('target=%s,\n' % quote_python(self.target).encode(ExternalEncoding))
        if self.username is not None:
            showIndent(outfile, level)
            outfile.write('username=%s,\n' % quote_python(self.username).encode(ExternalEncoding))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % quote_python(self.password).encode(ExternalEncoding))
        if self.portal is not None:
            showIndent(outfile, level)
            outfile.write('portal=%s,\n' % quote_python(self.portal).encode(ExternalEncoding))
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.serial is not None:
            showIndent(outfile, level)
            outfile.write('serial=%s,\n' % quote_python(self.serial).encode(ExternalEncoding))
        if self.vendor_id is not None:
            showIndent(outfile, level)
            outfile.write('vendor_id=%s,\n' % quote_python(self.vendor_id).encode(ExternalEncoding))
        if self.product_id is not None:
            showIndent(outfile, level)
            outfile.write('product_id=%s,\n' % quote_python(self.product_id).encode(ExternalEncoding))
        if self.lun_mapping is not None:
            showIndent(outfile, level)
            outfile.write('lun_mapping=%d,\n' % self.lun_mapping)
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % self.size)
        if self.paths is not None:
            showIndent(outfile, level)
            outfile.write('paths=%d,\n' % self.paths)
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=%s,\n' % quote_python(self.status).encode(ExternalEncoding))
        if self.volume_group_id is not None:
            showIndent(outfile, level)
            outfile.write('volume_group_id=%s,\n' % quote_python(self.volume_group_id).encode(ExternalEncoding))
        if self.storage_domain_id is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain_id=%s,\n' % quote_python(self.storage_domain_id).encode(ExternalEncoding))
        if self.disk_id is not None:
            showIndent(outfile, level)
            outfile.write('disk_id=%s,\n' % quote_python(self.disk_id).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'port')
            self.port = ival_
        elif nodeName_ == 'target':
            target_ = child_.text
            target_ = self.gds_validate_string(target_, node, 'target')
            self.target = target_
        elif nodeName_ == 'username':
            username_ = child_.text
            username_ = self.gds_validate_string(username_, node, 'username')
            self.username = username_
        elif nodeName_ == 'password':
            password_ = child_.text
            password_ = self.gds_validate_string(password_, node, 'password')
            self.password = password_
        elif nodeName_ == 'portal':
            portal_ = child_.text
            portal_ = self.gds_validate_string(portal_, node, 'portal')
            self.portal = portal_
        elif nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'serial':
            serial_ = child_.text
            serial_ = self.gds_validate_string(serial_, node, 'serial')
            self.serial = serial_
        elif nodeName_ == 'vendor_id':
            vendor_id_ = child_.text
            vendor_id_ = self.gds_validate_string(vendor_id_, node, 'vendor_id')
            self.vendor_id = vendor_id_
        elif nodeName_ == 'product_id':
            product_id_ = child_.text
            product_id_ = self.gds_validate_string(product_id_, node, 'product_id')
            self.product_id = product_id_
        elif nodeName_ == 'lun_mapping':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'lun_mapping')
            self.lun_mapping = ival_
        elif nodeName_ == 'size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'size')
            self.size = ival_
        elif nodeName_ == 'paths':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'paths')
            self.paths = ival_
        elif nodeName_ == 'status':
            status_ = child_.text
            status_ = self.gds_validate_string(status_, node, 'status')
            self.status = status_
        elif nodeName_ == 'volume_group_id':
            volume_group_id_ = child_.text
            volume_group_id_ = self.gds_validate_string(volume_group_id_, node, 'volume_group_id')
            self.volume_group_id = volume_group_id_
        elif nodeName_ == 'storage_domain_id':
            storage_domain_id_ = child_.text
            storage_domain_id_ = self.gds_validate_string(storage_domain_id_, node, 'storage_domain_id')
            self.storage_domain_id = storage_domain_id_
        elif nodeName_ == 'disk_id':
            disk_id_ = child_.text
            disk_id_ = self.gds_validate_string(disk_id_, node, 'disk_id')
            self.disk_id = disk_id_
# end class LogicalUnit


class VolumeGroup(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None, logical_unit=None):
        self.id = _cast(None, id)
        self.name = name
        if logical_unit is None:
            self.logical_unit = []
        else:
            self.logical_unit = logical_unit
    def factory(*args_, **kwargs_):
        if VolumeGroup.subclass:
            return VolumeGroup.subclass(*args_, **kwargs_)
        else:
            return VolumeGroup(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_logical_unit(self): return self.logical_unit
    def set_logical_unit(self, logical_unit): self.logical_unit = logical_unit
    def add_logical_unit(self, value): self.logical_unit.append(value)
    def insert_logical_unit(self, index, value): self.logical_unit[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def hasContent_(self):
        if (
            self.name is not None or
            self.logical_unit
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VolumeGroup', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VolumeGroup')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VolumeGroup'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='VolumeGroup', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_, eol_))
        for logical_unit_ in self.logical_unit:
            logical_unit_.export(outfile, level, namespace_, name_='logical_unit', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VolumeGroup'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('logical_unit=[\n')
        level += 1
        for logical_unit_ in self.logical_unit:
            showIndent(outfile, level)
            outfile.write('model_.logical_unit(\n')
            logical_unit_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'logical_unit':
            obj_ = LogicalUnit.factory()
            obj_.build(child_)
            self.logical_unit.append(obj_)
# end class VolumeGroup


class Storage(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, address=None, type_=None, path=None, mount_options=None, vfs_type=None, nfs_version=None, nfs_timeo=None, nfs_retrans=None, logical_unit=None, volume_group=None, override_luns=None, port=None, target=None, username=None, password=None, portal=None, host=None):
        super(Storage, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.address = address
        self.type_ = type_
        self.path = path
        self.mount_options = mount_options
        self.vfs_type = vfs_type
        self.nfs_version = nfs_version
        self.nfs_timeo = nfs_timeo
        self.nfs_retrans = nfs_retrans
        if logical_unit is None:
            self.logical_unit = []
        else:
            self.logical_unit = logical_unit
        self.volume_group = volume_group
        self.override_luns = override_luns
        self.port = port
        self.target = target
        self.username = username
        self.password = password
        self.portal = portal
        self.host = host
    def factory(*args_, **kwargs_):
        if Storage.subclass:
            return Storage.subclass(*args_, **kwargs_)
        else:
            return Storage(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_path(self): return self.path
    def set_path(self, path): self.path = path
    def get_mount_options(self): return self.mount_options
    def set_mount_options(self, mount_options): self.mount_options = mount_options
    def get_vfs_type(self): return self.vfs_type
    def set_vfs_type(self, vfs_type): self.vfs_type = vfs_type
    def get_nfs_version(self): return self.nfs_version
    def set_nfs_version(self, nfs_version): self.nfs_version = nfs_version
    def get_nfs_timeo(self): return self.nfs_timeo
    def set_nfs_timeo(self, nfs_timeo): self.nfs_timeo = nfs_timeo
    def get_nfs_retrans(self): return self.nfs_retrans
    def set_nfs_retrans(self, nfs_retrans): self.nfs_retrans = nfs_retrans
    def get_logical_unit(self): return self.logical_unit
    def set_logical_unit(self, logical_unit): self.logical_unit = logical_unit
    def add_logical_unit(self, value): self.logical_unit.append(value)
    def insert_logical_unit(self, index, value): self.logical_unit[index] = value
    def get_volume_group(self): return self.volume_group
    def set_volume_group(self, volume_group): self.volume_group = volume_group
    def get_override_luns(self): return self.override_luns
    def set_override_luns(self, override_luns): self.override_luns = override_luns
    def get_port(self): return self.port
    def set_port(self, port): self.port = port
    def get_target(self): return self.target
    def set_target(self, target): self.target = target
    def get_username(self): return self.username
    def set_username(self, username): self.username = username
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_portal(self): return self.portal
    def set_portal(self, portal): self.portal = portal
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def hasContent_(self):
        if (
            self.address is not None or
            self.type_ is not None or
            self.path is not None or
            self.mount_options is not None or
            self.vfs_type is not None or
            self.nfs_version is not None or
            self.nfs_timeo is not None or
            self.nfs_retrans is not None or
            self.logical_unit or
            self.volume_group is not None or
            self.override_luns is not None or
            self.port is not None or
            self.target is not None or
            self.username is not None or
            self.password is not None or
            self.portal is not None or
            self.host is not None or
            super(Storage, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Storage', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Storage')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Storage'):
        super(Storage, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Storage')
    def exportChildren(self, outfile, level, namespace_='', name_='Storage', fromsubclass_=False, pretty_print=True):
        super(Storage, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.address is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress>%s</%saddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_, eol_))
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.path is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spath>%s</%spath>%s' % (namespace_, self.gds_format_string(quote_xml(self.path).encode(ExternalEncoding), input_name='path'), namespace_, eol_))
        if self.mount_options is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smount_options>%s</%smount_options>%s' % (namespace_, self.gds_format_string(quote_xml(self.mount_options).encode(ExternalEncoding), input_name='mount_options'), namespace_, eol_))
        if self.vfs_type is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svfs_type>%s</%svfs_type>%s' % (namespace_, self.gds_format_string(quote_xml(self.vfs_type).encode(ExternalEncoding), input_name='vfs_type'), namespace_, eol_))
        if self.nfs_version is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snfs_version>%s</%snfs_version>%s' % (namespace_, self.gds_format_string(quote_xml(self.nfs_version).encode(ExternalEncoding), input_name='nfs_version'), namespace_, eol_))
        if self.nfs_timeo is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snfs_timeo>%s</%snfs_timeo>%s' % (namespace_, self.gds_format_integer(self.nfs_timeo, input_name='nfs_timeo'), namespace_, eol_))
        if self.nfs_retrans is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snfs_retrans>%s</%snfs_retrans>%s' % (namespace_, self.gds_format_integer(self.nfs_retrans, input_name='nfs_retrans'), namespace_, eol_))
        for logical_unit_ in self.logical_unit:
            logical_unit_.export(outfile, level, namespace_, name_='logical_unit', pretty_print=pretty_print)
        if self.volume_group is not None:
            self.volume_group.export(outfile, level, namespace_, name_='volume_group', pretty_print=pretty_print)
        if self.override_luns is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soverride_luns>%s</%soverride_luns>%s' % (namespace_, self.gds_format_boolean(self.override_luns, input_name='override_luns'), namespace_, eol_))
        if self.port is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sport>%s</%sport>%s' % (namespace_, self.gds_format_integer(self.port, input_name='port'), namespace_, eol_))
        if self.target is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%starget>%s</%starget>%s' % (namespace_, self.gds_format_string(quote_xml(self.target).encode(ExternalEncoding), input_name='target'), namespace_, eol_))
        if self.username is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%susername>%s</%susername>%s' % (namespace_, self.gds_format_string(quote_xml(self.username).encode(ExternalEncoding), input_name='username'), namespace_, eol_))
        if self.password is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespace_, self.gds_format_string(quote_xml(self.password).encode(ExternalEncoding), input_name='password'), namespace_, eol_))
        if self.portal is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sportal>%s</%sportal>%s' % (namespace_, self.gds_format_string(quote_xml(self.portal).encode(ExternalEncoding), input_name='portal'), namespace_, eol_))
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Storage'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Storage, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Storage, self).exportLiteralChildren(outfile, level, name_)
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.path is not None:
            showIndent(outfile, level)
            outfile.write('path=%s,\n' % quote_python(self.path).encode(ExternalEncoding))
        if self.mount_options is not None:
            showIndent(outfile, level)
            outfile.write('mount_options=%s,\n' % quote_python(self.mount_options).encode(ExternalEncoding))
        if self.vfs_type is not None:
            showIndent(outfile, level)
            outfile.write('vfs_type=%s,\n' % quote_python(self.vfs_type).encode(ExternalEncoding))
        if self.nfs_version is not None:
            showIndent(outfile, level)
            outfile.write('nfs_version=%s,\n' % quote_python(self.nfs_version).encode(ExternalEncoding))
        if self.nfs_timeo is not None:
            showIndent(outfile, level)
            outfile.write('nfs_timeo=%d,\n' % self.nfs_timeo)
        if self.nfs_retrans is not None:
            showIndent(outfile, level)
            outfile.write('nfs_retrans=%d,\n' % self.nfs_retrans)
        showIndent(outfile, level)
        outfile.write('logical_unit=[\n')
        level += 1
        for logical_unit_ in self.logical_unit:
            showIndent(outfile, level)
            outfile.write('model_.logical_unit(\n')
            logical_unit_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.volume_group is not None:
            showIndent(outfile, level)
            outfile.write('volume_group=model_.volume_group(\n')
            self.volume_group.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.override_luns is not None:
            showIndent(outfile, level)
            outfile.write('override_luns=%s,\n' % self.override_luns)
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('port=%d,\n' % self.port)
        if self.target is not None:
            showIndent(outfile, level)
            outfile.write('target=%s,\n' % quote_python(self.target).encode(ExternalEncoding))
        if self.username is not None:
            showIndent(outfile, level)
            outfile.write('username=%s,\n' % quote_python(self.username).encode(ExternalEncoding))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % quote_python(self.password).encode(ExternalEncoding))
        if self.portal is not None:
            showIndent(outfile, level)
            outfile.write('portal=%s,\n' % quote_python(self.portal).encode(ExternalEncoding))
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Storage, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'path':
            path_ = child_.text
            path_ = self.gds_validate_string(path_, node, 'path')
            self.path = path_
        elif nodeName_ == 'mount_options':
            mount_options_ = child_.text
            mount_options_ = self.gds_validate_string(mount_options_, node, 'mount_options')
            self.mount_options = mount_options_
        elif nodeName_ == 'vfs_type':
            vfs_type_ = child_.text
            vfs_type_ = self.gds_validate_string(vfs_type_, node, 'vfs_type')
            self.vfs_type = vfs_type_
        elif nodeName_ == 'nfs_version':
            nfs_version_ = child_.text
            nfs_version_ = self.gds_validate_string(nfs_version_, node, 'nfs_version')
            self.nfs_version = nfs_version_
        elif nodeName_ == 'nfs_timeo':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'nfs_timeo')
            self.nfs_timeo = ival_
        elif nodeName_ == 'nfs_retrans':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'nfs_retrans')
            self.nfs_retrans = ival_
        elif nodeName_ == 'logical_unit':
            obj_ = LogicalUnit.factory()
            obj_.build(child_)
            self.logical_unit.append(obj_)
        elif nodeName_ == 'volume_group':
            obj_ = VolumeGroup.factory()
            obj_.build(child_)
            self.set_volume_group(obj_)
        elif nodeName_ == 'override_luns':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'override_luns')
            self.override_luns = ival_
        elif nodeName_ == 'port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'port')
            self.port = ival_
        elif nodeName_ == 'target':
            target_ = child_.text
            target_ = self.gds_validate_string(target_, node, 'target')
            self.target = target_
        elif nodeName_ == 'username':
            username_ = child_.text
            username_ = self.gds_validate_string(username_, node, 'username')
            self.username = username_
        elif nodeName_ == 'password':
            password_ = child_.text
            password_ = self.gds_validate_string(password_, node, 'password')
            self.password = password_
        elif nodeName_ == 'portal':
            portal_ = child_.text
            portal_ = self.gds_validate_string(portal_, node, 'portal')
            self.portal = portal_
        elif nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.set_host(obj_)
        super(Storage, self).buildChildren(child_, node, nodeName_, True)
# end class Storage


class StorageConnection(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, address=None, type_=None, path=None, mount_options=None, vfs_type=None, nfs_version=None, nfs_timeo=None, nfs_retrans=None, port=None, target=None, username=None, password=None, portal=None, host=None):
        super(StorageConnection, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.address = address
        self.type_ = type_
        self.path = path
        self.mount_options = mount_options
        self.vfs_type = vfs_type
        self.nfs_version = nfs_version
        self.nfs_timeo = nfs_timeo
        self.nfs_retrans = nfs_retrans
        self.port = port
        self.target = target
        self.username = username
        self.password = password
        self.portal = portal
        self.host = host
    def factory(*args_, **kwargs_):
        if StorageConnection.subclass:
            return StorageConnection.subclass(*args_, **kwargs_)
        else:
            return StorageConnection(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_path(self): return self.path
    def set_path(self, path): self.path = path
    def get_mount_options(self): return self.mount_options
    def set_mount_options(self, mount_options): self.mount_options = mount_options
    def get_vfs_type(self): return self.vfs_type
    def set_vfs_type(self, vfs_type): self.vfs_type = vfs_type
    def get_nfs_version(self): return self.nfs_version
    def set_nfs_version(self, nfs_version): self.nfs_version = nfs_version
    def get_nfs_timeo(self): return self.nfs_timeo
    def set_nfs_timeo(self, nfs_timeo): self.nfs_timeo = nfs_timeo
    def get_nfs_retrans(self): return self.nfs_retrans
    def set_nfs_retrans(self, nfs_retrans): self.nfs_retrans = nfs_retrans
    def get_port(self): return self.port
    def set_port(self, port): self.port = port
    def get_target(self): return self.target
    def set_target(self, target): self.target = target
    def get_username(self): return self.username
    def set_username(self, username): self.username = username
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_portal(self): return self.portal
    def set_portal(self, portal): self.portal = portal
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def hasContent_(self):
        if (
            self.address is not None or
            self.type_ is not None or
            self.path is not None or
            self.mount_options is not None or
            self.vfs_type is not None or
            self.nfs_version is not None or
            self.nfs_timeo is not None or
            self.nfs_retrans is not None or
            self.port is not None or
            self.target is not None or
            self.username is not None or
            self.password is not None or
            self.portal is not None or
            self.host is not None or
            super(StorageConnection, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StorageConnection', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageConnection')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageConnection'):
        super(StorageConnection, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StorageConnection')
    def exportChildren(self, outfile, level, namespace_='', name_='StorageConnection', fromsubclass_=False, pretty_print=True):
        super(StorageConnection, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.address is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress>%s</%saddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_, eol_))
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.path is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spath>%s</%spath>%s' % (namespace_, self.gds_format_string(quote_xml(self.path).encode(ExternalEncoding), input_name='path'), namespace_, eol_))
        if self.mount_options is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smount_options>%s</%smount_options>%s' % (namespace_, self.gds_format_string(quote_xml(self.mount_options).encode(ExternalEncoding), input_name='mount_options'), namespace_, eol_))
        if self.vfs_type is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svfs_type>%s</%svfs_type>%s' % (namespace_, self.gds_format_string(quote_xml(self.vfs_type).encode(ExternalEncoding), input_name='vfs_type'), namespace_, eol_))
        if self.nfs_version is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snfs_version>%s</%snfs_version>%s' % (namespace_, self.gds_format_string(quote_xml(self.nfs_version).encode(ExternalEncoding), input_name='nfs_version'), namespace_, eol_))
        if self.nfs_timeo is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snfs_timeo>%s</%snfs_timeo>%s' % (namespace_, self.gds_format_integer(self.nfs_timeo, input_name='nfs_timeo'), namespace_, eol_))
        if self.nfs_retrans is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snfs_retrans>%s</%snfs_retrans>%s' % (namespace_, self.gds_format_integer(self.nfs_retrans, input_name='nfs_retrans'), namespace_, eol_))
        if self.port is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sport>%s</%sport>%s' % (namespace_, self.gds_format_integer(self.port, input_name='port'), namespace_, eol_))
        if self.target is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%starget>%s</%starget>%s' % (namespace_, self.gds_format_string(quote_xml(self.target).encode(ExternalEncoding), input_name='target'), namespace_, eol_))
        if self.username is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%susername>%s</%susername>%s' % (namespace_, self.gds_format_string(quote_xml(self.username).encode(ExternalEncoding), input_name='username'), namespace_, eol_))
        if self.password is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespace_, self.gds_format_string(quote_xml(self.password).encode(ExternalEncoding), input_name='password'), namespace_, eol_))
        if self.portal is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sportal>%s</%sportal>%s' % (namespace_, self.gds_format_string(quote_xml(self.portal).encode(ExternalEncoding), input_name='portal'), namespace_, eol_))
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='StorageConnection'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(StorageConnection, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StorageConnection, self).exportLiteralChildren(outfile, level, name_)
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.path is not None:
            showIndent(outfile, level)
            outfile.write('path=%s,\n' % quote_python(self.path).encode(ExternalEncoding))
        if self.mount_options is not None:
            showIndent(outfile, level)
            outfile.write('mount_options=%s,\n' % quote_python(self.mount_options).encode(ExternalEncoding))
        if self.vfs_type is not None:
            showIndent(outfile, level)
            outfile.write('vfs_type=%s,\n' % quote_python(self.vfs_type).encode(ExternalEncoding))
        if self.nfs_version is not None:
            showIndent(outfile, level)
            outfile.write('nfs_version=%s,\n' % quote_python(self.nfs_version).encode(ExternalEncoding))
        if self.nfs_timeo is not None:
            showIndent(outfile, level)
            outfile.write('nfs_timeo=%d,\n' % self.nfs_timeo)
        if self.nfs_retrans is not None:
            showIndent(outfile, level)
            outfile.write('nfs_retrans=%d,\n' % self.nfs_retrans)
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('port=%d,\n' % self.port)
        if self.target is not None:
            showIndent(outfile, level)
            outfile.write('target=%s,\n' % quote_python(self.target).encode(ExternalEncoding))
        if self.username is not None:
            showIndent(outfile, level)
            outfile.write('username=%s,\n' % quote_python(self.username).encode(ExternalEncoding))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % quote_python(self.password).encode(ExternalEncoding))
        if self.portal is not None:
            showIndent(outfile, level)
            outfile.write('portal=%s,\n' % quote_python(self.portal).encode(ExternalEncoding))
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(StorageConnection, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'path':
            path_ = child_.text
            path_ = self.gds_validate_string(path_, node, 'path')
            self.path = path_
        elif nodeName_ == 'mount_options':
            mount_options_ = child_.text
            mount_options_ = self.gds_validate_string(mount_options_, node, 'mount_options')
            self.mount_options = mount_options_
        elif nodeName_ == 'vfs_type':
            vfs_type_ = child_.text
            vfs_type_ = self.gds_validate_string(vfs_type_, node, 'vfs_type')
            self.vfs_type = vfs_type_
        elif nodeName_ == 'nfs_version':
            nfs_version_ = child_.text
            nfs_version_ = self.gds_validate_string(nfs_version_, node, 'nfs_version')
            self.nfs_version = nfs_version_
        elif nodeName_ == 'nfs_timeo':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'nfs_timeo')
            self.nfs_timeo = ival_
        elif nodeName_ == 'nfs_retrans':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'nfs_retrans')
            self.nfs_retrans = ival_
        elif nodeName_ == 'port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'port')
            self.port = ival_
        elif nodeName_ == 'target':
            target_ = child_.text
            target_ = self.gds_validate_string(target_, node, 'target')
            self.target = target_
        elif nodeName_ == 'username':
            username_ = child_.text
            username_ = self.gds_validate_string(username_, node, 'username')
            self.username = username_
        elif nodeName_ == 'password':
            password_ = child_.text
            password_ = self.gds_validate_string(password_, node, 'password')
            self.password = password_
        elif nodeName_ == 'portal':
            portal_ = child_.text
            portal_ = self.gds_validate_string(portal_, node, 'portal')
            self.portal = portal_
        elif nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.set_host(obj_)
        super(StorageConnection, self).buildChildren(child_, node, nodeName_, True)
# end class StorageConnection


class StorageDomain(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, data_center=None, type_=None, status=None, master=None, storage=None, host=None, format=None, destroy=None, available=None, used=None, committed=None, storage_format=None):
        super(StorageDomain, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.data_center = data_center
        self.type_ = type_
        self.status = status
        self.master = master
        self.storage = storage
        self.host = host
        self.format = format
        self.destroy = destroy
        self.available = available
        self.used = used
        self.committed = committed
        self.storage_format = storage_format
    def factory(*args_, **kwargs_):
        if StorageDomain.subclass:
            return StorageDomain.subclass(*args_, **kwargs_)
        else:
            return StorageDomain(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_data_center(self): return self.data_center
    def set_data_center(self, data_center): self.data_center = data_center
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_master(self): return self.master
    def set_master(self, master): self.master = master
    def get_storage(self): return self.storage
    def set_storage(self, storage): self.storage = storage
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_destroy(self): return self.destroy
    def set_destroy(self, destroy): self.destroy = destroy
    def get_available(self): return self.available
    def set_available(self, available): self.available = available
    def get_used(self): return self.used
    def set_used(self, used): self.used = used
    def get_committed(self): return self.committed
    def set_committed(self, committed): self.committed = committed
    def get_storage_format(self): return self.storage_format
    def set_storage_format(self, storage_format): self.storage_format = storage_format
    def hasContent_(self):
        if (
            self.data_center is not None or
            self.type_ is not None or
            self.status is not None or
            self.master is not None or
            self.storage is not None or
            self.host is not None or
            self.format is not None or
            self.destroy is not None or
            self.available is not None or
            self.used is not None or
            self.committed is not None or
            self.storage_format is not None or
            super(StorageDomain, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StorageDomain', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageDomain')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageDomain'):
        super(StorageDomain, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StorageDomain')
    def exportChildren(self, outfile, level, namespace_='', name_='StorageDomain', fromsubclass_=False, pretty_print=True):
        super(StorageDomain, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.data_center is not None:
            self.data_center.export(outfile, level, namespace_, name_='data_center', pretty_print=pretty_print)
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status', pretty_print=pretty_print)
        if self.master is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smaster>%s</%smaster>%s' % (namespace_, self.gds_format_boolean(self.master, input_name='master'), namespace_, eol_))
        if self.storage is not None:
            self.storage.export(outfile, level, namespace_, name_='storage', pretty_print=pretty_print)
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host', pretty_print=pretty_print)
        if self.format is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sformat>%s</%sformat>%s' % (namespace_, self.gds_format_boolean(self.format, input_name='format'), namespace_, eol_))
        if self.destroy is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdestroy>%s</%sdestroy>%s' % (namespace_, self.gds_format_boolean(self.destroy, input_name='destroy'), namespace_, eol_))
        if self.available is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%savailable>%s</%savailable>%s' % (namespace_, self.gds_format_integer(self.available, input_name='available'), namespace_, eol_))
        if self.used is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sused>%s</%sused>%s' % (namespace_, self.gds_format_integer(self.used, input_name='used'), namespace_, eol_))
        if self.committed is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scommitted>%s</%scommitted>%s' % (namespace_, self.gds_format_integer(self.committed, input_name='committed'), namespace_, eol_))
        if self.storage_format is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstorage_format>%s</%sstorage_format>%s' % (namespace_, self.gds_format_string(quote_xml(self.storage_format).encode(ExternalEncoding), input_name='storage_format'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='StorageDomain'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(StorageDomain, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StorageDomain, self).exportLiteralChildren(outfile, level, name_)
        if self.data_center is not None:
            showIndent(outfile, level)
            outfile.write('data_center=model_.data_center(\n')
            self.data_center.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.master is not None:
            showIndent(outfile, level)
            outfile.write('master=%s,\n' % self.master)
        if self.storage is not None:
            showIndent(outfile, level)
            outfile.write('storage=model_.storage(\n')
            self.storage.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.format is not None:
            showIndent(outfile, level)
            outfile.write('format=%s,\n' % self.format)
        if self.destroy is not None:
            showIndent(outfile, level)
            outfile.write('destroy=%s,\n' % self.destroy)
        if self.available is not None:
            showIndent(outfile, level)
            outfile.write('available=%d,\n' % self.available)
        if self.used is not None:
            showIndent(outfile, level)
            outfile.write('used=%d,\n' % self.used)
        if self.committed is not None:
            showIndent(outfile, level)
            outfile.write('committed=%d,\n' % self.committed)
        if self.storage_format is not None:
            showIndent(outfile, level)
            outfile.write('storage_format=%s,\n' % quote_python(self.storage_format).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(StorageDomain, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'data_center':
            obj_ = DataCenter.factory()
            obj_.build(child_)
            self.set_data_center(obj_)
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.set_status(obj_)
        elif nodeName_ == 'master':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'master')
            self.master = ival_
        elif nodeName_ == 'storage':
            obj_ = Storage.factory()
            obj_.build(child_)
            self.set_storage(obj_)
        elif nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.set_host(obj_)
        elif nodeName_ == 'format':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'format')
            self.format = ival_
        elif nodeName_ == 'destroy':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'destroy')
            self.destroy = ival_
        elif nodeName_ == 'available':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'available')
            self.available = ival_
        elif nodeName_ == 'used':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'used')
            self.used = ival_
        elif nodeName_ == 'committed':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'committed')
            self.committed = ival_
        elif nodeName_ == 'storage_format':
            storage_format_ = child_.text
            storage_format_ = self.gds_validate_string(storage_format_, node, 'storage_format')
            self.storage_format = storage_format_
        super(StorageDomain, self).buildChildren(child_, node, nodeName_, True)
# end class StorageDomain


class StorageDomainStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, storage_domain_state=None):
        if storage_domain_state is None:
            self.storage_domain_state = []
        else:
            self.storage_domain_state = storage_domain_state
    def factory(*args_, **kwargs_):
        if StorageDomainStates.subclass:
            return StorageDomainStates.subclass(*args_, **kwargs_)
        else:
            return StorageDomainStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_storage_domain_state(self): return self.storage_domain_state
    def set_storage_domain_state(self, storage_domain_state): self.storage_domain_state = storage_domain_state
    def add_storage_domain_state(self, value): self.storage_domain_state.append(value)
    def insert_storage_domain_state(self, index, value): self.storage_domain_state[index] = value
    def hasContent_(self):
        if (
            self.storage_domain_state
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StorageDomainStates', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageDomainStates')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageDomainStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='StorageDomainStates', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for storage_domain_state_ in self.storage_domain_state:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstorage_domain_state>%s</%sstorage_domain_state>%s' % (namespace_, self.gds_format_string(quote_xml(storage_domain_state_).encode(ExternalEncoding), input_name='storage_domain_state'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='StorageDomainStates'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('storage_domain_state=[\n')
        level += 1
        for storage_domain_state_ in self.storage_domain_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(storage_domain_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'storage_domain_state':
            storage_domain_state_ = child_.text
            storage_domain_state_ = self.gds_validate_string(storage_domain_state_, node, 'storage_domain_state')
            self.storage_domain_state.append(storage_domain_state_)
# end class StorageDomainStates


class StorageDomains(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, storage_domain=None):
        super(StorageDomains, self).__init__(actions, total, active, )
        if storage_domain is None:
            self.storage_domain = []
        else:
            self.storage_domain = storage_domain
    def factory(*args_, **kwargs_):
        if StorageDomains.subclass:
            return StorageDomains.subclass(*args_, **kwargs_)
        else:
            return StorageDomains(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_storage_domain(self): return self.storage_domain
    def set_storage_domain(self, storage_domain): self.storage_domain = storage_domain
    def add_storage_domain(self, value): self.storage_domain.append(value)
    def insert_storage_domain(self, index, value): self.storage_domain[index] = value
    def hasContent_(self):
        if (
            self.storage_domain or
            super(StorageDomains, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StorageDomains', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageDomains')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageDomains'):
        super(StorageDomains, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StorageDomains')
    def exportChildren(self, outfile, level, namespace_='', name_='StorageDomains', fromsubclass_=False, pretty_print=True):
        super(StorageDomains, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for storage_domain_ in self.storage_domain:
            storage_domain_.export(outfile, level, namespace_, name_='storage_domain', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='StorageDomains'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(StorageDomains, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StorageDomains, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('storage_domain=[\n')
        level += 1
        for storage_domain_ in self.storage_domain:
            showIndent(outfile, level)
            outfile.write('model_.storage_domain(\n')
            storage_domain_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(StorageDomains, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'storage_domain':
            obj_ = StorageDomain.factory()
            obj_.build(child_)
            self.storage_domain.append(obj_)
        super(StorageDomains, self).buildChildren(child_, node, nodeName_, True)
# end class StorageDomains


class StorageConnections(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, storage_connection=None):
        super(StorageConnections, self).__init__(actions, total, active, )
        if storage_connection is None:
            self.storage_connection = []
        else:
            self.storage_connection = storage_connection
    def factory(*args_, **kwargs_):
        if StorageConnections.subclass:
            return StorageConnections.subclass(*args_, **kwargs_)
        else:
            return StorageConnections(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_storage_connection(self): return self.storage_connection
    def set_storage_connection(self, storage_connection): self.storage_connection = storage_connection
    def add_storage_connection(self, value): self.storage_connection.append(value)
    def insert_storage_connection(self, index, value): self.storage_connection[index] = value
    def hasContent_(self):
        if (
            self.storage_connection or
            super(StorageConnections, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StorageConnections', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageConnections')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageConnections'):
        super(StorageConnections, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StorageConnections')
    def exportChildren(self, outfile, level, namespace_='', name_='StorageConnections', fromsubclass_=False, pretty_print=True):
        super(StorageConnections, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for storage_connection_ in self.storage_connection:
            storage_connection_.export(outfile, level, namespace_, name_='storage_connection', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='StorageConnections'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(StorageConnections, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StorageConnections, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('storage_connection=[\n')
        level += 1
        for storage_connection_ in self.storage_connection:
            showIndent(outfile, level)
            outfile.write('model_.storage_connection(\n')
            storage_connection_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(StorageConnections, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'storage_connection':
            obj_ = StorageConnection.factory()
            obj_.build(child_)
            self.storage_connection.append(obj_)
        super(StorageConnections, self).buildChildren(child_, node, nodeName_, True)
# end class StorageConnections


class Template(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, vm=None, type_=None, status=None, memory=None, cpu=None, cpu_shares=None, os=None, cluster=None, storage_domain=None, creation_time=None, origin=None, high_availability=None, display=None, stateless=None, delete_protected=None, console=None, timezone=None, domain=None, usb=None, tunnel_migration=None, virtio_scsi=None, permissions=None):
        super(Template, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.vm = vm
        self.type_ = type_
        self.status = status
        self.memory = memory
        self.cpu = cpu
        self.cpu_shares = cpu_shares
        self.os = os
        self.cluster = cluster
        self.storage_domain = storage_domain
        self.creation_time = creation_time
        self.origin = origin
        self.high_availability = high_availability
        self.display = display
        self.stateless = stateless
        self.delete_protected = delete_protected
        self.console = console
        self.timezone = timezone
        self.domain = domain
        self.usb = usb
        self.tunnel_migration = tunnel_migration
        self.virtio_scsi = virtio_scsi
        self.permissions = permissions
    def factory(*args_, **kwargs_):
        if Template.subclass:
            return Template.subclass(*args_, **kwargs_)
        else:
            return Template(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vm(self): return self.vm
    def set_vm(self, vm): self.vm = vm
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_memory(self): return self.memory
    def set_memory(self, memory): self.memory = memory
    def get_cpu(self): return self.cpu
    def set_cpu(self, cpu): self.cpu = cpu
    def get_cpu_shares(self): return self.cpu_shares
    def set_cpu_shares(self, cpu_shares): self.cpu_shares = cpu_shares
    def get_os(self): return self.os
    def set_os(self, os): self.os = os
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def get_storage_domain(self): return self.storage_domain
    def set_storage_domain(self, storage_domain): self.storage_domain = storage_domain
    def get_creation_time(self): return self.creation_time
    def set_creation_time(self, creation_time): self.creation_time = creation_time
    def get_origin(self): return self.origin
    def set_origin(self, origin): self.origin = origin
    def get_high_availability(self): return self.high_availability
    def set_high_availability(self, high_availability): self.high_availability = high_availability
    def get_display(self): return self.display
    def set_display(self, display): self.display = display
    def get_stateless(self): return self.stateless
    def set_stateless(self, stateless): self.stateless = stateless
    def get_delete_protected(self): return self.delete_protected
    def set_delete_protected(self, delete_protected): self.delete_protected = delete_protected
    def get_console(self): return self.console
    def set_console(self, console): self.console = console
    def get_timezone(self): return self.timezone
    def set_timezone(self, timezone): self.timezone = timezone
    def get_domain(self): return self.domain
    def set_domain(self, domain): self.domain = domain
    def get_usb(self): return self.usb
    def set_usb(self, usb): self.usb = usb
    def get_tunnel_migration(self): return self.tunnel_migration
    def set_tunnel_migration(self, tunnel_migration): self.tunnel_migration = tunnel_migration
    def get_virtio_scsi(self): return self.virtio_scsi
    def set_virtio_scsi(self, virtio_scsi): self.virtio_scsi = virtio_scsi
    def get_permissions(self): return self.permissions
    def set_permissions(self, permissions): self.permissions = permissions
    def hasContent_(self):
        if (
            self.vm is not None or
            self.type_ is not None or
            self.status is not None or
            self.memory is not None or
            self.cpu is not None or
            self.cpu_shares is not None or
            self.os is not None or
            self.cluster is not None or
            self.storage_domain is not None or
            self.creation_time is not None or
            self.origin is not None or
            self.high_availability is not None or
            self.display is not None or
            self.stateless is not None or
            self.delete_protected is not None or
            self.console is not None or
            self.timezone is not None or
            self.domain is not None or
            self.usb is not None or
            self.tunnel_migration is not None or
            self.virtio_scsi is not None or
            self.permissions is not None or
            super(Template, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Template', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Template')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Template'):
        super(Template, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Template')
    def exportChildren(self, outfile, level, namespace_='', name_='Template', fromsubclass_=False, pretty_print=True):
        super(Template, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.vm is not None:
            self.vm.export(outfile, level, namespace_, name_='vm', pretty_print=pretty_print)
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status', pretty_print=pretty_print)
        if self.memory is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smemory>%s</%smemory>%s' % (namespace_, self.gds_format_integer(self.memory, input_name='memory'), namespace_, eol_))
        if self.cpu is not None:
            self.cpu.export(outfile, level, namespace_, name_='cpu', pretty_print=pretty_print)
        if self.cpu_shares is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scpu_shares>%s</%scpu_shares>%s' % (namespace_, self.gds_format_integer(self.cpu_shares, input_name='cpu_shares'), namespace_, eol_))
        if self.os is not None:
            self.os.export(outfile, level, namespace_, name_='os', pretty_print=pretty_print)
        if self.cluster is not None:
            self.cluster.export(outfile, level, namespace_, name_='cluster', pretty_print=pretty_print)
        if self.storage_domain is not None:
            self.storage_domain.export(outfile, level, namespace_, name_='storage_domain', pretty_print=pretty_print)
        if self.creation_time is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%screation_time>%s</%screation_time>%s' % (namespace_, self.gds_format_datetime(self.creation_time, input_name='creation_time'), namespace_, eol_))
        if self.origin is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorigin>%s</%sorigin>%s' % (namespace_, self.gds_format_string(quote_xml(self.origin).encode(ExternalEncoding), input_name='origin'), namespace_, eol_))
        if self.high_availability is not None:
            self.high_availability.export(outfile, level, namespace_, name_='high_availability', pretty_print=pretty_print)
        if self.display is not None:
            self.display.export(outfile, level, namespace_, name_='display', pretty_print=pretty_print)
        if self.stateless is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstateless>%s</%sstateless>%s' % (namespace_, self.gds_format_boolean(self.stateless, input_name='stateless'), namespace_, eol_))
        if self.delete_protected is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdelete_protected>%s</%sdelete_protected>%s' % (namespace_, self.gds_format_boolean(self.delete_protected, input_name='delete_protected'), namespace_, eol_))
        if self.console is not None:
            self.console.export(outfile, level, namespace_, name_='console', pretty_print=pretty_print)
        if self.timezone is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stimezone>%s</%stimezone>%s' % (namespace_, self.gds_format_string(quote_xml(self.timezone).encode(ExternalEncoding), input_name='timezone'), namespace_, eol_))
        if self.domain is not None:
            self.domain.export(outfile, level, namespace_, name_='domain', pretty_print=pretty_print)
        if self.usb is not None:
            self.usb.export(outfile, level, namespace_, name_='usb', pretty_print=pretty_print)
        if self.tunnel_migration is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stunnel_migration>%s</%stunnel_migration>%s' % (namespace_, self.gds_format_boolean(self.tunnel_migration, input_name='tunnel_migration'), namespace_, eol_))
        if self.virtio_scsi is not None:
            self.virtio_scsi.export(outfile, level, namespace_, name_='virtio_scsi', pretty_print=pretty_print)
        if self.permissions is not None:
            self.permissions.export(outfile, level, namespace_, name_='permissions', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Template'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Template, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Template, self).exportLiteralChildren(outfile, level, name_)
        if self.vm is not None:
            showIndent(outfile, level)
            outfile.write('vm=model_.vm(\n')
            self.vm.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.memory is not None:
            showIndent(outfile, level)
            outfile.write('memory=%d,\n' % self.memory)
        if self.cpu is not None:
            showIndent(outfile, level)
            outfile.write('cpu=model_.CPU(\n')
            self.cpu.exportLiteral(outfile, level, name_='cpu')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cpu_shares is not None:
            showIndent(outfile, level)
            outfile.write('cpu_shares=%d,\n' % self.cpu_shares)
        if self.os is not None:
            showIndent(outfile, level)
            outfile.write('os=model_.OperatingSystem(\n')
            self.os.exportLiteral(outfile, level, name_='os')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cluster is not None:
            showIndent(outfile, level)
            outfile.write('cluster=model_.cluster(\n')
            self.cluster.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.storage_domain is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain=model_.storage_domain(\n')
            self.storage_domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.creation_time is not None:
            showIndent(outfile, level)
            outfile.write('creation_time=datetime_.strptime("%s", "%%Y-%%m-%%dT%%H:%%M:%%S"),\n' % self.gds_format_datetime(self.creation_time, input_name='creation_time'))
        if self.origin is not None:
            showIndent(outfile, level)
            outfile.write('origin=%s,\n' % quote_python(self.origin).encode(ExternalEncoding))
        if self.high_availability is not None:
            showIndent(outfile, level)
            outfile.write('high_availability=model_.HighAvailability(\n')
            self.high_availability.exportLiteral(outfile, level, name_='high_availability')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.display is not None:
            showIndent(outfile, level)
            outfile.write('display=model_.Display(\n')
            self.display.exportLiteral(outfile, level, name_='display')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.stateless is not None:
            showIndent(outfile, level)
            outfile.write('stateless=%s,\n' % self.stateless)
        if self.delete_protected is not None:
            showIndent(outfile, level)
            outfile.write('delete_protected=%s,\n' % self.delete_protected)
        if self.console is not None:
            showIndent(outfile, level)
            outfile.write('console=model_.console(\n')
            self.console.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.timezone is not None:
            showIndent(outfile, level)
            outfile.write('timezone=%s,\n' % quote_python(self.timezone).encode(ExternalEncoding))
        if self.domain is not None:
            showIndent(outfile, level)
            outfile.write('domain=model_.domain(\n')
            self.domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.usb is not None:
            showIndent(outfile, level)
            outfile.write('usb=model_.usb(\n')
            self.usb.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.tunnel_migration is not None:
            showIndent(outfile, level)
            outfile.write('tunnel_migration=%s,\n' % self.tunnel_migration)
        if self.virtio_scsi is not None:
            showIndent(outfile, level)
            outfile.write('virtio_scsi=model_.virtio_scsi(\n')
            self.virtio_scsi.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.permissions is not None:
            showIndent(outfile, level)
            outfile.write('permissions=model_.permissions(\n')
            self.permissions.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Template, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vm':
            class_obj_ = self.get_class_obj_(child_, VM)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_vm(obj_)
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.set_status(obj_)
        elif nodeName_ == 'memory':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'memory')
            self.memory = ival_
        elif nodeName_ == 'cpu':
            obj_ = CPU.factory()
            obj_.build(child_)
            self.set_cpu(obj_)
        elif nodeName_ == 'cpu_shares':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'cpu_shares')
            self.cpu_shares = ival_
        elif nodeName_ == 'os':
            obj_ = OperatingSystem.factory()
            obj_.build(child_)
            self.set_os(obj_)
        elif nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.set_cluster(obj_)
        elif nodeName_ == 'storage_domain':
            obj_ = StorageDomain.factory()
            obj_.build(child_)
            self.set_storage_domain(obj_)
        elif nodeName_ == 'creation_time':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_, node, 'creation_time')
            self.creation_time = dval_
        elif nodeName_ == 'origin':
            origin_ = child_.text
            origin_ = self.gds_validate_string(origin_, node, 'origin')
            self.origin = origin_
        elif nodeName_ == 'high_availability':
            obj_ = HighAvailability.factory()
            obj_.build(child_)
            self.set_high_availability(obj_)
        elif nodeName_ == 'display':
            obj_ = Display.factory()
            obj_.build(child_)
            self.set_display(obj_)
        elif nodeName_ == 'stateless':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'stateless')
            self.stateless = ival_
        elif nodeName_ == 'delete_protected':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'delete_protected')
            self.delete_protected = ival_
        elif nodeName_ == 'console':
            obj_ = Console.factory()
            obj_.build(child_)
            self.set_console(obj_)
        elif nodeName_ == 'timezone':
            timezone_ = child_.text
            timezone_ = self.gds_validate_string(timezone_, node, 'timezone')
            self.timezone = timezone_
        elif nodeName_ == 'domain':
            obj_ = Domain.factory()
            obj_.build(child_)
            self.set_domain(obj_)
        elif nodeName_ == 'usb':
            obj_ = Usb.factory()
            obj_.build(child_)
            self.set_usb(obj_)
        elif nodeName_ == 'tunnel_migration':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'tunnel_migration')
            self.tunnel_migration = ival_
        elif nodeName_ == 'virtio_scsi':
            obj_ = VirtIO_SCSI.factory()
            obj_.build(child_)
            self.set_virtio_scsi(obj_)
        elif nodeName_ == 'permissions':
            obj_ = Permissions.factory()
            obj_.build(child_)
            self.set_permissions(obj_)
        super(Template, self).buildChildren(child_, node, nodeName_, True)
# end class Template


class Templates(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, template=None):
        super(Templates, self).__init__(actions, total, active, )
        if template is None:
            self.template = []
        else:
            self.template = template
    def factory(*args_, **kwargs_):
        if Templates.subclass:
            return Templates.subclass(*args_, **kwargs_)
        else:
            return Templates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_template(self): return self.template
    def set_template(self, template): self.template = template
    def add_template(self, value): self.template.append(value)
    def insert_template(self, index, value): self.template[index] = value
    def hasContent_(self):
        if (
            self.template or
            super(Templates, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Templates', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Templates')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Templates'):
        super(Templates, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Templates')
    def exportChildren(self, outfile, level, namespace_='', name_='Templates', fromsubclass_=False, pretty_print=True):
        super(Templates, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for template_ in self.template:
            template_.export(outfile, level, namespace_, name_='template', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Templates'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Templates, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Templates, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('template=[\n')
        level += 1
        for template_ in self.template:
            showIndent(outfile, level)
            outfile.write('model_.template(\n')
            template_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Templates, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'template':
            obj_ = Template.factory()
            obj_.build(child_)
            self.template.append(obj_)
        super(Templates, self).buildChildren(child_, node, nodeName_, True)
# end class Templates


class TemplateStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, template_state=None):
        if template_state is None:
            self.template_state = []
        else:
            self.template_state = template_state
    def factory(*args_, **kwargs_):
        if TemplateStates.subclass:
            return TemplateStates.subclass(*args_, **kwargs_)
        else:
            return TemplateStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_template_state(self): return self.template_state
    def set_template_state(self, template_state): self.template_state = template_state
    def add_template_state(self, value): self.template_state.append(value)
    def insert_template_state(self, index, value): self.template_state[index] = value
    def hasContent_(self):
        if (
            self.template_state
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TemplateStates', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TemplateStates')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TemplateStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='TemplateStates', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for template_state_ in self.template_state:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stemplate_state>%s</%stemplate_state>%s' % (namespace_, self.gds_format_string(quote_xml(template_state_).encode(ExternalEncoding), input_name='template_state'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='TemplateStates'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('template_state=[\n')
        level += 1
        for template_state_ in self.template_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(template_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'template_state':
            template_state_ = child_.text
            template_state_ = self.gds_validate_string(template_state_, node, 'template_state')
            self.template_state.append(template_state_)
# end class TemplateStates


class Boot(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, dev=None):
        self.dev = _cast(None, dev)
        pass
    def factory(*args_, **kwargs_):
        if Boot.subclass:
            return Boot.subclass(*args_, **kwargs_)
        else:
            return Boot(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_dev(self): return self.dev
    def set_dev(self, dev): self.dev = dev
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Boot', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Boot')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Boot'):
        if self.dev is not None and 'dev' not in already_processed:
            already_processed.add('dev')
            outfile.write(' dev=%s' % (self.gds_format_string(quote_attrib(self.dev).encode(ExternalEncoding), input_name='dev'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Boot', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='Boot'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.dev is not None and 'dev' not in already_processed:
            already_processed.add('dev')
            showIndent(outfile, level)
            outfile.write('dev = "%s",\n' % (self.dev,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('dev', node)
        if value is not None and 'dev' not in already_processed:
            already_processed.add('dev')
            self.dev = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Boot


class OperatingSystem(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, boot=None, kernel=None, initrd=None, cmdline=None, version=None):
        self.type_ = _cast(None, type_)
        if boot is None:
            self.boot = []
        else:
            self.boot = boot
        self.kernel = kernel
        self.initrd = initrd
        self.cmdline = cmdline
        self.version = version
    def factory(*args_, **kwargs_):
        if OperatingSystem.subclass:
            return OperatingSystem.subclass(*args_, **kwargs_)
        else:
            return OperatingSystem(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_boot(self): return self.boot
    def set_boot(self, boot): self.boot = boot
    def add_boot(self, value): self.boot.append(value)
    def insert_boot(self, index, value): self.boot[index] = value
    def get_kernel(self): return self.kernel
    def set_kernel(self, kernel): self.kernel = kernel
    def get_initrd(self): return self.initrd
    def set_initrd(self, initrd): self.initrd = initrd
    def get_cmdline(self): return self.cmdline
    def set_cmdline(self, cmdline): self.cmdline = cmdline
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def hasContent_(self):
        if (
            self.boot or
            self.kernel is not None or
            self.initrd is not None or
            self.cmdline is not None or
            self.version is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='OperatingSystem', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OperatingSystem')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OperatingSystem'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='OperatingSystem', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for boot_ in self.boot:
            boot_.export(outfile, level, namespace_, name_='boot', pretty_print=pretty_print)
        if self.kernel is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skernel>%s</%skernel>%s' % (namespace_, self.gds_format_string(quote_xml(self.kernel).encode(ExternalEncoding), input_name='kernel'), namespace_, eol_))
        if self.initrd is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinitrd>%s</%sinitrd>%s' % (namespace_, self.gds_format_string(quote_xml(self.initrd).encode(ExternalEncoding), input_name='initrd'), namespace_, eol_))
        if self.cmdline is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scmdline>%s</%scmdline>%s' % (namespace_, self.gds_format_string(quote_xml(self.cmdline).encode(ExternalEncoding), input_name='cmdline'), namespace_, eol_))
        if self.version is not None:
            self.version.export(outfile, level, namespace_, name_='version', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='OperatingSystem'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('boot=[\n')
        level += 1
        for boot_ in self.boot:
            showIndent(outfile, level)
            outfile.write('model_.Boot(\n')
            boot_.exportLiteral(outfile, level, name_='Boot')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.kernel is not None:
            showIndent(outfile, level)
            outfile.write('kernel=%s,\n' % quote_python(self.kernel).encode(ExternalEncoding))
        if self.initrd is not None:
            showIndent(outfile, level)
            outfile.write('initrd=%s,\n' % quote_python(self.initrd).encode(ExternalEncoding))
        if self.cmdline is not None:
            showIndent(outfile, level)
            outfile.write('cmdline=%s,\n' % quote_python(self.cmdline).encode(ExternalEncoding))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=model_.Version(\n')
            self.version.exportLiteral(outfile, level, name_='version')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'boot':
            obj_ = Boot.factory()
            obj_.build(child_)
            self.boot.append(obj_)
        elif nodeName_ == 'kernel':
            kernel_ = child_.text
            kernel_ = self.gds_validate_string(kernel_, node, 'kernel')
            self.kernel = kernel_
        elif nodeName_ == 'initrd':
            initrd_ = child_.text
            initrd_ = self.gds_validate_string(initrd_, node, 'initrd')
            self.initrd = initrd_
        elif nodeName_ == 'cmdline':
            cmdline_ = child_.text
            cmdline_ = self.gds_validate_string(cmdline_, node, 'cmdline')
            self.cmdline = cmdline_
        elif nodeName_ == 'version':
            class_obj_ = self.get_class_obj_(child_, Version)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_version(obj_)
# end class OperatingSystem


class HighAvailability(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, enabled=None, priority=None):
        self.enabled = enabled
        self.priority = priority
    def factory(*args_, **kwargs_):
        if HighAvailability.subclass:
            return HighAvailability.subclass(*args_, **kwargs_)
        else:
            return HighAvailability(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_enabled(self): return self.enabled
    def set_enabled(self, enabled): self.enabled = enabled
    def get_priority(self): return self.priority
    def set_priority(self, priority): self.priority = priority
    def hasContent_(self):
        if (
            self.enabled is not None or
            self.priority is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='HighAvailability', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HighAvailability')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HighAvailability'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='HighAvailability', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.enabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%senabled>%s</%senabled>%s' % (namespace_, self.gds_format_boolean(self.enabled, input_name='enabled'), namespace_, eol_))
        if self.priority is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spriority>%s</%spriority>%s' % (namespace_, self.gds_format_integer(self.priority, input_name='priority'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='HighAvailability'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.enabled is not None:
            showIndent(outfile, level)
            outfile.write('enabled=%s,\n' % self.enabled)
        if self.priority is not None:
            showIndent(outfile, level)
            outfile.write('priority=%d,\n' % self.priority)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'enabled')
            self.enabled = ival_
        elif nodeName_ == 'priority':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'priority')
            self.priority = ival_
# end class HighAvailability


class Display(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, address=None, port=None, secure_port=None, monitors=None, single_qxl_pci=None, allow_override=None, certificate=None, smartcard_enabled=None, keyboard_layout=None):
        self.type_ = type_
        self.address = address
        self.port = port
        self.secure_port = secure_port
        self.monitors = monitors
        self.single_qxl_pci = single_qxl_pci
        self.allow_override = allow_override
        self.certificate = certificate
        self.smartcard_enabled = smartcard_enabled
        self.keyboard_layout = keyboard_layout
    def factory(*args_, **kwargs_):
        if Display.subclass:
            return Display.subclass(*args_, **kwargs_)
        else:
            return Display(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_port(self): return self.port
    def set_port(self, port): self.port = port
    def get_secure_port(self): return self.secure_port
    def set_secure_port(self, secure_port): self.secure_port = secure_port
    def get_monitors(self): return self.monitors
    def set_monitors(self, monitors): self.monitors = monitors
    def get_single_qxl_pci(self): return self.single_qxl_pci
    def set_single_qxl_pci(self, single_qxl_pci): self.single_qxl_pci = single_qxl_pci
    def get_allow_override(self): return self.allow_override
    def set_allow_override(self, allow_override): self.allow_override = allow_override
    def get_certificate(self): return self.certificate
    def set_certificate(self, certificate): self.certificate = certificate
    def get_smartcard_enabled(self): return self.smartcard_enabled
    def set_smartcard_enabled(self, smartcard_enabled): self.smartcard_enabled = smartcard_enabled
    def get_keyboard_layout(self): return self.keyboard_layout
    def set_keyboard_layout(self, keyboard_layout): self.keyboard_layout = keyboard_layout
    def hasContent_(self):
        if (
            self.type_ is not None or
            self.address is not None or
            self.port is not None or
            self.secure_port is not None or
            self.monitors is not None or
            self.single_qxl_pci is not None or
            self.allow_override is not None or
            self.certificate is not None or
            self.smartcard_enabled is not None or
            self.keyboard_layout is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Display', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Display')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Display'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Display', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.address is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress>%s</%saddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_, eol_))
        if self.port is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sport>%s</%sport>%s' % (namespace_, self.gds_format_integer(self.port, input_name='port'), namespace_, eol_))
        if self.secure_port is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssecure_port>%s</%ssecure_port>%s' % (namespace_, self.gds_format_integer(self.secure_port, input_name='secure_port'), namespace_, eol_))
        if self.monitors is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smonitors>%s</%smonitors>%s' % (namespace_, self.gds_format_integer(self.monitors, input_name='monitors'), namespace_, eol_))
        if self.single_qxl_pci is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssingle_qxl_pci>%s</%ssingle_qxl_pci>%s' % (namespace_, self.gds_format_boolean(self.single_qxl_pci, input_name='single_qxl_pci'), namespace_, eol_))
        if self.allow_override is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sallow_override>%s</%sallow_override>%s' % (namespace_, self.gds_format_boolean(self.allow_override, input_name='allow_override'), namespace_, eol_))
        if self.certificate is not None:
            self.certificate.export(outfile, level, namespace_, name_='certificate', pretty_print=pretty_print)
        if self.smartcard_enabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssmartcard_enabled>%s</%ssmartcard_enabled>%s' % (namespace_, self.gds_format_boolean(self.smartcard_enabled, input_name='smartcard_enabled'), namespace_, eol_))
        if self.keyboard_layout is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skeyboard_layout>%s</%skeyboard_layout>%s' % (namespace_, self.gds_format_string(quote_xml(self.keyboard_layout).encode(ExternalEncoding), input_name='keyboard_layout'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Display'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('port=%d,\n' % self.port)
        if self.secure_port is not None:
            showIndent(outfile, level)
            outfile.write('secure_port=%d,\n' % self.secure_port)
        if self.monitors is not None:
            showIndent(outfile, level)
            outfile.write('monitors=%d,\n' % self.monitors)
        if self.single_qxl_pci is not None:
            showIndent(outfile, level)
            outfile.write('single_qxl_pci=%s,\n' % self.single_qxl_pci)
        if self.allow_override is not None:
            showIndent(outfile, level)
            outfile.write('allow_override=%s,\n' % self.allow_override)
        if self.certificate is not None:
            showIndent(outfile, level)
            outfile.write('certificate=model_.certificate(\n')
            self.certificate.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.smartcard_enabled is not None:
            showIndent(outfile, level)
            outfile.write('smartcard_enabled=%s,\n' % self.smartcard_enabled)
        if self.keyboard_layout is not None:
            showIndent(outfile, level)
            outfile.write('keyboard_layout=%s,\n' % quote_python(self.keyboard_layout).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'port')
            self.port = ival_
        elif nodeName_ == 'secure_port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'secure_port')
            self.secure_port = ival_
        elif nodeName_ == 'monitors':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'monitors')
            self.monitors = ival_
        elif nodeName_ == 'single_qxl_pci':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'single_qxl_pci')
            self.single_qxl_pci = ival_
        elif nodeName_ == 'allow_override':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'allow_override')
            self.allow_override = ival_
        elif nodeName_ == 'certificate':
            obj_ = Certificate.factory()
            obj_.build(child_)
            self.set_certificate(obj_)
        elif nodeName_ == 'smartcard_enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'smartcard_enabled')
            self.smartcard_enabled = ival_
        elif nodeName_ == 'keyboard_layout':
            keyboard_layout_ = child_.text
            keyboard_layout_ = self.gds_validate_string(keyboard_layout_, node, 'keyboard_layout')
            self.keyboard_layout = keyboard_layout_
# end class Display


class Ticket(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, value=None, expiry=None):
        self.value = value
        self.expiry = expiry
    def factory(*args_, **kwargs_):
        if Ticket.subclass:
            return Ticket.subclass(*args_, **kwargs_)
        else:
            return Ticket(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def get_expiry(self): return self.expiry
    def set_expiry(self, expiry): self.expiry = expiry
    def hasContent_(self):
        if (
            self.value is not None or
            self.expiry is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Ticket', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Ticket')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Ticket'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Ticket', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(self.value).encode(ExternalEncoding), input_name='value'), namespace_, eol_))
        if self.expiry is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sexpiry>%s</%sexpiry>%s' % (namespace_, self.gds_format_integer(self.expiry, input_name='expiry'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Ticket'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value).encode(ExternalEncoding))
        if self.expiry is not None:
            showIndent(outfile, level)
            outfile.write('expiry=%d,\n' % self.expiry)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
        elif nodeName_ == 'expiry':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'expiry')
            self.expiry = ival_
# end class Ticket


class CustomProperty(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, regexp=None, name=None, value=None):
        self.regexp = _cast(None, regexp)
        self.name = _cast(None, name)
        self.value = _cast(None, value)
        pass
    def factory(*args_, **kwargs_):
        if CustomProperty.subclass:
            return CustomProperty.subclass(*args_, **kwargs_)
        else:
            return CustomProperty(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_regexp(self): return self.regexp
    def set_regexp(self, regexp): self.regexp = regexp
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CustomProperty', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CustomProperty')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CustomProperty'):
        if self.regexp is not None and 'regexp' not in already_processed:
            already_processed.add('regexp')
            outfile.write(' regexp=%s' % (self.gds_format_string(quote_attrib(self.regexp).encode(ExternalEncoding), input_name='regexp'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (self.gds_format_string(quote_attrib(self.value).encode(ExternalEncoding), input_name='value'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='CustomProperty', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='CustomProperty'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.regexp is not None and 'regexp' not in already_processed:
            already_processed.add('regexp')
            showIndent(outfile, level)
            outfile.write('regexp = "%s",\n' % (self.regexp,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            showIndent(outfile, level)
            outfile.write('value = "%s",\n' % (self.value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('regexp', node)
        if value is not None and 'regexp' not in already_processed:
            already_processed.add('regexp')
            self.regexp = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class CustomProperty


class CustomProperties(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, custom_property=None):
        if custom_property is None:
            self.custom_property = []
        else:
            self.custom_property = custom_property
    def factory(*args_, **kwargs_):
        if CustomProperties.subclass:
            return CustomProperties.subclass(*args_, **kwargs_)
        else:
            return CustomProperties(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_custom_property(self): return self.custom_property
    def set_custom_property(self, custom_property): self.custom_property = custom_property
    def add_custom_property(self, value): self.custom_property.append(value)
    def insert_custom_property(self, index, value): self.custom_property[index] = value
    def hasContent_(self):
        if (
            self.custom_property
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CustomProperties', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CustomProperties')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CustomProperties'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='CustomProperties', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for custom_property_ in self.custom_property:
            custom_property_.export(outfile, level, namespace_, name_='custom_property', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='CustomProperties'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('custom_property=[\n')
        level += 1
        for custom_property_ in self.custom_property:
            showIndent(outfile, level)
            outfile.write('model_.CustomProperty(\n')
            custom_property_.exportLiteral(outfile, level, name_='CustomProperty')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'custom_property':
            obj_ = CustomProperty.factory()
            obj_.build(child_)
            self.custom_property.append(obj_)
# end class CustomProperties


class Payloads(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, payload=None):
        if payload is None:
            self.payload = []
        else:
            self.payload = payload
    def factory(*args_, **kwargs_):
        if Payloads.subclass:
            return Payloads.subclass(*args_, **kwargs_)
        else:
            return Payloads(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_payload(self): return self.payload
    def set_payload(self, payload): self.payload = payload
    def add_payload(self, value): self.payload.append(value)
    def insert_payload(self, index, value): self.payload[index] = value
    def hasContent_(self):
        if (
            self.payload
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Payloads', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Payloads')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Payloads'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Payloads', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for payload_ in self.payload:
            payload_.export(outfile, level, namespace_, name_='payload', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Payloads'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('payload=[\n')
        level += 1
        for payload_ in self.payload:
            showIndent(outfile, level)
            outfile.write('model_.Payload(\n')
            payload_.exportLiteral(outfile, level, name_='Payload')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'payload':
            obj_ = Payload.factory()
            obj_.build(child_)
            self.payload.append(obj_)
# end class Payloads


class Payload(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, files=None, volume_id=None):
        self.type_ = _cast(None, type_)
        self.files = files
        self.volume_id = volume_id
    def factory(*args_, **kwargs_):
        if Payload.subclass:
            return Payload.subclass(*args_, **kwargs_)
        else:
            return Payload(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_files(self): return self.files
    def set_files(self, files): self.files = files
    def get_volume_id(self): return self.volume_id
    def set_volume_id(self, volume_id): self.volume_id = volume_id
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def hasContent_(self):
        if (
            self.files is not None or
            self.volume_id is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Payload', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Payload')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Payload'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Payload', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.files is not None:
            self.files.export(outfile, level, namespace_, name_='files', pretty_print=pretty_print)
        if self.volume_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svolume_id>%s</%svolume_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.volume_id).encode(ExternalEncoding), input_name='volume_id'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Payload'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.files is not None:
            showIndent(outfile, level)
            outfile.write('files=model_.files(\n')
            self.files.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.volume_id is not None:
            showIndent(outfile, level)
            outfile.write('volume_id=%s,\n' % quote_python(self.volume_id).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'files':
            obj_ = Files.factory()
            obj_.build(child_)
            self.set_files(obj_)
        elif nodeName_ == 'volume_id':
            volume_id_ = child_.text
            volume_id_ = self.gds_validate_string(volume_id_, node, 'volume_id')
            self.volume_id = volume_id_
# end class Payload


class VmDeviceTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vm_device_types=None):
        if vm_device_types is None:
            self.vm_device_types = []
        else:
            self.vm_device_types = vm_device_types
    def factory(*args_, **kwargs_):
        if VmDeviceTypes.subclass:
            return VmDeviceTypes.subclass(*args_, **kwargs_)
        else:
            return VmDeviceTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vm_device_types(self): return self.vm_device_types
    def set_vm_device_types(self, vm_device_types): self.vm_device_types = vm_device_types
    def add_vm_device_types(self, value): self.vm_device_types.append(value)
    def insert_vm_device_types(self, index, value): self.vm_device_types[index] = value
    def hasContent_(self):
        if (
            self.vm_device_types
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VmDeviceTypes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmDeviceTypes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmDeviceTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VmDeviceTypes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for vm_device_types_ in self.vm_device_types:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svm_device_types>%s</%svm_device_types>%s' % (namespace_, self.gds_format_string(quote_xml(vm_device_types_).encode(ExternalEncoding), input_name='vm_device_types'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='VmDeviceTypes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('vm_device_types=[\n')
        level += 1
        for vm_device_types_ in self.vm_device_types:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(vm_device_types_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vm_device_types':
            vm_device_types_ = child_.text
            vm_device_types_ = self.gds_validate_string(vm_device_types_, node, 'vm_device_types')
            self.vm_device_types.append(vm_device_types_)
# end class VmDeviceTypes


class Configuration(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, data=None):
        self.type_ = type_
        self.data = data
    def factory(*args_, **kwargs_):
        if Configuration.subclass:
            return Configuration.subclass(*args_, **kwargs_)
        else:
            return Configuration(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_data(self): return self.data
    def set_data(self, data): self.data = data
    def hasContent_(self):
        if (
            self.type_ is not None or
            self.data is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Configuration', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Configuration')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Configuration'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Configuration', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.data is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdata>%s</%sdata>%s' % (namespace_, self.gds_format_string(quote_xml(self.data).encode(ExternalEncoding), input_name='data'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Configuration'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.data is not None:
            showIndent(outfile, level)
            outfile.write('data=%s,\n' % quote_python(self.data).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'data':
            data_ = child_.text
            data_ = self.gds_validate_string(data_, node, 'data')
            self.data = data_
# end class Configuration


class Initialization(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, configuration=None):
        self.configuration = configuration
    def factory(*args_, **kwargs_):
        if Initialization.subclass:
            return Initialization.subclass(*args_, **kwargs_)
        else:
            return Initialization(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_configuration(self): return self.configuration
    def set_configuration(self, configuration): self.configuration = configuration
    def hasContent_(self):
        if (
            self.configuration is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Initialization', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Initialization')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Initialization'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Initialization', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.configuration is not None:
            self.configuration.export(outfile, level, namespace_, name_='configuration', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Initialization'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.configuration is not None:
            showIndent(outfile, level)
            outfile.write('configuration=model_.Configuration(\n')
            self.configuration.exportLiteral(outfile, level, name_='configuration')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'configuration':
            obj_ = Configuration.factory()
            obj_.build(child_)
            self.set_configuration(obj_)
# end class Initialization


class VmPlacementPolicy(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, host=None, affinity=None):
        self.host = host
        self.affinity = affinity
    def factory(*args_, **kwargs_):
        if VmPlacementPolicy.subclass:
            return VmPlacementPolicy.subclass(*args_, **kwargs_)
        else:
            return VmPlacementPolicy(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def get_affinity(self): return self.affinity
    def set_affinity(self, affinity): self.affinity = affinity
    def hasContent_(self):
        if (
            self.host is not None or
            self.affinity is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VmPlacementPolicy', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmPlacementPolicy')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmPlacementPolicy'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VmPlacementPolicy', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host', pretty_print=pretty_print)
        if self.affinity is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saffinity>%s</%saffinity>%s' % (namespace_, self.gds_format_string(quote_xml(self.affinity).encode(ExternalEncoding), input_name='affinity'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='VmPlacementPolicy'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.Host(\n')
            self.host.exportLiteral(outfile, level, name_='host')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.affinity is not None:
            showIndent(outfile, level)
            outfile.write('affinity=%s,\n' % quote_python(self.affinity).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.set_host(obj_)
        elif nodeName_ == 'affinity':
            affinity_ = child_.text
            affinity_ = self.gds_validate_string(affinity_, node, 'affinity')
            self.affinity = affinity_
# end class VmPlacementPolicy


class GuestInfo(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ips=None, fqdn=None):
        self.ips = ips
        self.fqdn = fqdn
    def factory(*args_, **kwargs_):
        if GuestInfo.subclass:
            return GuestInfo.subclass(*args_, **kwargs_)
        else:
            return GuestInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ips(self): return self.ips
    def set_ips(self, ips): self.ips = ips
    def get_fqdn(self): return self.fqdn
    def set_fqdn(self, fqdn): self.fqdn = fqdn
    def hasContent_(self):
        if (
            self.ips is not None or
            self.fqdn is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GuestInfo', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GuestInfo')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GuestInfo'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='GuestInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ips is not None:
            self.ips.export(outfile, level, namespace_, name_='ips', pretty_print=pretty_print)
        if self.fqdn is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfqdn>%s</%sfqdn>%s' % (namespace_, self.gds_format_string(quote_xml(self.fqdn).encode(ExternalEncoding), input_name='fqdn'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='GuestInfo'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.ips is not None:
            showIndent(outfile, level)
            outfile.write('ips=model_.ips(\n')
            self.ips.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.fqdn is not None:
            showIndent(outfile, level)
            outfile.write('fqdn=%s,\n' % quote_python(self.fqdn).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ips':
            obj_ = IPs.factory()
            obj_.build(child_)
            self.set_ips(obj_)
        elif nodeName_ == 'fqdn':
            fqdn_ = child_.text
            fqdn_ = self.gds_validate_string(fqdn_, node, 'fqdn')
            self.fqdn = fqdn_
# end class GuestInfo


class VM(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, type_=None, status=None, memory=None, cpu=None, cpu_shares=None, os=None, high_availability=None, display=None, host=None, cluster=None, template=None, storage_domain=None, start_time=None, creation_time=None, origin=None, stateless=None, delete_protected=None, console=None, timezone=None, domain=None, custom_properties=None, payloads=None, statistics=None, disks=None, initialization=None, nics=None, tags=None, snapshots=None, placement_policy=None, memory_policy=None, guest_info=None, quota=None, usb=None, tunnel_migration=None, virtio_scsi=None, permissions=None, vmpool=None, cdroms=None, floppies=None, reported_devices=None, watchdogs=None, extensiontype_=None):
        super(VM, self).__init__(actions, href, id, name, description, comment, creation_status, link, extensiontype_, )
        self.type_ = type_
        self.status = status
        self.memory = memory
        self.cpu = cpu
        self.cpu_shares = cpu_shares
        self.os = os
        self.high_availability = high_availability
        self.display = display
        self.host = host
        self.cluster = cluster
        self.template = template
        self.storage_domain = storage_domain
        self.start_time = start_time
        self.creation_time = creation_time
        self.origin = origin
        self.stateless = stateless
        self.delete_protected = delete_protected
        self.console = console
        self.timezone = timezone
        self.domain = domain
        self.custom_properties = custom_properties
        self.payloads = payloads
        self.statistics = statistics
        self.disks = disks
        self.initialization = initialization
        self.nics = nics
        self.tags = tags
        self.snapshots = snapshots
        self.placement_policy = placement_policy
        self.memory_policy = memory_policy
        self.guest_info = guest_info
        self.quota = quota
        self.usb = usb
        self.tunnel_migration = tunnel_migration
        self.virtio_scsi = virtio_scsi
        self.permissions = permissions
        self.vmpool = vmpool
        self.cdroms = cdroms
        self.floppies = floppies
        self.reported_devices = reported_devices
        self.watchdogs = watchdogs
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if VM.subclass:
            return VM.subclass(*args_, **kwargs_)
        else:
            return VM(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_memory(self): return self.memory
    def set_memory(self, memory): self.memory = memory
    def get_cpu(self): return self.cpu
    def set_cpu(self, cpu): self.cpu = cpu
    def get_cpu_shares(self): return self.cpu_shares
    def set_cpu_shares(self, cpu_shares): self.cpu_shares = cpu_shares
    def get_os(self): return self.os
    def set_os(self, os): self.os = os
    def get_high_availability(self): return self.high_availability
    def set_high_availability(self, high_availability): self.high_availability = high_availability
    def get_display(self): return self.display
    def set_display(self, display): self.display = display
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def get_template(self): return self.template
    def set_template(self, template): self.template = template
    def get_storage_domain(self): return self.storage_domain
    def set_storage_domain(self, storage_domain): self.storage_domain = storage_domain
    def get_start_time(self): return self.start_time
    def set_start_time(self, start_time): self.start_time = start_time
    def get_creation_time(self): return self.creation_time
    def set_creation_time(self, creation_time): self.creation_time = creation_time
    def get_origin(self): return self.origin
    def set_origin(self, origin): self.origin = origin
    def get_stateless(self): return self.stateless
    def set_stateless(self, stateless): self.stateless = stateless
    def get_delete_protected(self): return self.delete_protected
    def set_delete_protected(self, delete_protected): self.delete_protected = delete_protected
    def get_console(self): return self.console
    def set_console(self, console): self.console = console
    def get_timezone(self): return self.timezone
    def set_timezone(self, timezone): self.timezone = timezone
    def get_domain(self): return self.domain
    def set_domain(self, domain): self.domain = domain
    def get_custom_properties(self): return self.custom_properties
    def set_custom_properties(self, custom_properties): self.custom_properties = custom_properties
    def get_payloads(self): return self.payloads
    def set_payloads(self, payloads): self.payloads = payloads
    def get_statistics(self): return self.statistics
    def set_statistics(self, statistics): self.statistics = statistics
    def get_disks(self): return self.disks
    def set_disks(self, disks): self.disks = disks
    def get_initialization(self): return self.initialization
    def set_initialization(self, initialization): self.initialization = initialization
    def get_nics(self): return self.nics
    def set_nics(self, nics): self.nics = nics
    def get_tags(self): return self.tags
    def set_tags(self, tags): self.tags = tags
    def get_snapshots(self): return self.snapshots
    def set_snapshots(self, snapshots): self.snapshots = snapshots
    def get_placement_policy(self): return self.placement_policy
    def set_placement_policy(self, placement_policy): self.placement_policy = placement_policy
    def get_memory_policy(self): return self.memory_policy
    def set_memory_policy(self, memory_policy): self.memory_policy = memory_policy
    def get_guest_info(self): return self.guest_info
    def set_guest_info(self, guest_info): self.guest_info = guest_info
    def get_quota(self): return self.quota
    def set_quota(self, quota): self.quota = quota
    def get_usb(self): return self.usb
    def set_usb(self, usb): self.usb = usb
    def get_tunnel_migration(self): return self.tunnel_migration
    def set_tunnel_migration(self, tunnel_migration): self.tunnel_migration = tunnel_migration
    def get_virtio_scsi(self): return self.virtio_scsi
    def set_virtio_scsi(self, virtio_scsi): self.virtio_scsi = virtio_scsi
    def get_permissions(self): return self.permissions
    def set_permissions(self, permissions): self.permissions = permissions
    def get_vmpool(self): return self.vmpool
    def set_vmpool(self, vmpool): self.vmpool = vmpool
    def get_cdroms(self): return self.cdroms
    def set_cdroms(self, cdroms): self.cdroms = cdroms
    def get_floppies(self): return self.floppies
    def set_floppies(self, floppies): self.floppies = floppies
    def get_reported_devices(self): return self.reported_devices
    def set_reported_devices(self, reported_devices): self.reported_devices = reported_devices
    def get_watchdogs(self): return self.watchdogs
    def set_watchdogs(self, watchdogs): self.watchdogs = watchdogs
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.type_ is not None or
            self.status is not None or
            self.memory is not None or
            self.cpu is not None or
            self.cpu_shares is not None or
            self.os is not None or
            self.high_availability is not None or
            self.display is not None or
            self.host is not None or
            self.cluster is not None or
            self.template is not None or
            self.storage_domain is not None or
            self.start_time is not None or
            self.creation_time is not None or
            self.origin is not None or
            self.stateless is not None or
            self.delete_protected is not None or
            self.console is not None or
            self.timezone is not None or
            self.domain is not None or
            self.custom_properties is not None or
            self.payloads is not None or
            self.statistics is not None or
            self.disks is not None or
            self.initialization is not None or
            self.nics is not None or
            self.tags is not None or
            self.snapshots is not None or
            self.placement_policy is not None or
            self.memory_policy is not None or
            self.guest_info is not None or
            self.quota is not None or
            self.usb is not None or
            self.tunnel_migration is not None or
            self.virtio_scsi is not None or
            self.permissions is not None or
            self.vmpool is not None or
            self.cdroms is not None or
            self.floppies is not None or
            self.reported_devices is not None or
            self.watchdogs is not None or
            super(VM, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VM', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VM')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VM'):
        super(VM, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VM')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='VM', fromsubclass_=False, pretty_print=True):
        super(VM, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status', pretty_print=pretty_print)
        if self.memory is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smemory>%s</%smemory>%s' % (namespace_, self.gds_format_integer(self.memory, input_name='memory'), namespace_, eol_))
        if self.cpu is not None:
            self.cpu.export(outfile, level, namespace_, name_='cpu', pretty_print=pretty_print)
        if self.cpu_shares is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scpu_shares>%s</%scpu_shares>%s' % (namespace_, self.gds_format_integer(self.cpu_shares, input_name='cpu_shares'), namespace_, eol_))
        if self.os is not None:
            self.os.export(outfile, level, namespace_, name_='os', pretty_print=pretty_print)
        if self.high_availability is not None:
            self.high_availability.export(outfile, level, namespace_, name_='high_availability', pretty_print=pretty_print)
        if self.display is not None:
            self.display.export(outfile, level, namespace_, name_='display', pretty_print=pretty_print)
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host', pretty_print=pretty_print)
        if self.cluster is not None:
            self.cluster.export(outfile, level, namespace_, name_='cluster', pretty_print=pretty_print)
        if self.template is not None:
            self.template.export(outfile, level, namespace_, name_='template', pretty_print=pretty_print)
        if self.storage_domain is not None:
            self.storage_domain.export(outfile, level, namespace_, name_='storage_domain', pretty_print=pretty_print)
        if self.start_time is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstart_time>%s</%sstart_time>%s' % (namespace_, self.gds_format_datetime(self.start_time, input_name='start_time'), namespace_, eol_))
        if self.creation_time is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%screation_time>%s</%screation_time>%s' % (namespace_, self.gds_format_datetime(self.creation_time, input_name='creation_time'), namespace_, eol_))
        if self.origin is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorigin>%s</%sorigin>%s' % (namespace_, self.gds_format_string(quote_xml(self.origin).encode(ExternalEncoding), input_name='origin'), namespace_, eol_))
        if self.stateless is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstateless>%s</%sstateless>%s' % (namespace_, self.gds_format_boolean(self.stateless, input_name='stateless'), namespace_, eol_))
        if self.delete_protected is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdelete_protected>%s</%sdelete_protected>%s' % (namespace_, self.gds_format_boolean(self.delete_protected, input_name='delete_protected'), namespace_, eol_))
        if self.console is not None:
            self.console.export(outfile, level, namespace_, name_='console', pretty_print=pretty_print)
        if self.timezone is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stimezone>%s</%stimezone>%s' % (namespace_, self.gds_format_string(quote_xml(self.timezone).encode(ExternalEncoding), input_name='timezone'), namespace_, eol_))
        if self.domain is not None:
            self.domain.export(outfile, level, namespace_, name_='domain', pretty_print=pretty_print)
        if self.custom_properties is not None:
            self.custom_properties.export(outfile, level, namespace_, name_='custom_properties', pretty_print=pretty_print)
        if self.payloads is not None:
            self.payloads.export(outfile, level, namespace_, name_='payloads', pretty_print=pretty_print)
        if self.statistics is not None:
            self.statistics.export(outfile, level, namespace_, name_='statistics', pretty_print=pretty_print)
        if self.disks is not None:
            self.disks.export(outfile, level, namespace_, name_='disks', pretty_print=pretty_print)
        if self.initialization is not None:
            self.initialization.export(outfile, level, namespace_, name_='initialization', pretty_print=pretty_print)
        if self.nics is not None:
            self.nics.export(outfile, level, namespace_, name_='nics', pretty_print=pretty_print)
        if self.tags is not None:
            self.tags.export(outfile, level, namespace_, name_='tags', pretty_print=pretty_print)
        if self.snapshots is not None:
            self.snapshots.export(outfile, level, namespace_, name_='snapshots', pretty_print=pretty_print)
        if self.placement_policy is not None:
            self.placement_policy.export(outfile, level, namespace_, name_='placement_policy', pretty_print=pretty_print)
        if self.memory_policy is not None:
            self.memory_policy.export(outfile, level, namespace_, name_='memory_policy', pretty_print=pretty_print)
        if self.guest_info is not None:
            self.guest_info.export(outfile, level, namespace_, name_='guest_info', pretty_print=pretty_print)
        if self.quota is not None:
            self.quota.export(outfile, level, namespace_, name_='quota', pretty_print=pretty_print)
        if self.usb is not None:
            self.usb.export(outfile, level, namespace_, name_='usb', pretty_print=pretty_print)
        if self.tunnel_migration is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stunnel_migration>%s</%stunnel_migration>%s' % (namespace_, self.gds_format_boolean(self.tunnel_migration, input_name='tunnel_migration'), namespace_, eol_))
        if self.virtio_scsi is not None:
            self.virtio_scsi.export(outfile, level, namespace_, name_='virtio_scsi', pretty_print=pretty_print)
        if self.permissions is not None:
            self.permissions.export(outfile, level, namespace_, name_='permissions', pretty_print=pretty_print)
        if self.vmpool is not None:
            self.vmpool.export(outfile, level, namespace_, name_='vmpool', pretty_print=pretty_print)
        if self.cdroms is not None:
            self.cdroms.export(outfile, level, namespace_, name_='cdroms', pretty_print=pretty_print)
        if self.floppies is not None:
            self.floppies.export(outfile, level, namespace_, name_='floppies', pretty_print=pretty_print)
        if self.reported_devices is not None:
            self.reported_devices.export(outfile, level, namespace_, name_='reported_devices', pretty_print=pretty_print)
        if self.watchdogs is not None:
            self.watchdogs.export(outfile, level, namespace_, name_='watchdogs', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VM'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(VM, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VM, self).exportLiteralChildren(outfile, level, name_)
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.memory is not None:
            showIndent(outfile, level)
            outfile.write('memory=%d,\n' % self.memory)
        if self.cpu is not None:
            showIndent(outfile, level)
            outfile.write('cpu=model_.CPU(\n')
            self.cpu.exportLiteral(outfile, level, name_='cpu')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cpu_shares is not None:
            showIndent(outfile, level)
            outfile.write('cpu_shares=%d,\n' % self.cpu_shares)
        if self.os is not None:
            showIndent(outfile, level)
            outfile.write('os=model_.OperatingSystem(\n')
            self.os.exportLiteral(outfile, level, name_='os')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.high_availability is not None:
            showIndent(outfile, level)
            outfile.write('high_availability=model_.HighAvailability(\n')
            self.high_availability.exportLiteral(outfile, level, name_='high_availability')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.display is not None:
            showIndent(outfile, level)
            outfile.write('display=model_.Display(\n')
            self.display.exportLiteral(outfile, level, name_='display')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cluster is not None:
            showIndent(outfile, level)
            outfile.write('cluster=model_.cluster(\n')
            self.cluster.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.template is not None:
            showIndent(outfile, level)
            outfile.write('template=model_.template(\n')
            self.template.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.storage_domain is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain=model_.storage_domain(\n')
            self.storage_domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.start_time is not None:
            showIndent(outfile, level)
            outfile.write('start_time=datetime_.strptime("%s", "%%Y-%%m-%%dT%%H:%%M:%%S"),\n' % self.gds_format_datetime(self.start_time, input_name='start_time'))
        if self.creation_time is not None:
            showIndent(outfile, level)
            outfile.write('creation_time=datetime_.strptime("%s", "%%Y-%%m-%%dT%%H:%%M:%%S"),\n' % self.gds_format_datetime(self.creation_time, input_name='creation_time'))
        if self.origin is not None:
            showIndent(outfile, level)
            outfile.write('origin=%s,\n' % quote_python(self.origin).encode(ExternalEncoding))
        if self.stateless is not None:
            showIndent(outfile, level)
            outfile.write('stateless=%s,\n' % self.stateless)
        if self.delete_protected is not None:
            showIndent(outfile, level)
            outfile.write('delete_protected=%s,\n' % self.delete_protected)
        if self.console is not None:
            showIndent(outfile, level)
            outfile.write('console=model_.console(\n')
            self.console.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.timezone is not None:
            showIndent(outfile, level)
            outfile.write('timezone=%s,\n' % quote_python(self.timezone).encode(ExternalEncoding))
        if self.domain is not None:
            showIndent(outfile, level)
            outfile.write('domain=model_.domain(\n')
            self.domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.custom_properties is not None:
            showIndent(outfile, level)
            outfile.write('custom_properties=model_.CustomProperties(\n')
            self.custom_properties.exportLiteral(outfile, level, name_='custom_properties')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.payloads is not None:
            showIndent(outfile, level)
            outfile.write('payloads=model_.Payloads(\n')
            self.payloads.exportLiteral(outfile, level, name_='payloads')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.statistics is not None:
            showIndent(outfile, level)
            outfile.write('statistics=model_.Statistics(\n')
            self.statistics.exportLiteral(outfile, level, name_='statistics')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.disks is not None:
            showIndent(outfile, level)
            outfile.write('disks=model_.Disks(\n')
            self.disks.exportLiteral(outfile, level, name_='disks')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.initialization is not None:
            showIndent(outfile, level)
            outfile.write('initialization=model_.initialization(\n')
            self.initialization.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.nics is not None:
            showIndent(outfile, level)
            outfile.write('nics=model_.Nics(\n')
            self.nics.exportLiteral(outfile, level, name_='nics')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.tags is not None:
            showIndent(outfile, level)
            outfile.write('tags=model_.Tags(\n')
            self.tags.exportLiteral(outfile, level, name_='tags')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.snapshots is not None:
            showIndent(outfile, level)
            outfile.write('snapshots=model_.Snapshots(\n')
            self.snapshots.exportLiteral(outfile, level, name_='snapshots')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.placement_policy is not None:
            showIndent(outfile, level)
            outfile.write('placement_policy=model_.VmPlacementPolicy(\n')
            self.placement_policy.exportLiteral(outfile, level, name_='placement_policy')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.memory_policy is not None:
            showIndent(outfile, level)
            outfile.write('memory_policy=model_.MemoryPolicy(\n')
            self.memory_policy.exportLiteral(outfile, level, name_='memory_policy')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.guest_info is not None:
            showIndent(outfile, level)
            outfile.write('guest_info=model_.GuestInfo(\n')
            self.guest_info.exportLiteral(outfile, level, name_='guest_info')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.quota is not None:
            showIndent(outfile, level)
            outfile.write('quota=model_.quota(\n')
            self.quota.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.usb is not None:
            showIndent(outfile, level)
            outfile.write('usb=model_.usb(\n')
            self.usb.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.tunnel_migration is not None:
            showIndent(outfile, level)
            outfile.write('tunnel_migration=%s,\n' % self.tunnel_migration)
        if self.virtio_scsi is not None:
            showIndent(outfile, level)
            outfile.write('virtio_scsi=model_.virtio_scsi(\n')
            self.virtio_scsi.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.permissions is not None:
            showIndent(outfile, level)
            outfile.write('permissions=model_.permissions(\n')
            self.permissions.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vmpool is not None:
            showIndent(outfile, level)
            outfile.write('vmpool=model_.vmpool(\n')
            self.vmpool.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cdroms is not None:
            showIndent(outfile, level)
            outfile.write('cdroms=model_.cdroms(\n')
            self.cdroms.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.floppies is not None:
            showIndent(outfile, level)
            outfile.write('floppies=model_.floppies(\n')
            self.floppies.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.reported_devices is not None:
            showIndent(outfile, level)
            outfile.write('reported_devices=model_.reported_devices(\n')
            self.reported_devices.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.watchdogs is not None:
            showIndent(outfile, level)
            outfile.write('watchdogs=model_.watchdogs(\n')
            self.watchdogs.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(VM, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.set_status(obj_)
        elif nodeName_ == 'memory':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'memory')
            self.memory = ival_
        elif nodeName_ == 'cpu':
            obj_ = CPU.factory()
            obj_.build(child_)
            self.set_cpu(obj_)
        elif nodeName_ == 'cpu_shares':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'cpu_shares')
            self.cpu_shares = ival_
        elif nodeName_ == 'os':
            obj_ = OperatingSystem.factory()
            obj_.build(child_)
            self.set_os(obj_)
        elif nodeName_ == 'high_availability':
            obj_ = HighAvailability.factory()
            obj_.build(child_)
            self.set_high_availability(obj_)
        elif nodeName_ == 'display':
            obj_ = Display.factory()
            obj_.build(child_)
            self.set_display(obj_)
        elif nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.set_host(obj_)
        elif nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.set_cluster(obj_)
        elif nodeName_ == 'template':
            obj_ = Template.factory()
            obj_.build(child_)
            self.set_template(obj_)
        elif nodeName_ == 'storage_domain':
            obj_ = StorageDomain.factory()
            obj_.build(child_)
            self.set_storage_domain(obj_)
        elif nodeName_ == 'start_time':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_, node, 'start_time')
            self.start_time = dval_
        elif nodeName_ == 'creation_time':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_, node, 'creation_time')
            self.creation_time = dval_
        elif nodeName_ == 'origin':
            origin_ = child_.text
            origin_ = self.gds_validate_string(origin_, node, 'origin')
            self.origin = origin_
        elif nodeName_ == 'stateless':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'stateless')
            self.stateless = ival_
        elif nodeName_ == 'delete_protected':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'delete_protected')
            self.delete_protected = ival_
        elif nodeName_ == 'console':
            obj_ = Console.factory()
            obj_.build(child_)
            self.set_console(obj_)
        elif nodeName_ == 'timezone':
            timezone_ = child_.text
            timezone_ = self.gds_validate_string(timezone_, node, 'timezone')
            self.timezone = timezone_
        elif nodeName_ == 'domain':
            obj_ = Domain.factory()
            obj_.build(child_)
            self.set_domain(obj_)
        elif nodeName_ == 'custom_properties':
            obj_ = CustomProperties.factory()
            obj_.build(child_)
            self.set_custom_properties(obj_)
        elif nodeName_ == 'payloads':
            obj_ = Payloads.factory()
            obj_.build(child_)
            self.set_payloads(obj_)
        elif nodeName_ == 'statistics':
            obj_ = Statistics.factory()
            obj_.build(child_)
            self.set_statistics(obj_)
        elif nodeName_ == 'disks':
            obj_ = Disks.factory()
            obj_.build(child_)
            self.set_disks(obj_)
        elif nodeName_ == 'initialization':
            obj_ = Initialization.factory()
            obj_.build(child_)
            self.set_initialization(obj_)
        elif nodeName_ == 'nics':
            obj_ = Nics.factory()
            obj_.build(child_)
            self.set_nics(obj_)
        elif nodeName_ == 'tags':
            obj_ = Tags.factory()
            obj_.build(child_)
            self.set_tags(obj_)
        elif nodeName_ == 'snapshots':
            obj_ = Snapshots.factory()
            obj_.build(child_)
            self.set_snapshots(obj_)
        elif nodeName_ == 'placement_policy':
            obj_ = VmPlacementPolicy.factory()
            obj_.build(child_)
            self.set_placement_policy(obj_)
        elif nodeName_ == 'memory_policy':
            obj_ = MemoryPolicy.factory()
            obj_.build(child_)
            self.set_memory_policy(obj_)
        elif nodeName_ == 'guest_info':
            obj_ = GuestInfo.factory()
            obj_.build(child_)
            self.set_guest_info(obj_)
        elif nodeName_ == 'quota':
            obj_ = Quota.factory()
            obj_.build(child_)
            self.set_quota(obj_)
        elif nodeName_ == 'usb':
            obj_ = Usb.factory()
            obj_.build(child_)
            self.set_usb(obj_)
        elif nodeName_ == 'tunnel_migration':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'tunnel_migration')
            self.tunnel_migration = ival_
        elif nodeName_ == 'virtio_scsi':
            obj_ = VirtIO_SCSI.factory()
            obj_.build(child_)
            self.set_virtio_scsi(obj_)
        elif nodeName_ == 'permissions':
            obj_ = Permissions.factory()
            obj_.build(child_)
            self.set_permissions(obj_)
        elif nodeName_ == 'vmpool':
            obj_ = VmPool.factory()
            obj_.build(child_)
            self.set_vmpool(obj_)
        elif nodeName_ == 'cdroms':
            obj_ = CdRoms.factory()
            obj_.build(child_)
            self.set_cdroms(obj_)
        elif nodeName_ == 'floppies':
            obj_ = Floppies.factory()
            obj_.build(child_)
            self.set_floppies(obj_)
        elif nodeName_ == 'reported_devices':
            obj_ = ReportedDevices.factory()
            obj_.build(child_)
            self.set_reported_devices(obj_)
        elif nodeName_ == 'watchdogs':
            obj_ = WatchDogs.factory()
            obj_.build(child_)
            self.set_watchdogs(obj_)
        super(VM, self).buildChildren(child_, node, nodeName_, True)
# end class VM


class VMs(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, vm=None):
        super(VMs, self).__init__(actions, total, active, )
        if vm is None:
            self.vm = []
        else:
            self.vm = vm
    def factory(*args_, **kwargs_):
        if VMs.subclass:
            return VMs.subclass(*args_, **kwargs_)
        else:
            return VMs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vm(self): return self.vm
    def set_vm(self, vm): self.vm = vm
    def add_vm(self, value): self.vm.append(value)
    def insert_vm(self, index, value): self.vm[index] = value
    def hasContent_(self):
        if (
            self.vm or
            super(VMs, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VMs', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VMs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VMs'):
        super(VMs, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VMs')
    def exportChildren(self, outfile, level, namespace_='', name_='VMs', fromsubclass_=False, pretty_print=True):
        super(VMs, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for vm_ in self.vm:
            vm_.export(outfile, level, namespace_, name_='vm', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VMs'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(VMs, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VMs, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('vm=[\n')
        level += 1
        for vm_ in self.vm:
            showIndent(outfile, level)
            outfile.write('model_.vm(\n')
            vm_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(VMs, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vm':
            class_obj_ = self.get_class_obj_(child_, VM)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.vm.append(obj_)
        super(VMs, self).buildChildren(child_, node, nodeName_, True)
# end class VMs


class ReportedDevices(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, reported_device=None):
        super(ReportedDevices, self).__init__(actions, total, active, )
        if reported_device is None:
            self.reported_device = []
        else:
            self.reported_device = reported_device
    def factory(*args_, **kwargs_):
        if ReportedDevices.subclass:
            return ReportedDevices.subclass(*args_, **kwargs_)
        else:
            return ReportedDevices(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_reported_device(self): return self.reported_device
    def set_reported_device(self, reported_device): self.reported_device = reported_device
    def add_reported_device(self, value): self.reported_device.append(value)
    def insert_reported_device(self, index, value): self.reported_device[index] = value
    def hasContent_(self):
        if (
            self.reported_device or
            super(ReportedDevices, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ReportedDevices', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ReportedDevices')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ReportedDevices'):
        super(ReportedDevices, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ReportedDevices')
    def exportChildren(self, outfile, level, namespace_='', name_='ReportedDevices', fromsubclass_=False, pretty_print=True):
        super(ReportedDevices, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for reported_device_ in self.reported_device:
            reported_device_.export(outfile, level, namespace_, name_='reported_device', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ReportedDevices'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ReportedDevices, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ReportedDevices, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('reported_device=[\n')
        level += 1
        for reported_device_ in self.reported_device:
            showIndent(outfile, level)
            outfile.write('model_.reported_device(\n')
            reported_device_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(ReportedDevices, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'reported_device':
            obj_ = ReportedDevice.factory()
            obj_.build(child_)
            self.reported_device.append(obj_)
        super(ReportedDevices, self).buildChildren(child_, node, nodeName_, True)
# end class ReportedDevices


class ReportedDevice(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, type_=None, mac=None, ips=None, vm=None):
        super(ReportedDevice, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.type_ = type_
        self.mac = mac
        self.ips = ips
        self.vm = vm
    def factory(*args_, **kwargs_):
        if ReportedDevice.subclass:
            return ReportedDevice.subclass(*args_, **kwargs_)
        else:
            return ReportedDevice(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_mac(self): return self.mac
    def set_mac(self, mac): self.mac = mac
    def get_ips(self): return self.ips
    def set_ips(self, ips): self.ips = ips
    def get_vm(self): return self.vm
    def set_vm(self, vm): self.vm = vm
    def hasContent_(self):
        if (
            self.type_ is not None or
            self.mac is not None or
            self.ips is not None or
            self.vm is not None or
            super(ReportedDevice, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ReportedDevice', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ReportedDevice')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ReportedDevice'):
        super(ReportedDevice, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ReportedDevice')
    def exportChildren(self, outfile, level, namespace_='', name_='ReportedDevice', fromsubclass_=False, pretty_print=True):
        super(ReportedDevice, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.mac is not None:
            self.mac.export(outfile, level, namespace_, name_='mac', pretty_print=pretty_print)
        if self.ips is not None:
            self.ips.export(outfile, level, namespace_, name_='ips', pretty_print=pretty_print)
        if self.vm is not None:
            self.vm.export(outfile, level, namespace_, name_='vm', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ReportedDevice'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ReportedDevice, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ReportedDevice, self).exportLiteralChildren(outfile, level, name_)
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.mac is not None:
            showIndent(outfile, level)
            outfile.write('mac=model_.mac(\n')
            self.mac.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ips is not None:
            showIndent(outfile, level)
            outfile.write('ips=model_.ips(\n')
            self.ips.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vm is not None:
            showIndent(outfile, level)
            outfile.write('vm=model_.vm(\n')
            self.vm.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(ReportedDevice, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'mac':
            obj_ = MAC.factory()
            obj_.build(child_)
            self.set_mac(obj_)
        elif nodeName_ == 'ips':
            obj_ = IPs.factory()
            obj_.build(child_)
            self.set_ips(obj_)
        elif nodeName_ == 'vm':
            class_obj_ = self.get_class_obj_(child_, VM)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_vm(obj_)
        super(ReportedDevice, self).buildChildren(child_, node, nodeName_, True)
# end class ReportedDevice


class PreviewVMs(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, preview_vm=None):
        super(PreviewVMs, self).__init__(actions, total, active, )
        if preview_vm is None:
            self.preview_vm = []
        else:
            self.preview_vm = preview_vm
    def factory(*args_, **kwargs_):
        if PreviewVMs.subclass:
            return PreviewVMs.subclass(*args_, **kwargs_)
        else:
            return PreviewVMs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_preview_vm(self): return self.preview_vm
    def set_preview_vm(self, preview_vm): self.preview_vm = preview_vm
    def add_preview_vm(self, value): self.preview_vm.append(value)
    def insert_preview_vm(self, index, value): self.preview_vm[index] = value
    def hasContent_(self):
        if (
            self.preview_vm or
            super(PreviewVMs, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PreviewVMs', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PreviewVMs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PreviewVMs'):
        super(PreviewVMs, self).exportAttributes(outfile, level, already_processed, namespace_, name_='PreviewVMs')
    def exportChildren(self, outfile, level, namespace_='', name_='PreviewVMs', fromsubclass_=False, pretty_print=True):
        super(PreviewVMs, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for preview_vm_ in self.preview_vm:
            preview_vm_.export(outfile, level, namespace_, name_='preview_vm', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='PreviewVMs'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(PreviewVMs, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(PreviewVMs, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('preview_vm=[\n')
        level += 1
        for preview_vm_ in self.preview_vm:
            showIndent(outfile, level)
            outfile.write('model_.VM(\n')
            preview_vm_.exportLiteral(outfile, level, name_='VM')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(PreviewVMs, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'preview_vm':
            class_obj_ = self.get_class_obj_(child_, VM)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.preview_vm.append(obj_)
        super(PreviewVMs, self).buildChildren(child_, node, nodeName_, True)
# end class PreviewVMs


class VmStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vm_state=None):
        if vm_state is None:
            self.vm_state = []
        else:
            self.vm_state = vm_state
    def factory(*args_, **kwargs_):
        if VmStates.subclass:
            return VmStates.subclass(*args_, **kwargs_)
        else:
            return VmStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vm_state(self): return self.vm_state
    def set_vm_state(self, vm_state): self.vm_state = vm_state
    def add_vm_state(self, value): self.vm_state.append(value)
    def insert_vm_state(self, index, value): self.vm_state[index] = value
    def hasContent_(self):
        if (
            self.vm_state
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VmStates', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmStates')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VmStates', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for vm_state_ in self.vm_state:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svm_state>%s</%svm_state>%s' % (namespace_, self.gds_format_string(quote_xml(vm_state_).encode(ExternalEncoding), input_name='vm_state'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='VmStates'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('vm_state=[\n')
        level += 1
        for vm_state_ in self.vm_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(vm_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vm_state':
            vm_state_ = child_.text
            vm_state_ = self.gds_validate_string(vm_state_, node, 'vm_state')
            self.vm_state.append(vm_state_)
# end class VmStates


class VmPauseDetails(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vm_pause_detail=None):
        if vm_pause_detail is None:
            self.vm_pause_detail = []
        else:
            self.vm_pause_detail = vm_pause_detail
    def factory(*args_, **kwargs_):
        if VmPauseDetails.subclass:
            return VmPauseDetails.subclass(*args_, **kwargs_)
        else:
            return VmPauseDetails(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vm_pause_detail(self): return self.vm_pause_detail
    def set_vm_pause_detail(self, vm_pause_detail): self.vm_pause_detail = vm_pause_detail
    def add_vm_pause_detail(self, value): self.vm_pause_detail.append(value)
    def insert_vm_pause_detail(self, index, value): self.vm_pause_detail[index] = value
    def hasContent_(self):
        if (
            self.vm_pause_detail
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VmPauseDetails', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmPauseDetails')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmPauseDetails'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VmPauseDetails', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for vm_pause_detail_ in self.vm_pause_detail:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svm_pause_detail>%s</%svm_pause_detail>%s' % (namespace_, self.gds_format_string(quote_xml(vm_pause_detail_).encode(ExternalEncoding), input_name='vm_pause_detail'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='VmPauseDetails'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('vm_pause_detail=[\n')
        level += 1
        for vm_pause_detail_ in self.vm_pause_detail:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(vm_pause_detail_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vm_pause_detail':
            vm_pause_detail_ = child_.text
            vm_pause_detail_ = self.gds_validate_string(vm_pause_detail_, node, 'vm_pause_detail')
            self.vm_pause_detail.append(vm_pause_detail_)
# end class VmPauseDetails


class PmProxyTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None):
        if type_ is None:
            self.type_ = []
        else:
            self.type_ = type_
    def factory(*args_, **kwargs_):
        if PmProxyTypes.subclass:
            return PmProxyTypes.subclass(*args_, **kwargs_)
        else:
            return PmProxyTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def add_type(self, value): self.type_.append(value)
    def insert_type(self, index, value): self.type_[index] = value
    def hasContent_(self):
        if (
            self.type_
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PmProxyTypes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PmProxyTypes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PmProxyTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='PmProxyTypes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for type_ in self.type_:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='PmProxyTypes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('type_=[\n')
        level += 1
        for type_ in self.type_:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_.append(type_)
# end class PmProxyTypes


class VmPool(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, size=None, cluster=None, template=None, prestarted_vms=None, max_user_vms=None):
        super(VmPool, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.size = size
        self.cluster = cluster
        self.template = template
        self.prestarted_vms = prestarted_vms
        self.max_user_vms = max_user_vms
    def factory(*args_, **kwargs_):
        if VmPool.subclass:
            return VmPool.subclass(*args_, **kwargs_)
        else:
            return VmPool(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def get_template(self): return self.template
    def set_template(self, template): self.template = template
    def get_prestarted_vms(self): return self.prestarted_vms
    def set_prestarted_vms(self, prestarted_vms): self.prestarted_vms = prestarted_vms
    def get_max_user_vms(self): return self.max_user_vms
    def set_max_user_vms(self, max_user_vms): self.max_user_vms = max_user_vms
    def hasContent_(self):
        if (
            self.size is not None or
            self.cluster is not None or
            self.template is not None or
            self.prestarted_vms is not None or
            self.max_user_vms is not None or
            super(VmPool, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VmPool', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmPool')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmPool'):
        super(VmPool, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VmPool')
    def exportChildren(self, outfile, level, namespace_='', name_='VmPool', fromsubclass_=False, pretty_print=True):
        super(VmPool, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.size is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssize>%s</%ssize>%s' % (namespace_, self.gds_format_integer(self.size, input_name='size'), namespace_, eol_))
        if self.cluster is not None:
            self.cluster.export(outfile, level, namespace_, name_='cluster', pretty_print=pretty_print)
        if self.template is not None:
            self.template.export(outfile, level, namespace_, name_='template', pretty_print=pretty_print)
        if self.prestarted_vms is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprestarted_vms>%s</%sprestarted_vms>%s' % (namespace_, self.gds_format_integer(self.prestarted_vms, input_name='prestarted_vms'), namespace_, eol_))
        if self.max_user_vms is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smax_user_vms>%s</%smax_user_vms>%s' % (namespace_, self.gds_format_integer(self.max_user_vms, input_name='max_user_vms'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='VmPool'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(VmPool, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VmPool, self).exportLiteralChildren(outfile, level, name_)
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % self.size)
        if self.cluster is not None:
            showIndent(outfile, level)
            outfile.write('cluster=model_.cluster(\n')
            self.cluster.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.template is not None:
            showIndent(outfile, level)
            outfile.write('template=model_.template(\n')
            self.template.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.prestarted_vms is not None:
            showIndent(outfile, level)
            outfile.write('prestarted_vms=%d,\n' % self.prestarted_vms)
        if self.max_user_vms is not None:
            showIndent(outfile, level)
            outfile.write('max_user_vms=%d,\n' % self.max_user_vms)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(VmPool, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'size')
            self.size = ival_
        elif nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.set_cluster(obj_)
        elif nodeName_ == 'template':
            obj_ = Template.factory()
            obj_.build(child_)
            self.set_template(obj_)
        elif nodeName_ == 'prestarted_vms':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'prestarted_vms')
            self.prestarted_vms = ival_
        elif nodeName_ == 'max_user_vms':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'max_user_vms')
            self.max_user_vms = ival_
        super(VmPool, self).buildChildren(child_, node, nodeName_, True)
# end class VmPool


class VmPools(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, vmpool=None):
        super(VmPools, self).__init__(actions, total, active, )
        if vmpool is None:
            self.vmpool = []
        else:
            self.vmpool = vmpool
    def factory(*args_, **kwargs_):
        if VmPools.subclass:
            return VmPools.subclass(*args_, **kwargs_)
        else:
            return VmPools(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vmpool(self): return self.vmpool
    def set_vmpool(self, vmpool): self.vmpool = vmpool
    def add_vmpool(self, value): self.vmpool.append(value)
    def insert_vmpool(self, index, value): self.vmpool[index] = value
    def hasContent_(self):
        if (
            self.vmpool or
            super(VmPools, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VmPools', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmPools')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmPools'):
        super(VmPools, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VmPools')
    def exportChildren(self, outfile, level, namespace_='', name_='VmPools', fromsubclass_=False, pretty_print=True):
        super(VmPools, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for vmpool_ in self.vmpool:
            vmpool_.export(outfile, level, namespace_, name_='vmpool', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VmPools'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(VmPools, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VmPools, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('vmpool=[\n')
        level += 1
        for vmpool_ in self.vmpool:
            showIndent(outfile, level)
            outfile.write('model_.vmpool(\n')
            vmpool_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(VmPools, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vmpool':
            obj_ = VmPool.factory()
            obj_.build(child_)
            self.vmpool.append(obj_)
        super(VmPools, self).buildChildren(child_, node, nodeName_, True)
# end class VmPools


class BaseDevice(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, vm=None, template=None, extensiontype_=None):
        super(BaseDevice, self).__init__(actions, href, id, name, description, comment, creation_status, link, extensiontype_, )
        self.vm = vm
        self.template = template
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if BaseDevice.subclass:
            return BaseDevice.subclass(*args_, **kwargs_)
        else:
            return BaseDevice(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vm(self): return self.vm
    def set_vm(self, vm): self.vm = vm
    def get_template(self): return self.template
    def set_template(self, template): self.template = template
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.vm is not None or
            self.template is not None or
            super(BaseDevice, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BaseDevice', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseDevice')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseDevice'):
        super(BaseDevice, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseDevice')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseDevice', fromsubclass_=False, pretty_print=True):
        super(BaseDevice, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.vm is not None:
            self.vm.export(outfile, level, namespace_, name_='vm', pretty_print=pretty_print)
        if self.template is not None:
            self.template.export(outfile, level, namespace_, name_='template', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BaseDevice'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(BaseDevice, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(BaseDevice, self).exportLiteralChildren(outfile, level, name_)
        if self.vm is not None:
            showIndent(outfile, level)
            outfile.write('vm=model_.vm(\n')
            self.vm.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.template is not None:
            showIndent(outfile, level)
            outfile.write('template=model_.template(\n')
            self.template.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(BaseDevice, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vm':
            class_obj_ = self.get_class_obj_(child_, VM)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_vm(obj_)
        elif nodeName_ == 'template':
            obj_ = Template.factory()
            obj_.build(child_)
            self.set_template(obj_)
        super(BaseDevice, self).buildChildren(child_, node, nodeName_, True)
# end class BaseDevice


class BaseDevices(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, extensiontype_=None):
        super(BaseDevices, self).__init__(actions, total, active, extensiontype_, )
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if BaseDevices.subclass:
            return BaseDevices.subclass(*args_, **kwargs_)
        else:
            return BaseDevices(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            super(BaseDevices, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BaseDevices', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseDevices')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseDevices'):
        super(BaseDevices, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseDevices')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseDevices', fromsubclass_=False, pretty_print=True):
        super(BaseDevices, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BaseDevices'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(BaseDevices, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(BaseDevices, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(BaseDevices, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BaseDevices, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BaseDevices


class Application(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, vm=None):
        super(Application, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.vm = vm
    def factory(*args_, **kwargs_):
        if Application.subclass:
            return Application.subclass(*args_, **kwargs_)
        else:
            return Application(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vm(self): return self.vm
    def set_vm(self, vm): self.vm = vm
    def hasContent_(self):
        if (
            self.vm is not None or
            super(Application, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Application', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Application')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Application'):
        super(Application, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Application')
    def exportChildren(self, outfile, level, namespace_='', name_='Application', fromsubclass_=False, pretty_print=True):
        super(Application, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.vm is not None:
            self.vm.export(outfile, level, namespace_, name_='vm', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Application'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Application, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Application, self).exportLiteralChildren(outfile, level, name_)
        if self.vm is not None:
            showIndent(outfile, level)
            outfile.write('vm=model_.vm(\n')
            self.vm.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Application, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vm':
            class_obj_ = self.get_class_obj_(child_, VM)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_vm(obj_)
        super(Application, self).buildChildren(child_, node, nodeName_, True)
# end class Application


class Applications(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, application=None):
        super(Applications, self).__init__(actions, total, active, )
        if application is None:
            self.application = []
        else:
            self.application = application
    def factory(*args_, **kwargs_):
        if Applications.subclass:
            return Applications.subclass(*args_, **kwargs_)
        else:
            return Applications(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_application(self): return self.application
    def set_application(self, application): self.application = application
    def add_application(self, value): self.application.append(value)
    def insert_application(self, index, value): self.application[index] = value
    def hasContent_(self):
        if (
            self.application or
            super(Applications, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Applications', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Applications')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Applications'):
        super(Applications, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Applications')
    def exportChildren(self, outfile, level, namespace_='', name_='Applications', fromsubclass_=False, pretty_print=True):
        super(Applications, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for application_ in self.application:
            application_.export(outfile, level, namespace_, name_='application', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Applications'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Applications, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Applications, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('application=[\n')
        level += 1
        for application_ in self.application:
            showIndent(outfile, level)
            outfile.write('model_.application(\n')
            application_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Applications, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'application':
            obj_ = Application.factory()
            obj_.build(child_)
            self.application.append(obj_)
        super(Applications, self).buildChildren(child_, node, nodeName_, True)
# end class Applications


class CdRom(BaseDevice):
    subclass = None
    superclass = BaseDevice
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, vm=None, template=None, file=None):
        super(CdRom, self).__init__(actions, href, id, name, description, comment, creation_status, link, vm, template, )
        self.file = file
    def factory(*args_, **kwargs_):
        if CdRom.subclass:
            return CdRom.subclass(*args_, **kwargs_)
        else:
            return CdRom(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_file(self): return self.file
    def set_file(self, file): self.file = file
    def hasContent_(self):
        if (
            self.file is not None or
            super(CdRom, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CdRom', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CdRom')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CdRom'):
        super(CdRom, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CdRom')
    def exportChildren(self, outfile, level, namespace_='', name_='CdRom', fromsubclass_=False, pretty_print=True):
        super(CdRom, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.file is not None:
            self.file.export(outfile, level, namespace_, name_='file', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='CdRom'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(CdRom, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(CdRom, self).exportLiteralChildren(outfile, level, name_)
        if self.file is not None:
            showIndent(outfile, level)
            outfile.write('file=model_.file(\n')
            self.file.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(CdRom, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'file':
            obj_ = File.factory()
            obj_.build(child_)
            self.set_file(obj_)
        super(CdRom, self).buildChildren(child_, node, nodeName_, True)
# end class CdRom


class CdRoms(BaseDevices):
    subclass = None
    superclass = BaseDevices
    def __init__(self, actions=None, total=None, active=None, cdrom=None):
        super(CdRoms, self).__init__(actions, total, active, )
        if cdrom is None:
            self.cdrom = []
        else:
            self.cdrom = cdrom
    def factory(*args_, **kwargs_):
        if CdRoms.subclass:
            return CdRoms.subclass(*args_, **kwargs_)
        else:
            return CdRoms(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cdrom(self): return self.cdrom
    def set_cdrom(self, cdrom): self.cdrom = cdrom
    def add_cdrom(self, value): self.cdrom.append(value)
    def insert_cdrom(self, index, value): self.cdrom[index] = value
    def hasContent_(self):
        if (
            self.cdrom or
            super(CdRoms, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CdRoms', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CdRoms')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CdRoms'):
        super(CdRoms, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CdRoms')
    def exportChildren(self, outfile, level, namespace_='', name_='CdRoms', fromsubclass_=False, pretty_print=True):
        super(CdRoms, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for cdrom_ in self.cdrom:
            cdrom_.export(outfile, level, namespace_, name_='cdrom', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='CdRoms'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(CdRoms, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(CdRoms, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('cdrom=[\n')
        level += 1
        for cdrom_ in self.cdrom:
            showIndent(outfile, level)
            outfile.write('model_.cdrom(\n')
            cdrom_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(CdRoms, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'cdrom':
            obj_ = CdRom.factory()
            obj_.build(child_)
            self.cdrom.append(obj_)
        super(CdRoms, self).buildChildren(child_, node, nodeName_, True)
# end class CdRoms


class Floppy(BaseDevice):
    subclass = None
    superclass = BaseDevice
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, vm=None, template=None, file=None):
        super(Floppy, self).__init__(actions, href, id, name, description, comment, creation_status, link, vm, template, )
        self.file = file
    def factory(*args_, **kwargs_):
        if Floppy.subclass:
            return Floppy.subclass(*args_, **kwargs_)
        else:
            return Floppy(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_file(self): return self.file
    def set_file(self, file): self.file = file
    def hasContent_(self):
        if (
            self.file is not None or
            super(Floppy, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Floppy', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Floppy')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Floppy'):
        super(Floppy, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Floppy')
    def exportChildren(self, outfile, level, namespace_='', name_='Floppy', fromsubclass_=False, pretty_print=True):
        super(Floppy, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.file is not None:
            self.file.export(outfile, level, namespace_, name_='file', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Floppy'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Floppy, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Floppy, self).exportLiteralChildren(outfile, level, name_)
        if self.file is not None:
            showIndent(outfile, level)
            outfile.write('file=model_.file(\n')
            self.file.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Floppy, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'file':
            obj_ = File.factory()
            obj_.build(child_)
            self.set_file(obj_)
        super(Floppy, self).buildChildren(child_, node, nodeName_, True)
# end class Floppy


class Floppies(BaseDevices):
    subclass = None
    superclass = BaseDevices
    def __init__(self, actions=None, total=None, active=None, floppy=None):
        super(Floppies, self).__init__(actions, total, active, )
        if floppy is None:
            self.floppy = []
        else:
            self.floppy = floppy
    def factory(*args_, **kwargs_):
        if Floppies.subclass:
            return Floppies.subclass(*args_, **kwargs_)
        else:
            return Floppies(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_floppy(self): return self.floppy
    def set_floppy(self, floppy): self.floppy = floppy
    def add_floppy(self, value): self.floppy.append(value)
    def insert_floppy(self, index, value): self.floppy[index] = value
    def hasContent_(self):
        if (
            self.floppy or
            super(Floppies, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Floppies', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Floppies')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Floppies'):
        super(Floppies, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Floppies')
    def exportChildren(self, outfile, level, namespace_='', name_='Floppies', fromsubclass_=False, pretty_print=True):
        super(Floppies, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for floppy_ in self.floppy:
            floppy_.export(outfile, level, namespace_, name_='floppy', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Floppies'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Floppies, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Floppies, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('floppy=[\n')
        level += 1
        for floppy_ in self.floppy:
            showIndent(outfile, level)
            outfile.write('model_.floppy(\n')
            floppy_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Floppies, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'floppy':
            obj_ = Floppy.factory()
            obj_.build(child_)
            self.floppy.append(obj_)
        super(Floppies, self).buildChildren(child_, node, nodeName_, True)
# end class Floppies


class Disk(BaseDevice):
    subclass = None
    superclass = BaseDevice
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, vm=None, template=None, alias=None, image_id=None, storage_domain=None, storage_domains=None, size=None, type_=None, provisioned_size=None, actual_size=None, status=None, interface=None, format=None, sparse=None, bootable=None, shareable=None, wipe_after_delete=None, propagate_errors=None, statistics=None, active=None, quota=None, lun_storage=None, sgio=None, snapshot=None):
        super(Disk, self).__init__(actions, href, id, name, description, comment, creation_status, link, vm, template, )
        self.alias = alias
        self.image_id = image_id
        self.storage_domain = storage_domain
        self.storage_domains = storage_domains
        self.size = size
        self.type_ = type_
        self.provisioned_size = provisioned_size
        self.actual_size = actual_size
        self.status = status
        self.interface = interface
        self.format = format
        self.sparse = sparse
        self.bootable = bootable
        self.shareable = shareable
        self.wipe_after_delete = wipe_after_delete
        self.propagate_errors = propagate_errors
        self.statistics = statistics
        self.active = active
        self.quota = quota
        self.lun_storage = lun_storage
        self.sgio = sgio
        self.snapshot = snapshot
    def factory(*args_, **kwargs_):
        if Disk.subclass:
            return Disk.subclass(*args_, **kwargs_)
        else:
            return Disk(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_alias(self): return self.alias
    def set_alias(self, alias): self.alias = alias
    def get_image_id(self): return self.image_id
    def set_image_id(self, image_id): self.image_id = image_id
    def get_storage_domain(self): return self.storage_domain
    def set_storage_domain(self, storage_domain): self.storage_domain = storage_domain
    def get_storage_domains(self): return self.storage_domains
    def set_storage_domains(self, storage_domains): self.storage_domains = storage_domains
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_provisioned_size(self): return self.provisioned_size
    def set_provisioned_size(self, provisioned_size): self.provisioned_size = provisioned_size
    def get_actual_size(self): return self.actual_size
    def set_actual_size(self, actual_size): self.actual_size = actual_size
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_interface(self): return self.interface
    def set_interface(self, interface): self.interface = interface
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_sparse(self): return self.sparse
    def set_sparse(self, sparse): self.sparse = sparse
    def get_bootable(self): return self.bootable
    def set_bootable(self, bootable): self.bootable = bootable
    def get_shareable(self): return self.shareable
    def set_shareable(self, shareable): self.shareable = shareable
    def get_wipe_after_delete(self): return self.wipe_after_delete
    def set_wipe_after_delete(self, wipe_after_delete): self.wipe_after_delete = wipe_after_delete
    def get_propagate_errors(self): return self.propagate_errors
    def set_propagate_errors(self, propagate_errors): self.propagate_errors = propagate_errors
    def get_statistics(self): return self.statistics
    def set_statistics(self, statistics): self.statistics = statistics
    def get_active(self): return self.active
    def set_active(self, active): self.active = active
    def get_quota(self): return self.quota
    def set_quota(self, quota): self.quota = quota
    def get_lun_storage(self): return self.lun_storage
    def set_lun_storage(self, lun_storage): self.lun_storage = lun_storage
    def get_sgio(self): return self.sgio
    def set_sgio(self, sgio): self.sgio = sgio
    def get_snapshot(self): return self.snapshot
    def set_snapshot(self, snapshot): self.snapshot = snapshot
    def hasContent_(self):
        if (
            self.alias is not None or
            self.image_id is not None or
            self.storage_domain is not None or
            self.storage_domains is not None or
            self.size is not None or
            self.type_ is not None or
            self.provisioned_size is not None or
            self.actual_size is not None or
            self.status is not None or
            self.interface is not None or
            self.format is not None or
            self.sparse is not None or
            self.bootable is not None or
            self.shareable is not None or
            self.wipe_after_delete is not None or
            self.propagate_errors is not None or
            self.statistics is not None or
            self.active is not None or
            self.quota is not None or
            self.lun_storage is not None or
            self.sgio is not None or
            self.snapshot is not None or
            super(Disk, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Disk', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Disk')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Disk'):
        super(Disk, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Disk')
    def exportChildren(self, outfile, level, namespace_='', name_='Disk', fromsubclass_=False, pretty_print=True):
        super(Disk, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.alias is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%salias>%s</%salias>%s' % (namespace_, self.gds_format_string(quote_xml(self.alias).encode(ExternalEncoding), input_name='alias'), namespace_, eol_))
        if self.image_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%simage_id>%s</%simage_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.image_id).encode(ExternalEncoding), input_name='image_id'), namespace_, eol_))
        if self.storage_domain is not None:
            self.storage_domain.export(outfile, level, namespace_, name_='storage_domain', pretty_print=pretty_print)
        if self.storage_domains is not None:
            self.storage_domains.export(outfile, level, namespace_, name_='storage_domains', pretty_print=pretty_print)
        if self.size is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssize>%s</%ssize>%s' % (namespace_, self.gds_format_integer(self.size, input_name='size'), namespace_, eol_))
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.provisioned_size is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprovisioned_size>%s</%sprovisioned_size>%s' % (namespace_, self.gds_format_integer(self.provisioned_size, input_name='provisioned_size'), namespace_, eol_))
        if self.actual_size is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sactual_size>%s</%sactual_size>%s' % (namespace_, self.gds_format_integer(self.actual_size, input_name='actual_size'), namespace_, eol_))
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status', pretty_print=pretty_print)
        if self.interface is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinterface>%s</%sinterface>%s' % (namespace_, self.gds_format_string(quote_xml(self.interface).encode(ExternalEncoding), input_name='interface'), namespace_, eol_))
        if self.format is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sformat>%s</%sformat>%s' % (namespace_, self.gds_format_string(quote_xml(self.format).encode(ExternalEncoding), input_name='format'), namespace_, eol_))
        if self.sparse is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssparse>%s</%ssparse>%s' % (namespace_, self.gds_format_boolean(self.sparse, input_name='sparse'), namespace_, eol_))
        if self.bootable is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbootable>%s</%sbootable>%s' % (namespace_, self.gds_format_boolean(self.bootable, input_name='bootable'), namespace_, eol_))
        if self.shareable is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshareable>%s</%sshareable>%s' % (namespace_, self.gds_format_boolean(self.shareable, input_name='shareable'), namespace_, eol_))
        if self.wipe_after_delete is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%swipe_after_delete>%s</%swipe_after_delete>%s' % (namespace_, self.gds_format_boolean(self.wipe_after_delete, input_name='wipe_after_delete'), namespace_, eol_))
        if self.propagate_errors is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spropagate_errors>%s</%spropagate_errors>%s' % (namespace_, self.gds_format_boolean(self.propagate_errors, input_name='propagate_errors'), namespace_, eol_))
        if self.statistics is not None:
            self.statistics.export(outfile, level, namespace_, name_='statistics', pretty_print=pretty_print)
        if self.active is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sactive>%s</%sactive>%s' % (namespace_, self.gds_format_boolean(self.active, input_name='active'), namespace_, eol_))
        if self.quota is not None:
            self.quota.export(outfile, level, namespace_, name_='quota', pretty_print=pretty_print)
        if self.lun_storage is not None:
            self.lun_storage.export(outfile, level, namespace_, name_='lun_storage', pretty_print=pretty_print)
        if self.sgio is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssgio>%s</%ssgio>%s' % (namespace_, self.gds_format_string(quote_xml(self.sgio).encode(ExternalEncoding), input_name='sgio'), namespace_, eol_))
        if self.snapshot is not None:
            self.snapshot.export(outfile, level, namespace_, name_='snapshot', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Disk'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Disk, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Disk, self).exportLiteralChildren(outfile, level, name_)
        if self.alias is not None:
            showIndent(outfile, level)
            outfile.write('alias=%s,\n' % quote_python(self.alias).encode(ExternalEncoding))
        if self.image_id is not None:
            showIndent(outfile, level)
            outfile.write('image_id=%s,\n' % quote_python(self.image_id).encode(ExternalEncoding))
        if self.storage_domain is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain=model_.storage_domain(\n')
            self.storage_domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.storage_domains is not None:
            showIndent(outfile, level)
            outfile.write('storage_domains=model_.storage_domains(\n')
            self.storage_domains.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % self.size)
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.provisioned_size is not None:
            showIndent(outfile, level)
            outfile.write('provisioned_size=%d,\n' % self.provisioned_size)
        if self.actual_size is not None:
            showIndent(outfile, level)
            outfile.write('actual_size=%d,\n' % self.actual_size)
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.interface is not None:
            showIndent(outfile, level)
            outfile.write('interface=%s,\n' % quote_python(self.interface).encode(ExternalEncoding))
        if self.format is not None:
            showIndent(outfile, level)
            outfile.write('format=%s,\n' % quote_python(self.format).encode(ExternalEncoding))
        if self.sparse is not None:
            showIndent(outfile, level)
            outfile.write('sparse=%s,\n' % self.sparse)
        if self.bootable is not None:
            showIndent(outfile, level)
            outfile.write('bootable=%s,\n' % self.bootable)
        if self.shareable is not None:
            showIndent(outfile, level)
            outfile.write('shareable=%s,\n' % self.shareable)
        if self.wipe_after_delete is not None:
            showIndent(outfile, level)
            outfile.write('wipe_after_delete=%s,\n' % self.wipe_after_delete)
        if self.propagate_errors is not None:
            showIndent(outfile, level)
            outfile.write('propagate_errors=%s,\n' % self.propagate_errors)
        if self.statistics is not None:
            showIndent(outfile, level)
            outfile.write('statistics=model_.Statistics(\n')
            self.statistics.exportLiteral(outfile, level, name_='statistics')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.active is not None:
            showIndent(outfile, level)
            outfile.write('active=%s,\n' % self.active)
        if self.quota is not None:
            showIndent(outfile, level)
            outfile.write('quota=model_.quota(\n')
            self.quota.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.lun_storage is not None:
            showIndent(outfile, level)
            outfile.write('lun_storage=model_.Storage(\n')
            self.lun_storage.exportLiteral(outfile, level, name_='lun_storage')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.sgio is not None:
            showIndent(outfile, level)
            outfile.write('sgio=%s,\n' % quote_python(self.sgio).encode(ExternalEncoding))
        if self.snapshot is not None:
            showIndent(outfile, level)
            outfile.write('snapshot=model_.snapshot(\n')
            self.snapshot.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Disk, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'alias':
            alias_ = child_.text
            alias_ = self.gds_validate_string(alias_, node, 'alias')
            self.alias = alias_
        elif nodeName_ == 'image_id':
            image_id_ = child_.text
            image_id_ = self.gds_validate_string(image_id_, node, 'image_id')
            self.image_id = image_id_
        elif nodeName_ == 'storage_domain':
            obj_ = StorageDomain.factory()
            obj_.build(child_)
            self.set_storage_domain(obj_)
        elif nodeName_ == 'storage_domains':
            obj_ = StorageDomains.factory()
            obj_.build(child_)
            self.set_storage_domains(obj_)
        elif nodeName_ == 'size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'size')
            self.size = ival_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'provisioned_size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'provisioned_size')
            self.provisioned_size = ival_
        elif nodeName_ == 'actual_size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'actual_size')
            self.actual_size = ival_
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.set_status(obj_)
        elif nodeName_ == 'interface':
            interface_ = child_.text
            interface_ = self.gds_validate_string(interface_, node, 'interface')
            self.interface = interface_
        elif nodeName_ == 'format':
            format_ = child_.text
            format_ = self.gds_validate_string(format_, node, 'format')
            self.format = format_
        elif nodeName_ == 'sparse':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'sparse')
            self.sparse = ival_
        elif nodeName_ == 'bootable':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'bootable')
            self.bootable = ival_
        elif nodeName_ == 'shareable':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'shareable')
            self.shareable = ival_
        elif nodeName_ == 'wipe_after_delete':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'wipe_after_delete')
            self.wipe_after_delete = ival_
        elif nodeName_ == 'propagate_errors':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'propagate_errors')
            self.propagate_errors = ival_
        elif nodeName_ == 'statistics':
            obj_ = Statistics.factory()
            obj_.build(child_)
            self.set_statistics(obj_)
        elif nodeName_ == 'active':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'active')
            self.active = ival_
        elif nodeName_ == 'quota':
            obj_ = Quota.factory()
            obj_.build(child_)
            self.set_quota(obj_)
        elif nodeName_ == 'lun_storage':
            obj_ = Storage.factory()
            obj_.build(child_)
            self.set_lun_storage(obj_)
        elif nodeName_ == 'sgio':
            sgio_ = child_.text
            sgio_ = self.gds_validate_string(sgio_, node, 'sgio')
            self.sgio = sgio_
        elif nodeName_ == 'snapshot':
            obj_ = Snapshot.factory()
            obj_.build(child_)
            self.set_snapshot(obj_)
        super(Disk, self).buildChildren(child_, node, nodeName_, True)
# end class Disk


class Disks(BaseDevices):
    subclass = None
    superclass = BaseDevices
    def __init__(self, actions=None, total=None, active=None, disk=None, clone=None, detach_only=None):
        super(Disks, self).__init__(actions, total, active, )
        if disk is None:
            self.disk = []
        else:
            self.disk = disk
        self.clone = clone
        self.detach_only = detach_only
    def factory(*args_, **kwargs_):
        if Disks.subclass:
            return Disks.subclass(*args_, **kwargs_)
        else:
            return Disks(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_disk(self): return self.disk
    def set_disk(self, disk): self.disk = disk
    def add_disk(self, value): self.disk.append(value)
    def insert_disk(self, index, value): self.disk[index] = value
    def get_clone(self): return self.clone
    def set_clone(self, clone): self.clone = clone
    def get_detach_only(self): return self.detach_only
    def set_detach_only(self, detach_only): self.detach_only = detach_only
    def hasContent_(self):
        if (
            self.disk or
            self.clone is not None or
            self.detach_only is not None or
            super(Disks, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Disks', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Disks')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Disks'):
        super(Disks, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Disks')
    def exportChildren(self, outfile, level, namespace_='', name_='Disks', fromsubclass_=False, pretty_print=True):
        super(Disks, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for disk_ in self.disk:
            disk_.export(outfile, level, namespace_, name_='disk', pretty_print=pretty_print)
        if self.clone is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sclone>%s</%sclone>%s' % (namespace_, self.gds_format_boolean(self.clone, input_name='clone'), namespace_, eol_))
        if self.detach_only is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetach_only>%s</%sdetach_only>%s' % (namespace_, self.gds_format_boolean(self.detach_only, input_name='detach_only'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Disks'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Disks, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Disks, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('disk=[\n')
        level += 1
        for disk_ in self.disk:
            showIndent(outfile, level)
            outfile.write('model_.disk(\n')
            disk_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.clone is not None:
            showIndent(outfile, level)
            outfile.write('clone=%s,\n' % self.clone)
        if self.detach_only is not None:
            showIndent(outfile, level)
            outfile.write('detach_only=%s,\n' % self.detach_only)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Disks, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'disk':
            obj_ = Disk.factory()
            obj_.build(child_)
            self.disk.append(obj_)
        elif nodeName_ == 'clone':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'clone')
            self.clone = ival_
        elif nodeName_ == 'detach_only':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'detach_only')
            self.detach_only = ival_
        super(Disks, self).buildChildren(child_, node, nodeName_, True)
# end class Disks


class DiskStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, disk_state=None):
        if disk_state is None:
            self.disk_state = []
        else:
            self.disk_state = disk_state
    def factory(*args_, **kwargs_):
        if DiskStates.subclass:
            return DiskStates.subclass(*args_, **kwargs_)
        else:
            return DiskStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_disk_state(self): return self.disk_state
    def set_disk_state(self, disk_state): self.disk_state = disk_state
    def add_disk_state(self, value): self.disk_state.append(value)
    def insert_disk_state(self, index, value): self.disk_state[index] = value
    def hasContent_(self):
        if (
            self.disk_state
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DiskStates', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DiskStates')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DiskStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='DiskStates', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for disk_state_ in self.disk_state:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisk_state>%s</%sdisk_state>%s' % (namespace_, self.gds_format_string(quote_xml(disk_state_).encode(ExternalEncoding), input_name='disk_state'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='DiskStates'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('disk_state=[\n')
        level += 1
        for disk_state_ in self.disk_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(disk_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'disk_state':
            disk_state_ = child_.text
            disk_state_ = self.gds_validate_string(disk_state_, node, 'disk_state')
            self.disk_state.append(disk_state_)
# end class DiskStates


class PortMirroring(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, networks=None):
        self.networks = networks
    def factory(*args_, **kwargs_):
        if PortMirroring.subclass:
            return PortMirroring.subclass(*args_, **kwargs_)
        else:
            return PortMirroring(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_networks(self): return self.networks
    def set_networks(self, networks): self.networks = networks
    def hasContent_(self):
        if (
            self.networks is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PortMirroring', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PortMirroring')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PortMirroring'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='PortMirroring', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.networks is not None:
            self.networks.export(outfile, level, namespace_, name_='networks', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='PortMirroring'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.networks is not None:
            showIndent(outfile, level)
            outfile.write('networks=model_.networks(\n')
            self.networks.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'networks':
            obj_ = Networks.factory()
            obj_.build(child_)
            self.set_networks(obj_)
# end class PortMirroring


class NIC(BaseDevice):
    subclass = None
    superclass = BaseDevice
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, vm=None, template=None, network=None, linked=None, interface=None, mac=None, statistics=None, active=None, plugged=None, port_mirroring=None, reported_devices=None, vnic_profile=None):
        super(NIC, self).__init__(actions, href, id, name, description, comment, creation_status, link, vm, template, )
        self.network = network
        self.linked = linked
        self.interface = interface
        self.mac = mac
        self.statistics = statistics
        self.active = active
        self.plugged = plugged
        self.port_mirroring = port_mirroring
        self.reported_devices = reported_devices
        self.vnic_profile = vnic_profile
    def factory(*args_, **kwargs_):
        if NIC.subclass:
            return NIC.subclass(*args_, **kwargs_)
        else:
            return NIC(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_network(self): return self.network
    def set_network(self, network): self.network = network
    def get_linked(self): return self.linked
    def set_linked(self, linked): self.linked = linked
    def get_interface(self): return self.interface
    def set_interface(self, interface): self.interface = interface
    def get_mac(self): return self.mac
    def set_mac(self, mac): self.mac = mac
    def get_statistics(self): return self.statistics
    def set_statistics(self, statistics): self.statistics = statistics
    def get_active(self): return self.active
    def set_active(self, active): self.active = active
    def get_plugged(self): return self.plugged
    def set_plugged(self, plugged): self.plugged = plugged
    def get_port_mirroring(self): return self.port_mirroring
    def set_port_mirroring(self, port_mirroring): self.port_mirroring = port_mirroring
    def get_reported_devices(self): return self.reported_devices
    def set_reported_devices(self, reported_devices): self.reported_devices = reported_devices
    def get_vnic_profile(self): return self.vnic_profile
    def set_vnic_profile(self, vnic_profile): self.vnic_profile = vnic_profile
    def hasContent_(self):
        if (
            self.network is not None or
            self.linked is not None or
            self.interface is not None or
            self.mac is not None or
            self.statistics is not None or
            self.active is not None or
            self.plugged is not None or
            self.port_mirroring is not None or
            self.reported_devices is not None or
            self.vnic_profile is not None or
            super(NIC, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NIC', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NIC')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NIC'):
        super(NIC, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NIC')
    def exportChildren(self, outfile, level, namespace_='', name_='NIC', fromsubclass_=False, pretty_print=True):
        super(NIC, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.network is not None:
            self.network.export(outfile, level, namespace_, name_='network', pretty_print=pretty_print)
        if self.linked is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slinked>%s</%slinked>%s' % (namespace_, self.gds_format_boolean(self.linked, input_name='linked'), namespace_, eol_))
        if self.interface is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinterface>%s</%sinterface>%s' % (namespace_, self.gds_format_string(quote_xml(self.interface).encode(ExternalEncoding), input_name='interface'), namespace_, eol_))
        if self.mac is not None:
            self.mac.export(outfile, level, namespace_, name_='mac', pretty_print=pretty_print)
        if self.statistics is not None:
            self.statistics.export(outfile, level, namespace_, name_='statistics', pretty_print=pretty_print)
        if self.active is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sactive>%s</%sactive>%s' % (namespace_, self.gds_format_boolean(self.active, input_name='active'), namespace_, eol_))
        if self.plugged is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%splugged>%s</%splugged>%s' % (namespace_, self.gds_format_boolean(self.plugged, input_name='plugged'), namespace_, eol_))
        if self.port_mirroring is not None:
            self.port_mirroring.export(outfile, level, namespace_, name_='port_mirroring', pretty_print=pretty_print)
        if self.reported_devices is not None:
            self.reported_devices.export(outfile, level, namespace_, name_='reported_devices', pretty_print=pretty_print)
        if self.vnic_profile is not None:
            self.vnic_profile.export(outfile, level, namespace_, name_='vnic_profile', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='NIC'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(NIC, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(NIC, self).exportLiteralChildren(outfile, level, name_)
        if self.network is not None:
            showIndent(outfile, level)
            outfile.write('network=model_.network(\n')
            self.network.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.linked is not None:
            showIndent(outfile, level)
            outfile.write('linked=%s,\n' % self.linked)
        if self.interface is not None:
            showIndent(outfile, level)
            outfile.write('interface=%s,\n' % quote_python(self.interface).encode(ExternalEncoding))
        if self.mac is not None:
            showIndent(outfile, level)
            outfile.write('mac=model_.mac(\n')
            self.mac.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.statistics is not None:
            showIndent(outfile, level)
            outfile.write('statistics=model_.Statistics(\n')
            self.statistics.exportLiteral(outfile, level, name_='statistics')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.active is not None:
            showIndent(outfile, level)
            outfile.write('active=%s,\n' % self.active)
        if self.plugged is not None:
            showIndent(outfile, level)
            outfile.write('plugged=%s,\n' % self.plugged)
        if self.port_mirroring is not None:
            showIndent(outfile, level)
            outfile.write('port_mirroring=model_.port_mirroring(\n')
            self.port_mirroring.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.reported_devices is not None:
            showIndent(outfile, level)
            outfile.write('reported_devices=model_.reported_devices(\n')
            self.reported_devices.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vnic_profile is not None:
            showIndent(outfile, level)
            outfile.write('vnic_profile=model_.vnic_profile(\n')
            self.vnic_profile.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(NIC, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'network':
            obj_ = Network.factory()
            obj_.build(child_)
            self.set_network(obj_)
        elif nodeName_ == 'linked':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'linked')
            self.linked = ival_
        elif nodeName_ == 'interface':
            interface_ = child_.text
            interface_ = self.gds_validate_string(interface_, node, 'interface')
            self.interface = interface_
        elif nodeName_ == 'mac':
            obj_ = MAC.factory()
            obj_.build(child_)
            self.set_mac(obj_)
        elif nodeName_ == 'statistics':
            obj_ = Statistics.factory()
            obj_.build(child_)
            self.set_statistics(obj_)
        elif nodeName_ == 'active':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'active')
            self.active = ival_
        elif nodeName_ == 'plugged':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'plugged')
            self.plugged = ival_
        elif nodeName_ == 'port_mirroring':
            obj_ = PortMirroring.factory()
            obj_.build(child_)
            self.set_port_mirroring(obj_)
        elif nodeName_ == 'reported_devices':
            obj_ = ReportedDevices.factory()
            obj_.build(child_)
            self.set_reported_devices(obj_)
        elif nodeName_ == 'vnic_profile':
            obj_ = VnicProfile.factory()
            obj_.build(child_)
            self.set_vnic_profile(obj_)
        super(NIC, self).buildChildren(child_, node, nodeName_, True)
# end class NIC


class Nics(BaseDevices):
    subclass = None
    superclass = BaseDevices
    def __init__(self, actions=None, total=None, active=None, nic=None):
        super(Nics, self).__init__(actions, total, active, )
        if nic is None:
            self.nic = []
        else:
            self.nic = nic
    def factory(*args_, **kwargs_):
        if Nics.subclass:
            return Nics.subclass(*args_, **kwargs_)
        else:
            return Nics(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_nic(self): return self.nic
    def set_nic(self, nic): self.nic = nic
    def add_nic(self, value): self.nic.append(value)
    def insert_nic(self, index, value): self.nic[index] = value
    def hasContent_(self):
        if (
            self.nic or
            super(Nics, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Nics', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Nics')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Nics'):
        super(Nics, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Nics')
    def exportChildren(self, outfile, level, namespace_='', name_='Nics', fromsubclass_=False, pretty_print=True):
        super(Nics, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for nic_ in self.nic:
            nic_.export(outfile, level, namespace_, name_='nic', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Nics'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Nics, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Nics, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('nic=[\n')
        level += 1
        for nic_ in self.nic:
            showIndent(outfile, level)
            outfile.write('model_.nic(\n')
            nic_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Nics, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'nic':
            obj_ = NIC.factory()
            obj_.build(child_)
            self.nic.append(obj_)
        super(Nics, self).buildChildren(child_, node, nodeName_, True)
# end class Nics


class Snapshot(VM):
    subclass = None
    superclass = VM
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, type_=None, status=None, memory=None, cpu=None, cpu_shares=None, os=None, high_availability=None, display=None, host=None, cluster=None, template=None, storage_domain=None, start_time=None, creation_time=None, origin=None, stateless=None, delete_protected=None, console=None, timezone=None, domain=None, custom_properties=None, payloads=None, statistics=None, disks=None, initialization=None, nics=None, tags=None, snapshots=None, placement_policy=None, memory_policy=None, guest_info=None, quota=None, usb=None, tunnel_migration=None, virtio_scsi=None, permissions=None, vmpool=None, cdroms=None, floppies=None, reported_devices=None, watchdogs=None, vm=None, date=None, snapshot_status=None, persist_memorystate=None):
        super(Snapshot, self).__init__(actions, href, id, name, description, comment, creation_status, link, type_, status, memory, cpu, cpu_shares, os, high_availability, display, host, cluster, template, storage_domain, start_time, creation_time, origin, stateless, delete_protected, console, timezone, domain, custom_properties, payloads, statistics, disks, initialization, nics, tags, snapshots, placement_policy, memory_policy, guest_info, quota, usb, tunnel_migration, virtio_scsi, permissions, vmpool, cdroms, floppies, reported_devices, watchdogs, )
        self.vm = vm
        self.date = date
        self.snapshot_status = snapshot_status
        self.persist_memorystate = persist_memorystate
    def factory(*args_, **kwargs_):
        if Snapshot.subclass:
            return Snapshot.subclass(*args_, **kwargs_)
        else:
            return Snapshot(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vm(self): return self.vm
    def set_vm(self, vm): self.vm = vm
    def get_date(self): return self.date
    def set_date(self, date): self.date = date
    def get_snapshot_status(self): return self.snapshot_status
    def set_snapshot_status(self, snapshot_status): self.snapshot_status = snapshot_status
    def get_persist_memorystate(self): return self.persist_memorystate
    def set_persist_memorystate(self, persist_memorystate): self.persist_memorystate = persist_memorystate
    def hasContent_(self):
        if (
            self.vm is not None or
            self.date is not None or
            self.snapshot_status is not None or
            self.persist_memorystate is not None or
            super(Snapshot, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Snapshot', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Snapshot')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Snapshot'):
        super(Snapshot, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Snapshot')
    def exportChildren(self, outfile, level, namespace_='', name_='Snapshot', fromsubclass_=False, pretty_print=True):
        super(Snapshot, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.vm is not None:
            self.vm.export(outfile, level, namespace_, name_='vm', pretty_print=pretty_print)
        if self.date is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdate>%s</%sdate>%s' % (namespace_, self.gds_format_datetime(self.date, input_name='date'), namespace_, eol_))
        if self.snapshot_status is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssnapshot_status>%s</%ssnapshot_status>%s' % (namespace_, self.gds_format_string(quote_xml(self.snapshot_status).encode(ExternalEncoding), input_name='snapshot_status'), namespace_, eol_))
        if self.persist_memorystate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spersist_memorystate>%s</%spersist_memorystate>%s' % (namespace_, self.gds_format_boolean(self.persist_memorystate, input_name='persist_memorystate'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Snapshot'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Snapshot, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Snapshot, self).exportLiteralChildren(outfile, level, name_)
        if self.vm is not None:
            showIndent(outfile, level)
            outfile.write('vm=model_.vm(\n')
            self.vm.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.date is not None:
            showIndent(outfile, level)
            outfile.write('date=datetime_.strptime("%s", "%%Y-%%m-%%dT%%H:%%M:%%S"),\n' % self.gds_format_datetime(self.date, input_name='date'))
        if self.snapshot_status is not None:
            showIndent(outfile, level)
            outfile.write('snapshot_status=%s,\n' % quote_python(self.snapshot_status).encode(ExternalEncoding))
        if self.persist_memorystate is not None:
            showIndent(outfile, level)
            outfile.write('persist_memorystate=%s,\n' % self.persist_memorystate)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Snapshot, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vm':
            class_obj_ = self.get_class_obj_(child_, VM)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_vm(obj_)
        elif nodeName_ == 'date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_, node, 'date')
            self.date = dval_
        elif nodeName_ == 'snapshot_status':
            snapshot_status_ = child_.text
            snapshot_status_ = self.gds_validate_string(snapshot_status_, node, 'snapshot_status')
            self.snapshot_status = snapshot_status_
        elif nodeName_ == 'persist_memorystate':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'persist_memorystate')
            self.persist_memorystate = ival_
        super(Snapshot, self).buildChildren(child_, node, nodeName_, True)
# end class Snapshot


class Snapshots(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, snapshot=None, collapse_snapshots=None):
        super(Snapshots, self).__init__(actions, total, active, )
        if snapshot is None:
            self.snapshot = []
        else:
            self.snapshot = snapshot
        self.collapse_snapshots = collapse_snapshots
    def factory(*args_, **kwargs_):
        if Snapshots.subclass:
            return Snapshots.subclass(*args_, **kwargs_)
        else:
            return Snapshots(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_snapshot(self): return self.snapshot
    def set_snapshot(self, snapshot): self.snapshot = snapshot
    def add_snapshot(self, value): self.snapshot.append(value)
    def insert_snapshot(self, index, value): self.snapshot[index] = value
    def get_collapse_snapshots(self): return self.collapse_snapshots
    def set_collapse_snapshots(self, collapse_snapshots): self.collapse_snapshots = collapse_snapshots
    def hasContent_(self):
        if (
            self.snapshot or
            self.collapse_snapshots is not None or
            super(Snapshots, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Snapshots', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Snapshots')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Snapshots'):
        super(Snapshots, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Snapshots')
    def exportChildren(self, outfile, level, namespace_='', name_='Snapshots', fromsubclass_=False, pretty_print=True):
        super(Snapshots, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for snapshot_ in self.snapshot:
            snapshot_.export(outfile, level, namespace_, name_='snapshot', pretty_print=pretty_print)
        if self.collapse_snapshots is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scollapse_snapshots>%s</%scollapse_snapshots>%s' % (namespace_, self.gds_format_boolean(self.collapse_snapshots, input_name='collapse_snapshots'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Snapshots'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Snapshots, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Snapshots, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('snapshot=[\n')
        level += 1
        for snapshot_ in self.snapshot:
            showIndent(outfile, level)
            outfile.write('model_.snapshot(\n')
            snapshot_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.collapse_snapshots is not None:
            showIndent(outfile, level)
            outfile.write('collapse_snapshots=%s,\n' % self.collapse_snapshots)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Snapshots, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'snapshot':
            obj_ = Snapshot.factory()
            obj_.build(child_)
            self.snapshot.append(obj_)
        elif nodeName_ == 'collapse_snapshots':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'collapse_snapshots')
            self.collapse_snapshots = ival_
        super(Snapshots, self).buildChildren(child_, node, nodeName_, True)
# end class Snapshots


class HostNIC(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, host=None, network=None, mac=None, ip=None, vlan=None, bonding=None, boot_protocol=None, statistics=None, check_connectivity=None, speed=None, status=None, mtu=None, bridged=None, custom_configuration=None, override_configuration=None):
        super(HostNIC, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.host = host
        self.network = network
        self.mac = mac
        self.ip = ip
        self.vlan = vlan
        self.bonding = bonding
        self.boot_protocol = boot_protocol
        self.statistics = statistics
        self.check_connectivity = check_connectivity
        self.speed = speed
        self.status = status
        self.mtu = mtu
        self.bridged = bridged
        self.custom_configuration = custom_configuration
        self.override_configuration = override_configuration
    def factory(*args_, **kwargs_):
        if HostNIC.subclass:
            return HostNIC.subclass(*args_, **kwargs_)
        else:
            return HostNIC(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def get_network(self): return self.network
    def set_network(self, network): self.network = network
    def get_mac(self): return self.mac
    def set_mac(self, mac): self.mac = mac
    def get_ip(self): return self.ip
    def set_ip(self, ip): self.ip = ip
    def get_vlan(self): return self.vlan
    def set_vlan(self, vlan): self.vlan = vlan
    def get_bonding(self): return self.bonding
    def set_bonding(self, bonding): self.bonding = bonding
    def get_boot_protocol(self): return self.boot_protocol
    def set_boot_protocol(self, boot_protocol): self.boot_protocol = boot_protocol
    def get_statistics(self): return self.statistics
    def set_statistics(self, statistics): self.statistics = statistics
    def get_check_connectivity(self): return self.check_connectivity
    def set_check_connectivity(self, check_connectivity): self.check_connectivity = check_connectivity
    def get_speed(self): return self.speed
    def set_speed(self, speed): self.speed = speed
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_mtu(self): return self.mtu
    def set_mtu(self, mtu): self.mtu = mtu
    def get_bridged(self): return self.bridged
    def set_bridged(self, bridged): self.bridged = bridged
    def get_custom_configuration(self): return self.custom_configuration
    def set_custom_configuration(self, custom_configuration): self.custom_configuration = custom_configuration
    def get_override_configuration(self): return self.override_configuration
    def set_override_configuration(self, override_configuration): self.override_configuration = override_configuration
    def hasContent_(self):
        if (
            self.host is not None or
            self.network is not None or
            self.mac is not None or
            self.ip is not None or
            self.vlan is not None or
            self.bonding is not None or
            self.boot_protocol is not None or
            self.statistics is not None or
            self.check_connectivity is not None or
            self.speed is not None or
            self.status is not None or
            self.mtu is not None or
            self.bridged is not None or
            self.custom_configuration is not None or
            self.override_configuration is not None or
            super(HostNIC, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='HostNIC', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HostNIC')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HostNIC'):
        super(HostNIC, self).exportAttributes(outfile, level, already_processed, namespace_, name_='HostNIC')
    def exportChildren(self, outfile, level, namespace_='', name_='HostNIC', fromsubclass_=False, pretty_print=True):
        super(HostNIC, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host', pretty_print=pretty_print)
        if self.network is not None:
            self.network.export(outfile, level, namespace_, name_='network', pretty_print=pretty_print)
        if self.mac is not None:
            self.mac.export(outfile, level, namespace_, name_='mac', pretty_print=pretty_print)
        if self.ip is not None:
            self.ip.export(outfile, level, namespace_, name_='ip', pretty_print=pretty_print)
        if self.vlan is not None:
            self.vlan.export(outfile, level, namespace_, name_='vlan', pretty_print=pretty_print)
        if self.bonding is not None:
            self.bonding.export(outfile, level, namespace_, name_='bonding', pretty_print=pretty_print)
        if self.boot_protocol is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sboot_protocol>%s</%sboot_protocol>%s' % (namespace_, self.gds_format_string(quote_xml(self.boot_protocol).encode(ExternalEncoding), input_name='boot_protocol'), namespace_, eol_))
        if self.statistics is not None:
            self.statistics.export(outfile, level, namespace_, name_='statistics', pretty_print=pretty_print)
        if self.check_connectivity is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scheck_connectivity>%s</%scheck_connectivity>%s' % (namespace_, self.gds_format_boolean(self.check_connectivity, input_name='check_connectivity'), namespace_, eol_))
        if self.speed is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sspeed>%s</%sspeed>%s' % (namespace_, self.gds_format_integer(self.speed, input_name='speed'), namespace_, eol_))
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status', pretty_print=pretty_print)
        if self.mtu is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smtu>%s</%smtu>%s' % (namespace_, self.gds_format_integer(self.mtu, input_name='mtu'), namespace_, eol_))
        if self.bridged is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbridged>%s</%sbridged>%s' % (namespace_, self.gds_format_boolean(self.bridged, input_name='bridged'), namespace_, eol_))
        if self.custom_configuration is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scustom_configuration>%s</%scustom_configuration>%s' % (namespace_, self.gds_format_boolean(self.custom_configuration, input_name='custom_configuration'), namespace_, eol_))
        if self.override_configuration is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soverride_configuration>%s</%soverride_configuration>%s' % (namespace_, self.gds_format_boolean(self.override_configuration, input_name='override_configuration'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='HostNIC'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(HostNIC, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(HostNIC, self).exportLiteralChildren(outfile, level, name_)
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.network is not None:
            showIndent(outfile, level)
            outfile.write('network=model_.network(\n')
            self.network.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.mac is not None:
            showIndent(outfile, level)
            outfile.write('mac=model_.mac(\n')
            self.mac.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ip is not None:
            showIndent(outfile, level)
            outfile.write('ip=model_.ip(\n')
            self.ip.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vlan is not None:
            showIndent(outfile, level)
            outfile.write('vlan=model_.vlan(\n')
            self.vlan.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.bonding is not None:
            showIndent(outfile, level)
            outfile.write('bonding=model_.bonding(\n')
            self.bonding.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.boot_protocol is not None:
            showIndent(outfile, level)
            outfile.write('boot_protocol=%s,\n' % quote_python(self.boot_protocol).encode(ExternalEncoding))
        if self.statistics is not None:
            showIndent(outfile, level)
            outfile.write('statistics=model_.Statistics(\n')
            self.statistics.exportLiteral(outfile, level, name_='statistics')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.check_connectivity is not None:
            showIndent(outfile, level)
            outfile.write('check_connectivity=%s,\n' % self.check_connectivity)
        if self.speed is not None:
            showIndent(outfile, level)
            outfile.write('speed=%d,\n' % self.speed)
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.mtu is not None:
            showIndent(outfile, level)
            outfile.write('mtu=%d,\n' % self.mtu)
        if self.bridged is not None:
            showIndent(outfile, level)
            outfile.write('bridged=%s,\n' % self.bridged)
        if self.custom_configuration is not None:
            showIndent(outfile, level)
            outfile.write('custom_configuration=%s,\n' % self.custom_configuration)
        if self.override_configuration is not None:
            showIndent(outfile, level)
            outfile.write('override_configuration=%s,\n' % self.override_configuration)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(HostNIC, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.set_host(obj_)
        elif nodeName_ == 'network':
            obj_ = Network.factory()
            obj_.build(child_)
            self.set_network(obj_)
        elif nodeName_ == 'mac':
            obj_ = MAC.factory()
            obj_.build(child_)
            self.set_mac(obj_)
        elif nodeName_ == 'ip':
            obj_ = IP.factory()
            obj_.build(child_)
            self.set_ip(obj_)
        elif nodeName_ == 'vlan':
            obj_ = VLAN.factory()
            obj_.build(child_)
            self.set_vlan(obj_)
        elif nodeName_ == 'bonding':
            obj_ = Bonding.factory()
            obj_.build(child_)
            self.set_bonding(obj_)
        elif nodeName_ == 'boot_protocol':
            boot_protocol_ = child_.text
            boot_protocol_ = self.gds_validate_string(boot_protocol_, node, 'boot_protocol')
            self.boot_protocol = boot_protocol_
        elif nodeName_ == 'statistics':
            obj_ = Statistics.factory()
            obj_.build(child_)
            self.set_statistics(obj_)
        elif nodeName_ == 'check_connectivity':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'check_connectivity')
            self.check_connectivity = ival_
        elif nodeName_ == 'speed':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'speed')
            self.speed = ival_
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.set_status(obj_)
        elif nodeName_ == 'mtu':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'mtu')
            self.mtu = ival_
        elif nodeName_ == 'bridged':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'bridged')
            self.bridged = ival_
        elif nodeName_ == 'custom_configuration':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'custom_configuration')
            self.custom_configuration = ival_
        elif nodeName_ == 'override_configuration':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'override_configuration')
            self.override_configuration = ival_
        super(HostNIC, self).buildChildren(child_, node, nodeName_, True)
# end class HostNIC


class HostNics(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, host_nic=None):
        super(HostNics, self).__init__(actions, total, active, )
        if host_nic is None:
            self.host_nic = []
        else:
            self.host_nic = host_nic
    def factory(*args_, **kwargs_):
        if HostNics.subclass:
            return HostNics.subclass(*args_, **kwargs_)
        else:
            return HostNics(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_host_nic(self): return self.host_nic
    def set_host_nic(self, host_nic): self.host_nic = host_nic
    def add_host_nic(self, value): self.host_nic.append(value)
    def insert_host_nic(self, index, value): self.host_nic[index] = value
    def hasContent_(self):
        if (
            self.host_nic or
            super(HostNics, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='HostNics', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HostNics')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HostNics'):
        super(HostNics, self).exportAttributes(outfile, level, already_processed, namespace_, name_='HostNics')
    def exportChildren(self, outfile, level, namespace_='', name_='HostNics', fromsubclass_=False, pretty_print=True):
        super(HostNics, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for host_nic_ in self.host_nic:
            host_nic_.export(outfile, level, namespace_, name_='host_nic', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='HostNics'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(HostNics, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(HostNics, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('host_nic=[\n')
        level += 1
        for host_nic_ in self.host_nic:
            showIndent(outfile, level)
            outfile.write('model_.host_nic(\n')
            host_nic_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(HostNics, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'host_nic':
            obj_ = HostNIC.factory()
            obj_.build(child_)
            self.host_nic.append(obj_)
        super(HostNics, self).buildChildren(child_, node, nodeName_, True)
# end class HostNics


class HostNICStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, host_nic_state=None):
        if host_nic_state is None:
            self.host_nic_state = []
        else:
            self.host_nic_state = host_nic_state
    def factory(*args_, **kwargs_):
        if HostNICStates.subclass:
            return HostNICStates.subclass(*args_, **kwargs_)
        else:
            return HostNICStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_host_nic_state(self): return self.host_nic_state
    def set_host_nic_state(self, host_nic_state): self.host_nic_state = host_nic_state
    def add_host_nic_state(self, value): self.host_nic_state.append(value)
    def insert_host_nic_state(self, index, value): self.host_nic_state[index] = value
    def hasContent_(self):
        if (
            self.host_nic_state
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='HostNICStates', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HostNICStates')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HostNICStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='HostNICStates', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for host_nic_state_ in self.host_nic_state:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shost_nic_state>%s</%shost_nic_state>%s' % (namespace_, self.gds_format_string(quote_xml(host_nic_state_).encode(ExternalEncoding), input_name='host_nic_state'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='HostNICStates'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('host_nic_state=[\n')
        level += 1
        for host_nic_state_ in self.host_nic_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(host_nic_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'host_nic_state':
            host_nic_state_ = child_.text
            host_nic_state_ = self.gds_validate_string(host_nic_state_, node, 'host_nic_state')
            self.host_nic_state.append(host_nic_state_)
# end class HostNICStates


class Slaves(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, host_nic=None):
        if host_nic is None:
            self.host_nic = []
        else:
            self.host_nic = host_nic
    def factory(*args_, **kwargs_):
        if Slaves.subclass:
            return Slaves.subclass(*args_, **kwargs_)
        else:
            return Slaves(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_host_nic(self): return self.host_nic
    def set_host_nic(self, host_nic): self.host_nic = host_nic
    def add_host_nic(self, value): self.host_nic.append(value)
    def insert_host_nic(self, index, value): self.host_nic[index] = value
    def hasContent_(self):
        if (
            self.host_nic
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Slaves', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Slaves')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Slaves'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Slaves', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for host_nic_ in self.host_nic:
            host_nic_.export(outfile, level, namespace_, name_='host_nic', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Slaves'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('host_nic=[\n')
        level += 1
        for host_nic_ in self.host_nic:
            showIndent(outfile, level)
            outfile.write('model_.host_nic(\n')
            host_nic_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'host_nic':
            obj_ = HostNIC.factory()
            obj_.build(child_)
            self.host_nic.append(obj_)
# end class Slaves


class Bonding(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, options=None, slaves=None):
        self.options = options
        self.slaves = slaves
    def factory(*args_, **kwargs_):
        if Bonding.subclass:
            return Bonding.subclass(*args_, **kwargs_)
        else:
            return Bonding(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_options(self): return self.options
    def set_options(self, options): self.options = options
    def get_slaves(self): return self.slaves
    def set_slaves(self, slaves): self.slaves = slaves
    def hasContent_(self):
        if (
            self.options is not None or
            self.slaves is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Bonding', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Bonding')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Bonding'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Bonding', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.options is not None:
            self.options.export(outfile, level, namespace_, name_='options', pretty_print=pretty_print)
        if self.slaves is not None:
            self.slaves.export(outfile, level, namespace_, name_='slaves', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Bonding'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.options is not None:
            showIndent(outfile, level)
            outfile.write('options=model_.options(\n')
            self.options.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.slaves is not None:
            showIndent(outfile, level)
            outfile.write('slaves=model_.slaves(\n')
            self.slaves.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'options':
            obj_ = Options.factory()
            obj_.build(child_)
            self.set_options(obj_)
        elif nodeName_ == 'slaves':
            obj_ = Slaves.factory()
            obj_.build(child_)
            self.set_slaves(obj_)
# end class Bonding


class HostStorage(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, storage=None):
        super(HostStorage, self).__init__(actions, total, active, )
        if storage is None:
            self.storage = []
        else:
            self.storage = storage
    def factory(*args_, **kwargs_):
        if HostStorage.subclass:
            return HostStorage.subclass(*args_, **kwargs_)
        else:
            return HostStorage(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_storage(self): return self.storage
    def set_storage(self, storage): self.storage = storage
    def add_storage(self, value): self.storage.append(value)
    def insert_storage(self, index, value): self.storage[index] = value
    def hasContent_(self):
        if (
            self.storage or
            super(HostStorage, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='HostStorage', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HostStorage')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HostStorage'):
        super(HostStorage, self).exportAttributes(outfile, level, already_processed, namespace_, name_='HostStorage')
    def exportChildren(self, outfile, level, namespace_='', name_='HostStorage', fromsubclass_=False, pretty_print=True):
        super(HostStorage, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for storage_ in self.storage:
            storage_.export(outfile, level, namespace_, name_='storage', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='HostStorage'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(HostStorage, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(HostStorage, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('storage=[\n')
        level += 1
        for storage_ in self.storage:
            showIndent(outfile, level)
            outfile.write('model_.storage(\n')
            storage_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(HostStorage, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'storage':
            obj_ = Storage.factory()
            obj_.build(child_)
            self.storage.append(obj_)
        super(HostStorage, self).buildChildren(child_, node, nodeName_, True)
# end class HostStorage


class TagParent(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, tag=None):
        self.tag = tag
    def factory(*args_, **kwargs_):
        if TagParent.subclass:
            return TagParent.subclass(*args_, **kwargs_)
        else:
            return TagParent(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_tag(self): return self.tag
    def set_tag(self, tag): self.tag = tag
    def hasContent_(self):
        if (
            self.tag is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TagParent', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TagParent')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TagParent'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='TagParent', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.tag is not None:
            self.tag.export(outfile, level, namespace_, name_='tag', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='TagParent'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.tag is not None:
            showIndent(outfile, level)
            outfile.write('tag=model_.tag(\n')
            self.tag.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'tag':
            obj_ = Tag.factory()
            obj_.build(child_)
            self.set_tag(obj_)
# end class TagParent


class Tag(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, host=None, vm=None, user=None, group=None, parent=None):
        super(Tag, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.host = host
        self.vm = vm
        self.user = user
        self.group = group
        self.parent = parent
    def factory(*args_, **kwargs_):
        if Tag.subclass:
            return Tag.subclass(*args_, **kwargs_)
        else:
            return Tag(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def get_vm(self): return self.vm
    def set_vm(self, vm): self.vm = vm
    def get_user(self): return self.user
    def set_user(self, user): self.user = user
    def get_group(self): return self.group
    def set_group(self, group): self.group = group
    def get_parent(self): return self.parent
    def set_parent(self, parent): self.parent = parent
    def hasContent_(self):
        if (
            self.host is not None or
            self.vm is not None or
            self.user is not None or
            self.group is not None or
            self.parent is not None or
            super(Tag, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Tag', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Tag')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Tag'):
        super(Tag, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Tag')
    def exportChildren(self, outfile, level, namespace_='', name_='Tag', fromsubclass_=False, pretty_print=True):
        super(Tag, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host', pretty_print=pretty_print)
        if self.vm is not None:
            self.vm.export(outfile, level, namespace_, name_='vm', pretty_print=pretty_print)
        if self.user is not None:
            self.user.export(outfile, level, namespace_, name_='user', pretty_print=pretty_print)
        if self.group is not None:
            self.group.export(outfile, level, namespace_, name_='group', pretty_print=pretty_print)
        if self.parent is not None:
            self.parent.export(outfile, level, namespace_, name_='parent', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Tag'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Tag, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Tag, self).exportLiteralChildren(outfile, level, name_)
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vm is not None:
            showIndent(outfile, level)
            outfile.write('vm=model_.vm(\n')
            self.vm.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.user is not None:
            showIndent(outfile, level)
            outfile.write('user=model_.user(\n')
            self.user.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.group is not None:
            showIndent(outfile, level)
            outfile.write('group=model_.group(\n')
            self.group.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.parent is not None:
            showIndent(outfile, level)
            outfile.write('parent=model_.TagParent(\n')
            self.parent.exportLiteral(outfile, level, name_='parent')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Tag, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.set_host(obj_)
        elif nodeName_ == 'vm':
            class_obj_ = self.get_class_obj_(child_, VM)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.set_vm(obj_)
        elif nodeName_ == 'user':
            obj_ = User.factory()
            obj_.build(child_)
            self.set_user(obj_)
        elif nodeName_ == 'group':
            obj_ = Group.factory()
            obj_.build(child_)
            self.set_group(obj_)
        elif nodeName_ == 'parent':
            obj_ = TagParent.factory()
            obj_.build(child_)
            self.set_parent(obj_)
        super(Tag, self).buildChildren(child_, node, nodeName_, True)
# end class Tag


class Tags(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, tag=None):
        super(Tags, self).__init__(actions, total, active, )
        if tag is None:
            self.tag = []
        else:
            self.tag = tag
    def factory(*args_, **kwargs_):
        if Tags.subclass:
            return Tags.subclass(*args_, **kwargs_)
        else:
            return Tags(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_tag(self): return self.tag
    def set_tag(self, tag): self.tag = tag
    def add_tag(self, value): self.tag.append(value)
    def insert_tag(self, index, value): self.tag[index] = value
    def hasContent_(self):
        if (
            self.tag or
            super(Tags, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Tags', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Tags')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Tags'):
        super(Tags, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Tags')
    def exportChildren(self, outfile, level, namespace_='', name_='Tags', fromsubclass_=False, pretty_print=True):
        super(Tags, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for tag_ in self.tag:
            tag_.export(outfile, level, namespace_, name_='tag', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Tags'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Tags, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Tags, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('tag=[\n')
        level += 1
        for tag_ in self.tag:
            showIndent(outfile, level)
            outfile.write('model_.tag(\n')
            tag_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Tags, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'tag':
            obj_ = Tag.factory()
            obj_.build(child_)
            self.tag.append(obj_)
        super(Tags, self).buildChildren(child_, node, nodeName_, True)
# end class Tags


class Usb(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, enabled=None, type_=None):
        self.enabled = enabled
        self.type_ = type_
    def factory(*args_, **kwargs_):
        if Usb.subclass:
            return Usb.subclass(*args_, **kwargs_)
        else:
            return Usb(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_enabled(self): return self.enabled
    def set_enabled(self, enabled): self.enabled = enabled
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def hasContent_(self):
        if (
            self.enabled is not None or
            self.type_ is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Usb', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Usb')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Usb'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Usb', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.enabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%senabled>%s</%senabled>%s' % (namespace_, self.gds_format_boolean(self.enabled, input_name='enabled'), namespace_, eol_))
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Usb'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.enabled is not None:
            showIndent(outfile, level)
            outfile.write('enabled=%s,\n' % self.enabled)
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'enabled')
            self.enabled = ival_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
# end class Usb


class Quota(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, data_center=None, vms=None, disks=None, users=None):
        super(Quota, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.data_center = data_center
        self.vms = vms
        self.disks = disks
        self.users = users
    def factory(*args_, **kwargs_):
        if Quota.subclass:
            return Quota.subclass(*args_, **kwargs_)
        else:
            return Quota(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_data_center(self): return self.data_center
    def set_data_center(self, data_center): self.data_center = data_center
    def get_vms(self): return self.vms
    def set_vms(self, vms): self.vms = vms
    def get_disks(self): return self.disks
    def set_disks(self, disks): self.disks = disks
    def get_users(self): return self.users
    def set_users(self, users): self.users = users
    def hasContent_(self):
        if (
            self.data_center is not None or
            self.vms is not None or
            self.disks is not None or
            self.users is not None or
            super(Quota, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Quota', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Quota')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Quota'):
        super(Quota, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Quota')
    def exportChildren(self, outfile, level, namespace_='', name_='Quota', fromsubclass_=False, pretty_print=True):
        super(Quota, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.data_center is not None:
            self.data_center.export(outfile, level, namespace_, name_='data_center', pretty_print=pretty_print)
        if self.vms is not None:
            self.vms.export(outfile, level, namespace_, name_='vms', pretty_print=pretty_print)
        if self.disks is not None:
            self.disks.export(outfile, level, namespace_, name_='disks', pretty_print=pretty_print)
        if self.users is not None:
            self.users.export(outfile, level, namespace_, name_='users', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Quota'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Quota, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Quota, self).exportLiteralChildren(outfile, level, name_)
        if self.data_center is not None:
            showIndent(outfile, level)
            outfile.write('data_center=model_.data_center(\n')
            self.data_center.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vms is not None:
            showIndent(outfile, level)
            outfile.write('vms=model_.vms(\n')
            self.vms.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.disks is not None:
            showIndent(outfile, level)
            outfile.write('disks=model_.disks(\n')
            self.disks.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.users is not None:
            showIndent(outfile, level)
            outfile.write('users=model_.users(\n')
            self.users.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Quota, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'data_center':
            obj_ = DataCenter.factory()
            obj_.build(child_)
            self.set_data_center(obj_)
        elif nodeName_ == 'vms':
            obj_ = VMs.factory()
            obj_.build(child_)
            self.set_vms(obj_)
        elif nodeName_ == 'disks':
            obj_ = Disks.factory()
            obj_.build(child_)
            self.set_disks(obj_)
        elif nodeName_ == 'users':
            obj_ = Users.factory()
            obj_.build(child_)
            self.set_users(obj_)
        super(Quota, self).buildChildren(child_, node, nodeName_, True)
# end class Quota


class Quotas(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, quota=None):
        super(Quotas, self).__init__(actions, total, active, )
        if quota is None:
            self.quota = []
        else:
            self.quota = quota
    def factory(*args_, **kwargs_):
        if Quotas.subclass:
            return Quotas.subclass(*args_, **kwargs_)
        else:
            return Quotas(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_quota(self): return self.quota
    def set_quota(self, quota): self.quota = quota
    def add_quota(self, value): self.quota.append(value)
    def insert_quota(self, index, value): self.quota[index] = value
    def hasContent_(self):
        if (
            self.quota or
            super(Quotas, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Quotas', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Quotas')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Quotas'):
        super(Quotas, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Quotas')
    def exportChildren(self, outfile, level, namespace_='', name_='Quotas', fromsubclass_=False, pretty_print=True):
        super(Quotas, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for quota_ in self.quota:
            quota_.export(outfile, level, namespace_, name_='quota', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Quotas'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Quotas, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Quotas, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('quota=[\n')
        level += 1
        for quota_ in self.quota:
            showIndent(outfile, level)
            outfile.write('model_.quota(\n')
            quota_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Quotas, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'quota':
            obj_ = Quota.factory()
            obj_.build(child_)
            self.quota.append(obj_)
        super(Quotas, self).buildChildren(child_, node, nodeName_, True)
# end class Quotas


class Url(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, parameters_set=None):
        if parameters_set is None:
            self.parameters_set = []
        else:
            self.parameters_set = parameters_set
    def factory(*args_, **kwargs_):
        if Url.subclass:
            return Url.subclass(*args_, **kwargs_)
        else:
            return Url(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_parameters_set(self): return self.parameters_set
    def set_parameters_set(self, parameters_set): self.parameters_set = parameters_set
    def add_parameters_set(self, value): self.parameters_set.append(value)
    def insert_parameters_set(self, index, value): self.parameters_set[index] = value
    def hasContent_(self):
        if (
            self.parameters_set
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Url', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Url')
        if self.hasContent_():
            outfile.write('>%s'