#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Wed Aug 27 18:00:48 2014 by generateDS.py version 2.12a.
#

import sys
import getopt
import re as re_
import base64
import datetime as datetime_

# Begin NOT_GENERATED
from ovirtsdk.utils.reflectionhelper import ReflectionHelper
from ovirtsdk.utils.comperator import Comparator
# End NOT_GENERATED

etree_ = None
Verbose_import_ = False
(
    XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")


def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
            'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))
        # Begin NOT_GENERATED
        def __setattr__(self, item, value):
            if (value is not None and
                not isinstance(value, list) and
                ReflectionHelper.isModuleMember(
                    sys.modules['ovirtsdk.infrastructure.brokers'],
                    type(value)) and
                not ReflectionHelper.isModuleMember(sys.modules[__name__],
                    type(value)) and
                value.__dict__.has_key('superclass') and
                value.superclass is not None and
                value.superclass != BaseResource):
                if (ReflectionHelper.isModuleMember(
                        sys.modules['ovirtsdk.infrastructure.brokers'],
                        type(self)) and
                   self.__dict__.has_key('superclass') and
                   self.superclass is not None):
                    object.__setattr__(self.superclass, item, value.superclass)
                else:
                    object.__setattr__(self, item, value.superclass)
            elif (not isinstance(value, list) and
                 ReflectionHelper.isModuleMember(
                         sys.modules['ovirtsdk.infrastructure.brokers'],
                         type(self)) and
                 self.__dict__.has_key('superclass') and
                 self.superclass is not None and
                 not ReflectionHelper.isModuleMember(
                         sys.modules['ovirtsdk.infrastructure.brokers'],
                         type(value)) and
                 item is not 'superclass' and
                 item is not 'parentclass'):
                object.__setattr__(self.superclass, item, value)
            elif isinstance(value, list):
                parsed_list = []
                for obj in value:
                    if (ReflectionHelper.isModuleMember(
                            sys.modules['ovirtsdk.infrastructure.brokers'],
                            type(obj)) and
                       obj.__dict__.has_key('superclass') and
                       obj.superclass is not None and
                       item is not 'superclass' and
                       item is not 'parentclass'):
                        parsed_list.append(obj.superclass)
                    else:
                        parsed_list.append(obj)
                object.__setattr__(self, item, parsed_list)
            else:
                object.__setattr__(self, item, value)

        def __eq__(self, other):
            return Comparator.compare(self, other)

        def __ne__(self, other):
            return not self.__eq__(other)
        # End NOT_GENERATED


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'UTF-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class KeyValuePair(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value
    def factory(*args_, **kwargs_):
        if KeyValuePair.subclass:
            return KeyValuePair.subclass(*args_, **kwargs_)
        else:
            return KeyValuePair(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_key(self): return self.key
    def set_key(self, key): self.key = key
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def hasContent_(self):
        if (
            self.key is not None or
            self.value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='KeyValuePair', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='KeyValuePair')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='KeyValuePair'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='KeyValuePair', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.key is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skey>%s</%skey>%s' % (namespace_, self.gds_format_string(quote_xml(self.key).encode(ExternalEncoding), input_name='key'), namespace_, eol_))
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(self.value).encode(ExternalEncoding), input_name='value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='KeyValuePair'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.key is not None:
            showIndent(outfile, level)
            outfile.write('key=%s,\n' % quote_python(self.key).encode(ExternalEncoding))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'key':
            key_ = child_.text
            key_ = self.gds_validate_string(key_, node, 'key')
            self.key = key_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
# end class KeyValuePair


class LinkCapabilities(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, searchable=None):
        self.searchable = searchable
    def factory(*args_, **kwargs_):
        if LinkCapabilities.subclass:
            return LinkCapabilities.subclass(*args_, **kwargs_)
        else:
            return LinkCapabilities(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_searchable(self): return self.searchable
    def set_searchable(self, searchable): self.searchable = searchable
    def hasContent_(self):
        if (
            self.searchable is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LinkCapabilities', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LinkCapabilities')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LinkCapabilities'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='LinkCapabilities', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.searchable is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssearchable>%s</%ssearchable>%s' % (namespace_, self.gds_format_boolean(self.searchable, input_name='searchable'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='LinkCapabilities'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.searchable is not None:
            showIndent(outfile, level)
            outfile.write('searchable=%s,\n' % self.searchable)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'searchable':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'searchable')
            self.searchable = ival_
# end class LinkCapabilities


class DetailedLinks(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, link=None):
        if link is None:
            self.link = []
        else:
            self.link = link
    def factory(*args_, **kwargs_):
        if DetailedLinks.subclass:
            return DetailedLinks.subclass(*args_, **kwargs_)
        else:
            return DetailedLinks(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_link(self): return self.link
    def set_link(self, link): self.link = link
    def add_link(self, value): self.link.append(value)
    def insert_link(self, index, value): self.link[index] = value
    def hasContent_(self):
        if (
            self.link
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DetailedLinks', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DetailedLinks')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DetailedLinks'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='DetailedLinks', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for link_ in self.link:
            link_.export(outfile, level, namespace_, name_='link', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='DetailedLinks'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('link=[\n')
        level += 1
        for link_ in self.link:
            showIndent(outfile, level)
            outfile.write('model_.DetailedLink(\n')
            link_.exportLiteral(outfile, level, name_='DetailedLink')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'link':
            class_obj_ = self.get_class_obj_(child_, DetailedLink)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.link.append(obj_)
# end class DetailedLinks


class Link(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, href=None, rel=None, extensiontype_=None):
        self.href = _cast(None, href)
        self.rel = _cast(None, rel)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if Link.subclass:
            return Link.subclass(*args_, **kwargs_)
        else:
            return Link(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_rel(self): return self.rel
    def set_rel(self, rel): self.rel = rel
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Link', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Link')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Link'):
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (self.gds_format_string(quote_attrib(self.href).encode(ExternalEncoding), input_name='href'), ))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            outfile.write(' rel=%s' % (self.gds_format_string(quote_attrib(self.rel).encode(ExternalEncoding), input_name='rel'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='Link', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='Link'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            showIndent(outfile, level)
            outfile.write('href="%s",\n' % (self.href,))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            showIndent(outfile, level)
            outfile.write('rel="%s",\n' % (self.rel,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('rel', node)
        if value is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            self.rel = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Link


class ApiSummary(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vms=None, hosts=None, users=None, storage_domains=None):
        self.vms = vms
        self.hosts = hosts
        self.users = users
        self.storage_domains = storage_domains
    def factory(*args_, **kwargs_):
        if ApiSummary.subclass:
            return ApiSummary.subclass(*args_, **kwargs_)
        else:
            return ApiSummary(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vms(self): return self.vms
    def set_vms(self, vms): self.vms = vms
    def get_hosts(self): return self.hosts
    def set_hosts(self, hosts): self.hosts = hosts
    def get_users(self): return self.users
    def set_users(self, users): self.users = users
    def get_storage_domains(self): return self.storage_domains
    def set_storage_domains(self, storage_domains): self.storage_domains = storage_domains
    def hasContent_(self):
        if (
            self.vms is not None or
            self.hosts is not None or
            self.users is not None or
            self.storage_domains is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ApiSummary', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ApiSummary')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ApiSummary'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ApiSummary', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.vms is not None:
            self.vms.export(outfile, level, namespace_, name_='vms', pretty_print=pretty_print)
        if self.hosts is not None:
            self.hosts.export(outfile, level, namespace_, name_='hosts', pretty_print=pretty_print)
        if self.users is not None:
            self.users.export(outfile, level, namespace_, name_='users', pretty_print=pretty_print)
        if self.storage_domains is not None:
            self.storage_domains.export(outfile, level, namespace_, name_='storage_domains', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ApiSummary'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.vms is not None:
            showIndent(outfile, level)
            outfile.write('vms=model_.vms(\n')
            self.vms.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.hosts is not None:
            showIndent(outfile, level)
            outfile.write('hosts=model_.hosts(\n')
            self.hosts.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.users is not None:
            showIndent(outfile, level)
            outfile.write('users=model_.users(\n')
            self.users.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.storage_domains is not None:
            showIndent(outfile, level)
            outfile.write('storage_domains=model_.storage_domains(\n')
            self.storage_domains.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vms':
            obj_ = VMs.factory()
            obj_.build(child_)
            self.vms = obj_
        elif nodeName_ == 'hosts':
            obj_ = Hosts.factory()
            obj_.build(child_)
            self.hosts = obj_
        elif nodeName_ == 'users':
            obj_ = Users.factory()
            obj_.build(child_)
            self.users = obj_
        elif nodeName_ == 'storage_domains':
            obj_ = StorageDomains.factory()
            obj_.build(child_)
            self.storage_domains = obj_
# end class ApiSummary


class Fault(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, reason=None, detail=None):
        self.reason = reason
        self.detail = detail
    def factory(*args_, **kwargs_):
        if Fault.subclass:
            return Fault.subclass(*args_, **kwargs_)
        else:
            return Fault(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_reason(self): return self.reason
    def set_reason(self, reason): self.reason = reason
    def get_detail(self): return self.detail
    def set_detail(self, detail): self.detail = detail
    def hasContent_(self):
        if (
            self.reason is not None or
            self.detail is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Fault', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Fault')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Fault'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Fault', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.reason is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreason>%s</%sreason>%s' % (namespace_, self.gds_format_string(quote_xml(self.reason).encode(ExternalEncoding), input_name='reason'), namespace_, eol_))
        if self.detail is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetail>%s</%sdetail>%s' % (namespace_, self.gds_format_string(quote_xml(self.detail).encode(ExternalEncoding), input_name='detail'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Fault'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.reason is not None:
            showIndent(outfile, level)
            outfile.write('reason=%s,\n' % quote_python(self.reason).encode(ExternalEncoding))
        if self.detail is not None:
            showIndent(outfile, level)
            outfile.write('detail=%s,\n' % quote_python(self.detail).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'reason':
            reason_ = child_.text
            reason_ = self.gds_validate_string(reason_, node, 'reason')
            self.reason = reason_
        elif nodeName_ == 'detail':
            detail_ = child_.text
            detail_ = self.gds_validate_string(detail_, node, 'detail')
            self.detail = detail_
# end class Fault


class UsageMessage(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, message=None, detailedLink=None):
        self.message = message
        self.detailedLink = detailedLink
    def factory(*args_, **kwargs_):
        if UsageMessage.subclass:
            return UsageMessage.subclass(*args_, **kwargs_)
        else:
            return UsageMessage(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_message(self): return self.message
    def set_message(self, message): self.message = message
    def get_detailedLink(self): return self.detailedLink
    def set_detailedLink(self, detailedLink): self.detailedLink = detailedLink
    def hasContent_(self):
        if (
            self.message is not None or
            self.detailedLink is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='UsageMessage', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='UsageMessage')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='UsageMessage'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='UsageMessage', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.message is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smessage>%s</%smessage>%s' % (namespace_, self.gds_format_string(quote_xml(self.message).encode(ExternalEncoding), input_name='message'), namespace_, eol_))
        if self.detailedLink is not None:
            self.detailedLink.export(outfile, level, namespace_, name_='detailedLink', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='UsageMessage'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.message is not None:
            showIndent(outfile, level)
            outfile.write('message=%s,\n' % quote_python(self.message).encode(ExternalEncoding))
        if self.detailedLink is not None:
            showIndent(outfile, level)
            outfile.write('detailedLink=model_.detailedLink(\n')
            self.detailedLink.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'message':
            message_ = child_.text
            message_ = self.gds_validate_string(message_, node, 'message')
            self.message = message_
        elif nodeName_ == 'detailedLink':
            class_obj_ = self.get_class_obj_(child_, DetailedLink)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.detailedLink = obj_
# end class UsageMessage


class GracePeriod(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, expiry=None):
        self.expiry = expiry
    def factory(*args_, **kwargs_):
        if GracePeriod.subclass:
            return GracePeriod.subclass(*args_, **kwargs_)
        else:
            return GracePeriod(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_expiry(self): return self.expiry
    def set_expiry(self, expiry): self.expiry = expiry
    def hasContent_(self):
        if (
            self.expiry is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GracePeriod', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GracePeriod')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GracePeriod'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='GracePeriod', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.expiry is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sexpiry>%s</%sexpiry>%s' % (namespace_, self.gds_format_integer(self.expiry, input_name='expiry'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='GracePeriod'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.expiry is not None:
            showIndent(outfile, level)
            outfile.write('expiry=%d,\n' % self.expiry)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'expiry':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'expiry')
            self.expiry = ival_
# end class GracePeriod


class IscsiDetails(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, initiator=None, port=None, target=None, username=None, password=None, portal=None, address=None, serial=None, vendor_id=None, product_id=None, lun_mapping=None, size=None, paths=None, status=None, volume_group_id=None, storage_domain_id=None, disk_id=None):
        self.initiator = initiator
        self.port = port
        self.target = target
        self.username = username
        self.password = password
        self.portal = portal
        self.address = address
        self.serial = serial
        self.vendor_id = vendor_id
        self.product_id = product_id
        self.lun_mapping = lun_mapping
        self.size = size
        self.paths = paths
        self.status = status
        self.volume_group_id = volume_group_id
        self.storage_domain_id = storage_domain_id
        self.disk_id = disk_id
    def factory(*args_, **kwargs_):
        if IscsiDetails.subclass:
            return IscsiDetails.subclass(*args_, **kwargs_)
        else:
            return IscsiDetails(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_initiator(self): return self.initiator
    def set_initiator(self, initiator): self.initiator = initiator
    def get_port(self): return self.port
    def set_port(self, port): self.port = port
    def get_target(self): return self.target
    def set_target(self, target): self.target = target
    def get_username(self): return self.username
    def set_username(self, username): self.username = username
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_portal(self): return self.portal
    def set_portal(self, portal): self.portal = portal
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_serial(self): return self.serial
    def set_serial(self, serial): self.serial = serial
    def get_vendor_id(self): return self.vendor_id
    def set_vendor_id(self, vendor_id): self.vendor_id = vendor_id
    def get_product_id(self): return self.product_id
    def set_product_id(self, product_id): self.product_id = product_id
    def get_lun_mapping(self): return self.lun_mapping
    def set_lun_mapping(self, lun_mapping): self.lun_mapping = lun_mapping
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def get_paths(self): return self.paths
    def set_paths(self, paths): self.paths = paths
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_volume_group_id(self): return self.volume_group_id
    def set_volume_group_id(self, volume_group_id): self.volume_group_id = volume_group_id
    def get_storage_domain_id(self): return self.storage_domain_id
    def set_storage_domain_id(self, storage_domain_id): self.storage_domain_id = storage_domain_id
    def get_disk_id(self): return self.disk_id
    def set_disk_id(self, disk_id): self.disk_id = disk_id
    def hasContent_(self):
        if (
            self.initiator is not None or
            self.port is not None or
            self.target is not None or
            self.username is not None or
            self.password is not None or
            self.portal is not None or
            self.address is not None or
            self.serial is not None or
            self.vendor_id is not None or
            self.product_id is not None or
            self.lun_mapping is not None or
            self.size is not None or
            self.paths is not None or
            self.status is not None or
            self.volume_group_id is not None or
            self.storage_domain_id is not None or
            self.disk_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IscsiDetails', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IscsiDetails')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IscsiDetails'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='IscsiDetails', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.initiator is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinitiator>%s</%sinitiator>%s' % (namespace_, self.gds_format_string(quote_xml(self.initiator).encode(ExternalEncoding), input_name='initiator'), namespace_, eol_))
        if self.port is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sport>%s</%sport>%s' % (namespace_, self.gds_format_integer(self.port, input_name='port'), namespace_, eol_))
        if self.target is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%starget>%s</%starget>%s' % (namespace_, self.gds_format_string(quote_xml(self.target).encode(ExternalEncoding), input_name='target'), namespace_, eol_))
        if self.username is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%susername>%s</%susername>%s' % (namespace_, self.gds_format_string(quote_xml(self.username).encode(ExternalEncoding), input_name='username'), namespace_, eol_))
        if self.password is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespace_, self.gds_format_string(quote_xml(self.password).encode(ExternalEncoding), input_name='password'), namespace_, eol_))
        if self.portal is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sportal>%s</%sportal>%s' % (namespace_, self.gds_format_string(quote_xml(self.portal).encode(ExternalEncoding), input_name='portal'), namespace_, eol_))
        if self.address is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress>%s</%saddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_, eol_))
        if self.serial is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sserial>%s</%sserial>%s' % (namespace_, self.gds_format_string(quote_xml(self.serial).encode(ExternalEncoding), input_name='serial'), namespace_, eol_))
        if self.vendor_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svendor_id>%s</%svendor_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.vendor_id).encode(ExternalEncoding), input_name='vendor_id'), namespace_, eol_))
        if self.product_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sproduct_id>%s</%sproduct_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.product_id).encode(ExternalEncoding), input_name='product_id'), namespace_, eol_))
        if self.lun_mapping is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slun_mapping>%s</%slun_mapping>%s' % (namespace_, self.gds_format_integer(self.lun_mapping, input_name='lun_mapping'), namespace_, eol_))
        if self.size is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssize>%s</%ssize>%s' % (namespace_, self.gds_format_integer(self.size, input_name='size'), namespace_, eol_))
        if self.paths is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spaths>%s</%spaths>%s' % (namespace_, self.gds_format_integer(self.paths, input_name='paths'), namespace_, eol_))
        if self.status is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstatus>%s</%sstatus>%s' % (namespace_, self.gds_format_string(quote_xml(self.status).encode(ExternalEncoding), input_name='status'), namespace_, eol_))
        if self.volume_group_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svolume_group_id>%s</%svolume_group_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.volume_group_id).encode(ExternalEncoding), input_name='volume_group_id'), namespace_, eol_))
        if self.storage_domain_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstorage_domain_id>%s</%sstorage_domain_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.storage_domain_id).encode(ExternalEncoding), input_name='storage_domain_id'), namespace_, eol_))
        if self.disk_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisk_id>%s</%sdisk_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.disk_id).encode(ExternalEncoding), input_name='disk_id'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='IscsiDetails'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.initiator is not None:
            showIndent(outfile, level)
            outfile.write('initiator=%s,\n' % quote_python(self.initiator).encode(ExternalEncoding))
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('port=%d,\n' % self.port)
        if self.target is not None:
            showIndent(outfile, level)
            outfile.write('target=%s,\n' % quote_python(self.target).encode(ExternalEncoding))
        if self.username is not None:
            showIndent(outfile, level)
            outfile.write('username=%s,\n' % quote_python(self.username).encode(ExternalEncoding))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % quote_python(self.password).encode(ExternalEncoding))
        if self.portal is not None:
            showIndent(outfile, level)
            outfile.write('portal=%s,\n' % quote_python(self.portal).encode(ExternalEncoding))
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.serial is not None:
            showIndent(outfile, level)
            outfile.write('serial=%s,\n' % quote_python(self.serial).encode(ExternalEncoding))
        if self.vendor_id is not None:
            showIndent(outfile, level)
            outfile.write('vendor_id=%s,\n' % quote_python(self.vendor_id).encode(ExternalEncoding))
        if self.product_id is not None:
            showIndent(outfile, level)
            outfile.write('product_id=%s,\n' % quote_python(self.product_id).encode(ExternalEncoding))
        if self.lun_mapping is not None:
            showIndent(outfile, level)
            outfile.write('lun_mapping=%d,\n' % self.lun_mapping)
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % self.size)
        if self.paths is not None:
            showIndent(outfile, level)
            outfile.write('paths=%d,\n' % self.paths)
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=%s,\n' % quote_python(self.status).encode(ExternalEncoding))
        if self.volume_group_id is not None:
            showIndent(outfile, level)
            outfile.write('volume_group_id=%s,\n' % quote_python(self.volume_group_id).encode(ExternalEncoding))
        if self.storage_domain_id is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain_id=%s,\n' % quote_python(self.storage_domain_id).encode(ExternalEncoding))
        if self.disk_id is not None:
            showIndent(outfile, level)
            outfile.write('disk_id=%s,\n' % quote_python(self.disk_id).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'initiator':
            initiator_ = child_.text
            initiator_ = self.gds_validate_string(initiator_, node, 'initiator')
            self.initiator = initiator_
        elif nodeName_ == 'port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'port')
            self.port = ival_
        elif nodeName_ == 'target':
            target_ = child_.text
            target_ = self.gds_validate_string(target_, node, 'target')
            self.target = target_
        elif nodeName_ == 'username':
            username_ = child_.text
            username_ = self.gds_validate_string(username_, node, 'username')
            self.username = username_
        elif nodeName_ == 'password':
            password_ = child_.text
            password_ = self.gds_validate_string(password_, node, 'password')
            self.password = password_
        elif nodeName_ == 'portal':
            portal_ = child_.text
            portal_ = self.gds_validate_string(portal_, node, 'portal')
            self.portal = portal_
        elif nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'serial':
            serial_ = child_.text
            serial_ = self.gds_validate_string(serial_, node, 'serial')
            self.serial = serial_
        elif nodeName_ == 'vendor_id':
            vendor_id_ = child_.text
            vendor_id_ = self.gds_validate_string(vendor_id_, node, 'vendor_id')
            self.vendor_id = vendor_id_
        elif nodeName_ == 'product_id':
            product_id_ = child_.text
            product_id_ = self.gds_validate_string(product_id_, node, 'product_id')
            self.product_id = product_id_
        elif nodeName_ == 'lun_mapping':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'lun_mapping')
            self.lun_mapping = ival_
        elif nodeName_ == 'size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'size')
            self.size = ival_
        elif nodeName_ == 'paths':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'paths')
            self.paths = ival_
        elif nodeName_ == 'status':
            status_ = child_.text
            status_ = self.gds_validate_string(status_, node, 'status')
            self.status = status_
        elif nodeName_ == 'volume_group_id':
            volume_group_id_ = child_.text
            volume_group_id_ = self.gds_validate_string(volume_group_id_, node, 'volume_group_id')
            self.volume_group_id = volume_group_id_
        elif nodeName_ == 'storage_domain_id':
            storage_domain_id_ = child_.text
            storage_domain_id_ = self.gds_validate_string(storage_domain_id_, node, 'storage_domain_id')
            self.storage_domain_id = storage_domain_id_
        elif nodeName_ == 'disk_id':
            disk_id_ = child_.text
            disk_id_ = self.gds_validate_string(disk_id_, node, 'disk_id')
            self.disk_id = disk_id_
# end class IscsiDetails


class Actions(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, link=None):
        if link is None:
            self.link = []
        else:
            self.link = link
    def factory(*args_, **kwargs_):
        if Actions.subclass:
            return Actions.subclass(*args_, **kwargs_)
        else:
            return Actions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_link(self): return self.link
    def set_link(self, link): self.link = link
    def add_link(self, value): self.link.append(value)
    def insert_link(self, index, value): self.link[index] = value
    def hasContent_(self):
        if (
            self.link
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Actions', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Actions')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Actions'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Actions', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for link_ in self.link:
            link_.export(outfile, level, namespace_, name_='link', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Actions'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('link=[\n')
        level += 1
        for link_ in self.link:
            showIndent(outfile, level)
            outfile.write('model_.link(\n')
            link_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'link':
            class_obj_ = self.get_class_obj_(child_, Link)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.link.append(obj_)
# end class Actions


class Status(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, state=None, detail=None):
        self.state = state
        self.detail = detail
    def factory(*args_, **kwargs_):
        if Status.subclass:
            return Status.subclass(*args_, **kwargs_)
        else:
            return Status(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def get_detail(self): return self.detail
    def set_detail(self, detail): self.detail = detail
    def hasContent_(self):
        if (
            self.state is not None or
            self.detail is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Status', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Status')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Status'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Status', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.state is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstate>%s</%sstate>%s' % (namespace_, self.gds_format_string(quote_xml(self.state).encode(ExternalEncoding), input_name='state'), namespace_, eol_))
        if self.detail is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetail>%s</%sdetail>%s' % (namespace_, self.gds_format_string(quote_xml(self.detail).encode(ExternalEncoding), input_name='detail'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Status'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.state is not None:
            showIndent(outfile, level)
            outfile.write('state=%s,\n' % quote_python(self.state).encode(ExternalEncoding))
        if self.detail is not None:
            showIndent(outfile, level)
            outfile.write('detail=%s,\n' % quote_python(self.detail).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'state':
            state_ = child_.text
            state_ = self.gds_validate_string(state_, node, 'state')
            self.state = state_
        elif nodeName_ == 'detail':
            detail_ = child_.text
            detail_ = self.gds_validate_string(detail_, node, 'detail')
            self.detail = detail_
# end class Status


class Usages(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, usage=None):
        if usage is None:
            self.usage = []
        else:
            self.usage = usage
    def factory(*args_, **kwargs_):
        if Usages.subclass:
            return Usages.subclass(*args_, **kwargs_)
        else:
            return Usages(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_usage(self): return self.usage
    def set_usage(self, usage): self.usage = usage
    def add_usage(self, value): self.usage.append(value)
    def insert_usage(self, index, value): self.usage[index] = value
    def hasContent_(self):
        if (
            self.usage
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Usages', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Usages')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Usages'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Usages', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for usage_ in self.usage:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%susage>%s</%susage>%s' % (namespace_, self.gds_format_string(quote_xml(usage_).encode(ExternalEncoding), input_name='usage'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Usages'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('usage=[\n')
        level += 1
        for usage_ in self.usage:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(usage_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'usage':
            usage_ = child_.text
            usage_ = self.gds_validate_string(usage_, node, 'usage')
            self.usage.append(usage_)
# end class Usages


class CreationStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, creation_state=None):
        if creation_state is None:
            self.creation_state = []
        else:
            self.creation_state = creation_state
    def factory(*args_, **kwargs_):
        if CreationStates.subclass:
            return CreationStates.subclass(*args_, **kwargs_)
        else:
            return CreationStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_creation_state(self): return self.creation_state
    def set_creation_state(self, creation_state): self.creation_state = creation_state
    def add_creation_state(self, value): self.creation_state.append(value)
    def insert_creation_state(self, index, value): self.creation_state[index] = value
    def hasContent_(self):
        if (
            self.creation_state
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CreationStates', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CreationStates')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CreationStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='CreationStates', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for creation_state_ in self.creation_state:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%screation_state>%s</%screation_state>%s' % (namespace_, self.gds_format_string(quote_xml(creation_state_).encode(ExternalEncoding), input_name='creation_state'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='CreationStates'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('creation_state=[\n')
        level += 1
        for creation_state_ in self.creation_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(creation_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'creation_state':
            creation_state_ = child_.text
            creation_state_ = self.gds_validate_string(creation_state_, node, 'creation_state')
            self.creation_state.append(creation_state_)
# end class CreationStates


class Value(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, datum=None, detail=None):
        self.datum = datum
        self.detail = detail
    def factory(*args_, **kwargs_):
        if Value.subclass:
            return Value.subclass(*args_, **kwargs_)
        else:
            return Value(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datum(self): return self.datum
    def set_datum(self, datum): self.datum = datum
    def get_detail(self): return self.detail
    def set_detail(self, detail): self.detail = detail
    def hasContent_(self):
        if (
            self.datum is not None or
            self.detail is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Value', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Value')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Value'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Value', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.datum is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdatum>%s</%sdatum>%s' % (namespace_, self.gds_format_float(self.datum, input_name='datum'), namespace_, eol_))
        if self.detail is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetail>%s</%sdetail>%s' % (namespace_, self.gds_format_string(quote_xml(self.detail).encode(ExternalEncoding), input_name='detail'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Value'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.datum is not None:
            showIndent(outfile, level)
            outfile.write('datum=%f,\n' % self.datum)
        if self.detail is not None:
            showIndent(outfile, level)
            outfile.write('detail=%s,\n' % quote_python(self.detail).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'datum':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'datum')
            self.datum = fval_
        elif nodeName_ == 'detail':
            detail_ = child_.text
            detail_ = self.gds_validate_string(detail_, node, 'detail')
            self.detail = detail_
# end class Value


class Values(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, value=None):
        self.type_ = _cast(None, type_)
        if value is None:
            self.value = []
        else:
            self.value = value
    def factory(*args_, **kwargs_):
        if Values.subclass:
            return Values.subclass(*args_, **kwargs_)
        else:
            return Values(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def add_value(self, value): self.value.append(value)
    def insert_value(self, index, value): self.value[index] = value
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def validate_ValueType(self, value):
        # Validate type ValueType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.value
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Values', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Values')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Values'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Values', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for value_ in self.value:
            value_.export(outfile, level, namespace_, name_='value', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Values'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('value=[\n')
        level += 1
        for value_ in self.value:
            showIndent(outfile, level)
            outfile.write('model_.value(\n')
            value_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
            self.validate_ValueType(self.type_)    # validate type ValueType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'value':
            obj_ = Value.factory()
            obj_.build(child_)
            self.value.append(obj_)
# end class Values


class CpuTopology(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, cores=None, threads=None, sockets=None):
        self.cores = _cast(int, cores)
        self.threads = _cast(int, threads)
        self.sockets = _cast(int, sockets)
        pass
    def factory(*args_, **kwargs_):
        if CpuTopology.subclass:
            return CpuTopology.subclass(*args_, **kwargs_)
        else:
            return CpuTopology(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cores(self): return self.cores
    def set_cores(self, cores): self.cores = cores
    def get_threads(self): return self.threads
    def set_threads(self, threads): self.threads = threads
    def get_sockets(self): return self.sockets
    def set_sockets(self, sockets): self.sockets = sockets
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CpuTopology', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CpuTopology')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CpuTopology'):
        if self.cores is not None and 'cores' not in already_processed:
            already_processed.add('cores')
            outfile.write(' cores="%s"' % self.gds_format_integer(self.cores, input_name='cores'))
        if self.threads is not None and 'threads' not in already_processed:
            already_processed.add('threads')
            outfile.write(' threads="%s"' % self.gds_format_integer(self.threads, input_name='threads'))
        if self.sockets is not None and 'sockets' not in already_processed:
            already_processed.add('sockets')
            outfile.write(' sockets="%s"' % self.gds_format_integer(self.sockets, input_name='sockets'))
    def exportChildren(self, outfile, level, namespace_='', name_='CpuTopology', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='CpuTopology'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.cores is not None and 'cores' not in already_processed:
            already_processed.add('cores')
            showIndent(outfile, level)
            outfile.write('cores=%d,\n' % (self.cores,))
        if self.threads is not None and 'threads' not in already_processed:
            already_processed.add('threads')
            showIndent(outfile, level)
            outfile.write('threads=%d,\n' % (self.threads,))
        if self.sockets is not None and 'sockets' not in already_processed:
            already_processed.add('sockets')
            showIndent(outfile, level)
            outfile.write('sockets=%d,\n' % (self.sockets,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('cores', node)
        if value is not None and 'cores' not in already_processed:
            already_processed.add('cores')
            try:
                self.cores = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('threads', node)
        if value is not None and 'threads' not in already_processed:
            already_processed.add('threads')
            try:
                self.threads = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('sockets', node)
        if value is not None and 'sockets' not in already_processed:
            already_processed.add('sockets')
            try:
                self.sockets = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class CpuTopology


class VCpuPin(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vcpu=None, cpu_set=None):
        self.vcpu = _cast(int, vcpu)
        self.cpu_set = _cast(None, cpu_set)
        pass
    def factory(*args_, **kwargs_):
        if VCpuPin.subclass:
            return VCpuPin.subclass(*args_, **kwargs_)
        else:
            return VCpuPin(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vcpu(self): return self.vcpu
    def set_vcpu(self, vcpu): self.vcpu = vcpu
    def get_cpu_set(self): return self.cpu_set
    def set_cpu_set(self, cpu_set): self.cpu_set = cpu_set
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VCpuPin', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VCpuPin')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VCpuPin'):
        if self.vcpu is not None and 'vcpu' not in already_processed:
            already_processed.add('vcpu')
            outfile.write(' vcpu="%s"' % self.gds_format_integer(self.vcpu, input_name='vcpu'))
        if self.cpu_set is not None and 'cpu_set' not in already_processed:
            already_processed.add('cpu_set')
            outfile.write(' cpu_set=%s' % (self.gds_format_string(quote_attrib(self.cpu_set).encode(ExternalEncoding), input_name='cpu_set'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='VCpuPin', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='VCpuPin'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.vcpu is not None and 'vcpu' not in already_processed:
            already_processed.add('vcpu')
            showIndent(outfile, level)
            outfile.write('vcpu=%d,\n' % (self.vcpu,))
        if self.cpu_set is not None and 'cpu_set' not in already_processed:
            already_processed.add('cpu_set')
            showIndent(outfile, level)
            outfile.write('cpu_set="%s",\n' % (self.cpu_set,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('vcpu', node)
        if value is not None and 'vcpu' not in already_processed:
            already_processed.add('vcpu')
            try:
                self.vcpu = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('cpu_set', node)
        if value is not None and 'cpu_set' not in already_processed:
            already_processed.add('cpu_set')
            self.cpu_set = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class VCpuPin


class CpuTune(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vcpu_pin=None):
        if vcpu_pin is None:
            self.vcpu_pin = []
        else:
            self.vcpu_pin = vcpu_pin
    def factory(*args_, **kwargs_):
        if CpuTune.subclass:
            return CpuTune.subclass(*args_, **kwargs_)
        else:
            return CpuTune(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vcpu_pin(self): return self.vcpu_pin
    def set_vcpu_pin(self, vcpu_pin): self.vcpu_pin = vcpu_pin
    def add_vcpu_pin(self, value): self.vcpu_pin.append(value)
    def insert_vcpu_pin(self, index, value): self.vcpu_pin[index] = value
    def hasContent_(self):
        if (
            self.vcpu_pin
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CpuTune', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CpuTune')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CpuTune'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='CpuTune', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for vcpu_pin_ in self.vcpu_pin:
            vcpu_pin_.export(outfile, level, namespace_, name_='vcpu_pin', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='CpuTune'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('vcpu_pin=[\n')
        level += 1
        for vcpu_pin_ in self.vcpu_pin:
            showIndent(outfile, level)
            outfile.write('model_.vcpu_pin(\n')
            vcpu_pin_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vcpu_pin':
            obj_ = VCpuPin.factory()
            obj_.build(child_)
            self.vcpu_pin.append(obj_)
# end class CpuTune


class CPU(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, topology=None, level=None, name=None, speed=None, cpu_tune=None, mode=None, architecture=None, cores=None):
        self.id = _cast(None, id)
        self.topology = topology
        self.level = level
        self.name = name
        self.speed = speed
        self.cpu_tune = cpu_tune
        self.mode = mode
        self.architecture = architecture
        self.cores = cores
    def factory(*args_, **kwargs_):
        if CPU.subclass:
            return CPU.subclass(*args_, **kwargs_)
        else:
            return CPU(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_topology(self): return self.topology
    def set_topology(self, topology): self.topology = topology
    def get_level(self): return self.level
    def set_level(self, level): self.level = level
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_speed(self): return self.speed
    def set_speed(self, speed): self.speed = speed
    def get_cpu_tune(self): return self.cpu_tune
    def set_cpu_tune(self, cpu_tune): self.cpu_tune = cpu_tune
    def get_mode(self): return self.mode
    def set_mode(self, mode): self.mode = mode
    def get_architecture(self): return self.architecture
    def set_architecture(self, architecture): self.architecture = architecture
    def get_cores(self): return self.cores
    def set_cores(self, cores): self.cores = cores
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def hasContent_(self):
        if (
            self.topology is not None or
            self.level is not None or
            self.name is not None or
            self.speed is not None or
            self.cpu_tune is not None or
            self.mode is not None or
            self.architecture is not None or
            self.cores is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CPU', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CPU')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CPU'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='CPU', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.topology is not None:
            self.topology.export(outfile, level, namespace_, name_='topology', pretty_print=pretty_print)
        if self.level is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slevel>%s</%slevel>%s' % (namespace_, self.gds_format_integer(self.level, input_name='level'), namespace_, eol_))
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_, eol_))
        if self.speed is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sspeed>%s</%sspeed>%s' % (namespace_, self.gds_format_float(self.speed, input_name='speed'), namespace_, eol_))
        if self.cpu_tune is not None:
            self.cpu_tune.export(outfile, level, namespace_, name_='cpu_tune', pretty_print=pretty_print)
        if self.mode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smode>%s</%smode>%s' % (namespace_, self.gds_format_string(quote_xml(self.mode).encode(ExternalEncoding), input_name='mode'), namespace_, eol_))
        if self.architecture is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sarchitecture>%s</%sarchitecture>%s' % (namespace_, self.gds_format_string(quote_xml(self.architecture).encode(ExternalEncoding), input_name='architecture'), namespace_, eol_))
        if self.cores is not None:
            self.cores.export(outfile, level, namespace_, name_='cores', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='CPU'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.topology is not None:
            showIndent(outfile, level)
            outfile.write('topology=model_.CpuTopology(\n')
            self.topology.exportLiteral(outfile, level, name_='topology')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.level is not None:
            showIndent(outfile, level)
            outfile.write('level=%d,\n' % self.level)
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        if self.speed is not None:
            showIndent(outfile, level)
            outfile.write('speed=%f,\n' % self.speed)
        if self.cpu_tune is not None:
            showIndent(outfile, level)
            outfile.write('cpu_tune=model_.CpuTune(\n')
            self.cpu_tune.exportLiteral(outfile, level, name_='cpu_tune')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.mode is not None:
            showIndent(outfile, level)
            outfile.write('mode=%s,\n' % quote_python(self.mode).encode(ExternalEncoding))
        if self.architecture is not None:
            showIndent(outfile, level)
            outfile.write('architecture=%s,\n' % quote_python(self.architecture).encode(ExternalEncoding))
        if self.cores is not None:
            showIndent(outfile, level)
            outfile.write('cores=model_.Cores(\n')
            self.cores.exportLiteral(outfile, level, name_='cores')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'topology':
            obj_ = CpuTopology.factory()
            obj_.build(child_)
            self.topology = obj_
        elif nodeName_ == 'level':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'level')
            self.level = ival_
        elif nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'speed':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'speed')
            self.speed = fval_
        elif nodeName_ == 'cpu_tune':
            obj_ = CpuTune.factory()
            obj_.build(child_)
            self.cpu_tune = obj_
        elif nodeName_ == 'mode':
            mode_ = child_.text
            mode_ = self.gds_validate_string(mode_, node, 'mode')
            self.mode = mode_
        elif nodeName_ == 'architecture':
            architecture_ = child_.text
            architecture_ = self.gds_validate_string(architecture_, node, 'architecture')
            self.architecture = architecture_
        elif nodeName_ == 'cores':
            obj_ = Cores.factory()
            obj_.build(child_)
            self.cores = obj_
# end class CPU


class CPUs(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, cpu=None):
        if cpu is None:
            self.cpu = []
        else:
            self.cpu = cpu
    def factory(*args_, **kwargs_):
        if CPUs.subclass:
            return CPUs.subclass(*args_, **kwargs_)
        else:
            return CPUs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cpu(self): return self.cpu
    def set_cpu(self, cpu): self.cpu = cpu
    def add_cpu(self, value): self.cpu.append(value)
    def insert_cpu(self, index, value): self.cpu[index] = value
    def hasContent_(self):
        if (
            self.cpu
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CPUs', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CPUs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CPUs'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='CPUs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for cpu_ in self.cpu:
            cpu_.export(outfile, level, namespace_, name_='cpu', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='CPUs'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('cpu=[\n')
        level += 1
        for cpu_ in self.cpu:
            showIndent(outfile, level)
            outfile.write('model_.cpu(\n')
            cpu_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'cpu':
            obj_ = CPU.factory()
            obj_.build(child_)
            self.cpu.append(obj_)
# end class CPUs


class TemplateVersion(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, base_template=None, version_number=None, version_name=None):
        self.base_template = base_template
        self.version_number = version_number
        self.version_name = version_name
    def factory(*args_, **kwargs_):
        if TemplateVersion.subclass:
            return TemplateVersion.subclass(*args_, **kwargs_)
        else:
            return TemplateVersion(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_base_template(self): return self.base_template
    def set_base_template(self, base_template): self.base_template = base_template
    def get_version_number(self): return self.version_number
    def set_version_number(self, version_number): self.version_number = version_number
    def get_version_name(self): return self.version_name
    def set_version_name(self, version_name): self.version_name = version_name
    def hasContent_(self):
        if (
            self.base_template is not None or
            self.version_number is not None or
            self.version_name is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TemplateVersion', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TemplateVersion')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TemplateVersion'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='TemplateVersion', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.base_template is not None:
            self.base_template.export(outfile, level, namespace_, name_='base_template', pretty_print=pretty_print)
        if self.version_number is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion_number>%s</%sversion_number>%s' % (namespace_, self.gds_format_integer(self.version_number, input_name='version_number'), namespace_, eol_))
        if self.version_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion_name>%s</%sversion_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.version_name).encode(ExternalEncoding), input_name='version_name'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='TemplateVersion'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.base_template is not None:
            showIndent(outfile, level)
            outfile.write('base_template=model_.Template(\n')
            self.base_template.exportLiteral(outfile, level, name_='base_template')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.version_number is not None:
            showIndent(outfile, level)
            outfile.write('version_number=%d,\n' % self.version_number)
        if self.version_name is not None:
            showIndent(outfile, level)
            outfile.write('version_name=%s,\n' % quote_python(self.version_name).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'base_template':
            class_obj_ = self.get_class_obj_(child_, Template)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.base_template = obj_
        elif nodeName_ == 'version_number':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'version_number')
            self.version_number = ival_
        elif nodeName_ == 'version_name':
            version_name_ = child_.text
            version_name_ = self.gds_validate_string(version_name_, node, 'version_name')
            self.version_name = version_name_
# end class TemplateVersion


class SupportedVersions(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, version=None):
        if version is None:
            self.version = []
        else:
            self.version = version
    def factory(*args_, **kwargs_):
        if SupportedVersions.subclass:
            return SupportedVersions.subclass(*args_, **kwargs_)
        else:
            return SupportedVersions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def add_version(self, value): self.version.append(value)
    def insert_version(self, index, value): self.version[index] = value
    def hasContent_(self):
        if (
            self.version
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SupportedVersions', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SupportedVersions')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SupportedVersions'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='SupportedVersions', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for version_ in self.version:
            version_.export(outfile, level, namespace_, name_='version', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SupportedVersions'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('version=[\n')
        level += 1
        for version_ in self.version:
            showIndent(outfile, level)
            outfile.write('model_.Version(\n')
            version_.exportLiteral(outfile, level, name_='Version')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'version':
            class_obj_ = self.get_class_obj_(child_, Version)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.version.append(obj_)
# end class SupportedVersions


class ErrorHandling(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, on_error=None):
        self.on_error = on_error
    def factory(*args_, **kwargs_):
        if ErrorHandling.subclass:
            return ErrorHandling.subclass(*args_, **kwargs_)
        else:
            return ErrorHandling(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_on_error(self): return self.on_error
    def set_on_error(self, on_error): self.on_error = on_error
    def hasContent_(self):
        if (
            self.on_error is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ErrorHandling', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ErrorHandling')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ErrorHandling'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ErrorHandling', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.on_error is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%son_error>%s</%son_error>%s' % (namespace_, self.gds_format_string(quote_xml(self.on_error).encode(ExternalEncoding), input_name='on_error'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='ErrorHandling'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.on_error is not None:
            showIndent(outfile, level)
            outfile.write('on_error=%s,\n' % quote_python(self.on_error).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'on_error':
            on_error_ = child_.text
            on_error_ = self.gds_validate_string(on_error_, node, 'on_error')
            self.on_error = on_error_
# end class ErrorHandling


class Features(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, feature=None):
        if feature is None:
            self.feature = []
        else:
            self.feature = feature
    def factory(*args_, **kwargs_):
        if Features.subclass:
            return Features.subclass(*args_, **kwargs_)
        else:
            return Features(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_feature(self): return self.feature
    def set_feature(self, feature): self.feature = feature
    def add_feature(self, value): self.feature.append(value)
    def insert_feature(self, index, value): self.feature[index] = value
    def hasContent_(self):
        if (
            self.feature
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Features', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Features')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Features'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Features', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for feature_ in self.feature:
            feature_.export(outfile, level, namespace_, name_='feature', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Features'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('feature=[\n')
        level += 1
        for feature_ in self.feature:
            showIndent(outfile, level)
            outfile.write('model_.feature(\n')
            feature_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'feature':
            obj_ = Feature.factory()
            obj_.build(child_)
            self.feature.append(obj_)
# end class Features


class FenceTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, fence_type=None):
        if fence_type is None:
            self.fence_type = []
        else:
            self.fence_type = fence_type
    def factory(*args_, **kwargs_):
        if FenceTypes.subclass:
            return FenceTypes.subclass(*args_, **kwargs_)
        else:
            return FenceTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_fence_type(self): return self.fence_type
    def set_fence_type(self, fence_type): self.fence_type = fence_type
    def add_fence_type(self, value): self.fence_type.append(value)
    def insert_fence_type(self, index, value): self.fence_type[index] = value
    def hasContent_(self):
        if (
            self.fence_type
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='FenceTypes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FenceTypes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FenceTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='FenceTypes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for fence_type_ in self.fence_type:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfence_type>%s</%sfence_type>%s' % (namespace_, self.gds_format_string(quote_xml(fence_type_).encode(ExternalEncoding), input_name='fence_type'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='FenceTypes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('fence_type=[\n')
        level += 1
        for fence_type_ in self.fence_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(fence_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'fence_type':
            fence_type_ = child_.text
            fence_type_ = self.gds_validate_string(fence_type_, node, 'fence_type')
            self.fence_type.append(fence_type_)
# end class FenceTypes


class StorageTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, storage_type=None):
        if storage_type is None:
            self.storage_type = []
        else:
            self.storage_type = storage_type
    def factory(*args_, **kwargs_):
        if StorageTypes.subclass:
            return StorageTypes.subclass(*args_, **kwargs_)
        else:
            return StorageTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_storage_type(self): return self.storage_type
    def set_storage_type(self, storage_type): self.storage_type = storage_type
    def add_storage_type(self, value): self.storage_type.append(value)
    def insert_storage_type(self, index, value): self.storage_type[index] = value
    def hasContent_(self):
        if (
            self.storage_type
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StorageTypes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageTypes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='StorageTypes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for storage_type_ in self.storage_type:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstorage_type>%s</%sstorage_type>%s' % (namespace_, self.gds_format_string(quote_xml(storage_type_).encode(ExternalEncoding), input_name='storage_type'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='StorageTypes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('storage_type=[\n')
        level += 1
        for storage_type_ in self.storage_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(storage_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'storage_type':
            storage_type_ = child_.text
            storage_type_ = self.gds_validate_string(storage_type_, node, 'storage_type')
            self.storage_type.append(storage_type_)
# end class StorageTypes


class ConfigurationTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, configuration_type=None):
        if configuration_type is None:
            self.configuration_type = []
        else:
            self.configuration_type = configuration_type
    def factory(*args_, **kwargs_):
        if ConfigurationTypes.subclass:
            return ConfigurationTypes.subclass(*args_, **kwargs_)
        else:
            return ConfigurationTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_configuration_type(self): return self.configuration_type
    def set_configuration_type(self, configuration_type): self.configuration_type = configuration_type
    def add_configuration_type(self, value): self.configuration_type.append(value)
    def insert_configuration_type(self, index, value): self.configuration_type[index] = value
    def hasContent_(self):
        if (
            self.configuration_type
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ConfigurationTypes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ConfigurationTypes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ConfigurationTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ConfigurationTypes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for configuration_type_ in self.configuration_type:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sconfiguration_type>%s</%sconfiguration_type>%s' % (namespace_, self.gds_format_string(quote_xml(configuration_type_).encode(ExternalEncoding), input_name='configuration_type'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='ConfigurationTypes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('configuration_type=[\n')
        level += 1
        for configuration_type_ in self.configuration_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(configuration_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'configuration_type':
            configuration_type_ = child_.text
            configuration_type_ = self.gds_validate_string(configuration_type_, node, 'configuration_type')
            self.configuration_type.append(configuration_type_)
# end class ConfigurationTypes


class StorageDomainTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, storage_domain_type=None):
        if storage_domain_type is None:
            self.storage_domain_type = []
        else:
            self.storage_domain_type = storage_domain_type
    def factory(*args_, **kwargs_):
        if StorageDomainTypes.subclass:
            return StorageDomainTypes.subclass(*args_, **kwargs_)
        else:
            return StorageDomainTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_storage_domain_type(self): return self.storage_domain_type
    def set_storage_domain_type(self, storage_domain_type): self.storage_domain_type = storage_domain_type
    def add_storage_domain_type(self, value): self.storage_domain_type.append(value)
    def insert_storage_domain_type(self, index, value): self.storage_domain_type[index] = value
    def hasContent_(self):
        if (
            self.storage_domain_type
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StorageDomainTypes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageDomainTypes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageDomainTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='StorageDomainTypes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for storage_domain_type_ in self.storage_domain_type:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstorage_domain_type>%s</%sstorage_domain_type>%s' % (namespace_, self.gds_format_string(quote_xml(storage_domain_type_).encode(ExternalEncoding), input_name='storage_domain_type'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='StorageDomainTypes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('storage_domain_type=[\n')
        level += 1
        for storage_domain_type_ in self.storage_domain_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(storage_domain_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'storage_domain_type':
            storage_domain_type_ = child_.text
            storage_domain_type_ = self.gds_validate_string(storage_domain_type_, node, 'storage_domain_type')
            self.storage_domain_type.append(storage_domain_type_)
# end class StorageDomainTypes


class VmTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vm_type=None):
        if vm_type is None:
            self.vm_type = []
        else:
            self.vm_type = vm_type
    def factory(*args_, **kwargs_):
        if VmTypes.subclass:
            return VmTypes.subclass(*args_, **kwargs_)
        else:
            return VmTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vm_type(self): return self.vm_type
    def set_vm_type(self, vm_type): self.vm_type = vm_type
    def add_vm_type(self, value): self.vm_type.append(value)
    def insert_vm_type(self, index, value): self.vm_type[index] = value
    def hasContent_(self):
        if (
            self.vm_type
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VmTypes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmTypes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VmTypes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for vm_type_ in self.vm_type:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svm_type>%s</%svm_type>%s' % (namespace_, self.gds_format_string(quote_xml(vm_type_).encode(ExternalEncoding), input_name='vm_type'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='VmTypes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('vm_type=[\n')
        level += 1
        for vm_type_ in self.vm_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(vm_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vm_type':
            vm_type_ = child_.text
            vm_type_ = self.gds_validate_string(vm_type_, node, 'vm_type')
            self.vm_type.append(vm_type_)
# end class VmTypes


class BootDevices(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, boot_device=None):
        if boot_device is None:
            self.boot_device = []
        else:
            self.boot_device = boot_device
    def factory(*args_, **kwargs_):
        if BootDevices.subclass:
            return BootDevices.subclass(*args_, **kwargs_)
        else:
            return BootDevices(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_boot_device(self): return self.boot_device
    def set_boot_device(self, boot_device): self.boot_device = boot_device
    def add_boot_device(self, value): self.boot_device.append(value)
    def insert_boot_device(self, index, value): self.boot_device[index] = value
    def hasContent_(self):
        if (
            self.boot_device
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BootDevices', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BootDevices')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BootDevices'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='BootDevices', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for boot_device_ in self.boot_device:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sboot_device>%s</%sboot_device>%s' % (namespace_, self.gds_format_string(quote_xml(boot_device_).encode(ExternalEncoding), input_name='boot_device'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='BootDevices'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('boot_device=[\n')
        level += 1
        for boot_device_ in self.boot_device:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(boot_device_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'boot_device':
            boot_device_ = child_.text
            boot_device_ = self.gds_validate_string(boot_device_, node, 'boot_device')
            self.boot_device.append(boot_device_)
# end class BootDevices


class DisplayTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, display_type=None):
        if display_type is None:
            self.display_type = []
        else:
            self.display_type = display_type
    def factory(*args_, **kwargs_):
        if DisplayTypes.subclass:
            return DisplayTypes.subclass(*args_, **kwargs_)
        else:
            return DisplayTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_display_type(self): return self.display_type
    def set_display_type(self, display_type): self.display_type = display_type
    def add_display_type(self, value): self.display_type.append(value)
    def insert_display_type(self, index, value): self.display_type[index] = value
    def hasContent_(self):
        if (
            self.display_type
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DisplayTypes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DisplayTypes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DisplayTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='DisplayTypes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for display_type_ in self.display_type:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplay_type>%s</%sdisplay_type>%s' % (namespace_, self.gds_format_string(quote_xml(display_type_).encode(ExternalEncoding), input_name='display_type'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='DisplayTypes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('display_type=[\n')
        level += 1
        for display_type_ in self.display_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(display_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'display_type':
            display_type_ = child_.text
            display_type_ = self.gds_validate_string(display_type_, node, 'display_type')
            self.display_type.append(display_type_)
# end class DisplayTypes


class NicInterfaces(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nic_interface=None):
        if nic_interface is None:
            self.nic_interface = []
        else:
            self.nic_interface = nic_interface
    def factory(*args_, **kwargs_):
        if NicInterfaces.subclass:
            return NicInterfaces.subclass(*args_, **kwargs_)
        else:
            return NicInterfaces(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_nic_interface(self): return self.nic_interface
    def set_nic_interface(self, nic_interface): self.nic_interface = nic_interface
    def add_nic_interface(self, value): self.nic_interface.append(value)
    def insert_nic_interface(self, index, value): self.nic_interface[index] = value
    def hasContent_(self):
        if (
            self.nic_interface
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NicInterfaces', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NicInterfaces')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NicInterfaces'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='NicInterfaces', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for nic_interface_ in self.nic_interface:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snic_interface>%s</%snic_interface>%s' % (namespace_, self.gds_format_string(quote_xml(nic_interface_).encode(ExternalEncoding), input_name='nic_interface'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='NicInterfaces'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('nic_interface=[\n')
        level += 1
        for nic_interface_ in self.nic_interface:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(nic_interface_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'nic_interface':
            nic_interface_ = child_.text
            nic_interface_ = self.gds_validate_string(nic_interface_, node, 'nic_interface')
            self.nic_interface.append(nic_interface_)
# end class NicInterfaces


class OsTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, os_type=None):
        if os_type is None:
            self.os_type = []
        else:
            self.os_type = os_type
    def factory(*args_, **kwargs_):
        if OsTypes.subclass:
            return OsTypes.subclass(*args_, **kwargs_)
        else:
            return OsTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_os_type(self): return self.os_type
    def set_os_type(self, os_type): self.os_type = os_type
    def add_os_type(self, value): self.os_type.append(value)
    def insert_os_type(self, index, value): self.os_type[index] = value
    def hasContent_(self):
        if (
            self.os_type
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='OsTypes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OsTypes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OsTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='OsTypes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for os_type_ in self.os_type:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sos_type>%s</%sos_type>%s' % (namespace_, self.gds_format_string(quote_xml(os_type_).encode(ExternalEncoding), input_name='os_type'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='OsTypes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('os_type=[\n')
        level += 1
        for os_type_ in self.os_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(os_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'os_type':
            os_type_ = child_.text
            os_type_ = self.gds_validate_string(os_type_, node, 'os_type')
            self.os_type.append(os_type_)
# end class OsTypes


class DiskFormats(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, disk_format=None):
        if disk_format is None:
            self.disk_format = []
        else:
            self.disk_format = disk_format
    def factory(*args_, **kwargs_):
        if DiskFormats.subclass:
            return DiskFormats.subclass(*args_, **kwargs_)
        else:
            return DiskFormats(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_disk_format(self): return self.disk_format
    def set_disk_format(self, disk_format): self.disk_format = disk_format
    def add_disk_format(self, value): self.disk_format.append(value)
    def insert_disk_format(self, index, value): self.disk_format[index] = value
    def hasContent_(self):
        if (
            self.disk_format
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DiskFormats', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DiskFormats')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DiskFormats'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='DiskFormats', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for disk_format_ in self.disk_format:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisk_format>%s</%sdisk_format>%s' % (namespace_, self.gds_format_string(quote_xml(disk_format_).encode(ExternalEncoding), input_name='disk_format'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='DiskFormats'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('disk_format=[\n')
        level += 1
        for disk_format_ in self.disk_format:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(disk_format_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'disk_format':
            disk_format_ = child_.text
            disk_format_ = self.gds_validate_string(disk_format_, node, 'disk_format')
            self.disk_format.append(disk_format_)
# end class DiskFormats


class DiskInterfaces(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, disk_interface=None):
        if disk_interface is None:
            self.disk_interface = []
        else:
            self.disk_interface = disk_interface
    def factory(*args_, **kwargs_):
        if DiskInterfaces.subclass:
            return DiskInterfaces.subclass(*args_, **kwargs_)
        else:
            return DiskInterfaces(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_disk_interface(self): return self.disk_interface
    def set_disk_interface(self, disk_interface): self.disk_interface = disk_interface
    def add_disk_interface(self, value): self.disk_interface.append(value)
    def insert_disk_interface(self, index, value): self.disk_interface[index] = value
    def hasContent_(self):
        if (
            self.disk_interface
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DiskInterfaces', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DiskInterfaces')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DiskInterfaces'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='DiskInterfaces', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for disk_interface_ in self.disk_interface:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisk_interface>%s</%sdisk_interface>%s' % (namespace_, self.gds_format_string(quote_xml(disk_interface_).encode(ExternalEncoding), input_name='disk_interface'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='DiskInterfaces'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('disk_interface=[\n')
        level += 1
        for disk_interface_ in self.disk_interface:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(disk_interface_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'disk_interface':
            disk_interface_ = child_.text
            disk_interface_ = self.gds_validate_string(disk_interface_, node, 'disk_interface')
            self.disk_interface.append(disk_interface_)
# end class DiskInterfaces


class VmAffinities(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, affinity=None):
        if affinity is None:
            self.affinity = []
        else:
            self.affinity = affinity
    def factory(*args_, **kwargs_):
        if VmAffinities.subclass:
            return VmAffinities.subclass(*args_, **kwargs_)
        else:
            return VmAffinities(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_affinity(self): return self.affinity
    def set_affinity(self, affinity): self.affinity = affinity
    def add_affinity(self, value): self.affinity.append(value)
    def insert_affinity(self, index, value): self.affinity[index] = value
    def hasContent_(self):
        if (
            self.affinity
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VmAffinities', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmAffinities')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmAffinities'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VmAffinities', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for affinity_ in self.affinity:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saffinity>%s</%saffinity>%s' % (namespace_, self.gds_format_string(quote_xml(affinity_).encode(ExternalEncoding), input_name='affinity'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='VmAffinities'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('affinity=[\n')
        level += 1
        for affinity_ in self.affinity:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(affinity_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'affinity':
            affinity_ = child_.text
            affinity_ = self.gds_validate_string(affinity_, node, 'affinity')
            self.affinity.append(affinity_)
# end class VmAffinities


class BootProtocols(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, boot_protocol=None):
        if boot_protocol is None:
            self.boot_protocol = []
        else:
            self.boot_protocol = boot_protocol
    def factory(*args_, **kwargs_):
        if BootProtocols.subclass:
            return BootProtocols.subclass(*args_, **kwargs_)
        else:
            return BootProtocols(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_boot_protocol(self): return self.boot_protocol
    def set_boot_protocol(self, boot_protocol): self.boot_protocol = boot_protocol
    def add_boot_protocol(self, value): self.boot_protocol.append(value)
    def insert_boot_protocol(self, index, value): self.boot_protocol[index] = value
    def hasContent_(self):
        if (
            self.boot_protocol
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BootProtocols', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BootProtocols')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BootProtocols'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='BootProtocols', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for boot_protocol_ in self.boot_protocol:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sboot_protocol>%s</%sboot_protocol>%s' % (namespace_, self.gds_format_string(quote_xml(boot_protocol_).encode(ExternalEncoding), input_name='boot_protocol'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='BootProtocols'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('boot_protocol=[\n')
        level += 1
        for boot_protocol_ in self.boot_protocol:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(boot_protocol_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'boot_protocol':
            boot_protocol_ = child_.text
            boot_protocol_ = self.gds_validate_string(boot_protocol_, node, 'boot_protocol')
            self.boot_protocol.append(boot_protocol_)
# end class BootProtocols


class ErrorHandlingOptions(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, on_error=None):
        if on_error is None:
            self.on_error = []
        else:
            self.on_error = on_error
    def factory(*args_, **kwargs_):
        if ErrorHandlingOptions.subclass:
            return ErrorHandlingOptions.subclass(*args_, **kwargs_)
        else:
            return ErrorHandlingOptions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_on_error(self): return self.on_error
    def set_on_error(self, on_error): self.on_error = on_error
    def add_on_error(self, value): self.on_error.append(value)
    def insert_on_error(self, index, value): self.on_error[index] = value
    def hasContent_(self):
        if (
            self.on_error
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ErrorHandlingOptions', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ErrorHandlingOptions')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ErrorHandlingOptions'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ErrorHandlingOptions', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for on_error_ in self.on_error:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%son_error>%s</%son_error>%s' % (namespace_, self.gds_format_string(quote_xml(on_error_).encode(ExternalEncoding), input_name='on_error'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='ErrorHandlingOptions'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('on_error=[\n')
        level += 1
        for on_error_ in self.on_error:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(on_error_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'on_error':
            on_error_ = child_.text
            on_error_ = self.gds_validate_string(on_error_, node, 'on_error')
            self.on_error.append(on_error_)
# end class ErrorHandlingOptions


class StorageFormats(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, format=None):
        if format is None:
            self.format = []
        else:
            self.format = format
    def factory(*args_, **kwargs_):
        if StorageFormats.subclass:
            return StorageFormats.subclass(*args_, **kwargs_)
        else:
            return StorageFormats(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def add_format(self, value): self.format.append(value)
    def insert_format(self, index, value): self.format[index] = value
    def hasContent_(self):
        if (
            self.format
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StorageFormats', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageFormats')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageFormats'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='StorageFormats', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for format_ in self.format:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sformat>%s</%sformat>%s' % (namespace_, self.gds_format_string(quote_xml(format_).encode(ExternalEncoding), input_name='format'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='StorageFormats'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('format=[\n')
        level += 1
        for format_ in self.format:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(format_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'format':
            format_ = child_.text
            format_ = self.gds_validate_string(format_, node, 'format')
            self.format.append(format_)
# end class StorageFormats


class NfsVersions(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nfs_version=None):
        if nfs_version is None:
            self.nfs_version = []
        else:
            self.nfs_version = nfs_version
    def factory(*args_, **kwargs_):
        if NfsVersions.subclass:
            return NfsVersions.subclass(*args_, **kwargs_)
        else:
            return NfsVersions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_nfs_version(self): return self.nfs_version
    def set_nfs_version(self, nfs_version): self.nfs_version = nfs_version
    def add_nfs_version(self, value): self.nfs_version.append(value)
    def insert_nfs_version(self, index, value): self.nfs_version[index] = value
    def hasContent_(self):
        if (
            self.nfs_version
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NfsVersions', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NfsVersions')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NfsVersions'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='NfsVersions', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for nfs_version_ in self.nfs_version:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snfs_version>%s</%snfs_version>%s' % (namespace_, self.gds_format_string(quote_xml(nfs_version_).encode(ExternalEncoding), input_name='nfs_version'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='NfsVersions'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('nfs_version=[\n')
        level += 1
        for nfs_version_ in self.nfs_version:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(nfs_version_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'nfs_version':
            nfs_version_ = child_.text
            nfs_version_ = self.gds_validate_string(nfs_version_, node, 'nfs_version')
            self.nfs_version.append(nfs_version_)
# end class NfsVersions


class ReportedDeviceTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, reported_device_type=None):
        if reported_device_type is None:
            self.reported_device_type = []
        else:
            self.reported_device_type = reported_device_type
    def factory(*args_, **kwargs_):
        if ReportedDeviceTypes.subclass:
            return ReportedDeviceTypes.subclass(*args_, **kwargs_)
        else:
            return ReportedDeviceTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_reported_device_type(self): return self.reported_device_type
    def set_reported_device_type(self, reported_device_type): self.reported_device_type = reported_device_type
    def add_reported_device_type(self, value): self.reported_device_type.append(value)
    def insert_reported_device_type(self, index, value): self.reported_device_type[index] = value
    def hasContent_(self):
        if (
            self.reported_device_type
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ReportedDeviceTypes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ReportedDeviceTypes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ReportedDeviceTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ReportedDeviceTypes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for reported_device_type_ in self.reported_device_type:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreported_device_type>%s</%sreported_device_type>%s' % (namespace_, self.gds_format_string(quote_xml(reported_device_type_).encode(ExternalEncoding), input_name='reported_device_type'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='ReportedDeviceTypes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('reported_device_type=[\n')
        level += 1
        for reported_device_type_ in self.reported_device_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(reported_device_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'reported_device_type':
            reported_device_type_ = child_.text
            reported_device_type_ = self.gds_validate_string(reported_device_type_, node, 'reported_device_type')
            self.reported_device_type.append(reported_device_type_)
# end class ReportedDeviceTypes


class IpVersions(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ip_version=None):
        if ip_version is None:
            self.ip_version = []
        else:
            self.ip_version = ip_version
    def factory(*args_, **kwargs_):
        if IpVersions.subclass:
            return IpVersions.subclass(*args_, **kwargs_)
        else:
            return IpVersions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ip_version(self): return self.ip_version
    def set_ip_version(self, ip_version): self.ip_version = ip_version
    def add_ip_version(self, value): self.ip_version.append(value)
    def insert_ip_version(self, index, value): self.ip_version[index] = value
    def hasContent_(self):
        if (
            self.ip_version
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IpVersions', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IpVersions')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IpVersions'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='IpVersions', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ip_version_ in self.ip_version:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sip_version>%s</%sip_version>%s' % (namespace_, self.gds_format_string(quote_xml(ip_version_).encode(ExternalEncoding), input_name='ip_version'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='IpVersions'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('ip_version=[\n')
        level += 1
        for ip_version_ in self.ip_version:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(ip_version_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ip_version':
            ip_version_ = child_.text
            ip_version_ = self.gds_validate_string(ip_version_, node, 'ip_version')
            self.ip_version.append(ip_version_)
# end class IpVersions


class CpuModes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, cpu_mode=None):
        if cpu_mode is None:
            self.cpu_mode = []
        else:
            self.cpu_mode = cpu_mode
    def factory(*args_, **kwargs_):
        if CpuModes.subclass:
            return CpuModes.subclass(*args_, **kwargs_)
        else:
            return CpuModes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cpu_mode(self): return self.cpu_mode
    def set_cpu_mode(self, cpu_mode): self.cpu_mode = cpu_mode
    def add_cpu_mode(self, value): self.cpu_mode.append(value)
    def insert_cpu_mode(self, index, value): self.cpu_mode[index] = value
    def hasContent_(self):
        if (
            self.cpu_mode
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CpuModes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CpuModes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CpuModes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='CpuModes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for cpu_mode_ in self.cpu_mode:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scpu_mode>%s</%scpu_mode>%s' % (namespace_, self.gds_format_string(quote_xml(cpu_mode_).encode(ExternalEncoding), input_name='cpu_mode'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='CpuModes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('cpu_mode=[\n')
        level += 1
        for cpu_mode_ in self.cpu_mode:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(cpu_mode_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'cpu_mode':
            cpu_mode_ = child_.text
            cpu_mode_ = self.gds_validate_string(cpu_mode_, node, 'cpu_mode')
            self.cpu_mode.append(cpu_mode_)
# end class CpuModes


class ScsiGenericIoOptions(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, sgio_options=None):
        if sgio_options is None:
            self.sgio_options = []
        else:
            self.sgio_options = sgio_options
    def factory(*args_, **kwargs_):
        if ScsiGenericIoOptions.subclass:
            return ScsiGenericIoOptions.subclass(*args_, **kwargs_)
        else:
            return ScsiGenericIoOptions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_sgio_options(self): return self.sgio_options
    def set_sgio_options(self, sgio_options): self.sgio_options = sgio_options
    def add_sgio_options(self, value): self.sgio_options.append(value)
    def insert_sgio_options(self, index, value): self.sgio_options[index] = value
    def hasContent_(self):
        if (
            self.sgio_options
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ScsiGenericIoOptions', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ScsiGenericIoOptions')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ScsiGenericIoOptions'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ScsiGenericIoOptions', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for sgio_options_ in self.sgio_options:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssgio_options>%s</%ssgio_options>%s' % (namespace_, self.gds_format_string(quote_xml(sgio_options_).encode(ExternalEncoding), input_name='sgio_options'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='ScsiGenericIoOptions'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('sgio_options=[\n')
        level += 1
        for sgio_options_ in self.sgio_options:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(sgio_options_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'sgio_options':
            sgio_options_ = child_.text
            sgio_options_ = self.gds_validate_string(sgio_options_, node, 'sgio_options')
            self.sgio_options.append(sgio_options_)
# end class ScsiGenericIoOptions


class PayloadEncodings(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, payload_encodings=None):
        if payload_encodings is None:
            self.payload_encodings = []
        else:
            self.payload_encodings = payload_encodings
    def factory(*args_, **kwargs_):
        if PayloadEncodings.subclass:
            return PayloadEncodings.subclass(*args_, **kwargs_)
        else:
            return PayloadEncodings(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_payload_encodings(self): return self.payload_encodings
    def set_payload_encodings(self, payload_encodings): self.payload_encodings = payload_encodings
    def add_payload_encodings(self, value): self.payload_encodings.append(value)
    def insert_payload_encodings(self, index, value): self.payload_encodings[index] = value
    def hasContent_(self):
        if (
            self.payload_encodings
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PayloadEncodings', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PayloadEncodings')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PayloadEncodings'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='PayloadEncodings', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for payload_encodings_ in self.payload_encodings:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spayload_encodings>%s</%spayload_encodings>%s' % (namespace_, self.gds_format_string(quote_xml(payload_encodings_).encode(ExternalEncoding), input_name='payload_encodings'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='PayloadEncodings'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('payload_encodings=[\n')
        level += 1
        for payload_encodings_ in self.payload_encodings:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(payload_encodings_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'payload_encodings':
            payload_encodings_ = child_.text
            payload_encodings_ = self.gds_validate_string(payload_encodings_, node, 'payload_encodings')
            self.payload_encodings.append(payload_encodings_)
# end class PayloadEncodings


class WatchdogActions(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, action=None):
        if action is None:
            self.action = []
        else:
            self.action = action
    def factory(*args_, **kwargs_):
        if WatchdogActions.subclass:
            return WatchdogActions.subclass(*args_, **kwargs_)
        else:
            return WatchdogActions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_action(self): return self.action
    def set_action(self, action): self.action = action
    def add_action(self, value): self.action.append(value)
    def insert_action(self, index, value): self.action[index] = value
    def hasContent_(self):
        if (
            self.action
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='WatchdogActions', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='WatchdogActions')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='WatchdogActions'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='WatchdogActions', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for action_ in self.action:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saction>%s</%saction>%s' % (namespace_, self.gds_format_string(quote_xml(action_).encode(ExternalEncoding), input_name='action'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='WatchdogActions'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('action=[\n')
        level += 1
        for action_ in self.action:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(action_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'action':
            action_ = child_.text
            action_ = self.gds_validate_string(action_, node, 'action')
            self.action.append(action_)
# end class WatchdogActions


class WatchdogModels(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, model=None):
        if model is None:
            self.model = []
        else:
            self.model = model
    def factory(*args_, **kwargs_):
        if WatchdogModels.subclass:
            return WatchdogModels.subclass(*args_, **kwargs_)
        else:
            return WatchdogModels(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_model(self): return self.model
    def set_model(self, model): self.model = model
    def add_model(self, value): self.model.append(value)
    def insert_model(self, index, value): self.model[index] = value
    def hasContent_(self):
        if (
            self.model
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='WatchdogModels', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='WatchdogModels')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='WatchdogModels'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='WatchdogModels', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for model_ in self.model:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodel>%s</%smodel>%s' % (namespace_, self.gds_format_string(quote_xml(model_).encode(ExternalEncoding), input_name='model'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='WatchdogModels'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('model=[\n')
        level += 1
        for model_ in self.model:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(model_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'model':
            model_ = child_.text
            model_ = self.gds_validate_string(model_, node, 'model')
            self.model.append(model_)
# end class WatchdogModels


class SnapshotStatuses(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, snapshot_status=None):
        if snapshot_status is None:
            self.snapshot_status = []
        else:
            self.snapshot_status = snapshot_status
    def factory(*args_, **kwargs_):
        if SnapshotStatuses.subclass:
            return SnapshotStatuses.subclass(*args_, **kwargs_)
        else:
            return SnapshotStatuses(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_snapshot_status(self): return self.snapshot_status
    def set_snapshot_status(self, snapshot_status): self.snapshot_status = snapshot_status
    def add_snapshot_status(self, value): self.snapshot_status.append(value)
    def insert_snapshot_status(self, index, value): self.snapshot_status[index] = value
    def hasContent_(self):
        if (
            self.snapshot_status
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SnapshotStatuses', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SnapshotStatuses')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SnapshotStatuses'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='SnapshotStatuses', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for snapshot_status_ in self.snapshot_status:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssnapshot_status>%s</%ssnapshot_status>%s' % (namespace_, self.gds_format_string(quote_xml(snapshot_status_).encode(ExternalEncoding), input_name='snapshot_status'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='SnapshotStatuses'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('snapshot_status=[\n')
        level += 1
        for snapshot_status_ in self.snapshot_status:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(snapshot_status_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'snapshot_status':
            snapshot_status_ = child_.text
            snapshot_status_ = self.gds_validate_string(snapshot_status_, node, 'snapshot_status')
            self.snapshot_status.append(snapshot_status_)
# end class SnapshotStatuses


class SsoMethods(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, sso_method=None):
        if sso_method is None:
            self.sso_method = []
        else:
            self.sso_method = sso_method
    def factory(*args_, **kwargs_):
        if SsoMethods.subclass:
            return SsoMethods.subclass(*args_, **kwargs_)
        else:
            return SsoMethods(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_sso_method(self): return self.sso_method
    def set_sso_method(self, sso_method): self.sso_method = sso_method
    def add_sso_method(self, value): self.sso_method.append(value)
    def insert_sso_method(self, index, value): self.sso_method[index] = value
    def hasContent_(self):
        if (
            self.sso_method
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SsoMethods', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SsoMethods')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SsoMethods'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='SsoMethods', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for sso_method_ in self.sso_method:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssso_method>%s</%ssso_method>%s' % (namespace_, self.gds_format_string(quote_xml(sso_method_).encode(ExternalEncoding), input_name='sso_method'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='SsoMethods'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('sso_method=[\n')
        level += 1
        for sso_method_ in self.sso_method:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(sso_method_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'sso_method':
            sso_method_ = child_.text
            sso_method_ = self.gds_validate_string(sso_method_, node, 'sso_method')
            self.sso_method.append(sso_method_)
# end class SsoMethods


class KdumpStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, kdump_status=None):
        if kdump_status is None:
            self.kdump_status = []
        else:
            self.kdump_status = kdump_status
    def factory(*args_, **kwargs_):
        if KdumpStates.subclass:
            return KdumpStates.subclass(*args_, **kwargs_)
        else:
            return KdumpStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_kdump_status(self): return self.kdump_status
    def set_kdump_status(self, kdump_status): self.kdump_status = kdump_status
    def add_kdump_status(self, value): self.kdump_status.append(value)
    def insert_kdump_status(self, index, value): self.kdump_status[index] = value
    def hasContent_(self):
        if (
            self.kdump_status
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='KdumpStates', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='KdumpStates')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='KdumpStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='KdumpStates', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for kdump_status_ in self.kdump_status:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skdump_status>%s</%skdump_status>%s' % (namespace_, self.gds_format_string(quote_xml(kdump_status_).encode(ExternalEncoding), input_name='kdump_status'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='KdumpStates'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('kdump_status=[\n')
        level += 1
        for kdump_status_ in self.kdump_status:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(kdump_status_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'kdump_status':
            kdump_status_ = child_.text
            kdump_status_ = self.gds_validate_string(kdump_status_, node, 'kdump_status')
            self.kdump_status.append(kdump_status_)
# end class KdumpStates


class ArchitectureCapability(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, name=None, architectures=None):
        self.name = name
        if architectures is None:
            self.architectures = []
        else:
            self.architectures = architectures
    def factory(*args_, **kwargs_):
        if ArchitectureCapability.subclass:
            return ArchitectureCapability.subclass(*args_, **kwargs_)
        else:
            return ArchitectureCapability(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_architectures(self): return self.architectures
    def set_architectures(self, architectures): self.architectures = architectures
    def add_architectures(self, value): self.architectures.append(value)
    def insert_architectures(self, index, value): self.architectures[index] = value
    def hasContent_(self):
        if (
            self.name is not None or
            self.architectures
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ArchitectureCapability', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ArchitectureCapability')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ArchitectureCapability'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ArchitectureCapability', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_, eol_))
        for architectures_ in self.architectures:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sarchitectures>%s</%sarchitectures>%s' % (namespace_, self.gds_format_string(quote_xml(architectures_).encode(ExternalEncoding), input_name='architectures'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='ArchitectureCapability'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('architectures=[\n')
        level += 1
        for architectures_ in self.architectures:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(architectures_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'architectures':
            architectures_ = child_.text
            architectures_ = self.gds_validate_string(architectures_, node, 'architectures')
            self.architectures.append(architectures_)
# end class ArchitectureCapability


class ArchitectureCapabilities(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, architecture_capability=None):
        if architecture_capability is None:
            self.architecture_capability = []
        else:
            self.architecture_capability = architecture_capability
    def factory(*args_, **kwargs_):
        if ArchitectureCapabilities.subclass:
            return ArchitectureCapabilities.subclass(*args_, **kwargs_)
        else:
            return ArchitectureCapabilities(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_architecture_capability(self): return self.architecture_capability
    def set_architecture_capability(self, architecture_capability): self.architecture_capability = architecture_capability
    def add_architecture_capability(self, value): self.architecture_capability.append(value)
    def insert_architecture_capability(self, index, value): self.architecture_capability[index] = value
    def hasContent_(self):
        if (
            self.architecture_capability
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ArchitectureCapabilities', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ArchitectureCapabilities')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ArchitectureCapabilities'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ArchitectureCapabilities', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for architecture_capability_ in self.architecture_capability:
            architecture_capability_.export(outfile, level, namespace_, name_='architecture_capability', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ArchitectureCapabilities'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('architecture_capability=[\n')
        level += 1
        for architecture_capability_ in self.architecture_capability:
            showIndent(outfile, level)
            outfile.write('model_.architecture_capability(\n')
            architecture_capability_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'architecture_capability':
            obj_ = ArchitectureCapability.factory()
            obj_.build(child_)
            self.architecture_capability.append(obj_)
# end class ArchitectureCapabilities


class SerialNumberPolicies(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, serial_number_policy=None):
        if serial_number_policy is None:
            self.serial_number_policy = []
        else:
            self.serial_number_policy = serial_number_policy
    def factory(*args_, **kwargs_):
        if SerialNumberPolicies.subclass:
            return SerialNumberPolicies.subclass(*args_, **kwargs_)
        else:
            return SerialNumberPolicies(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_serial_number_policy(self): return self.serial_number_policy
    def set_serial_number_policy(self, serial_number_policy): self.serial_number_policy = serial_number_policy
    def add_serial_number_policy(self, value): self.serial_number_policy.append(value)
    def insert_serial_number_policy(self, index, value): self.serial_number_policy[index] = value
    def hasContent_(self):
        if (
            self.serial_number_policy
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SerialNumberPolicies', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SerialNumberPolicies')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SerialNumberPolicies'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='SerialNumberPolicies', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for serial_number_policy_ in self.serial_number_policy:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sserial_number_policy>%s</%sserial_number_policy>%s' % (namespace_, self.gds_format_string(quote_xml(serial_number_policy_).encode(ExternalEncoding), input_name='serial_number_policy'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='SerialNumberPolicies'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('serial_number_policy=[\n')
        level += 1
        for serial_number_policy_ in self.serial_number_policy:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(serial_number_policy_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'serial_number_policy':
            serial_number_policy_ = child_.text
            serial_number_policy_ = self.gds_validate_string(serial_number_policy_, node, 'serial_number_policy')
            self.serial_number_policy.append(serial_number_policy_)
# end class SerialNumberPolicies


class SELinuxModes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, selinux_mode=None):
        if selinux_mode is None:
            self.selinux_mode = []
        else:
            self.selinux_mode = selinux_mode
    def factory(*args_, **kwargs_):
        if SELinuxModes.subclass:
            return SELinuxModes.subclass(*args_, **kwargs_)
        else:
            return SELinuxModes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_selinux_mode(self): return self.selinux_mode
    def set_selinux_mode(self, selinux_mode): self.selinux_mode = selinux_mode
    def add_selinux_mode(self, value): self.selinux_mode.append(value)
    def insert_selinux_mode(self, index, value): self.selinux_mode[index] = value
    def hasContent_(self):
        if (
            self.selinux_mode
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SELinuxModes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SELinuxModes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SELinuxModes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='SELinuxModes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for selinux_mode_ in self.selinux_mode:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sselinux_mode>%s</%sselinux_mode>%s' % (namespace_, self.gds_format_string(quote_xml(selinux_mode_).encode(ExternalEncoding), input_name='selinux_mode'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='SELinuxModes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('selinux_mode=[\n')
        level += 1
        for selinux_mode_ in self.selinux_mode:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(selinux_mode_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'selinux_mode':
            selinux_mode_ = child_.text
            selinux_mode_ = self.gds_validate_string(selinux_mode_, node, 'selinux_mode')
            self.selinux_mode.append(selinux_mode_)
# end class SELinuxModes


class SchedulingPolicyUnitTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, scheduling_policy_unit_type=None):
        if scheduling_policy_unit_type is None:
            self.scheduling_policy_unit_type = []
        else:
            self.scheduling_policy_unit_type = scheduling_policy_unit_type
    def factory(*args_, **kwargs_):
        if SchedulingPolicyUnitTypes.subclass:
            return SchedulingPolicyUnitTypes.subclass(*args_, **kwargs_)
        else:
            return SchedulingPolicyUnitTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_scheduling_policy_unit_type(self): return self.scheduling_policy_unit_type
    def set_scheduling_policy_unit_type(self, scheduling_policy_unit_type): self.scheduling_policy_unit_type = scheduling_policy_unit_type
    def add_scheduling_policy_unit_type(self, value): self.scheduling_policy_unit_type.append(value)
    def insert_scheduling_policy_unit_type(self, index, value): self.scheduling_policy_unit_type[index] = value
    def hasContent_(self):
        if (
            self.scheduling_policy_unit_type
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SchedulingPolicyUnitTypes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SchedulingPolicyUnitTypes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SchedulingPolicyUnitTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='SchedulingPolicyUnitTypes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for scheduling_policy_unit_type_ in self.scheduling_policy_unit_type:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sscheduling_policy_unit_type>%s</%sscheduling_policy_unit_type>%s' % (namespace_, self.gds_format_string(quote_xml(scheduling_policy_unit_type_).encode(ExternalEncoding), input_name='scheduling_policy_unit_type'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='SchedulingPolicyUnitTypes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('scheduling_policy_unit_type=[\n')
        level += 1
        for scheduling_policy_unit_type_ in self.scheduling_policy_unit_type:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(scheduling_policy_unit_type_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'scheduling_policy_unit_type':
            scheduling_policy_unit_type_ = child_.text
            scheduling_policy_unit_type_ = self.gds_validate_string(scheduling_policy_unit_type_, node, 'scheduling_policy_unit_type')
            self.scheduling_policy_unit_type.append(scheduling_policy_unit_type_)
# end class SchedulingPolicyUnitTypes


class ActionableResource(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, actions=None, extensiontype_=None):
        self.actions = actions
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if ActionableResource.subclass:
            return ActionableResource.subclass(*args_, **kwargs_)
        else:
            return ActionableResource(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_actions(self): return self.actions
    def set_actions(self, actions): self.actions = actions
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.actions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ActionableResource', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ActionableResource')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ActionableResource'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ActionableResource', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.actions is not None:
            self.actions.export(outfile, level, namespace_, name_='actions', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ActionableResource'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.actions is not None:
            showIndent(outfile, level)
            outfile.write('actions=model_.Actions(\n')
            self.actions.exportLiteral(outfile, level, name_='actions')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'actions':
            obj_ = Actions.factory()
            obj_.build(child_)
            self.actions = obj_
# end class ActionableResource


class BaseResource(ActionableResource):
    subclass = None
    superclass = ActionableResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, extensiontype_=None):
        super(BaseResource, self).__init__(actions, extensiontype_, )
        self.href = _cast(None, href)
        self.id = _cast(None, id)
        self.name = name
        self.description = description
        self.comment = comment
        self.creation_status = creation_status
        if link is None:
            self.link = []
        else:
            self.link = link
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if BaseResource.subclass:
            return BaseResource.subclass(*args_, **kwargs_)
        else:
            return BaseResource(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_comment(self): return self.comment
    def set_comment(self, comment): self.comment = comment
    def get_creation_status(self): return self.creation_status
    def set_creation_status(self, creation_status): self.creation_status = creation_status
    def get_link(self): return self.link
    def set_link(self, link): self.link = link
    def add_link(self, value): self.link.append(value)
    def insert_link(self, index, value): self.link[index] = value
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.name is not None or
            self.description is not None or
            self.comment is not None or
            self.creation_status is not None or
            self.link or
            super(BaseResource, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BaseResource', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseResource')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseResource'):
        super(BaseResource, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseResource')
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (self.gds_format_string(quote_attrib(self.href).encode(ExternalEncoding), input_name='href'), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseResource', fromsubclass_=False, pretty_print=True):
        super(BaseResource, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_, eol_))
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_, eol_))
        if self.comment is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scomment>%s</%scomment>%s' % (namespace_, self.gds_format_string(quote_xml(self.comment).encode(ExternalEncoding), input_name='comment'), namespace_, eol_))
        if self.creation_status is not None:
            self.creation_status.export(outfile, level, namespace_, name_='creation_status', pretty_print=pretty_print)
        for link_ in self.link:
            link_.export(outfile, level, namespace_, name_='link', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BaseResource'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            showIndent(outfile, level)
            outfile.write('href="%s",\n' % (self.href,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
        super(BaseResource, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(BaseResource, self).exportLiteralChildren(outfile, level, name_)
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.comment is not None:
            showIndent(outfile, level)
            outfile.write('comment=%s,\n' % quote_python(self.comment).encode(ExternalEncoding))
        if self.creation_status is not None:
            showIndent(outfile, level)
            outfile.write('creation_status=model_.Status(\n')
            self.creation_status.exportLiteral(outfile, level, name_='creation_status')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('link=[\n')
        level += 1
        for link_ in self.link:
            showIndent(outfile, level)
            outfile.write('model_.link(\n')
            link_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(BaseResource, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'comment':
            comment_ = child_.text
            comment_ = self.gds_validate_string(comment_, node, 'comment')
            self.comment = comment_
        elif nodeName_ == 'creation_status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.creation_status = obj_
        elif nodeName_ == 'link':
            class_obj_ = self.get_class_obj_(child_, Link)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.link.append(obj_)
        super(BaseResource, self).buildChildren(child_, node, nodeName_, True)
# end class BaseResource


class BaseResources(ActionableResource):
    subclass = None
    superclass = ActionableResource
    def __init__(self, actions=None, total=None, active=None, extensiontype_=None):
        super(BaseResources, self).__init__(actions, extensiontype_, )
        self.total = total
        self.active = active
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if BaseResources.subclass:
            return BaseResources.subclass(*args_, **kwargs_)
        else:
            return BaseResources(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_total(self): return self.total
    def set_total(self, total): self.total = total
    def get_active(self): return self.active
    def set_active(self, active): self.active = active
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.total is not None or
            self.active is not None or
            super(BaseResources, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BaseResources', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseResources')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseResources'):
        super(BaseResources, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseResources')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseResources', fromsubclass_=False, pretty_print=True):
        super(BaseResources, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.total is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotal>%s</%stotal>%s' % (namespace_, self.gds_format_integer(self.total, input_name='total'), namespace_, eol_))
        if self.active is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sactive>%s</%sactive>%s' % (namespace_, self.gds_format_integer(self.active, input_name='active'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='BaseResources'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(BaseResources, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(BaseResources, self).exportLiteralChildren(outfile, level, name_)
        if self.total is not None:
            showIndent(outfile, level)
            outfile.write('total=%d,\n' % self.total)
        if self.active is not None:
            showIndent(outfile, level)
            outfile.write('active=%d,\n' % self.active)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(BaseResources, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'total':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'total')
            self.total = ival_
        elif nodeName_ == 'active':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'active')
            self.active = ival_
        super(BaseResources, self).buildChildren(child_, node, nodeName_, True)
# end class BaseResources


class Option(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, name=None, value=None):
        self.type_ = _cast(None, type_)
        self.name = _cast(None, name)
        self.value = _cast(None, value)
        pass
    def factory(*args_, **kwargs_):
        if Option.subclass:
            return Option.subclass(*args_, **kwargs_)
        else:
            return Option(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Option', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Option')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Option'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (self.gds_format_string(quote_attrib(self.value).encode(ExternalEncoding), input_name='value'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Option', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='Option'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            showIndent(outfile, level)
            outfile.write('value="%s",\n' % (self.value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Option


class Options(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, option=None):
        if option is None:
            self.option = []
        else:
            self.option = option
    def factory(*args_, **kwargs_):
        if Options.subclass:
            return Options.subclass(*args_, **kwargs_)
        else:
            return Options(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_option(self): return self.option
    def set_option(self, option): self.option = option
    def add_option(self, value): self.option.append(value)
    def insert_option(self, index, value): self.option[index] = value
    def hasContent_(self):
        if (
            self.option
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Options', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Options')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Options'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Options', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for option_ in self.option:
            option_.export(outfile, level, namespace_, name_='option', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Options'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('option=[\n')
        level += 1
        for option_ in self.option:
            showIndent(outfile, level)
            outfile.write('model_.Option(\n')
            option_.exportLiteral(outfile, level, name_='Option')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'option':
            obj_ = Option.factory()
            obj_.build(child_)
            self.option.append(obj_)
# end class Options


class DataCenter(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, storage_type=None, local=None, storage_format=None, version=None, supported_versions=None, status=None):
        super(DataCenter, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.storage_type = storage_type
        self.local = local
        self.storage_format = storage_format
        self.version = version
        self.supported_versions = supported_versions
        self.status = status
    def factory(*args_, **kwargs_):
        if DataCenter.subclass:
            return DataCenter.subclass(*args_, **kwargs_)
        else:
            return DataCenter(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_storage_type(self): return self.storage_type
    def set_storage_type(self, storage_type): self.storage_type = storage_type
    def get_local(self): return self.local
    def set_local(self, local): self.local = local
    def get_storage_format(self): return self.storage_format
    def set_storage_format(self, storage_format): self.storage_format = storage_format
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_supported_versions(self): return self.supported_versions
    def set_supported_versions(self, supported_versions): self.supported_versions = supported_versions
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def hasContent_(self):
        if (
            self.storage_type is not None or
            self.local is not None or
            self.storage_format is not None or
            self.version is not None or
            self.supported_versions is not None or
            self.status is not None or
            super(DataCenter, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DataCenter', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DataCenter')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DataCenter'):
        super(DataCenter, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DataCenter')
    def exportChildren(self, outfile, level, namespace_='', name_='DataCenter', fromsubclass_=False, pretty_print=True):
        super(DataCenter, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.storage_type is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstorage_type>%s</%sstorage_type>%s' % (namespace_, self.gds_format_string(quote_xml(self.storage_type).encode(ExternalEncoding), input_name='storage_type'), namespace_, eol_))
        if self.local is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slocal>%s</%slocal>%s' % (namespace_, self.gds_format_boolean(self.local, input_name='local'), namespace_, eol_))
        if self.storage_format is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstorage_format>%s</%sstorage_format>%s' % (namespace_, self.gds_format_string(quote_xml(self.storage_format).encode(ExternalEncoding), input_name='storage_format'), namespace_, eol_))
        if self.version is not None:
            self.version.export(outfile, level, namespace_, name_='version', pretty_print=pretty_print)
        if self.supported_versions is not None:
            self.supported_versions.export(outfile, level, namespace_, name_='supported_versions', pretty_print=pretty_print)
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='DataCenter'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(DataCenter, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DataCenter, self).exportLiteralChildren(outfile, level, name_)
        if self.storage_type is not None:
            showIndent(outfile, level)
            outfile.write('storage_type=%s,\n' % quote_python(self.storage_type).encode(ExternalEncoding))
        if self.local is not None:
            showIndent(outfile, level)
            outfile.write('local=%s,\n' % self.local)
        if self.storage_format is not None:
            showIndent(outfile, level)
            outfile.write('storage_format=%s,\n' % quote_python(self.storage_format).encode(ExternalEncoding))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=model_.Version(\n')
            self.version.exportLiteral(outfile, level, name_='version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.supported_versions is not None:
            showIndent(outfile, level)
            outfile.write('supported_versions=model_.SupportedVersions(\n')
            self.supported_versions.exportLiteral(outfile, level, name_='supported_versions')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(DataCenter, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'storage_type':
            storage_type_ = child_.text
            storage_type_ = self.gds_validate_string(storage_type_, node, 'storage_type')
            self.storage_type = storage_type_
        elif nodeName_ == 'local':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'local')
            self.local = ival_
        elif nodeName_ == 'storage_format':
            storage_format_ = child_.text
            storage_format_ = self.gds_validate_string(storage_format_, node, 'storage_format')
            self.storage_format = storage_format_
        elif nodeName_ == 'version':
            class_obj_ = self.get_class_obj_(child_, Version)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.version = obj_
        elif nodeName_ == 'supported_versions':
            obj_ = SupportedVersions.factory()
            obj_.build(child_)
            self.supported_versions = obj_
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.status = obj_
        super(DataCenter, self).buildChildren(child_, node, nodeName_, True)
# end class DataCenter


class DataCenters(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, data_center=None):
        super(DataCenters, self).__init__(actions, total, active, )
        if data_center is None:
            self.data_center = []
        else:
            self.data_center = data_center
    def factory(*args_, **kwargs_):
        if DataCenters.subclass:
            return DataCenters.subclass(*args_, **kwargs_)
        else:
            return DataCenters(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_data_center(self): return self.data_center
    def set_data_center(self, data_center): self.data_center = data_center
    def add_data_center(self, value): self.data_center.append(value)
    def insert_data_center(self, index, value): self.data_center[index] = value
    def hasContent_(self):
        if (
            self.data_center or
            super(DataCenters, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DataCenters', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DataCenters')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DataCenters'):
        super(DataCenters, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DataCenters')
    def exportChildren(self, outfile, level, namespace_='', name_='DataCenters', fromsubclass_=False, pretty_print=True):
        super(DataCenters, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for data_center_ in self.data_center:
            data_center_.export(outfile, level, namespace_, name_='data_center', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='DataCenters'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(DataCenters, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DataCenters, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('data_center=[\n')
        level += 1
        for data_center_ in self.data_center:
            showIndent(outfile, level)
            outfile.write('model_.data_center(\n')
            data_center_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(DataCenters, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'data_center':
            obj_ = DataCenter.factory()
            obj_.build(child_)
            self.data_center.append(obj_)
        super(DataCenters, self).buildChildren(child_, node, nodeName_, True)
# end class DataCenters


class DataCenterStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, data_center_state=None):
        if data_center_state is None:
            self.data_center_state = []
        else:
            self.data_center_state = data_center_state
    def factory(*args_, **kwargs_):
        if DataCenterStates.subclass:
            return DataCenterStates.subclass(*args_, **kwargs_)
        else:
            return DataCenterStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_data_center_state(self): return self.data_center_state
    def set_data_center_state(self, data_center_state): self.data_center_state = data_center_state
    def add_data_center_state(self, value): self.data_center_state.append(value)
    def insert_data_center_state(self, index, value): self.data_center_state[index] = value
    def hasContent_(self):
        if (
            self.data_center_state
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DataCenterStates', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DataCenterStates')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DataCenterStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='DataCenterStates', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for data_center_state_ in self.data_center_state:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdata_center_state>%s</%sdata_center_state>%s' % (namespace_, self.gds_format_string(quote_xml(data_center_state_).encode(ExternalEncoding), input_name='data_center_state'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='DataCenterStates'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('data_center_state=[\n')
        level += 1
        for data_center_state_ in self.data_center_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(data_center_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'data_center_state':
            data_center_state_ = child_.text
            data_center_state_ = self.gds_validate_string(data_center_state_, node, 'data_center_state')
            self.data_center_state.append(data_center_state_)
# end class DataCenterStates


class MemoryOverCommit(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, percent=None):
        self.percent = _cast(int, percent)
        pass
    def factory(*args_, **kwargs_):
        if MemoryOverCommit.subclass:
            return MemoryOverCommit.subclass(*args_, **kwargs_)
        else:
            return MemoryOverCommit(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_percent(self): return self.percent
    def set_percent(self, percent): self.percent = percent
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MemoryOverCommit', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MemoryOverCommit')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MemoryOverCommit'):
        if self.percent is not None and 'percent' not in already_processed:
            already_processed.add('percent')
            outfile.write(' percent="%s"' % self.gds_format_integer(self.percent, input_name='percent'))
    def exportChildren(self, outfile, level, namespace_='', name_='MemoryOverCommit', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='MemoryOverCommit'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.percent is not None and 'percent' not in already_processed:
            already_processed.add('percent')
            showIndent(outfile, level)
            outfile.write('percent=%d,\n' % (self.percent,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('percent', node)
        if value is not None and 'percent' not in already_processed:
            already_processed.add('percent')
            try:
                self.percent = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class MemoryOverCommit


class MemoryPolicy(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, guaranteed=None, ballooning=None, overcommit=None, transparent_hugepages=None):
        self.guaranteed = guaranteed
        self.ballooning = ballooning
        self.overcommit = overcommit
        self.transparent_hugepages = transparent_hugepages
    def factory(*args_, **kwargs_):
        if MemoryPolicy.subclass:
            return MemoryPolicy.subclass(*args_, **kwargs_)
        else:
            return MemoryPolicy(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_guaranteed(self): return self.guaranteed
    def set_guaranteed(self, guaranteed): self.guaranteed = guaranteed
    def get_ballooning(self): return self.ballooning
    def set_ballooning(self, ballooning): self.ballooning = ballooning
    def get_overcommit(self): return self.overcommit
    def set_overcommit(self, overcommit): self.overcommit = overcommit
    def get_transparent_hugepages(self): return self.transparent_hugepages
    def set_transparent_hugepages(self, transparent_hugepages): self.transparent_hugepages = transparent_hugepages
    def hasContent_(self):
        if (
            self.guaranteed is not None or
            self.ballooning is not None or
            self.overcommit is not None or
            self.transparent_hugepages is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MemoryPolicy', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MemoryPolicy')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MemoryPolicy'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='MemoryPolicy', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.guaranteed is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sguaranteed>%s</%sguaranteed>%s' % (namespace_, self.gds_format_integer(self.guaranteed, input_name='guaranteed'), namespace_, eol_))
        if self.ballooning is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sballooning>%s</%sballooning>%s' % (namespace_, self.gds_format_boolean(self.ballooning, input_name='ballooning'), namespace_, eol_))
        if self.overcommit is not None:
            self.overcommit.export(outfile, level, namespace_, name_='overcommit', pretty_print=pretty_print)
        if self.transparent_hugepages is not None:
            self.transparent_hugepages.export(outfile, level, namespace_, name_='transparent_hugepages', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='MemoryPolicy'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.guaranteed is not None:
            showIndent(outfile, level)
            outfile.write('guaranteed=%d,\n' % self.guaranteed)
        if self.ballooning is not None:
            showIndent(outfile, level)
            outfile.write('ballooning=%s,\n' % self.ballooning)
        if self.overcommit is not None:
            showIndent(outfile, level)
            outfile.write('overcommit=model_.MemoryOverCommit(\n')
            self.overcommit.exportLiteral(outfile, level, name_='overcommit')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.transparent_hugepages is not None:
            showIndent(outfile, level)
            outfile.write('transparent_hugepages=model_.transparent_hugepages(\n')
            self.transparent_hugepages.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'guaranteed':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'guaranteed')
            self.guaranteed = ival_
        elif nodeName_ == 'ballooning':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ballooning')
            self.ballooning = ival_
        elif nodeName_ == 'overcommit':
            obj_ = MemoryOverCommit.factory()
            obj_.build(child_)
            self.overcommit = obj_
        elif nodeName_ == 'transparent_hugepages':
            obj_ = TransparentHugePages.factory()
            obj_.build(child_)
            self.transparent_hugepages = obj_
# end class MemoryPolicy


class Console(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, enabled=None):
        self.enabled = _cast(bool, enabled)
        pass
    def factory(*args_, **kwargs_):
        if Console.subclass:
            return Console.subclass(*args_, **kwargs_)
        else:
            return Console(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_enabled(self): return self.enabled
    def set_enabled(self, enabled): self.enabled = enabled
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Console', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Console')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Console'):
        if self.enabled is not None and 'enabled' not in already_processed:
            already_processed.add('enabled')
            outfile.write(' enabled="%s"' % self.gds_format_boolean(self.enabled, input_name='enabled'))
    def exportChildren(self, outfile, level, namespace_='', name_='Console', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='Console'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.enabled is not None and 'enabled' not in already_processed:
            already_processed.add('enabled')
            showIndent(outfile, level)
            outfile.write('enabled=%s,\n' % (self.enabled,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('enabled', node)
        if value is not None and 'enabled' not in already_processed:
            already_processed.add('enabled')
            if value in ('true', '1'):
                self.enabled = True
            elif value in ('false', '0'):
                self.enabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Console


class VirtIO_SCSI(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, enabled=None):
        self.enabled = _cast(bool, enabled)
        pass
    def factory(*args_, **kwargs_):
        if VirtIO_SCSI.subclass:
            return VirtIO_SCSI.subclass(*args_, **kwargs_)
        else:
            return VirtIO_SCSI(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_enabled(self): return self.enabled
    def set_enabled(self, enabled): self.enabled = enabled
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VirtIO_SCSI', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VirtIO_SCSI')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VirtIO_SCSI'):
        if self.enabled is not None and 'enabled' not in already_processed:
            already_processed.add('enabled')
            outfile.write(' enabled="%s"' % self.gds_format_boolean(self.enabled, input_name='enabled'))
    def exportChildren(self, outfile, level, namespace_='', name_='VirtIO_SCSI', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='VirtIO_SCSI'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.enabled is not None and 'enabled' not in already_processed:
            already_processed.add('enabled')
            showIndent(outfile, level)
            outfile.write('enabled=%s,\n' % (self.enabled,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('enabled', node)
        if value is not None and 'enabled' not in already_processed:
            already_processed.add('enabled')
            if value in ('true', '1'):
                self.enabled = True
            elif value in ('false', '0'):
                self.enabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class VirtIO_SCSI


class SchedulingPolicyThresholds(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, high=None, duration=None, low=None):
        self.high = _cast(int, high)
        self.duration = _cast(int, duration)
        self.low = _cast(int, low)
        pass
    def factory(*args_, **kwargs_):
        if SchedulingPolicyThresholds.subclass:
            return SchedulingPolicyThresholds.subclass(*args_, **kwargs_)
        else:
            return SchedulingPolicyThresholds(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_high(self): return self.high
    def set_high(self, high): self.high = high
    def get_duration(self): return self.duration
    def set_duration(self, duration): self.duration = duration
    def get_low(self): return self.low
    def set_low(self, low): self.low = low
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SchedulingPolicyThresholds', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SchedulingPolicyThresholds')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SchedulingPolicyThresholds'):
        if self.high is not None and 'high' not in already_processed:
            already_processed.add('high')
            outfile.write(' high="%s"' % self.gds_format_integer(self.high, input_name='high'))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            outfile.write(' duration="%s"' % self.gds_format_integer(self.duration, input_name='duration'))
        if self.low is not None and 'low' not in already_processed:
            already_processed.add('low')
            outfile.write(' low="%s"' % self.gds_format_integer(self.low, input_name='low'))
    def exportChildren(self, outfile, level, namespace_='', name_='SchedulingPolicyThresholds', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='SchedulingPolicyThresholds'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.high is not None and 'high' not in already_processed:
            already_processed.add('high')
            showIndent(outfile, level)
            outfile.write('high=%d,\n' % (self.high,))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            showIndent(outfile, level)
            outfile.write('duration=%d,\n' % (self.duration,))
        if self.low is not None and 'low' not in already_processed:
            already_processed.add('low')
            showIndent(outfile, level)
            outfile.write('low=%d,\n' % (self.low,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('high', node)
        if value is not None and 'high' not in already_processed:
            already_processed.add('high')
            try:
                self.high = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('duration', node)
        if value is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            try:
                self.duration = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('low', node)
        if value is not None and 'low' not in already_processed:
            already_processed.add('low')
            try:
                self.low = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class SchedulingPolicyThresholds


class SchedulingPolicyUnit(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, type_=None, internal=None, enabled=None, properties=None):
        super(SchedulingPolicyUnit, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.type_ = _cast(None, type_)
        self.internal = internal
        self.enabled = enabled
        self.properties = properties
    def factory(*args_, **kwargs_):
        if SchedulingPolicyUnit.subclass:
            return SchedulingPolicyUnit.subclass(*args_, **kwargs_)
        else:
            return SchedulingPolicyUnit(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_internal(self): return self.internal
    def set_internal(self, internal): self.internal = internal
    def get_enabled(self): return self.enabled
    def set_enabled(self, enabled): self.enabled = enabled
    def get_properties(self): return self.properties
    def set_properties(self, properties): self.properties = properties
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def hasContent_(self):
        if (
            self.internal is not None or
            self.enabled is not None or
            self.properties is not None or
            super(SchedulingPolicyUnit, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SchedulingPolicyUnit', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SchedulingPolicyUnit')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SchedulingPolicyUnit'):
        super(SchedulingPolicyUnit, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SchedulingPolicyUnit')
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='SchedulingPolicyUnit', fromsubclass_=False, pretty_print=True):
        super(SchedulingPolicyUnit, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.internal is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinternal>%s</%sinternal>%s' % (namespace_, self.gds_format_boolean(self.internal, input_name='internal'), namespace_, eol_))
        if self.enabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%senabled>%s</%senabled>%s' % (namespace_, self.gds_format_boolean(self.enabled, input_name='enabled'), namespace_, eol_))
        if self.properties is not None:
            self.properties.export(outfile, level, namespace_, name_='properties', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SchedulingPolicyUnit'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
        super(SchedulingPolicyUnit, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(SchedulingPolicyUnit, self).exportLiteralChildren(outfile, level, name_)
        if self.internal is not None:
            showIndent(outfile, level)
            outfile.write('internal=%s,\n' % self.internal)
        if self.enabled is not None:
            showIndent(outfile, level)
            outfile.write('enabled=%s,\n' % self.enabled)
        if self.properties is not None:
            showIndent(outfile, level)
            outfile.write('properties=model_.properties(\n')
            self.properties.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        super(SchedulingPolicyUnit, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'internal':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'internal')
            self.internal = ival_
        elif nodeName_ == 'enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'enabled')
            self.enabled = ival_
        elif nodeName_ == 'properties':
            obj_ = Properties.factory()
            obj_.build(child_)
            self.properties = obj_
        super(SchedulingPolicyUnit, self).buildChildren(child_, node, nodeName_, True)
# end class SchedulingPolicyUnit


class SchedulingPolicyUnits(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, scheduling_policy_unit=None):
        super(SchedulingPolicyUnits, self).__init__(actions, total, active, )
        if scheduling_policy_unit is None:
            self.scheduling_policy_unit = []
        else:
            self.scheduling_policy_unit = scheduling_policy_unit
    def factory(*args_, **kwargs_):
        if SchedulingPolicyUnits.subclass:
            return SchedulingPolicyUnits.subclass(*args_, **kwargs_)
        else:
            return SchedulingPolicyUnits(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_scheduling_policy_unit(self): return self.scheduling_policy_unit
    def set_scheduling_policy_unit(self, scheduling_policy_unit): self.scheduling_policy_unit = scheduling_policy_unit
    def add_scheduling_policy_unit(self, value): self.scheduling_policy_unit.append(value)
    def insert_scheduling_policy_unit(self, index, value): self.scheduling_policy_unit[index] = value
    def hasContent_(self):
        if (
            self.scheduling_policy_unit or
            super(SchedulingPolicyUnits, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SchedulingPolicyUnits', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SchedulingPolicyUnits')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SchedulingPolicyUnits'):
        super(SchedulingPolicyUnits, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SchedulingPolicyUnits')
    def exportChildren(self, outfile, level, namespace_='', name_='SchedulingPolicyUnits', fromsubclass_=False, pretty_print=True):
        super(SchedulingPolicyUnits, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for scheduling_policy_unit_ in self.scheduling_policy_unit:
            scheduling_policy_unit_.export(outfile, level, namespace_, name_='scheduling_policy_unit', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SchedulingPolicyUnits'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(SchedulingPolicyUnits, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(SchedulingPolicyUnits, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('scheduling_policy_unit=[\n')
        level += 1
        for scheduling_policy_unit_ in self.scheduling_policy_unit:
            showIndent(outfile, level)
            outfile.write('model_.scheduling_policy_unit(\n')
            scheduling_policy_unit_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(SchedulingPolicyUnits, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'scheduling_policy_unit':
            obj_ = SchedulingPolicyUnit.factory()
            obj_.build(child_)
            self.scheduling_policy_unit.append(obj_)
        super(SchedulingPolicyUnits, self).buildChildren(child_, node, nodeName_, True)
# end class SchedulingPolicyUnits


class Filter(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, scheduling_policy_unit=None, position=None):
        super(Filter, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.scheduling_policy_unit = scheduling_policy_unit
        self.position = position
    def factory(*args_, **kwargs_):
        if Filter.subclass:
            return Filter.subclass(*args_, **kwargs_)
        else:
            return Filter(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_scheduling_policy_unit(self): return self.scheduling_policy_unit
    def set_scheduling_policy_unit(self, scheduling_policy_unit): self.scheduling_policy_unit = scheduling_policy_unit
    def get_position(self): return self.position
    def set_position(self, position): self.position = position
    def hasContent_(self):
        if (
            self.scheduling_policy_unit is not None or
            self.position is not None or
            super(Filter, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Filter', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Filter')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Filter'):
        super(Filter, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Filter')
    def exportChildren(self, outfile, level, namespace_='', name_='Filter', fromsubclass_=False, pretty_print=True):
        super(Filter, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.scheduling_policy_unit is not None:
            self.scheduling_policy_unit.export(outfile, level, namespace_, name_='scheduling_policy_unit', pretty_print=pretty_print)
        if self.position is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sposition>%s</%sposition>%s' % (namespace_, self.gds_format_integer(self.position, input_name='position'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Filter'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Filter, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Filter, self).exportLiteralChildren(outfile, level, name_)
        if self.scheduling_policy_unit is not None:
            showIndent(outfile, level)
            outfile.write('scheduling_policy_unit=model_.scheduling_policy_unit(\n')
            self.scheduling_policy_unit.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.position is not None:
            showIndent(outfile, level)
            outfile.write('position=%d,\n' % self.position)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Filter, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'scheduling_policy_unit':
            obj_ = SchedulingPolicyUnit.factory()
            obj_.build(child_)
            self.scheduling_policy_unit = obj_
        elif nodeName_ == 'position':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'position')
            self.position = ival_
        super(Filter, self).buildChildren(child_, node, nodeName_, True)
# end class Filter


class Filters(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, filter=None):
        super(Filters, self).__init__(actions, total, active, )
        if filter is None:
            self.filter = []
        else:
            self.filter = filter
    def factory(*args_, **kwargs_):
        if Filters.subclass:
            return Filters.subclass(*args_, **kwargs_)
        else:
            return Filters(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_filter(self): return self.filter
    def set_filter(self, filter): self.filter = filter
    def add_filter(self, value): self.filter.append(value)
    def insert_filter(self, index, value): self.filter[index] = value
    def hasContent_(self):
        if (
            self.filter or
            super(Filters, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Filters', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Filters')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Filters'):
        super(Filters, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Filters')
    def exportChildren(self, outfile, level, namespace_='', name_='Filters', fromsubclass_=False, pretty_print=True):
        super(Filters, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for filter_ in self.filter:
            filter_.export(outfile, level, namespace_, name_='filter', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Filters'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Filters, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Filters, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('filter=[\n')
        level += 1
        for filter_ in self.filter:
            showIndent(outfile, level)
            outfile.write('model_.filter(\n')
            filter_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Filters, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'filter':
            obj_ = Filter.factory()
            obj_.build(child_)
            self.filter.append(obj_)
        super(Filters, self).buildChildren(child_, node, nodeName_, True)
# end class Filters


class Weight(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, scheduling_policy=None, scheduling_policy_unit=None, factor=None):
        super(Weight, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.scheduling_policy = scheduling_policy
        self.scheduling_policy_unit = scheduling_policy_unit
        self.factor = factor
    def factory(*args_, **kwargs_):
        if Weight.subclass:
            return Weight.subclass(*args_, **kwargs_)
        else:
            return Weight(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_scheduling_policy(self): return self.scheduling_policy
    def set_scheduling_policy(self, scheduling_policy): self.scheduling_policy = scheduling_policy
    def get_scheduling_policy_unit(self): return self.scheduling_policy_unit
    def set_scheduling_policy_unit(self, scheduling_policy_unit): self.scheduling_policy_unit = scheduling_policy_unit
    def get_factor(self): return self.factor
    def set_factor(self, factor): self.factor = factor
    def hasContent_(self):
        if (
            self.scheduling_policy is not None or
            self.scheduling_policy_unit is not None or
            self.factor is not None or
            super(Weight, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Weight', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Weight')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Weight'):
        super(Weight, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Weight')
    def exportChildren(self, outfile, level, namespace_='', name_='Weight', fromsubclass_=False, pretty_print=True):
        super(Weight, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.scheduling_policy is not None:
            self.scheduling_policy.export(outfile, level, namespace_, name_='scheduling_policy', pretty_print=pretty_print)
        if self.scheduling_policy_unit is not None:
            self.scheduling_policy_unit.export(outfile, level, namespace_, name_='scheduling_policy_unit', pretty_print=pretty_print)
        if self.factor is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfactor>%s</%sfactor>%s' % (namespace_, self.gds_format_integer(self.factor, input_name='factor'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Weight'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Weight, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Weight, self).exportLiteralChildren(outfile, level, name_)
        if self.scheduling_policy is not None:
            showIndent(outfile, level)
            outfile.write('scheduling_policy=model_.scheduling_policy(\n')
            self.scheduling_policy.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.scheduling_policy_unit is not None:
            showIndent(outfile, level)
            outfile.write('scheduling_policy_unit=model_.scheduling_policy_unit(\n')
            self.scheduling_policy_unit.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.factor is not None:
            showIndent(outfile, level)
            outfile.write('factor=%d,\n' % self.factor)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Weight, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'scheduling_policy':
            obj_ = SchedulingPolicy.factory()
            obj_.build(child_)
            self.scheduling_policy = obj_
        elif nodeName_ == 'scheduling_policy_unit':
            obj_ = SchedulingPolicyUnit.factory()
            obj_.build(child_)
            self.scheduling_policy_unit = obj_
        elif nodeName_ == 'factor':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'factor')
            self.factor = ival_
        super(Weight, self).buildChildren(child_, node, nodeName_, True)
# end class Weight


class Weights(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, weight=None):
        super(Weights, self).__init__(actions, total, active, )
        if weight is None:
            self.weight = []
        else:
            self.weight = weight
    def factory(*args_, **kwargs_):
        if Weights.subclass:
            return Weights.subclass(*args_, **kwargs_)
        else:
            return Weights(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_weight(self): return self.weight
    def set_weight(self, weight): self.weight = weight
    def add_weight(self, value): self.weight.append(value)
    def insert_weight(self, index, value): self.weight[index] = value
    def hasContent_(self):
        if (
            self.weight or
            super(Weights, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Weights', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Weights')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Weights'):
        super(Weights, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Weights')
    def exportChildren(self, outfile, level, namespace_='', name_='Weights', fromsubclass_=False, pretty_print=True):
        super(Weights, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for weight_ in self.weight:
            weight_.export(outfile, level, namespace_, name_='weight', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Weights'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Weights, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Weights, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('weight=[\n')
        level += 1
        for weight_ in self.weight:
            showIndent(outfile, level)
            outfile.write('model_.weight(\n')
            weight_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Weights, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'weight':
            obj_ = Weight.factory()
            obj_.build(child_)
            self.weight.append(obj_)
        super(Weights, self).buildChildren(child_, node, nodeName_, True)
# end class Weights


class Balance(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, scheduling_policy=None, scheduling_policy_unit=None):
        super(Balance, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.scheduling_policy = scheduling_policy
        self.scheduling_policy_unit = scheduling_policy_unit
    def factory(*args_, **kwargs_):
        if Balance.subclass:
            return Balance.subclass(*args_, **kwargs_)
        else:
            return Balance(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_scheduling_policy(self): return self.scheduling_policy
    def set_scheduling_policy(self, scheduling_policy): self.scheduling_policy = scheduling_policy
    def get_scheduling_policy_unit(self): return self.scheduling_policy_unit
    def set_scheduling_policy_unit(self, scheduling_policy_unit): self.scheduling_policy_unit = scheduling_policy_unit
    def hasContent_(self):
        if (
            self.scheduling_policy is not None or
            self.scheduling_policy_unit is not None or
            super(Balance, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Balance', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Balance')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Balance'):
        super(Balance, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Balance')
    def exportChildren(self, outfile, level, namespace_='', name_='Balance', fromsubclass_=False, pretty_print=True):
        super(Balance, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.scheduling_policy is not None:
            self.scheduling_policy.export(outfile, level, namespace_, name_='scheduling_policy', pretty_print=pretty_print)
        if self.scheduling_policy_unit is not None:
            self.scheduling_policy_unit.export(outfile, level, namespace_, name_='scheduling_policy_unit', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Balance'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Balance, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Balance, self).exportLiteralChildren(outfile, level, name_)
        if self.scheduling_policy is not None:
            showIndent(outfile, level)
            outfile.write('scheduling_policy=model_.scheduling_policy(\n')
            self.scheduling_policy.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.scheduling_policy_unit is not None:
            showIndent(outfile, level)
            outfile.write('scheduling_policy_unit=model_.scheduling_policy_unit(\n')
            self.scheduling_policy_unit.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Balance, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'scheduling_policy':
            obj_ = SchedulingPolicy.factory()
            obj_.build(child_)
            self.scheduling_policy = obj_
        elif nodeName_ == 'scheduling_policy_unit':
            obj_ = SchedulingPolicyUnit.factory()
            obj_.build(child_)
            self.scheduling_policy_unit = obj_
        super(Balance, self).buildChildren(child_, node, nodeName_, True)
# end class Balance


class Balances(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, balance=None):
        super(Balances, self).__init__(actions, total, active, )
        self.balance = balance
    def factory(*args_, **kwargs_):
        if Balances.subclass:
            return Balances.subclass(*args_, **kwargs_)
        else:
            return Balances(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_balance(self): return self.balance
    def set_balance(self, balance): self.balance = balance
    def hasContent_(self):
        if (
            self.balance is not None or
            super(Balances, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Balances', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Balances')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Balances'):
        super(Balances, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Balances')
    def exportChildren(self, outfile, level, namespace_='', name_='Balances', fromsubclass_=False, pretty_print=True):
        super(Balances, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.balance is not None:
            self.balance.export(outfile, level, namespace_, name_='balance', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Balances'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Balances, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Balances, self).exportLiteralChildren(outfile, level, name_)
        if self.balance is not None:
            showIndent(outfile, level)
            outfile.write('balance=model_.balance(\n')
            self.balance.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Balances, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'balance':
            obj_ = Balance.factory()
            obj_.build(child_)
            self.balance = obj_
        super(Balances, self).buildChildren(child_, node, nodeName_, True)
# end class Balances


class SchedulingPolicy(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, policy=None, thresholds=None, locked=None, default_policy=None, properties=None):
        super(SchedulingPolicy, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.policy = policy
        self.thresholds = thresholds
        self.locked = locked
        self.default_policy = default_policy
        self.properties = properties
    def factory(*args_, **kwargs_):
        if SchedulingPolicy.subclass:
            return SchedulingPolicy.subclass(*args_, **kwargs_)
        else:
            return SchedulingPolicy(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_policy(self): return self.policy
    def set_policy(self, policy): self.policy = policy
    def get_thresholds(self): return self.thresholds
    def set_thresholds(self, thresholds): self.thresholds = thresholds
    def get_locked(self): return self.locked
    def set_locked(self, locked): self.locked = locked
    def get_default_policy(self): return self.default_policy
    def set_default_policy(self, default_policy): self.default_policy = default_policy
    def get_properties(self): return self.properties
    def set_properties(self, properties): self.properties = properties
    def hasContent_(self):
        if (
            self.policy is not None or
            self.thresholds is not None or
            self.locked is not None or
            self.default_policy is not None or
            self.properties is not None or
            super(SchedulingPolicy, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SchedulingPolicy', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SchedulingPolicy')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SchedulingPolicy'):
        super(SchedulingPolicy, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SchedulingPolicy')
    def exportChildren(self, outfile, level, namespace_='', name_='SchedulingPolicy', fromsubclass_=False, pretty_print=True):
        super(SchedulingPolicy, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.policy is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spolicy>%s</%spolicy>%s' % (namespace_, self.gds_format_string(quote_xml(self.policy).encode(ExternalEncoding), input_name='policy'), namespace_, eol_))
        if self.thresholds is not None:
            self.thresholds.export(outfile, level, namespace_, name_='thresholds', pretty_print=pretty_print)
        if self.locked is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slocked>%s</%slocked>%s' % (namespace_, self.gds_format_boolean(self.locked, input_name='locked'), namespace_, eol_))
        if self.default_policy is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdefault_policy>%s</%sdefault_policy>%s' % (namespace_, self.gds_format_boolean(self.default_policy, input_name='default_policy'), namespace_, eol_))
        if self.properties is not None:
            self.properties.export(outfile, level, namespace_, name_='properties', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SchedulingPolicy'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(SchedulingPolicy, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(SchedulingPolicy, self).exportLiteralChildren(outfile, level, name_)
        if self.policy is not None:
            showIndent(outfile, level)
            outfile.write('policy=%s,\n' % quote_python(self.policy).encode(ExternalEncoding))
        if self.thresholds is not None:
            showIndent(outfile, level)
            outfile.write('thresholds=model_.SchedulingPolicyThresholds(\n')
            self.thresholds.exportLiteral(outfile, level, name_='thresholds')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.locked is not None:
            showIndent(outfile, level)
            outfile.write('locked=%s,\n' % self.locked)
        if self.default_policy is not None:
            showIndent(outfile, level)
            outfile.write('default_policy=%s,\n' % self.default_policy)
        if self.properties is not None:
            showIndent(outfile, level)
            outfile.write('properties=model_.properties(\n')
            self.properties.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(SchedulingPolicy, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'policy':
            policy_ = child_.text
            policy_ = self.gds_validate_string(policy_, node, 'policy')
            self.policy = policy_
        elif nodeName_ == 'thresholds':
            obj_ = SchedulingPolicyThresholds.factory()
            obj_.build(child_)
            self.thresholds = obj_
        elif nodeName_ == 'locked':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'locked')
            self.locked = ival_
        elif nodeName_ == 'default_policy':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'default_policy')
            self.default_policy = ival_
        elif nodeName_ == 'properties':
            obj_ = Properties.factory()
            obj_.build(child_)
            self.properties = obj_
        super(SchedulingPolicy, self).buildChildren(child_, node, nodeName_, True)
# end class SchedulingPolicy


class Cluster(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, cpu=None, data_center=None, memory_policy=None, scheduling_policy=None, version=None, supported_versions=None, error_handling=None, virt_service=None, gluster_service=None, threads_as_cores=None, tunnel_migration=None, trusted_service=None, ha_reservation=None, optional_reason=None, ballooning_enabled=None, display=None, ksm=None, serial_number=None, required_rng_sources=None):
        super(Cluster, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.cpu = cpu
        self.data_center = data_center
        self.memory_policy = memory_policy
        self.scheduling_policy = scheduling_policy
        self.version = version
        self.supported_versions = supported_versions
        self.error_handling = error_handling
        self.virt_service = virt_service
        self.gluster_service = gluster_service
        self.threads_as_cores = threads_as_cores
        self.tunnel_migration = tunnel_migration
        self.trusted_service = trusted_service
        self.ha_reservation = ha_reservation
        self.optional_reason = optional_reason
        self.ballooning_enabled = ballooning_enabled
        self.display = display
        self.ksm = ksm
        self.serial_number = serial_number
        self.required_rng_sources = required_rng_sources
    def factory(*args_, **kwargs_):
        if Cluster.subclass:
            return Cluster.subclass(*args_, **kwargs_)
        else:
            return Cluster(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cpu(self): return self.cpu
    def set_cpu(self, cpu): self.cpu = cpu
    def get_data_center(self): return self.data_center
    def set_data_center(self, data_center): self.data_center = data_center
    def get_memory_policy(self): return self.memory_policy
    def set_memory_policy(self, memory_policy): self.memory_policy = memory_policy
    def get_scheduling_policy(self): return self.scheduling_policy
    def set_scheduling_policy(self, scheduling_policy): self.scheduling_policy = scheduling_policy
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_supported_versions(self): return self.supported_versions
    def set_supported_versions(self, supported_versions): self.supported_versions = supported_versions
    def get_error_handling(self): return self.error_handling
    def set_error_handling(self, error_handling): self.error_handling = error_handling
    def get_virt_service(self): return self.virt_service
    def set_virt_service(self, virt_service): self.virt_service = virt_service
    def get_gluster_service(self): return self.gluster_service
    def set_gluster_service(self, gluster_service): self.gluster_service = gluster_service
    def get_threads_as_cores(self): return self.threads_as_cores
    def set_threads_as_cores(self, threads_as_cores): self.threads_as_cores = threads_as_cores
    def get_tunnel_migration(self): return self.tunnel_migration
    def set_tunnel_migration(self, tunnel_migration): self.tunnel_migration = tunnel_migration
    def get_trusted_service(self): return self.trusted_service
    def set_trusted_service(self, trusted_service): self.trusted_service = trusted_service
    def get_ha_reservation(self): return self.ha_reservation
    def set_ha_reservation(self, ha_reservation): self.ha_reservation = ha_reservation
    def get_optional_reason(self): return self.optional_reason
    def set_optional_reason(self, optional_reason): self.optional_reason = optional_reason
    def get_ballooning_enabled(self): return self.ballooning_enabled
    def set_ballooning_enabled(self, ballooning_enabled): self.ballooning_enabled = ballooning_enabled
    def get_display(self): return self.display
    def set_display(self, display): self.display = display
    def get_ksm(self): return self.ksm
    def set_ksm(self, ksm): self.ksm = ksm
    def get_serial_number(self): return self.serial_number
    def set_serial_number(self, serial_number): self.serial_number = serial_number
    def get_required_rng_sources(self): return self.required_rng_sources
    def set_required_rng_sources(self, required_rng_sources): self.required_rng_sources = required_rng_sources
    def hasContent_(self):
        if (
            self.cpu is not None or
            self.data_center is not None or
            self.memory_policy is not None or
            self.scheduling_policy is not None or
            self.version is not None or
            self.supported_versions is not None or
            self.error_handling is not None or
            self.virt_service is not None or
            self.gluster_service is not None or
            self.threads_as_cores is not None or
            self.tunnel_migration is not None or
            self.trusted_service is not None or
            self.ha_reservation is not None or
            self.optional_reason is not None or
            self.ballooning_enabled is not None or
            self.display is not None or
            self.ksm is not None or
            self.serial_number is not None or
            self.required_rng_sources is not None or
            super(Cluster, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Cluster', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Cluster')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Cluster'):
        super(Cluster, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Cluster')
    def exportChildren(self, outfile, level, namespace_='', name_='Cluster', fromsubclass_=False, pretty_print=True):
        super(Cluster, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cpu is not None:
            self.cpu.export(outfile, level, namespace_, name_='cpu', pretty_print=pretty_print)
        if self.data_center is not None:
            self.data_center.export(outfile, level, namespace_, name_='data_center', pretty_print=pretty_print)
        if self.memory_policy is not None:
            self.memory_policy.export(outfile, level, namespace_, name_='memory_policy', pretty_print=pretty_print)
        if self.scheduling_policy is not None:
            self.scheduling_policy.export(outfile, level, namespace_, name_='scheduling_policy', pretty_print=pretty_print)
        if self.version is not None:
            self.version.export(outfile, level, namespace_, name_='version', pretty_print=pretty_print)
        if self.supported_versions is not None:
            self.supported_versions.export(outfile, level, namespace_, name_='supported_versions', pretty_print=pretty_print)
        if self.error_handling is not None:
            self.error_handling.export(outfile, level, namespace_, name_='error_handling', pretty_print=pretty_print)
        if self.virt_service is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svirt_service>%s</%svirt_service>%s' % (namespace_, self.gds_format_boolean(self.virt_service, input_name='virt_service'), namespace_, eol_))
        if self.gluster_service is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgluster_service>%s</%sgluster_service>%s' % (namespace_, self.gds_format_boolean(self.gluster_service, input_name='gluster_service'), namespace_, eol_))
        if self.threads_as_cores is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sthreads_as_cores>%s</%sthreads_as_cores>%s' % (namespace_, self.gds_format_boolean(self.threads_as_cores, input_name='threads_as_cores'), namespace_, eol_))
        if self.tunnel_migration is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stunnel_migration>%s</%stunnel_migration>%s' % (namespace_, self.gds_format_boolean(self.tunnel_migration, input_name='tunnel_migration'), namespace_, eol_))
        if self.trusted_service is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%strusted_service>%s</%strusted_service>%s' % (namespace_, self.gds_format_boolean(self.trusted_service, input_name='trusted_service'), namespace_, eol_))
        if self.ha_reservation is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sha_reservation>%s</%sha_reservation>%s' % (namespace_, self.gds_format_boolean(self.ha_reservation, input_name='ha_reservation'), namespace_, eol_))
        if self.optional_reason is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soptional_reason>%s</%soptional_reason>%s' % (namespace_, self.gds_format_boolean(self.optional_reason, input_name='optional_reason'), namespace_, eol_))
        if self.ballooning_enabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sballooning_enabled>%s</%sballooning_enabled>%s' % (namespace_, self.gds_format_boolean(self.ballooning_enabled, input_name='ballooning_enabled'), namespace_, eol_))
        if self.display is not None:
            self.display.export(outfile, level, namespace_, name_='display', pretty_print=pretty_print)
        if self.ksm is not None:
            self.ksm.export(outfile, level, namespace_, name_='ksm', pretty_print=pretty_print)
        if self.serial_number is not None:
            self.serial_number.export(outfile, level, namespace_, name_='serial_number', pretty_print=pretty_print)
        if self.required_rng_sources is not None:
            self.required_rng_sources.export(outfile, level, namespace_, name_='required_rng_sources', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Cluster'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Cluster, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Cluster, self).exportLiteralChildren(outfile, level, name_)
        if self.cpu is not None:
            showIndent(outfile, level)
            outfile.write('cpu=model_.cpu(\n')
            self.cpu.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.data_center is not None:
            showIndent(outfile, level)
            outfile.write('data_center=model_.data_center(\n')
            self.data_center.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.memory_policy is not None:
            showIndent(outfile, level)
            outfile.write('memory_policy=model_.MemoryPolicy(\n')
            self.memory_policy.exportLiteral(outfile, level, name_='memory_policy')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.scheduling_policy is not None:
            showIndent(outfile, level)
            outfile.write('scheduling_policy=model_.SchedulingPolicy(\n')
            self.scheduling_policy.exportLiteral(outfile, level, name_='scheduling_policy')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=model_.Version(\n')
            self.version.exportLiteral(outfile, level, name_='version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.supported_versions is not None:
            showIndent(outfile, level)
            outfile.write('supported_versions=model_.SupportedVersions(\n')
            self.supported_versions.exportLiteral(outfile, level, name_='supported_versions')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.error_handling is not None:
            showIndent(outfile, level)
            outfile.write('error_handling=model_.ErrorHandling(\n')
            self.error_handling.exportLiteral(outfile, level, name_='error_handling')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.virt_service is not None:
            showIndent(outfile, level)
            outfile.write('virt_service=%s,\n' % self.virt_service)
        if self.gluster_service is not None:
            showIndent(outfile, level)
            outfile.write('gluster_service=%s,\n' % self.gluster_service)
        if self.threads_as_cores is not None:
            showIndent(outfile, level)
            outfile.write('threads_as_cores=%s,\n' % self.threads_as_cores)
        if self.tunnel_migration is not None:
            showIndent(outfile, level)
            outfile.write('tunnel_migration=%s,\n' % self.tunnel_migration)
        if self.trusted_service is not None:
            showIndent(outfile, level)
            outfile.write('trusted_service=%s,\n' % self.trusted_service)
        if self.ha_reservation is not None:
            showIndent(outfile, level)
            outfile.write('ha_reservation=%s,\n' % self.ha_reservation)
        if self.optional_reason is not None:
            showIndent(outfile, level)
            outfile.write('optional_reason=%s,\n' % self.optional_reason)
        if self.ballooning_enabled is not None:
            showIndent(outfile, level)
            outfile.write('ballooning_enabled=%s,\n' % self.ballooning_enabled)
        if self.display is not None:
            showIndent(outfile, level)
            outfile.write('display=model_.display(\n')
            self.display.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ksm is not None:
            showIndent(outfile, level)
            outfile.write('ksm=model_.ksm(\n')
            self.ksm.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.serial_number is not None:
            showIndent(outfile, level)
            outfile.write('serial_number=model_.serial_number(\n')
            self.serial_number.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.required_rng_sources is not None:
            showIndent(outfile, level)
            outfile.write('required_rng_sources=model_.RngSources(\n')
            self.required_rng_sources.exportLiteral(outfile, level, name_='required_rng_sources')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Cluster, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'cpu':
            obj_ = CPU.factory()
            obj_.build(child_)
            self.cpu = obj_
        elif nodeName_ == 'data_center':
            obj_ = DataCenter.factory()
            obj_.build(child_)
            self.data_center = obj_
        elif nodeName_ == 'memory_policy':
            obj_ = MemoryPolicy.factory()
            obj_.build(child_)
            self.memory_policy = obj_
        elif nodeName_ == 'scheduling_policy':
            obj_ = SchedulingPolicy.factory()
            obj_.build(child_)
            self.scheduling_policy = obj_
        elif nodeName_ == 'version':
            class_obj_ = self.get_class_obj_(child_, Version)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.version = obj_
        elif nodeName_ == 'supported_versions':
            obj_ = SupportedVersions.factory()
            obj_.build(child_)
            self.supported_versions = obj_
        elif nodeName_ == 'error_handling':
            obj_ = ErrorHandling.factory()
            obj_.build(child_)
            self.error_handling = obj_
        elif nodeName_ == 'virt_service':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'virt_service')
            self.virt_service = ival_
        elif nodeName_ == 'gluster_service':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'gluster_service')
            self.gluster_service = ival_
        elif nodeName_ == 'threads_as_cores':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'threads_as_cores')
            self.threads_as_cores = ival_
        elif nodeName_ == 'tunnel_migration':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'tunnel_migration')
            self.tunnel_migration = ival_
        elif nodeName_ == 'trusted_service':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'trusted_service')
            self.trusted_service = ival_
        elif nodeName_ == 'ha_reservation':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ha_reservation')
            self.ha_reservation = ival_
        elif nodeName_ == 'optional_reason':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'optional_reason')
            self.optional_reason = ival_
        elif nodeName_ == 'ballooning_enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ballooning_enabled')
            self.ballooning_enabled = ival_
        elif nodeName_ == 'display':
            obj_ = Display.factory()
            obj_.build(child_)
            self.display = obj_
        elif nodeName_ == 'ksm':
            obj_ = KSM.factory()
            obj_.build(child_)
            self.ksm = obj_
        elif nodeName_ == 'serial_number':
            obj_ = SerialNumber.factory()
            obj_.build(child_)
            self.serial_number = obj_
        elif nodeName_ == 'required_rng_sources':
            obj_ = RngSources.factory()
            obj_.build(child_)
            self.required_rng_sources = obj_
        super(Cluster, self).buildChildren(child_, node, nodeName_, True)
# end class Cluster


class Clusters(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, cluster=None):
        super(Clusters, self).__init__(actions, total, active, )
        if cluster is None:
            self.cluster = []
        else:
            self.cluster = cluster
    def factory(*args_, **kwargs_):
        if Clusters.subclass:
            return Clusters.subclass(*args_, **kwargs_)
        else:
            return Clusters(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def add_cluster(self, value): self.cluster.append(value)
    def insert_cluster(self, index, value): self.cluster[index] = value
    def hasContent_(self):
        if (
            self.cluster or
            super(Clusters, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Clusters', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Clusters')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Clusters'):
        super(Clusters, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Clusters')
    def exportChildren(self, outfile, level, namespace_='', name_='Clusters', fromsubclass_=False, pretty_print=True):
        super(Clusters, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for cluster_ in self.cluster:
            cluster_.export(outfile, level, namespace_, name_='cluster', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Clusters'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Clusters, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Clusters, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('cluster=[\n')
        level += 1
        for cluster_ in self.cluster:
            showIndent(outfile, level)
            outfile.write('model_.cluster(\n')
            cluster_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Clusters, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.cluster.append(obj_)
        super(Clusters, self).buildChildren(child_, node, nodeName_, True)
# end class Clusters


class Agent(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, address=None, username=None, password=None, options=None, concurrent=None, order=None):
        self.type_ = _cast(None, type_)
        self.address = address
        self.username = username
        self.password = password
        self.options = options
        self.concurrent = concurrent
        self.order = order
    def factory(*args_, **kwargs_):
        if Agent.subclass:
            return Agent.subclass(*args_, **kwargs_)
        else:
            return Agent(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_username(self): return self.username
    def set_username(self, username): self.username = username
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_options(self): return self.options
    def set_options(self, options): self.options = options
    def get_concurrent(self): return self.concurrent
    def set_concurrent(self, concurrent): self.concurrent = concurrent
    def get_order(self): return self.order
    def set_order(self, order): self.order = order
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def hasContent_(self):
        if (
            self.address is not None or
            self.username is not None or
            self.password is not None or
            self.options is not None or
            self.concurrent is not None or
            self.order is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Agent', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Agent')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Agent'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Agent', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.address is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress>%s</%saddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_, eol_))
        if self.username is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%susername>%s</%susername>%s' % (namespace_, self.gds_format_string(quote_xml(self.username).encode(ExternalEncoding), input_name='username'), namespace_, eol_))
        if self.password is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespace_, self.gds_format_string(quote_xml(self.password).encode(ExternalEncoding), input_name='password'), namespace_, eol_))
        if self.options is not None:
            self.options.export(outfile, level, namespace_, name_='options', pretty_print=pretty_print)
        if self.concurrent is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sconcurrent>%s</%sconcurrent>%s' % (namespace_, self.gds_format_boolean(self.concurrent, input_name='concurrent'), namespace_, eol_))
        if self.order is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorder>%s</%sorder>%s' % (namespace_, self.gds_format_integer(self.order, input_name='order'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Agent'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.username is not None:
            showIndent(outfile, level)
            outfile.write('username=%s,\n' % quote_python(self.username).encode(ExternalEncoding))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % quote_python(self.password).encode(ExternalEncoding))
        if self.options is not None:
            showIndent(outfile, level)
            outfile.write('options=model_.options(\n')
            self.options.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.concurrent is not None:
            showIndent(outfile, level)
            outfile.write('concurrent=%s,\n' % self.concurrent)
        if self.order is not None:
            showIndent(outfile, level)
            outfile.write('order=%d,\n' % self.order)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'username':
            username_ = child_.text
            username_ = self.gds_validate_string(username_, node, 'username')
            self.username = username_
        elif nodeName_ == 'password':
            password_ = child_.text
            password_ = self.gds_validate_string(password_, node, 'password')
            self.password = password_
        elif nodeName_ == 'options':
            obj_ = Options.factory()
            obj_.build(child_)
            self.options = obj_
        elif nodeName_ == 'concurrent':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'concurrent')
            self.concurrent = ival_
        elif nodeName_ == 'order':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'order')
            self.order = ival_
# end class Agent


class Agents(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, agent=None):
        if agent is None:
            self.agent = []
        else:
            self.agent = agent
    def factory(*args_, **kwargs_):
        if Agents.subclass:
            return Agents.subclass(*args_, **kwargs_)
        else:
            return Agents(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_agent(self): return self.agent
    def set_agent(self, agent): self.agent = agent
    def add_agent(self, value): self.agent.append(value)
    def insert_agent(self, index, value): self.agent[index] = value
    def hasContent_(self):
        if (
            self.agent
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Agents', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Agents')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Agents'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Agents', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for agent_ in self.agent:
            agent_.export(outfile, level, namespace_, name_='agent', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Agents'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('agent=[\n')
        level += 1
        for agent_ in self.agent:
            showIndent(outfile, level)
            outfile.write('model_.Agent(\n')
            agent_.exportLiteral(outfile, level, name_='Agent')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'agent':
            obj_ = Agent.factory()
            obj_.build(child_)
            self.agent.append(obj_)
# end class Agents


class PowerManagement(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, enabled=None, address=None, username=None, password=None, options=None, status=None, pm_proxies=None, agents=None, automatic_pm_enabled=None, kdump_detection=None):
        self.type_ = _cast(None, type_)
        self.enabled = enabled
        self.address = address
        self.username = username
        self.password = password
        self.options = options
        self.status = status
        self.pm_proxies = pm_proxies
        self.agents = agents
        self.automatic_pm_enabled = automatic_pm_enabled
        self.kdump_detection = kdump_detection
    def factory(*args_, **kwargs_):
        if PowerManagement.subclass:
            return PowerManagement.subclass(*args_, **kwargs_)
        else:
            return PowerManagement(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_enabled(self): return self.enabled
    def set_enabled(self, enabled): self.enabled = enabled
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_username(self): return self.username
    def set_username(self, username): self.username = username
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_options(self): return self.options
    def set_options(self, options): self.options = options
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_pm_proxies(self): return self.pm_proxies
    def set_pm_proxies(self, pm_proxies): self.pm_proxies = pm_proxies
    def get_agents(self): return self.agents
    def set_agents(self, agents): self.agents = agents
    def get_automatic_pm_enabled(self): return self.automatic_pm_enabled
    def set_automatic_pm_enabled(self, automatic_pm_enabled): self.automatic_pm_enabled = automatic_pm_enabled
    def get_kdump_detection(self): return self.kdump_detection
    def set_kdump_detection(self, kdump_detection): self.kdump_detection = kdump_detection
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def hasContent_(self):
        if (
            self.enabled is not None or
            self.address is not None or
            self.username is not None or
            self.password is not None or
            self.options is not None or
            self.status is not None or
            self.pm_proxies is not None or
            self.agents is not None or
            self.automatic_pm_enabled is not None or
            self.kdump_detection is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PowerManagement', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PowerManagement')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PowerManagement'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PowerManagement', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.enabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%senabled>%s</%senabled>%s' % (namespace_, self.gds_format_boolean(self.enabled, input_name='enabled'), namespace_, eol_))
        if self.address is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress>%s</%saddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_, eol_))
        if self.username is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%susername>%s</%susername>%s' % (namespace_, self.gds_format_string(quote_xml(self.username).encode(ExternalEncoding), input_name='username'), namespace_, eol_))
        if self.password is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespace_, self.gds_format_string(quote_xml(self.password).encode(ExternalEncoding), input_name='password'), namespace_, eol_))
        if self.options is not None:
            self.options.export(outfile, level, namespace_, name_='options', pretty_print=pretty_print)
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status', pretty_print=pretty_print)
        if self.pm_proxies is not None:
            self.pm_proxies.export(outfile, level, namespace_, name_='pm_proxies', pretty_print=pretty_print)
        if self.agents is not None:
            self.agents.export(outfile, level, namespace_, name_='agents', pretty_print=pretty_print)
        if self.automatic_pm_enabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sautomatic_pm_enabled>%s</%sautomatic_pm_enabled>%s' % (namespace_, self.gds_format_boolean(self.automatic_pm_enabled, input_name='automatic_pm_enabled'), namespace_, eol_))
        if self.kdump_detection is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skdump_detection>%s</%skdump_detection>%s' % (namespace_, self.gds_format_boolean(self.kdump_detection, input_name='kdump_detection'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='PowerManagement'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.enabled is not None:
            showIndent(outfile, level)
            outfile.write('enabled=%s,\n' % self.enabled)
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.username is not None:
            showIndent(outfile, level)
            outfile.write('username=%s,\n' % quote_python(self.username).encode(ExternalEncoding))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % quote_python(self.password).encode(ExternalEncoding))
        if self.options is not None:
            showIndent(outfile, level)
            outfile.write('options=model_.Options(\n')
            self.options.exportLiteral(outfile, level, name_='options')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.pm_proxies is not None:
            showIndent(outfile, level)
            outfile.write('pm_proxies=model_.pm_proxies(\n')
            self.pm_proxies.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.agents is not None:
            showIndent(outfile, level)
            outfile.write('agents=model_.agents(\n')
            self.agents.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.automatic_pm_enabled is not None:
            showIndent(outfile, level)
            outfile.write('automatic_pm_enabled=%s,\n' % self.automatic_pm_enabled)
        if self.kdump_detection is not None:
            showIndent(outfile, level)
            outfile.write('kdump_detection=%s,\n' % self.kdump_detection)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'enabled')
            self.enabled = ival_
        elif nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'username':
            username_ = child_.text
            username_ = self.gds_validate_string(username_, node, 'username')
            self.username = username_
        elif nodeName_ == 'password':
            password_ = child_.text
            password_ = self.gds_validate_string(password_, node, 'password')
            self.password = password_
        elif nodeName_ == 'options':
            obj_ = Options.factory()
            obj_.build(child_)
            self.options = obj_
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.status = obj_
        elif nodeName_ == 'pm_proxies':
            obj_ = PmProxies.factory()
            obj_.build(child_)
            self.pm_proxies = obj_
        elif nodeName_ == 'agents':
            obj_ = Agents.factory()
            obj_.build(child_)
            self.agents = obj_
        elif nodeName_ == 'automatic_pm_enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'automatic_pm_enabled')
            self.automatic_pm_enabled = ival_
        elif nodeName_ == 'kdump_detection':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'kdump_detection')
            self.kdump_detection = ival_
# end class PowerManagement


class PowerManagementStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, power_management_state=None):
        if power_management_state is None:
            self.power_management_state = []
        else:
            self.power_management_state = power_management_state
    def factory(*args_, **kwargs_):
        if PowerManagementStates.subclass:
            return PowerManagementStates.subclass(*args_, **kwargs_)
        else:
            return PowerManagementStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_power_management_state(self): return self.power_management_state
    def set_power_management_state(self, power_management_state): self.power_management_state = power_management_state
    def add_power_management_state(self, value): self.power_management_state.append(value)
    def insert_power_management_state(self, index, value): self.power_management_state[index] = value
    def hasContent_(self):
        if (
            self.power_management_state
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PowerManagementStates', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PowerManagementStates')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PowerManagementStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='PowerManagementStates', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for power_management_state_ in self.power_management_state:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spower_management_state>%s</%spower_management_state>%s' % (namespace_, self.gds_format_string(quote_xml(power_management_state_).encode(ExternalEncoding), input_name='power_management_state'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='PowerManagementStates'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('power_management_state=[\n')
        level += 1
        for power_management_state_ in self.power_management_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(power_management_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'power_management_state':
            power_management_state_ = child_.text
            power_management_state_ = self.gds_validate_string(power_management_state_, node, 'power_management_state')
            self.power_management_state.append(power_management_state_)
# end class PowerManagementStates


class HardwareInformation(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, manufacturer=None, version=None, serial_number=None, product_name=None, uuid=None, family=None, supported_rng_sources=None):
        self.manufacturer = manufacturer
        self.version = version
        self.serial_number = serial_number
        self.product_name = product_name
        self.uuid = uuid
        self.family = family
        self.supported_rng_sources = supported_rng_sources
    def factory(*args_, **kwargs_):
        if HardwareInformation.subclass:
            return HardwareInformation.subclass(*args_, **kwargs_)
        else:
            return HardwareInformation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_manufacturer(self): return self.manufacturer
    def set_manufacturer(self, manufacturer): self.manufacturer = manufacturer
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_serial_number(self): return self.serial_number
    def set_serial_number(self, serial_number): self.serial_number = serial_number
    def get_product_name(self): return self.product_name
    def set_product_name(self, product_name): self.product_name = product_name
    def get_uuid(self): return self.uuid
    def set_uuid(self, uuid): self.uuid = uuid
    def get_family(self): return self.family
    def set_family(self, family): self.family = family
    def get_supported_rng_sources(self): return self.supported_rng_sources
    def set_supported_rng_sources(self, supported_rng_sources): self.supported_rng_sources = supported_rng_sources
    def hasContent_(self):
        if (
            self.manufacturer is not None or
            self.version is not None or
            self.serial_number is not None or
            self.product_name is not None or
            self.uuid is not None or
            self.family is not None or
            self.supported_rng_sources is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='HardwareInformation', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HardwareInformation')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HardwareInformation'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='HardwareInformation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.manufacturer is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smanufacturer>%s</%smanufacturer>%s' % (namespace_, self.gds_format_string(quote_xml(self.manufacturer).encode(ExternalEncoding), input_name='manufacturer'), namespace_, eol_))
        if self.version is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion>%s</%sversion>%s' % (namespace_, self.gds_format_string(quote_xml(self.version).encode(ExternalEncoding), input_name='version'), namespace_, eol_))
        if self.serial_number is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sserial_number>%s</%sserial_number>%s' % (namespace_, self.gds_format_string(quote_xml(self.serial_number).encode(ExternalEncoding), input_name='serial_number'), namespace_, eol_))
        if self.product_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sproduct_name>%s</%sproduct_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.product_name).encode(ExternalEncoding), input_name='product_name'), namespace_, eol_))
        if self.uuid is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suuid>%s</%suuid>%s' % (namespace_, self.gds_format_string(quote_xml(self.uuid).encode(ExternalEncoding), input_name='uuid'), namespace_, eol_))
        if self.family is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfamily>%s</%sfamily>%s' % (namespace_, self.gds_format_string(quote_xml(self.family).encode(ExternalEncoding), input_name='family'), namespace_, eol_))
        if self.supported_rng_sources is not None:
            self.supported_rng_sources.export(outfile, level, namespace_, name_='supported_rng_sources', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='HardwareInformation'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.manufacturer is not None:
            showIndent(outfile, level)
            outfile.write('manufacturer=%s,\n' % quote_python(self.manufacturer).encode(ExternalEncoding))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=%s,\n' % quote_python(self.version).encode(ExternalEncoding))
        if self.serial_number is not None:
            showIndent(outfile, level)
            outfile.write('serial_number=%s,\n' % quote_python(self.serial_number).encode(ExternalEncoding))
        if self.product_name is not None:
            showIndent(outfile, level)
            outfile.write('product_name=%s,\n' % quote_python(self.product_name).encode(ExternalEncoding))
        if self.uuid is not None:
            showIndent(outfile, level)
            outfile.write('uuid=%s,\n' % quote_python(self.uuid).encode(ExternalEncoding))
        if self.family is not None:
            showIndent(outfile, level)
            outfile.write('family=%s,\n' % quote_python(self.family).encode(ExternalEncoding))
        if self.supported_rng_sources is not None:
            showIndent(outfile, level)
            outfile.write('supported_rng_sources=model_.RngSources(\n')
            self.supported_rng_sources.exportLiteral(outfile, level, name_='supported_rng_sources')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'manufacturer':
            manufacturer_ = child_.text
            manufacturer_ = self.gds_validate_string(manufacturer_, node, 'manufacturer')
            self.manufacturer = manufacturer_
        elif nodeName_ == 'version':
            version_ = child_.text
            version_ = self.gds_validate_string(version_, node, 'version')
            self.version = version_
        elif nodeName_ == 'serial_number':
            serial_number_ = child_.text
            serial_number_ = self.gds_validate_string(serial_number_, node, 'serial_number')
            self.serial_number = serial_number_
        elif nodeName_ == 'product_name':
            product_name_ = child_.text
            product_name_ = self.gds_validate_string(product_name_, node, 'product_name')
            self.product_name = product_name_
        elif nodeName_ == 'uuid':
            uuid_ = child_.text
            uuid_ = self.gds_validate_string(uuid_, node, 'uuid')
            self.uuid = uuid_
        elif nodeName_ == 'family':
            family_ = child_.text
            family_ = self.gds_validate_string(family_, node, 'family')
            self.family = family_
        elif nodeName_ == 'supported_rng_sources':
            obj_ = RngSources.factory()
            obj_.build(child_)
            self.supported_rng_sources = obj_
# end class HardwareInformation


class PowerManagers(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, power_management=None):
        if power_management is None:
            self.power_management = []
        else:
            self.power_management = power_management
    def factory(*args_, **kwargs_):
        if PowerManagers.subclass:
            return PowerManagers.subclass(*args_, **kwargs_)
        else:
            return PowerManagers(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_power_management(self): return self.power_management
    def set_power_management(self, power_management): self.power_management = power_management
    def add_power_management(self, value): self.power_management.append(value)
    def insert_power_management(self, index, value): self.power_management[index] = value
    def hasContent_(self):
        if (
            self.power_management
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PowerManagers', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PowerManagers')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PowerManagers'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='PowerManagers', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for power_management_ in self.power_management:
            power_management_.export(outfile, level, namespace_, name_='power_management', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='PowerManagers'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('power_management=[\n')
        level += 1
        for power_management_ in self.power_management:
            showIndent(outfile, level)
            outfile.write('model_.power_management(\n')
            power_management_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'power_management':
            obj_ = PowerManagement.factory()
            obj_.build(child_)
            self.power_management.append(obj_)
# end class PowerManagers


class KSM(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, enabled=None):
        self.enabled = enabled
    def factory(*args_, **kwargs_):
        if KSM.subclass:
            return KSM.subclass(*args_, **kwargs_)
        else:
            return KSM(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_enabled(self): return self.enabled
    def set_enabled(self, enabled): self.enabled = enabled
    def hasContent_(self):
        if (
            self.enabled is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='KSM', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='KSM')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='KSM'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='KSM', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.enabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%senabled>%s</%senabled>%s' % (namespace_, self.gds_format_boolean(self.enabled, input_name='enabled'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='KSM'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.enabled is not None:
            showIndent(outfile, level)
            outfile.write('enabled=%s,\n' % self.enabled)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'enabled')
            self.enabled = ival_
# end class KSM


class TransparentHugePages(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, enabled=None):
        self.enabled = enabled
    def factory(*args_, **kwargs_):
        if TransparentHugePages.subclass:
            return TransparentHugePages.subclass(*args_, **kwargs_)
        else:
            return TransparentHugePages(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_enabled(self): return self.enabled
    def set_enabled(self, enabled): self.enabled = enabled
    def hasContent_(self):
        if (
            self.enabled is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TransparentHugePages', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TransparentHugePages')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TransparentHugePages'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='TransparentHugePages', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.enabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%senabled>%s</%senabled>%s' % (namespace_, self.gds_format_boolean(self.enabled, input_name='enabled'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='TransparentHugePages'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.enabled is not None:
            showIndent(outfile, level)
            outfile.write('enabled=%s,\n' % self.enabled)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'enabled')
            self.enabled = ival_
# end class TransparentHugePages


class Certificate(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, organization=None, subject=None):
        self.organization = organization
        self.subject = subject
    def factory(*args_, **kwargs_):
        if Certificate.subclass:
            return Certificate.subclass(*args_, **kwargs_)
        else:
            return Certificate(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_organization(self): return self.organization
    def set_organization(self, organization): self.organization = organization
    def get_subject(self): return self.subject
    def set_subject(self, subject): self.subject = subject
    def hasContent_(self):
        if (
            self.organization is not None or
            self.subject is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Certificate', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Certificate')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Certificate'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Certificate', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.organization is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorganization>%s</%sorganization>%s' % (namespace_, self.gds_format_string(quote_xml(self.organization).encode(ExternalEncoding), input_name='organization'), namespace_, eol_))
        if self.subject is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssubject>%s</%ssubject>%s' % (namespace_, self.gds_format_string(quote_xml(self.subject).encode(ExternalEncoding), input_name='subject'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Certificate'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.organization is not None:
            showIndent(outfile, level)
            outfile.write('organization=%s,\n' % quote_python(self.organization).encode(ExternalEncoding))
        if self.subject is not None:
            showIndent(outfile, level)
            outfile.write('subject=%s,\n' % quote_python(self.subject).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'organization':
            organization_ = child_.text
            organization_ = self.gds_validate_string(organization_, node, 'organization')
            self.organization = organization_
        elif nodeName_ == 'subject':
            subject_ = child_.text
            subject_ = self.gds_validate_string(subject_, node, 'subject')
            self.subject = subject_
# end class Certificate


class SELinux(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, mode=None):
        self.mode = mode
    def factory(*args_, **kwargs_):
        if SELinux.subclass:
            return SELinux.subclass(*args_, **kwargs_)
        else:
            return SELinux(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_mode(self): return self.mode
    def set_mode(self, mode): self.mode = mode
    def hasContent_(self):
        if (
            self.mode is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SELinux', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SELinux')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SELinux'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='SELinux', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.mode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smode>%s</%smode>%s' % (namespace_, self.gds_format_string(quote_xml(self.mode).encode(ExternalEncoding), input_name='mode'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='SELinux'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.mode is not None:
            showIndent(outfile, level)
            outfile.write('mode=%s,\n' % quote_python(self.mode).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'mode':
            mode_ = child_.text
            mode_ = self.gds_validate_string(mode_, node, 'mode')
            self.mode = mode_
# end class SELinux


class Host(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, address=None, certificate=None, status=None, cluster=None, port=None, type_=None, storage_manager=None, version=None, hardware_information=None, power_management=None, ksm=None, transparent_hugepages=None, iscsi=None, root_password=None, ssh=None, statistics=None, cpu=None, memory=None, max_scheduling_memory=None, summary=None, override_iptables=None, protocol=None, reboot_after_installation=None, os=None, hooks=None, libvirt_version=None, display=None, hosted_engine=None, kdump_status=None, selinux=None, auto_numa_status=None, numa_supported=None, live_snapshot_support=None):
        super(Host, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.address = address
        self.certificate = certificate
        self.status = status
        self.cluster = cluster
        self.port = port
        self.type_ = type_
        self.storage_manager = storage_manager
        self.version = version
        self.hardware_information = hardware_information
        self.power_management = power_management
        self.ksm = ksm
        self.transparent_hugepages = transparent_hugepages
        self.iscsi = iscsi
        self.root_password = root_password
        self.ssh = ssh
        self.statistics = statistics
        self.cpu = cpu
        self.memory = memory
        self.max_scheduling_memory = max_scheduling_memory
        self.summary = summary
        self.override_iptables = override_iptables
        self.protocol = protocol
        self.reboot_after_installation = reboot_after_installation
        self.os = os
        self.hooks = hooks
        self.libvirt_version = libvirt_version
        self.display = display
        self.hosted_engine = hosted_engine
        self.kdump_status = kdump_status
        self.selinux = selinux
        self.auto_numa_status = auto_numa_status
        self.numa_supported = numa_supported
        self.live_snapshot_support = live_snapshot_support
    def factory(*args_, **kwargs_):
        if Host.subclass:
            return Host.subclass(*args_, **kwargs_)
        else:
            return Host(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_certificate(self): return self.certificate
    def set_certificate(self, certificate): self.certificate = certificate
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def get_port(self): return self.port
    def set_port(self, port): self.port = port
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_storage_manager(self): return self.storage_manager
    def set_storage_manager(self, storage_manager): self.storage_manager = storage_manager
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_hardware_information(self): return self.hardware_information
    def set_hardware_information(self, hardware_information): self.hardware_information = hardware_information
    def get_power_management(self): return self.power_management
    def set_power_management(self, power_management): self.power_management = power_management
    def get_ksm(self): return self.ksm
    def set_ksm(self, ksm): self.ksm = ksm
    def get_transparent_hugepages(self): return self.transparent_hugepages
    def set_transparent_hugepages(self, transparent_hugepages): self.transparent_hugepages = transparent_hugepages
    def get_iscsi(self): return self.iscsi
    def set_iscsi(self, iscsi): self.iscsi = iscsi
    def get_root_password(self): return self.root_password
    def set_root_password(self, root_password): self.root_password = root_password
    def get_ssh(self): return self.ssh
    def set_ssh(self, ssh): self.ssh = ssh
    def get_statistics(self): return self.statistics
    def set_statistics(self, statistics): self.statistics = statistics
    def get_cpu(self): return self.cpu
    def set_cpu(self, cpu): self.cpu = cpu
    def get_memory(self): return self.memory
    def set_memory(self, memory): self.memory = memory
    def get_max_scheduling_memory(self): return self.max_scheduling_memory
    def set_max_scheduling_memory(self, max_scheduling_memory): self.max_scheduling_memory = max_scheduling_memory
    def get_summary(self): return self.summary
    def set_summary(self, summary): self.summary = summary
    def get_override_iptables(self): return self.override_iptables
    def set_override_iptables(self, override_iptables): self.override_iptables = override_iptables
    def get_protocol(self): return self.protocol
    def set_protocol(self, protocol): self.protocol = protocol
    def get_reboot_after_installation(self): return self.reboot_after_installation
    def set_reboot_after_installation(self, reboot_after_installation): self.reboot_after_installation = reboot_after_installation
    def get_os(self): return self.os
    def set_os(self, os): self.os = os
    def get_hooks(self): return self.hooks
    def set_hooks(self, hooks): self.hooks = hooks
    def get_libvirt_version(self): return self.libvirt_version
    def set_libvirt_version(self, libvirt_version): self.libvirt_version = libvirt_version
    def get_display(self): return self.display
    def set_display(self, display): self.display = display
    def get_hosted_engine(self): return self.hosted_engine
    def set_hosted_engine(self, hosted_engine): self.hosted_engine = hosted_engine
    def get_kdump_status(self): return self.kdump_status
    def set_kdump_status(self, kdump_status): self.kdump_status = kdump_status
    def get_selinux(self): return self.selinux
    def set_selinux(self, selinux): self.selinux = selinux
    def get_auto_numa_status(self): return self.auto_numa_status
    def set_auto_numa_status(self, auto_numa_status): self.auto_numa_status = auto_numa_status
    def get_numa_supported(self): return self.numa_supported
    def set_numa_supported(self, numa_supported): self.numa_supported = numa_supported
    def get_live_snapshot_support(self): return self.live_snapshot_support
    def set_live_snapshot_support(self, live_snapshot_support): self.live_snapshot_support = live_snapshot_support
    def hasContent_(self):
        if (
            self.address is not None or
            self.certificate is not None or
            self.status is not None or
            self.cluster is not None or
            self.port is not None or
            self.type_ is not None or
            self.storage_manager is not None or
            self.version is not None or
            self.hardware_information is not None or
            self.power_management is not None or
            self.ksm is not None or
            self.transparent_hugepages is not None or
            self.iscsi is not None or
            self.root_password is not None or
            self.ssh is not None or
            self.statistics is not None or
            self.cpu is not None or
            self.memory is not None or
            self.max_scheduling_memory is not None or
            self.summary is not None or
            self.override_iptables is not None or
            self.protocol is not None or
            self.reboot_after_installation is not None or
            self.os is not None or
            self.hooks is not None or
            self.libvirt_version is not None or
            self.display is not None or
            self.hosted_engine is not None or
            self.kdump_status is not None or
            self.selinux is not None or
            self.auto_numa_status is not None or
            self.numa_supported is not None or
            self.live_snapshot_support is not None or
            super(Host, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Host', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Host')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Host'):
        super(Host, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Host')
    def exportChildren(self, outfile, level, namespace_='', name_='Host', fromsubclass_=False, pretty_print=True):
        super(Host, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.address is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress>%s</%saddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_, eol_))
        if self.certificate is not None:
            self.certificate.export(outfile, level, namespace_, name_='certificate', pretty_print=pretty_print)
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status', pretty_print=pretty_print)
        if self.cluster is not None:
            self.cluster.export(outfile, level, namespace_, name_='cluster', pretty_print=pretty_print)
        if self.port is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sport>%s</%sport>%s' % (namespace_, self.gds_format_integer(self.port, input_name='port'), namespace_, eol_))
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.storage_manager is not None:
            self.storage_manager.export(outfile, level, namespace_, name_='storage_manager', pretty_print=pretty_print)
        if self.version is not None:
            self.version.export(outfile, level, namespace_, name_='version', pretty_print=pretty_print)
        if self.hardware_information is not None:
            self.hardware_information.export(outfile, level, namespace_, name_='hardware_information', pretty_print=pretty_print)
        if self.power_management is not None:
            self.power_management.export(outfile, level, namespace_, name_='power_management', pretty_print=pretty_print)
        if self.ksm is not None:
            self.ksm.export(outfile, level, namespace_, name_='ksm', pretty_print=pretty_print)
        if self.transparent_hugepages is not None:
            self.transparent_hugepages.export(outfile, level, namespace_, name_='transparent_hugepages', pretty_print=pretty_print)
        if self.iscsi is not None:
            self.iscsi.export(outfile, level, namespace_, name_='iscsi', pretty_print=pretty_print)
        if self.root_password is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sroot_password>%s</%sroot_password>%s' % (namespace_, self.gds_format_string(quote_xml(self.root_password).encode(ExternalEncoding), input_name='root_password'), namespace_, eol_))
        if self.ssh is not None:
            self.ssh.export(outfile, level, namespace_, name_='ssh', pretty_print=pretty_print)
        if self.statistics is not None:
            self.statistics.export(outfile, level, namespace_, name_='statistics', pretty_print=pretty_print)
        if self.cpu is not None:
            self.cpu.export(outfile, level, namespace_, name_='cpu', pretty_print=pretty_print)
        if self.memory is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smemory>%s</%smemory>%s' % (namespace_, self.gds_format_integer(self.memory, input_name='memory'), namespace_, eol_))
        if self.max_scheduling_memory is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smax_scheduling_memory>%s</%smax_scheduling_memory>%s' % (namespace_, self.gds_format_integer(self.max_scheduling_memory, input_name='max_scheduling_memory'), namespace_, eol_))
        if self.summary is not None:
            self.summary.export(outfile, level, namespace_, name_='summary', pretty_print=pretty_print)
        if self.override_iptables is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soverride_iptables>%s</%soverride_iptables>%s' % (namespace_, self.gds_format_boolean(self.override_iptables, input_name='override_iptables'), namespace_, eol_))
        if self.protocol is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprotocol>%s</%sprotocol>%s' % (namespace_, self.gds_format_string(quote_xml(self.protocol).encode(ExternalEncoding), input_name='protocol'), namespace_, eol_))
        if self.reboot_after_installation is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreboot_after_installation>%s</%sreboot_after_installation>%s' % (namespace_, self.gds_format_boolean(self.reboot_after_installation, input_name='reboot_after_installation'), namespace_, eol_))
        if self.os is not None:
            self.os.export(outfile, level, namespace_, name_='os', pretty_print=pretty_print)
        if self.hooks is not None:
            self.hooks.export(outfile, level, namespace_, name_='hooks', pretty_print=pretty_print)
        if self.libvirt_version is not None:
            self.libvirt_version.export(outfile, level, namespace_, name_='libvirt_version', pretty_print=pretty_print)
        if self.display is not None:
            self.display.export(outfile, level, namespace_, name_='display', pretty_print=pretty_print)
        if self.hosted_engine is not None:
            self.hosted_engine.export(outfile, level, namespace_, name_='hosted_engine', pretty_print=pretty_print)
        if self.kdump_status is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skdump_status>%s</%skdump_status>%s' % (namespace_, self.gds_format_string(quote_xml(self.kdump_status).encode(ExternalEncoding), input_name='kdump_status'), namespace_, eol_))
        if self.selinux is not None:
            self.selinux.export(outfile, level, namespace_, name_='selinux', pretty_print=pretty_print)
        if self.auto_numa_status is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sauto_numa_status>%s</%sauto_numa_status>%s' % (namespace_, self.gds_format_string(quote_xml(self.auto_numa_status).encode(ExternalEncoding), input_name='auto_numa_status'), namespace_, eol_))
        if self.numa_supported is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snuma_supported>%s</%snuma_supported>%s' % (namespace_, self.gds_format_boolean(self.numa_supported, input_name='numa_supported'), namespace_, eol_))
        if self.live_snapshot_support is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slive_snapshot_support>%s</%slive_snapshot_support>%s' % (namespace_, self.gds_format_boolean(self.live_snapshot_support, input_name='live_snapshot_support'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Host'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Host, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Host, self).exportLiteralChildren(outfile, level, name_)
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.certificate is not None:
            showIndent(outfile, level)
            outfile.write('certificate=model_.certificate(\n')
            self.certificate.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cluster is not None:
            showIndent(outfile, level)
            outfile.write('cluster=model_.Cluster(\n')
            self.cluster.exportLiteral(outfile, level, name_='cluster')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('port=%d,\n' % self.port)
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.storage_manager is not None:
            showIndent(outfile, level)
            outfile.write('storage_manager=model_.StorageManager(\n')
            self.storage_manager.exportLiteral(outfile, level, name_='storage_manager')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=model_.Version(\n')
            self.version.exportLiteral(outfile, level, name_='version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.hardware_information is not None:
            showIndent(outfile, level)
            outfile.write('hardware_information=model_.hardware_information(\n')
            self.hardware_information.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.power_management is not None:
            showIndent(outfile, level)
            outfile.write('power_management=model_.power_management(\n')
            self.power_management.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ksm is not None:
            showIndent(outfile, level)
            outfile.write('ksm=model_.ksm(\n')
            self.ksm.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.transparent_hugepages is not None:
            showIndent(outfile, level)
            outfile.write('transparent_hugepages=model_.transparent_hugepages(\n')
            self.transparent_hugepages.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.iscsi is not None:
            showIndent(outfile, level)
            outfile.write('iscsi=model_.IscsiDetails(\n')
            self.iscsi.exportLiteral(outfile, level, name_='iscsi')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.root_password is not None:
            showIndent(outfile, level)
            outfile.write('root_password=%s,\n' % quote_python(self.root_password).encode(ExternalEncoding))
        if self.ssh is not None:
            showIndent(outfile, level)
            outfile.write('ssh=model_.ssh(\n')
            self.ssh.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.statistics is not None:
            showIndent(outfile, level)
            outfile.write('statistics=model_.Statistics(\n')
            self.statistics.exportLiteral(outfile, level, name_='statistics')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cpu is not None:
            showIndent(outfile, level)
            outfile.write('cpu=model_.cpu(\n')
            self.cpu.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.memory is not None:
            showIndent(outfile, level)
            outfile.write('memory=%d,\n' % self.memory)
        if self.max_scheduling_memory is not None:
            showIndent(outfile, level)
            outfile.write('max_scheduling_memory=%d,\n' % self.max_scheduling_memory)
        if self.summary is not None:
            showIndent(outfile, level)
            outfile.write('summary=model_.VmSummary(\n')
            self.summary.exportLiteral(outfile, level, name_='summary')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.override_iptables is not None:
            showIndent(outfile, level)
            outfile.write('override_iptables=%s,\n' % self.override_iptables)
        if self.protocol is not None:
            showIndent(outfile, level)
            outfile.write('protocol=%s,\n' % quote_python(self.protocol).encode(ExternalEncoding))
        if self.reboot_after_installation is not None:
            showIndent(outfile, level)
            outfile.write('reboot_after_installation=%s,\n' % self.reboot_after_installation)
        if self.os is not None:
            showIndent(outfile, level)
            outfile.write('os=model_.OperatingSystem(\n')
            self.os.exportLiteral(outfile, level, name_='os')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.hooks is not None:
            showIndent(outfile, level)
            outfile.write('hooks=model_.hooks(\n')
            self.hooks.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.libvirt_version is not None:
            showIndent(outfile, level)
            outfile.write('libvirt_version=model_.Version(\n')
            self.libvirt_version.exportLiteral(outfile, level, name_='libvirt_version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.display is not None:
            showIndent(outfile, level)
            outfile.write('display=model_.display(\n')
            self.display.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.hosted_engine is not None:
            showIndent(outfile, level)
            outfile.write('hosted_engine=model_.HostedEngine(\n')
            self.hosted_engine.exportLiteral(outfile, level, name_='hosted_engine')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.kdump_status is not None:
            showIndent(outfile, level)
            outfile.write('kdump_status=%s,\n' % quote_python(self.kdump_status).encode(ExternalEncoding))
        if self.selinux is not None:
            showIndent(outfile, level)
            outfile.write('selinux=model_.SELinux(\n')
            self.selinux.exportLiteral(outfile, level, name_='selinux')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.auto_numa_status is not None:
            showIndent(outfile, level)
            outfile.write('auto_numa_status=%s,\n' % quote_python(self.auto_numa_status).encode(ExternalEncoding))
        if self.numa_supported is not None:
            showIndent(outfile, level)
            outfile.write('numa_supported=%s,\n' % self.numa_supported)
        if self.live_snapshot_support is not None:
            showIndent(outfile, level)
            outfile.write('live_snapshot_support=%s,\n' % self.live_snapshot_support)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Host, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'certificate':
            obj_ = Certificate.factory()
            obj_.build(child_)
            self.certificate = obj_
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.status = obj_
        elif nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.cluster = obj_
        elif nodeName_ == 'port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'port')
            self.port = ival_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'storage_manager':
            obj_ = StorageManager.factory()
            obj_.build(child_)
            self.storage_manager = obj_
        elif nodeName_ == 'version':
            class_obj_ = self.get_class_obj_(child_, Version)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.version = obj_
        elif nodeName_ == 'hardware_information':
            obj_ = HardwareInformation.factory()
            obj_.build(child_)
            self.hardware_information = obj_
        elif nodeName_ == 'power_management':
            obj_ = PowerManagement.factory()
            obj_.build(child_)
            self.power_management = obj_
        elif nodeName_ == 'ksm':
            obj_ = KSM.factory()
            obj_.build(child_)
            self.ksm = obj_
        elif nodeName_ == 'transparent_hugepages':
            obj_ = TransparentHugePages.factory()
            obj_.build(child_)
            self.transparent_hugepages = obj_
        elif nodeName_ == 'iscsi':
            obj_ = IscsiDetails.factory()
            obj_.build(child_)
            self.iscsi = obj_
        elif nodeName_ == 'root_password':
            root_password_ = child_.text
            root_password_ = self.gds_validate_string(root_password_, node, 'root_password')
            self.root_password = root_password_
        elif nodeName_ == 'ssh':
            obj_ = SSH.factory()
            obj_.build(child_)
            self.ssh = obj_
        elif nodeName_ == 'statistics':
            obj_ = Statistics.factory()
            obj_.build(child_)
            self.statistics = obj_
        elif nodeName_ == 'cpu':
            obj_ = CPU.factory()
            obj_.build(child_)
            self.cpu = obj_
        elif nodeName_ == 'memory':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'memory')
            self.memory = ival_
        elif nodeName_ == 'max_scheduling_memory':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'max_scheduling_memory')
            self.max_scheduling_memory = ival_
        elif nodeName_ == 'summary':
            obj_ = VmSummary.factory()
            obj_.build(child_)
            self.summary = obj_
        elif nodeName_ == 'override_iptables':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'override_iptables')
            self.override_iptables = ival_
        elif nodeName_ == 'protocol':
            protocol_ = child_.text
            protocol_ = self.gds_validate_string(protocol_, node, 'protocol')
            self.protocol = protocol_
        elif nodeName_ == 'reboot_after_installation':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'reboot_after_installation')
            self.reboot_after_installation = ival_
        elif nodeName_ == 'os':
            obj_ = OperatingSystem.factory()
            obj_.build(child_)
            self.os = obj_
        elif nodeName_ == 'hooks':
            obj_ = Hooks.factory()
            obj_.build(child_)
            self.hooks = obj_
        elif nodeName_ == 'libvirt_version':
            class_obj_ = self.get_class_obj_(child_, Version)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.libvirt_version = obj_
        elif nodeName_ == 'display':
            obj_ = Display.factory()
            obj_.build(child_)
            self.display = obj_
        elif nodeName_ == 'hosted_engine':
            obj_ = HostedEngine.factory()
            obj_.build(child_)
            self.hosted_engine = obj_
        elif nodeName_ == 'kdump_status':
            kdump_status_ = child_.text
            kdump_status_ = self.gds_validate_string(kdump_status_, node, 'kdump_status')
            self.kdump_status = kdump_status_
        elif nodeName_ == 'selinux':
            obj_ = SELinux.factory()
            obj_.build(child_)
            self.selinux = obj_
        elif nodeName_ == 'auto_numa_status':
            auto_numa_status_ = child_.text
            auto_numa_status_ = self.gds_validate_string(auto_numa_status_, node, 'auto_numa_status')
            self.auto_numa_status = auto_numa_status_
        elif nodeName_ == 'numa_supported':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'numa_supported')
            self.numa_supported = ival_
        elif nodeName_ == 'live_snapshot_support':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'live_snapshot_support')
            self.live_snapshot_support = ival_
        super(Host, self).buildChildren(child_, node, nodeName_, True)
# end class Host


class StorageManager(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, priority=None, valueOf_=None):
        self.priority = _cast(int, priority)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if StorageManager.subclass:
            return StorageManager.subclass(*args_, **kwargs_)
        else:
            return StorageManager(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_priority(self): return self.priority
    def set_priority(self, priority): self.priority = priority
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StorageManager', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageManager')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageManager'):
        if self.priority is not None and 'priority' not in already_processed:
            already_processed.add('priority')
            outfile.write(' priority="%s"' % self.gds_format_integer(self.priority, input_name='priority'))
    def exportChildren(self, outfile, level, namespace_='', name_='StorageManager', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='StorageManager'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.priority is not None and 'priority' not in already_processed:
            already_processed.add('priority')
            showIndent(outfile, level)
            outfile.write('priority=%d,\n' % (self.priority,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('priority', node)
        if value is not None and 'priority' not in already_processed:
            already_processed.add('priority')
            try:
                self.priority = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class StorageManager


class HostedEngine(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, configured=None, active=None, score=None, global_maintenance=None, local_maintenance=None):
        self.configured = configured
        self.active = active
        self.score = score
        self.global_maintenance = global_maintenance
        self.local_maintenance = local_maintenance
    def factory(*args_, **kwargs_):
        if HostedEngine.subclass:
            return HostedEngine.subclass(*args_, **kwargs_)
        else:
            return HostedEngine(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_configured(self): return self.configured
    def set_configured(self, configured): self.configured = configured
    def get_active(self): return self.active
    def set_active(self, active): self.active = active
    def get_score(self): return self.score
    def set_score(self, score): self.score = score
    def get_global_maintenance(self): return self.global_maintenance
    def set_global_maintenance(self, global_maintenance): self.global_maintenance = global_maintenance
    def get_local_maintenance(self): return self.local_maintenance
    def set_local_maintenance(self, local_maintenance): self.local_maintenance = local_maintenance
    def hasContent_(self):
        if (
            self.configured is not None or
            self.active is not None or
            self.score is not None or
            self.global_maintenance is not None or
            self.local_maintenance is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='HostedEngine', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HostedEngine')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HostedEngine'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='HostedEngine', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.configured is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sconfigured>%s</%sconfigured>%s' % (namespace_, self.gds_format_boolean(self.configured, input_name='configured'), namespace_, eol_))
        if self.active is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sactive>%s</%sactive>%s' % (namespace_, self.gds_format_boolean(self.active, input_name='active'), namespace_, eol_))
        if self.score is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sscore>%s</%sscore>%s' % (namespace_, self.gds_format_integer(self.score, input_name='score'), namespace_, eol_))
        if self.global_maintenance is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sglobal_maintenance>%s</%sglobal_maintenance>%s' % (namespace_, self.gds_format_boolean(self.global_maintenance, input_name='global_maintenance'), namespace_, eol_))
        if self.local_maintenance is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slocal_maintenance>%s</%slocal_maintenance>%s' % (namespace_, self.gds_format_boolean(self.local_maintenance, input_name='local_maintenance'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='HostedEngine'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.configured is not None:
            showIndent(outfile, level)
            outfile.write('configured=%s,\n' % self.configured)
        if self.active is not None:
            showIndent(outfile, level)
            outfile.write('active=%s,\n' % self.active)
        if self.score is not None:
            showIndent(outfile, level)
            outfile.write('score=%d,\n' % self.score)
        if self.global_maintenance is not None:
            showIndent(outfile, level)
            outfile.write('global_maintenance=%s,\n' % self.global_maintenance)
        if self.local_maintenance is not None:
            showIndent(outfile, level)
            outfile.write('local_maintenance=%s,\n' % self.local_maintenance)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'configured':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'configured')
            self.configured = ival_
        elif nodeName_ == 'active':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'active')
            self.active = ival_
        elif nodeName_ == 'score':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'score')
            self.score = ival_
        elif nodeName_ == 'global_maintenance':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'global_maintenance')
            self.global_maintenance = ival_
        elif nodeName_ == 'local_maintenance':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'local_maintenance')
            self.local_maintenance = ival_
# end class HostedEngine


class HostStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, host_state=None):
        if host_state is None:
            self.host_state = []
        else:
            self.host_state = host_state
    def factory(*args_, **kwargs_):
        if HostStates.subclass:
            return HostStates.subclass(*args_, **kwargs_)
        else:
            return HostStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_host_state(self): return self.host_state
    def set_host_state(self, host_state): self.host_state = host_state
    def add_host_state(self, value): self.host_state.append(value)
    def insert_host_state(self, index, value): self.host_state[index] = value
    def hasContent_(self):
        if (
            self.host_state
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='HostStates', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HostStates')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HostStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='HostStates', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for host_state_ in self.host_state:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shost_state>%s</%shost_state>%s' % (namespace_, self.gds_format_string(quote_xml(host_state_).encode(ExternalEncoding), input_name='host_state'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='HostStates'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('host_state=[\n')
        level += 1
        for host_state_ in self.host_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(host_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'host_state':
            host_state_ = child_.text
            host_state_ = self.gds_validate_string(host_state_, node, 'host_state')
            self.host_state.append(host_state_)
# end class HostStates


class HostNonOperationalDetails(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, host_non_operational_detail=None):
        if host_non_operational_detail is None:
            self.host_non_operational_detail = []
        else:
            self.host_non_operational_detail = host_non_operational_detail
    def factory(*args_, **kwargs_):
        if HostNonOperationalDetails.subclass:
            return HostNonOperationalDetails.subclass(*args_, **kwargs_)
        else:
            return HostNonOperationalDetails(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_host_non_operational_detail(self): return self.host_non_operational_detail
    def set_host_non_operational_detail(self, host_non_operational_detail): self.host_non_operational_detail = host_non_operational_detail
    def add_host_non_operational_detail(self, value): self.host_non_operational_detail.append(value)
    def insert_host_non_operational_detail(self, index, value): self.host_non_operational_detail[index] = value
    def hasContent_(self):
        if (
            self.host_non_operational_detail
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='HostNonOperationalDetails', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HostNonOperationalDetails')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HostNonOperationalDetails'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='HostNonOperationalDetails', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for host_non_operational_detail_ in self.host_non_operational_detail:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shost_non_operational_detail>%s</%shost_non_operational_detail>%s' % (namespace_, self.gds_format_string(quote_xml(host_non_operational_detail_).encode(ExternalEncoding), input_name='host_non_operational_detail'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='HostNonOperationalDetails'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('host_non_operational_detail=[\n')
        level += 1
        for host_non_operational_detail_ in self.host_non_operational_detail:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(host_non_operational_detail_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'host_non_operational_detail':
            host_non_operational_detail_ = child_.text
            host_non_operational_detail_ = self.gds_validate_string(host_non_operational_detail_, node, 'host_non_operational_detail')
            self.host_non_operational_detail.append(host_non_operational_detail_)
# end class HostNonOperationalDetails


class VmSummary(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, active=None, migrating=None, total=None):
        self.active = active
        self.migrating = migrating
        self.total = total
    def factory(*args_, **kwargs_):
        if VmSummary.subclass:
            return VmSummary.subclass(*args_, **kwargs_)
        else:
            return VmSummary(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_active(self): return self.active
    def set_active(self, active): self.active = active
    def get_migrating(self): return self.migrating
    def set_migrating(self, migrating): self.migrating = migrating
    def get_total(self): return self.total
    def set_total(self, total): self.total = total
    def hasContent_(self):
        if (
            self.active is not None or
            self.migrating is not None or
            self.total is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VmSummary', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmSummary')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmSummary'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VmSummary', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.active is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sactive>%s</%sactive>%s' % (namespace_, self.gds_format_integer(self.active, input_name='active'), namespace_, eol_))
        if self.migrating is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smigrating>%s</%smigrating>%s' % (namespace_, self.gds_format_integer(self.migrating, input_name='migrating'), namespace_, eol_))
        if self.total is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotal>%s</%stotal>%s' % (namespace_, self.gds_format_integer(self.total, input_name='total'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='VmSummary'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.active is not None:
            showIndent(outfile, level)
            outfile.write('active=%d,\n' % self.active)
        if self.migrating is not None:
            showIndent(outfile, level)
            outfile.write('migrating=%d,\n' % self.migrating)
        if self.total is not None:
            showIndent(outfile, level)
            outfile.write('total=%d,\n' % self.total)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'active':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'active')
            self.active = ival_
        elif nodeName_ == 'migrating':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'migrating')
            self.migrating = ival_
        elif nodeName_ == 'total':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'total')
            self.total = ival_
# end class VmSummary


class Hosts(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, host=None):
        super(Hosts, self).__init__(actions, total, active, )
        if host is None:
            self.host = []
        else:
            self.host = host
    def factory(*args_, **kwargs_):
        if Hosts.subclass:
            return Hosts.subclass(*args_, **kwargs_)
        else:
            return Hosts(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def add_host(self, value): self.host.append(value)
    def insert_host(self, index, value): self.host[index] = value
    def hasContent_(self):
        if (
            self.host or
            super(Hosts, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Hosts', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Hosts')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Hosts'):
        super(Hosts, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Hosts')
    def exportChildren(self, outfile, level, namespace_='', name_='Hosts', fromsubclass_=False, pretty_print=True):
        super(Hosts, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for host_ in self.host:
            host_.export(outfile, level, namespace_, name_='host', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Hosts'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Hosts, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Hosts, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('host=[\n')
        level += 1
        for host_ in self.host:
            showIndent(outfile, level)
            outfile.write('model_.host(\n')
            host_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Hosts, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.host.append(obj_)
        super(Hosts, self).buildChildren(child_, node, nodeName_, True)
# end class Hosts


class Permit(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, administrative=None, role=None):
        super(Permit, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.administrative = administrative
        self.role = role
    def factory(*args_, **kwargs_):
        if Permit.subclass:
            return Permit.subclass(*args_, **kwargs_)
        else:
            return Permit(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_administrative(self): return self.administrative
    def set_administrative(self, administrative): self.administrative = administrative
    def get_role(self): return self.role
    def set_role(self, role): self.role = role
    def hasContent_(self):
        if (
            self.administrative is not None or
            self.role is not None or
            super(Permit, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Permit', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Permit')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Permit'):
        super(Permit, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Permit')
    def exportChildren(self, outfile, level, namespace_='', name_='Permit', fromsubclass_=False, pretty_print=True):
        super(Permit, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.administrative is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sadministrative>%s</%sadministrative>%s' % (namespace_, self.gds_format_boolean(self.administrative, input_name='administrative'), namespace_, eol_))
        if self.role is not None:
            self.role.export(outfile, level, namespace_, name_='role', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Permit'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Permit, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Permit, self).exportLiteralChildren(outfile, level, name_)
        if self.administrative is not None:
            showIndent(outfile, level)
            outfile.write('administrative=%s,\n' % self.administrative)
        if self.role is not None:
            showIndent(outfile, level)
            outfile.write('role=model_.Role(\n')
            self.role.exportLiteral(outfile, level, name_='role')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Permit, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'administrative':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'administrative')
            self.administrative = ival_
        elif nodeName_ == 'role':
            obj_ = Role.factory()
            obj_.build(child_)
            self.role = obj_
        super(Permit, self).buildChildren(child_, node, nodeName_, True)
# end class Permit


class Permits(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, permit=None):
        super(Permits, self).__init__(actions, total, active, )
        if permit is None:
            self.permit = []
        else:
            self.permit = permit
    def factory(*args_, **kwargs_):
        if Permits.subclass:
            return Permits.subclass(*args_, **kwargs_)
        else:
            return Permits(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_permit(self): return self.permit
    def set_permit(self, permit): self.permit = permit
    def add_permit(self, value): self.permit.append(value)
    def insert_permit(self, index, value): self.permit[index] = value
    def hasContent_(self):
        if (
            self.permit or
            super(Permits, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Permits', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Permits')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Permits'):
        super(Permits, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Permits')
    def exportChildren(self, outfile, level, namespace_='', name_='Permits', fromsubclass_=False, pretty_print=True):
        super(Permits, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for permit_ in self.permit:
            permit_.export(outfile, level, namespace_, name_='permit', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Permits'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Permits, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Permits, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('permit=[\n')
        level += 1
        for permit_ in self.permit:
            showIndent(outfile, level)
            outfile.write('model_.Permit(\n')
            permit_.exportLiteral(outfile, level, name_='Permit')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Permits, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'permit':
            obj_ = Permit.factory()
            obj_.build(child_)
            self.permit.append(obj_)
        super(Permits, self).buildChildren(child_, node, nodeName_, True)
# end class Permits


class Role(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, mutable=None, administrative=None, user=None, permits=None):
        super(Role, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.mutable = mutable
        self.administrative = administrative
        self.user = user
        self.permits = permits
    def factory(*args_, **kwargs_):
        if Role.subclass:
            return Role.subclass(*args_, **kwargs_)
        else:
            return Role(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_mutable(self): return self.mutable
    def set_mutable(self, mutable): self.mutable = mutable
    def get_administrative(self): return self.administrative
    def set_administrative(self, administrative): self.administrative = administrative
    def get_user(self): return self.user
    def set_user(self, user): self.user = user
    def get_permits(self): return self.permits
    def set_permits(self, permits): self.permits = permits
    def hasContent_(self):
        if (
            self.mutable is not None or
            self.administrative is not None or
            self.user is not None or
            self.permits is not None or
            super(Role, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Role', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Role')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Role'):
        super(Role, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Role')
    def exportChildren(self, outfile, level, namespace_='', name_='Role', fromsubclass_=False, pretty_print=True):
        super(Role, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.mutable is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smutable>%s</%smutable>%s' % (namespace_, self.gds_format_boolean(self.mutable, input_name='mutable'), namespace_, eol_))
        if self.administrative is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sadministrative>%s</%sadministrative>%s' % (namespace_, self.gds_format_boolean(self.administrative, input_name='administrative'), namespace_, eol_))
        if self.user is not None:
            self.user.export(outfile, level, namespace_, name_='user', pretty_print=pretty_print)
        if self.permits is not None:
            self.permits.export(outfile, level, namespace_, name_='permits', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Role'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Role, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Role, self).exportLiteralChildren(outfile, level, name_)
        if self.mutable is not None:
            showIndent(outfile, level)
            outfile.write('mutable=%s,\n' % self.mutable)
        if self.administrative is not None:
            showIndent(outfile, level)
            outfile.write('administrative=%s,\n' % self.administrative)
        if self.user is not None:
            showIndent(outfile, level)
            outfile.write('user=model_.User(\n')
            self.user.exportLiteral(outfile, level, name_='user')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.permits is not None:
            showIndent(outfile, level)
            outfile.write('permits=model_.Permits(\n')
            self.permits.exportLiteral(outfile, level, name_='permits')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Role, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'mutable':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'mutable')
            self.mutable = ival_
        elif nodeName_ == 'administrative':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'administrative')
            self.administrative = ival_
        elif nodeName_ == 'user':
            class_obj_ = self.get_class_obj_(child_, User)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.user = obj_
        elif nodeName_ == 'permits':
            obj_ = Permits.factory()
            obj_.build(child_)
            self.permits = obj_
        super(Role, self).buildChildren(child_, node, nodeName_, True)
# end class Role


class Roles(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, role=None):
        super(Roles, self).__init__(actions, total, active, )
        if role is None:
            self.role = []
        else:
            self.role = role
    def factory(*args_, **kwargs_):
        if Roles.subclass:
            return Roles.subclass(*args_, **kwargs_)
        else:
            return Roles(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_role(self): return self.role
    def set_role(self, role): self.role = role
    def add_role(self, value): self.role.append(value)
    def insert_role(self, index, value): self.role[index] = value
    def hasContent_(self):
        if (
            self.role or
            super(Roles, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Roles', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Roles')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Roles'):
        super(Roles, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Roles')
    def exportChildren(self, outfile, level, namespace_='', name_='Roles', fromsubclass_=False, pretty_print=True):
        super(Roles, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for role_ in self.role:
            role_.export(outfile, level, namespace_, name_='role', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Roles'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Roles, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Roles, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('role=[\n')
        level += 1
        for role_ in self.role:
            showIndent(outfile, level)
            outfile.write('model_.role(\n')
            role_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Roles, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'role':
            obj_ = Role.factory()
            obj_.build(child_)
            self.role.append(obj_)
        super(Roles, self).buildChildren(child_, node, nodeName_, True)
# end class Roles


class User(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, domain=None, domain_entry_id=None, department=None, logged_in=None, namespace=None, last_name=None, user_name=None, password=None, email=None, roles=None, groups=None, extensiontype_=None):
        super(User, self).__init__(actions, href, id, name, description, comment, creation_status, link, extensiontype_, )
        self.domain = domain
        self.domain_entry_id = domain_entry_id
        self.department = department
        self.logged_in = logged_in
        self.namespace = namespace
        self.last_name = last_name
        self.user_name = user_name
        self.password = password
        self.email = email
        self.roles = roles
        self.groups = groups
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if User.subclass:
            return User.subclass(*args_, **kwargs_)
        else:
            return User(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_domain(self): return self.domain
    def set_domain(self, domain): self.domain = domain
    def get_domain_entry_id(self): return self.domain_entry_id
    def set_domain_entry_id(self, domain_entry_id): self.domain_entry_id = domain_entry_id
    def get_department(self): return self.department
    def set_department(self, department): self.department = department
    def get_logged_in(self): return self.logged_in
    def set_logged_in(self, logged_in): self.logged_in = logged_in
    def get_namespace(self): return self.namespace
    def set_namespace(self, namespace): self.namespace = namespace
    def get_last_name(self): return self.last_name
    def set_last_name(self, last_name): self.last_name = last_name
    def get_user_name(self): return self.user_name
    def set_user_name(self, user_name): self.user_name = user_name
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_email(self): return self.email
    def set_email(self, email): self.email = email
    def get_roles(self): return self.roles
    def set_roles(self, roles): self.roles = roles
    def get_groups(self): return self.groups
    def set_groups(self, groups): self.groups = groups
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.domain is not None or
            self.domain_entry_id is not None or
            self.department is not None or
            self.logged_in is not None or
            self.namespace is not None or
            self.last_name is not None or
            self.user_name is not None or
            self.password is not None or
            self.email is not None or
            self.roles is not None or
            self.groups is not None or
            super(User, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='User', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='User')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='User'):
        super(User, self).exportAttributes(outfile, level, already_processed, namespace_, name_='User')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='User', fromsubclass_=False, pretty_print=True):
        super(User, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.domain is not None:
            self.domain.export(outfile, level, namespace_, name_='domain', pretty_print=pretty_print)
        if self.domain_entry_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdomain_entry_id>%s</%sdomain_entry_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.domain_entry_id).encode(ExternalEncoding), input_name='domain_entry_id'), namespace_, eol_))
        if self.department is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdepartment>%s</%sdepartment>%s' % (namespace_, self.gds_format_string(quote_xml(self.department).encode(ExternalEncoding), input_name='department'), namespace_, eol_))
        if self.logged_in is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slogged_in>%s</%slogged_in>%s' % (namespace_, self.gds_format_boolean(self.logged_in, input_name='logged_in'), namespace_, eol_))
        if self.namespace is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snamespace>%s</%snamespace>%s' % (namespace_, self.gds_format_string(quote_xml(self.namespace).encode(ExternalEncoding), input_name='namespace'), namespace_, eol_))
        if self.last_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slast_name>%s</%slast_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.last_name).encode(ExternalEncoding), input_name='last_name'), namespace_, eol_))
        if self.user_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_name>%s</%suser_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.user_name).encode(ExternalEncoding), input_name='user_name'), namespace_, eol_))
        if self.password is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespace_, self.gds_format_string(quote_xml(self.password).encode(ExternalEncoding), input_name='password'), namespace_, eol_))
        if self.email is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%semail>%s</%semail>%s' % (namespace_, self.gds_format_string(quote_xml(self.email).encode(ExternalEncoding), input_name='email'), namespace_, eol_))
        if self.roles is not None:
            self.roles.export(outfile, level, namespace_, name_='roles', pretty_print=pretty_print)
        if self.groups is not None:
            self.groups.export(outfile, level, namespace_, name_='groups', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='User'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(User, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(User, self).exportLiteralChildren(outfile, level, name_)
        if self.domain is not None:
            showIndent(outfile, level)
            outfile.write('domain=model_.domain(\n')
            self.domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.domain_entry_id is not None:
            showIndent(outfile, level)
            outfile.write('domain_entry_id=%s,\n' % quote_python(self.domain_entry_id).encode(ExternalEncoding))
        if self.department is not None:
            showIndent(outfile, level)
            outfile.write('department=%s,\n' % quote_python(self.department).encode(ExternalEncoding))
        if self.logged_in is not None:
            showIndent(outfile, level)
            outfile.write('logged_in=%s,\n' % self.logged_in)
        if self.namespace is not None:
            showIndent(outfile, level)
            outfile.write('namespace=%s,\n' % quote_python(self.namespace).encode(ExternalEncoding))
        if self.last_name is not None:
            showIndent(outfile, level)
            outfile.write('last_name=%s,\n' % quote_python(self.last_name).encode(ExternalEncoding))
        if self.user_name is not None:
            showIndent(outfile, level)
            outfile.write('user_name=%s,\n' % quote_python(self.user_name).encode(ExternalEncoding))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % quote_python(self.password).encode(ExternalEncoding))
        if self.email is not None:
            showIndent(outfile, level)
            outfile.write('email=%s,\n' % quote_python(self.email).encode(ExternalEncoding))
        if self.roles is not None:
            showIndent(outfile, level)
            outfile.write('roles=model_.Roles(\n')
            self.roles.exportLiteral(outfile, level, name_='roles')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.groups is not None:
            showIndent(outfile, level)
            outfile.write('groups=model_.groups(\n')
            self.groups.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(User, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'domain':
            obj_ = Domain.factory()
            obj_.build(child_)
            self.domain = obj_
        elif nodeName_ == 'domain_entry_id':
            domain_entry_id_ = child_.text
            domain_entry_id_ = self.gds_validate_string(domain_entry_id_, node, 'domain_entry_id')
            self.domain_entry_id = domain_entry_id_
        elif nodeName_ == 'department':
            department_ = child_.text
            department_ = self.gds_validate_string(department_, node, 'department')
            self.department = department_
        elif nodeName_ == 'logged_in':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'logged_in')
            self.logged_in = ival_
        elif nodeName_ == 'namespace':
            namespace_ = child_.text
            namespace_ = self.gds_validate_string(namespace_, node, 'namespace')
            self.namespace = namespace_
        elif nodeName_ == 'last_name':
            last_name_ = child_.text
            last_name_ = self.gds_validate_string(last_name_, node, 'last_name')
            self.last_name = last_name_
        elif nodeName_ == 'user_name':
            user_name_ = child_.text
            user_name_ = self.gds_validate_string(user_name_, node, 'user_name')
            self.user_name = user_name_
        elif nodeName_ == 'password':
            password_ = child_.text
            password_ = self.gds_validate_string(password_, node, 'password')
            self.password = password_
        elif nodeName_ == 'email':
            email_ = child_.text
            email_ = self.gds_validate_string(email_, node, 'email')
            self.email = email_
        elif nodeName_ == 'roles':
            obj_ = Roles.factory()
            obj_.build(child_)
            self.roles = obj_
        elif nodeName_ == 'groups':
            obj_ = Groups.factory()
            obj_.build(child_)
            self.groups = obj_
        super(User, self).buildChildren(child_, node, nodeName_, True)
# end class User


class JobOwner(User):
    subclass = None
    superclass = User
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, domain=None, domain_entry_id=None, department=None, logged_in=None, namespace=None, last_name=None, user_name=None, password=None, email=None, roles=None, groups=None):
        super(JobOwner, self).__init__(actions, href, id, name, description, comment, creation_status, link, domain, domain_entry_id, department, logged_in, namespace, last_name, user_name, password, email, roles, groups, )
        pass
    def factory(*args_, **kwargs_):
        if JobOwner.subclass:
            return JobOwner.subclass(*args_, **kwargs_)
        else:
            return JobOwner(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(JobOwner, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='JobOwner', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='JobOwner')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='JobOwner'):
        super(JobOwner, self).exportAttributes(outfile, level, already_processed, namespace_, name_='JobOwner')
    def exportChildren(self, outfile, level, namespace_='', name_='JobOwner', fromsubclass_=False, pretty_print=True):
        super(JobOwner, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='JobOwner'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(JobOwner, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(JobOwner, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(JobOwner, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(JobOwner, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class JobOwner


class Users(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, user=None):
        super(Users, self).__init__(actions, total, active, )
        if user is None:
            self.user = []
        else:
            self.user = user
    def factory(*args_, **kwargs_):
        if Users.subclass:
            return Users.subclass(*args_, **kwargs_)
        else:
            return Users(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_user(self): return self.user
    def set_user(self, user): self.user = user
    def add_user(self, value): self.user.append(value)
    def insert_user(self, index, value): self.user[index] = value
    def hasContent_(self):
        if (
            self.user or
            super(Users, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Users', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Users')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Users'):
        super(Users, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Users')
    def exportChildren(self, outfile, level, namespace_='', name_='Users', fromsubclass_=False, pretty_print=True):
        super(Users, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for user_ in self.user:
            user_.export(outfile, level, namespace_, name_='user', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Users'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Users, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Users, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('user=[\n')
        level += 1
        for user_ in self.user:
            showIndent(outfile, level)
            outfile.write('model_.user(\n')
            user_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Users, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'user':
            class_obj_ = self.get_class_obj_(child_, User)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.user.append(obj_)
        super(Users, self).buildChildren(child_, node, nodeName_, True)
# end class Users


class AuthenticationMethod(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, authentication_method=None):
        if authentication_method is None:
            self.authentication_method = []
        else:
            self.authentication_method = authentication_method
    def factory(*args_, **kwargs_):
        if AuthenticationMethod.subclass:
            return AuthenticationMethod.subclass(*args_, **kwargs_)
        else:
            return AuthenticationMethod(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_authentication_method(self): return self.authentication_method
    def set_authentication_method(self, authentication_method): self.authentication_method = authentication_method
    def add_authentication_method(self, value): self.authentication_method.append(value)
    def insert_authentication_method(self, index, value): self.authentication_method[index] = value
    def hasContent_(self):
        if (
            self.authentication_method
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AuthenticationMethod', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AuthenticationMethod')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AuthenticationMethod'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='AuthenticationMethod', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for authentication_method_ in self.authentication_method:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sauthentication_method>%s</%sauthentication_method>%s' % (namespace_, self.gds_format_string(quote_xml(authentication_method_).encode(ExternalEncoding), input_name='authentication_method'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='AuthenticationMethod'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('authentication_method=[\n')
        level += 1
        for authentication_method_ in self.authentication_method:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(authentication_method_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'authentication_method':
            authentication_method_ = child_.text
            authentication_method_ = self.gds_validate_string(authentication_method_, node, 'authentication_method')
            self.authentication_method.append(authentication_method_)
# end class AuthenticationMethod


class SSH(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, port=None, fingerprint=None, authentication_method=None, user=None):
        super(SSH, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.port = port
        self.fingerprint = fingerprint
        self.authentication_method = authentication_method
        self.user = user
    def factory(*args_, **kwargs_):
        if SSH.subclass:
            return SSH.subclass(*args_, **kwargs_)
        else:
            return SSH(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_port(self): return self.port
    def set_port(self, port): self.port = port
    def get_fingerprint(self): return self.fingerprint
    def set_fingerprint(self, fingerprint): self.fingerprint = fingerprint
    def get_authentication_method(self): return self.authentication_method
    def set_authentication_method(self, authentication_method): self.authentication_method = authentication_method
    def get_user(self): return self.user
    def set_user(self, user): self.user = user
    def hasContent_(self):
        if (
            self.port is not None or
            self.fingerprint is not None or
            self.authentication_method is not None or
            self.user is not None or
            super(SSH, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SSH', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SSH')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SSH'):
        super(SSH, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SSH')
    def exportChildren(self, outfile, level, namespace_='', name_='SSH', fromsubclass_=False, pretty_print=True):
        super(SSH, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.port is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sport>%s</%sport>%s' % (namespace_, self.gds_format_integer(self.port, input_name='port'), namespace_, eol_))
        if self.fingerprint is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfingerprint>%s</%sfingerprint>%s' % (namespace_, self.gds_format_string(quote_xml(self.fingerprint).encode(ExternalEncoding), input_name='fingerprint'), namespace_, eol_))
        if self.authentication_method is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sauthentication_method>%s</%sauthentication_method>%s' % (namespace_, self.gds_format_string(quote_xml(self.authentication_method).encode(ExternalEncoding), input_name='authentication_method'), namespace_, eol_))
        if self.user is not None:
            self.user.export(outfile, level, namespace_, name_='user', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SSH'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(SSH, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(SSH, self).exportLiteralChildren(outfile, level, name_)
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('port=%d,\n' % self.port)
        if self.fingerprint is not None:
            showIndent(outfile, level)
            outfile.write('fingerprint=%s,\n' % quote_python(self.fingerprint).encode(ExternalEncoding))
        if self.authentication_method is not None:
            showIndent(outfile, level)
            outfile.write('authentication_method=%s,\n' % quote_python(self.authentication_method).encode(ExternalEncoding))
        if self.user is not None:
            showIndent(outfile, level)
            outfile.write('user=model_.user(\n')
            self.user.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(SSH, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'port')
            self.port = ival_
        elif nodeName_ == 'fingerprint':
            fingerprint_ = child_.text
            fingerprint_ = self.gds_validate_string(fingerprint_, node, 'fingerprint')
            self.fingerprint = fingerprint_
        elif nodeName_ == 'authentication_method':
            authentication_method_ = child_.text
            authentication_method_ = self.gds_validate_string(authentication_method_, node, 'authentication_method')
            self.authentication_method = authentication_method_
        elif nodeName_ == 'user':
            class_obj_ = self.get_class_obj_(child_, User)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.user = obj_
        super(SSH, self).buildChildren(child_, node, nodeName_, True)
# end class SSH


class Group(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, domain=None, domain_entry_id=None, namespace=None, roles=None):
        super(Group, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.domain = domain
        self.domain_entry_id = domain_entry_id
        self.namespace = namespace
        self.roles = roles
    def factory(*args_, **kwargs_):
        if Group.subclass:
            return Group.subclass(*args_, **kwargs_)
        else:
            return Group(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_domain(self): return self.domain
    def set_domain(self, domain): self.domain = domain
    def get_domain_entry_id(self): return self.domain_entry_id
    def set_domain_entry_id(self, domain_entry_id): self.domain_entry_id = domain_entry_id
    def get_namespace(self): return self.namespace
    def set_namespace(self, namespace): self.namespace = namespace
    def get_roles(self): return self.roles
    def set_roles(self, roles): self.roles = roles
    def hasContent_(self):
        if (
            self.domain is not None or
            self.domain_entry_id is not None or
            self.namespace is not None or
            self.roles is not None or
            super(Group, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Group', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Group')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Group'):
        super(Group, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Group')
    def exportChildren(self, outfile, level, namespace_='', name_='Group', fromsubclass_=False, pretty_print=True):
        super(Group, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.domain is not None:
            self.domain.export(outfile, level, namespace_, name_='domain', pretty_print=pretty_print)
        if self.domain_entry_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdomain_entry_id>%s</%sdomain_entry_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.domain_entry_id).encode(ExternalEncoding), input_name='domain_entry_id'), namespace_, eol_))
        if self.namespace is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snamespace>%s</%snamespace>%s' % (namespace_, self.gds_format_string(quote_xml(self.namespace).encode(ExternalEncoding), input_name='namespace'), namespace_, eol_))
        if self.roles is not None:
            self.roles.export(outfile, level, namespace_, name_='roles', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Group'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Group, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Group, self).exportLiteralChildren(outfile, level, name_)
        if self.domain is not None:
            showIndent(outfile, level)
            outfile.write('domain=model_.domain(\n')
            self.domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.domain_entry_id is not None:
            showIndent(outfile, level)
            outfile.write('domain_entry_id=%s,\n' % quote_python(self.domain_entry_id).encode(ExternalEncoding))
        if self.namespace is not None:
            showIndent(outfile, level)
            outfile.write('namespace=%s,\n' % quote_python(self.namespace).encode(ExternalEncoding))
        if self.roles is not None:
            showIndent(outfile, level)
            outfile.write('roles=model_.Roles(\n')
            self.roles.exportLiteral(outfile, level, name_='roles')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Group, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'domain':
            obj_ = Domain.factory()
            obj_.build(child_)
            self.domain = obj_
        elif nodeName_ == 'domain_entry_id':
            domain_entry_id_ = child_.text
            domain_entry_id_ = self.gds_validate_string(domain_entry_id_, node, 'domain_entry_id')
            self.domain_entry_id = domain_entry_id_
        elif nodeName_ == 'namespace':
            namespace_ = child_.text
            namespace_ = self.gds_validate_string(namespace_, node, 'namespace')
            self.namespace = namespace_
        elif nodeName_ == 'roles':
            obj_ = Roles.factory()
            obj_.build(child_)
            self.roles = obj_
        super(Group, self).buildChildren(child_, node, nodeName_, True)
# end class Group


class Groups(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, group=None):
        super(Groups, self).__init__(actions, total, active, )
        if group is None:
            self.group = []
        else:
            self.group = group
    def factory(*args_, **kwargs_):
        if Groups.subclass:
            return Groups.subclass(*args_, **kwargs_)
        else:
            return Groups(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_group(self): return self.group
    def set_group(self, group): self.group = group
    def add_group(self, value): self.group.append(value)
    def insert_group(self, index, value): self.group[index] = value
    def hasContent_(self):
        if (
            self.group or
            super(Groups, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Groups', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Groups')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Groups'):
        super(Groups, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Groups')
    def exportChildren(self, outfile, level, namespace_='', name_='Groups', fromsubclass_=False, pretty_print=True):
        super(Groups, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for group_ in self.group:
            group_.export(outfile, level, namespace_, name_='group', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Groups'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Groups, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Groups, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('group=[\n')
        level += 1
        for group_ in self.group:
            showIndent(outfile, level)
            outfile.write('model_.group(\n')
            group_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Groups, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'group':
            obj_ = Group.factory()
            obj_.build(child_)
            self.group.append(obj_)
        super(Groups, self).buildChildren(child_, node, nodeName_, True)
# end class Groups


class Permission(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, role=None, user=None, group=None, data_center=None, cluster=None, host=None, storage_domain=None, vm=None, vmpool=None, template=None, disk=None):
        super(Permission, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.role = role
        self.user = user
        self.group = group
        self.data_center = data_center
        self.cluster = cluster
        self.host = host
        self.storage_domain = storage_domain
        self.vm = vm
        self.vmpool = vmpool
        self.template = template
        self.disk = disk
    def factory(*args_, **kwargs_):
        if Permission.subclass:
            return Permission.subclass(*args_, **kwargs_)
        else:
            return Permission(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_role(self): return self.role
    def set_role(self, role): self.role = role
    def get_user(self): return self.user
    def set_user(self, user): self.user = user
    def get_group(self): return self.group
    def set_group(self, group): self.group = group
    def get_data_center(self): return self.data_center
    def set_data_center(self, data_center): self.data_center = data_center
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def get_storage_domain(self): return self.storage_domain
    def set_storage_domain(self, storage_domain): self.storage_domain = storage_domain
    def get_vm(self): return self.vm
    def set_vm(self, vm): self.vm = vm
    def get_vmpool(self): return self.vmpool
    def set_vmpool(self, vmpool): self.vmpool = vmpool
    def get_template(self): return self.template
    def set_template(self, template): self.template = template
    def get_disk(self): return self.disk
    def set_disk(self, disk): self.disk = disk
    def hasContent_(self):
        if (
            self.role is not None or
            self.user is not None or
            self.group is not None or
            self.data_center is not None or
            self.cluster is not None or
            self.host is not None or
            self.storage_domain is not None or
            self.vm is not None or
            self.vmpool is not None or
            self.template is not None or
            self.disk is not None or
            super(Permission, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Permission', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Permission')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Permission'):
        super(Permission, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Permission')
    def exportChildren(self, outfile, level, namespace_='', name_='Permission', fromsubclass_=False, pretty_print=True):
        super(Permission, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.role is not None:
            self.role.export(outfile, level, namespace_, name_='role', pretty_print=pretty_print)
        if self.user is not None:
            self.user.export(outfile, level, namespace_, name_='user', pretty_print=pretty_print)
        if self.group is not None:
            self.group.export(outfile, level, namespace_, name_='group', pretty_print=pretty_print)
        if self.data_center is not None:
            self.data_center.export(outfile, level, namespace_, name_='data_center', pretty_print=pretty_print)
        if self.cluster is not None:
            self.cluster.export(outfile, level, namespace_, name_='cluster', pretty_print=pretty_print)
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host', pretty_print=pretty_print)
        if self.storage_domain is not None:
            self.storage_domain.export(outfile, level, namespace_, name_='storage_domain', pretty_print=pretty_print)
        if self.vm is not None:
            self.vm.export(outfile, level, namespace_, name_='vm', pretty_print=pretty_print)
        if self.vmpool is not None:
            self.vmpool.export(outfile, level, namespace_, name_='vmpool', pretty_print=pretty_print)
        if self.template is not None:
            self.template.export(outfile, level, namespace_, name_='template', pretty_print=pretty_print)
        if self.disk is not None:
            self.disk.export(outfile, level, namespace_, name_='disk', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Permission'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Permission, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Permission, self).exportLiteralChildren(outfile, level, name_)
        if self.role is not None:
            showIndent(outfile, level)
            outfile.write('role=model_.Role(\n')
            self.role.exportLiteral(outfile, level, name_='role')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.user is not None:
            showIndent(outfile, level)
            outfile.write('user=model_.User(\n')
            self.user.exportLiteral(outfile, level, name_='user')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.group is not None:
            showIndent(outfile, level)
            outfile.write('group=model_.Group(\n')
            self.group.exportLiteral(outfile, level, name_='group')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.data_center is not None:
            showIndent(outfile, level)
            outfile.write('data_center=model_.data_center(\n')
            self.data_center.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cluster is not None:
            showIndent(outfile, level)
            outfile.write('cluster=model_.cluster(\n')
            self.cluster.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.storage_domain is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain=model_.storage_domain(\n')
            self.storage_domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vm is not None:
            showIndent(outfile, level)
            outfile.write('vm=model_.vm(\n')
            self.vm.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vmpool is not None:
            showIndent(outfile, level)
            outfile.write('vmpool=model_.vmpool(\n')
            self.vmpool.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.template is not None:
            showIndent(outfile, level)
            outfile.write('template=model_.template(\n')
            self.template.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.disk is not None:
            showIndent(outfile, level)
            outfile.write('disk=model_.disk(\n')
            self.disk.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Permission, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'role':
            obj_ = Role.factory()
            obj_.build(child_)
            self.role = obj_
        elif nodeName_ == 'user':
            class_obj_ = self.get_class_obj_(child_, User)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.user = obj_
        elif nodeName_ == 'group':
            obj_ = Group.factory()
            obj_.build(child_)
            self.group = obj_
        elif nodeName_ == 'data_center':
            obj_ = DataCenter.factory()
            obj_.build(child_)
            self.data_center = obj_
        elif nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.cluster = obj_
        elif nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.host = obj_
        elif nodeName_ == 'storage_domain':
            obj_ = StorageDomain.factory()
            obj_.build(child_)
            self.storage_domain = obj_
        elif nodeName_ == 'vm':
            class_obj_ = self.get_class_obj_(child_, VM)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.vm = obj_
        elif nodeName_ == 'vmpool':
            obj_ = VmPool.factory()
            obj_.build(child_)
            self.vmpool = obj_
        elif nodeName_ == 'template':
            class_obj_ = self.get_class_obj_(child_, Template)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.template = obj_
        elif nodeName_ == 'disk':
            class_obj_ = self.get_class_obj_(child_, Disk)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.disk = obj_
        super(Permission, self).buildChildren(child_, node, nodeName_, True)
# end class Permission


class Permissions(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, permission=None, clone=None):
        super(Permissions, self).__init__(actions, total, active, )
        if permission is None:
            self.permission = []
        else:
            self.permission = permission
        self.clone = clone
    def factory(*args_, **kwargs_):
        if Permissions.subclass:
            return Permissions.subclass(*args_, **kwargs_)
        else:
            return Permissions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_permission(self): return self.permission
    def set_permission(self, permission): self.permission = permission
    def add_permission(self, value): self.permission.append(value)
    def insert_permission(self, index, value): self.permission[index] = value
    def get_clone(self): return self.clone
    def set_clone(self, clone): self.clone = clone
    def hasContent_(self):
        if (
            self.permission or
            self.clone is not None or
            super(Permissions, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Permissions', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Permissions')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Permissions'):
        super(Permissions, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Permissions')
    def exportChildren(self, outfile, level, namespace_='', name_='Permissions', fromsubclass_=False, pretty_print=True):
        super(Permissions, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for permission_ in self.permission:
            permission_.export(outfile, level, namespace_, name_='permission', pretty_print=pretty_print)
        if self.clone is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sclone>%s</%sclone>%s' % (namespace_, self.gds_format_boolean(self.clone, input_name='clone'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Permissions'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Permissions, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Permissions, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('permission=[\n')
        level += 1
        for permission_ in self.permission:
            showIndent(outfile, level)
            outfile.write('model_.permission(\n')
            permission_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.clone is not None:
            showIndent(outfile, level)
            outfile.write('clone=%s,\n' % self.clone)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Permissions, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'permission':
            obj_ = Permission.factory()
            obj_.build(child_)
            self.permission.append(obj_)
        elif nodeName_ == 'clone':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'clone')
            self.clone = ival_
        super(Permissions, self).buildChildren(child_, node, nodeName_, True)
# end class Permissions


class Domain(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, user=None):
        super(Domain, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.user = user
    def factory(*args_, **kwargs_):
        if Domain.subclass:
            return Domain.subclass(*args_, **kwargs_)
        else:
            return Domain(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_user(self): return self.user
    def set_user(self, user): self.user = user
    def hasContent_(self):
        if (
            self.user is not None or
            super(Domain, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Domain', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Domain')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Domain'):
        super(Domain, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Domain')
    def exportChildren(self, outfile, level, namespace_='', name_='Domain', fromsubclass_=False, pretty_print=True):
        super(Domain, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.user is not None:
            self.user.export(outfile, level, namespace_, name_='user', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Domain'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Domain, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Domain, self).exportLiteralChildren(outfile, level, name_)
        if self.user is not None:
            showIndent(outfile, level)
            outfile.write('user=model_.User(\n')
            self.user.exportLiteral(outfile, level, name_='user')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Domain, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'user':
            class_obj_ = self.get_class_obj_(child_, User)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.user = obj_
        super(Domain, self).buildChildren(child_, node, nodeName_, True)
# end class Domain


class Domains(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, domain=None):
        super(Domains, self).__init__(actions, total, active, )
        if domain is None:
            self.domain = []
        else:
            self.domain = domain
    def factory(*args_, **kwargs_):
        if Domains.subclass:
            return Domains.subclass(*args_, **kwargs_)
        else:
            return Domains(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_domain(self): return self.domain
    def set_domain(self, domain): self.domain = domain
    def add_domain(self, value): self.domain.append(value)
    def insert_domain(self, index, value): self.domain[index] = value
    def hasContent_(self):
        if (
            self.domain or
            super(Domains, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Domains', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Domains')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Domains'):
        super(Domains, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Domains')
    def exportChildren(self, outfile, level, namespace_='', name_='Domains', fromsubclass_=False, pretty_print=True):
        super(Domains, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for domain_ in self.domain:
            domain_.export(outfile, level, namespace_, name_='domain', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Domains'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Domains, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Domains, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('domain=[\n')
        level += 1
        for domain_ in self.domain:
            showIndent(outfile, level)
            outfile.write('model_.domain(\n')
            domain_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Domains, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'domain':
            obj_ = Domain.factory()
            obj_.build(child_)
            self.domain.append(obj_)
        super(Domains, self).buildChildren(child_, node, nodeName_, True)
# end class Domains


class Event(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, code=None, severity=None, time=None, correlation_id=None, user=None, vm=None, storage_domain=None, host=None, template=None, cluster=None, data_center=None, origin=None, custom_id=None, flood_rate=None, custom_data=None):
        super(Event, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.code = code
        self.severity = severity
        if isinstance(time, basestring):
            initvalue_ = datetime_.datetime.strptime(time, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = time
        self.time = initvalue_
        self.correlation_id = correlation_id
        self.user = user
        self.vm = vm
        self.storage_domain = storage_domain
        self.host = host
        self.template = template
        self.cluster = cluster
        self.data_center = data_center
        self.origin = origin
        self.custom_id = custom_id
        self.flood_rate = flood_rate
        self.custom_data = custom_data
    def factory(*args_, **kwargs_):
        if Event.subclass:
            return Event.subclass(*args_, **kwargs_)
        else:
            return Event(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_severity(self): return self.severity
    def set_severity(self, severity): self.severity = severity
    def get_time(self): return self.time
    def set_time(self, time): self.time = time
    def get_correlation_id(self): return self.correlation_id
    def set_correlation_id(self, correlation_id): self.correlation_id = correlation_id
    def get_user(self): return self.user
    def set_user(self, user): self.user = user
    def get_vm(self): return self.vm
    def set_vm(self, vm): self.vm = vm
    def get_storage_domain(self): return self.storage_domain
    def set_storage_domain(self, storage_domain): self.storage_domain = storage_domain
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def get_template(self): return self.template
    def set_template(self, template): self.template = template
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def get_data_center(self): return self.data_center
    def set_data_center(self, data_center): self.data_center = data_center
    def get_origin(self): return self.origin
    def set_origin(self, origin): self.origin = origin
    def get_custom_id(self): return self.custom_id
    def set_custom_id(self, custom_id): self.custom_id = custom_id
    def get_flood_rate(self): return self.flood_rate
    def set_flood_rate(self, flood_rate): self.flood_rate = flood_rate
    def get_custom_data(self): return self.custom_data
    def set_custom_data(self, custom_data): self.custom_data = custom_data
    def hasContent_(self):
        if (
            self.code is not None or
            self.severity is not None or
            self.time is not None or
            self.correlation_id is not None or
            self.user is not None or
            self.vm is not None or
            self.storage_domain is not None or
            self.host is not None or
            self.template is not None or
            self.cluster is not None or
            self.data_center is not None or
            self.origin is not None or
            self.custom_id is not None or
            self.flood_rate is not None or
            self.custom_data is not None or
            super(Event, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Event', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Event')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Event'):
        super(Event, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Event')
    def exportChildren(self, outfile, level, namespace_='', name_='Event', fromsubclass_=False, pretty_print=True):
        super(Event, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.code is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scode>%s</%scode>%s' % (namespace_, self.gds_format_integer(self.code, input_name='code'), namespace_, eol_))
        if self.severity is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sseverity>%s</%sseverity>%s' % (namespace_, self.gds_format_string(quote_xml(self.severity).encode(ExternalEncoding), input_name='severity'), namespace_, eol_))
        if self.time is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stime>%s</%stime>%s' % (namespace_, self.gds_format_datetime(self.time, input_name='time'), namespace_, eol_))
        if self.correlation_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scorrelation_id>%s</%scorrelation_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.correlation_id).encode(ExternalEncoding), input_name='correlation_id'), namespace_, eol_))
        if self.user is not None:
            self.user.export(outfile, level, namespace_, name_='user', pretty_print=pretty_print)
        if self.vm is not None:
            self.vm.export(outfile, level, namespace_, name_='vm', pretty_print=pretty_print)
        if self.storage_domain is not None:
            self.storage_domain.export(outfile, level, namespace_, name_='storage_domain', pretty_print=pretty_print)
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host', pretty_print=pretty_print)
        if self.template is not None:
            self.template.export(outfile, level, namespace_, name_='template', pretty_print=pretty_print)
        if self.cluster is not None:
            self.cluster.export(outfile, level, namespace_, name_='cluster', pretty_print=pretty_print)
        if self.data_center is not None:
            self.data_center.export(outfile, level, namespace_, name_='data_center', pretty_print=pretty_print)
        if self.origin is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorigin>%s</%sorigin>%s' % (namespace_, self.gds_format_string(quote_xml(self.origin).encode(ExternalEncoding), input_name='origin'), namespace_, eol_))
        if self.custom_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scustom_id>%s</%scustom_id>%s' % (namespace_, self.gds_format_integer(self.custom_id, input_name='custom_id'), namespace_, eol_))
        if self.flood_rate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sflood_rate>%s</%sflood_rate>%s' % (namespace_, self.gds_format_integer(self.flood_rate, input_name='flood_rate'), namespace_, eol_))
        if self.custom_data is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scustom_data>%s</%scustom_data>%s' % (namespace_, self.gds_format_string(quote_xml(self.custom_data).encode(ExternalEncoding), input_name='custom_data'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Event'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Event, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Event, self).exportLiteralChildren(outfile, level, name_)
        if self.code is not None:
            showIndent(outfile, level)
            outfile.write('code=%d,\n' % self.code)
        if self.severity is not None:
            showIndent(outfile, level)
            outfile.write('severity=%s,\n' % quote_python(self.severity).encode(ExternalEncoding))
        if self.time is not None:
            showIndent(outfile, level)
            outfile.write('time=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.time, input_name='time'))
        if self.correlation_id is not None:
            showIndent(outfile, level)
            outfile.write('correlation_id=%s,\n' % quote_python(self.correlation_id).encode(ExternalEncoding))
        if self.user is not None:
            showIndent(outfile, level)
            outfile.write('user=model_.user(\n')
            self.user.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vm is not None:
            showIndent(outfile, level)
            outfile.write('vm=model_.vm(\n')
            self.vm.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.storage_domain is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain=model_.storage_domain(\n')
            self.storage_domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.template is not None:
            showIndent(outfile, level)
            outfile.write('template=model_.template(\n')
            self.template.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cluster is not None:
            showIndent(outfile, level)
            outfile.write('cluster=model_.cluster(\n')
            self.cluster.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.data_center is not None:
            showIndent(outfile, level)
            outfile.write('data_center=model_.data_center(\n')
            self.data_center.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.origin is not None:
            showIndent(outfile, level)
            outfile.write('origin=%s,\n' % quote_python(self.origin).encode(ExternalEncoding))
        if self.custom_id is not None:
            showIndent(outfile, level)
            outfile.write('custom_id=%d,\n' % self.custom_id)
        if self.flood_rate is not None:
            showIndent(outfile, level)
            outfile.write('flood_rate=%d,\n' % self.flood_rate)
        if self.custom_data is not None:
            showIndent(outfile, level)
            outfile.write('custom_data=%s,\n' % quote_python(self.custom_data).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Event, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'code':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'code')
            self.code = ival_
        elif nodeName_ == 'severity':
            severity_ = child_.text
            severity_ = self.gds_validate_string(severity_, node, 'severity')
            self.severity = severity_
        elif nodeName_ == 'time':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.time = dval_
        elif nodeName_ == 'correlation_id':
            correlation_id_ = child_.text
            correlation_id_ = self.gds_validate_string(correlation_id_, node, 'correlation_id')
            self.correlation_id = correlation_id_
        elif nodeName_ == 'user':
            class_obj_ = self.get_class_obj_(child_, User)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.user = obj_
        elif nodeName_ == 'vm':
            class_obj_ = self.get_class_obj_(child_, VM)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.vm = obj_
        elif nodeName_ == 'storage_domain':
            obj_ = StorageDomain.factory()
            obj_.build(child_)
            self.storage_domain = obj_
        elif nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.host = obj_
        elif nodeName_ == 'template':
            class_obj_ = self.get_class_obj_(child_, Template)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.template = obj_
        elif nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.cluster = obj_
        elif nodeName_ == 'data_center':
            obj_ = DataCenter.factory()
            obj_.build(child_)
            self.data_center = obj_
        elif nodeName_ == 'origin':
            origin_ = child_.text
            origin_ = self.gds_validate_string(origin_, node, 'origin')
            self.origin = origin_
        elif nodeName_ == 'custom_id':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'custom_id')
            self.custom_id = ival_
        elif nodeName_ == 'flood_rate':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'flood_rate')
            self.flood_rate = ival_
        elif nodeName_ == 'custom_data':
            custom_data_ = child_.text
            custom_data_ = self.gds_validate_string(custom_data_, node, 'custom_data')
            self.custom_data = custom_data_
        super(Event, self).buildChildren(child_, node, nodeName_, True)
# end class Event


class Events(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, event=None):
        super(Events, self).__init__(actions, total, active, )
        if event is None:
            self.event = []
        else:
            self.event = event
    def factory(*args_, **kwargs_):
        if Events.subclass:
            return Events.subclass(*args_, **kwargs_)
        else:
            return Events(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_event(self): return self.event
    def set_event(self, event): self.event = event
    def add_event(self, value): self.event.append(value)
    def insert_event(self, index, value): self.event[index] = value
    def hasContent_(self):
        if (
            self.event or
            super(Events, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Events', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Events')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Events'):
        super(Events, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Events')
    def exportChildren(self, outfile, level, namespace_='', name_='Events', fromsubclass_=False, pretty_print=True):
        super(Events, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for event_ in self.event:
            event_.export(outfile, level, namespace_, name_='event', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Events'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Events, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Events, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('event=[\n')
        level += 1
        for event_ in self.event:
            showIndent(outfile, level)
            outfile.write('model_.event(\n')
            event_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Events, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'event':
            obj_ = Event.factory()
            obj_.build(child_)
            self.event.append(obj_)
        super(Events, self).buildChildren(child_, node, nodeName_, True)
# end class Events


class File(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, content=None, type_=None, storage_domain=None):
        super(File, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.content = content
        self.type_ = type_
        self.storage_domain = storage_domain
    def factory(*args_, **kwargs_):
        if File.subclass:
            return File.subclass(*args_, **kwargs_)
        else:
            return File(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_content(self): return self.content
    def set_content(self, content): self.content = content
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_storage_domain(self): return self.storage_domain
    def set_storage_domain(self, storage_domain): self.storage_domain = storage_domain
    def hasContent_(self):
        if (
            self.content is not None or
            self.type_ is not None or
            self.storage_domain is not None or
            super(File, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='File', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='File')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='File'):
        super(File, self).exportAttributes(outfile, level, already_processed, namespace_, name_='File')
    def exportChildren(self, outfile, level, namespace_='', name_='File', fromsubclass_=False, pretty_print=True):
        super(File, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.content is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scontent>%s</%scontent>%s' % (namespace_, self.gds_format_string(quote_xml(self.content).encode(ExternalEncoding), input_name='content'), namespace_, eol_))
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.storage_domain is not None:
            self.storage_domain.export(outfile, level, namespace_, name_='storage_domain', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='File'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(File, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(File, self).exportLiteralChildren(outfile, level, name_)
        if self.content is not None:
            showIndent(outfile, level)
            outfile.write('content=%s,\n' % quote_python(self.content).encode(ExternalEncoding))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.storage_domain is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain=model_.storage_domain(\n')
            self.storage_domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(File, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'content':
            content_ = child_.text
            content_ = self.gds_validate_string(content_, node, 'content')
            self.content = content_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'storage_domain':
            obj_ = StorageDomain.factory()
            obj_.build(child_)
            self.storage_domain = obj_
        super(File, self).buildChildren(child_, node, nodeName_, True)
# end class File


class Files(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, file=None):
        super(Files, self).__init__(actions, total, active, )
        if file is None:
            self.file = []
        else:
            self.file = file
    def factory(*args_, **kwargs_):
        if Files.subclass:
            return Files.subclass(*args_, **kwargs_)
        else:
            return Files(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_file(self): return self.file
    def set_file(self, file): self.file = file
    def add_file(self, value): self.file.append(value)
    def insert_file(self, index, value): self.file[index] = value
    def hasContent_(self):
        if (
            self.file or
            super(Files, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Files', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Files')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Files'):
        super(Files, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Files')
    def exportChildren(self, outfile, level, namespace_='', name_='Files', fromsubclass_=False, pretty_print=True):
        super(Files, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for file_ in self.file:
            file_.export(outfile, level, namespace_, name_='file', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Files'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Files, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Files, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('file=[\n')
        level += 1
        for file_ in self.file:
            showIndent(outfile, level)
            outfile.write('model_.file(\n')
            file_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Files, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'file':
            obj_ = File.factory()
            obj_.build(child_)
            self.file.append(obj_)
        super(Files, self).buildChildren(child_, node, nodeName_, True)
# end class Files


class Image(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, storage_domain=None):
        super(Image, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.storage_domain = storage_domain
    def factory(*args_, **kwargs_):
        if Image.subclass:
            return Image.subclass(*args_, **kwargs_)
        else:
            return Image(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_storage_domain(self): return self.storage_domain
    def set_storage_domain(self, storage_domain): self.storage_domain = storage_domain
    def hasContent_(self):
        if (
            self.storage_domain is not None or
            super(Image, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Image', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Image')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Image'):
        super(Image, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Image')
    def exportChildren(self, outfile, level, namespace_='', name_='Image', fromsubclass_=False, pretty_print=True):
        super(Image, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.storage_domain is not None:
            self.storage_domain.export(outfile, level, namespace_, name_='storage_domain', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Image'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Image, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Image, self).exportLiteralChildren(outfile, level, name_)
        if self.storage_domain is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain=model_.storage_domain(\n')
            self.storage_domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Image, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'storage_domain':
            obj_ = StorageDomain.factory()
            obj_.build(child_)
            self.storage_domain = obj_
        super(Image, self).buildChildren(child_, node, nodeName_, True)
# end class Image


class Images(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, image=None):
        super(Images, self).__init__(actions, total, active, )
        if image is None:
            self.image = []
        else:
            self.image = image
    def factory(*args_, **kwargs_):
        if Images.subclass:
            return Images.subclass(*args_, **kwargs_)
        else:
            return Images(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_image(self): return self.image
    def set_image(self, image): self.image = image
    def add_image(self, value): self.image.append(value)
    def insert_image(self, index, value): self.image[index] = value
    def hasContent_(self):
        if (
            self.image or
            super(Images, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Images', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Images')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Images'):
        super(Images, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Images')
    def exportChildren(self, outfile, level, namespace_='', name_='Images', fromsubclass_=False, pretty_print=True):
        super(Images, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for image_ in self.image:
            image_.export(outfile, level, namespace_, name_='image', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Images'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Images, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Images, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('image=[\n')
        level += 1
        for image_ in self.image:
            showIndent(outfile, level)
            outfile.write('model_.image(\n')
            image_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Images, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'image':
            obj_ = Image.factory()
            obj_.build(child_)
            self.image.append(obj_)
        super(Images, self).buildChildren(child_, node, nodeName_, True)
# end class Images


class Hook(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, event_name=None, md5=None, host=None):
        super(Hook, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.event_name = event_name
        self.md5 = md5
        self.host = host
    def factory(*args_, **kwargs_):
        if Hook.subclass:
            return Hook.subclass(*args_, **kwargs_)
        else:
            return Hook(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_event_name(self): return self.event_name
    def set_event_name(self, event_name): self.event_name = event_name
    def get_md5(self): return self.md5
    def set_md5(self, md5): self.md5 = md5
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def hasContent_(self):
        if (
            self.event_name is not None or
            self.md5 is not None or
            self.host is not None or
            super(Hook, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Hook', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Hook')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Hook'):
        super(Hook, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Hook')
    def exportChildren(self, outfile, level, namespace_='', name_='Hook', fromsubclass_=False, pretty_print=True):
        super(Hook, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.event_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sevent_name>%s</%sevent_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.event_name).encode(ExternalEncoding), input_name='event_name'), namespace_, eol_))
        if self.md5 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smd5>%s</%smd5>%s' % (namespace_, self.gds_format_string(quote_xml(self.md5).encode(ExternalEncoding), input_name='md5'), namespace_, eol_))
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Hook'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Hook, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Hook, self).exportLiteralChildren(outfile, level, name_)
        if self.event_name is not None:
            showIndent(outfile, level)
            outfile.write('event_name=%s,\n' % quote_python(self.event_name).encode(ExternalEncoding))
        if self.md5 is not None:
            showIndent(outfile, level)
            outfile.write('md5=%s,\n' % quote_python(self.md5).encode(ExternalEncoding))
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Hook, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'event_name':
            event_name_ = child_.text
            event_name_ = self.gds_validate_string(event_name_, node, 'event_name')
            self.event_name = event_name_
        elif nodeName_ == 'md5':
            md5_ = child_.text
            md5_ = self.gds_validate_string(md5_, node, 'md5')
            self.md5 = md5_
        elif nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.host = obj_
        super(Hook, self).buildChildren(child_, node, nodeName_, True)
# end class Hook


class Hooks(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, hook=None):
        super(Hooks, self).__init__(actions, total, active, )
        if hook is None:
            self.hook = []
        else:
            self.hook = hook
    def factory(*args_, **kwargs_):
        if Hooks.subclass:
            return Hooks.subclass(*args_, **kwargs_)
        else:
            return Hooks(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_hook(self): return self.hook
    def set_hook(self, hook): self.hook = hook
    def add_hook(self, value): self.hook.append(value)
    def insert_hook(self, index, value): self.hook[index] = value
    def hasContent_(self):
        if (
            self.hook or
            super(Hooks, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Hooks', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Hooks')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Hooks'):
        super(Hooks, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Hooks')
    def exportChildren(self, outfile, level, namespace_='', name_='Hooks', fromsubclass_=False, pretty_print=True):
        super(Hooks, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for hook_ in self.hook:
            hook_.export(outfile, level, namespace_, name_='hook', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Hooks'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Hooks, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Hooks, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('hook=[\n')
        level += 1
        for hook_ in self.hook:
            showIndent(outfile, level)
            outfile.write('model_.hook(\n')
            hook_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Hooks, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'hook':
            obj_ = Hook.factory()
            obj_.build(child_)
            self.hook.append(obj_)
        super(Hooks, self).buildChildren(child_, node, nodeName_, True)
# end class Hooks


class IP(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, netmask=None, version=None, gateway=None, address=None):
        self.netmask = _cast(None, netmask)
        self.version = _cast(None, version)
        self.gateway = _cast(None, gateway)
        self.address = _cast(None, address)
        pass
    def factory(*args_, **kwargs_):
        if IP.subclass:
            return IP.subclass(*args_, **kwargs_)
        else:
            return IP(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_netmask(self): return self.netmask
    def set_netmask(self, netmask): self.netmask = netmask
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_gateway(self): return self.gateway
    def set_gateway(self, gateway): self.gateway = gateway
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IP', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IP')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IP'):
        if self.netmask is not None and 'netmask' not in already_processed:
            already_processed.add('netmask')
            outfile.write(' netmask=%s' % (self.gds_format_string(quote_attrib(self.netmask).encode(ExternalEncoding), input_name='netmask'), ))
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            outfile.write(' version=%s' % (self.gds_format_string(quote_attrib(self.version).encode(ExternalEncoding), input_name='version'), ))
        if self.gateway is not None and 'gateway' not in already_processed:
            already_processed.add('gateway')
            outfile.write(' gateway=%s' % (self.gds_format_string(quote_attrib(self.gateway).encode(ExternalEncoding), input_name='gateway'), ))
        if self.address is not None and 'address' not in already_processed:
            already_processed.add('address')
            outfile.write(' address=%s' % (self.gds_format_string(quote_attrib(self.address).encode(ExternalEncoding), input_name='address'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='IP', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='IP'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.netmask is not None and 'netmask' not in already_processed:
            already_processed.add('netmask')
            showIndent(outfile, level)
            outfile.write('netmask="%s",\n' % (self.netmask,))
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            showIndent(outfile, level)
            outfile.write('version="%s",\n' % (self.version,))
        if self.gateway is not None and 'gateway' not in already_processed:
            already_processed.add('gateway')
            showIndent(outfile, level)
            outfile.write('gateway="%s",\n' % (self.gateway,))
        if self.address is not None and 'address' not in already_processed:
            already_processed.add('address')
            showIndent(outfile, level)
            outfile.write('address="%s",\n' % (self.address,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('netmask', node)
        if value is not None and 'netmask' not in already_processed:
            already_processed.add('netmask')
            self.netmask = value
        value = find_attr_value_('version', node)
        if value is not None and 'version' not in already_processed:
            already_processed.add('version')
            self.version = value
        value = find_attr_value_('gateway', node)
        if value is not None and 'gateway' not in already_processed:
            already_processed.add('gateway')
            self.gateway = value
        value = find_attr_value_('address', node)
        if value is not None and 'address' not in already_processed:
            already_processed.add('address')
            self.address = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class IP


class IPs(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, ip=None):
        super(IPs, self).__init__(actions, total, active, )
        if ip is None:
            self.ip = []
        else:
            self.ip = ip
    def factory(*args_, **kwargs_):
        if IPs.subclass:
            return IPs.subclass(*args_, **kwargs_)
        else:
            return IPs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ip(self): return self.ip
    def set_ip(self, ip): self.ip = ip
    def add_ip(self, value): self.ip.append(value)
    def insert_ip(self, index, value): self.ip[index] = value
    def hasContent_(self):
        if (
            self.ip or
            super(IPs, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IPs', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IPs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IPs'):
        super(IPs, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IPs')
    def exportChildren(self, outfile, level, namespace_='', name_='IPs', fromsubclass_=False, pretty_print=True):
        super(IPs, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ip_ in self.ip:
            ip_.export(outfile, level, namespace_, name_='ip', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IPs'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(IPs, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IPs, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('ip=[\n')
        level += 1
        for ip_ in self.ip:
            showIndent(outfile, level)
            outfile.write('model_.ip(\n')
            ip_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(IPs, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ip':
            obj_ = IP.factory()
            obj_.build(child_)
            self.ip.append(obj_)
        super(IPs, self).buildChildren(child_, node, nodeName_, True)
# end class IPs


class MAC(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, address=None):
        self.address = _cast(None, address)
        pass
    def factory(*args_, **kwargs_):
        if MAC.subclass:
            return MAC.subclass(*args_, **kwargs_)
        else:
            return MAC(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MAC', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MAC')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MAC'):
        if self.address is not None and 'address' not in already_processed:
            already_processed.add('address')
            outfile.write(' address=%s' % (self.gds_format_string(quote_attrib(self.address).encode(ExternalEncoding), input_name='address'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='MAC', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='MAC'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.address is not None and 'address' not in already_processed:
            already_processed.add('address')
            showIndent(outfile, level)
            outfile.write('address="%s",\n' % (self.address,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('address', node)
        if value is not None and 'address' not in already_processed:
            already_processed.add('address')
            self.address = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class MAC


class VLAN(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None):
        self.id = _cast(int, id)
        pass
    def factory(*args_, **kwargs_):
        if VLAN.subclass:
            return VLAN.subclass(*args_, **kwargs_)
        else:
            return VLAN(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VLAN', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VLAN')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VLAN'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespace_='', name_='VLAN', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='VLAN'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id=%d,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class VLAN


class Network(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, data_center=None, cluster=None, ip=None, vlan=None, stp=None, status=None, display=None, mtu=None, usages=None, required=None, profile_required=None, labels=None):
        super(Network, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.data_center = data_center
        self.cluster = cluster
        self.ip = ip
        self.vlan = vlan
        self.stp = stp
        self.status = status
        self.display = display
        self.mtu = mtu
        self.usages = usages
        self.required = required
        self.profile_required = profile_required
        self.labels = labels
    def factory(*args_, **kwargs_):
        if Network.subclass:
            return Network.subclass(*args_, **kwargs_)
        else:
            return Network(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_data_center(self): return self.data_center
    def set_data_center(self, data_center): self.data_center = data_center
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def get_ip(self): return self.ip
    def set_ip(self, ip): self.ip = ip
    def get_vlan(self): return self.vlan
    def set_vlan(self, vlan): self.vlan = vlan
    def get_stp(self): return self.stp
    def set_stp(self, stp): self.stp = stp
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_display(self): return self.display
    def set_display(self, display): self.display = display
    def get_mtu(self): return self.mtu
    def set_mtu(self, mtu): self.mtu = mtu
    def get_usages(self): return self.usages
    def set_usages(self, usages): self.usages = usages
    def get_required(self): return self.required
    def set_required(self, required): self.required = required
    def get_profile_required(self): return self.profile_required
    def set_profile_required(self, profile_required): self.profile_required = profile_required
    def get_labels(self): return self.labels
    def set_labels(self, labels): self.labels = labels
    def hasContent_(self):
        if (
            self.data_center is not None or
            self.cluster is not None or
            self.ip is not None or
            self.vlan is not None or
            self.stp is not None or
            self.status is not None or
            self.display is not None or
            self.mtu is not None or
            self.usages is not None or
            self.required is not None or
            self.profile_required is not None or
            self.labels is not None or
            super(Network, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Network', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Network')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Network'):
        super(Network, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Network')
    def exportChildren(self, outfile, level, namespace_='', name_='Network', fromsubclass_=False, pretty_print=True):
        super(Network, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.data_center is not None:
            self.data_center.export(outfile, level, namespace_, name_='data_center', pretty_print=pretty_print)
        if self.cluster is not None:
            self.cluster.export(outfile, level, namespace_, name_='cluster', pretty_print=pretty_print)
        if self.ip is not None:
            self.ip.export(outfile, level, namespace_, name_='ip', pretty_print=pretty_print)
        if self.vlan is not None:
            self.vlan.export(outfile, level, namespace_, name_='vlan', pretty_print=pretty_print)
        if self.stp is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstp>%s</%sstp>%s' % (namespace_, self.gds_format_boolean(self.stp, input_name='stp'), namespace_, eol_))
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status', pretty_print=pretty_print)
        if self.display is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplay>%s</%sdisplay>%s' % (namespace_, self.gds_format_boolean(self.display, input_name='display'), namespace_, eol_))
        if self.mtu is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smtu>%s</%smtu>%s' % (namespace_, self.gds_format_integer(self.mtu, input_name='mtu'), namespace_, eol_))
        if self.usages is not None:
            self.usages.export(outfile, level, namespace_, name_='usages', pretty_print=pretty_print)
        if self.required is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srequired>%s</%srequired>%s' % (namespace_, self.gds_format_boolean(self.required, input_name='required'), namespace_, eol_))
        if self.profile_required is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprofile_required>%s</%sprofile_required>%s' % (namespace_, self.gds_format_boolean(self.profile_required, input_name='profile_required'), namespace_, eol_))
        if self.labels is not None:
            self.labels.export(outfile, level, namespace_, name_='labels', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Network'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Network, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Network, self).exportLiteralChildren(outfile, level, name_)
        if self.data_center is not None:
            showIndent(outfile, level)
            outfile.write('data_center=model_.data_center(\n')
            self.data_center.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cluster is not None:
            showIndent(outfile, level)
            outfile.write('cluster=model_.cluster(\n')
            self.cluster.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ip is not None:
            showIndent(outfile, level)
            outfile.write('ip=model_.ip(\n')
            self.ip.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vlan is not None:
            showIndent(outfile, level)
            outfile.write('vlan=model_.vlan(\n')
            self.vlan.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.stp is not None:
            showIndent(outfile, level)
            outfile.write('stp=%s,\n' % self.stp)
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.display is not None:
            showIndent(outfile, level)
            outfile.write('display=%s,\n' % self.display)
        if self.mtu is not None:
            showIndent(outfile, level)
            outfile.write('mtu=%d,\n' % self.mtu)
        if self.usages is not None:
            showIndent(outfile, level)
            outfile.write('usages=model_.usages(\n')
            self.usages.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.required is not None:
            showIndent(outfile, level)
            outfile.write('required=%s,\n' % self.required)
        if self.profile_required is not None:
            showIndent(outfile, level)
            outfile.write('profile_required=%s,\n' % self.profile_required)
        if self.labels is not None:
            showIndent(outfile, level)
            outfile.write('labels=model_.labels(\n')
            self.labels.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Network, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'data_center':
            obj_ = DataCenter.factory()
            obj_.build(child_)
            self.data_center = obj_
        elif nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.cluster = obj_
        elif nodeName_ == 'ip':
            obj_ = IP.factory()
            obj_.build(child_)
            self.ip = obj_
        elif nodeName_ == 'vlan':
            obj_ = VLAN.factory()
            obj_.build(child_)
            self.vlan = obj_
        elif nodeName_ == 'stp':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'stp')
            self.stp = ival_
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.status = obj_
        elif nodeName_ == 'display':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'display')
            self.display = ival_
        elif nodeName_ == 'mtu':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'mtu')
            self.mtu = ival_
        elif nodeName_ == 'usages':
            obj_ = Usages.factory()
            obj_.build(child_)
            self.usages = obj_
        elif nodeName_ == 'required':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'required')
            self.required = ival_
        elif nodeName_ == 'profile_required':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'profile_required')
            self.profile_required = ival_
        elif nodeName_ == 'labels':
            obj_ = Labels.factory()
            obj_.build(child_)
            self.labels = obj_
        super(Network, self).buildChildren(child_, node, nodeName_, True)
# end class Network


class NetworkStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, network_state=None):
        if network_state is None:
            self.network_state = []
        else:
            self.network_state = network_state
    def factory(*args_, **kwargs_):
        if NetworkStates.subclass:
            return NetworkStates.subclass(*args_, **kwargs_)
        else:
            return NetworkStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_network_state(self): return self.network_state
    def set_network_state(self, network_state): self.network_state = network_state
    def add_network_state(self, value): self.network_state.append(value)
    def insert_network_state(self, index, value): self.network_state[index] = value
    def hasContent_(self):
        if (
            self.network_state
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NetworkStates', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkStates')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NetworkStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='NetworkStates', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for network_state_ in self.network_state:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snetwork_state>%s</%snetwork_state>%s' % (namespace_, self.gds_format_string(quote_xml(network_state_).encode(ExternalEncoding), input_name='network_state'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='NetworkStates'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('network_state=[\n')
        level += 1
        for network_state_ in self.network_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(network_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'network_state':
            network_state_ = child_.text
            network_state_ = self.gds_validate_string(network_state_, node, 'network_state')
            self.network_state.append(network_state_)
# end class NetworkStates


class Networks(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, network=None):
        super(Networks, self).__init__(actions, total, active, )
        if network is None:
            self.network = []
        else:
            self.network = network
    def factory(*args_, **kwargs_):
        if Networks.subclass:
            return Networks.subclass(*args_, **kwargs_)
        else:
            return Networks(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_network(self): return self.network
    def set_network(self, network): self.network = network
    def add_network(self, value): self.network.append(value)
    def insert_network(self, index, value): self.network[index] = value
    def hasContent_(self):
        if (
            self.network or
            super(Networks, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Networks', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Networks')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Networks'):
        super(Networks, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Networks')
    def exportChildren(self, outfile, level, namespace_='', name_='Networks', fromsubclass_=False, pretty_print=True):
        super(Networks, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for network_ in self.network:
            network_.export(outfile, level, namespace_, name_='network', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Networks'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Networks, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Networks, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('network=[\n')
        level += 1
        for network_ in self.network:
            showIndent(outfile, level)
            outfile.write('model_.network(\n')
            network_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Networks, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'network':
            obj_ = Network.factory()
            obj_.build(child_)
            self.network.append(obj_)
        super(Networks, self).buildChildren(child_, node, nodeName_, True)
# end class Networks


class Label(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, network=None, host_nic=None):
        super(Label, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.network = network
        self.host_nic = host_nic
    def factory(*args_, **kwargs_):
        if Label.subclass:
            return Label.subclass(*args_, **kwargs_)
        else:
            return Label(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_network(self): return self.network
    def set_network(self, network): self.network = network
    def get_host_nic(self): return self.host_nic
    def set_host_nic(self, host_nic): self.host_nic = host_nic
    def hasContent_(self):
        if (
            self.network is not None or
            self.host_nic is not None or
            super(Label, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Label', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Label')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Label'):
        super(Label, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Label')
    def exportChildren(self, outfile, level, namespace_='', name_='Label', fromsubclass_=False, pretty_print=True):
        super(Label, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.network is not None:
            self.network.export(outfile, level, namespace_, name_='network', pretty_print=pretty_print)
        if self.host_nic is not None:
            self.host_nic.export(outfile, level, namespace_, name_='host_nic', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Label'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Label, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Label, self).exportLiteralChildren(outfile, level, name_)
        if self.network is not None:
            showIndent(outfile, level)
            outfile.write('network=model_.network(\n')
            self.network.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.host_nic is not None:
            showIndent(outfile, level)
            outfile.write('host_nic=model_.host_nic(\n')
            self.host_nic.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Label, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'network':
            obj_ = Network.factory()
            obj_.build(child_)
            self.network = obj_
        elif nodeName_ == 'host_nic':
            obj_ = HostNIC.factory()
            obj_.build(child_)
            self.host_nic = obj_
        super(Label, self).buildChildren(child_, node, nodeName_, True)
# end class Label


class Labels(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, label=None):
        super(Labels, self).__init__(actions, total, active, )
        if label is None:
            self.label = []
        else:
            self.label = label
    def factory(*args_, **kwargs_):
        if Labels.subclass:
            return Labels.subclass(*args_, **kwargs_)
        else:
            return Labels(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_label(self): return self.label
    def set_label(self, label): self.label = label
    def add_label(self, value): self.label.append(value)
    def insert_label(self, index, value): self.label[index] = value
    def hasContent_(self):
        if (
            self.label or
            super(Labels, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Labels', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Labels')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Labels'):
        super(Labels, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Labels')
    def exportChildren(self, outfile, level, namespace_='', name_='Labels', fromsubclass_=False, pretty_print=True):
        super(Labels, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for label_ in self.label:
            label_.export(outfile, level, namespace_, name_='label', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Labels'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Labels, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Labels, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('label=[\n')
        level += 1
        for label_ in self.label:
            showIndent(outfile, level)
            outfile.write('model_.label(\n')
            label_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Labels, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'label':
            obj_ = Label.factory()
            obj_.build(child_)
            self.label.append(obj_)
        super(Labels, self).buildChildren(child_, node, nodeName_, True)
# end class Labels


class VnicProfile(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, network=None, port_mirroring=None, custom_properties=None):
        super(VnicProfile, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.network = network
        self.port_mirroring = port_mirroring
        self.custom_properties = custom_properties
    def factory(*args_, **kwargs_):
        if VnicProfile.subclass:
            return VnicProfile.subclass(*args_, **kwargs_)
        else:
            return VnicProfile(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_network(self): return self.network
    def set_network(self, network): self.network = network
    def get_port_mirroring(self): return self.port_mirroring
    def set_port_mirroring(self, port_mirroring): self.port_mirroring = port_mirroring
    def get_custom_properties(self): return self.custom_properties
    def set_custom_properties(self, custom_properties): self.custom_properties = custom_properties
    def hasContent_(self):
        if (
            self.network is not None or
            self.port_mirroring is not None or
            self.custom_properties is not None or
            super(VnicProfile, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VnicProfile', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VnicProfile')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VnicProfile'):
        super(VnicProfile, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VnicProfile')
    def exportChildren(self, outfile, level, namespace_='', name_='VnicProfile', fromsubclass_=False, pretty_print=True):
        super(VnicProfile, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.network is not None:
            self.network.export(outfile, level, namespace_, name_='network', pretty_print=pretty_print)
        if self.port_mirroring is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sport_mirroring>%s</%sport_mirroring>%s' % (namespace_, self.gds_format_boolean(self.port_mirroring, input_name='port_mirroring'), namespace_, eol_))
        if self.custom_properties is not None:
            self.custom_properties.export(outfile, level, namespace_, name_='custom_properties', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VnicProfile'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(VnicProfile, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VnicProfile, self).exportLiteralChildren(outfile, level, name_)
        if self.network is not None:
            showIndent(outfile, level)
            outfile.write('network=model_.network(\n')
            self.network.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.port_mirroring is not None:
            showIndent(outfile, level)
            outfile.write('port_mirroring=%s,\n' % self.port_mirroring)
        if self.custom_properties is not None:
            showIndent(outfile, level)
            outfile.write('custom_properties=model_.custom_properties(\n')
            self.custom_properties.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(VnicProfile, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'network':
            obj_ = Network.factory()
            obj_.build(child_)
            self.network = obj_
        elif nodeName_ == 'port_mirroring':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'port_mirroring')
            self.port_mirroring = ival_
        elif nodeName_ == 'custom_properties':
            obj_ = CustomProperties.factory()
            obj_.build(child_)
            self.custom_properties = obj_
        super(VnicProfile, self).buildChildren(child_, node, nodeName_, True)
# end class VnicProfile


class VnicProfiles(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, vnic_profile=None):
        super(VnicProfiles, self).__init__(actions, total, active, )
        if vnic_profile is None:
            self.vnic_profile = []
        else:
            self.vnic_profile = vnic_profile
    def factory(*args_, **kwargs_):
        if VnicProfiles.subclass:
            return VnicProfiles.subclass(*args_, **kwargs_)
        else:
            return VnicProfiles(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vnic_profile(self): return self.vnic_profile
    def set_vnic_profile(self, vnic_profile): self.vnic_profile = vnic_profile
    def add_vnic_profile(self, value): self.vnic_profile.append(value)
    def insert_vnic_profile(self, index, value): self.vnic_profile[index] = value
    def hasContent_(self):
        if (
            self.vnic_profile or
            super(VnicProfiles, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VnicProfiles', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VnicProfiles')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VnicProfiles'):
        super(VnicProfiles, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VnicProfiles')
    def exportChildren(self, outfile, level, namespace_='', name_='VnicProfiles', fromsubclass_=False, pretty_print=True):
        super(VnicProfiles, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for vnic_profile_ in self.vnic_profile:
            vnic_profile_.export(outfile, level, namespace_, name_='vnic_profile', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VnicProfiles'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(VnicProfiles, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VnicProfiles, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('vnic_profile=[\n')
        level += 1
        for vnic_profile_ in self.vnic_profile:
            showIndent(outfile, level)
            outfile.write('model_.vnic_profile(\n')
            vnic_profile_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(VnicProfiles, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vnic_profile':
            obj_ = VnicProfile.factory()
            obj_.build(child_)
            self.vnic_profile.append(obj_)
        super(VnicProfiles, self).buildChildren(child_, node, nodeName_, True)
# end class VnicProfiles


class LogicalUnit(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, port=None, target=None, username=None, password=None, portal=None, address=None, serial=None, vendor_id=None, product_id=None, lun_mapping=None, size=None, paths=None, status=None, volume_group_id=None, storage_domain_id=None, disk_id=None):
        self.id = _cast(None, id)
        self.port = port
        self.target = target
        self.username = username
        self.password = password
        self.portal = portal
        self.address = address
        self.serial = serial
        self.vendor_id = vendor_id
        self.product_id = product_id
        self.lun_mapping = lun_mapping
        self.size = size
        self.paths = paths
        self.status = status
        self.volume_group_id = volume_group_id
        self.storage_domain_id = storage_domain_id
        self.disk_id = disk_id
    def factory(*args_, **kwargs_):
        if LogicalUnit.subclass:
            return LogicalUnit.subclass(*args_, **kwargs_)
        else:
            return LogicalUnit(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_port(self): return self.port
    def set_port(self, port): self.port = port
    def get_target(self): return self.target
    def set_target(self, target): self.target = target
    def get_username(self): return self.username
    def set_username(self, username): self.username = username
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_portal(self): return self.portal
    def set_portal(self, portal): self.portal = portal
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_serial(self): return self.serial
    def set_serial(self, serial): self.serial = serial
    def get_vendor_id(self): return self.vendor_id
    def set_vendor_id(self, vendor_id): self.vendor_id = vendor_id
    def get_product_id(self): return self.product_id
    def set_product_id(self, product_id): self.product_id = product_id
    def get_lun_mapping(self): return self.lun_mapping
    def set_lun_mapping(self, lun_mapping): self.lun_mapping = lun_mapping
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def get_paths(self): return self.paths
    def set_paths(self, paths): self.paths = paths
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_volume_group_id(self): return self.volume_group_id
    def set_volume_group_id(self, volume_group_id): self.volume_group_id = volume_group_id
    def get_storage_domain_id(self): return self.storage_domain_id
    def set_storage_domain_id(self, storage_domain_id): self.storage_domain_id = storage_domain_id
    def get_disk_id(self): return self.disk_id
    def set_disk_id(self, disk_id): self.disk_id = disk_id
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def hasContent_(self):
        if (
            self.port is not None or
            self.target is not None or
            self.username is not None or
            self.password is not None or
            self.portal is not None or
            self.address is not None or
            self.serial is not None or
            self.vendor_id is not None or
            self.product_id is not None or
            self.lun_mapping is not None or
            self.size is not None or
            self.paths is not None or
            self.status is not None or
            self.volume_group_id is not None or
            self.storage_domain_id is not None or
            self.disk_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LogicalUnit', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LogicalUnit')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LogicalUnit'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='LogicalUnit', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.port is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sport>%s</%sport>%s' % (namespace_, self.gds_format_integer(self.port, input_name='port'), namespace_, eol_))
        if self.target is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%starget>%s</%starget>%s' % (namespace_, self.gds_format_string(quote_xml(self.target).encode(ExternalEncoding), input_name='target'), namespace_, eol_))
        if self.username is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%susername>%s</%susername>%s' % (namespace_, self.gds_format_string(quote_xml(self.username).encode(ExternalEncoding), input_name='username'), namespace_, eol_))
        if self.password is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespace_, self.gds_format_string(quote_xml(self.password).encode(ExternalEncoding), input_name='password'), namespace_, eol_))
        if self.portal is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sportal>%s</%sportal>%s' % (namespace_, self.gds_format_string(quote_xml(self.portal).encode(ExternalEncoding), input_name='portal'), namespace_, eol_))
        if self.address is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress>%s</%saddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_, eol_))
        if self.serial is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sserial>%s</%sserial>%s' % (namespace_, self.gds_format_string(quote_xml(self.serial).encode(ExternalEncoding), input_name='serial'), namespace_, eol_))
        if self.vendor_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svendor_id>%s</%svendor_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.vendor_id).encode(ExternalEncoding), input_name='vendor_id'), namespace_, eol_))
        if self.product_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sproduct_id>%s</%sproduct_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.product_id).encode(ExternalEncoding), input_name='product_id'), namespace_, eol_))
        if self.lun_mapping is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slun_mapping>%s</%slun_mapping>%s' % (namespace_, self.gds_format_integer(self.lun_mapping, input_name='lun_mapping'), namespace_, eol_))
        if self.size is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssize>%s</%ssize>%s' % (namespace_, self.gds_format_integer(self.size, input_name='size'), namespace_, eol_))
        if self.paths is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spaths>%s</%spaths>%s' % (namespace_, self.gds_format_integer(self.paths, input_name='paths'), namespace_, eol_))
        if self.status is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstatus>%s</%sstatus>%s' % (namespace_, self.gds_format_string(quote_xml(self.status).encode(ExternalEncoding), input_name='status'), namespace_, eol_))
        if self.volume_group_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svolume_group_id>%s</%svolume_group_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.volume_group_id).encode(ExternalEncoding), input_name='volume_group_id'), namespace_, eol_))
        if self.storage_domain_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstorage_domain_id>%s</%sstorage_domain_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.storage_domain_id).encode(ExternalEncoding), input_name='storage_domain_id'), namespace_, eol_))
        if self.disk_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisk_id>%s</%sdisk_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.disk_id).encode(ExternalEncoding), input_name='disk_id'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='LogicalUnit'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('port=%d,\n' % self.port)
        if self.target is not None:
            showIndent(outfile, level)
            outfile.write('target=%s,\n' % quote_python(self.target).encode(ExternalEncoding))
        if self.username is not None:
            showIndent(outfile, level)
            outfile.write('username=%s,\n' % quote_python(self.username).encode(ExternalEncoding))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % quote_python(self.password).encode(ExternalEncoding))
        if self.portal is not None:
            showIndent(outfile, level)
            outfile.write('portal=%s,\n' % quote_python(self.portal).encode(ExternalEncoding))
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.serial is not None:
            showIndent(outfile, level)
            outfile.write('serial=%s,\n' % quote_python(self.serial).encode(ExternalEncoding))
        if self.vendor_id is not None:
            showIndent(outfile, level)
            outfile.write('vendor_id=%s,\n' % quote_python(self.vendor_id).encode(ExternalEncoding))
        if self.product_id is not None:
            showIndent(outfile, level)
            outfile.write('product_id=%s,\n' % quote_python(self.product_id).encode(ExternalEncoding))
        if self.lun_mapping is not None:
            showIndent(outfile, level)
            outfile.write('lun_mapping=%d,\n' % self.lun_mapping)
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % self.size)
        if self.paths is not None:
            showIndent(outfile, level)
            outfile.write('paths=%d,\n' % self.paths)
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=%s,\n' % quote_python(self.status).encode(ExternalEncoding))
        if self.volume_group_id is not None:
            showIndent(outfile, level)
            outfile.write('volume_group_id=%s,\n' % quote_python(self.volume_group_id).encode(ExternalEncoding))
        if self.storage_domain_id is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain_id=%s,\n' % quote_python(self.storage_domain_id).encode(ExternalEncoding))
        if self.disk_id is not None:
            showIndent(outfile, level)
            outfile.write('disk_id=%s,\n' % quote_python(self.disk_id).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'port')
            self.port = ival_
        elif nodeName_ == 'target':
            target_ = child_.text
            target_ = self.gds_validate_string(target_, node, 'target')
            self.target = target_
        elif nodeName_ == 'username':
            username_ = child_.text
            username_ = self.gds_validate_string(username_, node, 'username')
            self.username = username_
        elif nodeName_ == 'password':
            password_ = child_.text
            password_ = self.gds_validate_string(password_, node, 'password')
            self.password = password_
        elif nodeName_ == 'portal':
            portal_ = child_.text
            portal_ = self.gds_validate_string(portal_, node, 'portal')
            self.portal = portal_
        elif nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'serial':
            serial_ = child_.text
            serial_ = self.gds_validate_string(serial_, node, 'serial')
            self.serial = serial_
        elif nodeName_ == 'vendor_id':
            vendor_id_ = child_.text
            vendor_id_ = self.gds_validate_string(vendor_id_, node, 'vendor_id')
            self.vendor_id = vendor_id_
        elif nodeName_ == 'product_id':
            product_id_ = child_.text
            product_id_ = self.gds_validate_string(product_id_, node, 'product_id')
            self.product_id = product_id_
        elif nodeName_ == 'lun_mapping':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'lun_mapping')
            self.lun_mapping = ival_
        elif nodeName_ == 'size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'size')
            self.size = ival_
        elif nodeName_ == 'paths':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'paths')
            self.paths = ival_
        elif nodeName_ == 'status':
            status_ = child_.text
            status_ = self.gds_validate_string(status_, node, 'status')
            self.status = status_
        elif nodeName_ == 'volume_group_id':
            volume_group_id_ = child_.text
            volume_group_id_ = self.gds_validate_string(volume_group_id_, node, 'volume_group_id')
            self.volume_group_id = volume_group_id_
        elif nodeName_ == 'storage_domain_id':
            storage_domain_id_ = child_.text
            storage_domain_id_ = self.gds_validate_string(storage_domain_id_, node, 'storage_domain_id')
            self.storage_domain_id = storage_domain_id_
        elif nodeName_ == 'disk_id':
            disk_id_ = child_.text
            disk_id_ = self.gds_validate_string(disk_id_, node, 'disk_id')
            self.disk_id = disk_id_
# end class LogicalUnit


class VolumeGroup(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None, logical_unit=None):
        self.id = _cast(None, id)
        self.name = name
        if logical_unit is None:
            self.logical_unit = []
        else:
            self.logical_unit = logical_unit
    def factory(*args_, **kwargs_):
        if VolumeGroup.subclass:
            return VolumeGroup.subclass(*args_, **kwargs_)
        else:
            return VolumeGroup(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_logical_unit(self): return self.logical_unit
    def set_logical_unit(self, logical_unit): self.logical_unit = logical_unit
    def add_logical_unit(self, value): self.logical_unit.append(value)
    def insert_logical_unit(self, index, value): self.logical_unit[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def hasContent_(self):
        if (
            self.name is not None or
            self.logical_unit
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VolumeGroup', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VolumeGroup')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VolumeGroup'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='VolumeGroup', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_, eol_))
        for logical_unit_ in self.logical_unit:
            logical_unit_.export(outfile, level, namespace_, name_='logical_unit', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VolumeGroup'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('logical_unit=[\n')
        level += 1
        for logical_unit_ in self.logical_unit:
            showIndent(outfile, level)
            outfile.write('model_.logical_unit(\n')
            logical_unit_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'logical_unit':
            obj_ = LogicalUnit.factory()
            obj_.build(child_)
            self.logical_unit.append(obj_)
# end class VolumeGroup


class Storage(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, address=None, type_=None, path=None, mount_options=None, vfs_type=None, nfs_version=None, nfs_timeo=None, nfs_retrans=None, logical_unit=None, volume_group=None, override_luns=None, port=None, target=None, username=None, password=None, portal=None, host=None):
        super(Storage, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.address = address
        self.type_ = type_
        self.path = path
        self.mount_options = mount_options
        self.vfs_type = vfs_type
        self.nfs_version = nfs_version
        self.nfs_timeo = nfs_timeo
        self.nfs_retrans = nfs_retrans
        if logical_unit is None:
            self.logical_unit = []
        else:
            self.logical_unit = logical_unit
        self.volume_group = volume_group
        self.override_luns = override_luns
        self.port = port
        self.target = target
        self.username = username
        self.password = password
        self.portal = portal
        self.host = host
    def factory(*args_, **kwargs_):
        if Storage.subclass:
            return Storage.subclass(*args_, **kwargs_)
        else:
            return Storage(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_path(self): return self.path
    def set_path(self, path): self.path = path
    def get_mount_options(self): return self.mount_options
    def set_mount_options(self, mount_options): self.mount_options = mount_options
    def get_vfs_type(self): return self.vfs_type
    def set_vfs_type(self, vfs_type): self.vfs_type = vfs_type
    def get_nfs_version(self): return self.nfs_version
    def set_nfs_version(self, nfs_version): self.nfs_version = nfs_version
    def get_nfs_timeo(self): return self.nfs_timeo
    def set_nfs_timeo(self, nfs_timeo): self.nfs_timeo = nfs_timeo
    def get_nfs_retrans(self): return self.nfs_retrans
    def set_nfs_retrans(self, nfs_retrans): self.nfs_retrans = nfs_retrans
    def get_logical_unit(self): return self.logical_unit
    def set_logical_unit(self, logical_unit): self.logical_unit = logical_unit
    def add_logical_unit(self, value): self.logical_unit.append(value)
    def insert_logical_unit(self, index, value): self.logical_unit[index] = value
    def get_volume_group(self): return self.volume_group
    def set_volume_group(self, volume_group): self.volume_group = volume_group
    def get_override_luns(self): return self.override_luns
    def set_override_luns(self, override_luns): self.override_luns = override_luns
    def get_port(self): return self.port
    def set_port(self, port): self.port = port
    def get_target(self): return self.target
    def set_target(self, target): self.target = target
    def get_username(self): return self.username
    def set_username(self, username): self.username = username
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_portal(self): return self.portal
    def set_portal(self, portal): self.portal = portal
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def hasContent_(self):
        if (
            self.address is not None or
            self.type_ is not None or
            self.path is not None or
            self.mount_options is not None or
            self.vfs_type is not None or
            self.nfs_version is not None or
            self.nfs_timeo is not None or
            self.nfs_retrans is not None or
            self.logical_unit or
            self.volume_group is not None or
            self.override_luns is not None or
            self.port is not None or
            self.target is not None or
            self.username is not None or
            self.password is not None or
            self.portal is not None or
            self.host is not None or
            super(Storage, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Storage', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Storage')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Storage'):
        super(Storage, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Storage')
    def exportChildren(self, outfile, level, namespace_='', name_='Storage', fromsubclass_=False, pretty_print=True):
        super(Storage, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.address is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress>%s</%saddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_, eol_))
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.path is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spath>%s</%spath>%s' % (namespace_, self.gds_format_string(quote_xml(self.path).encode(ExternalEncoding), input_name='path'), namespace_, eol_))
        if self.mount_options is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smount_options>%s</%smount_options>%s' % (namespace_, self.gds_format_string(quote_xml(self.mount_options).encode(ExternalEncoding), input_name='mount_options'), namespace_, eol_))
        if self.vfs_type is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svfs_type>%s</%svfs_type>%s' % (namespace_, self.gds_format_string(quote_xml(self.vfs_type).encode(ExternalEncoding), input_name='vfs_type'), namespace_, eol_))
        if self.nfs_version is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snfs_version>%s</%snfs_version>%s' % (namespace_, self.gds_format_string(quote_xml(self.nfs_version).encode(ExternalEncoding), input_name='nfs_version'), namespace_, eol_))
        if self.nfs_timeo is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snfs_timeo>%s</%snfs_timeo>%s' % (namespace_, self.gds_format_integer(self.nfs_timeo, input_name='nfs_timeo'), namespace_, eol_))
        if self.nfs_retrans is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snfs_retrans>%s</%snfs_retrans>%s' % (namespace_, self.gds_format_integer(self.nfs_retrans, input_name='nfs_retrans'), namespace_, eol_))
        for logical_unit_ in self.logical_unit:
            logical_unit_.export(outfile, level, namespace_, name_='logical_unit', pretty_print=pretty_print)
        if self.volume_group is not None:
            self.volume_group.export(outfile, level, namespace_, name_='volume_group', pretty_print=pretty_print)
        if self.override_luns is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soverride_luns>%s</%soverride_luns>%s' % (namespace_, self.gds_format_boolean(self.override_luns, input_name='override_luns'), namespace_, eol_))
        if self.port is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sport>%s</%sport>%s' % (namespace_, self.gds_format_integer(self.port, input_name='port'), namespace_, eol_))
        if self.target is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%starget>%s</%starget>%s' % (namespace_, self.gds_format_string(quote_xml(self.target).encode(ExternalEncoding), input_name='target'), namespace_, eol_))
        if self.username is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%susername>%s</%susername>%s' % (namespace_, self.gds_format_string(quote_xml(self.username).encode(ExternalEncoding), input_name='username'), namespace_, eol_))
        if self.password is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespace_, self.gds_format_string(quote_xml(self.password).encode(ExternalEncoding), input_name='password'), namespace_, eol_))
        if self.portal is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sportal>%s</%sportal>%s' % (namespace_, self.gds_format_string(quote_xml(self.portal).encode(ExternalEncoding), input_name='portal'), namespace_, eol_))
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Storage'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Storage, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Storage, self).exportLiteralChildren(outfile, level, name_)
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.path is not None:
            showIndent(outfile, level)
            outfile.write('path=%s,\n' % quote_python(self.path).encode(ExternalEncoding))
        if self.mount_options is not None:
            showIndent(outfile, level)
            outfile.write('mount_options=%s,\n' % quote_python(self.mount_options).encode(ExternalEncoding))
        if self.vfs_type is not None:
            showIndent(outfile, level)
            outfile.write('vfs_type=%s,\n' % quote_python(self.vfs_type).encode(ExternalEncoding))
        if self.nfs_version is not None:
            showIndent(outfile, level)
            outfile.write('nfs_version=%s,\n' % quote_python(self.nfs_version).encode(ExternalEncoding))
        if self.nfs_timeo is not None:
            showIndent(outfile, level)
            outfile.write('nfs_timeo=%d,\n' % self.nfs_timeo)
        if self.nfs_retrans is not None:
            showIndent(outfile, level)
            outfile.write('nfs_retrans=%d,\n' % self.nfs_retrans)
        showIndent(outfile, level)
        outfile.write('logical_unit=[\n')
        level += 1
        for logical_unit_ in self.logical_unit:
            showIndent(outfile, level)
            outfile.write('model_.logical_unit(\n')
            logical_unit_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.volume_group is not None:
            showIndent(outfile, level)
            outfile.write('volume_group=model_.volume_group(\n')
            self.volume_group.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.override_luns is not None:
            showIndent(outfile, level)
            outfile.write('override_luns=%s,\n' % self.override_luns)
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('port=%d,\n' % self.port)
        if self.target is not None:
            showIndent(outfile, level)
            outfile.write('target=%s,\n' % quote_python(self.target).encode(ExternalEncoding))
        if self.username is not None:
            showIndent(outfile, level)
            outfile.write('username=%s,\n' % quote_python(self.username).encode(ExternalEncoding))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % quote_python(self.password).encode(ExternalEncoding))
        if self.portal is not None:
            showIndent(outfile, level)
            outfile.write('portal=%s,\n' % quote_python(self.portal).encode(ExternalEncoding))
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Storage, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'path':
            path_ = child_.text
            path_ = self.gds_validate_string(path_, node, 'path')
            self.path = path_
        elif nodeName_ == 'mount_options':
            mount_options_ = child_.text
            mount_options_ = self.gds_validate_string(mount_options_, node, 'mount_options')
            self.mount_options = mount_options_
        elif nodeName_ == 'vfs_type':
            vfs_type_ = child_.text
            vfs_type_ = self.gds_validate_string(vfs_type_, node, 'vfs_type')
            self.vfs_type = vfs_type_
        elif nodeName_ == 'nfs_version':
            nfs_version_ = child_.text
            nfs_version_ = self.gds_validate_string(nfs_version_, node, 'nfs_version')
            self.nfs_version = nfs_version_
        elif nodeName_ == 'nfs_timeo':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'nfs_timeo')
            self.nfs_timeo = ival_
        elif nodeName_ == 'nfs_retrans':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'nfs_retrans')
            self.nfs_retrans = ival_
        elif nodeName_ == 'logical_unit':
            obj_ = LogicalUnit.factory()
            obj_.build(child_)
            self.logical_unit.append(obj_)
        elif nodeName_ == 'volume_group':
            obj_ = VolumeGroup.factory()
            obj_.build(child_)
            self.volume_group = obj_
        elif nodeName_ == 'override_luns':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'override_luns')
            self.override_luns = ival_
        elif nodeName_ == 'port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'port')
            self.port = ival_
        elif nodeName_ == 'target':
            target_ = child_.text
            target_ = self.gds_validate_string(target_, node, 'target')
            self.target = target_
        elif nodeName_ == 'username':
            username_ = child_.text
            username_ = self.gds_validate_string(username_, node, 'username')
            self.username = username_
        elif nodeName_ == 'password':
            password_ = child_.text
            password_ = self.gds_validate_string(password_, node, 'password')
            self.password = password_
        elif nodeName_ == 'portal':
            portal_ = child_.text
            portal_ = self.gds_validate_string(portal_, node, 'portal')
            self.portal = portal_
        elif nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.host = obj_
        super(Storage, self).buildChildren(child_, node, nodeName_, True)
# end class Storage


class StorageConnection(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, address=None, type_=None, path=None, mount_options=None, vfs_type=None, nfs_version=None, nfs_timeo=None, nfs_retrans=None, port=None, target=None, username=None, password=None, portal=None, host=None):
        super(StorageConnection, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.address = address
        self.type_ = type_
        self.path = path
        self.mount_options = mount_options
        self.vfs_type = vfs_type
        self.nfs_version = nfs_version
        self.nfs_timeo = nfs_timeo
        self.nfs_retrans = nfs_retrans
        self.port = port
        self.target = target
        self.username = username
        self.password = password
        self.portal = portal
        self.host = host
    def factory(*args_, **kwargs_):
        if StorageConnection.subclass:
            return StorageConnection.subclass(*args_, **kwargs_)
        else:
            return StorageConnection(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_path(self): return self.path
    def set_path(self, path): self.path = path
    def get_mount_options(self): return self.mount_options
    def set_mount_options(self, mount_options): self.mount_options = mount_options
    def get_vfs_type(self): return self.vfs_type
    def set_vfs_type(self, vfs_type): self.vfs_type = vfs_type
    def get_nfs_version(self): return self.nfs_version
    def set_nfs_version(self, nfs_version): self.nfs_version = nfs_version
    def get_nfs_timeo(self): return self.nfs_timeo
    def set_nfs_timeo(self, nfs_timeo): self.nfs_timeo = nfs_timeo
    def get_nfs_retrans(self): return self.nfs_retrans
    def set_nfs_retrans(self, nfs_retrans): self.nfs_retrans = nfs_retrans
    def get_port(self): return self.port
    def set_port(self, port): self.port = port
    def get_target(self): return self.target
    def set_target(self, target): self.target = target
    def get_username(self): return self.username
    def set_username(self, username): self.username = username
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_portal(self): return self.portal
    def set_portal(self, portal): self.portal = portal
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def hasContent_(self):
        if (
            self.address is not None or
            self.type_ is not None or
            self.path is not None or
            self.mount_options is not None or
            self.vfs_type is not None or
            self.nfs_version is not None or
            self.nfs_timeo is not None or
            self.nfs_retrans is not None or
            self.port is not None or
            self.target is not None or
            self.username is not None or
            self.password is not None or
            self.portal is not None or
            self.host is not None or
            super(StorageConnection, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StorageConnection', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageConnection')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageConnection'):
        super(StorageConnection, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StorageConnection')
    def exportChildren(self, outfile, level, namespace_='', name_='StorageConnection', fromsubclass_=False, pretty_print=True):
        super(StorageConnection, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.address is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress>%s</%saddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_, eol_))
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.path is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spath>%s</%spath>%s' % (namespace_, self.gds_format_string(quote_xml(self.path).encode(ExternalEncoding), input_name='path'), namespace_, eol_))
        if self.mount_options is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smount_options>%s</%smount_options>%s' % (namespace_, self.gds_format_string(quote_xml(self.mount_options).encode(ExternalEncoding), input_name='mount_options'), namespace_, eol_))
        if self.vfs_type is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svfs_type>%s</%svfs_type>%s' % (namespace_, self.gds_format_string(quote_xml(self.vfs_type).encode(ExternalEncoding), input_name='vfs_type'), namespace_, eol_))
        if self.nfs_version is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snfs_version>%s</%snfs_version>%s' % (namespace_, self.gds_format_string(quote_xml(self.nfs_version).encode(ExternalEncoding), input_name='nfs_version'), namespace_, eol_))
        if self.nfs_timeo is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snfs_timeo>%s</%snfs_timeo>%s' % (namespace_, self.gds_format_integer(self.nfs_timeo, input_name='nfs_timeo'), namespace_, eol_))
        if self.nfs_retrans is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snfs_retrans>%s</%snfs_retrans>%s' % (namespace_, self.gds_format_integer(self.nfs_retrans, input_name='nfs_retrans'), namespace_, eol_))
        if self.port is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sport>%s</%sport>%s' % (namespace_, self.gds_format_integer(self.port, input_name='port'), namespace_, eol_))
        if self.target is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%starget>%s</%starget>%s' % (namespace_, self.gds_format_string(quote_xml(self.target).encode(ExternalEncoding), input_name='target'), namespace_, eol_))
        if self.username is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%susername>%s</%susername>%s' % (namespace_, self.gds_format_string(quote_xml(self.username).encode(ExternalEncoding), input_name='username'), namespace_, eol_))
        if self.password is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespace_, self.gds_format_string(quote_xml(self.password).encode(ExternalEncoding), input_name='password'), namespace_, eol_))
        if self.portal is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sportal>%s</%sportal>%s' % (namespace_, self.gds_format_string(quote_xml(self.portal).encode(ExternalEncoding), input_name='portal'), namespace_, eol_))
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='StorageConnection'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(StorageConnection, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StorageConnection, self).exportLiteralChildren(outfile, level, name_)
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.path is not None:
            showIndent(outfile, level)
            outfile.write('path=%s,\n' % quote_python(self.path).encode(ExternalEncoding))
        if self.mount_options is not None:
            showIndent(outfile, level)
            outfile.write('mount_options=%s,\n' % quote_python(self.mount_options).encode(ExternalEncoding))
        if self.vfs_type is not None:
            showIndent(outfile, level)
            outfile.write('vfs_type=%s,\n' % quote_python(self.vfs_type).encode(ExternalEncoding))
        if self.nfs_version is not None:
            showIndent(outfile, level)
            outfile.write('nfs_version=%s,\n' % quote_python(self.nfs_version).encode(ExternalEncoding))
        if self.nfs_timeo is not None:
            showIndent(outfile, level)
            outfile.write('nfs_timeo=%d,\n' % self.nfs_timeo)
        if self.nfs_retrans is not None:
            showIndent(outfile, level)
            outfile.write('nfs_retrans=%d,\n' % self.nfs_retrans)
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('port=%d,\n' % self.port)
        if self.target is not None:
            showIndent(outfile, level)
            outfile.write('target=%s,\n' % quote_python(self.target).encode(ExternalEncoding))
        if self.username is not None:
            showIndent(outfile, level)
            outfile.write('username=%s,\n' % quote_python(self.username).encode(ExternalEncoding))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % quote_python(self.password).encode(ExternalEncoding))
        if self.portal is not None:
            showIndent(outfile, level)
            outfile.write('portal=%s,\n' % quote_python(self.portal).encode(ExternalEncoding))
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(StorageConnection, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'path':
            path_ = child_.text
            path_ = self.gds_validate_string(path_, node, 'path')
            self.path = path_
        elif nodeName_ == 'mount_options':
            mount_options_ = child_.text
            mount_options_ = self.gds_validate_string(mount_options_, node, 'mount_options')
            self.mount_options = mount_options_
        elif nodeName_ == 'vfs_type':
            vfs_type_ = child_.text
            vfs_type_ = self.gds_validate_string(vfs_type_, node, 'vfs_type')
            self.vfs_type = vfs_type_
        elif nodeName_ == 'nfs_version':
            nfs_version_ = child_.text
            nfs_version_ = self.gds_validate_string(nfs_version_, node, 'nfs_version')
            self.nfs_version = nfs_version_
        elif nodeName_ == 'nfs_timeo':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'nfs_timeo')
            self.nfs_timeo = ival_
        elif nodeName_ == 'nfs_retrans':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'nfs_retrans')
            self.nfs_retrans = ival_
        elif nodeName_ == 'port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'port')
            self.port = ival_
        elif nodeName_ == 'target':
            target_ = child_.text
            target_ = self.gds_validate_string(target_, node, 'target')
            self.target = target_
        elif nodeName_ == 'username':
            username_ = child_.text
            username_ = self.gds_validate_string(username_, node, 'username')
            self.username = username_
        elif nodeName_ == 'password':
            password_ = child_.text
            password_ = self.gds_validate_string(password_, node, 'password')
            self.password = password_
        elif nodeName_ == 'portal':
            portal_ = child_.text
            portal_ = self.gds_validate_string(portal_, node, 'portal')
            self.portal = portal_
        elif nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.host = obj_
        super(StorageConnection, self).buildChildren(child_, node, nodeName_, True)
# end class StorageConnection


class StorageDomain(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, data_center=None, type_=None, status=None, master=None, storage=None, host=None, format=None, destroy=None, available=None, used=None, committed=None, storage_format=None):
        super(StorageDomain, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.data_center = data_center
        self.type_ = type_
        self.status = status
        self.master = master
        self.storage = storage
        self.host = host
        self.format = format
        self.destroy = destroy
        self.available = available
        self.used = used
        self.committed = committed
        self.storage_format = storage_format
    def factory(*args_, **kwargs_):
        if StorageDomain.subclass:
            return StorageDomain.subclass(*args_, **kwargs_)
        else:
            return StorageDomain(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_data_center(self): return self.data_center
    def set_data_center(self, data_center): self.data_center = data_center
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_master(self): return self.master
    def set_master(self, master): self.master = master
    def get_storage(self): return self.storage
    def set_storage(self, storage): self.storage = storage
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_destroy(self): return self.destroy
    def set_destroy(self, destroy): self.destroy = destroy
    def get_available(self): return self.available
    def set_available(self, available): self.available = available
    def get_used(self): return self.used
    def set_used(self, used): self.used = used
    def get_committed(self): return self.committed
    def set_committed(self, committed): self.committed = committed
    def get_storage_format(self): return self.storage_format
    def set_storage_format(self, storage_format): self.storage_format = storage_format
    def hasContent_(self):
        if (
            self.data_center is not None or
            self.type_ is not None or
            self.status is not None or
            self.master is not None or
            self.storage is not None or
            self.host is not None or
            self.format is not None or
            self.destroy is not None or
            self.available is not None or
            self.used is not None or
            self.committed is not None or
            self.storage_format is not None or
            super(StorageDomain, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StorageDomain', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageDomain')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageDomain'):
        super(StorageDomain, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StorageDomain')
    def exportChildren(self, outfile, level, namespace_='', name_='StorageDomain', fromsubclass_=False, pretty_print=True):
        super(StorageDomain, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.data_center is not None:
            self.data_center.export(outfile, level, namespace_, name_='data_center', pretty_print=pretty_print)
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status', pretty_print=pretty_print)
        if self.master is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smaster>%s</%smaster>%s' % (namespace_, self.gds_format_boolean(self.master, input_name='master'), namespace_, eol_))
        if self.storage is not None:
            self.storage.export(outfile, level, namespace_, name_='storage', pretty_print=pretty_print)
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host', pretty_print=pretty_print)
        if self.format is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sformat>%s</%sformat>%s' % (namespace_, self.gds_format_boolean(self.format, input_name='format'), namespace_, eol_))
        if self.destroy is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdestroy>%s</%sdestroy>%s' % (namespace_, self.gds_format_boolean(self.destroy, input_name='destroy'), namespace_, eol_))
        if self.available is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%savailable>%s</%savailable>%s' % (namespace_, self.gds_format_integer(self.available, input_name='available'), namespace_, eol_))
        if self.used is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sused>%s</%sused>%s' % (namespace_, self.gds_format_integer(self.used, input_name='used'), namespace_, eol_))
        if self.committed is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scommitted>%s</%scommitted>%s' % (namespace_, self.gds_format_integer(self.committed, input_name='committed'), namespace_, eol_))
        if self.storage_format is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstorage_format>%s</%sstorage_format>%s' % (namespace_, self.gds_format_string(quote_xml(self.storage_format).encode(ExternalEncoding), input_name='storage_format'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='StorageDomain'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(StorageDomain, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StorageDomain, self).exportLiteralChildren(outfile, level, name_)
        if self.data_center is not None:
            showIndent(outfile, level)
            outfile.write('data_center=model_.data_center(\n')
            self.data_center.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.master is not None:
            showIndent(outfile, level)
            outfile.write('master=%s,\n' % self.master)
        if self.storage is not None:
            showIndent(outfile, level)
            outfile.write('storage=model_.storage(\n')
            self.storage.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.format is not None:
            showIndent(outfile, level)
            outfile.write('format=%s,\n' % self.format)
        if self.destroy is not None:
            showIndent(outfile, level)
            outfile.write('destroy=%s,\n' % self.destroy)
        if self.available is not None:
            showIndent(outfile, level)
            outfile.write('available=%d,\n' % self.available)
        if self.used is not None:
            showIndent(outfile, level)
            outfile.write('used=%d,\n' % self.used)
        if self.committed is not None:
            showIndent(outfile, level)
            outfile.write('committed=%d,\n' % self.committed)
        if self.storage_format is not None:
            showIndent(outfile, level)
            outfile.write('storage_format=%s,\n' % quote_python(self.storage_format).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(StorageDomain, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'data_center':
            obj_ = DataCenter.factory()
            obj_.build(child_)
            self.data_center = obj_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.status = obj_
        elif nodeName_ == 'master':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'master')
            self.master = ival_
        elif nodeName_ == 'storage':
            obj_ = Storage.factory()
            obj_.build(child_)
            self.storage = obj_
        elif nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.host = obj_
        elif nodeName_ == 'format':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'format')
            self.format = ival_
        elif nodeName_ == 'destroy':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'destroy')
            self.destroy = ival_
        elif nodeName_ == 'available':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'available')
            self.available = ival_
        elif nodeName_ == 'used':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'used')
            self.used = ival_
        elif nodeName_ == 'committed':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'committed')
            self.committed = ival_
        elif nodeName_ == 'storage_format':
            storage_format_ = child_.text
            storage_format_ = self.gds_validate_string(storage_format_, node, 'storage_format')
            self.storage_format = storage_format_
        super(StorageDomain, self).buildChildren(child_, node, nodeName_, True)
# end class StorageDomain


class StorageDomainStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, storage_domain_state=None):
        if storage_domain_state is None:
            self.storage_domain_state = []
        else:
            self.storage_domain_state = storage_domain_state
    def factory(*args_, **kwargs_):
        if StorageDomainStates.subclass:
            return StorageDomainStates.subclass(*args_, **kwargs_)
        else:
            return StorageDomainStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_storage_domain_state(self): return self.storage_domain_state
    def set_storage_domain_state(self, storage_domain_state): self.storage_domain_state = storage_domain_state
    def add_storage_domain_state(self, value): self.storage_domain_state.append(value)
    def insert_storage_domain_state(self, index, value): self.storage_domain_state[index] = value
    def hasContent_(self):
        if (
            self.storage_domain_state
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StorageDomainStates', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageDomainStates')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageDomainStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='StorageDomainStates', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for storage_domain_state_ in self.storage_domain_state:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstorage_domain_state>%s</%sstorage_domain_state>%s' % (namespace_, self.gds_format_string(quote_xml(storage_domain_state_).encode(ExternalEncoding), input_name='storage_domain_state'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='StorageDomainStates'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('storage_domain_state=[\n')
        level += 1
        for storage_domain_state_ in self.storage_domain_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(storage_domain_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'storage_domain_state':
            storage_domain_state_ = child_.text
            storage_domain_state_ = self.gds_validate_string(storage_domain_state_, node, 'storage_domain_state')
            self.storage_domain_state.append(storage_domain_state_)
# end class StorageDomainStates


class StorageDomains(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, storage_domain=None):
        super(StorageDomains, self).__init__(actions, total, active, )
        if storage_domain is None:
            self.storage_domain = []
        else:
            self.storage_domain = storage_domain
    def factory(*args_, **kwargs_):
        if StorageDomains.subclass:
            return StorageDomains.subclass(*args_, **kwargs_)
        else:
            return StorageDomains(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_storage_domain(self): return self.storage_domain
    def set_storage_domain(self, storage_domain): self.storage_domain = storage_domain
    def add_storage_domain(self, value): self.storage_domain.append(value)
    def insert_storage_domain(self, index, value): self.storage_domain[index] = value
    def hasContent_(self):
        if (
            self.storage_domain or
            super(StorageDomains, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StorageDomains', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageDomains')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageDomains'):
        super(StorageDomains, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StorageDomains')
    def exportChildren(self, outfile, level, namespace_='', name_='StorageDomains', fromsubclass_=False, pretty_print=True):
        super(StorageDomains, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for storage_domain_ in self.storage_domain:
            storage_domain_.export(outfile, level, namespace_, name_='storage_domain', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='StorageDomains'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(StorageDomains, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StorageDomains, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('storage_domain=[\n')
        level += 1
        for storage_domain_ in self.storage_domain:
            showIndent(outfile, level)
            outfile.write('model_.storage_domain(\n')
            storage_domain_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(StorageDomains, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'storage_domain':
            obj_ = StorageDomain.factory()
            obj_.build(child_)
            self.storage_domain.append(obj_)
        super(StorageDomains, self).buildChildren(child_, node, nodeName_, True)
# end class StorageDomains


class StorageConnections(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, storage_connection=None):
        super(StorageConnections, self).__init__(actions, total, active, )
        if storage_connection is None:
            self.storage_connection = []
        else:
            self.storage_connection = storage_connection
    def factory(*args_, **kwargs_):
        if StorageConnections.subclass:
            return StorageConnections.subclass(*args_, **kwargs_)
        else:
            return StorageConnections(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_storage_connection(self): return self.storage_connection
    def set_storage_connection(self, storage_connection): self.storage_connection = storage_connection
    def add_storage_connection(self, value): self.storage_connection.append(value)
    def insert_storage_connection(self, index, value): self.storage_connection[index] = value
    def hasContent_(self):
        if (
            self.storage_connection or
            super(StorageConnections, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StorageConnections', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StorageConnections')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StorageConnections'):
        super(StorageConnections, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StorageConnections')
    def exportChildren(self, outfile, level, namespace_='', name_='StorageConnections', fromsubclass_=False, pretty_print=True):
        super(StorageConnections, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for storage_connection_ in self.storage_connection:
            storage_connection_.export(outfile, level, namespace_, name_='storage_connection', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='StorageConnections'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(StorageConnections, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StorageConnections, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('storage_connection=[\n')
        level += 1
        for storage_connection_ in self.storage_connection:
            showIndent(outfile, level)
            outfile.write('model_.storage_connection(\n')
            storage_connection_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(StorageConnections, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'storage_connection':
            obj_ = StorageConnection.factory()
            obj_.build(child_)
            self.storage_connection.append(obj_)
        super(StorageConnections, self).buildChildren(child_, node, nodeName_, True)
# end class StorageConnections


class InstanceTypes(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, instance_type=None):
        super(InstanceTypes, self).__init__(actions, total, active, )
        if instance_type is None:
            self.instance_type = []
        else:
            self.instance_type = instance_type
    def factory(*args_, **kwargs_):
        if InstanceTypes.subclass:
            return InstanceTypes.subclass(*args_, **kwargs_)
        else:
            return InstanceTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_instance_type(self): return self.instance_type
    def set_instance_type(self, instance_type): self.instance_type = instance_type
    def add_instance_type(self, value): self.instance_type.append(value)
    def insert_instance_type(self, index, value): self.instance_type[index] = value
    def hasContent_(self):
        if (
            self.instance_type or
            super(InstanceTypes, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='InstanceTypes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='InstanceTypes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='InstanceTypes'):
        super(InstanceTypes, self).exportAttributes(outfile, level, already_processed, namespace_, name_='InstanceTypes')
    def exportChildren(self, outfile, level, namespace_='', name_='InstanceTypes', fromsubclass_=False, pretty_print=True):
        super(InstanceTypes, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for instance_type_ in self.instance_type:
            instance_type_.export(outfile, level, namespace_, name_='instance_type', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='InstanceTypes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(InstanceTypes, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(InstanceTypes, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('instance_type=[\n')
        level += 1
        for instance_type_ in self.instance_type:
            showIndent(outfile, level)
            outfile.write('model_.instance_type(\n')
            instance_type_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(InstanceTypes, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'instance_type':
            obj_ = InstanceType.factory()
            obj_.build(child_)
            self.instance_type.append(obj_)
        super(InstanceTypes, self).buildChildren(child_, node, nodeName_, True)
# end class InstanceTypes


class Template(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, vm=None, type_=None, status=None, memory=None, cpu=None, cpu_shares=None, bios=None, os=None, cluster=None, storage_domain=None, creation_time=None, origin=None, high_availability=None, display=None, stateless=None, delete_protected=None, sso=None, rng_device=None, console=None, timezone=None, domain=None, usb=None, tunnel_migration=None, migration_downtime=None, virtio_scsi=None, permissions=None, version=None, serial_number=None, cpu_profile=None, extensiontype_=None):
        super(Template, self).__init__(actions, href, id, name, description, comment, creation_status, link, extensiontype_, )
        self.vm = vm
        self.type_ = type_
        self.status = status
        self.memory = memory
        self.cpu = cpu
        self.cpu_shares = cpu_shares
        self.bios = bios
        self.os = os
        self.cluster = cluster
        self.storage_domain = storage_domain
        if isinstance(creation_time, basestring):
            initvalue_ = datetime_.datetime.strptime(creation_time, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = creation_time
        self.creation_time = initvalue_
        self.origin = origin
        self.high_availability = high_availability
        self.display = display
        self.stateless = stateless
        self.delete_protected = delete_protected
        self.sso = sso
        self.rng_device = rng_device
        self.console = console
        self.timezone = timezone
        self.domain = domain
        self.usb = usb
        self.tunnel_migration = tunnel_migration
        self.migration_downtime = migration_downtime
        self.virtio_scsi = virtio_scsi
        self.permissions = permissions
        self.version = version
        self.serial_number = serial_number
        self.cpu_profile = cpu_profile
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if Template.subclass:
            return Template.subclass(*args_, **kwargs_)
        else:
            return Template(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vm(self): return self.vm
    def set_vm(self, vm): self.vm = vm
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_memory(self): return self.memory
    def set_memory(self, memory): self.memory = memory
    def get_cpu(self): return self.cpu
    def set_cpu(self, cpu): self.cpu = cpu
    def get_cpu_shares(self): return self.cpu_shares
    def set_cpu_shares(self, cpu_shares): self.cpu_shares = cpu_shares
    def get_bios(self): return self.bios
    def set_bios(self, bios): self.bios = bios
    def get_os(self): return self.os
    def set_os(self, os): self.os = os
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def get_storage_domain(self): return self.storage_domain
    def set_storage_domain(self, storage_domain): self.storage_domain = storage_domain
    def get_creation_time(self): return self.creation_time
    def set_creation_time(self, creation_time): self.creation_time = creation_time
    def get_origin(self): return self.origin
    def set_origin(self, origin): self.origin = origin
    def get_high_availability(self): return self.high_availability
    def set_high_availability(self, high_availability): self.high_availability = high_availability
    def get_display(self): return self.display
    def set_display(self, display): self.display = display
    def get_stateless(self): return self.stateless
    def set_stateless(self, stateless): self.stateless = stateless
    def get_delete_protected(self): return self.delete_protected
    def set_delete_protected(self, delete_protected): self.delete_protected = delete_protected
    def get_sso(self): return self.sso
    def set_sso(self, sso): self.sso = sso
    def get_rng_device(self): return self.rng_device
    def set_rng_device(self, rng_device): self.rng_device = rng_device
    def get_console(self): return self.console
    def set_console(self, console): self.console = console
    def get_timezone(self): return self.timezone
    def set_timezone(self, timezone): self.timezone = timezone
    def get_domain(self): return self.domain
    def set_domain(self, domain): self.domain = domain
    def get_usb(self): return self.usb
    def set_usb(self, usb): self.usb = usb
    def get_tunnel_migration(self): return self.tunnel_migration
    def set_tunnel_migration(self, tunnel_migration): self.tunnel_migration = tunnel_migration
    def get_migration_downtime(self): return self.migration_downtime
    def set_migration_downtime(self, migration_downtime): self.migration_downtime = migration_downtime
    def get_virtio_scsi(self): return self.virtio_scsi
    def set_virtio_scsi(self, virtio_scsi): self.virtio_scsi = virtio_scsi
    def get_permissions(self): return self.permissions
    def set_permissions(self, permissions): self.permissions = permissions
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_serial_number(self): return self.serial_number
    def set_serial_number(self, serial_number): self.serial_number = serial_number
    def get_cpu_profile(self): return self.cpu_profile
    def set_cpu_profile(self, cpu_profile): self.cpu_profile = cpu_profile
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.vm is not None or
            self.type_ is not None or
            self.status is not None or
            self.memory is not None or
            self.cpu is not None or
            self.cpu_shares is not None or
            self.bios is not None or
            self.os is not None or
            self.cluster is not None or
            self.storage_domain is not None or
            self.creation_time is not None or
            self.origin is not None or
            self.high_availability is not None or
            self.display is not None or
            self.stateless is not None or
            self.delete_protected is not None or
            self.sso is not None or
            self.rng_device is not None or
            self.console is not None or
            self.timezone is not None or
            self.domain is not None or
            self.usb is not None or
            self.tunnel_migration is not None or
            self.migration_downtime is not None or
            self.virtio_scsi is not None or
            self.permissions is not None or
            self.version is not None or
            self.serial_number is not None or
            self.cpu_profile is not None or
            super(Template, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Template', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Template')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Template'):
        super(Template, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Template')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='Template', fromsubclass_=False, pretty_print=True):
        super(Template, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.vm is not None:
            self.vm.export(outfile, level, namespace_, name_='vm', pretty_print=pretty_print)
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status', pretty_print=pretty_print)
        if self.memory is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smemory>%s</%smemory>%s' % (namespace_, self.gds_format_integer(self.memory, input_name='memory'), namespace_, eol_))
        if self.cpu is not None:
            self.cpu.export(outfile, level, namespace_, name_='cpu', pretty_print=pretty_print)
        if self.cpu_shares is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scpu_shares>%s</%scpu_shares>%s' % (namespace_, self.gds_format_integer(self.cpu_shares, input_name='cpu_shares'), namespace_, eol_))
        if self.bios is not None:
            self.bios.export(outfile, level, namespace_, name_='bios', pretty_print=pretty_print)
        if self.os is not None:
            self.os.export(outfile, level, namespace_, name_='os', pretty_print=pretty_print)
        if self.cluster is not None:
            self.cluster.export(outfile, level, namespace_, name_='cluster', pretty_print=pretty_print)
        if self.storage_domain is not None:
            self.storage_domain.export(outfile, level, namespace_, name_='storage_domain', pretty_print=pretty_print)
        if self.creation_time is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%screation_time>%s</%screation_time>%s' % (namespace_, self.gds_format_datetime(self.creation_time, input_name='creation_time'), namespace_, eol_))
        if self.origin is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorigin>%s</%sorigin>%s' % (namespace_, self.gds_format_string(quote_xml(self.origin).encode(ExternalEncoding), input_name='origin'), namespace_, eol_))
        if self.high_availability is not None:
            self.high_availability.export(outfile, level, namespace_, name_='high_availability', pretty_print=pretty_print)
        if self.display is not None:
            self.display.export(outfile, level, namespace_, name_='display', pretty_print=pretty_print)
        if self.stateless is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstateless>%s</%sstateless>%s' % (namespace_, self.gds_format_boolean(self.stateless, input_name='stateless'), namespace_, eol_))
        if self.delete_protected is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdelete_protected>%s</%sdelete_protected>%s' % (namespace_, self.gds_format_boolean(self.delete_protected, input_name='delete_protected'), namespace_, eol_))
        if self.sso is not None:
            self.sso.export(outfile, level, namespace_, name_='sso', pretty_print=pretty_print)
        if self.rng_device is not None:
            self.rng_device.export(outfile, level, namespace_, name_='rng_device', pretty_print=pretty_print)
        if self.console is not None:
            self.console.export(outfile, level, namespace_, name_='console', pretty_print=pretty_print)
        if self.timezone is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stimezone>%s</%stimezone>%s' % (namespace_, self.gds_format_string(quote_xml(self.timezone).encode(ExternalEncoding), input_name='timezone'), namespace_, eol_))
        if self.domain is not None:
            self.domain.export(outfile, level, namespace_, name_='domain', pretty_print=pretty_print)
        if self.usb is not None:
            self.usb.export(outfile, level, namespace_, name_='usb', pretty_print=pretty_print)
        if self.tunnel_migration is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stunnel_migration>%s</%stunnel_migration>%s' % (namespace_, self.gds_format_boolean(self.tunnel_migration, input_name='tunnel_migration'), namespace_, eol_))
        if self.migration_downtime is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smigration_downtime>%s</%smigration_downtime>%s' % (namespace_, self.gds_format_integer(self.migration_downtime, input_name='migration_downtime'), namespace_, eol_))
        if self.virtio_scsi is not None:
            self.virtio_scsi.export(outfile, level, namespace_, name_='virtio_scsi', pretty_print=pretty_print)
        if self.permissions is not None:
            self.permissions.export(outfile, level, namespace_, name_='permissions', pretty_print=pretty_print)
        if self.version is not None:
            self.version.export(outfile, level, namespace_, name_='version', pretty_print=pretty_print)
        if self.serial_number is not None:
            self.serial_number.export(outfile, level, namespace_, name_='serial_number', pretty_print=pretty_print)
        if self.cpu_profile is not None:
            self.cpu_profile.export(outfile, level, namespace_, name_='cpu_profile', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Template'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Template, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Template, self).exportLiteralChildren(outfile, level, name_)
        if self.vm is not None:
            showIndent(outfile, level)
            outfile.write('vm=model_.vm(\n')
            self.vm.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.memory is not None:
            showIndent(outfile, level)
            outfile.write('memory=%d,\n' % self.memory)
        if self.cpu is not None:
            showIndent(outfile, level)
            outfile.write('cpu=model_.CPU(\n')
            self.cpu.exportLiteral(outfile, level, name_='cpu')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cpu_shares is not None:
            showIndent(outfile, level)
            outfile.write('cpu_shares=%d,\n' % self.cpu_shares)
        if self.bios is not None:
            showIndent(outfile, level)
            outfile.write('bios=model_.Bios(\n')
            self.bios.exportLiteral(outfile, level, name_='bios')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.os is not None:
            showIndent(outfile, level)
            outfile.write('os=model_.OperatingSystem(\n')
            self.os.exportLiteral(outfile, level, name_='os')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cluster is not None:
            showIndent(outfile, level)
            outfile.write('cluster=model_.cluster(\n')
            self.cluster.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.storage_domain is not None:
            showIndent(outfile, level)
            outfile.write('storage_domain=model_.storage_domain(\n')
            self.storage_domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.creation_time is not None:
            showIndent(outfile, level)
            outfile.write('creation_time=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.creation_time, input_name='creation_time'))
        if self.origin is not None:
            showIndent(outfile, level)
            outfile.write('origin=%s,\n' % quote_python(self.origin).encode(ExternalEncoding))
        if self.high_availability is not None:
            showIndent(outfile, level)
            outfile.write('high_availability=model_.HighAvailability(\n')
            self.high_availability.exportLiteral(outfile, level, name_='high_availability')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.display is not None:
            showIndent(outfile, level)
            outfile.write('display=model_.Display(\n')
            self.display.exportLiteral(outfile, level, name_='display')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.stateless is not None:
            showIndent(outfile, level)
            outfile.write('stateless=%s,\n' % self.stateless)
        if self.delete_protected is not None:
            showIndent(outfile, level)
            outfile.write('delete_protected=%s,\n' % self.delete_protected)
        if self.sso is not None:
            showIndent(outfile, level)
            outfile.write('sso=model_.sso(\n')
            self.sso.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.rng_device is not None:
            showIndent(outfile, level)
            outfile.write('rng_device=model_.rng_device(\n')
            self.rng_device.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.console is not None:
            showIndent(outfile, level)
            outfile.write('console=model_.console(\n')
            self.console.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.timezone is not None:
            showIndent(outfile, level)
            outfile.write('timezone=%s,\n' % quote_python(self.timezone).encode(ExternalEncoding))
        if self.domain is not None:
            showIndent(outfile, level)
            outfile.write('domain=model_.domain(\n')
            self.domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.usb is not None:
            showIndent(outfile, level)
            outfile.write('usb=model_.usb(\n')
            self.usb.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.tunnel_migration is not None:
            showIndent(outfile, level)
            outfile.write('tunnel_migration=%s,\n' % self.tunnel_migration)
        if self.migration_downtime is not None:
            showIndent(outfile, level)
            outfile.write('migration_downtime=%d,\n' % self.migration_downtime)
        if self.virtio_scsi is not None:
            showIndent(outfile, level)
            outfile.write('virtio_scsi=model_.virtio_scsi(\n')
            self.virtio_scsi.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.permissions is not None:
            showIndent(outfile, level)
            outfile.write('permissions=model_.permissions(\n')
            self.permissions.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=model_.TemplateVersion(\n')
            self.version.exportLiteral(outfile, level, name_='version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.serial_number is not None:
            showIndent(outfile, level)
            outfile.write('serial_number=model_.serial_number(\n')
            self.serial_number.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cpu_profile is not None:
            showIndent(outfile, level)
            outfile.write('cpu_profile=model_.cpu_profile(\n')
            self.cpu_profile.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(Template, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vm':
            class_obj_ = self.get_class_obj_(child_, VM)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.vm = obj_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'status':
            obj_ = Status.factory()
            obj_.build(child_)
            self.status = obj_
        elif nodeName_ == 'memory':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'memory')
            self.memory = ival_
        elif nodeName_ == 'cpu':
            obj_ = CPU.factory()
            obj_.build(child_)
            self.cpu = obj_
        elif nodeName_ == 'cpu_shares':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'cpu_shares')
            self.cpu_shares = ival_
        elif nodeName_ == 'bios':
            obj_ = Bios.factory()
            obj_.build(child_)
            self.bios = obj_
        elif nodeName_ == 'os':
            obj_ = OperatingSystem.factory()
            obj_.build(child_)
            self.os = obj_
        elif nodeName_ == 'cluster':
            obj_ = Cluster.factory()
            obj_.build(child_)
            self.cluster = obj_
        elif nodeName_ == 'storage_domain':
            obj_ = StorageDomain.factory()
            obj_.build(child_)
            self.storage_domain = obj_
        elif nodeName_ == 'creation_time':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.creation_time = dval_
        elif nodeName_ == 'origin':
            origin_ = child_.text
            origin_ = self.gds_validate_string(origin_, node, 'origin')
            self.origin = origin_
        elif nodeName_ == 'high_availability':
            obj_ = HighAvailability.factory()
            obj_.build(child_)
            self.high_availability = obj_
        elif nodeName_ == 'display':
            obj_ = Display.factory()
            obj_.build(child_)
            self.display = obj_
        elif nodeName_ == 'stateless':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'stateless')
            self.stateless = ival_
        elif nodeName_ == 'delete_protected':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'delete_protected')
            self.delete_protected = ival_
        elif nodeName_ == 'sso':
            obj_ = Sso.factory()
            obj_.build(child_)
            self.sso = obj_
        elif nodeName_ == 'rng_device':
            obj_ = RngDevice.factory()
            obj_.build(child_)
            self.rng_device = obj_
        elif nodeName_ == 'console':
            obj_ = Console.factory()
            obj_.build(child_)
            self.console = obj_
        elif nodeName_ == 'timezone':
            timezone_ = child_.text
            timezone_ = self.gds_validate_string(timezone_, node, 'timezone')
            self.timezone = timezone_
        elif nodeName_ == 'domain':
            obj_ = Domain.factory()
            obj_.build(child_)
            self.domain = obj_
        elif nodeName_ == 'usb':
            obj_ = Usb.factory()
            obj_.build(child_)
            self.usb = obj_
        elif nodeName_ == 'tunnel_migration':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'tunnel_migration')
            self.tunnel_migration = ival_
        elif nodeName_ == 'migration_downtime':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'migration_downtime')
            self.migration_downtime = ival_
        elif nodeName_ == 'virtio_scsi':
            obj_ = VirtIO_SCSI.factory()
            obj_.build(child_)
            self.virtio_scsi = obj_
        elif nodeName_ == 'permissions':
            obj_ = Permissions.factory()
            obj_.build(child_)
            self.permissions = obj_
        elif nodeName_ == 'version':
            obj_ = TemplateVersion.factory()
            obj_.build(child_)
            self.version = obj_
        elif nodeName_ == 'serial_number':
            obj_ = SerialNumber.factory()
            obj_.build(child_)
            self.serial_number = obj_
        elif nodeName_ == 'cpu_profile':
            obj_ = CpuProfile.factory()
            obj_.build(child_)
            self.cpu_profile = obj_
        super(Template, self).buildChildren(child_, node, nodeName_, True)
# end class Template


class Templates(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, template=None):
        super(Templates, self).__init__(actions, total, active, )
        if template is None:
            self.template = []
        else:
            self.template = template
    def factory(*args_, **kwargs_):
        if Templates.subclass:
            return Templates.subclass(*args_, **kwargs_)
        else:
            return Templates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_template(self): return self.template
    def set_template(self, template): self.template = template
    def add_template(self, value): self.template.append(value)
    def insert_template(self, index, value): self.template[index] = value
    def hasContent_(self):
        if (
            self.template or
            super(Templates, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Templates', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Templates')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Templates'):
        super(Templates, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Templates')
    def exportChildren(self, outfile, level, namespace_='', name_='Templates', fromsubclass_=False, pretty_print=True):
        super(Templates, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for template_ in self.template:
            template_.export(outfile, level, namespace_, name_='template', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Templates'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Templates, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Templates, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('template=[\n')
        level += 1
        for template_ in self.template:
            showIndent(outfile, level)
            outfile.write('model_.template(\n')
            template_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Templates, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'template':
            class_obj_ = self.get_class_obj_(child_, Template)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.template.append(obj_)
        super(Templates, self).buildChildren(child_, node, nodeName_, True)
# end class Templates


class TemplateStates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, template_state=None):
        if template_state is None:
            self.template_state = []
        else:
            self.template_state = template_state
    def factory(*args_, **kwargs_):
        if TemplateStates.subclass:
            return TemplateStates.subclass(*args_, **kwargs_)
        else:
            return TemplateStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_template_state(self): return self.template_state
    def set_template_state(self, template_state): self.template_state = template_state
    def add_template_state(self, value): self.template_state.append(value)
    def insert_template_state(self, index, value): self.template_state[index] = value
    def hasContent_(self):
        if (
            self.template_state
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TemplateStates', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TemplateStates')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TemplateStates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='TemplateStates', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for template_state_ in self.template_state:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stemplate_state>%s</%stemplate_state>%s' % (namespace_, self.gds_format_string(quote_xml(template_state_).encode(ExternalEncoding), input_name='template_state'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='TemplateStates'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('template_state=[\n')
        level += 1
        for template_state_ in self.template_state:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(template_state_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'template_state':
            template_state_ = child_.text
            template_state_ = self.gds_validate_string(template_state_, node, 'template_state')
            self.template_state.append(template_state_)
# end class TemplateStates


class Bios(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, boot_menu=None):
        self.boot_menu = boot_menu
    def factory(*args_, **kwargs_):
        if Bios.subclass:
            return Bios.subclass(*args_, **kwargs_)
        else:
            return Bios(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_boot_menu(self): return self.boot_menu
    def set_boot_menu(self, boot_menu): self.boot_menu = boot_menu
    def hasContent_(self):
        if (
            self.boot_menu is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Bios', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Bios')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Bios'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Bios', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.boot_menu is not None:
            self.boot_menu.export(outfile, level, namespace_, name_='boot_menu', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Bios'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.boot_menu is not None:
            showIndent(outfile, level)
            outfile.write('boot_menu=model_.boot_menu(\n')
            self.boot_menu.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'boot_menu':
            obj_ = BootMenu.factory()
            obj_.build(child_)
            self.boot_menu = obj_
# end class Bios


class BootMenu(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, enabled=None):
        self.enabled = enabled
    def factory(*args_, **kwargs_):
        if BootMenu.subclass:
            return BootMenu.subclass(*args_, **kwargs_)
        else:
            return BootMenu(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_enabled(self): return self.enabled
    def set_enabled(self, enabled): self.enabled = enabled
    def hasContent_(self):
        if (
            self.enabled is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BootMenu', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BootMenu')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BootMenu'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='BootMenu', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.enabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%senabled>%s</%senabled>%s' % (namespace_, self.gds_format_boolean(self.enabled, input_name='enabled'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='BootMenu'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.enabled is not None:
            showIndent(outfile, level)
            outfile.write('enabled=%s,\n' % self.enabled)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'enabled')
            self.enabled = ival_
# end class BootMenu


class Boot(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, dev=None):
        self.dev = _cast(None, dev)
        pass
    def factory(*args_, **kwargs_):
        if Boot.subclass:
            return Boot.subclass(*args_, **kwargs_)
        else:
            return Boot(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_dev(self): return self.dev
    def set_dev(self, dev): self.dev = dev
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Boot', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Boot')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Boot'):
        if self.dev is not None and 'dev' not in already_processed:
            already_processed.add('dev')
            outfile.write(' dev=%s' % (self.gds_format_string(quote_attrib(self.dev).encode(ExternalEncoding), input_name='dev'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Boot', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='Boot'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.dev is not None and 'dev' not in already_processed:
            already_processed.add('dev')
            showIndent(outfile, level)
            outfile.write('dev="%s",\n' % (self.dev,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('dev', node)
        if value is not None and 'dev' not in already_processed:
            already_processed.add('dev')
            self.dev = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Boot


class OperatingSystem(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, boot=None, kernel=None, initrd=None, cmdline=None, version=None):
        self.type_ = _cast(None, type_)
        if boot is None:
            self.boot = []
        else:
            self.boot = boot
        self.kernel = kernel
        self.initrd = initrd
        self.cmdline = cmdline
        self.version = version
    def factory(*args_, **kwargs_):
        if OperatingSystem.subclass:
            return OperatingSystem.subclass(*args_, **kwargs_)
        else:
            return OperatingSystem(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_boot(self): return self.boot
    def set_boot(self, boot): self.boot = boot
    def add_boot(self, value): self.boot.append(value)
    def insert_boot(self, index, value): self.boot[index] = value
    def get_kernel(self): return self.kernel
    def set_kernel(self, kernel): self.kernel = kernel
    def get_initrd(self): return self.initrd
    def set_initrd(self, initrd): self.initrd = initrd
    def get_cmdline(self): return self.cmdline
    def set_cmdline(self, cmdline): self.cmdline = cmdline
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def hasContent_(self):
        if (
            self.boot or
            self.kernel is not None or
            self.initrd is not None or
            self.cmdline is not None or
            self.version is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='OperatingSystem', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OperatingSystem')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OperatingSystem'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='OperatingSystem', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for boot_ in self.boot:
            boot_.export(outfile, level, namespace_, name_='boot', pretty_print=pretty_print)
        if self.kernel is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skernel>%s</%skernel>%s' % (namespace_, self.gds_format_string(quote_xml(self.kernel).encode(ExternalEncoding), input_name='kernel'), namespace_, eol_))
        if self.initrd is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinitrd>%s</%sinitrd>%s' % (namespace_, self.gds_format_string(quote_xml(self.initrd).encode(ExternalEncoding), input_name='initrd'), namespace_, eol_))
        if self.cmdline is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scmdline>%s</%scmdline>%s' % (namespace_, self.gds_format_string(quote_xml(self.cmdline).encode(ExternalEncoding), input_name='cmdline'), namespace_, eol_))
        if self.version is not None:
            self.version.export(outfile, level, namespace_, name_='version', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='OperatingSystem'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('boot=[\n')
        level += 1
        for boot_ in self.boot:
            showIndent(outfile, level)
            outfile.write('model_.Boot(\n')
            boot_.exportLiteral(outfile, level, name_='Boot')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.kernel is not None:
            showIndent(outfile, level)
            outfile.write('kernel=%s,\n' % quote_python(self.kernel).encode(ExternalEncoding))
        if self.initrd is not None:
            showIndent(outfile, level)
            outfile.write('initrd=%s,\n' % quote_python(self.initrd).encode(ExternalEncoding))
        if self.cmdline is not None:
            showIndent(outfile, level)
            outfile.write('cmdline=%s,\n' % quote_python(self.cmdline).encode(ExternalEncoding))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=model_.Version(\n')
            self.version.exportLiteral(outfile, level, name_='version')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'boot':
            obj_ = Boot.factory()
            obj_.build(child_)
            self.boot.append(obj_)
        elif nodeName_ == 'kernel':
            kernel_ = child_.text
            kernel_ = self.gds_validate_string(kernel_, node, 'kernel')
            self.kernel = kernel_
        elif nodeName_ == 'initrd':
            initrd_ = child_.text
            initrd_ = self.gds_validate_string(initrd_, node, 'initrd')
            self.initrd = initrd_
        elif nodeName_ == 'cmdline':
            cmdline_ = child_.text
            cmdline_ = self.gds_validate_string(cmdline_, node, 'cmdline')
            self.cmdline = cmdline_
        elif nodeName_ == 'version':
            class_obj_ = self.get_class_obj_(child_, Version)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.version = obj_
# end class OperatingSystem


class Sso(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, methods=None):
        self.methods = methods
    def factory(*args_, **kwargs_):
        if Sso.subclass:
            return Sso.subclass(*args_, **kwargs_)
        else:
            return Sso(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_methods(self): return self.methods
    def set_methods(self, methods): self.methods = methods
    def hasContent_(self):
        if (
            self.methods is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Sso', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Sso')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Sso'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Sso', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.methods is not None:
            self.methods.export(outfile, level, namespace_, name_='methods', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Sso'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.methods is not None:
            showIndent(outfile, level)
            outfile.write('methods=model_.methods(\n')
            self.methods.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'methods':
            obj_ = Methods.factory()
            obj_.build(child_)
            self.methods = obj_
# end class Sso


class Methods(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, method=None):
        if method is None:
            self.method = []
        else:
            self.method = method
    def factory(*args_, **kwargs_):
        if Methods.subclass:
            return Methods.subclass(*args_, **kwargs_)
        else:
            return Methods(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_method(self): return self.method
    def set_method(self, method): self.method = method
    def add_method(self, value): self.method.append(value)
    def insert_method(self, index, value): self.method[index] = value
    def hasContent_(self):
        if (
            self.method
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Methods', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Methods')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Methods'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Methods', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for method_ in self.method:
            method_.export(outfile, level, namespace_, name_='method', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Methods'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('method=[\n')
        level += 1
        for method_ in self.method:
            showIndent(outfile, level)
            outfile.write('model_.method(\n')
            method_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'method':
            obj_ = Method.factory()
            obj_.build(child_)
            self.method.append(obj_)
# end class Methods


class Method(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None):
        self.id = _cast(None, id)
        pass
    def factory(*args_, **kwargs_):
        if Method.subclass:
            return Method.subclass(*args_, **kwargs_)
        else:
            return Method(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Method', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Method')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Method'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Method', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='Method'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Method


class Rate(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, bytes=None, period=None):
        self.bytes = bytes
        self.period = period
    def factory(*args_, **kwargs_):
        if Rate.subclass:
            return Rate.subclass(*args_, **kwargs_)
        else:
            return Rate(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_bytes(self): return self.bytes
    def set_bytes(self, bytes): self.bytes = bytes
    def get_period(self): return self.period
    def set_period(self, period): self.period = period
    def hasContent_(self):
        if (
            self.bytes is not None or
            self.period is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Rate', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Rate')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Rate'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Rate', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.bytes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbytes>%s</%sbytes>%s' % (namespace_, self.gds_format_integer(self.bytes, input_name='bytes'), namespace_, eol_))
        if self.period is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%speriod>%s</%speriod>%s' % (namespace_, self.gds_format_integer(self.period, input_name='period'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Rate'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.bytes is not None:
            showIndent(outfile, level)
            outfile.write('bytes=%d,\n' % self.bytes)
        if self.period is not None:
            showIndent(outfile, level)
            outfile.write('period=%d,\n' % self.period)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'bytes':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'bytes')
            self.bytes = ival_
        elif nodeName_ == 'period':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'period')
            self.period = ival_
# end class Rate


class RngSources(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, source=None):
        if source is None:
            self.source = []
        else:
            self.source = source
    def factory(*args_, **kwargs_):
        if RngSources.subclass:
            return RngSources.subclass(*args_, **kwargs_)
        else:
            return RngSources(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_source(self): return self.source
    def set_source(self, source): self.source = source
    def add_source(self, value): self.source.append(value)
    def insert_source(self, index, value): self.source[index] = value
    def hasContent_(self):
        if (
            self.source
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='RngSources', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RngSources')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RngSources'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='RngSources', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for source_ in self.source:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssource>%s</%ssource>%s' % (namespace_, self.gds_format_string(quote_xml(source_).encode(ExternalEncoding), input_name='source'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='RngSources'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('source=[\n')
        level += 1
        for source_ in self.source:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(source_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'source':
            source_ = child_.text
            source_ = self.gds_validate_string(source_, node, 'source')
            self.source.append(source_)
# end class RngSources


class RngDevice(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, rate=None, source=None):
        self.rate = rate
        self.source = source
    def factory(*args_, **kwargs_):
        if RngDevice.subclass:
            return RngDevice.subclass(*args_, **kwargs_)
        else:
            return RngDevice(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_rate(self): return self.rate
    def set_rate(self, rate): self.rate = rate
    def get_source(self): return self.source
    def set_source(self, source): self.source = source
    def hasContent_(self):
        if (
            self.rate is not None or
            self.source is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='RngDevice', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RngDevice')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RngDevice'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='RngDevice', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.rate is not None:
            self.rate.export(outfile, level, namespace_, name_='rate', pretty_print=pretty_print)
        if self.source is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssource>%s</%ssource>%s' % (namespace_, self.gds_format_string(quote_xml(self.source).encode(ExternalEncoding), input_name='source'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='RngDevice'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.rate is not None:
            showIndent(outfile, level)
            outfile.write('rate=model_.Rate(\n')
            self.rate.exportLiteral(outfile, level, name_='rate')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.source is not None:
            showIndent(outfile, level)
            outfile.write('source=%s,\n' % quote_python(self.source).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'rate':
            obj_ = Rate.factory()
            obj_.build(child_)
            self.rate = obj_
        elif nodeName_ == 'source':
            source_ = child_.text
            source_ = self.gds_validate_string(source_, node, 'source')
            self.source = source_
# end class RngDevice


class HighAvailability(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, enabled=None, priority=None):
        self.enabled = enabled
        self.priority = priority
    def factory(*args_, **kwargs_):
        if HighAvailability.subclass:
            return HighAvailability.subclass(*args_, **kwargs_)
        else:
            return HighAvailability(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_enabled(self): return self.enabled
    def set_enabled(self, enabled): self.enabled = enabled
    def get_priority(self): return self.priority
    def set_priority(self, priority): self.priority = priority
    def hasContent_(self):
        if (
            self.enabled is not None or
            self.priority is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='HighAvailability', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HighAvailability')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HighAvailability'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='HighAvailability', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.enabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%senabled>%s</%senabled>%s' % (namespace_, self.gds_format_boolean(self.enabled, input_name='enabled'), namespace_, eol_))
        if self.priority is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spriority>%s</%spriority>%s' % (namespace_, self.gds_format_integer(self.priority, input_name='priority'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='HighAvailability'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.enabled is not None:
            showIndent(outfile, level)
            outfile.write('enabled=%s,\n' % self.enabled)
        if self.priority is not None:
            showIndent(outfile, level)
            outfile.write('priority=%d,\n' % self.priority)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'enabled')
            self.enabled = ival_
        elif nodeName_ == 'priority':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'priority')
            self.priority = ival_
# end class HighAvailability


class Display(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, address=None, port=None, secure_port=None, monitors=None, single_qxl_pci=None, allow_override=None, certificate=None, smartcard_enabled=None, keyboard_layout=None, proxy=None, file_transfer_enabled=None, copy_paste_enabled=None):
        self.type_ = type_
        self.address = address
        self.port = port
        self.secure_port = secure_port
        self.monitors = monitors
        self.single_qxl_pci = single_qxl_pci
        self.allow_override = allow_override
        self.certificate = certificate
        self.smartcard_enabled = smartcard_enabled
        self.keyboard_layout = keyboard_layout
        self.proxy = proxy
        self.file_transfer_enabled = file_transfer_enabled
        self.copy_paste_enabled = copy_paste_enabled
    def factory(*args_, **kwargs_):
        if Display.subclass:
            return Display.subclass(*args_, **kwargs_)
        else:
            return Display(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_port(self): return self.port
    def set_port(self, port): self.port = port
    def get_secure_port(self): return self.secure_port
    def set_secure_port(self, secure_port): self.secure_port = secure_port
    def get_monitors(self): return self.monitors
    def set_monitors(self, monitors): self.monitors = monitors
    def get_single_qxl_pci(self): return self.single_qxl_pci
    def set_single_qxl_pci(self, single_qxl_pci): self.single_qxl_pci = single_qxl_pci
    def get_allow_override(self): return self.allow_override
    def set_allow_override(self, allow_override): self.allow_override = allow_override
    def get_certificate(self): return self.certificate
    def set_certificate(self, certificate): self.certificate = certificate
    def get_smartcard_enabled(self): return self.smartcard_enabled
    def set_smartcard_enabled(self, smartcard_enabled): self.smartcard_enabled = smartcard_enabled
    def get_keyboard_layout(self): return self.keyboard_layout
    def set_keyboard_layout(self, keyboard_layout): self.keyboard_layout = keyboard_layout
    def get_proxy(self): return self.proxy
    def set_proxy(self, proxy): self.proxy = proxy
    def get_file_transfer_enabled(self): return self.file_transfer_enabled
    def set_file_transfer_enabled(self, file_transfer_enabled): self.file_transfer_enabled = file_transfer_enabled
    def get_copy_paste_enabled(self): return self.copy_paste_enabled
    def set_copy_paste_enabled(self, copy_paste_enabled): self.copy_paste_enabled = copy_paste_enabled
    def hasContent_(self):
        if (
            self.type_ is not None or
            self.address is not None or
            self.port is not None or
            self.secure_port is not None or
            self.monitors is not None or
            self.single_qxl_pci is not None or
            self.allow_override is not None or
            self.certificate is not None or
            self.smartcard_enabled is not None or
            self.keyboard_layout is not None or
            self.proxy is not None or
            self.file_transfer_enabled is not None or
            self.copy_paste_enabled is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Display', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Display')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Display'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Display', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.address is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress>%s</%saddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_, eol_))
        if self.port is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sport>%s</%sport>%s' % (namespace_, self.gds_format_integer(self.port, input_name='port'), namespace_, eol_))
        if self.secure_port is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssecure_port>%s</%ssecure_port>%s' % (namespace_, self.gds_format_integer(self.secure_port, input_name='secure_port'), namespace_, eol_))
        if self.monitors is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smonitors>%s</%smonitors>%s' % (namespace_, self.gds_format_integer(self.monitors, input_name='monitors'), namespace_, eol_))
        if self.single_qxl_pci is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssingle_qxl_pci>%s</%ssingle_qxl_pci>%s' % (namespace_, self.gds_format_boolean(self.single_qxl_pci, input_name='single_qxl_pci'), namespace_, eol_))
        if self.allow_override is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sallow_override>%s</%sallow_override>%s' % (namespace_, self.gds_format_boolean(self.allow_override, input_name='allow_override'), namespace_, eol_))
        if self.certificate is not None:
            self.certificate.export(outfile, level, namespace_, name_='certificate', pretty_print=pretty_print)
        if self.smartcard_enabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssmartcard_enabled>%s</%ssmartcard_enabled>%s' % (namespace_, self.gds_format_boolean(self.smartcard_enabled, input_name='smartcard_enabled'), namespace_, eol_))
        if self.keyboard_layout is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skeyboard_layout>%s</%skeyboard_layout>%s' % (namespace_, self.gds_format_string(quote_xml(self.keyboard_layout).encode(ExternalEncoding), input_name='keyboard_layout'), namespace_, eol_))
        if self.proxy is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sproxy>%s</%sproxy>%s' % (namespace_, self.gds_format_string(quote_xml(self.proxy).encode(ExternalEncoding), input_name='proxy'), namespace_, eol_))
        if self.file_transfer_enabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfile_transfer_enabled>%s</%sfile_transfer_enabled>%s' % (namespace_, self.gds_format_boolean(self.file_transfer_enabled, input_name='file_transfer_enabled'), namespace_, eol_))
        if self.copy_paste_enabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scopy_paste_enabled>%s</%scopy_paste_enabled>%s' % (namespace_, self.gds_format_boolean(self.copy_paste_enabled, input_name='copy_paste_enabled'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Display'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('port=%d,\n' % self.port)
        if self.secure_port is not None:
            showIndent(outfile, level)
            outfile.write('secure_port=%d,\n' % self.secure_port)
        if self.monitors is not None:
            showIndent(outfile, level)
            outfile.write('monitors=%d,\n' % self.monitors)
        if self.single_qxl_pci is not None:
            showIndent(outfile, level)
            outfile.write('single_qxl_pci=%s,\n' % self.single_qxl_pci)
        if self.allow_override is not None:
            showIndent(outfile, level)
            outfile.write('allow_override=%s,\n' % self.allow_override)
        if self.certificate is not None:
            showIndent(outfile, level)
            outfile.write('certificate=model_.certificate(\n')
            self.certificate.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.smartcard_enabled is not None:
            showIndent(outfile, level)
            outfile.write('smartcard_enabled=%s,\n' % self.smartcard_enabled)
        if self.keyboard_layout is not None:
            showIndent(outfile, level)
            outfile.write('keyboard_layout=%s,\n' % quote_python(self.keyboard_layout).encode(ExternalEncoding))
        if self.proxy is not None:
            showIndent(outfile, level)
            outfile.write('proxy=%s,\n' % quote_python(self.proxy).encode(ExternalEncoding))
        if self.file_transfer_enabled is not None:
            showIndent(outfile, level)
            outfile.write('file_transfer_enabled=%s,\n' % self.file_transfer_enabled)
        if self.copy_paste_enabled is not None:
            showIndent(outfile, level)
            outfile.write('copy_paste_enabled=%s,\n' % self.copy_paste_enabled)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'port')
            self.port = ival_
        elif nodeName_ == 'secure_port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'secure_port')
            self.secure_port = ival_
        elif nodeName_ == 'monitors':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'monitors')
            self.monitors = ival_
        elif nodeName_ == 'single_qxl_pci':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'single_qxl_pci')
            self.single_qxl_pci = ival_
        elif nodeName_ == 'allow_override':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'allow_override')
            self.allow_override = ival_
        elif nodeName_ == 'certificate':
            obj_ = Certificate.factory()
            obj_.build(child_)
            self.certificate = obj_
        elif nodeName_ == 'smartcard_enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'smartcard_enabled')
            self.smartcard_enabled = ival_
        elif nodeName_ == 'keyboard_layout':
            keyboard_layout_ = child_.text
            keyboard_layout_ = self.gds_validate_string(keyboard_layout_, node, 'keyboard_layout')
            self.keyboard_layout = keyboard_layout_
        elif nodeName_ == 'proxy':
            proxy_ = child_.text
            proxy_ = self.gds_validate_string(proxy_, node, 'proxy')
            self.proxy = proxy_
        elif nodeName_ == 'file_transfer_enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'file_transfer_enabled')
            self.file_transfer_enabled = ival_
        elif nodeName_ == 'copy_paste_enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'copy_paste_enabled')
            self.copy_paste_enabled = ival_
# end class Display


class Ticket(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, value=None, expiry=None):
        self.value = value
        self.expiry = expiry
    def factory(*args_, **kwargs_):
        if Ticket.subclass:
            return Ticket.subclass(*args_, **kwargs_)
        else:
            return Ticket(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def get_expiry(self): return self.expiry
    def set_expiry(self, expiry): self.expiry = expiry
    def hasContent_(self):
        if (
            self.value is not None or
            self.expiry is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Ticket', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Ticket')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Ticket'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Ticket', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(self.value).encode(ExternalEncoding), input_name='value'), namespace_, eol_))
        if self.expiry is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sexpiry>%s</%sexpiry>%s' % (namespace_, self.gds_format_integer(self.expiry, input_name='expiry'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Ticket'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value).encode(ExternalEncoding))
        if self.expiry is not None:
            showIndent(outfile, level)
            outfile.write('expiry=%d,\n' % self.expiry)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
        elif nodeName_ == 'expiry':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'expiry')
            self.expiry = ival_
# end class Ticket


class CustomProperty(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, regexp=None, name=None, value=None):
        self.regexp = _cast(None, regexp)
        self.name = _cast(None, name)
        self.value = _cast(None, value)
        pass
    def factory(*args_, **kwargs_):
        if CustomProperty.subclass:
            return CustomProperty.subclass(*args_, **kwargs_)
        else:
            return CustomProperty(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_regexp(self): return self.regexp
    def set_regexp(self, regexp): self.regexp = regexp
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CustomProperty', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CustomProperty')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CustomProperty'):
        if self.regexp is not None and 'regexp' not in already_processed:
            already_processed.add('regexp')
            outfile.write(' regexp=%s' % (self.gds_format_string(quote_attrib(self.regexp).encode(ExternalEncoding), input_name='regexp'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (self.gds_format_string(quote_attrib(self.value).encode(ExternalEncoding), input_name='value'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='CustomProperty', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='CustomProperty'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.regexp is not None and 'regexp' not in already_processed:
            already_processed.add('regexp')
            showIndent(outfile, level)
            outfile.write('regexp="%s",\n' % (self.regexp,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            showIndent(outfile, level)
            outfile.write('value="%s",\n' % (self.value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('regexp', node)
        if value is not None and 'regexp' not in already_processed:
            already_processed.add('regexp')
            self.regexp = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class CustomProperty


class CustomProperties(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, custom_property=None):
        if custom_property is None:
            self.custom_property = []
        else:
            self.custom_property = custom_property
    def factory(*args_, **kwargs_):
        if CustomProperties.subclass:
            return CustomProperties.subclass(*args_, **kwargs_)
        else:
            return CustomProperties(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_custom_property(self): return self.custom_property
    def set_custom_property(self, custom_property): self.custom_property = custom_property
    def add_custom_property(self, value): self.custom_property.append(value)
    def insert_custom_property(self, index, value): self.custom_property[index] = value
    def hasContent_(self):
        if (
            self.custom_property
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CustomProperties', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CustomProperties')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CustomProperties'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='CustomProperties', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for custom_property_ in self.custom_property:
            custom_property_.export(outfile, level, namespace_, name_='custom_property', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='CustomProperties'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('custom_property=[\n')
        level += 1
        for custom_property_ in self.custom_property:
            showIndent(outfile, level)
            outfile.write('model_.CustomProperty(\n')
            custom_property_.exportLiteral(outfile, level, name_='CustomProperty')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'custom_property':
            obj_ = CustomProperty.factory()
            obj_.build(child_)
            self.custom_property.append(obj_)
# end class CustomProperties


class Property(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, name=None, value=None):
        self.name = name
        self.value = value
    def factory(*args_, **kwargs_):
        if Property.subclass:
            return Property.subclass(*args_, **kwargs_)
        else:
            return Property(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def hasContent_(self):
        if (
            self.name is not None or
            self.value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Property', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Property')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Property'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Property', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_, eol_))
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(self.value).encode(ExternalEncoding), input_name='value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Property'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
# end class Property


class Properties(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, property=None):
        if property is None:
            self.property = []
        else:
            self.property = property
    def factory(*args_, **kwargs_):
        if Properties.subclass:
            return Properties.subclass(*args_, **kwargs_)
        else:
            return Properties(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_property(self): return self.property
    def set_property(self, property): self.property = property
    def add_property(self, value): self.property.append(value)
    def insert_property(self, index, value): self.property[index] = value
    def hasContent_(self):
        if (
            self.property
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Properties', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Properties')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Properties'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Properties', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for property_ in self.property:
            property_.export(outfile, level, namespace_, name_='property', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Properties'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('property=[\n')
        level += 1
        for property_ in self.property:
            showIndent(outfile, level)
            outfile.write('model_.property(\n')
            property_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'property':
            obj_ = Property.factory()
            obj_.build(child_)
            self.property.append(obj_)
# end class Properties


class Payloads(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, payload=None):
        if payload is None:
            self.payload = []
        else:
            self.payload = payload
    def factory(*args_, **kwargs_):
        if Payloads.subclass:
            return Payloads.subclass(*args_, **kwargs_)
        else:
            return Payloads(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_payload(self): return self.payload
    def set_payload(self, payload): self.payload = payload
    def add_payload(self, value): self.payload.append(value)
    def insert_payload(self, index, value): self.payload[index] = value
    def hasContent_(self):
        if (
            self.payload
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Payloads', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Payloads')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Payloads'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Payloads', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for payload_ in self.payload:
            payload_.export(outfile, level, namespace_, name_='payload', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Payloads'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('payload=[\n')
        level += 1
        for payload_ in self.payload:
            showIndent(outfile, level)
            outfile.write('model_.Payload(\n')
            payload_.exportLiteral(outfile, level, name_='Payload')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'payload':
            obj_ = Payload.factory()
            obj_.build(child_)
            self.payload.append(obj_)
# end class Payloads


class Payload(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, files=None, volume_id=None):
        self.type_ = _cast(None, type_)
        self.files = files
        self.volume_id = volume_id
    def factory(*args_, **kwargs_):
        if Payload.subclass:
            return Payload.subclass(*args_, **kwargs_)
        else:
            return Payload(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_files(self): return self.files
    def set_files(self, files): self.files = files
    def get_volume_id(self): return self.volume_id
    def set_volume_id(self, volume_id): self.volume_id = volume_id
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def hasContent_(self):
        if (
            self.files is not None or
            self.volume_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Payload', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Payload')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Payload'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Payload', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.files is not None:
            self.files.export(outfile, level, namespace_, name_='files', pretty_print=pretty_print)
        if self.volume_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svolume_id>%s</%svolume_id>%s' % (namespace_, self.gds_format_string(quote_xml(self.volume_id).encode(ExternalEncoding), input_name='volume_id'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Payload'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.files is not None:
            showIndent(outfile, level)
            outfile.write('files=model_.files(\n')
            self.files.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.volume_id is not None:
            showIndent(outfile, level)
            outfile.write('volume_id=%s,\n' % quote_python(self.volume_id).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'files':
            obj_ = Files.factory()
            obj_.build(child_)
            self.files = obj_
        elif nodeName_ == 'volume_id':
            volume_id_ = child_.text
            volume_id_ = self.gds_validate_string(volume_id_, node, 'volume_id')
            self.volume_id = volume_id_
# end class Payload


class VmDeviceTypes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vm_device_types=None):
        if vm_device_types is None:
            self.vm_device_types = []
        else:
            self.vm_device_types = vm_device_types
    def factory(*args_, **kwargs_):
        if VmDeviceTypes.subclass:
            return VmDeviceTypes.subclass(*args_, **kwargs_)
        else:
            return VmDeviceTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vm_device_types(self): return self.vm_device_types
    def set_vm_device_types(self, vm_device_types): self.vm_device_types = vm_device_types
    def add_vm_device_types(self, value): self.vm_device_types.append(value)
    def insert_vm_device_types(self, index, value): self.vm_device_types[index] = value
    def hasContent_(self):
        if (
            self.vm_device_types
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VmDeviceTypes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmDeviceTypes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmDeviceTypes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VmDeviceTypes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for vm_device_types_ in self.vm_device_types:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svm_device_types>%s</%svm_device_types>%s' % (namespace_, self.gds_format_string(quote_xml(vm_device_types_).encode(ExternalEncoding), input_name='vm_device_types'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='VmDeviceTypes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('vm_device_types=[\n')
        level += 1
        for vm_device_types_ in self.vm_device_types:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(vm_device_types_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vm_device_types':
            vm_device_types_ = child_.text
            vm_device_types_ = self.gds_validate_string(vm_device_types_, node, 'vm_device_types')
            self.vm_device_types.append(vm_device_types_)
# end class VmDeviceTypes


class Configuration(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, data=None):
        self.type_ = type_
        self.data = data
    def factory(*args_, **kwargs_):
        if Configuration.subclass:
            return Configuration.subclass(*args_, **kwargs_)
        else:
            return Configuration(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_data(self): return self.data
    def set_data(self, data): self.data = data
    def hasContent_(self):
        if (
            self.type_ is not None or
            self.data is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Configuration', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Configuration')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Configuration'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Configuration', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.data is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdata>%s</%sdata>%s' % (namespace_, self.gds_format_string(quote_xml(self.data).encode(ExternalEncoding), input_name='data'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Configuration'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.data is not None:
            showIndent(outfile, level)
            outfile.write('data=%s,\n' % quote_python(self.data).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'data':
            data_ = child_.text
            data_ = self.gds_validate_string(data_, node, 'data')
            self.data = data_
# end class Configuration


class Initialization(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, configuration=None, cloud_init=None, host_name=None, domain=None, timezone=None, authorized_ssh_keys=None, regenerate_ssh_keys=None, regenerate_ids=None, dns_servers=None, dns_search=None, nic_configurations=None, windows_license_key=None, root_password=None, custom_script=None, input_locale=None, ui_language=None, system_locale=None, user_locale=None, user_name=None, active_directory_ou=None, org_name=None):
        self.configuration = configuration
        self.cloud_init = cloud_init
        self.host_name = host_name
        self.domain = domain
        self.timezone = timezone
        self.authorized_ssh_keys = authorized_ssh_keys
        self.regenerate_ssh_keys = regenerate_ssh_keys
        self.regenerate_ids = regenerate_ids
        self.dns_servers = dns_servers
        self.dns_search = dns_search
        self.nic_configurations = nic_configurations
        self.windows_license_key = windows_license_key
        self.root_password = root_password
        self.custom_script = custom_script
        self.input_locale = input_locale
        self.ui_language = ui_language
        self.system_locale = system_locale
        self.user_locale = user_locale
        self.user_name = user_name
        self.active_directory_ou = active_directory_ou
        self.org_name = org_name
    def factory(*args_, **kwargs_):
        if Initialization.subclass:
            return Initialization.subclass(*args_, **kwargs_)
        else:
            return Initialization(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_configuration(self): return self.configuration
    def set_configuration(self, configuration): self.configuration = configuration
    def get_cloud_init(self): return self.cloud_init
    def set_cloud_init(self, cloud_init): self.cloud_init = cloud_init
    def get_host_name(self): return self.host_name
    def set_host_name(self, host_name): self.host_name = host_name
    def get_domain(self): return self.domain
    def set_domain(self, domain): self.domain = domain
    def get_timezone(self): return self.timezone
    def set_timezone(self, timezone): self.timezone = timezone
    def get_authorized_ssh_keys(self): return self.authorized_ssh_keys
    def set_authorized_ssh_keys(self, authorized_ssh_keys): self.authorized_ssh_keys = authorized_ssh_keys
    def get_regenerate_ssh_keys(self): return self.regenerate_ssh_keys
    def set_regenerate_ssh_keys(self, regenerate_ssh_keys): self.regenerate_ssh_keys = regenerate_ssh_keys
    def get_regenerate_ids(self): return self.regenerate_ids
    def set_regenerate_ids(self, regenerate_ids): self.regenerate_ids = regenerate_ids
    def get_dns_servers(self): return self.dns_servers
    def set_dns_servers(self, dns_servers): self.dns_servers = dns_servers
    def get_dns_search(self): return self.dns_search
    def set_dns_search(self, dns_search): self.dns_search = dns_search
    def get_nic_configurations(self): return self.nic_configurations
    def set_nic_configurations(self, nic_configurations): self.nic_configurations = nic_configurations
    def get_windows_license_key(self): return self.windows_license_key
    def set_windows_license_key(self, windows_license_key): self.windows_license_key = windows_license_key
    def get_root_password(self): return self.root_password
    def set_root_password(self, root_password): self.root_password = root_password
    def get_custom_script(self): return self.custom_script
    def set_custom_script(self, custom_script): self.custom_script = custom_script
    def get_input_locale(self): return self.input_locale
    def set_input_locale(self, input_locale): self.input_locale = input_locale
    def get_ui_language(self): return self.ui_language
    def set_ui_language(self, ui_language): self.ui_language = ui_language
    def get_system_locale(self): return self.system_locale
    def set_system_locale(self, system_locale): self.system_locale = system_locale
    def get_user_locale(self): return self.user_locale
    def set_user_locale(self, user_locale): self.user_locale = user_locale
    def get_user_name(self): return self.user_name
    def set_user_name(self, user_name): self.user_name = user_name
    def get_active_directory_ou(self): return self.active_directory_ou
    def set_active_directory_ou(self, active_directory_ou): self.active_directory_ou = active_directory_ou
    def get_org_name(self): return self.org_name
    def set_org_name(self, org_name): self.org_name = org_name
    def hasContent_(self):
        if (
            self.configuration is not None or
            self.cloud_init is not None or
            self.host_name is not None or
            self.domain is not None or
            self.timezone is not None or
            self.authorized_ssh_keys is not None or
            self.regenerate_ssh_keys is not None or
            self.regenerate_ids is not None or
            self.dns_servers is not None or
            self.dns_search is not None or
            self.nic_configurations is not None or
            self.windows_license_key is not None or
            self.root_password is not None or
            self.custom_script is not None or
            self.input_locale is not None or
            self.ui_language is not None or
            self.system_locale is not None or
            self.user_locale is not None or
            self.user_name is not None or
            self.active_directory_ou is not None or
            self.org_name is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Initialization', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Initialization')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Initialization'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Initialization', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.configuration is not None:
            self.configuration.export(outfile, level, namespace_, name_='configuration', pretty_print=pretty_print)
        if self.cloud_init is not None:
            self.cloud_init.export(outfile, level, namespace_, name_='cloud_init', pretty_print=pretty_print)
        if self.host_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shost_name>%s</%shost_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.host_name).encode(ExternalEncoding), input_name='host_name'), namespace_, eol_))
        if self.domain is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdomain>%s</%sdomain>%s' % (namespace_, self.gds_format_string(quote_xml(self.domain).encode(ExternalEncoding), input_name='domain'), namespace_, eol_))
        if self.timezone is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stimezone>%s</%stimezone>%s' % (namespace_, self.gds_format_string(quote_xml(self.timezone).encode(ExternalEncoding), input_name='timezone'), namespace_, eol_))
        if self.authorized_ssh_keys is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sauthorized_ssh_keys>%s</%sauthorized_ssh_keys>%s' % (namespace_, self.gds_format_string(quote_xml(self.authorized_ssh_keys).encode(ExternalEncoding), input_name='authorized_ssh_keys'), namespace_, eol_))
        if self.regenerate_ssh_keys is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sregenerate_ssh_keys>%s</%sregenerate_ssh_keys>%s' % (namespace_, self.gds_format_boolean(self.regenerate_ssh_keys, input_name='regenerate_ssh_keys'), namespace_, eol_))
        if self.regenerate_ids is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sregenerate_ids>%s</%sregenerate_ids>%s' % (namespace_, self.gds_format_boolean(self.regenerate_ids, input_name='regenerate_ids'), namespace_, eol_))
        if self.dns_servers is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdns_servers>%s</%sdns_servers>%s' % (namespace_, self.gds_format_string(quote_xml(self.dns_servers).encode(ExternalEncoding), input_name='dns_servers'), namespace_, eol_))
        if self.dns_search is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdns_search>%s</%sdns_search>%s' % (namespace_, self.gds_format_string(quote_xml(self.dns_search).encode(ExternalEncoding), input_name='dns_search'), namespace_, eol_))
        if self.nic_configurations is not None:
            self.nic_configurations.export(outfile, level, namespace_, name_='nic_configurations', pretty_print=pretty_print)
        if self.windows_license_key is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%swindows_license_key>%s</%swindows_license_key>%s' % (namespace_, self.gds_format_string(quote_xml(self.windows_license_key).encode(ExternalEncoding), input_name='windows_license_key'), namespace_, eol_))
        if self.root_password is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sroot_password>%s</%sroot_password>%s' % (namespace_, self.gds_format_string(quote_xml(self.root_password).encode(ExternalEncoding), input_name='root_password'), namespace_, eol_))
        if self.custom_script is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scustom_script>%s</%scustom_script>%s' % (namespace_, self.gds_format_string(quote_xml(self.custom_script).encode(ExternalEncoding), input_name='custom_script'), namespace_, eol_))
        if self.input_locale is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinput_locale>%s</%sinput_locale>%s' % (namespace_, self.gds_format_string(quote_xml(self.input_locale).encode(ExternalEncoding), input_name='input_locale'), namespace_, eol_))
        if self.ui_language is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sui_language>%s</%sui_language>%s' % (namespace_, self.gds_format_string(quote_xml(self.ui_language).encode(ExternalEncoding), input_name='ui_language'), namespace_, eol_))
        if self.system_locale is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssystem_locale>%s</%ssystem_locale>%s' % (namespace_, self.gds_format_string(quote_xml(self.system_locale).encode(ExternalEncoding), input_name='system_locale'), namespace_, eol_))
        if self.user_locale is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_locale>%s</%suser_locale>%s' % (namespace_, self.gds_format_string(quote_xml(self.user_locale).encode(ExternalEncoding), input_name='user_locale'), namespace_, eol_))
        if self.user_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_name>%s</%suser_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.user_name).encode(ExternalEncoding), input_name='user_name'), namespace_, eol_))
        if self.active_directory_ou is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sactive_directory_ou>%s</%sactive_directory_ou>%s' % (namespace_, self.gds_format_string(quote_xml(self.active_directory_ou).encode(ExternalEncoding), input_name='active_directory_ou'), namespace_, eol_))
        if self.org_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorg_name>%s</%sorg_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.org_name).encode(ExternalEncoding), input_name='org_name'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Initialization'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.configuration is not None:
            showIndent(outfile, level)
            outfile.write('configuration=model_.Configuration(\n')
            self.configuration.exportLiteral(outfile, level, name_='configuration')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.cloud_init is not None:
            showIndent(outfile, level)
            outfile.write('cloud_init=model_.CloudInit(\n')
            self.cloud_init.exportLiteral(outfile, level, name_='cloud_init')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.host_name is not None:
            showIndent(outfile, level)
            outfile.write('host_name=%s,\n' % quote_python(self.host_name).encode(ExternalEncoding))
        if self.domain is not None:
            showIndent(outfile, level)
            outfile.write('domain=%s,\n' % quote_python(self.domain).encode(ExternalEncoding))
        if self.timezone is not None:
            showIndent(outfile, level)
            outfile.write('timezone=%s,\n' % quote_python(self.timezone).encode(ExternalEncoding))
        if self.authorized_ssh_keys is not None:
            showIndent(outfile, level)
            outfile.write('authorized_ssh_keys=%s,\n' % quote_python(self.authorized_ssh_keys).encode(ExternalEncoding))
        if self.regenerate_ssh_keys is not None:
            showIndent(outfile, level)
            outfile.write('regenerate_ssh_keys=%s,\n' % self.regenerate_ssh_keys)
        if self.regenerate_ids is not None:
            showIndent(outfile, level)
            outfile.write('regenerate_ids=%s,\n' % self.regenerate_ids)
        if self.dns_servers is not None:
            showIndent(outfile, level)
            outfile.write('dns_servers=%s,\n' % quote_python(self.dns_servers).encode(ExternalEncoding))
        if self.dns_search is not None:
            showIndent(outfile, level)
            outfile.write('dns_search=%s,\n' % quote_python(self.dns_search).encode(ExternalEncoding))
        if self.nic_configurations is not None:
            showIndent(outfile, level)
            outfile.write('nic_configurations=model_.nic_configurations(\n')
            self.nic_configurations.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.windows_license_key is not None:
            showIndent(outfile, level)
            outfile.write('windows_license_key=%s,\n' % quote_python(self.windows_license_key).encode(ExternalEncoding))
        if self.root_password is not None:
            showIndent(outfile, level)
            outfile.write('root_password=%s,\n' % quote_python(self.root_password).encode(ExternalEncoding))
        if self.custom_script is not None:
            showIndent(outfile, level)
            outfile.write('custom_script=%s,\n' % quote_python(self.custom_script).encode(ExternalEncoding))
        if self.input_locale is not None:
            showIndent(outfile, level)
            outfile.write('input_locale=%s,\n' % quote_python(self.input_locale).encode(ExternalEncoding))
        if self.ui_language is not None:
            showIndent(outfile, level)
            outfile.write('ui_language=%s,\n' % quote_python(self.ui_language).encode(ExternalEncoding))
        if self.system_locale is not None:
            showIndent(outfile, level)
            outfile.write('system_locale=%s,\n' % quote_python(self.system_locale).encode(ExternalEncoding))
        if self.user_locale is not None:
            showIndent(outfile, level)
            outfile.write('user_locale=%s,\n' % quote_python(self.user_locale).encode(ExternalEncoding))
        if self.user_name is not None:
            showIndent(outfile, level)
            outfile.write('user_name=%s,\n' % quote_python(self.user_name).encode(ExternalEncoding))
        if self.active_directory_ou is not None:
            showIndent(outfile, level)
            outfile.write('active_directory_ou=%s,\n' % quote_python(self.active_directory_ou).encode(ExternalEncoding))
        if self.org_name is not None:
            showIndent(outfile, level)
            outfile.write('org_name=%s,\n' % quote_python(self.org_name).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'configuration':
            obj_ = Configuration.factory()
            obj_.build(child_)
            self.configuration = obj_
        elif nodeName_ == 'cloud_init':
            obj_ = CloudInit.factory()
            obj_.build(child_)
            self.cloud_init = obj_
        elif nodeName_ == 'host_name':
            host_name_ = child_.text
            host_name_ = self.gds_validate_string(host_name_, node, 'host_name')
            self.host_name = host_name_
        elif nodeName_ == 'domain':
            domain_ = child_.text
            domain_ = self.gds_validate_string(domain_, node, 'domain')
            self.domain = domain_
        elif nodeName_ == 'timezone':
            timezone_ = child_.text
            timezone_ = self.gds_validate_string(timezone_, node, 'timezone')
            self.timezone = timezone_
        elif nodeName_ == 'authorized_ssh_keys':
            authorized_ssh_keys_ = child_.text
            authorized_ssh_keys_ = self.gds_validate_string(authorized_ssh_keys_, node, 'authorized_ssh_keys')
            self.authorized_ssh_keys = authorized_ssh_keys_
        elif nodeName_ == 'regenerate_ssh_keys':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'regenerate_ssh_keys')
            self.regenerate_ssh_keys = ival_
        elif nodeName_ == 'regenerate_ids':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'regenerate_ids')
            self.regenerate_ids = ival_
        elif nodeName_ == 'dns_servers':
            dns_servers_ = child_.text
            dns_servers_ = self.gds_validate_string(dns_servers_, node, 'dns_servers')
            self.dns_servers = dns_servers_
        elif nodeName_ == 'dns_search':
            dns_search_ = child_.text
            dns_search_ = self.gds_validate_string(dns_search_, node, 'dns_search')
            self.dns_search = dns_search_
        elif nodeName_ == 'nic_configurations':
            obj_ = GuestNicsConfiguration.factory()
            obj_.build(child_)
            self.nic_configurations = obj_
        elif nodeName_ == 'windows_license_key':
            windows_license_key_ = child_.text
            windows_license_key_ = self.gds_validate_string(windows_license_key_, node, 'windows_license_key')
            self.windows_license_key = windows_license_key_
        elif nodeName_ == 'root_password':
            root_password_ = child_.text
            root_password_ = self.gds_validate_string(root_password_, node, 'root_password')
            self.root_password = root_password_
        elif nodeName_ == 'custom_script':
            custom_script_ = child_.text
            custom_script_ = self.gds_validate_string(custom_script_, node, 'custom_script')
            self.custom_script = custom_script_
        elif nodeName_ == 'input_locale':
            input_locale_ = child_.text
            input_locale_ = self.gds_validate_string(input_locale_, node, 'input_locale')
            self.input_locale = input_locale_
        elif nodeName_ == 'ui_language':
            ui_language_ = child_.text
            ui_language_ = self.gds_validate_string(ui_language_, node, 'ui_language')
            self.ui_language = ui_language_
        elif nodeName_ == 'system_locale':
            system_locale_ = child_.text
            system_locale_ = self.gds_validate_string(system_locale_, node, 'system_locale')
            self.system_locale = system_locale_
        elif nodeName_ == 'user_locale':
            user_locale_ = child_.text
            user_locale_ = self.gds_validate_string(user_locale_, node, 'user_locale')
            self.user_locale = user_locale_
        elif nodeName_ == 'user_name':
            user_name_ = child_.text
            user_name_ = self.gds_validate_string(user_name_, node, 'user_name')
            self.user_name = user_name_
        elif nodeName_ == 'active_directory_ou':
            active_directory_ou_ = child_.text
            active_directory_ou_ = self.gds_validate_string(active_directory_ou_, node, 'active_directory_ou')
            self.active_directory_ou = active_directory_ou_
        elif nodeName_ == 'org_name':
            org_name_ = child_.text
            org_name_ = self.gds_validate_string(org_name_, node, 'org_name')
            self.org_name = org_name_
# end class Initialization


class DNS(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, servers=None, search_domains=None):
        self.servers = servers
        self.search_domains = search_domains
    def factory(*args_, **kwargs_):
        if DNS.subclass:
            return DNS.subclass(*args_, **kwargs_)
        else:
            return DNS(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_servers(self): return self.servers
    def set_servers(self, servers): self.servers = servers
    def get_search_domains(self): return self.search_domains
    def set_search_domains(self, search_domains): self.search_domains = search_domains
    def hasContent_(self):
        if (
            self.servers is not None or
            self.search_domains is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DNS', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DNS')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DNS'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='DNS', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.servers is not None:
            self.servers.export(outfile, level, namespace_, name_='servers', pretty_print=pretty_print)
        if self.search_domains is not None:
            self.search_domains.export(outfile, level, namespace_, name_='search_domains', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='DNS'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.servers is not None:
            showIndent(outfile, level)
            outfile.write('servers=model_.Hosts(\n')
            self.servers.exportLiteral(outfile, level, name_='servers')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.search_domains is not None:
            showIndent(outfile, level)
            outfile.write('search_domains=model_.Hosts(\n')
            self.search_domains.exportLiteral(outfile, level, name_='search_domains')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'servers':
            obj_ = Hosts.factory()
            obj_.build(child_)
            self.servers = obj_
        elif nodeName_ == 'search_domains':
            obj_ = Hosts.factory()
            obj_.build(child_)
            self.search_domains = obj_
# end class DNS


class AuthorizedKey(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, user=None, key=None):
        super(AuthorizedKey, self).__init__(actions, href, id, name, description, comment, creation_status, link, )
        self.user = user
        self.key = key
    def factory(*args_, **kwargs_):
        if AuthorizedKey.subclass:
            return AuthorizedKey.subclass(*args_, **kwargs_)
        else:
            return AuthorizedKey(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_user(self): return self.user
    def set_user(self, user): self.user = user
    def get_key(self): return self.key
    def set_key(self, key): self.key = key
    def hasContent_(self):
        if (
            self.user is not None or
            self.key is not None or
            super(AuthorizedKey, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AuthorizedKey', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AuthorizedKey')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AuthorizedKey'):
        super(AuthorizedKey, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AuthorizedKey')
    def exportChildren(self, outfile, level, namespace_='', name_='AuthorizedKey', fromsubclass_=False, pretty_print=True):
        super(AuthorizedKey, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.user is not None:
            self.user.export(outfile, level, namespace_, name_='user', pretty_print=pretty_print)
        if self.key is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skey>%s</%skey>%s' % (namespace_, self.gds_format_string(quote_xml(self.key).encode(ExternalEncoding), input_name='key'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='AuthorizedKey'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AuthorizedKey, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AuthorizedKey, self).exportLiteralChildren(outfile, level, name_)
        if self.user is not None:
            showIndent(outfile, level)
            outfile.write('user=model_.user(\n')
            self.user.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.key is not None:
            showIndent(outfile, level)
            outfile.write('key=%s,\n' % quote_python(self.key).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(AuthorizedKey, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'user':
            class_obj_ = self.get_class_obj_(child_, User)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.user = obj_
        elif nodeName_ == 'key':
            key_ = child_.text
            key_ = self.gds_validate_string(key_, node, 'key')
            self.key = key_
        super(AuthorizedKey, self).buildChildren(child_, node, nodeName_, True)
# end class AuthorizedKey


class AuthorizedKeys(BaseResources):
    subclass = None
    superclass = BaseResources
    def __init__(self, actions=None, total=None, active=None, authorized_key=None):
        super(AuthorizedKeys, self).__init__(actions, total, active, )
        if authorized_key is None:
            self.authorized_key = []
        else:
            self.authorized_key = authorized_key
    def factory(*args_, **kwargs_):
        if AuthorizedKeys.subclass:
            return AuthorizedKeys.subclass(*args_, **kwargs_)
        else:
            return AuthorizedKeys(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_authorized_key(self): return self.authorized_key
    def set_authorized_key(self, authorized_key): self.authorized_key = authorized_key
    def add_authorized_key(self, value): self.authorized_key.append(value)
    def insert_authorized_key(self, index, value): self.authorized_key[index] = value
    def hasContent_(self):
        if (
            self.authorized_key or
            super(AuthorizedKeys, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AuthorizedKeys', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AuthorizedKeys')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AuthorizedKeys'):
        super(AuthorizedKeys, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AuthorizedKeys')
    def exportChildren(self, outfile, level, namespace_='', name_='AuthorizedKeys', fromsubclass_=False, pretty_print=True):
        super(AuthorizedKeys, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for authorized_key_ in self.authorized_key:
            authorized_key_.export(outfile, level, namespace_, name_='authorized_key', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='AuthorizedKeys'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AuthorizedKeys, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AuthorizedKeys, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('authorized_key=[\n')
        level += 1
        for authorized_key_ in self.authorized_key:
            showIndent(outfile, level)
            outfile.write('model_.authorized_key(\n')
            authorized_key_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(AuthorizedKeys, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'authorized_key':
            obj_ = AuthorizedKey.factory()
            obj_.build(child_)
            self.authorized_key.append(obj_)
        super(AuthorizedKeys, self).buildChildren(child_, node, nodeName_, True)
# end class AuthorizedKeys


class CloudInit(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, host=None, authorized_keys=None, network_configuration=None, regenerate_ssh_keys=None, timezone=None, users=None, files=None):
        self.host = host
        self.authorized_keys = authorized_keys
        self.network_configuration = network_configuration
        self.regenerate_ssh_keys = regenerate_ssh_keys
        self.timezone = timezone
        self.users = users
        self.files = files
    def factory(*args_, **kwargs_):
        if CloudInit.subclass:
            return CloudInit.subclass(*args_, **kwargs_)
        else:
            return CloudInit(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def get_authorized_keys(self): return self.authorized_keys
    def set_authorized_keys(self, authorized_keys): self.authorized_keys = authorized_keys
    def get_network_configuration(self): return self.network_configuration
    def set_network_configuration(self, network_configuration): self.network_configuration = network_configuration
    def get_regenerate_ssh_keys(self): return self.regenerate_ssh_keys
    def set_regenerate_ssh_keys(self, regenerate_ssh_keys): self.regenerate_ssh_keys = regenerate_ssh_keys
    def get_timezone(self): return self.timezone
    def set_timezone(self, timezone): self.timezone = timezone
    def get_users(self): return self.users
    def set_users(self, users): self.users = users
    def get_files(self): return self.files
    def set_files(self, files): self.files = files
    def hasContent_(self):
        if (
            self.host is not None or
            self.authorized_keys is not None or
            self.network_configuration is not None or
            self.regenerate_ssh_keys is not None or
            self.timezone is not None or
            self.users is not None or
            self.files is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CloudInit', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CloudInit')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CloudInit'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='CloudInit', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host', pretty_print=pretty_print)
        if self.authorized_keys is not None:
            self.authorized_keys.export(outfile, level, namespace_, name_='authorized_keys', pretty_print=pretty_print)
        if self.network_configuration is not None:
            self.network_configuration.export(outfile, level, namespace_, name_='network_configuration', pretty_print=pretty_print)
        if self.regenerate_ssh_keys is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sregenerate_ssh_keys>%s</%sregenerate_ssh_keys>%s' % (namespace_, self.gds_format_boolean(self.regenerate_ssh_keys, input_name='regenerate_ssh_keys'), namespace_, eol_))
        if self.timezone is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stimezone>%s</%stimezone>%s' % (namespace_, self.gds_format_string(quote_xml(self.timezone).encode(ExternalEncoding), input_name='timezone'), namespace_, eol_))
        if self.users is not None:
            self.users.export(outfile, level, namespace_, name_='users', pretty_print=pretty_print)
        if self.files is not None:
            self.files.export(outfile, level, namespace_, name_='files', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='CloudInit'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.host(\n')
            self.host.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.authorized_keys is not None:
            showIndent(outfile, level)
            outfile.write('authorized_keys=model_.authorized_keys(\n')
            self.authorized_keys.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.network_configuration is not None:
            showIndent(outfile, level)
            outfile.write('network_configuration=model_.network_configuration(\n')
            self.network_configuration.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.regenerate_ssh_keys is not None:
            showIndent(outfile, level)
            outfile.write('regenerate_ssh_keys=%s,\n' % self.regenerate_ssh_keys)
        if self.timezone is not None:
            showIndent(outfile, level)
            outfile.write('timezone=%s,\n' % quote_python(self.timezone).encode(ExternalEncoding))
        if self.users is not None:
            showIndent(outfile, level)
            outfile.write('users=model_.users(\n')
            self.users.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.files is not None:
            showIndent(outfile, level)
            outfile.write('files=model_.files(\n')
            self.files.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.host = obj_
        elif nodeName_ == 'authorized_keys':
            obj_ = AuthorizedKeys.factory()
            obj_.build(child_)
            self.authorized_keys = obj_
        elif nodeName_ == 'network_configuration':
            obj_ = NetworkConfiguration.factory()
            obj_.build(child_)
            self.network_configuration = obj_
        elif nodeName_ == 'regenerate_ssh_keys':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'regenerate_ssh_keys')
            self.regenerate_ssh_keys = ival_
        elif nodeName_ == 'timezone':
            timezone_ = child_.text
            timezone_ = self.gds_validate_string(timezone_, node, 'timezone')
            self.timezone = timezone_
        elif nodeName_ == 'users':
            obj_ = Users.factory()
            obj_.build(child_)
            self.users = obj_
        elif nodeName_ == 'files':
            obj_ = Files.factory()
            obj_.build(child_)
            self.files = obj_
# end class CloudInit


class NetworkConfiguration(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nics=None, dns=None):
        self.nics = nics
        self.dns = dns
    def factory(*args_, **kwargs_):
        if NetworkConfiguration.subclass:
            return NetworkConfiguration.subclass(*args_, **kwargs_)
        else:
            return NetworkConfiguration(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_nics(self): return self.nics
    def set_nics(self, nics): self.nics = nics
    def get_dns(self): return self.dns
    def set_dns(self, dns): self.dns = dns
    def hasContent_(self):
        if (
            self.nics is not None or
            self.dns is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NetworkConfiguration', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkConfiguration')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NetworkConfiguration'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='NetworkConfiguration', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.nics is not None:
            self.nics.export(outfile, level, namespace_, name_='nics', pretty_print=pretty_print)
        if self.dns is not None:
            self.dns.export(outfile, level, namespace_, name_='dns', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='NetworkConfiguration'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.nics is not None:
            showIndent(outfile, level)
            outfile.write('nics=model_.nics(\n')
            self.nics.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.dns is not None:
            showIndent(outfile, level)
            outfile.write('dns=model_.dns(\n')
            self.dns.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'nics':
            obj_ = Nics.factory()
            obj_.build(child_)
            self.nics = obj_
        elif nodeName_ == 'dns':
            obj_ = DNS.factory()
            obj_.build(child_)
            self.dns = obj_
# end class NetworkConfiguration


class VmPlacementPolicy(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, host=None, affinity=None):
        self.host = host
        self.affinity = affinity
    def factory(*args_, **kwargs_):
        if VmPlacementPolicy.subclass:
            return VmPlacementPolicy.subclass(*args_, **kwargs_)
        else:
            return VmPlacementPolicy(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def get_affinity(self): return self.affinity
    def set_affinity(self, affinity): self.affinity = affinity
    def hasContent_(self):
        if (
            self.host is not None or
            self.affinity is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VmPlacementPolicy', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmPlacementPolicy')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmPlacementPolicy'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VmPlacementPolicy', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.host is not None:
            self.host.export(outfile, level, namespace_, name_='host', pretty_print=pretty_print)
        if self.affinity is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saffinity>%s</%saffinity>%s' % (namespace_, self.gds_format_string(quote_xml(self.affinity).encode(ExternalEncoding), input_name='affinity'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='VmPlacementPolicy'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.host is not None:
            showIndent(outfile, level)
            outfile.write('host=model_.Host(\n')
            self.host.exportLiteral(outfile, level, name_='host')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.affinity is not None:
            showIndent(outfile, level)
            outfile.write('affinity=%s,\n' % quote_python(self.affinity).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'host':
            obj_ = Host.factory()
            obj_.build(child_)
            self.host = obj_
        elif nodeName_ == 'affinity':
            affinity_ = child_.text
            affinity_ = self.gds_validate_string(affinity_, node, 'affinity')
            self.affinity = affinity_
# end class VmPlacementPolicy


class GuestInfo(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ips=None, fqdn=None):
        self.ips = ips
        self.fqdn = fqdn
    def factory(*args_, **kwargs_):
        if GuestInfo.subclass:
            return GuestInfo.subclass(*args_, **kwargs_)
        else:
            return GuestInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ips(self): return self.ips
    def set_ips(self, ips): self.ips = ips
    def get_fqdn(self): return self.fqdn
    def set_fqdn(self, fqdn): self.fqdn = fqdn
    def hasContent_(self):
        if (
            self.ips is not None or
            self.fqdn is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GuestInfo', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GuestInfo')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GuestInfo'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='GuestInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ips is not None:
            self.ips.export(outfile, level, namespace_, name_='ips', pretty_print=pretty_print)
        if self.fqdn is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfqdn>%s</%sfqdn>%s' % (namespace_, self.gds_format_string(quote_xml(self.fqdn).encode(ExternalEncoding), input_name='fqdn'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='GuestInfo'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.ips is not None:
            showIndent(outfile, level)
            outfile.write('ips=model_.ips(\n')
            self.ips.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.fqdn is not None:
            showIndent(outfile, level)
            outfile.write('fqdn=%s,\n' % quote_python(self.fqdn).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ips':
            obj_ = IPs.factory()
            obj_.build(child_)
            self.ips = obj_
        elif nodeName_ == 'fqdn':
            fqdn_ = child_.text
            fqdn_ = self.gds_validate_string(fqdn_, node, 'fqdn')
            self.fqdn = fqdn_
# end class GuestInfo


class SerialNumber(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, policy=None, value=None):
        self.policy = policy
        self.value = value
    def factory(*args_, **kwargs_):
        if SerialNumber.subclass:
            return SerialNumber.subclass(*args_, **kwargs_)
        else:
            return SerialNumber(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_policy(self): return self.policy
    def set_policy(self, policy): self.policy = policy
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def hasContent_(self):
        if (
            self.policy is not None or
            self.value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SerialNumber', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SerialNumber')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SerialNumber'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='SerialNumber', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.policy is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spolicy>%s</%spolicy>%s' % (namespace_, self.gds_format_string(quote_xml(self.policy).encode(ExternalEncoding), input_name='policy'), namespace_, eol_))
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(self.value).encode(ExternalEncoding), input_name='value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='SerialNumber'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.policy is not None:
            showIndent(outfile, level)
            outfile.write('policy=%s,\n' % quote_python(self.policy).encode(ExternalEncoding))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'policy':
            policy_ = child_.text
            policy_ = self.gds_validate_string(policy_, node, 'policy')
            self.policy = policy_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
# end class SerialNumber


class VM(BaseResource):
    subclass = None
    superclass = BaseResource
    def __init__(self, actions=None, href=None, id=None, name=None, description=None, comment=None, creation_status=None, link=None, type_=None, status=None, stop_reason=None, memory=None, cpu=None, cpu_shares=None, bios=None, os=None, high_availability=None, display=None, host=None, cluster=None, template=None, instance_type=None, storage_domain=None, start_time=None, stop_time=None, creation_time=None, origin=None, stateless=None, delete_protected=None, sso=None, rng_device=None, console=None, timezone=None, domain=None, custom_properties=None, payloads=None, statistics=None, disks=None, initialization=None, nics=None, tags=None, snapshots=None, placement_policy=None, memory_policy=None, guest_info=None, quota=None, usb=None, tunnel_migration=None, migration_downtime=None, virtio_scsi=None, permissions=None, cpu_profile=None, vmpool=None, cdroms=None, floppies=None, reported_devices=None, watchdogs=None, use_latest_template_version=None, serial_number=None, next_run_configuration_exists=None, numa_tune_mode=None, extensiontype_=None):
        super(VM, self).__init__(actions, href, id, name, description, comment, creation_status, link, extensiontype_, )
        self.type_ = type_
        self.status = status
        self.stop_reason = stop_reason
        self.memory = memory
        self.cpu = cpu
        self.cpu_shares = cpu_shares
        self.bios = bios
        self.os = os
        self.high_availability = high_availability
        self.display = display
        self.host = host
        self.cluster = cluster
        self.template = template
        self.instance_type = instance_type
        self.storage_domain = storage_domain
        if isinstance(start_time, basestring):
            initvalue_ = datetime_.datetime.strptime(start_time, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = start_time
        self.start_time = initvalue_
        if isinstance(stop_time, basestring):
            initvalue_ = datetime_.datetime.strptime(stop_time, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = stop_time
        self.stop_time = initvalue_
        if isinstance(creation_time, basestring):
            initvalue_ = datetime_.datetime.strptime(creation_time, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = creation_time
        self.creation_time = initvalue_
        self.origin = origin
        self.stateless = stateless
        self.delete_protected = delete_protected
        self.sso = sso
        self.rng_device = rng_device
        self.console = console
        self.timezone = timezone
        self.domain = domain
        self.custom_properties = custom_properties
        self.payloads = payloads
        self.statistics = statistics
        self.disks = disks
        self.initialization = initialization
        self.nics = nics
        self.tags = tags
        self.snapshots = snapshots
        self.placement_policy = placement_policy
        self.memory_policy = memory_policy
        self.guest_info = guest_info
        self.quota = quota
        self.usb = usb
        self.tunnel_migration = tunnel_migration
        self.migration_downtime = migration_downtime
        self.virtio_scsi = virtio_scsi
        self.permissions = permissions
        self.cpu_profile = cpu_profile
        self.vmpool = vmpool
        self.cdroms = cdroms
        self.floppies = floppies
        self.reported_devices = reported_devices
        self.watchdogs = watchdogs
        self.use_latest_template_version = use_latest_template_version
        self.serial_number = serial_number
        self.next_run_configuration_exists = next_run_configuration_exists
        self.numa_tune_mode = numa_tune_mode
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if VM.subclass:
            return VM.subclass(*args_, **kwargs_)
        else:
            return VM(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_stop_reason(self): return self.stop_reason
    def set_stop_reason(self, stop_reason): self.stop_reason = stop_reason
    def get_memory(self): return self.memory
    def set_memory(self, memory): self.memory = memory
    def get_cpu(self): return self.cpu
    def set_cpu(self, cpu): self.cpu = cpu
    def get_cpu_shares(self): return self.cpu_shares
    def set_cpu_shares(self, cpu_shares): self.cpu_shares = cpu_shares
    def get_bios(self): return self.bios
    def set_bios(self, bios): self.bios = bios
    def get_os(self): return self.os
    def set_os(self, os): self.os = os
    def get_high_availability(self): return self.high_availability
    def set_high_availability(self, high_availability): self.high_availability = high_availability
    def get_display(self): return self.display
    def set_display(self, display): self.display = display
    def get_host(self): return self.host
    def set_host(self, host): self.host = host
    def get_cluster(self): return self.cluster
    def set_cluster(self, cluster): self.cluster = cluster
    def get_template(self): return self.template
    def set_template(self, template): self.template = template
    def get_instance_type(self): return self.instance_type
    def set_instance_type(self, instance_type): self.instance_type = instance_type
    def get_storage_domain(self): return self.storage_domain
    def set_storage_domain(self, storage_domain): self.storage_domain = storage_domain
    def get_start_time(self): return self.start_time
    def set_start_time(self, start_time): self.start_time = start_time
    def get_stop_time(self): return self.stop_time
    def set_stop_time(self, stop_time): self.stop_time = stop_time
    def get_creation_time(self): return self.creation_time
    def set_creation_time(self, creation_time): self.creation_time = creation_time
    def get_origin(self): return self.origin
    def set_origin(self, origin): self.origin = origin
    def get_stateless(self): return self.stateless
    def set_stateless(self, stateless): self.stateless = stateless
    def get_delete_protected(self): return self.delete_protected
    def set_delete_protected(self, delete_protected): self.delete_protected = delete_protected
    def get_sso(self): return self.sso
    def set_sso(self, sso): self.sso = sso
    def get_rng_device(self): return self.rng