#!python3
import flask
import gunicorn.app.base

from ownrepo.repositories import RepositoriesManager
from ownrepo.web import web
from ownrepo.utils import read_config, write_config


__version__ = "0.1b"


class GunicornApplication(gunicorn.app.base.BaseApplication):
    """ A gunicorn application running ownrepo """

    def __init__(self, storage, options=None):
        self.options = options if options is not None else {}
        self.app = create_app(storage)  # Crete a new OwnRepo application

        super(GunicornApplication, self).__init__()

    def load_config(self):
        # Do some cleanup to config items
        config = {key: value for key, value in self.options.items() if key
                  in self.cfg.settings and value is not None}

        for key, value in config.items():
            self.cfg.set(key.lower(), value)

    def load(self):
        return self.app


def create_app(storage):
    """ Create a new instance of ownrepo """
    app = flask.Flask(__name__, static_url_path='/+assets')
    app.url_map.strict_slashes = False
    app.ownrepo_storage = storage
    app.ownrepo_repos = RepositoriesManager(app)

    # Register blueprints
    app.register_blueprint(web)
    return app


def create_gunicorn_process(storage, options=None):
    """ Create a production-ready webserver object using gunicorn """
    if options is None:
        options = {'bind': '0.0.0.0', 'port': 80, 'workers': 3}

    app = GunicornApplication(storage, options)
    return app
