#!python3
import hashlib
import random
import string

import flask


def hash_password(users, name, password):
    """ Hash a password """
    salted = users['password_salt']+password+name
    return hashlib.sha512(salted.encode('utf-8')).hexdigest()


def random_salt():
    """ Generate a random salt """
    # Generate a random 32-chars salt
    salt = ''.join(random.SystemRandom().choice(string.printable)
                   for _ in range(32))
    return salt


def validate(users, name, password):
    """ Validate an username-password pair """
    # The user must exist
    if name not in users['users']:
        return False

    # Password must match
    current_password = users['users'][name]['password']
    if hash_password(users, name, password) != current_password:
        return False

    return True


def trigger_http_auth():
    """ Trigger an HTTP auth """
    return flask.Response(flask.render_template('login_failed.html'), 401,
                          {'WWW-Authenticate': 'Basic realm="Login Required"'})
