# shout/plugs/list.py
#
#

""" lists various stuff. """

## padje imports

from padje.generic import need_skip
from padje.utils import striphtml
from padje import cmnds, plugins

## basic imports

import logging
import time

## list command

def list(event):
    try: p, attrs = event.rest.split(" ", 1) ; attrs = attrs.split()
    except ValueError: p = event.rest ; attrs = []
    try: store = getattr(plugins.get(p), "store")
    except AttributeError: event.reply("no store available for %s" % event.rest) ; return
    c = 0
    objs = sorted(store.objects(), key=lambda x: x.estamp or x.ctime)
    for obj in objs:
        if need_skip(obj, black=["html",], white=["text",]): continue
        result = ""
        value = ""
        c += 1
        for attr in attrs:
            if attr == "nr": result += "%s " % str(c) ; continue
            try: value = striphtml(obj[attr])
            except KeyError: continue
            if value: result += " %s" % value
        if obj.txt: result += obj.txt
        if result: event.reply(result.strip())
    logging.warn("%s objects counted" % c)
 
cmnds.register("list", list)
