# padje/generic.py
#
#

"""generic functions """

## IMPORTS

import logging
import email

## GENERICS

def feed(text):
    from padje import Object
    result = []
    chunks = text.split("\r\n")
    for chunk in chunks:
        obj = Object().feed(chunk)
        result.append(obj)        
    return result

def dispatch(target, event, cmnd, *args, **kwargs):
    try: functions = target[cmnd]
    except KeyError: logging.debug("no %s found" % cmnd) ; return False
    for func in functions: func(event) 
    return event

def resolve(*args, **kwargs):
    from padje import dispatch, cmnds, tools, tests
    event = args[0]
    cmnd = event.cmnd or event.user_cmnd
    e = dispatch(event._target, event, cmnd, *args, **kwargs)
    if not e: e = dispatch(cmnds, event, cmnd, *args, **kwargs) 
    if not e: e = dispatch(tools, event, cmnd, *args, **kwargs)
    if not e: e = dispatch(tests, event, cmnd, *args, **kwargs)
    return e

def format(*args, **kwargs):
    keys = args[0]
    result = ""   
    for key in keys:
       try: result += "%s - " % item[key]
       except KeyError: continue
    return result[:-3]

def need_skip(obj, attr="Content-Type", black=[], white=[]):
    needskip = False
    try: value = obj[attr]
    except KeyError: return needskip
    for w in white:
        if w not in value: needskip = True
    for b in black:
        if b in value: needskip = True
    return needskip
