# padje/plugs/mail.py
#
#

""" slurp and send. """

## IMPORTS

from padje.utils import striphtml, j, error
from padje import cmnds, Object

import email.message
import datetime
import logging
import email
import time
import os

## HELPERS

def emailstamp(input):
    instring = " ".join(input.strip().split()[:-1])
    ttime = time.strptime(instring, "%a, %d %b %Y %H:%M:%S")
    return time.mktime(ttime)  

def emailtime(input):
    instring = " ".join(input.strip().split()[:-1])
    stamp = time.strptime(instring, "%a, %d %b %Y %H:%M:%S")
    dd = datetime.datetime.fromtimestamp(time.mktime(stamp))
    return str(dd).replace(" ", os.sep)

def need_skip(obj):
    whitelist = ["text",]
    blacklist = ["html",]
    nogo = False
    try: ctype = obj["Content-Type"]
    except KeyError: nogo = False
    for white in whitelist:
        if white not in ctype: nogo = True
    for black in blacklist:
        if black in ctype: nogo = True
    return nogo

## CLASSES

class Email(Object):

    def get_attr(self, attr):
        for line in self.text.splitlines():
            try: key, val = line.split(":", 1)
            except ValueError: continue
            if key.lower() == attr.lower(): return val

## VARIABLES

store = Email()

## COMMANDS

def slurp(event):
    if not event.rest: event.reply("what directory?") ; return
    target = event.rest
    if not os.path.isdir(target): event.reply("%s is not a directory." % target) ; return
    teller = 0
    event.reply("scanning %s" % target)
    for fn in os.listdir(target):
        ff = target + os.sep + fn 
        logging.warn("reading %s" % ff)
        try: data = open(ff, "r").read()
        except IsADirectoryError: continue
        except: error() ; continue
        e = Email()
        message = email.message_from_string(data)
        e.update(message.items())
        e.text = ""
        for load in message.get_payload()[1:]: e.text += str(load)
        try:  e.sdate = emailtime(e.Date) ; e.estamp = emailstamp(e.Date)
        except ValueError as ex: logging.warn("date missed %s" % ex) ; continue
        if e.sdate:  e.save(e.sdate)
        else: e.save(j("nodate", e.get_stamp()))
        logging.warn("saved at %s" % e.sdate)
        teller += 1
    event.reply("%s emails slurped." % teller)

cmnds.register("slurp", slurp)
