# padje/utils.py
#
#

""" utils package. """

## IMPORT

from padje.defines import *
from padje import __version__

import traceback
import datetime
import optparse
import hashlib
import logging
import string
import time
import sys
import os
import re

## OPTIONS

def make_opts():
    parser = optparse.OptionParser(usage='usage: %prog [options]', version=__version__)
    for option in options:
        type, default, dest, help = option[2:]
        if "store" in type:
            try: parser.add_option(option[0], option[1], action=type, default=default, dest=dest, help=help)
            except Exception as ex: logging.error("error: %s - option: %s" % (str(ex), option)) ; continue
        else:
            try: parser.add_option(option[0], option[1], type=type, default=default, dest=dest, help=help)
            except Exception as ex: logging.error("error: %s - option: %s" % (str(ex), option)) ; continue
    return parser.parse_args()

## SIGNATURES

def make_signature(data): return str(hashlib.sha1(bytes(str(data), "utf-8")).hexdigest())

## ERRORS

def error(*args, **kwargs):
    msg = exceptionmsg()
    logging.error("error detected:\n\n%s\n" % msg)
    return msg

def exceptionmsg(*args, **kwargs):
    exctype, excvalue, tb = sys.exc_info()
    trace = traceback.extract_tb(tb)
    result = ""
    for i in trace:
        fname = i[0]
        linenr = i[1]
        func = i[2]  
        plugfile = fname[:-3].split(os.sep)
        mod = []
        for i in plugfile[::-1]: mod.append(i)
        ownname = '.'.join(mod[::-1])
        result += "%s:%s %s | " % (ownname, linenr, func)
    del trace
    return "%s%s: %s" % (result, exctype, excvalue)

## JOINS

def j(*args):
     if not args: return
     todo = list(map(str, filter(None, args)))
     return os.path.join(*todo)

def mj(*args):
     if not args: return
     todo = list(map(str, filter(None, args)))
     return os.path.join(*todo).replace(os.sep, ".")

def dj(*args):
     if not args: return
     todo = list(map(str, filter(None, args)))
     return os.path.join(*todo).replace(os.sep, "-")

def aj(sep=None, *args): return os.path.abspath(*j(sep, *args))


## RESOLVING

def resolve_ip(hostname=None, timeout=1.0):
    oldtimeout = socket.getdefaulttimeout()
    socket.setdefaulttimeout(timeout)
    try: ip = socket.gethostbyname(hostname or socket.gethostname())
    except socket.timeout: ip = None
    socket.setdefaulttimeout(oldtimeout)
    return ip

def resolve_host(ip=None, timeout=1.0):
    """ determine the ip address we are running on, we use this for creatin an id. """
    oldtimeout = socket.getdefaulttimeout()
    socket.setdefaulttimeout(timeout)
    try: host = socket.gethostbyaddr(ip or resolve_ip())[0]
    except socket.timeout: host = None
    socket.setdefaulttimeout(oldtimeout)
    return host

## DIRECTORIES

def touch(fname):
    try: fd = os.open(fname, os.O_RDONLY | os.O_CREAT) ; os.close(fd)
    except: error()

def check_permissions(ddir, dirmask=dirmask, filemask=filemask):
    uid = os.getuid()
    gid = os.getgid()
    try: stat = os.stat(ddir)
    except OSError: make_dir(ddir) ; stat = os.stat(ddir) 
    if stat.st_uid != uid: os.chown(ddir, uid, gid)
    if os.path.isfile(ddir): mask = filemask
    else: mask = dirmask
    if stat.st_mode != mask: os.chmod(ddir, mask)

def make_dir(path):
    target = os.sep
    for item in path.split(target)[:-1]:
        target = j(target, item)
        try: os.mkdir(target)
        except OSError as ex: logging.debug(ex) ; continue
        check_permissions(target)
    return path

## STACK

def dump_frame(search="code"):
    result = {}
    frame = sys._getframe(1)
    search = str(search)
    for i in dir(frame):
        if search in i:
            target = getattr(frame, i)
            for j in dir(target):
                result[j] = getattr(target, j)
    return result

def called_from(level=2):
    result = ""  
    loopframe = sys._getframe(level)
    if not loopframe: return result
    marker = ""
    pre = "padje"
    while 1:
        try: back = loopframe.f_back
        except AttributeError: break
        if not back: break
        filename = back.f_code.co_filename
        if "plugs" in filename: result = filename.split(os.sep)[-1][:-3] ; pre = "plugs" ; break
        loopframe = back
    del loopframe   
    if result: return "%s.%s" % (pre, result)

## LOCATING

def get_source(mod):
    if not os.getcwd() in sys.path: sys.path.insert(0, os.getcwd())
    source = None
    splitted = mod.split(".")
    if len(splitted) == 1: splitted.append("")
    thedir, file = os.path.split(mod.replace(".", os.sep))
    if os.path.isdir(thedir): source = thedir
    if source and os.path.exists(source): logging.info("source is %s" % source) ; return source
    if not source:
        try: import pkg_resources
        except (ImportError, ValueError): import wtf.contrib.pkg_resources
        source = p.resource_filename()
    logging.info("source is %s" % source)
    return source

## HELPERS

def stripbadchar(s): return "".join([c for c in s if ord(c) > 31 or c in allowedchars])

def enc_char(s):
    result = []
    for c in s:
        if c in allowedchars: result.append(c)
        else: result.append(enc_name(c))
    return "".join(result)

def enc_needed(s): return [c for c in s if c not in allowedchars]

def enc_name(input): return str(base64.urlsafe_b64encode(bytes(input, "utf-8")), "utf-8")

def split_txt(what, l=375):
    txtlist = []
    start = 0
    end = l
    length = len(what)
    for i in range(int(length/end+1)):
        starttag = what.find("</", end)
        if starttag != -1: endword = what.find('>', end) + 1
        else:
            endword = what.find(' ', end)
            if endword == -1: endword = length
        res = what[start:endword]
        if res: txtlist.append(res)
        start = endword
        end = start + l
    return txtlist

def striphtml(text):
    from bs4 import BeautifulSoup
    text = str(text)
    txt = text.replace("\r\n", "")
    txt = txt.replace("\n", "")
    soup = BeautifulSoup(txt)
    text_nodes = soup.findAll(text=True)
    return ' '.join(text_nodes)

def smooth(a):
    if type(a) not in basic_types: return get_cls(a)
    else: return a

def make_version(name=""): return "%s%s #%s -=- ! %s%s" % (YELLOW, name, __version__, time.ctime(time.time()), ENDC)

def hello(name=""): print(make_version(name) + "\n")

def parse_options(input):
    from padje import Object
    options = Object()
    options.args = []
    opts = input.split()
    for opt in opts:
        try: name, value = opt.split("=") ; options[name] = value
        except: options.args.append(opt)
    return options

def list_eggs(filter=""):
    for f in sys.path:
        if ".egg" in f and filter not in f: yield f

def show_eggs(filter="padje"):
    for egg in list_eggs(filter): logging.warn("%s egg: %s" % (filter, egg))

def stripped(input):
    try: return input.split("/")[0]
    except: return input

def get_clsname(obj):
    name = str(obj.__class__)
    return name.split(" ")[1][1:-2]

def get_cls(obj):
    return get_clsname(obj).split(".")[-1]

## TIME

def dtime(stamp): return datetime.datetime.fromtimestamp(stamp)
def ptime(daystr): return datetime.datetime.strptime(daystr or "1984-01-01", '%Y-%m-%d')
def tdiff(d1, d2): return datetime.timedelta(d1, d2)

def hms(): return str(datetime.datetime.today()).split()[1].split(".")[0]
def day(): return str(datetime.datetime.today()).split()[0]

## HEADER

headertxt = '''# %s
#
# this is an padje (#%s) file, %s
#
# this file can be edited !!

'''

## LOOP

def mainloop():
    while 1:
        try: time.sleep(1)
        except KeyboardInterrupt: break
        except Exception: error() ; break

## INPUT

def feed(text):
    from padje import Object
    result = []
    chunks = text.split("\r\n")
    for chunk in chunks:
        obj = Object().feed(chunk)
        result.append(obj)
    return result
