# shout/plugs/list.py
#
#

""" lists various stuff. """

## padje imports

from padje.generic import need_skip
from padje.utils import striphtml, ptime, dtime, tdiff
from padje import cmnds, plugins

## basic imports

import datetime
import logging
import time

## list command

def list(event):
    try: p, attrs = event.rest.split(" ", 1) ; attrs = attrs.split()
    except ValueError: p = event.rest ; attrs = []
    try: store = getattr(plugins.get(p), "store")
    except AttributeError: event.reply("no store available for %s" % event.rest) ; return
    c = 0
    opts = event.options
    objs = sorted(store.objects(), key=lambda o: o.estamp)
    for obj in objs:
        if need_skip(obj, black=["html",], white=["text",]): continue
        fr = ptime(opts.fr or "1984-01-01")
        to = ptime(opts.to or "2013-12-30")
        if obj.estamp:
            if obj.estamp < fr.timestamp(): continue
            if obj.estamp > to.timestamp(): continue
        result = ""
        value = ""
        c += 1
        for attr in attrs:
            if attr == "nr": result += "%s - " % str(c) ; continue
            if attr == "days": result += "%s - " % datetime.timedelta(-1, time.time() - obj.estamp) ; continue
            try:
                if attr == "txt": value = striphtml(obj[attr])
                else: value = obj[attr]
            except KeyError: continue
            if value: result += "%s - " % value
        if result: result = result[:-3]
        if obj.txt: result += obj.txt
        if result: event.reply(result.strip())
    logging.warn("%s objects counted" % c)
    logging.warn("used options: %s" % opts)
 
cmnds.register("list", list)
