# padje/drivers.py
#
#

""" drivers package. """

from padje import NoSuchBotType
from padje.drivers.xmpp import XMPPBot
from padje.drivers.irc import IRCBot
from padje.drivers.line import CLIBot

## get_bot factory function

def get_bot(type, config):
    if type == "IRC": return IRCBot(**config)
    elif type == "XMPP": return XMPPBot(**config)
    elif type == "CLI": return cLIBot(**config)
    else: raise NoSuchBotType(type)
