# padje/defines.py
#
#

""" defines. """

## IMPORTS

import string
import re

## CONSTANTS

basic_types= [ str, int, float, bool, None]

attributes = {}
subelements = {}

attributes['message'] = ['type', 'from', 'to', 'id']
subelements['message'] = ['subject', 'body', 'error', 'thread', 'x']

attributes['presence'] = ['type', 'from', 'to', 'id']
subelements['presence'] = ['show', 'status', 'priority', 'x']


attributes['iq'] = ['type', 'from', 'to', 'id']
subelements['iq'] = ['query', 'error']

## DEFINITIONS

timere = re.compile('(\S+)\s+(\S+)\s+(\d+)\s+(\d+):(\d+):(\d+)\s+(\d+)')
bdmonths = ['Bo', 'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']

dirmask = 0o700 
filemask = 0o600
allowedchars = string.ascii_letters + string.digits + "_,-. \n" + string.punctuation

options = [
              ('-s', '--shell', 'store_true', False, 'doshell',  "enable shell prompting"),
              ('-a', '--api', 'store_true', False, 'api',  "enable api server"),
              ('-t', '--test', 'store_true', False, 'do_test',  "enable test mode"),
              ('', '--local', 'store_true', False, 'do_local',  "use local directory as the working directory"),
              ('', '--apiport', 'string', "", 'apiport', "port on which the api server will run"),
              ('-d', '--dir', 'string', "", 'workdir',  "directory to work with"),
              ('-l', '--loglevel', 'string', "", 'loglevel',  "loglevel"),
              ('-c', '--channel', 'string', "", 'channel',  "channel"),
          ]   

## COLORS

ERASE_LINE = '\033[2K'
BOLD='\033[1m'     
RED = '\033[91m'   
YELLOW = '\033[93m'
GREEN = '\033[92m' 
BLUE = '\033[94m'
BLA = '\033[95m'
ENDC = '\033[0m'
