#!/usr/bin/python

import sys, os, socket, threading, getpass, logging, time, base64, select, termios, tty
import secsh


#####   utility functions

def load_host_keys():
    filename = os.environ['HOME'] + '/.ssh/known_hosts'
    keys = {}
    try:
        f = open(filename, 'r')
    except Exception, e:
        print '*** Unable to open host keys file (%s)' % filename
        return
    for line in f:
        hostlist, keytype, key = line.split(' ')
        hosts = hostlist.split(',')
        for host in hosts:
            if not keys.has_key(host):
                keys[host] = {}
            keys[host][keytype] = base64.decodestring(key)
    f.close()
    return keys


#####   main demo

# setup logging
l = logging.getLogger("secsh")
l.setLevel(logging.DEBUG)
if len(l.handlers) == 0:
    f = open('demo.log', 'w')
    lh = logging.StreamHandler(f)
    lh.setFormatter(logging.Formatter('%(levelname)-.3s [%(asctime)s] %(name)s: %(message)s', '%Y%m%d:%H%M%S'))
    l.addHandler(lh)

username = ''
if len(sys.argv) > 1:
    hostname = sys.argv[1]
    if hostname.find('@') >= 0:
        username, hostname = hostname.split('@')
else:
    hostname = raw_input('Hostname: ')
if len(hostname) == 0:
    print '*** Hostname required.'
    sys.exit(1)

# now connect
try:
    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    sock.connect((hostname, 22))
except Exception, e:
    print '*** Connect failed: ' + str(e)
    sys.exit(1)

try:
    event = threading.Event()
    t = secsh.Transport(sock, event)
    # print repr(t)
    event.wait(10)
    if not t.is_active():
        print '*** SSH negoatiation failed.'
        sys.exit(1)
    # print repr(t)

    keys = load_host_keys()
    keytype, hostkey = t.get_host_key()
    if not keys.has_key(hostname):
        print '*** WARNING: Unknown host key!'
    elif not keys[hostname].has_key(keytype):
        print '*** WARNING: Unknown host key!'
    elif keys[hostname][keytype] != hostkey:
        print '*** WARNING: Host key has changed!!!'
        sys.exit(1)
    else:
        print '*** Host key OK.'

    event.clear()

    # get username
    if username == '':
        default_username = getpass.getuser()
        username = raw_input('Username [%s]: ' % default_username)
        if len(username) == 0:
            username = default_username

    # ask for what kind of authentication to try
    default_auth = 'p'
    auth = raw_input('Auth by (p)assword, (r)sa key, or (d)ss key? [%s] ' % default_auth)
    if len(auth) == 0:
        auth = default_auth

    if auth == 'r':
        key = secsh.RSAKey()
        default_path = os.environ['HOME'] + '/.ssh/id_rsa'
        path = raw_input('RSA key [%s]: ' % default_path)
        if len(path) == 0:
            path = default_path
        key.read_private_key_file(path)
        t.auth_key(username, key, event)
    elif auth == 'd':
        key = secsh.DSSKey()
        default_path = os.environ['HOME'] + '/.ssh/id_dsa'
        path = raw_input('DSS key [%s]: ' % default_path)
        if len(path) == 0:
            path = default_path
        key.read_private_key_file(path)
        t.auth_key(username, key, event)
    else:
        pw = getpass.getpass('Password for %s@%s: ' % (username, hostname))
        t.auth_password(username, pw, event)

    event.wait(10)
    # print repr(t)
    if not t.is_authenticated():
        print '*** Authentication failed. :('
        t.close()
        sys.exit(1)

    chan = t.open_session()
    chan.get_pty()
    chan.invoke_shell()
    print '*** Here we go!'
    print

    try:
        oldtty = termios.tcgetattr(sys.stdin)
        tty.setraw(sys.stdin.fileno())
        tty.setcbreak(sys.stdin.fileno())
        chan.settimeout(0.0)

        while 1:
            r, w, e = select.select([chan, sys.stdin], [], [])
            if chan in r:
                try:
                    x = chan.recv(1024)
                    if len(x) == 0:
                        print
                        print '*** EOF'
                        break
                    sys.stdout.write(x)
                    sys.stdout.flush()
                except socket.timeout:
                    pass
            if sys.stdin in r:
                # FIXME: reading 1 byte at a time is incredibly dumb.
                x = sys.stdin.read(1)
                if len(x) == 0:
                    print
                    print '*** Bye.'
                    break
                chan.send(x)

    finally:
        termios.tcsetattr(sys.stdin, termios.TCSADRAIN, oldtty)

    chan.close()
    t.close()

except Exception, e:
    print '*** Caught exception: ' + str(e)
    try:
        t.close()
    except:
        pass
    sys.exit(1)

