#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import
import parma

from setuptools import setup, find_packages


setup(
    name='parma',
    version=parma.__version__,
    description="A wrapper for Orchard's fig commandline.",
    long_description=open('README.rst').read(),
    url='https://github.com/snowball-digital/parma',
    license=parma.__license__,
    author=parma.__author__,
    author_email="sebastian@roadsi.de",
    packages=find_packages(exclude=['tests']),
    install_requires=['click', 'fig'],
    include_package_data=True,
    entry_points={'console_scripts': ['parma = parma.cli:cli']},
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        'Topic :: Software Development :: Build Tools',
    ],
)
