# -*- coding: utf-8 -*-

from setuptools import setup
from codecs import open
from os import path


here = path.abspath(path.dirname(__file__))

with open(path.join(here, 'README.rst'), encoding='utf-8') as f:
    long_description = f.read()


setup(
    name='parsers',
    version='0.1.0.a1',
    description='Support multiple parsers with ease.',
    long_description=long_description,
    url='https://github.com/redodo/parsers',
    author='Hidde Bultsma',
    author_email='dodo@gododo.co',
    license='MIT',
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.2',
        'Programming Language :: Python :: 3.3',
        'Programming Language :: Python :: 3.4',
    ],
    keywords='parse, parsing, json, xml, yaml, bunch',
    py_modules=['parsers'],
    install_requires=[
        'lunch',
    ],
)
