from setuptools import setup, find_packages
import os 
from pip.req import parse_requirements

# hack for working with pandocs
import codecs 
try: 
  codecs.lookup('mbcs') 
except LookupError: 
  utf8 = codecs.lookup('utf-8') 
  func = lambda name, enc=utf8: {True: enc}.get(name=='mbcs') 
  codecs.register(func) 

# install readme
readme = os.path.join(os.path.dirname(__file__), 'README.md')

try:
  import pypandoc
  long_description = pypandoc.convert(readme, 'rst', format="md")
except (IOError, ImportError):
  long_description = ""

# parse requirements file
#required = [str(ir.req) for ir in parse_requirements("requirements.txt")]

# setup
setup(
  name='particle',
  version='0.0.4',
  description='Multi-method Article Extraction',
  long_description = long_description,
  classifiers=[
    "Development Status :: 3 - Alpha",
    "Intended Audience :: Developers",
    "License :: OSI Approved :: MIT License",
    "Operating System :: OS Independent",
    "Programming Language :: Python",
    ],
  keywords='',
  author='Brian Abelson',
  author_email='brian@newslynx.org',
  url='http://github.com/newslynx/particle',
  license='MIT',
  packages=find_packages(exclude=['ez_setup', 'examples', 'tests']),
  namespace_packages=[],
  include_package_data=False,
  zip_safe=False,
  install_requires=[
    "goose-extractor==1.0.17",
    "siegfried>=0.0.7",
    "lauteur>=0.0.5",
    "requests==2.3.0",
    "beautifulsoup4==4.3.2",
    "newspaper==0.0.6"
  ],
  tests_require=[]
)