from setuptools import setup

setup(name='passport',
      version='0.1.0',
      description="Light-weight configuration management using Consul",
      maintainer="Gavin M. Roy",
      maintainer_email="gavinmroy@gmail.com",
      url="https://github.com/gmr/passport",
      install_requires=['consulate', 'tornado'],
      license=open('LICENSE').read(),
      package_data={'': ['LICENSE', 'README.md']},
      py_modules=['passport'],
      entry_points=dict(console_scripts=['passport=passport:main']),
      classifiers=['Development Status :: 3 - Alpha',
                   'Intended Audience :: Developers',
                   'License :: OSI Approved :: BSD License',
                   'Operating System :: OS Independent',
                   'Programming Language :: Python :: 2',
                   'Programming Language :: Python :: 2.6',
                   'Programming Language :: Python :: 2.7',
                   'Programming Language :: Python :: 3',
                   'Programming Language :: Python :: 3.2',
                   'Programming Language :: Python :: 3.3',
                   'Programming Language :: Python :: 3.4',
                   'Programming Language :: Python :: Implementation :: CPython',
                   'Programming Language :: Python :: Implementation :: PyPy',
                   'Topic :: Database',
                   'Topic :: Software Development :: Libraries'],
      zip_safe=True)
