from pequod_cli.auth import AuthService
from pequod_cli.controller import ClusterController
from pequod_cli.manager import CoreManager
from pequod_cli.registry import ApplicationRegistry


class Context:
    def __init__(self, config_file, cluster, core_seeds, credentials):
        self.config_file = config_file
        self.cluster = cluster
        self.core_seeds = core_seeds

        self.auth = AuthService(core_seeds, credentials)
        self.manager = CoreManager(core_seeds, credentials)
        self.registry = ApplicationRegistry(core_seeds, credentials)
        self.controller = ClusterController(core_seeds, credentials)

        self.all_core_services = [self.auth, self.manager, self.registry, self.controller]