import requests
from pequod_cli.service import CoreService


class ApplicationRegistry(CoreService):
    def __init__(self, endpoints, credentials, cacert):
        super().__init__(endpoints, 'application-registry', credentials, cacert)

    def get_manifest(self, repository_name, application_name, application_version):
        try:
            data = self.get('/manifests/{}/{}/{}'.format(repository_name, application_name, application_version))
        except requests.HTTPError as e:
            if e.response.status_code == 404:
                return None
        return data