import click
from pequod_cli.console import print_table, print_permissions
from pequod_cli.utils import AliasedGroup


@click.group(cls=AliasedGroup)
def replicator():
    """
    Interact with File Replicator
    """
    pass


@replicator.command()
@click.pass_obj
def trackers(ctx):
    """
    List all torrent trackers
    """
    data = ctx.replicator.get('/trackers')

    COLS = 'url'.split()
    rows = []
    for tier in data['tiers']:
        for tracker in tier['trackers']:
            rows.append({'url': tracker})

    print_table(COLS, rows)


@replicator.command()
@click.pass_obj
def permissions(ctx):
    """
    List all permissions
    """
    print_permissions(ctx.replicator.permissions())