from pequod_cli.service import CoreService


class CoreManager(CoreService):
    def __init__(self, endpoints, credentials, cacert):
        super().__init__(endpoints, 'core-manager', credentials, cacert)

    def get_zones(self):
        data = self.get('/zones')
        return dict([(row['name'], row) for row in data['zones']])

    def get_templates(self):
        data = self.get('/templates')
        return data['templates']

    def get_vaults(self):
        data = self.get('/vaults')
        return data['vaults']
