import collections
import click

ApplicationVersion = collections.namedtuple('ApplicationVersion',
                                            'repository_name application_name application_version')


def parse_application_spec(spec):
    try:
        repo, app = spec.split('/')
        app, version = app.split(':')
    except:
        raise click.UsageError('Invalid application spec, must be <repo>/<app>:<version>')
    return ApplicationVersion(repository_name=repo, application_name=app, application_version=version)


class ApplicationSpec(click.ParamType):
    name = 'ApplicationSpec'

    def convert(self, value, param, ctx):
        if isinstance(value, ApplicationVersion):
            return value
        return parse_application_spec(value)
