import click
from pequod_cli.console import print_table
from pequod_cli.utils import AliasedGroup


@click.command(cls=AliasedGroup)
def auth():
    """
    Interact with Auth Service
    """
    pass


@auth.command()
@click.argument('username', required=False)
@click.pass_obj
def authorize(ctx, username):
    """
    List user's permissions
    """
    if not username:
        username = ctx.auth.credentials['username']
    data = ctx.auth.get('/authorize/{}'.format(username))
    permissions = data['permissions']
    rows = [{'permission': p} for p in permissions]
    print_table(['permission'], rows)
