import click
from pequod_cli.console import print_table, print_permissions, action, ok
from pequod_cli.utils import AliasedGroup


@click.group(cls=AliasedGroup)
def replicator():
    """
    Interact with File Replicator
    """
    pass


@replicator.command()
@click.pass_obj
def trackers(ctx):
    """
    List all torrent trackers
    """
    data = ctx.replicator.get('/trackers')

    COLS = 'url'.split()
    rows = []
    for tier in data['tiers']:
        for tracker in tier['trackers']:
            rows.append({'url': tracker})

    print_table(COLS, rows)


@replicator.group(cls=AliasedGroup)
@click.pass_obj
def torrents(ctx):
    """
    Manage torrents
    """
    pass


@torrents.command()
@click.argument("repository_name")
@click.pass_obj
def list(ctx, repository_name):
    """
    List all torrents in a certain repository
    """
    data = ctx.replicator.get('/torrents/{}'.format(repository_name))
    cols = 'repository_name torrent_name archived'.split()
    rows = []
    for torrent in data['torrents']:
        rows.append(torrent)
    print_table(cols, rows)


@torrents.command()
@click.argument("repository_name")
@click.argument("torrent_name")
@click.pass_obj
def archive(ctx, repository_name, torrent_name):
    """
    List all torrents in a certain repository
    """
    action('Archiving {repository_name}/{torrent_name}..', **vars())
    ctx.replicator.delete('/torrents/{}/{}'.format(repository_name, torrent_name))
    ok()


@replicator.command()
@click.pass_obj
def permissions(ctx):
    """
    List all permissions
    """
    print_permissions(ctx.replicator.permissions())