from pequod_cli.auth import AuthService
from pequod_cli.controller import ClusterController
from pequod_cli.manager import CoreManager
from pequod_cli.registry import ApplicationRegistry
from pequod_cli.replicator import FileReplicator


class Context:
    def __init__(self, config_file, cluster, endpoints: dict, credentials):
        self.config_file = config_file
        self.cluster = cluster
        self.endpoints = endpoints

        self.auth = AuthService(endpoints, credentials)
        self.replicator = FileReplicator(endpoints, credentials)
        self.manager = CoreManager(endpoints, credentials)
        self.registry = ApplicationRegistry(endpoints, credentials)
        self.controller = ClusterController(endpoints, credentials)

        self.all_core_services = [self.auth, self.replicator, self.manager, self.registry, self.controller]