#!/usr/bin/python
# -*- coding: utf8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-

"""Globals and function needs for this project.

.. module:: utils
    :platform: Unix
    :synopsis: This module contains all useful globals and function needed.

.. moduleauthor:: Pierre Leray <pierreleray64@gmail.com>

"""

import argparse
import logging
from datetime import datetime

# Globals declaration for this project
CURRENTCOST = "currentcost"
TIMESERIES = "timeseries"
ERROR = "error"
TOPICS = (CURRENTCOST, ERROR)
TTY_CONNECTION_PROBLEM = "CurrentCost %s in %s: TTY connection problem: %s \
is unreachable. Retry connection in 5 seconds."
TTY_TRYING_CONNECTION = "CurrentCost %s in %s: Trying to connect to %s."
TTY_CONNECTION_SUCCESS = "CurrentCost %s in %s: Success connection to %s."
TTY_DISCONNECTED = "CurrentCost %s in %s: TTY port %s disconnected."
CURRENTCOST_TIMEOUT = "CurrentCost %s in %s: Reach timeout. Verify \
CurrentCost wire connection or wave range"
CC_INCORRECT_MESSAGE = "CurrentCost %s in %s: Send incorrect \
message => %s."
RABBIT_MQ_CONNECTION_PROBLEM = "Problem trying to connect to RabbitMQ with \
this configuration: username: %s, password: %s, host: %s"
RABBIT_MQ_CREDENTIAL_PROBLEM = "Problem bad RabbitMQ credential with \
this configuration: username: %s, password: %s, host: %s"
CURRENTCOST_UNICODE_ERROR = "Bad message sent from currentcost, invalid ASCII"
INCORRECT_MESSAGE = "Receive incorrect message => %s"
MISSING_SITE_ID = "missing siteID in %s"
MISSING_VARIABLE_ID = "missing deviceID in %s"
MISSING_MESSAGE = "missing message in %s"
MISSING_DATE = "missing date in %s"
MISSING_DST_TIMEZONE = "missing dstTimezone in %s"
MISSING_NON_DST_TIMEZONE = "missing nonDstTimezone in %s"
INCORRECT_XML_MESSAGE = "Incorrect XML message => %s"
INCORRECT_CURRENTCOST_MISSING_TMPR = "Missing currentcost temperature value\
 in %s"
INCORRECT_CURRENTCOST_MISSING_WATTS = "Missing currentcost watts value in %s"
# Logger initialization
LOGGER = logging.getLogger("messager")


def argument_parser():
    """Method that parse arguments from command line, return an error in
    case of missing parameter or return arguments with their value.

    :returns:  dict -- Dict containing arguments.

    """
    # Get command line arguments
    parser = argparse.ArgumentParser()
    # Define expected arguments
    parser.add_argument("rabbitmq_credential",
                        help="credential for rabbitMQ. \
                        Format: username:password.")
    parser.add_argument("-l", "--log-conf", help="path to log configuration")
    parser.add_argument("-v", "--verbose", help="activate verbose mode",
                        action="store_true")
    # Return list of argument passed in command line
    return parser.parse_args()


def init_message(log_conf):
    """Create log message starting current cost.

    :param log_conf: Path to log configuration.
    :type log_conf: str.
    """
    # Create init message
    message = "Starting timeserieslogger application\n"
    message += "Current time: %s\n" % datetime.now()
    message += "Log configuration: %s\n" % log_conf
    # We log this message
    LOGGER.info(message)


def verbose_mode(verbose):
    """Active verbose mode.

    :param verbose: Boolean if true active verbose mode.
    :type variable_name: bool.

    """
    # If verbose mode is activated
    if verbose:
        # Create an handler to console and display log message
        sth = logging.StreamHandler()
        sth.setLevel(logging.INFO)
        # Add this handler to current logger
        LOGGER.addHandler(sth)
