#!/usr/bin/python
# -*- coding: utf8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-

""" Setup.py script """

from setuptools import setup

VERSION = "0.3.6"

INSTALL_REQS = ["pika"]

PROJECT = "phase"

PLUGIN = "messager"


setup(
    name="%s.%s" % (PROJECT, PLUGIN),
    version=VERSION,
    description="Python module to exchange message over RabbitMQ",
    long_description=open('README.rst').read(),
    author="Pierre Leray",
    author_email="pierreleray64@gmail.com",
    url="https://github.com/liogen/%s.%s" % (PROJECT, PLUGIN),
    license="MIT",
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Environment :: Console",
        "Intended Audience :: Developers",
        "Intended Audience :: Education",
        "Intended Audience :: Information Technology",
        "Intended Audience :: Science/Research",
        "Operating System :: Unix",
        "Programming Language :: Python :: 2.7",
        "Topic :: Home Automation",
        "License :: OSI Approved :: MIT License",
    ],
    packages=[PLUGIN],
    install_requires=INSTALL_REQS,
    zip_safe=False,
)
